/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelService.CopyModel][google.cloud.aiplatform.v1beta1.ModelService.CopyModel].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.CopyModelRequest}
 */
public final class CopyModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.CopyModelRequest)
    CopyModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CopyModelRequest.newBuilder() to construct.
  private CopyModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CopyModelRequest() {
    parent_ = "";
    sourceModel_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CopyModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_CopyModelRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_CopyModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.CopyModelRequest.class,
            com.google.cloud.aiplatform.v1beta1.CopyModelRequest.Builder.class);
  }

  private int bitField0_;
  private int destinationModelCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destinationModel_;

  public enum DestinationModelCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MODEL_ID(4),
    PARENT_MODEL(5),
    DESTINATIONMODEL_NOT_SET(0);
    private final int value;

    private DestinationModelCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationModelCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationModelCase forNumber(int value) {
      switch (value) {
        case 4:
          return MODEL_ID;
        case 5:
          return PARENT_MODEL;
        case 0:
          return DESTINATIONMODEL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationModelCase getDestinationModelCase() {
    return DestinationModelCase.forNumber(destinationModelCase_);
  }

  public static final int MODEL_ID_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Optional. Copy source_model into a new Model with this ID. The ID will
   * become the final component of the model resource name.
   *
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the modelId field is set.
   */
  public boolean hasModelId() {
    return destinationModelCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Optional. Copy source_model into a new Model with this ID. The ID will
   * become the final component of the model resource name.
   *
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelId.
   */
  public java.lang.String getModelId() {
    java.lang.Object ref = "";
    if (destinationModelCase_ == 4) {
      ref = destinationModel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationModelCase_ == 4) {
        destinationModel_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Copy source_model into a new Model with this ID. The ID will
   * become the final component of the model resource name.
   *
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelId.
   */
  public com.google.protobuf.ByteString getModelIdBytes() {
    java.lang.Object ref = "";
    if (destinationModelCase_ == 4) {
      ref = destinationModel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationModelCase_ == 4) {
        destinationModel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_MODEL_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Optional. Specify this field to copy source_model into this existing
   * Model as a new version. Format:
   * `projects/{project}/locations/{location}/models/{model}`
   * </pre>
   *
   * <code>
   * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the parentModel field is set.
   */
  public boolean hasParentModel() {
    return destinationModelCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specify this field to copy source_model into this existing
   * Model as a new version. Format:
   * `projects/{project}/locations/{location}/models/{model}`
   * </pre>
   *
   * <code>
   * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parentModel.
   */
  public java.lang.String getParentModel() {
    java.lang.Object ref = "";
    if (destinationModelCase_ == 5) {
      ref = destinationModel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationModelCase_ == 5) {
        destinationModel_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Specify this field to copy source_model into this existing
   * Model as a new version. Format:
   * `projects/{project}/locations/{location}/models/{model}`
   * </pre>
   *
   * <code>
   * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parentModel.
   */
  public com.google.protobuf.ByteString getParentModelBytes() {
    java.lang.Object ref = "";
    if (destinationModelCase_ == 5) {
      ref = destinationModel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationModelCase_ == 5) {
        destinationModel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location into which to copy the Model.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location into which to copy the Model.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_MODEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceModel_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model to copy. That Model must be in the
   * same Project. Format:
   * `projects/{project}/locations/{location}/models/{model}`
   * </pre>
   *
   * <code>
   * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The sourceModel.
   */
  @java.lang.Override
  public java.lang.String getSourceModel() {
    java.lang.Object ref = sourceModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceModel_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model to copy. That Model must be in the
   * same Project. Format:
   * `projects/{project}/locations/{location}/models/{model}`
   * </pre>
   *
   * <code>
   * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for sourceModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceModelBytes() {
    java.lang.Object ref = sourceModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options. If this is set,
   * then the Model copy will be encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options. If this is set,
   * then the Model copy will be encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options. If this is set,
   * then the Model copy will be encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceModel_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getEncryptionSpec());
    }
    if (destinationModelCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, destinationModel_);
    }
    if (destinationModelCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, destinationModel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceModel_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEncryptionSpec());
    }
    if (destinationModelCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, destinationModel_);
    }
    if (destinationModelCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, destinationModel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.CopyModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.CopyModelRequest other =
        (com.google.cloud.aiplatform.v1beta1.CopyModelRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getSourceModel().equals(other.getSourceModel())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getDestinationModelCase().equals(other.getDestinationModelCase())) return false;
    switch (destinationModelCase_) {
      case 4:
        if (!getModelId().equals(other.getModelId())) return false;
        break;
      case 5:
        if (!getParentModel().equals(other.getParentModel())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SOURCE_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getSourceModel().hashCode();
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    switch (destinationModelCase_) {
      case 4:
        hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
        hash = (53 * hash) + getModelId().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PARENT_MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getParentModel().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.CopyModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelService.CopyModel][google.cloud.aiplatform.v1beta1.ModelService.CopyModel].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.CopyModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.CopyModelRequest)
      com.google.cloud.aiplatform.v1beta1.CopyModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_CopyModelRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_CopyModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.CopyModelRequest.class,
              com.google.cloud.aiplatform.v1beta1.CopyModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.CopyModelRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      sourceModel_ = "";
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      destinationModelCase_ = 0;
      destinationModel_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_CopyModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CopyModelRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.CopyModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CopyModelRequest build() {
      com.google.cloud.aiplatform.v1beta1.CopyModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CopyModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.CopyModelRequest result =
          new com.google.cloud.aiplatform.v1beta1.CopyModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.CopyModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sourceModel_ = sourceModel_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.CopyModelRequest result) {
      result.destinationModelCase_ = destinationModelCase_;
      result.destinationModel_ = this.destinationModel_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.CopyModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.CopyModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.CopyModelRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.CopyModelRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getSourceModel().isEmpty()) {
        sourceModel_ = other.sourceModel_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      switch (other.getDestinationModelCase()) {
        case MODEL_ID:
          {
            destinationModelCase_ = 4;
            destinationModel_ = other.destinationModel_;
            onChanged();
            break;
          }
        case PARENT_MODEL:
          {
            destinationModelCase_ = 5;
            destinationModel_ = other.destinationModel_;
            onChanged();
            break;
          }
        case DESTINATIONMODEL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                sourceModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationModelCase_ = 4;
                destinationModel_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationModelCase_ = 5;
                destinationModel_ = s;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationModelCase_ = 0;
    private java.lang.Object destinationModel_;

    public DestinationModelCase getDestinationModelCase() {
      return DestinationModelCase.forNumber(destinationModelCase_);
    }

    public Builder clearDestinationModel() {
      destinationModelCase_ = 0;
      destinationModel_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Optional. Copy source_model into a new Model with this ID. The ID will
     * become the final component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the modelId field is set.
     */
    @java.lang.Override
    public boolean hasModelId() {
      return destinationModelCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Copy source_model into a new Model with this ID. The ID will
     * become the final component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelId.
     */
    @java.lang.Override
    public java.lang.String getModelId() {
      java.lang.Object ref = "";
      if (destinationModelCase_ == 4) {
        ref = destinationModel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationModelCase_ == 4) {
          destinationModel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Copy source_model into a new Model with this ID. The ID will
     * become the final component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = "";
      if (destinationModelCase_ == 4) {
        ref = destinationModel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationModelCase_ == 4) {
          destinationModel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Copy source_model into a new Model with this ID. The ID will
     * become the final component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationModelCase_ = 4;
      destinationModel_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Copy source_model into a new Model with this ID. The ID will
     * become the final component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelId() {
      if (destinationModelCase_ == 4) {
        destinationModelCase_ = 0;
        destinationModel_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Copy source_model into a new Model with this ID. The ID will
     * become the final component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationModelCase_ = 4;
      destinationModel_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specify this field to copy source_model into this existing
     * Model as a new version. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the parentModel field is set.
     */
    @java.lang.Override
    public boolean hasParentModel() {
      return destinationModelCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specify this field to copy source_model into this existing
     * Model as a new version. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parentModel.
     */
    @java.lang.Override
    public java.lang.String getParentModel() {
      java.lang.Object ref = "";
      if (destinationModelCase_ == 5) {
        ref = destinationModel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationModelCase_ == 5) {
          destinationModel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specify this field to copy source_model into this existing
     * Model as a new version. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parentModel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentModelBytes() {
      java.lang.Object ref = "";
      if (destinationModelCase_ == 5) {
        ref = destinationModel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationModelCase_ == 5) {
          destinationModel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specify this field to copy source_model into this existing
     * Model as a new version. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parentModel to set.
     * @return This builder for chaining.
     */
    public Builder setParentModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationModelCase_ = 5;
      destinationModel_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specify this field to copy source_model into this existing
     * Model as a new version. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentModel() {
      if (destinationModelCase_ == 5) {
        destinationModelCase_ = 0;
        destinationModel_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specify this field to copy source_model into this existing
     * Model as a new version. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string parent_model = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parentModel to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationModelCase_ = 5;
      destinationModel_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to copy the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to copy the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to copy the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to copy the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to copy the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object sourceModel_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to copy. That Model must be in the
     * same Project. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sourceModel.
     */
    public java.lang.String getSourceModel() {
      java.lang.Object ref = sourceModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to copy. That Model must be in the
     * same Project. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sourceModel.
     */
    public com.google.protobuf.ByteString getSourceModelBytes() {
      java.lang.Object ref = sourceModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to copy. That Model must be in the
     * same Project. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The sourceModel to set.
     * @return This builder for chaining.
     */
    public Builder setSourceModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceModel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to copy. That Model must be in the
     * same Project. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceModel() {
      sourceModel_ = getDefaultInstance().getSourceModel();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to copy. That Model must be in the
     * same Project. Format:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string source_model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for sourceModel to set.
     * @return This builder for chaining.
     */
    public Builder setSourceModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceModel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000010);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options. If this is set,
     * then the Model copy will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.CopyModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.CopyModelRequest)
  private static final com.google.cloud.aiplatform.v1beta1.CopyModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.CopyModelRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.CopyModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CopyModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<CopyModelRequest>() {
        @java.lang.Override
        public CopyModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CopyModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CopyModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CopyModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
