/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/dataset.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A collection of DataItems and Annotations on them.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Dataset}
 */
public final class Dataset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Dataset)
    DatasetOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Dataset.newBuilder() to construct.
  private Dataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Dataset() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    metadataSchemaUri_ = "";
    etag_ = "";
    savedQueries_ = java.util.Collections.emptyList();
    metadataArtifact_ = "";
    modelReference_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Dataset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DatasetProto
        .internal_static_google_cloud_aiplatform_v1beta1_Dataset_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DatasetProto
        .internal_static_google_cloud_aiplatform_v1beta1_Dataset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Dataset.class,
            com.google.cloud.aiplatform.v1beta1.Dataset.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Identifier. The resource name of the Dataset.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Identifier. The resource name of the Dataset.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the Dataset.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the Dataset.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * The description of the Dataset.
   * </pre>
   *
   * <code>string description = 16;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The description of the Dataset.
   * </pre>
   *
   * <code>string description = 16;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_SCHEMA_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadataSchemaUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Dataset. The schema is defined as an
   * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
   * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
   * </pre>
   *
   * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The metadataSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetadataSchemaUri() {
    java.lang.Object ref = metadataSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadataSchemaUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Dataset. The schema is defined as an
   * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
   * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
   * </pre>
   *
   * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for metadataSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataSchemaUriBytes() {
    java.lang.Object ref = metadataSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadataSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 8;
  private com.google.protobuf.Value metadata_;

  /**
   *
   *
   * <pre>
   * Required. Additional information about the Dataset.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Additional information about the Dataset.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetadata() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }

  /**
   *
   *
   * <pre>
   * Required. Additional information about the Dataset.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }

  public static final int DATA_ITEM_COUNT_FIELD_NUMBER = 10;
  private long dataItemCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. The number of DataItems in this Dataset. Only apply for
   * non-structured Dataset.
   * </pre>
   *
   * <code>int64 data_item_count = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The dataItemCount.
   */
  @java.lang.Override
  public long getDataItemCount() {
    return dataItemCount_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Dataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Dataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Dataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Dataset was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Dataset was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Dataset was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.DatasetProto
                .internal_static_google_cloud_aiplatform_v1beta1_Dataset_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Datasets.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one Dataset (System
   * labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each Dataset:
   *
   * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
   *   value is the
   *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Datasets.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one Dataset (System
   * labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each Dataset:
   *
   * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
   *   value is the
   *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Datasets.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one Dataset (System
   * labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each Dataset:
   *
   * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
   *   value is the
   *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Datasets.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one Dataset (System
   * labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each Dataset:
   *
   * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
   *   value is the
   *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SAVED_QUERIES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.SavedQuery> savedQueries_;

  /**
   *
   *
   * <pre>
   * All SavedQueries belong to the Dataset will be returned in List/Get
   * Dataset response. The annotation_specs field
   * will not be populated except for UI cases which will only use
   * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
   * In CreateDataset request, a SavedQuery is created together if
   * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
   * The SavedQuery should not contain any AnnotationSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.SavedQuery> getSavedQueriesList() {
    return savedQueries_;
  }

  /**
   *
   *
   * <pre>
   * All SavedQueries belong to the Dataset will be returned in List/Get
   * Dataset response. The annotation_specs field
   * will not be populated except for UI cases which will only use
   * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
   * In CreateDataset request, a SavedQuery is created together if
   * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
   * The SavedQuery should not contain any AnnotationSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder>
      getSavedQueriesOrBuilderList() {
    return savedQueries_;
  }

  /**
   *
   *
   * <pre>
   * All SavedQueries belong to the Dataset will be returned in List/Get
   * Dataset response. The annotation_specs field
   * will not be populated except for UI cases which will only use
   * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
   * In CreateDataset request, a SavedQuery is created together if
   * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
   * The SavedQuery should not contain any AnnotationSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
   */
  @java.lang.Override
  public int getSavedQueriesCount() {
    return savedQueries_.size();
  }

  /**
   *
   *
   * <pre>
   * All SavedQueries belong to the Dataset will be returned in List/Get
   * Dataset response. The annotation_specs field
   * will not be populated except for UI cases which will only use
   * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
   * In CreateDataset request, a SavedQuery is created together if
   * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
   * The SavedQuery should not contain any AnnotationSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SavedQuery getSavedQueries(int index) {
    return savedQueries_.get(index);
  }

  /**
   *
   *
   * <pre>
   * All SavedQueries belong to the Dataset will be returned in List/Get
   * Dataset response. The annotation_specs field
   * will not be populated except for UI cases which will only use
   * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
   * In CreateDataset request, a SavedQuery is created together if
   * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
   * The SavedQuery should not contain any AnnotationSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder getSavedQueriesOrBuilder(
      int index) {
    return savedQueries_.get(index);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 11;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Dataset. If set, this Dataset
   * and all sub-resources of this Dataset will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Dataset. If set, this Dataset
   * and all sub-resources of this Dataset will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Dataset. If set, this Dataset
   * and all sub-resources of this Dataset will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int METADATA_ARTIFACT_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadataArtifact_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Artifact that was created in
   * MetadataStore when creating the Dataset. The Artifact resource name pattern
   * is
   * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
   * </pre>
   *
   * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metadataArtifact.
   */
  @java.lang.Override
  public java.lang.String getMetadataArtifact() {
    java.lang.Object ref = metadataArtifact_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadataArtifact_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Artifact that was created in
   * MetadataStore when creating the Dataset. The Artifact resource name pattern
   * is
   * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
   * </pre>
   *
   * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for metadataArtifact.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataArtifactBytes() {
    java.lang.Object ref = metadataArtifact_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadataArtifact_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_REFERENCE_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelReference_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Reference to the public base model last used by the dataset. Only
   * set for prompt datasets.
   * </pre>
   *
   * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelReference.
   */
  @java.lang.Override
  public java.lang.String getModelReference() {
    java.lang.Object ref = modelReference_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelReference_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Reference to the public base model last used by the dataset. Only
   * set for prompt datasets.
   * </pre>
   *
   * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelReference.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelReferenceBytes() {
    java.lang.Object ref = modelReference_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelReference_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 19;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 20;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, metadataSchemaUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getMetadata());
    }
    for (int i = 0; i < savedQueries_.size(); i++) {
      output.writeMessage(9, savedQueries_.get(i));
    }
    if (dataItemCount_ != 0L) {
      output.writeInt64(10, dataItemCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataArtifact_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, metadataArtifact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelReference_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, modelReference_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(19, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(20, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, metadataSchemaUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getMetadata());
    }
    for (int i = 0; i < savedQueries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, savedQueries_.get(i));
    }
    if (dataItemCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, dataItemCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataArtifact_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, metadataArtifact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelReference_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, modelReference_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Dataset)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Dataset other =
        (com.google.cloud.aiplatform.v1beta1.Dataset) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getMetadataSchemaUri().equals(other.getMetadataSchemaUri())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (getDataItemCount() != other.getDataItemCount()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getSavedQueriesList().equals(other.getSavedQueriesList())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getMetadataArtifact().equals(other.getMetadataArtifact())) return false;
    if (!getModelReference().equals(other.getModelReference())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + METADATA_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetadataSchemaUri().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (37 * hash) + DATA_ITEM_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDataItemCount());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getSavedQueriesCount() > 0) {
      hash = (37 * hash) + SAVED_QUERIES_FIELD_NUMBER;
      hash = (53 * hash) + getSavedQueriesList().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + METADATA_ARTIFACT_FIELD_NUMBER;
    hash = (53 * hash) + getMetadataArtifact().hashCode();
    hash = (37 * hash) + MODEL_REFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + getModelReference().hashCode();
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Dataset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A collection of DataItems and Annotations on them.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Dataset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Dataset)
      com.google.cloud.aiplatform.v1beta1.DatasetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1beta1_Dataset_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1beta1_Dataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Dataset.class,
              com.google.cloud.aiplatform.v1beta1.Dataset.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Dataset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetadataFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getSavedQueriesFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      metadataSchemaUri_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      dataItemCount_ = 0L;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      internalGetMutableLabels().clear();
      if (savedQueriesBuilder_ == null) {
        savedQueries_ = java.util.Collections.emptyList();
      } else {
        savedQueries_ = null;
        savedQueriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      metadataArtifact_ = "";
      modelReference_ = "";
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1beta1_Dataset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Dataset getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Dataset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Dataset build() {
      com.google.cloud.aiplatform.v1beta1.Dataset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Dataset buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Dataset result =
          new com.google.cloud.aiplatform.v1beta1.Dataset(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.Dataset result) {
      if (savedQueriesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          savedQueries_ = java.util.Collections.unmodifiableList(savedQueries_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.savedQueries_ = savedQueries_;
      } else {
        result.savedQueries_ = savedQueriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Dataset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metadataSchemaUri_ = metadataSchemaUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dataItemCount_ = dataItemCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.metadataArtifact_ = metadataArtifact_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.modelReference_ = modelReference_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Dataset) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Dataset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Dataset other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Dataset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getMetadataSchemaUri().isEmpty()) {
        metadataSchemaUri_ = other.metadataSchemaUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.getDataItemCount() != 0L) {
        setDataItemCount(other.getDataItemCount());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000200;
      if (savedQueriesBuilder_ == null) {
        if (!other.savedQueries_.isEmpty()) {
          if (savedQueries_.isEmpty()) {
            savedQueries_ = other.savedQueries_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureSavedQueriesIsMutable();
            savedQueries_.addAll(other.savedQueries_);
          }
          onChanged();
        }
      } else {
        if (!other.savedQueries_.isEmpty()) {
          if (savedQueriesBuilder_.isEmpty()) {
            savedQueriesBuilder_.dispose();
            savedQueriesBuilder_ = null;
            savedQueries_ = other.savedQueries_;
            bitField0_ = (bitField0_ & ~0x00000400);
            savedQueriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSavedQueriesFieldBuilder()
                    : null;
          } else {
            savedQueriesBuilder_.addAllMessages(other.savedQueries_);
          }
        }
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (!other.getMetadataArtifact().isEmpty()) {
        metadataArtifact_ = other.metadataArtifact_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getModelReference().isEmpty()) {
        modelReference_ = other.modelReference_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                metadataSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 50:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.aiplatform.v1beta1.SavedQuery m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.SavedQuery.parser(), extensionRegistry);
                if (savedQueriesBuilder_ == null) {
                  ensureSavedQueriesIsMutable();
                  savedQueries_.add(m);
                } else {
                  savedQueriesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                dataItemCount_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 130:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 130
            case 138:
              {
                metadataArtifact_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 138
            case 146:
              {
                modelReference_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 146
            case 152:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 152
            case 160:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 160
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the Dataset.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the Dataset.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the Dataset.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the Dataset.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the Dataset.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the Dataset.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the Dataset.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the Dataset.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the Dataset.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the Dataset.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * The description of the Dataset.
     * </pre>
     *
     * <code>string description = 16;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The description of the Dataset.
     * </pre>
     *
     * <code>string description = 16;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The description of the Dataset.
     * </pre>
     *
     * <code>string description = 16;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The description of the Dataset.
     * </pre>
     *
     * <code>string description = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The description of the Dataset.
     * </pre>
     *
     * <code>string description = 16;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object metadataSchemaUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Dataset. The schema is defined as an
     * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
     * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     * </pre>
     *
     * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metadataSchemaUri.
     */
    public java.lang.String getMetadataSchemaUri() {
      java.lang.Object ref = metadataSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Dataset. The schema is defined as an
     * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
     * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     * </pre>
     *
     * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metadataSchemaUri.
     */
    public com.google.protobuf.ByteString getMetadataSchemaUriBytes() {
      java.lang.Object ref = metadataSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Dataset. The schema is defined as an
     * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
     * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     * </pre>
     *
     * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The metadataSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataSchemaUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Dataset. The schema is defined as an
     * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
     * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     * </pre>
     *
     * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataSchemaUri() {
      metadataSchemaUri_ = getDefaultInstance().getMetadataSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Dataset. The schema is defined as an
     * OpenAPI 3.0.2 Schema Object. The schema files that can be used here are
     * found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     * </pre>
     *
     * <code>string metadata_schema_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for metadataSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataSchemaUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metadataBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Value getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000010);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.Value.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Additional information about the Dataset.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private long dataItemCount_;

    /**
     *
     *
     * <pre>
     * Output only. The number of DataItems in this Dataset. Only apply for
     * non-structured Dataset.
     * </pre>
     *
     * <code>int64 data_item_count = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dataItemCount.
     */
    @java.lang.Override
    public long getDataItemCount() {
      return dataItemCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of DataItems in this Dataset. Only apply for
     * non-structured Dataset.
     * </pre>
     *
     * <code>int64 data_item_count = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The dataItemCount to set.
     * @return This builder for chaining.
     */
    public Builder setDataItemCount(long value) {

      dataItemCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of DataItems in this Dataset. Only apply for
     * non-structured Dataset.
     * </pre>
     *
     * <code>int64 data_item_count = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataItemCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      dataItemCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Dataset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000200;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Datasets.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one Dataset (System
     * labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each Dataset:
     *
     * * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
     *   value is the
     *   [metadata_schema's][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri]
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.SavedQuery> savedQueries_ =
        java.util.Collections.emptyList();

    private void ensureSavedQueriesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        savedQueries_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.SavedQuery>(savedQueries_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SavedQuery,
            com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder,
            com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder>
        savedQueriesBuilder_;

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SavedQuery> getSavedQueriesList() {
      if (savedQueriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(savedQueries_);
      } else {
        return savedQueriesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public int getSavedQueriesCount() {
      if (savedQueriesBuilder_ == null) {
        return savedQueries_.size();
      } else {
        return savedQueriesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SavedQuery getSavedQueries(int index) {
      if (savedQueriesBuilder_ == null) {
        return savedQueries_.get(index);
      } else {
        return savedQueriesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder setSavedQueries(
        int index, com.google.cloud.aiplatform.v1beta1.SavedQuery value) {
      if (savedQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSavedQueriesIsMutable();
        savedQueries_.set(index, value);
        onChanged();
      } else {
        savedQueriesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder setSavedQueries(
        int index, com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder builderForValue) {
      if (savedQueriesBuilder_ == null) {
        ensureSavedQueriesIsMutable();
        savedQueries_.set(index, builderForValue.build());
        onChanged();
      } else {
        savedQueriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder addSavedQueries(com.google.cloud.aiplatform.v1beta1.SavedQuery value) {
      if (savedQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSavedQueriesIsMutable();
        savedQueries_.add(value);
        onChanged();
      } else {
        savedQueriesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder addSavedQueries(
        int index, com.google.cloud.aiplatform.v1beta1.SavedQuery value) {
      if (savedQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSavedQueriesIsMutable();
        savedQueries_.add(index, value);
        onChanged();
      } else {
        savedQueriesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder addSavedQueries(
        com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder builderForValue) {
      if (savedQueriesBuilder_ == null) {
        ensureSavedQueriesIsMutable();
        savedQueries_.add(builderForValue.build());
        onChanged();
      } else {
        savedQueriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder addSavedQueries(
        int index, com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder builderForValue) {
      if (savedQueriesBuilder_ == null) {
        ensureSavedQueriesIsMutable();
        savedQueries_.add(index, builderForValue.build());
        onChanged();
      } else {
        savedQueriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder addAllSavedQueries(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.SavedQuery> values) {
      if (savedQueriesBuilder_ == null) {
        ensureSavedQueriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, savedQueries_);
        onChanged();
      } else {
        savedQueriesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder clearSavedQueries() {
      if (savedQueriesBuilder_ == null) {
        savedQueries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        savedQueriesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public Builder removeSavedQueries(int index) {
      if (savedQueriesBuilder_ == null) {
        ensureSavedQueriesIsMutable();
        savedQueries_.remove(index);
        onChanged();
      } else {
        savedQueriesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder getSavedQueriesBuilder(
        int index) {
      return getSavedQueriesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder getSavedQueriesOrBuilder(
        int index) {
      if (savedQueriesBuilder_ == null) {
        return savedQueries_.get(index);
      } else {
        return savedQueriesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder>
        getSavedQueriesOrBuilderList() {
      if (savedQueriesBuilder_ != null) {
        return savedQueriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(savedQueries_);
      }
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder addSavedQueriesBuilder() {
      return getSavedQueriesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.SavedQuery.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder addSavedQueriesBuilder(
        int index) {
      return getSavedQueriesFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.SavedQuery.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All SavedQueries belong to the Dataset will be returned in List/Get
     * Dataset response. The annotation_specs field
     * will not be populated except for UI cases which will only use
     * [annotation_spec_count][google.cloud.aiplatform.v1beta1.SavedQuery.annotation_spec_count].
     * In CreateDataset request, a SavedQuery is created together if
     * this field is set, up to one SavedQuery can be set in CreateDatasetRequest.
     * The SavedQuery should not contain any AnnotationSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.SavedQuery saved_queries = 9;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder>
        getSavedQueriesBuilderList() {
      return getSavedQueriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SavedQuery,
            com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder,
            com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder>
        getSavedQueriesFieldBuilder() {
      if (savedQueriesBuilder_ == null) {
        savedQueriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SavedQuery,
                com.google.cloud.aiplatform.v1beta1.SavedQuery.Builder,
                com.google.cloud.aiplatform.v1beta1.SavedQueryOrBuilder>(
                savedQueries_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        savedQueries_ = null;
      }
      return savedQueriesBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000800);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Dataset. If set, this Dataset
     * and all sub-resources of this Dataset will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private java.lang.Object metadataArtifact_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Dataset. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metadataArtifact.
     */
    public java.lang.String getMetadataArtifact() {
      java.lang.Object ref = metadataArtifact_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataArtifact_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Dataset. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for metadataArtifact.
     */
    public com.google.protobuf.ByteString getMetadataArtifactBytes() {
      java.lang.Object ref = metadataArtifact_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataArtifact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Dataset. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metadataArtifact to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataArtifact(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataArtifact_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Dataset. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataArtifact() {
      metadataArtifact_ = getDefaultInstance().getMetadataArtifact();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Dataset. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for metadataArtifact to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataArtifactBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataArtifact_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object modelReference_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Reference to the public base model last used by the dataset. Only
     * set for prompt datasets.
     * </pre>
     *
     * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelReference.
     */
    public java.lang.String getModelReference() {
      java.lang.Object ref = modelReference_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelReference_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Reference to the public base model last used by the dataset. Only
     * set for prompt datasets.
     * </pre>
     *
     * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelReference.
     */
    public com.google.protobuf.ByteString getModelReferenceBytes() {
      java.lang.Object ref = modelReference_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelReference_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Reference to the public base model last used by the dataset. Only
     * set for prompt datasets.
     * </pre>
     *
     * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The modelReference to set.
     * @return This builder for chaining.
     */
    public Builder setModelReference(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelReference_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Reference to the public base model last used by the dataset. Only
     * set for prompt datasets.
     * </pre>
     *
     * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelReference() {
      modelReference_ = getDefaultInstance().getModelReference();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Reference to the public base model last used by the dataset. Only
     * set for prompt datasets.
     * </pre>
     *
     * <code>string model_reference = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for modelReference to set.
     * @return This builder for chaining.
     */
    public Builder setModelReferenceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelReference_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00004000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00008000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Dataset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Dataset)
  private static final com.google.cloud.aiplatform.v1beta1.Dataset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Dataset();
  }

  public static com.google.cloud.aiplatform.v1beta1.Dataset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Dataset> PARSER =
      new com.google.protobuf.AbstractParser<Dataset>() {
        @java.lang.Override
        public Dataset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Dataset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Dataset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Dataset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
