/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Statistics computed over a tuning dataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DatasetStats}
 */
public final class DatasetStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DatasetStats)
    DatasetStatsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DatasetStats.newBuilder() to construct.
  private DatasetStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DatasetStats() {
    userDatasetExamples_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DatasetStats();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_DatasetStats_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_DatasetStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DatasetStats.class,
            com.google.cloud.aiplatform.v1beta1.DatasetStats.Builder.class);
  }

  private int bitField0_;
  public static final int TUNING_DATASET_EXAMPLE_COUNT_FIELD_NUMBER = 1;
  private long tuningDatasetExampleCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. Number of examples in the tuning dataset.
   * </pre>
   *
   * <code>int64 tuning_dataset_example_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tuningDatasetExampleCount.
   */
  @java.lang.Override
  public long getTuningDatasetExampleCount() {
    return tuningDatasetExampleCount_;
  }

  public static final int TOTAL_TUNING_CHARACTER_COUNT_FIELD_NUMBER = 2;
  private long totalTuningCharacterCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. Number of tuning characters in the tuning dataset.
   * </pre>
   *
   * <code>int64 total_tuning_character_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The totalTuningCharacterCount.
   */
  @java.lang.Override
  public long getTotalTuningCharacterCount() {
    return totalTuningCharacterCount_;
  }

  public static final int TOTAL_BILLABLE_CHARACTER_COUNT_FIELD_NUMBER = 3;
  private long totalBillableCharacterCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. Number of billable characters in the tuning dataset.
   * </pre>
   *
   * <code>int64 total_billable_character_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The totalBillableCharacterCount.
   */
  @java.lang.Override
  public long getTotalBillableCharacterCount() {
    return totalBillableCharacterCount_;
  }

  public static final int TUNING_STEP_COUNT_FIELD_NUMBER = 4;
  private long tuningStepCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. Number of tuning steps for this Tuning Job.
   * </pre>
   *
   * <code>int64 tuning_step_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tuningStepCount.
   */
  @java.lang.Override
  public long getTuningStepCount() {
    return tuningStepCount_;
  }

  public static final int USER_INPUT_TOKEN_DISTRIBUTION_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.DatasetDistribution userInputTokenDistribution_;

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user input tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userInputTokenDistribution field is set.
   */
  @java.lang.Override
  public boolean hasUserInputTokenDistribution() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user input tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userInputTokenDistribution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistribution getUserInputTokenDistribution() {
    return userInputTokenDistribution_ == null
        ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
        : userInputTokenDistribution_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user input tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder
      getUserInputTokenDistributionOrBuilder() {
    return userInputTokenDistribution_ == null
        ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
        : userInputTokenDistribution_;
  }

  public static final int USER_OUTPUT_TOKEN_DISTRIBUTION_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.DatasetDistribution userOutputTokenDistribution_;

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user output tokens.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userOutputTokenDistribution field is set.
   */
  @java.lang.Override
  public boolean hasUserOutputTokenDistribution() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user output tokens.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userOutputTokenDistribution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistribution getUserOutputTokenDistribution() {
    return userOutputTokenDistribution_ == null
        ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
        : userOutputTokenDistribution_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the user output tokens.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder
      getUserOutputTokenDistributionOrBuilder() {
    return userOutputTokenDistribution_ == null
        ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
        : userOutputTokenDistribution_;
  }

  public static final int USER_MESSAGE_PER_EXAMPLE_DISTRIBUTION_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.DatasetDistribution
      userMessagePerExampleDistribution_;

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the messages per example.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userMessagePerExampleDistribution field is set.
   */
  @java.lang.Override
  public boolean hasUserMessagePerExampleDistribution() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the messages per example.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userMessagePerExampleDistribution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistribution
      getUserMessagePerExampleDistribution() {
    return userMessagePerExampleDistribution_ == null
        ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
        : userMessagePerExampleDistribution_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Dataset distributions for the messages per example.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder
      getUserMessagePerExampleDistributionOrBuilder() {
    return userMessagePerExampleDistribution_ == null
        ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
        : userMessagePerExampleDistribution_;
  }

  public static final int USER_DATASET_EXAMPLES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> userDatasetExamples_;

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getUserDatasetExamplesList() {
    return userDatasetExamples_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
      getUserDatasetExamplesOrBuilderList() {
    return userDatasetExamples_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getUserDatasetExamplesCount() {
    return userDatasetExamples_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getUserDatasetExamples(int index) {
    return userDatasetExamples_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Sample user messages in the training dataset uri.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getUserDatasetExamplesOrBuilder(
      int index) {
    return userDatasetExamples_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (tuningDatasetExampleCount_ != 0L) {
      output.writeInt64(1, tuningDatasetExampleCount_);
    }
    if (totalTuningCharacterCount_ != 0L) {
      output.writeInt64(2, totalTuningCharacterCount_);
    }
    if (totalBillableCharacterCount_ != 0L) {
      output.writeInt64(3, totalBillableCharacterCount_);
    }
    if (tuningStepCount_ != 0L) {
      output.writeInt64(4, tuningStepCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getUserInputTokenDistribution());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUserOutputTokenDistribution());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getUserMessagePerExampleDistribution());
    }
    for (int i = 0; i < userDatasetExamples_.size(); i++) {
      output.writeMessage(8, userDatasetExamples_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (tuningDatasetExampleCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, tuningDatasetExampleCount_);
    }
    if (totalTuningCharacterCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, totalTuningCharacterCount_);
    }
    if (totalBillableCharacterCount_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(3, totalBillableCharacterCount_);
    }
    if (tuningStepCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, tuningStepCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getUserInputTokenDistribution());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getUserOutputTokenDistribution());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getUserMessagePerExampleDistribution());
    }
    for (int i = 0; i < userDatasetExamples_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, userDatasetExamples_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DatasetStats)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DatasetStats other =
        (com.google.cloud.aiplatform.v1beta1.DatasetStats) obj;

    if (getTuningDatasetExampleCount() != other.getTuningDatasetExampleCount()) return false;
    if (getTotalTuningCharacterCount() != other.getTotalTuningCharacterCount()) return false;
    if (getTotalBillableCharacterCount() != other.getTotalBillableCharacterCount()) return false;
    if (getTuningStepCount() != other.getTuningStepCount()) return false;
    if (hasUserInputTokenDistribution() != other.hasUserInputTokenDistribution()) return false;
    if (hasUserInputTokenDistribution()) {
      if (!getUserInputTokenDistribution().equals(other.getUserInputTokenDistribution()))
        return false;
    }
    if (hasUserOutputTokenDistribution() != other.hasUserOutputTokenDistribution()) return false;
    if (hasUserOutputTokenDistribution()) {
      if (!getUserOutputTokenDistribution().equals(other.getUserOutputTokenDistribution()))
        return false;
    }
    if (hasUserMessagePerExampleDistribution() != other.hasUserMessagePerExampleDistribution())
      return false;
    if (hasUserMessagePerExampleDistribution()) {
      if (!getUserMessagePerExampleDistribution()
          .equals(other.getUserMessagePerExampleDistribution())) return false;
    }
    if (!getUserDatasetExamplesList().equals(other.getUserDatasetExamplesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TUNING_DATASET_EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTuningDatasetExampleCount());
    hash = (37 * hash) + TOTAL_TUNING_CHARACTER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalTuningCharacterCount());
    hash = (37 * hash) + TOTAL_BILLABLE_CHARACTER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalBillableCharacterCount());
    hash = (37 * hash) + TUNING_STEP_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTuningStepCount());
    if (hasUserInputTokenDistribution()) {
      hash = (37 * hash) + USER_INPUT_TOKEN_DISTRIBUTION_FIELD_NUMBER;
      hash = (53 * hash) + getUserInputTokenDistribution().hashCode();
    }
    if (hasUserOutputTokenDistribution()) {
      hash = (37 * hash) + USER_OUTPUT_TOKEN_DISTRIBUTION_FIELD_NUMBER;
      hash = (53 * hash) + getUserOutputTokenDistribution().hashCode();
    }
    if (hasUserMessagePerExampleDistribution()) {
      hash = (37 * hash) + USER_MESSAGE_PER_EXAMPLE_DISTRIBUTION_FIELD_NUMBER;
      hash = (53 * hash) + getUserMessagePerExampleDistribution().hashCode();
    }
    if (getUserDatasetExamplesCount() > 0) {
      hash = (37 * hash) + USER_DATASET_EXAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getUserDatasetExamplesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.DatasetStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Statistics computed over a tuning dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DatasetStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DatasetStats)
      com.google.cloud.aiplatform.v1beta1.DatasetStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DatasetStats.class,
              com.google.cloud.aiplatform.v1beta1.DatasetStats.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DatasetStats.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserInputTokenDistributionFieldBuilder();
        getUserOutputTokenDistributionFieldBuilder();
        getUserMessagePerExampleDistributionFieldBuilder();
        getUserDatasetExamplesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tuningDatasetExampleCount_ = 0L;
      totalTuningCharacterCount_ = 0L;
      totalBillableCharacterCount_ = 0L;
      tuningStepCount_ = 0L;
      userInputTokenDistribution_ = null;
      if (userInputTokenDistributionBuilder_ != null) {
        userInputTokenDistributionBuilder_.dispose();
        userInputTokenDistributionBuilder_ = null;
      }
      userOutputTokenDistribution_ = null;
      if (userOutputTokenDistributionBuilder_ != null) {
        userOutputTokenDistributionBuilder_.dispose();
        userOutputTokenDistributionBuilder_ = null;
      }
      userMessagePerExampleDistribution_ = null;
      if (userMessagePerExampleDistributionBuilder_ != null) {
        userMessagePerExampleDistributionBuilder_.dispose();
        userMessagePerExampleDistributionBuilder_ = null;
      }
      if (userDatasetExamplesBuilder_ == null) {
        userDatasetExamples_ = java.util.Collections.emptyList();
      } else {
        userDatasetExamples_ = null;
        userDatasetExamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetStats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetStats getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetStats build() {
      com.google.cloud.aiplatform.v1beta1.DatasetStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetStats buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DatasetStats result =
          new com.google.cloud.aiplatform.v1beta1.DatasetStats(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.DatasetStats result) {
      if (userDatasetExamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          userDatasetExamples_ = java.util.Collections.unmodifiableList(userDatasetExamples_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.userDatasetExamples_ = userDatasetExamples_;
      } else {
        result.userDatasetExamples_ = userDatasetExamplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.DatasetStats result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tuningDatasetExampleCount_ = tuningDatasetExampleCount_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.totalTuningCharacterCount_ = totalTuningCharacterCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.totalBillableCharacterCount_ = totalBillableCharacterCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tuningStepCount_ = tuningStepCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.userInputTokenDistribution_ =
            userInputTokenDistributionBuilder_ == null
                ? userInputTokenDistribution_
                : userInputTokenDistributionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.userOutputTokenDistribution_ =
            userOutputTokenDistributionBuilder_ == null
                ? userOutputTokenDistribution_
                : userOutputTokenDistributionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.userMessagePerExampleDistribution_ =
            userMessagePerExampleDistributionBuilder_ == null
                ? userMessagePerExampleDistribution_
                : userMessagePerExampleDistributionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DatasetStats) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DatasetStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.DatasetStats other) {
      if (other == com.google.cloud.aiplatform.v1beta1.DatasetStats.getDefaultInstance())
        return this;
      if (other.getTuningDatasetExampleCount() != 0L) {
        setTuningDatasetExampleCount(other.getTuningDatasetExampleCount());
      }
      if (other.getTotalTuningCharacterCount() != 0L) {
        setTotalTuningCharacterCount(other.getTotalTuningCharacterCount());
      }
      if (other.getTotalBillableCharacterCount() != 0L) {
        setTotalBillableCharacterCount(other.getTotalBillableCharacterCount());
      }
      if (other.getTuningStepCount() != 0L) {
        setTuningStepCount(other.getTuningStepCount());
      }
      if (other.hasUserInputTokenDistribution()) {
        mergeUserInputTokenDistribution(other.getUserInputTokenDistribution());
      }
      if (other.hasUserOutputTokenDistribution()) {
        mergeUserOutputTokenDistribution(other.getUserOutputTokenDistribution());
      }
      if (other.hasUserMessagePerExampleDistribution()) {
        mergeUserMessagePerExampleDistribution(other.getUserMessagePerExampleDistribution());
      }
      if (userDatasetExamplesBuilder_ == null) {
        if (!other.userDatasetExamples_.isEmpty()) {
          if (userDatasetExamples_.isEmpty()) {
            userDatasetExamples_ = other.userDatasetExamples_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureUserDatasetExamplesIsMutable();
            userDatasetExamples_.addAll(other.userDatasetExamples_);
          }
          onChanged();
        }
      } else {
        if (!other.userDatasetExamples_.isEmpty()) {
          if (userDatasetExamplesBuilder_.isEmpty()) {
            userDatasetExamplesBuilder_.dispose();
            userDatasetExamplesBuilder_ = null;
            userDatasetExamples_ = other.userDatasetExamples_;
            bitField0_ = (bitField0_ & ~0x00000080);
            userDatasetExamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUserDatasetExamplesFieldBuilder()
                    : null;
          } else {
            userDatasetExamplesBuilder_.addAllMessages(other.userDatasetExamples_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                tuningDatasetExampleCount_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                totalTuningCharacterCount_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                totalBillableCharacterCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                tuningStepCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getUserInputTokenDistributionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getUserOutputTokenDistributionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getUserMessagePerExampleDistributionFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.aiplatform.v1beta1.Content m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Content.parser(), extensionRegistry);
                if (userDatasetExamplesBuilder_ == null) {
                  ensureUserDatasetExamplesIsMutable();
                  userDatasetExamples_.add(m);
                } else {
                  userDatasetExamplesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long tuningDatasetExampleCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of examples in the tuning dataset.
     * </pre>
     *
     * <code>int64 tuning_dataset_example_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tuningDatasetExampleCount.
     */
    @java.lang.Override
    public long getTuningDatasetExampleCount() {
      return tuningDatasetExampleCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of examples in the tuning dataset.
     * </pre>
     *
     * <code>int64 tuning_dataset_example_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The tuningDatasetExampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setTuningDatasetExampleCount(long value) {

      tuningDatasetExampleCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of examples in the tuning dataset.
     * </pre>
     *
     * <code>int64 tuning_dataset_example_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTuningDatasetExampleCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      tuningDatasetExampleCount_ = 0L;
      onChanged();
      return this;
    }

    private long totalTuningCharacterCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of tuning characters in the tuning dataset.
     * </pre>
     *
     * <code>int64 total_tuning_character_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The totalTuningCharacterCount.
     */
    @java.lang.Override
    public long getTotalTuningCharacterCount() {
      return totalTuningCharacterCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of tuning characters in the tuning dataset.
     * </pre>
     *
     * <code>int64 total_tuning_character_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The totalTuningCharacterCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalTuningCharacterCount(long value) {

      totalTuningCharacterCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of tuning characters in the tuning dataset.
     * </pre>
     *
     * <code>int64 total_tuning_character_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalTuningCharacterCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      totalTuningCharacterCount_ = 0L;
      onChanged();
      return this;
    }

    private long totalBillableCharacterCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of billable characters in the tuning dataset.
     * </pre>
     *
     * <code>int64 total_billable_character_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The totalBillableCharacterCount.
     */
    @java.lang.Override
    public long getTotalBillableCharacterCount() {
      return totalBillableCharacterCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of billable characters in the tuning dataset.
     * </pre>
     *
     * <code>int64 total_billable_character_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The totalBillableCharacterCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalBillableCharacterCount(long value) {

      totalBillableCharacterCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of billable characters in the tuning dataset.
     * </pre>
     *
     * <code>int64 total_billable_character_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalBillableCharacterCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      totalBillableCharacterCount_ = 0L;
      onChanged();
      return this;
    }

    private long tuningStepCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of tuning steps for this Tuning Job.
     * </pre>
     *
     * <code>int64 tuning_step_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tuningStepCount.
     */
    @java.lang.Override
    public long getTuningStepCount() {
      return tuningStepCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of tuning steps for this Tuning Job.
     * </pre>
     *
     * <code>int64 tuning_step_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tuningStepCount to set.
     * @return This builder for chaining.
     */
    public Builder setTuningStepCount(long value) {

      tuningStepCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of tuning steps for this Tuning Job.
     * </pre>
     *
     * <code>int64 tuning_step_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTuningStepCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      tuningStepCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DatasetDistribution userInputTokenDistribution_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>
        userInputTokenDistributionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the userInputTokenDistribution field is set.
     */
    public boolean hasUserInputTokenDistribution() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The userInputTokenDistribution.
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution getUserInputTokenDistribution() {
      if (userInputTokenDistributionBuilder_ == null) {
        return userInputTokenDistribution_ == null
            ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
            : userInputTokenDistribution_;
      } else {
        return userInputTokenDistributionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserInputTokenDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution value) {
      if (userInputTokenDistributionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInputTokenDistribution_ = value;
      } else {
        userInputTokenDistributionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserInputTokenDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder builderForValue) {
      if (userInputTokenDistributionBuilder_ == null) {
        userInputTokenDistribution_ = builderForValue.build();
      } else {
        userInputTokenDistributionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUserInputTokenDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution value) {
      if (userInputTokenDistributionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && userInputTokenDistribution_ != null
            && userInputTokenDistribution_
                != com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()) {
          getUserInputTokenDistributionBuilder().mergeFrom(value);
        } else {
          userInputTokenDistribution_ = value;
        }
      } else {
        userInputTokenDistributionBuilder_.mergeFrom(value);
      }
      if (userInputTokenDistribution_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUserInputTokenDistribution() {
      bitField0_ = (bitField0_ & ~0x00000010);
      userInputTokenDistribution_ = null;
      if (userInputTokenDistributionBuilder_ != null) {
        userInputTokenDistributionBuilder_.dispose();
        userInputTokenDistributionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder
        getUserInputTokenDistributionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUserInputTokenDistributionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder
        getUserInputTokenDistributionOrBuilder() {
      if (userInputTokenDistributionBuilder_ != null) {
        return userInputTokenDistributionBuilder_.getMessageOrBuilder();
      } else {
        return userInputTokenDistribution_ == null
            ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
            : userInputTokenDistribution_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user input tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_input_token_distribution = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>
        getUserInputTokenDistributionFieldBuilder() {
      if (userInputTokenDistributionBuilder_ == null) {
        userInputTokenDistributionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
                com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>(
                getUserInputTokenDistribution(), getParentForChildren(), isClean());
        userInputTokenDistribution_ = null;
      }
      return userInputTokenDistributionBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.DatasetDistribution userOutputTokenDistribution_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>
        userOutputTokenDistributionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the userOutputTokenDistribution field is set.
     */
    public boolean hasUserOutputTokenDistribution() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The userOutputTokenDistribution.
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution
        getUserOutputTokenDistribution() {
      if (userOutputTokenDistributionBuilder_ == null) {
        return userOutputTokenDistribution_ == null
            ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
            : userOutputTokenDistribution_;
      } else {
        return userOutputTokenDistributionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserOutputTokenDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution value) {
      if (userOutputTokenDistributionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userOutputTokenDistribution_ = value;
      } else {
        userOutputTokenDistributionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserOutputTokenDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder builderForValue) {
      if (userOutputTokenDistributionBuilder_ == null) {
        userOutputTokenDistribution_ = builderForValue.build();
      } else {
        userOutputTokenDistributionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUserOutputTokenDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution value) {
      if (userOutputTokenDistributionBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && userOutputTokenDistribution_ != null
            && userOutputTokenDistribution_
                != com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()) {
          getUserOutputTokenDistributionBuilder().mergeFrom(value);
        } else {
          userOutputTokenDistribution_ = value;
        }
      } else {
        userOutputTokenDistributionBuilder_.mergeFrom(value);
      }
      if (userOutputTokenDistribution_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUserOutputTokenDistribution() {
      bitField0_ = (bitField0_ & ~0x00000020);
      userOutputTokenDistribution_ = null;
      if (userOutputTokenDistributionBuilder_ != null) {
        userOutputTokenDistributionBuilder_.dispose();
        userOutputTokenDistributionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder
        getUserOutputTokenDistributionBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUserOutputTokenDistributionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder
        getUserOutputTokenDistributionOrBuilder() {
      if (userOutputTokenDistributionBuilder_ != null) {
        return userOutputTokenDistributionBuilder_.getMessageOrBuilder();
      } else {
        return userOutputTokenDistribution_ == null
            ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
            : userOutputTokenDistribution_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the user output tokens.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.DatasetDistribution user_output_token_distribution = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>
        getUserOutputTokenDistributionFieldBuilder() {
      if (userOutputTokenDistributionBuilder_ == null) {
        userOutputTokenDistributionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
                com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>(
                getUserOutputTokenDistribution(), getParentForChildren(), isClean());
        userOutputTokenDistribution_ = null;
      }
      return userOutputTokenDistributionBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.DatasetDistribution
        userMessagePerExampleDistribution_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>
        userMessagePerExampleDistributionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the userMessagePerExampleDistribution field is set.
     */
    public boolean hasUserMessagePerExampleDistribution() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The userMessagePerExampleDistribution.
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution
        getUserMessagePerExampleDistribution() {
      if (userMessagePerExampleDistributionBuilder_ == null) {
        return userMessagePerExampleDistribution_ == null
            ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
            : userMessagePerExampleDistribution_;
      } else {
        return userMessagePerExampleDistributionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserMessagePerExampleDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution value) {
      if (userMessagePerExampleDistributionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userMessagePerExampleDistribution_ = value;
      } else {
        userMessagePerExampleDistributionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserMessagePerExampleDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder builderForValue) {
      if (userMessagePerExampleDistributionBuilder_ == null) {
        userMessagePerExampleDistribution_ = builderForValue.build();
      } else {
        userMessagePerExampleDistributionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUserMessagePerExampleDistribution(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution value) {
      if (userMessagePerExampleDistributionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && userMessagePerExampleDistribution_ != null
            && userMessagePerExampleDistribution_
                != com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()) {
          getUserMessagePerExampleDistributionBuilder().mergeFrom(value);
        } else {
          userMessagePerExampleDistribution_ = value;
        }
      } else {
        userMessagePerExampleDistributionBuilder_.mergeFrom(value);
      }
      if (userMessagePerExampleDistribution_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUserMessagePerExampleDistribution() {
      bitField0_ = (bitField0_ & ~0x00000040);
      userMessagePerExampleDistribution_ = null;
      if (userMessagePerExampleDistributionBuilder_ != null) {
        userMessagePerExampleDistributionBuilder_.dispose();
        userMessagePerExampleDistributionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder
        getUserMessagePerExampleDistributionBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUserMessagePerExampleDistributionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder
        getUserMessagePerExampleDistributionOrBuilder() {
      if (userMessagePerExampleDistributionBuilder_ != null) {
        return userMessagePerExampleDistributionBuilder_.getMessageOrBuilder();
      } else {
        return userMessagePerExampleDistribution_ == null
            ? com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance()
            : userMessagePerExampleDistribution_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Dataset distributions for the messages per example.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DatasetDistribution user_message_per_example_distribution = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>
        getUserMessagePerExampleDistributionFieldBuilder() {
      if (userMessagePerExampleDistributionBuilder_ == null) {
        userMessagePerExampleDistributionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution,
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder,
                com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder>(
                getUserMessagePerExampleDistribution(), getParentForChildren(), isClean());
        userMessagePerExampleDistribution_ = null;
      }
      return userMessagePerExampleDistributionBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> userDatasetExamples_ =
        java.util.Collections.emptyList();

    private void ensureUserDatasetExamplesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        userDatasetExamples_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Content>(
                userDatasetExamples_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        userDatasetExamplesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content>
        getUserDatasetExamplesList() {
      if (userDatasetExamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(userDatasetExamples_);
      } else {
        return userDatasetExamplesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getUserDatasetExamplesCount() {
      if (userDatasetExamplesBuilder_ == null) {
        return userDatasetExamples_.size();
      } else {
        return userDatasetExamplesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content getUserDatasetExamples(int index) {
      if (userDatasetExamplesBuilder_ == null) {
        return userDatasetExamples_.get(index);
      } else {
        return userDatasetExamplesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserDatasetExamples(
        int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (userDatasetExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.set(index, value);
        onChanged();
      } else {
        userDatasetExamplesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserDatasetExamples(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (userDatasetExamplesBuilder_ == null) {
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        userDatasetExamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUserDatasetExamples(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (userDatasetExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.add(value);
        onChanged();
      } else {
        userDatasetExamplesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUserDatasetExamples(
        int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (userDatasetExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.add(index, value);
        onChanged();
      } else {
        userDatasetExamplesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUserDatasetExamples(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (userDatasetExamplesBuilder_ == null) {
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.add(builderForValue.build());
        onChanged();
      } else {
        userDatasetExamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUserDatasetExamples(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (userDatasetExamplesBuilder_ == null) {
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        userDatasetExamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllUserDatasetExamples(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Content> values) {
      if (userDatasetExamplesBuilder_ == null) {
        ensureUserDatasetExamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userDatasetExamples_);
        onChanged();
      } else {
        userDatasetExamplesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUserDatasetExamples() {
      if (userDatasetExamplesBuilder_ == null) {
        userDatasetExamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        userDatasetExamplesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeUserDatasetExamples(int index) {
      if (userDatasetExamplesBuilder_ == null) {
        ensureUserDatasetExamplesIsMutable();
        userDatasetExamples_.remove(index);
        onChanged();
      } else {
        userDatasetExamplesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getUserDatasetExamplesBuilder(
        int index) {
      return getUserDatasetExamplesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getUserDatasetExamplesOrBuilder(
        int index) {
      if (userDatasetExamplesBuilder_ == null) {
        return userDatasetExamples_.get(index);
      } else {
        return userDatasetExamplesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getUserDatasetExamplesOrBuilderList() {
      if (userDatasetExamplesBuilder_ != null) {
        return userDatasetExamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(userDatasetExamples_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addUserDatasetExamplesBuilder() {
      return getUserDatasetExamplesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addUserDatasetExamplesBuilder(
        int index) {
      return getUserDatasetExamplesFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Sample user messages in the training dataset uri.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content user_dataset_examples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content.Builder>
        getUserDatasetExamplesBuilderList() {
      return getUserDatasetExamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getUserDatasetExamplesFieldBuilder() {
      if (userDatasetExamplesBuilder_ == null) {
        userDatasetExamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                userDatasetExamples_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        userDatasetExamples_ = null;
      }
      return userDatasetExamplesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DatasetStats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DatasetStats)
  private static final com.google.cloud.aiplatform.v1beta1.DatasetStats DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DatasetStats();
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetStats getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DatasetStats> PARSER =
      new com.google.protobuf.AbstractParser<DatasetStats>() {
        @java.lang.Override
        public DatasetStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DatasetStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DatasetStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetStats getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
