/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

public interface DistillationSpecOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.DistillationSpec)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The base teacher model that is being distilled. See [Supported
   * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
   * </pre>
   *
   * <code>string base_teacher_model = 5;</code>
   *
   * @return Whether the baseTeacherModel field is set.
   */
  boolean hasBaseTeacherModel();

  /**
   *
   *
   * <pre>
   * The base teacher model that is being distilled. See [Supported
   * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
   * </pre>
   *
   * <code>string base_teacher_model = 5;</code>
   *
   * @return The baseTeacherModel.
   */
  java.lang.String getBaseTeacherModel();

  /**
   *
   *
   * <pre>
   * The base teacher model that is being distilled. See [Supported
   * models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
   * </pre>
   *
   * <code>string base_teacher_model = 5;</code>
   *
   * @return The bytes for baseTeacherModel.
   */
  com.google.protobuf.ByteString getBaseTeacherModelBytes();

  /**
   *
   *
   * <pre>
   * The resource name of the Tuned teacher model. Format:
   * `projects/{project}/locations/{location}/models/{model}`.
   * </pre>
   *
   * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the tunedTeacherModelSource field is set.
   */
  boolean hasTunedTeacherModelSource();

  /**
   *
   *
   * <pre>
   * The resource name of the Tuned teacher model. Format:
   * `projects/{project}/locations/{location}/models/{model}`.
   * </pre>
   *
   * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The tunedTeacherModelSource.
   */
  java.lang.String getTunedTeacherModelSource();

  /**
   *
   *
   * <pre>
   * The resource name of the Tuned teacher model. Format:
   * `projects/{project}/locations/{location}/models/{model}`.
   * </pre>
   *
   * <code>string tuned_teacher_model_source = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for tunedTeacherModelSource.
   */
  com.google.protobuf.ByteString getTunedTeacherModelSourceBytes();

  /**
   *
   *
   * <pre>
   * Required. Cloud Storage path to file containing training dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trainingDatasetUri.
   */
  java.lang.String getTrainingDatasetUri();

  /**
   *
   *
   * <pre>
   * Required. Cloud Storage path to file containing training dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trainingDatasetUri.
   */
  com.google.protobuf.ByteString getTrainingDatasetUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the validationDatasetUri field is set.
   */
  boolean hasValidationDatasetUri();

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The validationDatasetUri.
   */
  java.lang.String getValidationDatasetUri();

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage path to file containing validation dataset for
   * tuning. The dataset must be formatted as a JSONL file.
   * </pre>
   *
   * <code>optional string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for validationDatasetUri.
   */
  com.google.protobuf.ByteString getValidationDatasetUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for Distillation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hyperParameters field is set.
   */
  boolean hasHyperParameters();

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for Distillation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hyperParameters.
   */
  com.google.cloud.aiplatform.v1beta1.DistillationHyperParameters getHyperParameters();

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for Distillation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DistillationHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.DistillationHyperParametersOrBuilder
      getHyperParametersOrBuilder();

  /**
   *
   *
   * <pre>
   * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
   * </pre>
   *
   * <code>string student_model = 4;</code>
   *
   * @return The studentModel.
   */
  java.lang.String getStudentModel();

  /**
   *
   *
   * <pre>
   * The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
   * </pre>
   *
   * <code>string student_model = 4;</code>
   *
   * @return The bytes for studentModel.
   */
  com.google.protobuf.ByteString getStudentModelBytes();

  /**
   *
   *
   * <pre>
   * Required. A path in a Cloud Storage bucket, which will be treated as the
   * root output directory of the distillation pipeline. It is used by the
   * system to generate the paths of output artifacts.
   * </pre>
   *
   * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The pipelineRootDirectory.
   */
  java.lang.String getPipelineRootDirectory();

  /**
   *
   *
   * <pre>
   * Required. A path in a Cloud Storage bucket, which will be treated as the
   * root output directory of the distillation pipeline. It is used by the
   * system to generate the paths of output artifacts.
   * </pre>
   *
   * <code>string pipeline_root_directory = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for pipelineRootDirectory.
   */
  com.google.protobuf.ByteString getPipelineRootDirectoryBytes();

  com.google.cloud.aiplatform.v1beta1.DistillationSpec.TeacherModelCase getTeacherModelCase();
}
