/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/session.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Actions are parts of events that are executed by the agent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.EventActions}
 */
public final class EventActions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EventActions)
    EventActionsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EventActions.newBuilder() to construct.
  private EventActions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EventActions() {
    transferAgent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EventActions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_EventActions_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetArtifactDelta();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_EventActions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.EventActions.class,
            com.google.cloud.aiplatform.v1beta1.EventActions.Builder.class);
  }

  private int bitField0_;
  public static final int SKIP_SUMMARIZATION_FIELD_NUMBER = 1;
  private boolean skipSummarization_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, it won't call model to summarize function response.
   * Only used for function_response event.
   * </pre>
   *
   * <code>bool skip_summarization = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The skipSummarization.
   */
  @java.lang.Override
  public boolean getSkipSummarization() {
    return skipSummarization_;
  }

  public static final int STATE_DELTA_FIELD_NUMBER = 2;
  private com.google.protobuf.Struct stateDelta_;

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating the state with the given
   * delta.
   * </pre>
   *
   * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the stateDelta field is set.
   */
  @java.lang.Override
  public boolean hasStateDelta() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating the state with the given
   * delta.
   * </pre>
   *
   * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The stateDelta.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getStateDelta() {
    return stateDelta_ == null ? com.google.protobuf.Struct.getDefaultInstance() : stateDelta_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating the state with the given
   * delta.
   * </pre>
   *
   * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getStateDeltaOrBuilder() {
    return stateDelta_ == null ? com.google.protobuf.Struct.getDefaultInstance() : stateDelta_;
  }

  public static final int ARTIFACT_DELTA_FIELD_NUMBER = 3;

  private static final class ArtifactDeltaDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.SessionProto
                .internal_static_google_cloud_aiplatform_v1beta1_EventActions_ArtifactDeltaEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> artifactDelta_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetArtifactDelta() {
    if (artifactDelta_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ArtifactDeltaDefaultEntryHolder.defaultEntry);
    }
    return artifactDelta_;
  }

  public int getArtifactDeltaCount() {
    return internalGetArtifactDelta().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating an artifact. key is the
   * filename, value is the version.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsArtifactDelta(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetArtifactDelta().getMap().containsKey(key);
  }

  /** Use {@link #getArtifactDeltaMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getArtifactDelta() {
    return getArtifactDeltaMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating an artifact. key is the
   * filename, value is the version.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getArtifactDeltaMap() {
    return internalGetArtifactDelta().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating an artifact. key is the
   * filename, value is the version.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getArtifactDeltaOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetArtifactDelta().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Indicates that the event is updating an artifact. key is the
   * filename, value is the version.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getArtifactDeltaOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetArtifactDelta().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TRANSFER_TO_AGENT_FIELD_NUMBER = 5;
  private boolean transferToAgent_ = false;

  /**
   *
   *
   * <pre>
   * Deprecated. If set, the event transfers to the specified agent.
   * </pre>
   *
   * <code>bool transfer_to_agent = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.EventActions.transfer_to_agent is deprecated. See
   *     google/cloud/aiplatform/v1beta1/session.proto;l=157
   * @return The transferToAgent.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getTransferToAgent() {
    return transferToAgent_;
  }

  public static final int ESCALATE_FIELD_NUMBER = 6;
  private boolean escalate_ = false;

  /**
   *
   *
   * <pre>
   * Optional. The agent is escalating to a higher level agent.
   * </pre>
   *
   * <code>bool escalate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The escalate.
   */
  @java.lang.Override
  public boolean getEscalate() {
    return escalate_;
  }

  public static final int REQUESTED_AUTH_CONFIGS_FIELD_NUMBER = 7;
  private com.google.protobuf.Struct requestedAuthConfigs_;

  /**
   *
   *
   * <pre>
   * Optional. Will only be set by a tool response indicating tool request euc.
   * Struct key is the function call id since one function call response (from
   * model) could correspond to multiple function calls. Struct value is the
   * required auth config, which can be another struct.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the requestedAuthConfigs field is set.
   */
  @java.lang.Override
  public boolean hasRequestedAuthConfigs() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Will only be set by a tool response indicating tool request euc.
   * Struct key is the function call id since one function call response (from
   * model) could correspond to multiple function calls. Struct value is the
   * required auth config, which can be another struct.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The requestedAuthConfigs.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getRequestedAuthConfigs() {
    return requestedAuthConfigs_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : requestedAuthConfigs_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Will only be set by a tool response indicating tool request euc.
   * Struct key is the function call id since one function call response (from
   * model) could correspond to multiple function calls. Struct value is the
   * required auth config, which can be another struct.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getRequestedAuthConfigsOrBuilder() {
    return requestedAuthConfigs_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : requestedAuthConfigs_;
  }

  public static final int TRANSFER_AGENT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object transferAgent_ = "";

  /**
   *
   *
   * <pre>
   * Optional. If set, the event transfers to the specified agent.
   * </pre>
   *
   * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The transferAgent.
   */
  @java.lang.Override
  public java.lang.String getTransferAgent() {
    java.lang.Object ref = transferAgent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transferAgent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, the event transfers to the specified agent.
   * </pre>
   *
   * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for transferAgent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransferAgentBytes() {
    java.lang.Object ref = transferAgent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transferAgent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (skipSummarization_ != false) {
      output.writeBool(1, skipSummarization_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStateDelta());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetArtifactDelta(), ArtifactDeltaDefaultEntryHolder.defaultEntry, 3);
    if (transferToAgent_ != false) {
      output.writeBool(5, transferToAgent_);
    }
    if (escalate_ != false) {
      output.writeBool(6, escalate_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getRequestedAuthConfigs());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transferAgent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, transferAgent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (skipSummarization_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, skipSummarization_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStateDelta());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetArtifactDelta().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> artifactDelta__ =
          ArtifactDeltaDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, artifactDelta__);
    }
    if (transferToAgent_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, transferToAgent_);
    }
    if (escalate_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, escalate_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRequestedAuthConfigs());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transferAgent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, transferAgent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EventActions)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.EventActions other =
        (com.google.cloud.aiplatform.v1beta1.EventActions) obj;

    if (getSkipSummarization() != other.getSkipSummarization()) return false;
    if (hasStateDelta() != other.hasStateDelta()) return false;
    if (hasStateDelta()) {
      if (!getStateDelta().equals(other.getStateDelta())) return false;
    }
    if (!internalGetArtifactDelta().equals(other.internalGetArtifactDelta())) return false;
    if (getTransferToAgent() != other.getTransferToAgent()) return false;
    if (getEscalate() != other.getEscalate()) return false;
    if (hasRequestedAuthConfigs() != other.hasRequestedAuthConfigs()) return false;
    if (hasRequestedAuthConfigs()) {
      if (!getRequestedAuthConfigs().equals(other.getRequestedAuthConfigs())) return false;
    }
    if (!getTransferAgent().equals(other.getTransferAgent())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SKIP_SUMMARIZATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipSummarization());
    if (hasStateDelta()) {
      hash = (37 * hash) + STATE_DELTA_FIELD_NUMBER;
      hash = (53 * hash) + getStateDelta().hashCode();
    }
    if (!internalGetArtifactDelta().getMap().isEmpty()) {
      hash = (37 * hash) + ARTIFACT_DELTA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetArtifactDelta().hashCode();
    }
    hash = (37 * hash) + TRANSFER_TO_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTransferToAgent());
    hash = (37 * hash) + ESCALATE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEscalate());
    if (hasRequestedAuthConfigs()) {
      hash = (37 * hash) + REQUESTED_AUTH_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedAuthConfigs().hashCode();
    }
    hash = (37 * hash) + TRANSFER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getTransferAgent().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.EventActions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Actions are parts of events that are executed by the agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EventActions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EventActions)
      com.google.cloud.aiplatform.v1beta1.EventActionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_EventActions_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetArtifactDelta();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableArtifactDelta();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_EventActions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EventActions.class,
              com.google.cloud.aiplatform.v1beta1.EventActions.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.EventActions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStateDeltaFieldBuilder();
        getRequestedAuthConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      skipSummarization_ = false;
      stateDelta_ = null;
      if (stateDeltaBuilder_ != null) {
        stateDeltaBuilder_.dispose();
        stateDeltaBuilder_ = null;
      }
      internalGetMutableArtifactDelta().clear();
      transferToAgent_ = false;
      escalate_ = false;
      requestedAuthConfigs_ = null;
      if (requestedAuthConfigsBuilder_ != null) {
        requestedAuthConfigsBuilder_.dispose();
        requestedAuthConfigsBuilder_ = null;
      }
      transferAgent_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_EventActions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EventActions getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EventActions build() {
      com.google.cloud.aiplatform.v1beta1.EventActions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EventActions buildPartial() {
      com.google.cloud.aiplatform.v1beta1.EventActions result =
          new com.google.cloud.aiplatform.v1beta1.EventActions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.EventActions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.skipSummarization_ = skipSummarization_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.stateDelta_ = stateDeltaBuilder_ == null ? stateDelta_ : stateDeltaBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.artifactDelta_ = internalGetArtifactDelta();
        result.artifactDelta_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.transferToAgent_ = transferToAgent_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.escalate_ = escalate_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.requestedAuthConfigs_ =
            requestedAuthConfigsBuilder_ == null
                ? requestedAuthConfigs_
                : requestedAuthConfigsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.transferAgent_ = transferAgent_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.EventActions) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.EventActions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.EventActions other) {
      if (other == com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance())
        return this;
      if (other.getSkipSummarization() != false) {
        setSkipSummarization(other.getSkipSummarization());
      }
      if (other.hasStateDelta()) {
        mergeStateDelta(other.getStateDelta());
      }
      internalGetMutableArtifactDelta().mergeFrom(other.internalGetArtifactDelta());
      bitField0_ |= 0x00000004;
      if (other.getTransferToAgent() != false) {
        setTransferToAgent(other.getTransferToAgent());
      }
      if (other.getEscalate() != false) {
        setEscalate(other.getEscalate());
      }
      if (other.hasRequestedAuthConfigs()) {
        mergeRequestedAuthConfigs(other.getRequestedAuthConfigs());
      }
      if (!other.getTransferAgent().isEmpty()) {
        transferAgent_ = other.transferAgent_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                skipSummarization_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getStateDeltaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> artifactDelta__ =
                    input.readMessage(
                        ArtifactDeltaDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableArtifactDelta()
                    .getMutableMap()
                    .put(artifactDelta__.getKey(), artifactDelta__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 40:
              {
                transferToAgent_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                escalate_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(
                    getRequestedAuthConfigsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                transferAgent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean skipSummarization_;

    /**
     *
     *
     * <pre>
     * Optional. If true, it won't call model to summarize function response.
     * Only used for function_response event.
     * </pre>
     *
     * <code>bool skip_summarization = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The skipSummarization.
     */
    @java.lang.Override
    public boolean getSkipSummarization() {
      return skipSummarization_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, it won't call model to summarize function response.
     * Only used for function_response event.
     * </pre>
     *
     * <code>bool skip_summarization = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The skipSummarization to set.
     * @return This builder for chaining.
     */
    public Builder setSkipSummarization(boolean value) {

      skipSummarization_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, it won't call model to summarize function response.
     * Only used for function_response event.
     * </pre>
     *
     * <code>bool skip_summarization = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipSummarization() {
      bitField0_ = (bitField0_ & ~0x00000001);
      skipSummarization_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct stateDelta_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        stateDeltaBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the stateDelta field is set.
     */
    public boolean hasStateDelta() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The stateDelta.
     */
    public com.google.protobuf.Struct getStateDelta() {
      if (stateDeltaBuilder_ == null) {
        return stateDelta_ == null ? com.google.protobuf.Struct.getDefaultInstance() : stateDelta_;
      } else {
        return stateDeltaBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStateDelta(com.google.protobuf.Struct value) {
      if (stateDeltaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateDelta_ = value;
      } else {
        stateDeltaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStateDelta(com.google.protobuf.Struct.Builder builderForValue) {
      if (stateDeltaBuilder_ == null) {
        stateDelta_ = builderForValue.build();
      } else {
        stateDeltaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeStateDelta(com.google.protobuf.Struct value) {
      if (stateDeltaBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && stateDelta_ != null
            && stateDelta_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getStateDeltaBuilder().mergeFrom(value);
        } else {
          stateDelta_ = value;
        }
      } else {
        stateDeltaBuilder_.mergeFrom(value);
      }
      if (stateDelta_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearStateDelta() {
      bitField0_ = (bitField0_ & ~0x00000002);
      stateDelta_ = null;
      if (stateDeltaBuilder_ != null) {
        stateDeltaBuilder_.dispose();
        stateDeltaBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getStateDeltaBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStateDeltaFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getStateDeltaOrBuilder() {
      if (stateDeltaBuilder_ != null) {
        return stateDeltaBuilder_.getMessageOrBuilder();
      } else {
        return stateDelta_ == null ? com.google.protobuf.Struct.getDefaultInstance() : stateDelta_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating the state with the given
     * delta.
     * </pre>
     *
     * <code>.google.protobuf.Struct state_delta = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getStateDeltaFieldBuilder() {
      if (stateDeltaBuilder_ == null) {
        stateDeltaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getStateDelta(), getParentForChildren(), isClean());
        stateDelta_ = null;
      }
      return stateDeltaBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> artifactDelta_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetArtifactDelta() {
      if (artifactDelta_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ArtifactDeltaDefaultEntryHolder.defaultEntry);
      }
      return artifactDelta_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableArtifactDelta() {
      if (artifactDelta_ == null) {
        artifactDelta_ =
            com.google.protobuf.MapField.newMapField(ArtifactDeltaDefaultEntryHolder.defaultEntry);
      }
      if (!artifactDelta_.isMutable()) {
        artifactDelta_ = artifactDelta_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return artifactDelta_;
    }

    public int getArtifactDeltaCount() {
      return internalGetArtifactDelta().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsArtifactDelta(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetArtifactDelta().getMap().containsKey(key);
    }

    /** Use {@link #getArtifactDeltaMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getArtifactDelta() {
      return getArtifactDeltaMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getArtifactDeltaMap() {
      return internalGetArtifactDelta().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getArtifactDeltaOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetArtifactDelta().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getArtifactDeltaOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetArtifactDelta().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearArtifactDelta() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableArtifactDelta().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeArtifactDelta(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableArtifactDelta().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableArtifactDelta() {
      bitField0_ |= 0x00000004;
      return internalGetMutableArtifactDelta().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putArtifactDelta(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableArtifactDelta().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates that the event is updating an artifact. key is the
     * filename, value is the version.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; artifact_delta = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllArtifactDelta(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableArtifactDelta().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private boolean transferToAgent_;

    /**
     *
     *
     * <pre>
     * Deprecated. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>bool transfer_to_agent = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.EventActions.transfer_to_agent is deprecated. See
     *     google/cloud/aiplatform/v1beta1/session.proto;l=157
     * @return The transferToAgent.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getTransferToAgent() {
      return transferToAgent_;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>bool transfer_to_agent = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.EventActions.transfer_to_agent is deprecated. See
     *     google/cloud/aiplatform/v1beta1/session.proto;l=157
     * @param value The transferToAgent to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTransferToAgent(boolean value) {

      transferToAgent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>bool transfer_to_agent = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.EventActions.transfer_to_agent is deprecated. See
     *     google/cloud/aiplatform/v1beta1/session.proto;l=157
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearTransferToAgent() {
      bitField0_ = (bitField0_ & ~0x00000008);
      transferToAgent_ = false;
      onChanged();
      return this;
    }

    private boolean escalate_;

    /**
     *
     *
     * <pre>
     * Optional. The agent is escalating to a higher level agent.
     * </pre>
     *
     * <code>bool escalate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The escalate.
     */
    @java.lang.Override
    public boolean getEscalate() {
      return escalate_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The agent is escalating to a higher level agent.
     * </pre>
     *
     * <code>bool escalate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The escalate to set.
     * @return This builder for chaining.
     */
    public Builder setEscalate(boolean value) {

      escalate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The agent is escalating to a higher level agent.
     * </pre>
     *
     * <code>bool escalate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEscalate() {
      bitField0_ = (bitField0_ & ~0x00000010);
      escalate_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct requestedAuthConfigs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        requestedAuthConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the requestedAuthConfigs field is set.
     */
    public boolean hasRequestedAuthConfigs() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The requestedAuthConfigs.
     */
    public com.google.protobuf.Struct getRequestedAuthConfigs() {
      if (requestedAuthConfigsBuilder_ == null) {
        return requestedAuthConfigs_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : requestedAuthConfigs_;
      } else {
        return requestedAuthConfigsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRequestedAuthConfigs(com.google.protobuf.Struct value) {
      if (requestedAuthConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestedAuthConfigs_ = value;
      } else {
        requestedAuthConfigsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRequestedAuthConfigs(com.google.protobuf.Struct.Builder builderForValue) {
      if (requestedAuthConfigsBuilder_ == null) {
        requestedAuthConfigs_ = builderForValue.build();
      } else {
        requestedAuthConfigsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRequestedAuthConfigs(com.google.protobuf.Struct value) {
      if (requestedAuthConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && requestedAuthConfigs_ != null
            && requestedAuthConfigs_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getRequestedAuthConfigsBuilder().mergeFrom(value);
        } else {
          requestedAuthConfigs_ = value;
        }
      } else {
        requestedAuthConfigsBuilder_.mergeFrom(value);
      }
      if (requestedAuthConfigs_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRequestedAuthConfigs() {
      bitField0_ = (bitField0_ & ~0x00000020);
      requestedAuthConfigs_ = null;
      if (requestedAuthConfigsBuilder_ != null) {
        requestedAuthConfigsBuilder_.dispose();
        requestedAuthConfigsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getRequestedAuthConfigsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRequestedAuthConfigsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getRequestedAuthConfigsOrBuilder() {
      if (requestedAuthConfigsBuilder_ != null) {
        return requestedAuthConfigsBuilder_.getMessageOrBuilder();
      } else {
        return requestedAuthConfigs_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : requestedAuthConfigs_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Will only be set by a tool response indicating tool request euc.
     * Struct key is the function call id since one function call response (from
     * model) could correspond to multiple function calls. Struct value is the
     * required auth config, which can be another struct.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct requested_auth_configs = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getRequestedAuthConfigsFieldBuilder() {
      if (requestedAuthConfigsBuilder_ == null) {
        requestedAuthConfigsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getRequestedAuthConfigs(), getParentForChildren(), isClean());
        requestedAuthConfigs_ = null;
      }
      return requestedAuthConfigsBuilder_;
    }

    private java.lang.Object transferAgent_ = "";

    /**
     *
     *
     * <pre>
     * Optional. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The transferAgent.
     */
    public java.lang.String getTransferAgent() {
      java.lang.Object ref = transferAgent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transferAgent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for transferAgent.
     */
    public com.google.protobuf.ByteString getTransferAgentBytes() {
      java.lang.Object ref = transferAgent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transferAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The transferAgent to set.
     * @return This builder for chaining.
     */
    public Builder setTransferAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transferAgent_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransferAgent() {
      transferAgent_ = getDefaultInstance().getTransferAgent();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, the event transfers to the specified agent.
     * </pre>
     *
     * <code>string transfer_agent = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for transferAgent to set.
     * @return This builder for chaining.
     */
    public Builder setTransferAgentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      transferAgent_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EventActions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EventActions)
  private static final com.google.cloud.aiplatform.v1beta1.EventActions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EventActions();
  }

  public static com.google.cloud.aiplatform.v1beta1.EventActions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EventActions> PARSER =
      new com.google.protobuf.AbstractParser<EventActions>() {
        @java.lang.Override
        public EventActions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EventActions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EventActions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EventActions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
