/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/session.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata relating to a LLM response event.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.EventMetadata}
 */
public final class EventMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EventMetadata)
    EventMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EventMetadata.newBuilder() to construct.
  private EventMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EventMetadata() {
    longRunningToolIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    branch_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EventMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_EventMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_EventMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.EventMetadata.class,
            com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int GROUNDING_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.GroundingMetadata groundingMetadata_;

  /**
   *
   *
   * <pre>
   * Optional. Metadata returned to client when grounding is enabled.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the groundingMetadata field is set.
   */
  @java.lang.Override
  public boolean hasGroundingMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata returned to client when grounding is enabled.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The groundingMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingMetadata getGroundingMetadata() {
    return groundingMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance()
        : groundingMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata returned to client when grounding is enabled.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingMetadataOrBuilder
      getGroundingMetadataOrBuilder() {
    return groundingMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance()
        : groundingMetadata_;
  }

  public static final int PARTIAL_FIELD_NUMBER = 2;
  private boolean partial_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Indicates whether the text content is part of a unfinished text
   * stream. Only used for streaming mode and when the content is plain text.
   * </pre>
   *
   * <code>bool partial = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The partial.
   */
  @java.lang.Override
  public boolean getPartial() {
    return partial_;
  }

  public static final int TURN_COMPLETE_FIELD_NUMBER = 3;
  private boolean turnComplete_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Indicates whether the response from the model is complete.
   * Only used for streaming mode.
   * </pre>
   *
   * <code>bool turn_complete = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The turnComplete.
   */
  @java.lang.Override
  public boolean getTurnComplete() {
    return turnComplete_;
  }

  public static final int INTERRUPTED_FIELD_NUMBER = 4;
  private boolean interrupted_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Flag indicating that LLM was interrupted when generating the
   * content. Usually it's due to user interruption during a bidi streaming.
   * </pre>
   *
   * <code>bool interrupted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The interrupted.
   */
  @java.lang.Override
  public boolean getInterrupted() {
    return interrupted_;
  }

  public static final int LONG_RUNNING_TOOL_IDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList longRunningToolIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Set of ids of the long running function calls.
   * Agent client will know from this field about which function call is long
   * running. Only valid for function call event.
   * </pre>
   *
   * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the longRunningToolIds.
   */
  public com.google.protobuf.ProtocolStringList getLongRunningToolIdsList() {
    return longRunningToolIds_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Set of ids of the long running function calls.
   * Agent client will know from this field about which function call is long
   * running. Only valid for function call event.
   * </pre>
   *
   * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of longRunningToolIds.
   */
  public int getLongRunningToolIdsCount() {
    return longRunningToolIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Set of ids of the long running function calls.
   * Agent client will know from this field about which function call is long
   * running. Only valid for function call event.
   * </pre>
   *
   * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The longRunningToolIds at the given index.
   */
  public java.lang.String getLongRunningToolIds(int index) {
    return longRunningToolIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Set of ids of the long running function calls.
   * Agent client will know from this field about which function call is long
   * running. Only valid for function call event.
   * </pre>
   *
   * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the longRunningToolIds at the given index.
   */
  public com.google.protobuf.ByteString getLongRunningToolIdsBytes(int index) {
    return longRunningToolIds_.getByteString(index);
  }

  public static final int BRANCH_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object branch_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The branch of the event.
   * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
   * agent_2, and agent_2 is the parent of agent_3.
   * Branch is used when multiple child agents shouldn't see their siblings'
   * conversation history.
   * </pre>
   *
   * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The branch.
   */
  @java.lang.Override
  public java.lang.String getBranch() {
    java.lang.Object ref = branch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      branch_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The branch of the event.
   * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
   * agent_2, and agent_2 is the parent of agent_3.
   * Branch is used when multiple child agents shouldn't see their siblings'
   * conversation history.
   * </pre>
   *
   * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for branch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBranchBytes() {
    java.lang.Object ref = branch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      branch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getGroundingMetadata());
    }
    if (partial_ != false) {
      output.writeBool(2, partial_);
    }
    if (turnComplete_ != false) {
      output.writeBool(3, turnComplete_);
    }
    if (interrupted_ != false) {
      output.writeBool(4, interrupted_);
    }
    for (int i = 0; i < longRunningToolIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, longRunningToolIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branch_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, branch_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGroundingMetadata());
    }
    if (partial_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, partial_);
    }
    if (turnComplete_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, turnComplete_);
    }
    if (interrupted_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, interrupted_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < longRunningToolIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(longRunningToolIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLongRunningToolIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branch_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, branch_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EventMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.EventMetadata other =
        (com.google.cloud.aiplatform.v1beta1.EventMetadata) obj;

    if (hasGroundingMetadata() != other.hasGroundingMetadata()) return false;
    if (hasGroundingMetadata()) {
      if (!getGroundingMetadata().equals(other.getGroundingMetadata())) return false;
    }
    if (getPartial() != other.getPartial()) return false;
    if (getTurnComplete() != other.getTurnComplete()) return false;
    if (getInterrupted() != other.getInterrupted()) return false;
    if (!getLongRunningToolIdsList().equals(other.getLongRunningToolIdsList())) return false;
    if (!getBranch().equals(other.getBranch())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGroundingMetadata()) {
      hash = (37 * hash) + GROUNDING_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingMetadata().hashCode();
    }
    hash = (37 * hash) + PARTIAL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPartial());
    hash = (37 * hash) + TURN_COMPLETE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTurnComplete());
    hash = (37 * hash) + INTERRUPTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInterrupted());
    if (getLongRunningToolIdsCount() > 0) {
      hash = (37 * hash) + LONG_RUNNING_TOOL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getLongRunningToolIdsList().hashCode();
    }
    hash = (37 * hash) + BRANCH_FIELD_NUMBER;
    hash = (53 * hash) + getBranch().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.EventMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata relating to a LLM response event.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EventMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EventMetadata)
      com.google.cloud.aiplatform.v1beta1.EventMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_EventMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_EventMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EventMetadata.class,
              com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.EventMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGroundingMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      groundingMetadata_ = null;
      if (groundingMetadataBuilder_ != null) {
        groundingMetadataBuilder_.dispose();
        groundingMetadataBuilder_ = null;
      }
      partial_ = false;
      turnComplete_ = false;
      interrupted_ = false;
      longRunningToolIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      branch_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_EventMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EventMetadata getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EventMetadata build() {
      com.google.cloud.aiplatform.v1beta1.EventMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EventMetadata buildPartial() {
      com.google.cloud.aiplatform.v1beta1.EventMetadata result =
          new com.google.cloud.aiplatform.v1beta1.EventMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.EventMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.groundingMetadata_ =
            groundingMetadataBuilder_ == null
                ? groundingMetadata_
                : groundingMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.partial_ = partial_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.turnComplete_ = turnComplete_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.interrupted_ = interrupted_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        longRunningToolIds_.makeImmutable();
        result.longRunningToolIds_ = longRunningToolIds_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.branch_ = branch_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.EventMetadata) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.EventMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.EventMetadata other) {
      if (other == com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance())
        return this;
      if (other.hasGroundingMetadata()) {
        mergeGroundingMetadata(other.getGroundingMetadata());
      }
      if (other.getPartial() != false) {
        setPartial(other.getPartial());
      }
      if (other.getTurnComplete() != false) {
        setTurnComplete(other.getTurnComplete());
      }
      if (other.getInterrupted() != false) {
        setInterrupted(other.getInterrupted());
      }
      if (!other.longRunningToolIds_.isEmpty()) {
        if (longRunningToolIds_.isEmpty()) {
          longRunningToolIds_ = other.longRunningToolIds_;
          bitField0_ |= 0x00000010;
        } else {
          ensureLongRunningToolIdsIsMutable();
          longRunningToolIds_.addAll(other.longRunningToolIds_);
        }
        onChanged();
      }
      if (!other.getBranch().isEmpty()) {
        branch_ = other.branch_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getGroundingMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                partial_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                turnComplete_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                interrupted_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLongRunningToolIdsIsMutable();
                longRunningToolIds_.add(s);
                break;
              } // case 42
            case 50:
              {
                branch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.GroundingMetadata groundingMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundingMetadata,
            com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundingMetadataOrBuilder>
        groundingMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the groundingMetadata field is set.
     */
    public boolean hasGroundingMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The groundingMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingMetadata getGroundingMetadata() {
      if (groundingMetadataBuilder_ == null) {
        return groundingMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance()
            : groundingMetadata_;
      } else {
        return groundingMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingMetadata(
        com.google.cloud.aiplatform.v1beta1.GroundingMetadata value) {
      if (groundingMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        groundingMetadata_ = value;
      } else {
        groundingMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingMetadata(
        com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder builderForValue) {
      if (groundingMetadataBuilder_ == null) {
        groundingMetadata_ = builderForValue.build();
      } else {
        groundingMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGroundingMetadata(
        com.google.cloud.aiplatform.v1beta1.GroundingMetadata value) {
      if (groundingMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && groundingMetadata_ != null
            && groundingMetadata_
                != com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance()) {
          getGroundingMetadataBuilder().mergeFrom(value);
        } else {
          groundingMetadata_ = value;
        }
      } else {
        groundingMetadataBuilder_.mergeFrom(value);
      }
      if (groundingMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGroundingMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      groundingMetadata_ = null;
      if (groundingMetadataBuilder_ != null) {
        groundingMetadataBuilder_.dispose();
        groundingMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder
        getGroundingMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getGroundingMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingMetadataOrBuilder
        getGroundingMetadataOrBuilder() {
      if (groundingMetadataBuilder_ != null) {
        return groundingMetadataBuilder_.getMessageOrBuilder();
      } else {
        return groundingMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance()
            : groundingMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata returned to client when grounding is enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GroundingMetadata grounding_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundingMetadata,
            com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundingMetadataOrBuilder>
        getGroundingMetadataFieldBuilder() {
      if (groundingMetadataBuilder_ == null) {
        groundingMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GroundingMetadata,
                com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.GroundingMetadataOrBuilder>(
                getGroundingMetadata(), getParentForChildren(), isClean());
        groundingMetadata_ = null;
      }
      return groundingMetadataBuilder_;
    }

    private boolean partial_;

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the text content is part of a unfinished text
     * stream. Only used for streaming mode and when the content is plain text.
     * </pre>
     *
     * <code>bool partial = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The partial.
     */
    @java.lang.Override
    public boolean getPartial() {
      return partial_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the text content is part of a unfinished text
     * stream. Only used for streaming mode and when the content is plain text.
     * </pre>
     *
     * <code>bool partial = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The partial to set.
     * @return This builder for chaining.
     */
    public Builder setPartial(boolean value) {

      partial_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the text content is part of a unfinished text
     * stream. Only used for streaming mode and when the content is plain text.
     * </pre>
     *
     * <code>bool partial = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartial() {
      bitField0_ = (bitField0_ & ~0x00000002);
      partial_ = false;
      onChanged();
      return this;
    }

    private boolean turnComplete_;

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the response from the model is complete.
     * Only used for streaming mode.
     * </pre>
     *
     * <code>bool turn_complete = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The turnComplete.
     */
    @java.lang.Override
    public boolean getTurnComplete() {
      return turnComplete_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the response from the model is complete.
     * Only used for streaming mode.
     * </pre>
     *
     * <code>bool turn_complete = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The turnComplete to set.
     * @return This builder for chaining.
     */
    public Builder setTurnComplete(boolean value) {

      turnComplete_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the response from the model is complete.
     * Only used for streaming mode.
     * </pre>
     *
     * <code>bool turn_complete = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTurnComplete() {
      bitField0_ = (bitField0_ & ~0x00000004);
      turnComplete_ = false;
      onChanged();
      return this;
    }

    private boolean interrupted_;

    /**
     *
     *
     * <pre>
     * Optional. Flag indicating that LLM was interrupted when generating the
     * content. Usually it's due to user interruption during a bidi streaming.
     * </pre>
     *
     * <code>bool interrupted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The interrupted.
     */
    @java.lang.Override
    public boolean getInterrupted() {
      return interrupted_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Flag indicating that LLM was interrupted when generating the
     * content. Usually it's due to user interruption during a bidi streaming.
     * </pre>
     *
     * <code>bool interrupted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The interrupted to set.
     * @return This builder for chaining.
     */
    public Builder setInterrupted(boolean value) {

      interrupted_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Flag indicating that LLM was interrupted when generating the
     * content. Usually it's due to user interruption during a bidi streaming.
     * </pre>
     *
     * <code>bool interrupted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterrupted() {
      bitField0_ = (bitField0_ & ~0x00000008);
      interrupted_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList longRunningToolIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLongRunningToolIdsIsMutable() {
      if (!longRunningToolIds_.isModifiable()) {
        longRunningToolIds_ = new com.google.protobuf.LazyStringArrayList(longRunningToolIds_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the longRunningToolIds.
     */
    public com.google.protobuf.ProtocolStringList getLongRunningToolIdsList() {
      longRunningToolIds_.makeImmutable();
      return longRunningToolIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of longRunningToolIds.
     */
    public int getLongRunningToolIdsCount() {
      return longRunningToolIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The longRunningToolIds at the given index.
     */
    public java.lang.String getLongRunningToolIds(int index) {
      return longRunningToolIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the longRunningToolIds at the given index.
     */
    public com.google.protobuf.ByteString getLongRunningToolIdsBytes(int index) {
      return longRunningToolIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The longRunningToolIds to set.
     * @return This builder for chaining.
     */
    public Builder setLongRunningToolIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLongRunningToolIdsIsMutable();
      longRunningToolIds_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The longRunningToolIds to add.
     * @return This builder for chaining.
     */
    public Builder addLongRunningToolIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLongRunningToolIdsIsMutable();
      longRunningToolIds_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The longRunningToolIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllLongRunningToolIds(java.lang.Iterable<java.lang.String> values) {
      ensureLongRunningToolIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, longRunningToolIds_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLongRunningToolIds() {
      longRunningToolIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Set of ids of the long running function calls.
     * Agent client will know from this field about which function call is long
     * running. Only valid for function call event.
     * </pre>
     *
     * <code>repeated string long_running_tool_ids = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the longRunningToolIds to add.
     * @return This builder for chaining.
     */
    public Builder addLongRunningToolIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLongRunningToolIdsIsMutable();
      longRunningToolIds_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object branch_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The branch of the event.
     * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
     * agent_2, and agent_2 is the parent of agent_3.
     * Branch is used when multiple child agents shouldn't see their siblings'
     * conversation history.
     * </pre>
     *
     * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The branch.
     */
    public java.lang.String getBranch() {
      java.lang.Object ref = branch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        branch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The branch of the event.
     * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
     * agent_2, and agent_2 is the parent of agent_3.
     * Branch is used when multiple child agents shouldn't see their siblings'
     * conversation history.
     * </pre>
     *
     * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for branch.
     */
    public com.google.protobuf.ByteString getBranchBytes() {
      java.lang.Object ref = branch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        branch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The branch of the event.
     * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
     * agent_2, and agent_2 is the parent of agent_3.
     * Branch is used when multiple child agents shouldn't see their siblings'
     * conversation history.
     * </pre>
     *
     * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The branch to set.
     * @return This builder for chaining.
     */
    public Builder setBranch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      branch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The branch of the event.
     * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
     * agent_2, and agent_2 is the parent of agent_3.
     * Branch is used when multiple child agents shouldn't see their siblings'
     * conversation history.
     * </pre>
     *
     * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranch() {
      branch_ = getDefaultInstance().getBranch();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The branch of the event.
     * The format is like agent_1.agent_2.agent_3, where agent_1 is the parent of
     * agent_2, and agent_2 is the parent of agent_3.
     * Branch is used when multiple child agents shouldn't see their siblings'
     * conversation history.
     * </pre>
     *
     * <code>string branch = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for branch to set.
     * @return This builder for chaining.
     */
    public Builder setBranchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      branch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EventMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EventMetadata)
  private static final com.google.cloud.aiplatform.v1beta1.EventMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EventMetadata();
  }

  public static com.google.cloud.aiplatform.v1beta1.EventMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EventMetadata> PARSER =
      new com.google.protobuf.AbstractParser<EventMetadata>() {
        @java.lang.Override
        public EventMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EventMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EventMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EventMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
