/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/example_store.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Filters for examples' array metadata fields. An array field is example
 * metadata where multiple values are attributed to a single example.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExamplesArrayFilter}
 */
public final class ExamplesArrayFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ExamplesArrayFilter)
    ExamplesArrayFilterOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ExamplesArrayFilter.newBuilder() to construct.
  private ExamplesArrayFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExamplesArrayFilter() {
    values_ = com.google.protobuf.LazyStringArrayList.emptyList();
    arrayOperator_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExamplesArrayFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExamplesArrayFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExamplesArrayFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.class,
            com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The logic to use for filtering.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator}
   */
  public enum ArrayOperator implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should not be used.
     * </pre>
     *
     * <code>ARRAY_OPERATOR_UNSPECIFIED = 0;</code>
     */
    ARRAY_OPERATOR_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The metadata array field in the example must contain at least one of the
     * values.
     * </pre>
     *
     * <code>CONTAINS_ANY = 1;</code>
     */
    CONTAINS_ANY(1),
    /**
     *
     *
     * <pre>
     * The metadata array field in the example must contain all of the values.
     * </pre>
     *
     * <code>CONTAINS_ALL = 2;</code>
     */
    CONTAINS_ALL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should not be used.
     * </pre>
     *
     * <code>ARRAY_OPERATOR_UNSPECIFIED = 0;</code>
     */
    public static final int ARRAY_OPERATOR_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The metadata array field in the example must contain at least one of the
     * values.
     * </pre>
     *
     * <code>CONTAINS_ANY = 1;</code>
     */
    public static final int CONTAINS_ANY_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The metadata array field in the example must contain all of the values.
     * </pre>
     *
     * <code>CONTAINS_ALL = 2;</code>
     */
    public static final int CONTAINS_ALL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ArrayOperator valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ArrayOperator forNumber(int value) {
      switch (value) {
        case 0:
          return ARRAY_OPERATOR_UNSPECIFIED;
        case 1:
          return CONTAINS_ANY;
        case 2:
          return CONTAINS_ALL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ArrayOperator> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ArrayOperator> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ArrayOperator>() {
          public ArrayOperator findValueByNumber(int number) {
            return ArrayOperator.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ArrayOperator[] VALUES = values();

    public static ArrayOperator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ArrayOperator(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator)
  }

  public static final int VALUES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList values_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Required. The values by which to filter examples.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the values.
   */
  public com.google.protobuf.ProtocolStringList getValuesList() {
    return values_;
  }

  /**
   *
   *
   * <pre>
   * Required. The values by which to filter examples.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of values.
   */
  public int getValuesCount() {
    return values_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The values by which to filter examples.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The values at the given index.
   */
  public java.lang.String getValues(int index) {
    return values_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The values by which to filter examples.
   * </pre>
   *
   * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the values at the given index.
   */
  public com.google.protobuf.ByteString getValuesBytes(int index) {
    return values_.getByteString(index);
  }

  public static final int ARRAY_OPERATOR_FIELD_NUMBER = 2;
  private int arrayOperator_ = 0;

  /**
   *
   *
   * <pre>
   * Required. The operator logic to use for filtering.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for arrayOperator.
   */
  @java.lang.Override
  public int getArrayOperatorValue() {
    return arrayOperator_;
  }

  /**
   *
   *
   * <pre>
   * Required. The operator logic to use for filtering.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The arrayOperator.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator getArrayOperator() {
    com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator result =
        com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator.forNumber(
            arrayOperator_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < values_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
    }
    if (arrayOperator_
        != com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator
            .ARRAY_OPERATOR_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, arrayOperator_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < values_.size(); i++) {
        dataSize += computeStringSizeNoTag(values_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getValuesList().size();
    }
    if (arrayOperator_
        != com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator
            .ARRAY_OPERATOR_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, arrayOperator_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter other =
        (com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter) obj;

    if (!getValuesList().equals(other.getValuesList())) return false;
    if (arrayOperator_ != other.arrayOperator_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getValuesCount() > 0) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getValuesList().hashCode();
    }
    hash = (37 * hash) + ARRAY_OPERATOR_FIELD_NUMBER;
    hash = (53 * hash) + arrayOperator_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Filters for examples' array metadata fields. An array field is example
   * metadata where multiple values are attributed to a single example.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExamplesArrayFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ExamplesArrayFilter)
      com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExamplesArrayFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExamplesArrayFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.class,
              com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      arrayOperator_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExamplesArrayFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter build() {
      com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter result =
          new com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        values_.makeImmutable();
        result.values_ = values_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.arrayOperator_ = arrayOperator_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.getDefaultInstance())
        return this;
      if (!other.values_.isEmpty()) {
        if (values_.isEmpty()) {
          values_ = other.values_;
          bitField0_ |= 0x00000001;
        } else {
          ensureValuesIsMutable();
          values_.addAll(other.values_);
        }
        onChanged();
      }
      if (other.arrayOperator_ != 0) {
        setArrayOperatorValue(other.getArrayOperatorValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureValuesIsMutable();
                values_.add(s);
                break;
              } // case 10
            case 16:
              {
                arrayOperator_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList values_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureValuesIsMutable() {
      if (!values_.isModifiable()) {
        values_ = new com.google.protobuf.LazyStringArrayList(values_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the values.
     */
    public com.google.protobuf.ProtocolStringList getValuesList() {
      values_.makeImmutable();
      return values_;
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of values.
     */
    public int getValuesCount() {
      return values_.size();
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    public java.lang.String getValues(int index) {
      return values_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the values at the given index.
     */
    public com.google.protobuf.ByteString getValuesBytes(int index) {
      return values_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The values to set.
     * @return This builder for chaining.
     */
    public Builder setValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValuesIsMutable();
      values_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The values to add.
     * @return This builder for chaining.
     */
    public Builder addValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValuesIsMutable();
      values_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The values to add.
     * @return This builder for chaining.
     */
    public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
      ensureValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValues() {
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The values by which to filter examples.
     * </pre>
     *
     * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the values to add.
     * @return This builder for chaining.
     */
    public Builder addValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureValuesIsMutable();
      values_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int arrayOperator_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The operator logic to use for filtering.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for arrayOperator.
     */
    @java.lang.Override
    public int getArrayOperatorValue() {
      return arrayOperator_;
    }

    /**
     *
     *
     * <pre>
     * Required. The operator logic to use for filtering.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for arrayOperator to set.
     * @return This builder for chaining.
     */
    public Builder setArrayOperatorValue(int value) {
      arrayOperator_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The operator logic to use for filtering.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The arrayOperator.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator
        getArrayOperator() {
      com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator result =
          com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator.forNumber(
              arrayOperator_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Required. The operator logic to use for filtering.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The arrayOperator to set.
     * @return This builder for chaining.
     */
    public Builder setArrayOperator(
        com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      arrayOperator_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The operator logic to use for filtering.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExamplesArrayFilter.ArrayOperator array_operator = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArrayOperator() {
      bitField0_ = (bitField0_ & ~0x00000002);
      arrayOperator_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ExamplesArrayFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ExamplesArrayFilter)
  private static final com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter();
  }

  public static com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExamplesArrayFilter> PARSER =
      new com.google.protobuf.AbstractParser<ExamplesArrayFilter>() {
        @java.lang.Override
        public ExamplesArrayFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExamplesArrayFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExamplesArrayFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExamplesArrayFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
