/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/memory_bank_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest}
 */
public final class GenerateMemoriesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest)
    GenerateMemoriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateMemoriesRequest.newBuilder() to construct.
  private GenerateMemoriesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateMemoriesRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateMemoriesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetScope();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.class,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.Builder.class);
  }

  public interface VertexSessionSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Session to generate memories for.
     * Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    java.lang.String getSession();

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Session to generate memories for.
     * Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    com.google.protobuf.ByteString getSessionBytes();

    /**
     *
     *
     * <pre>
     * Optional. Time range to define which session events should be used to
     * generate memories. Start time (inclusive) of the time range. If not set,
     * the start time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();

    /**
     *
     *
     * <pre>
     * Optional. Time range to define which session events should be used to
     * generate memories. Start time (inclusive) of the time range. If not set,
     * the start time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();

    /**
     *
     *
     * <pre>
     * Optional. Time range to define which session events should be used to
     * generate memories. Start time (inclusive) of the time range. If not set,
     * the start time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive) of the time range. If not set, the end
     * time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();

    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive) of the time range. If not set, the end
     * time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();

    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive) of the time range. If not set, the end
     * time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Defines an Agent Engine Session from which to generate the memories. If
   * `scope` is not provided, the scope will be extracted from the Session
   * (i.e. {"user_id": sesison.user_id}).
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource}
   */
  public static final class VertexSessionSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
      VertexSessionSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use VertexSessionSource.newBuilder() to construct.
    private VertexSessionSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VertexSessionSource() {
      session_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VertexSessionSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_VertexSessionSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_VertexSessionSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.class,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                  .Builder.class);
    }

    private int bitField0_;
    public static final int SESSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object session_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Session to generate memories for.
     * Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    @java.lang.Override
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Session to generate memories for.
     * Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int START_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp startTime_;

    /**
     *
     *
     * <pre>
     * Optional. Time range to define which session events should be used to
     * generate memories. Start time (inclusive) of the time range. If not set,
     * the start time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Time range to define which session events should be used to
     * generate memories. Start time (inclusive) of the time range. If not set,
     * the start time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Time range to define which session events should be used to
     * generate memories. Start time (inclusive) of the time range. If not set,
     * the start time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }

    public static final int END_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp endTime_;

    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive) of the time range. If not set, the end
     * time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive) of the time range. If not set, the end
     * time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }

    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive) of the time range. If not set, the end
     * time is unbounded.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getStartTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getEndTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource other =
          (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource) obj;

      if (!getSession().equals(other.getSession())) return false;
      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SESSION_FIELD_NUMBER;
      hash = (53 * hash) + getSession().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Defines an Agent Engine Session from which to generate the memories. If
     * `scope` is not provided, the scope will be extracted from the Session
     * (i.e. {"user_id": sesison.user_id}).
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_VertexSessionSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_VertexSessionSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                    .class,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStartTimeFieldBuilder();
          getEndTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        session_ = "";
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_VertexSessionSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
          build() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource result =
            new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.session_ = session_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                .getDefaultInstance()) return this;
        if (!other.getSession().isEmpty()) {
          session_ = other.session_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  session_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object session_ = "";

      /**
       *
       *
       * <pre>
       * Required. The resource name of the Session to generate memories for.
       * Format:
       * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
       * </pre>
       *
       * <code>
       * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The session.
       */
      public java.lang.String getSession() {
        java.lang.Object ref = session_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          session_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the Session to generate memories for.
       * Format:
       * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
       * </pre>
       *
       * <code>
       * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for session.
       */
      public com.google.protobuf.ByteString getSessionBytes() {
        java.lang.Object ref = session_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          session_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the Session to generate memories for.
       * Format:
       * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
       * </pre>
       *
       * <code>
       * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The session to set.
       * @return This builder for chaining.
       */
      public Builder setSession(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        session_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the Session to generate memories for.
       * Format:
       * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
       * </pre>
       *
       * <code>
       * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSession() {
        session_ = getDefaultInstance().getSession();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the Session to generate memories for.
       * Format:
       * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
       * </pre>
       *
       * <code>
       * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for session to set.
       * @return This builder for chaining.
       */
      public Builder setSessionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        session_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
        } else {
          startTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && startTime_ != null
              && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStartTimeBuilder().mergeFrom(value);
          } else {
            startTime_ = value;
          }
        } else {
          startTimeBuilder_.mergeFrom(value);
        }
        if (startTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearStartTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Time range to define which session events should be used to
       * generate memories. Start time (inclusive) of the time range. If not set,
       * the start time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
        } else {
          endTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && endTime_ != null
              && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEndTimeBuilder().mergeFrom(value);
          } else {
            endTime_ = value;
          }
        } else {
          endTimeBuilder_.mergeFrom(value);
        }
        if (endTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEndTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. End time (exclusive) of the time range. If not set, the end
       * time is unbounded.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
    private static final com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
            .VertexSessionSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VertexSessionSource> PARSER =
        new com.google.protobuf.AbstractParser<VertexSessionSource>() {
          @java.lang.Override
          public VertexSessionSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VertexSessionSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VertexSessionSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DirectContentsSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event>
        getEventsList();

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
        getEvents(int index);

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getEventsCount();

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .EventOrBuilder>
        getEventsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.EventOrBuilder
        getEventsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * Defines a direct source of content from which to generate the memories.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource}
   */
  public static final class DirectContentsSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
      DirectContentsSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DirectContentsSource.newBuilder() to construct.
    private DirectContentsSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DirectContentsSource() {
      events_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DirectContentsSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .class,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Builder.class);
    }

    public interface EventOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A single piece of content from which to generate memories.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the content field is set.
       */
      boolean hasContent();

      /**
       *
       *
       * <pre>
       * Required. A single piece of content from which to generate memories.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The content.
       */
      com.google.cloud.aiplatform.v1beta1.Content getContent();

      /**
       *
       *
       * <pre>
       * Required. A single piece of content from which to generate memories.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * A single piece of conversation from which to generate memories.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event}
     */
    public static final class Event extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event)
        EventOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use Event.newBuilder() to construct.
      private Event(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Event() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Event();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_Event_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_Event_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .Event.class,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .Event.Builder.class);
      }

      private int bitField0_;
      public static final int CONTENT_FIELD_NUMBER = 1;
      private com.google.cloud.aiplatform.v1beta1.Content content_;

      /**
       *
       *
       * <pre>
       * Required. A single piece of content from which to generate memories.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the content field is set.
       */
      @java.lang.Override
      public boolean hasContent() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. A single piece of content from which to generate memories.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The content.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Content getContent() {
        return content_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : content_;
      }

      /**
       *
       *
       * <pre>
       * Required. A single piece of content from which to generate memories.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentOrBuilder() {
        return content_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : content_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getContent());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getContent());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Event)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
            other =
                (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                        .Event)
                    obj;

        if (hasContent() != other.hasContent()) return false;
        if (hasContent()) {
          if (!getContent().equals(other.getContent())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasContent()) {
          hash = (37 * hash) + CONTENT_FIELD_NUMBER;
          hash = (53 * hash) + getContent().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A single piece of conversation from which to generate memories.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event)
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .EventOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_Event_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_Event_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .Event.class,
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .Event.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getContentFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          content_ = null;
          if (contentBuilder_ != null) {
            contentBuilder_.dispose();
            contentBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_Event_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Event
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Event
            build() {
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Event
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              result =
                  new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                      .DirectContentsSource.Event(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Event) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                        .Event)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Event.getDefaultInstance()) return this;
          if (other.hasContent()) {
            mergeContent(other.getContent());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.aiplatform.v1beta1.Content content_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
            contentBuilder_;

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the content field is set.
         */
        public boolean hasContent() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The content.
         */
        public com.google.cloud.aiplatform.v1beta1.Content getContent() {
          if (contentBuilder_ == null) {
            return content_ == null
                ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
                : content_;
          } else {
            return contentBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setContent(com.google.cloud.aiplatform.v1beta1.Content value) {
          if (contentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            content_ = value;
          } else {
            contentBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setContent(
            com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
          if (contentBuilder_ == null) {
            content_ = builderForValue.build();
          } else {
            contentBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeContent(com.google.cloud.aiplatform.v1beta1.Content value) {
          if (contentBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && content_ != null
                && content_ != com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()) {
              getContentBuilder().mergeFrom(value);
            } else {
              content_ = value;
            }
          } else {
            contentBuilder_.mergeFrom(value);
          }
          if (content_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearContent() {
          bitField0_ = (bitField0_ & ~0x00000001);
          content_ = null;
          if (contentBuilder_ != null) {
            contentBuilder_.dispose();
            contentBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.Content.Builder getContentBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getContentFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentOrBuilder() {
          if (contentBuilder_ != null) {
            return contentBuilder_.getMessageOrBuilder();
          } else {
            return content_ == null
                ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
                : content_;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. A single piece of content from which to generate memories.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.Content content = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
            getContentFieldBuilder() {
          if (contentBuilder_ == null) {
            contentBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.Content,
                    com.google.cloud.aiplatform.v1beta1.Content.Builder,
                    com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                    getContent(), getParentForChildren(), isClean());
            content_ = null;
          }
          return contentBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event)
      private static final com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
              .DirectContentsSource.Event
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Event();
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .Event
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Event> PARSER =
          new com.google.protobuf.AbstractParser<Event>() {
            @java.lang.Override
            public Event parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Event> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Event> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int EVENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event>
        events_;

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event>
        getEventsList() {
      return events_;
    }

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .EventOrBuilder>
        getEventsOrBuilderList() {
      return events_;
    }

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getEventsCount() {
      return events_.size();
    }

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
        getEvents(int index) {
      return events_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The source content (i.e. chat history) to generate memories
     * from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
            .EventOrBuilder
        getEventsOrBuilder(int index) {
      return events_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < events_.size(); i++) {
        output.writeMessage(1, events_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < events_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, events_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource other =
          (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource) obj;

      if (!getEventsList().equals(other.getEventsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEventsCount() > 0) {
        hash = (37 * hash) + EVENTS_FIELD_NUMBER;
        hash = (53 * hash) + getEventsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content from which to generate the memories.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .class,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (eventsBuilder_ == null) {
          events_ = java.util.Collections.emptyList();
        } else {
          events_ = null;
          eventsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_DirectContentsSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
          build() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource result =
            new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource result) {
        if (eventsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            events_ = java.util.Collections.unmodifiableList(events_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.events_ = events_;
        } else {
          result.events_ = eventsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .getDefaultInstance()) return this;
        if (eventsBuilder_ == null) {
          if (!other.events_.isEmpty()) {
            if (events_.isEmpty()) {
              events_ = other.events_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEventsIsMutable();
              events_.addAll(other.events_);
            }
            onChanged();
          }
        } else {
          if (!other.events_.isEmpty()) {
            if (eventsBuilder_.isEmpty()) {
              eventsBuilder_.dispose();
              eventsBuilder_ = null;
              events_ = other.events_;
              bitField0_ = (bitField0_ & ~0x00000001);
              eventsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEventsFieldBuilder()
                      : null;
            } else {
              eventsBuilder_.addAllMessages(other.events_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                          .Event
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                                  .DirectContentsSource.Event.parser(),
                              extensionRegistry);
                  if (eventsBuilder_ == null) {
                    ensureEventsIsMutable();
                    events_.add(m);
                  } else {
                    eventsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Event>
          events_ = java.util.Collections.emptyList();

      private void ensureEventsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          events_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .Event>(events_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Event,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .EventOrBuilder>
          eventsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Event>
          getEventsList() {
        if (eventsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(events_);
        } else {
          return eventsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getEventsCount() {
        if (eventsBuilder_ == null) {
          return events_.size();
        } else {
          return eventsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
          getEvents(int index) {
        if (eventsBuilder_ == null) {
          return events_.get(index);
        } else {
          return eventsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEvents(
          int index,
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              value) {
        if (eventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEventsIsMutable();
          events_.set(index, value);
          onChanged();
        } else {
          eventsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEvents(
          int index,
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                  .Builder
              builderForValue) {
        if (eventsBuilder_ == null) {
          ensureEventsIsMutable();
          events_.set(index, builderForValue.build());
          onChanged();
        } else {
          eventsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEvents(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              value) {
        if (eventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEventsIsMutable();
          events_.add(value);
          onChanged();
        } else {
          eventsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEvents(
          int index,
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              value) {
        if (eventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEventsIsMutable();
          events_.add(index, value);
          onChanged();
        } else {
          eventsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEvents(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                  .Builder
              builderForValue) {
        if (eventsBuilder_ == null) {
          ensureEventsIsMutable();
          events_.add(builderForValue.build());
          onChanged();
        } else {
          eventsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEvents(
          int index,
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                  .Builder
              builderForValue) {
        if (eventsBuilder_ == null) {
          ensureEventsIsMutable();
          events_.add(index, builderForValue.build());
          onChanged();
        } else {
          eventsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllEvents(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                          .DirectContentsSource.Event>
              values) {
        if (eventsBuilder_ == null) {
          ensureEventsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, events_);
          onChanged();
        } else {
          eventsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearEvents() {
        if (eventsBuilder_ == null) {
          events_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          eventsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeEvents(int index) {
        if (eventsBuilder_ == null) {
          ensureEventsIsMutable();
          events_.remove(index);
          onChanged();
        } else {
          eventsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              .Builder
          getEventsBuilder(int index) {
        return getEventsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
              .EventOrBuilder
          getEventsOrBuilder(int index) {
        if (eventsBuilder_ == null) {
          return events_.get(index);
        } else {
          return eventsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .EventOrBuilder>
          getEventsOrBuilderList() {
        if (eventsBuilder_ != null) {
          return eventsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(events_);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              .Builder
          addEventsBuilder() {
        return getEventsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .Event.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
              .Builder
          addEventsBuilder(int index) {
        return getEventsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .Event.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Required. The source content (i.e. chat history) to generate memories
       * from.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event events = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                  .Builder>
          getEventsBuilderList() {
        return getEventsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .Event,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .EventOrBuilder>
          getEventsFieldBuilder() {
        if (eventsBuilder_ == null) {
          eventsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .Event,
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .Event.Builder,
                  com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                      .EventOrBuilder>(
                  events_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          events_ = null;
        }
        return eventsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
    private static final com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
            .DirectContentsSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DirectContentsSource> PARSER =
        new com.google.protobuf.AbstractParser<DirectContentsSource>() {
          @java.lang.Override
          public DirectContentsSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DirectContentsSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DirectContentsSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VERTEX_SESSION_SOURCE(2),
    DIRECT_CONTENTS_SOURCE(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return VERTEX_SESSION_SOURCE;
        case 3:
          return DIRECT_CONTENTS_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int VERTEX_SESSION_SOURCE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Defines a Vertex Session as the source content from which to generate
   * memories.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
   * </code>
   *
   * @return Whether the vertexSessionSource field is set.
   */
  @java.lang.Override
  public boolean hasVertexSessionSource() {
    return sourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Defines a Vertex Session as the source content from which to generate
   * memories.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
   * </code>
   *
   * @return The vertexSessionSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
      getVertexSessionSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
          source_;
    }
    return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Defines a Vertex Session as the source content from which to generate
   * memories.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSourceOrBuilder
      getVertexSessionSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
          source_;
    }
    return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        .getDefaultInstance();
  }

  public static final int DIRECT_CONTENTS_SOURCE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Defines a direct source of content as the source content from which to
   * generate memories.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
   * </code>
   *
   * @return Whether the directContentsSource field is set.
   */
  @java.lang.Override
  public boolean hasDirectContentsSource() {
    return sourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Defines a direct source of content as the source content from which to
   * generate memories.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
   * </code>
   *
   * @return The directContentsSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
      getDirectContentsSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
          source_;
    }
    return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Defines a direct source of content as the source content from which to
   * generate memories.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSourceOrBuilder
      getDirectContentsSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
          source_;
    }
    return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        .getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the ReasoningEngine to generate memories
   * for. Format:
   * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the ReasoningEngine to generate memories
   * for. Format:
   * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_CONSOLIDATION_FIELD_NUMBER = 4;
  private boolean disableConsolidation_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, generated memories will not be consolidated with
   * existing memories; all generated memories will be added as new memories
   * regardless of whether they are duplicates of or contradictory to existing
   * memories. By default, memory consolidation is enabled.
   * </pre>
   *
   * <code>bool disable_consolidation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableConsolidation.
   */
  @java.lang.Override
  public boolean getDisableConsolidation() {
    return disableConsolidation_;
  }

  public static final int SCOPE_FIELD_NUMBER = 8;

  private static final class ScopeDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_ScopeEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> scope_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetScope() {
    if (scope_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ScopeDefaultEntryHolder.defaultEntry);
    }
    return scope_;
  }

  public int getScopeCount() {
    return internalGetScope().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The scope of the memories that should be generated. Memories will
   * be consolidated across memories with the same scope. Must be provided
   * unless the scope is defined in the source content. If `scope` is provided,
   * it will override the scope defined in the source content. Scope values
   * cannot contain the wildcard character '*'.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsScope(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetScope().getMap().containsKey(key);
  }

  /** Use {@link #getScopeMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getScope() {
    return getScopeMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The scope of the memories that should be generated. Memories will
   * be consolidated across memories with the same scope. Must be provided
   * unless the scope is defined in the source content. If `scope` is provided,
   * it will override the scope defined in the source content. Scope values
   * cannot contain the wildcard character '*'.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getScopeMap() {
    return internalGetScope().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The scope of the memories that should be generated. Memories will
   * be consolidated across memories with the same scope. Must be provided
   * unless the scope is defined in the source content. If `scope` is provided,
   * it will override the scope defined in the source content. Scope values
   * cannot contain the wildcard character '*'.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getScopeOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The scope of the memories that should be generated. Memories will
   * be consolidated across memories with the same scope. Must be provided
   * unless the scope is defined in the source content. If `scope` is provided,
   * it will override the scope defined in the source content. Scope values
   * cannot contain the wildcard character '*'.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getScopeOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
              source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
              source_);
    }
    if (disableConsolidation_ != false) {
      output.writeBool(4, disableConsolidation_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetScope(), ScopeDefaultEntryHolder.defaultEntry, 8);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
                  source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
                  source_);
    }
    if (disableConsolidation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, disableConsolidation_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetScope().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> scope__ =
          ScopeDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, scope__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest other =
        (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getDisableConsolidation() != other.getDisableConsolidation()) return false;
    if (!internalGetScope().equals(other.internalGetScope())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getVertexSessionSource().equals(other.getVertexSessionSource())) return false;
        break;
      case 3:
        if (!getDirectContentsSource().equals(other.getDirectContentsSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DISABLE_CONSOLIDATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableConsolidation());
    if (!internalGetScope().getMap().isEmpty()) {
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + internalGetScope().hashCode();
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + VERTEX_SESSION_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getVertexSessionSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DIRECT_CONTENTS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getDirectContentsSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest)
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetScope();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableScope();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.class,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (vertexSessionSourceBuilder_ != null) {
        vertexSessionSourceBuilder_.clear();
      }
      if (directContentsSourceBuilder_ != null) {
        directContentsSourceBuilder_.clear();
      }
      parent_ = "";
      disableConsolidation_ = false;
      internalGetMutableScope().clear();
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest build() {
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest result =
          new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.disableConsolidation_ = disableConsolidation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.scope_ = internalGetScope();
        result.scope_.makeImmutable();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && vertexSessionSourceBuilder_ != null) {
        result.source_ = vertexSessionSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && directContentsSourceBuilder_ != null) {
        result.source_ = directContentsSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getDisableConsolidation() != false) {
        setDisableConsolidation(other.getDisableConsolidation());
      }
      internalGetMutableScope().mergeFrom(other.internalGetScope());
      bitField0_ |= 0x00000010;
      switch (other.getSourceCase()) {
        case VERTEX_SESSION_SOURCE:
          {
            mergeVertexSessionSource(other.getVertexSessionSource());
            break;
          }
        case DIRECT_CONTENTS_SOURCE:
          {
            mergeDirectContentsSource(other.getDirectContentsSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getVertexSessionSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDirectContentsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                disableConsolidation_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> scope__ =
                    input.readMessage(
                        ScopeDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableScope().getMutableMap().put(scope__.getKey(), scope__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                .VertexSessionSourceOrBuilder>
        vertexSessionSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     *
     * @return Whether the vertexSessionSource field is set.
     */
    @java.lang.Override
    public boolean hasVertexSessionSource() {
      return sourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     *
     * @return The vertexSessionSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
        getVertexSessionSource() {
      if (vertexSessionSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
              source_;
        }
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return vertexSessionSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    public Builder setVertexSessionSource(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource value) {
      if (vertexSessionSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        vertexSessionSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    public Builder setVertexSessionSource(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.Builder
            builderForValue) {
      if (vertexSessionSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        vertexSessionSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    public Builder mergeVertexSessionSource(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource value) {
      if (vertexSessionSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                              .VertexSessionSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          vertexSessionSourceBuilder_.mergeFrom(value);
        } else {
          vertexSessionSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    public Builder clearVertexSessionSource() {
      if (vertexSessionSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        vertexSessionSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.Builder
        getVertexSessionSourceBuilder() {
      return getVertexSessionSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSourceOrBuilder
        getVertexSessionSourceOrBuilder() {
      if ((sourceCase_ == 2) && (vertexSessionSourceBuilder_ != null)) {
        return vertexSessionSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
              source_;
        }
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a Vertex Session as the source content from which to generate
     * memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource vertex_session_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                .VertexSessionSourceOrBuilder>
        getVertexSessionSourceFieldBuilder() {
      if (vertexSessionSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                  .getDefaultInstance();
        }
        vertexSessionSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                    .VertexSessionSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return vertexSessionSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                .DirectContentsSourceOrBuilder>
        directContentsSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     *
     * @return Whether the directContentsSource field is set.
     */
    @java.lang.Override
    public boolean hasDirectContentsSource() {
      return sourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     *
     * @return The directContentsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
        getDirectContentsSource() {
      if (directContentsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
              source_;
        }
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return directContentsSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    public Builder setDirectContentsSource(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource value) {
      if (directContentsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        directContentsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    public Builder setDirectContentsSource(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Builder
            builderForValue) {
      if (directContentsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        directContentsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    public Builder mergeDirectContentsSource(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource value) {
      if (directContentsSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_
                != com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                              .DirectContentsSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          directContentsSourceBuilder_.mergeFrom(value);
        } else {
          directContentsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    public Builder clearDirectContentsSource() {
      if (directContentsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        directContentsSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Builder
        getDirectContentsSourceBuilder() {
      return getDirectContentsSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSourceOrBuilder
        getDirectContentsSourceOrBuilder() {
      if ((sourceCase_ == 3) && (directContentsSourceBuilder_ != null)) {
        return directContentsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
              source_;
        }
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a direct source of content as the source content from which to
     * generate memories.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource direct_contents_source = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                .Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                .DirectContentsSourceOrBuilder>
        getDirectContentsSourceFieldBuilder() {
      if (directContentsSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                  .getDefaultInstance();
        }
        directContentsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
                    .DirectContentsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return directContentsSourceBuilder_;
    }

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to generate memories
     * for. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to generate memories
     * for. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to generate memories
     * for. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to generate memories
     * for. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to generate memories
     * for. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean disableConsolidation_;

    /**
     *
     *
     * <pre>
     * Optional. If true, generated memories will not be consolidated with
     * existing memories; all generated memories will be added as new memories
     * regardless of whether they are duplicates of or contradictory to existing
     * memories. By default, memory consolidation is enabled.
     * </pre>
     *
     * <code>bool disable_consolidation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableConsolidation.
     */
    @java.lang.Override
    public boolean getDisableConsolidation() {
      return disableConsolidation_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, generated memories will not be consolidated with
     * existing memories; all generated memories will be added as new memories
     * regardless of whether they are duplicates of or contradictory to existing
     * memories. By default, memory consolidation is enabled.
     * </pre>
     *
     * <code>bool disable_consolidation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disableConsolidation to set.
     * @return This builder for chaining.
     */
    public Builder setDisableConsolidation(boolean value) {

      disableConsolidation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, generated memories will not be consolidated with
     * existing memories; all generated memories will be added as new memories
     * regardless of whether they are duplicates of or contradictory to existing
     * memories. By default, memory consolidation is enabled.
     * </pre>
     *
     * <code>bool disable_consolidation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableConsolidation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      disableConsolidation_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> scope_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetScope() {
      if (scope_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ScopeDefaultEntryHolder.defaultEntry);
      }
      return scope_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableScope() {
      if (scope_ == null) {
        scope_ = com.google.protobuf.MapField.newMapField(ScopeDefaultEntryHolder.defaultEntry);
      }
      if (!scope_.isMutable()) {
        scope_ = scope_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return scope_;
    }

    public int getScopeCount() {
      return internalGetScope().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsScope(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetScope().getMap().containsKey(key);
    }

    /** Use {@link #getScopeMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getScope() {
      return getScopeMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getScopeMap() {
      return internalGetScope().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getScopeOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getScopeOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearScope() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableScope().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeScope(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableScope().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableScope() {
      bitField0_ |= 0x00000010;
      return internalGetMutableScope().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putScope(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableScope().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scope of the memories that should be generated. Memories will
     * be consolidated across memories with the same scope. Must be provided
     * unless the scope is defined in the source content. If `scope` is provided,
     * it will override the scope defined in the source content. Scope values
     * cannot contain the wildcard character '*'.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllScope(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableScope().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateMemoriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateMemoriesRequest>() {
        @java.lang.Override
        public GenerateMemoriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateMemoriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateMemoriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
