/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/evaluation_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The metric used for dataset level evaluation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Metric}
 */
public final class Metric extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Metric)
    MetricOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Metric.newBuilder() to construct.
  private Metric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Metric() {
    aggregationMetrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Metric();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_Metric_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_Metric_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Metric.class,
            com.google.cloud.aiplatform.v1beta1.Metric.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The aggregation metrics supported by EvaluationService.EvaluateDataset.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.Metric.AggregationMetric}
   */
  public enum AggregationMetric implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified aggregation metric.
     * </pre>
     *
     * <code>AGGREGATION_METRIC_UNSPECIFIED = 0;</code>
     */
    AGGREGATION_METRIC_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Average aggregation metric.
     * </pre>
     *
     * <code>AVERAGE = 1;</code>
     */
    AVERAGE(1),
    /**
     *
     *
     * <pre>
     * Mode aggregation metric.
     * </pre>
     *
     * <code>MODE = 2;</code>
     */
    MODE(2),
    /**
     *
     *
     * <pre>
     * Standard deviation aggregation metric.
     * </pre>
     *
     * <code>STANDARD_DEVIATION = 3;</code>
     */
    STANDARD_DEVIATION(3),
    /**
     *
     *
     * <pre>
     * Variance aggregation metric.
     * </pre>
     *
     * <code>VARIANCE = 4;</code>
     */
    VARIANCE(4),
    /**
     *
     *
     * <pre>
     * Minimum aggregation metric.
     * </pre>
     *
     * <code>MINIMUM = 5;</code>
     */
    MINIMUM(5),
    /**
     *
     *
     * <pre>
     * Maximum aggregation metric.
     * </pre>
     *
     * <code>MAXIMUM = 6;</code>
     */
    MAXIMUM(6),
    /**
     *
     *
     * <pre>
     * Median aggregation metric.
     * </pre>
     *
     * <code>MEDIAN = 7;</code>
     */
    MEDIAN(7),
    /**
     *
     *
     * <pre>
     * 90th percentile aggregation metric.
     * </pre>
     *
     * <code>PERCENTILE_P90 = 8;</code>
     */
    PERCENTILE_P90(8),
    /**
     *
     *
     * <pre>
     * 95th percentile aggregation metric.
     * </pre>
     *
     * <code>PERCENTILE_P95 = 9;</code>
     */
    PERCENTILE_P95(9),
    /**
     *
     *
     * <pre>
     * 99th percentile aggregation metric.
     * </pre>
     *
     * <code>PERCENTILE_P99 = 10;</code>
     */
    PERCENTILE_P99(10),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified aggregation metric.
     * </pre>
     *
     * <code>AGGREGATION_METRIC_UNSPECIFIED = 0;</code>
     */
    public static final int AGGREGATION_METRIC_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Average aggregation metric.
     * </pre>
     *
     * <code>AVERAGE = 1;</code>
     */
    public static final int AVERAGE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Mode aggregation metric.
     * </pre>
     *
     * <code>MODE = 2;</code>
     */
    public static final int MODE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Standard deviation aggregation metric.
     * </pre>
     *
     * <code>STANDARD_DEVIATION = 3;</code>
     */
    public static final int STANDARD_DEVIATION_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Variance aggregation metric.
     * </pre>
     *
     * <code>VARIANCE = 4;</code>
     */
    public static final int VARIANCE_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Minimum aggregation metric.
     * </pre>
     *
     * <code>MINIMUM = 5;</code>
     */
    public static final int MINIMUM_VALUE = 5;

    /**
     *
     *
     * <pre>
     * Maximum aggregation metric.
     * </pre>
     *
     * <code>MAXIMUM = 6;</code>
     */
    public static final int MAXIMUM_VALUE = 6;

    /**
     *
     *
     * <pre>
     * Median aggregation metric.
     * </pre>
     *
     * <code>MEDIAN = 7;</code>
     */
    public static final int MEDIAN_VALUE = 7;

    /**
     *
     *
     * <pre>
     * 90th percentile aggregation metric.
     * </pre>
     *
     * <code>PERCENTILE_P90 = 8;</code>
     */
    public static final int PERCENTILE_P90_VALUE = 8;

    /**
     *
     *
     * <pre>
     * 95th percentile aggregation metric.
     * </pre>
     *
     * <code>PERCENTILE_P95 = 9;</code>
     */
    public static final int PERCENTILE_P95_VALUE = 9;

    /**
     *
     *
     * <pre>
     * 99th percentile aggregation metric.
     * </pre>
     *
     * <code>PERCENTILE_P99 = 10;</code>
     */
    public static final int PERCENTILE_P99_VALUE = 10;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AggregationMetric valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AggregationMetric forNumber(int value) {
      switch (value) {
        case 0:
          return AGGREGATION_METRIC_UNSPECIFIED;
        case 1:
          return AVERAGE;
        case 2:
          return MODE;
        case 3:
          return STANDARD_DEVIATION;
        case 4:
          return VARIANCE;
        case 5:
          return MINIMUM;
        case 6:
          return MAXIMUM;
        case 7:
          return MEDIAN;
        case 8:
          return PERCENTILE_P90;
        case 9:
          return PERCENTILE_P95;
        case 10:
          return PERCENTILE_P99;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AggregationMetric>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AggregationMetric>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AggregationMetric>() {
              public AggregationMetric findValueByNumber(int number) {
                return AggregationMetric.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Metric.getDescriptor().getEnumTypes().get(0);
    }

    private static final AggregationMetric[] VALUES = values();

    public static AggregationMetric valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AggregationMetric(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.Metric.AggregationMetric)
  }

  private int metricSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metricSpec_;

  public enum MetricSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    POINTWISE_METRIC_SPEC(2),
    PAIRWISE_METRIC_SPEC(3),
    EXACT_MATCH_SPEC(4),
    BLEU_SPEC(5),
    ROUGE_SPEC(6),
    METRICSPEC_NOT_SET(0);
    private final int value;

    private MetricSpecCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetricSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetricSpecCase forNumber(int value) {
      switch (value) {
        case 2:
          return POINTWISE_METRIC_SPEC;
        case 3:
          return PAIRWISE_METRIC_SPEC;
        case 4:
          return EXACT_MATCH_SPEC;
        case 5:
          return BLEU_SPEC;
        case 6:
          return ROUGE_SPEC;
        case 0:
          return METRICSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetricSpecCase getMetricSpecCase() {
    return MetricSpecCase.forNumber(metricSpecCase_);
  }

  public static final int POINTWISE_METRIC_SPEC_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Spec for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
   *
   * @return Whether the pointwiseMetricSpec field is set.
   */
  @java.lang.Override
  public boolean hasPointwiseMetricSpec() {
    return metricSpecCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Spec for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
   *
   * @return The pointwiseMetricSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec getPointwiseMetricSpec() {
    if (metricSpecCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Spec for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpecOrBuilder
      getPointwiseMetricSpecOrBuilder() {
    if (metricSpecCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance();
  }

  public static final int PAIRWISE_METRIC_SPEC_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Spec for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
   *
   * @return Whether the pairwiseMetricSpec field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseMetricSpec() {
    return metricSpecCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Spec for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
   *
   * @return The pairwiseMetricSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec getPairwiseMetricSpec() {
    if (metricSpecCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Spec for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpecOrBuilder
      getPairwiseMetricSpecOrBuilder() {
    if (metricSpecCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance();
  }

  public static final int EXACT_MATCH_SPEC_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Spec for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
   *
   * @return Whether the exactMatchSpec field is set.
   */
  @java.lang.Override
  public boolean hasExactMatchSpec() {
    return metricSpecCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Spec for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
   *
   * @return The exactMatchSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExactMatchSpec getExactMatchSpec() {
    if (metricSpecCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Spec for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExactMatchSpecOrBuilder getExactMatchSpecOrBuilder() {
    if (metricSpecCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance();
  }

  public static final int BLEU_SPEC_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Spec for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
   *
   * @return Whether the bleuSpec field is set.
   */
  @java.lang.Override
  public boolean hasBleuSpec() {
    return metricSpecCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Spec for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
   *
   * @return The bleuSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BleuSpec getBleuSpec() {
    if (metricSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Spec for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BleuSpecOrBuilder getBleuSpecOrBuilder() {
    if (metricSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance();
  }

  public static final int ROUGE_SPEC_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Spec for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
   *
   * @return Whether the rougeSpec field is set.
   */
  @java.lang.Override
  public boolean hasRougeSpec() {
    return metricSpecCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Spec for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
   *
   * @return The rougeSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RougeSpec getRougeSpec() {
    if (metricSpecCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Spec for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RougeSpecOrBuilder getRougeSpecOrBuilder() {
    if (metricSpecCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance();
  }

  public static final int AGGREGATION_METRICS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> aggregationMetrics_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>
      aggregationMetrics_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>() {
            public com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric convert(
                java.lang.Integer from) {
              com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric result =
                  com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric.forNumber(from);
              return result == null
                  ? com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. The aggregation metrics to use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the aggregationMetrics.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>
      getAggregationMetricsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>(
        aggregationMetrics_, aggregationMetrics_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. The aggregation metrics to use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of aggregationMetrics.
   */
  @java.lang.Override
  public int getAggregationMetricsCount() {
    return aggregationMetrics_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The aggregation metrics to use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The aggregationMetrics at the given index.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric getAggregationMetrics(
      int index) {
    return aggregationMetrics_converter_.convert(aggregationMetrics_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. The aggregation metrics to use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for aggregationMetrics.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAggregationMetricsValueList() {
    return aggregationMetrics_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The aggregation metrics to use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of aggregationMetrics at the given index.
   */
  @java.lang.Override
  public int getAggregationMetricsValue(int index) {
    return aggregationMetrics_.get(index);
  }

  private int aggregationMetricsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getAggregationMetricsList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(aggregationMetricsMemoizedSerializedSize);
    }
    for (int i = 0; i < aggregationMetrics_.size(); i++) {
      output.writeEnumNoTag(aggregationMetrics_.get(i));
    }
    if (metricSpecCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_);
    }
    if (metricSpecCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_);
    }
    if (metricSpecCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_);
    }
    if (metricSpecCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_);
    }
    if (metricSpecCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < aggregationMetrics_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(aggregationMetrics_.get(i));
      }
      size += dataSize;
      if (!getAggregationMetricsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      aggregationMetricsMemoizedSerializedSize = dataSize;
    }
    if (metricSpecCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_);
    }
    if (metricSpecCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_);
    }
    if (metricSpecCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_);
    }
    if (metricSpecCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_);
    }
    if (metricSpecCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Metric)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Metric other =
        (com.google.cloud.aiplatform.v1beta1.Metric) obj;

    if (!aggregationMetrics_.equals(other.aggregationMetrics_)) return false;
    if (!getMetricSpecCase().equals(other.getMetricSpecCase())) return false;
    switch (metricSpecCase_) {
      case 2:
        if (!getPointwiseMetricSpec().equals(other.getPointwiseMetricSpec())) return false;
        break;
      case 3:
        if (!getPairwiseMetricSpec().equals(other.getPairwiseMetricSpec())) return false;
        break;
      case 4:
        if (!getExactMatchSpec().equals(other.getExactMatchSpec())) return false;
        break;
      case 5:
        if (!getBleuSpec().equals(other.getBleuSpec())) return false;
        break;
      case 6:
        if (!getRougeSpec().equals(other.getRougeSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAggregationMetricsCount() > 0) {
      hash = (37 * hash) + AGGREGATION_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + aggregationMetrics_.hashCode();
    }
    switch (metricSpecCase_) {
      case 2:
        hash = (37 * hash) + POINTWISE_METRIC_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPointwiseMetricSpec().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PAIRWISE_METRIC_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseMetricSpec().hashCode();
        break;
      case 4:
        hash = (37 * hash) + EXACT_MATCH_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getExactMatchSpec().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BLEU_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBleuSpec().hashCode();
        break;
      case 6:
        hash = (37 * hash) + ROUGE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getRougeSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Metric prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The metric used for dataset level evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Metric}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Metric)
      com.google.cloud.aiplatform.v1beta1.MetricOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Metric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Metric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Metric.class,
              com.google.cloud.aiplatform.v1beta1.Metric.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Metric.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (pointwiseMetricSpecBuilder_ != null) {
        pointwiseMetricSpecBuilder_.clear();
      }
      if (pairwiseMetricSpecBuilder_ != null) {
        pairwiseMetricSpecBuilder_.clear();
      }
      if (exactMatchSpecBuilder_ != null) {
        exactMatchSpecBuilder_.clear();
      }
      if (bleuSpecBuilder_ != null) {
        bleuSpecBuilder_.clear();
      }
      if (rougeSpecBuilder_ != null) {
        rougeSpecBuilder_.clear();
      }
      aggregationMetrics_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      metricSpecCase_ = 0;
      metricSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Metric_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Metric getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Metric.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Metric build() {
      com.google.cloud.aiplatform.v1beta1.Metric result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Metric buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Metric result =
          new com.google.cloud.aiplatform.v1beta1.Metric(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.Metric result) {
      if (((bitField0_ & 0x00000020) != 0)) {
        aggregationMetrics_ = java.util.Collections.unmodifiableList(aggregationMetrics_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.aggregationMetrics_ = aggregationMetrics_;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Metric result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.Metric result) {
      result.metricSpecCase_ = metricSpecCase_;
      result.metricSpec_ = this.metricSpec_;
      if (metricSpecCase_ == 2 && pointwiseMetricSpecBuilder_ != null) {
        result.metricSpec_ = pointwiseMetricSpecBuilder_.build();
      }
      if (metricSpecCase_ == 3 && pairwiseMetricSpecBuilder_ != null) {
        result.metricSpec_ = pairwiseMetricSpecBuilder_.build();
      }
      if (metricSpecCase_ == 4 && exactMatchSpecBuilder_ != null) {
        result.metricSpec_ = exactMatchSpecBuilder_.build();
      }
      if (metricSpecCase_ == 5 && bleuSpecBuilder_ != null) {
        result.metricSpec_ = bleuSpecBuilder_.build();
      }
      if (metricSpecCase_ == 6 && rougeSpecBuilder_ != null) {
        result.metricSpec_ = rougeSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Metric) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Metric) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Metric other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Metric.getDefaultInstance()) return this;
      if (!other.aggregationMetrics_.isEmpty()) {
        if (aggregationMetrics_.isEmpty()) {
          aggregationMetrics_ = other.aggregationMetrics_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureAggregationMetricsIsMutable();
          aggregationMetrics_.addAll(other.aggregationMetrics_);
        }
        onChanged();
      }
      switch (other.getMetricSpecCase()) {
        case POINTWISE_METRIC_SPEC:
          {
            mergePointwiseMetricSpec(other.getPointwiseMetricSpec());
            break;
          }
        case PAIRWISE_METRIC_SPEC:
          {
            mergePairwiseMetricSpec(other.getPairwiseMetricSpec());
            break;
          }
        case EXACT_MATCH_SPEC:
          {
            mergeExactMatchSpec(other.getExactMatchSpec());
            break;
          }
        case BLEU_SPEC:
          {
            mergeBleuSpec(other.getBleuSpec());
            break;
          }
        case ROUGE_SPEC:
          {
            mergeRougeSpec(other.getRougeSpec());
            break;
          }
        case METRICSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureAggregationMetricsIsMutable();
                aggregationMetrics_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAggregationMetricsIsMutable();
                  aggregationMetrics_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getPointwiseMetricSpecFieldBuilder().getBuilder(), extensionRegistry);
                metricSpecCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getPairwiseMetricSpecFieldBuilder().getBuilder(), extensionRegistry);
                metricSpecCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getExactMatchSpecFieldBuilder().getBuilder(), extensionRegistry);
                metricSpecCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getBleuSpecFieldBuilder().getBuilder(), extensionRegistry);
                metricSpecCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getRougeSpecFieldBuilder().getBuilder(), extensionRegistry);
                metricSpecCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metricSpecCase_ = 0;
    private java.lang.Object metricSpec_;

    public MetricSpecCase getMetricSpecCase() {
      return MetricSpecCase.forNumber(metricSpecCase_);
    }

    public Builder clearMetricSpec() {
      metricSpecCase_ = 0;
      metricSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpecOrBuilder>
        pointwiseMetricSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     *
     * @return Whether the pointwiseMetricSpec field is set.
     */
    @java.lang.Override
    public boolean hasPointwiseMetricSpec() {
      return metricSpecCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     *
     * @return The pointwiseMetricSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec getPointwiseMetricSpec() {
      if (pointwiseMetricSpecBuilder_ == null) {
        if (metricSpecCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance();
      } else {
        if (metricSpecCase_ == 2) {
          return pointwiseMetricSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    public Builder setPointwiseMetricSpec(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec value) {
      if (pointwiseMetricSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricSpec_ = value;
        onChanged();
      } else {
        pointwiseMetricSpecBuilder_.setMessage(value);
      }
      metricSpecCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    public Builder setPointwiseMetricSpec(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.Builder builderForValue) {
      if (pointwiseMetricSpecBuilder_ == null) {
        metricSpec_ = builderForValue.build();
        onChanged();
      } else {
        pointwiseMetricSpecBuilder_.setMessage(builderForValue.build());
      }
      metricSpecCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    public Builder mergePointwiseMetricSpec(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec value) {
      if (pointwiseMetricSpecBuilder_ == null) {
        if (metricSpecCase_ == 2
            && metricSpec_
                != com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance()) {
          metricSpec_ =
              com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricSpec_ = value;
        }
        onChanged();
      } else {
        if (metricSpecCase_ == 2) {
          pointwiseMetricSpecBuilder_.mergeFrom(value);
        } else {
          pointwiseMetricSpecBuilder_.setMessage(value);
        }
      }
      metricSpecCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    public Builder clearPointwiseMetricSpec() {
      if (pointwiseMetricSpecBuilder_ == null) {
        if (metricSpecCase_ == 2) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
          onChanged();
        }
      } else {
        if (metricSpecCase_ == 2) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
        }
        pointwiseMetricSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.Builder
        getPointwiseMetricSpecBuilder() {
      return getPointwiseMetricSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpecOrBuilder
        getPointwiseMetricSpecOrBuilder() {
      if ((metricSpecCase_ == 2) && (pointwiseMetricSpecBuilder_ != null)) {
        return pointwiseMetricSpecBuilder_.getMessageOrBuilder();
      } else {
        if (metricSpecCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec pointwise_metric_spec = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpecOrBuilder>
        getPointwiseMetricSpecFieldBuilder() {
      if (pointwiseMetricSpecBuilder_ == null) {
        if (!(metricSpecCase_ == 2)) {
          metricSpec_ =
              com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.getDefaultInstance();
        }
        pointwiseMetricSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec,
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PointwiseMetricSpec) metricSpec_,
                getParentForChildren(),
                isClean());
        metricSpec_ = null;
      }
      metricSpecCase_ = 2;
      onChanged();
      return pointwiseMetricSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpecOrBuilder>
        pairwiseMetricSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     *
     * @return Whether the pairwiseMetricSpec field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseMetricSpec() {
      return metricSpecCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     *
     * @return The pairwiseMetricSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec getPairwiseMetricSpec() {
      if (pairwiseMetricSpecBuilder_ == null) {
        if (metricSpecCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance();
      } else {
        if (metricSpecCase_ == 3) {
          return pairwiseMetricSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    public Builder setPairwiseMetricSpec(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec value) {
      if (pairwiseMetricSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricSpec_ = value;
        onChanged();
      } else {
        pairwiseMetricSpecBuilder_.setMessage(value);
      }
      metricSpecCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    public Builder setPairwiseMetricSpec(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.Builder builderForValue) {
      if (pairwiseMetricSpecBuilder_ == null) {
        metricSpec_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseMetricSpecBuilder_.setMessage(builderForValue.build());
      }
      metricSpecCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    public Builder mergePairwiseMetricSpec(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec value) {
      if (pairwiseMetricSpecBuilder_ == null) {
        if (metricSpecCase_ == 3
            && metricSpec_
                != com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance()) {
          metricSpec_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricSpec_ = value;
        }
        onChanged();
      } else {
        if (metricSpecCase_ == 3) {
          pairwiseMetricSpecBuilder_.mergeFrom(value);
        } else {
          pairwiseMetricSpecBuilder_.setMessage(value);
        }
      }
      metricSpecCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    public Builder clearPairwiseMetricSpec() {
      if (pairwiseMetricSpecBuilder_ == null) {
        if (metricSpecCase_ == 3) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
          onChanged();
        }
      } else {
        if (metricSpecCase_ == 3) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
        }
        pairwiseMetricSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.Builder
        getPairwiseMetricSpecBuilder() {
      return getPairwiseMetricSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpecOrBuilder
        getPairwiseMetricSpecOrBuilder() {
      if ((metricSpecCase_ == 3) && (pairwiseMetricSpecBuilder_ != null)) {
        return pairwiseMetricSpecBuilder_.getMessageOrBuilder();
      } else {
        if (metricSpecCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec pairwise_metric_spec = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpecOrBuilder>
        getPairwiseMetricSpecFieldBuilder() {
      if (pairwiseMetricSpecBuilder_ == null) {
        if (!(metricSpecCase_ == 3)) {
          metricSpec_ = com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.getDefaultInstance();
        }
        pairwiseMetricSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec,
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PairwiseMetricSpec) metricSpec_,
                getParentForChildren(),
                isClean());
        metricSpec_ = null;
      }
      metricSpecCase_ = 3;
      onChanged();
      return pairwiseMetricSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExactMatchSpec,
            com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExactMatchSpecOrBuilder>
        exactMatchSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     *
     * @return Whether the exactMatchSpec field is set.
     */
    @java.lang.Override
    public boolean hasExactMatchSpec() {
      return metricSpecCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     *
     * @return The exactMatchSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExactMatchSpec getExactMatchSpec() {
      if (exactMatchSpecBuilder_ == null) {
        if (metricSpecCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance();
      } else {
        if (metricSpecCase_ == 4) {
          return exactMatchSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    public Builder setExactMatchSpec(com.google.cloud.aiplatform.v1beta1.ExactMatchSpec value) {
      if (exactMatchSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricSpec_ = value;
        onChanged();
      } else {
        exactMatchSpecBuilder_.setMessage(value);
      }
      metricSpecCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    public Builder setExactMatchSpec(
        com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.Builder builderForValue) {
      if (exactMatchSpecBuilder_ == null) {
        metricSpec_ = builderForValue.build();
        onChanged();
      } else {
        exactMatchSpecBuilder_.setMessage(builderForValue.build());
      }
      metricSpecCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    public Builder mergeExactMatchSpec(com.google.cloud.aiplatform.v1beta1.ExactMatchSpec value) {
      if (exactMatchSpecBuilder_ == null) {
        if (metricSpecCase_ == 4
            && metricSpec_
                != com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance()) {
          metricSpec_ =
              com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricSpec_ = value;
        }
        onChanged();
      } else {
        if (metricSpecCase_ == 4) {
          exactMatchSpecBuilder_.mergeFrom(value);
        } else {
          exactMatchSpecBuilder_.setMessage(value);
        }
      }
      metricSpecCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    public Builder clearExactMatchSpec() {
      if (exactMatchSpecBuilder_ == null) {
        if (metricSpecCase_ == 4) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
          onChanged();
        }
      } else {
        if (metricSpecCase_ == 4) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
        }
        exactMatchSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.Builder getExactMatchSpecBuilder() {
      return getExactMatchSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExactMatchSpecOrBuilder
        getExactMatchSpecOrBuilder() {
      if ((metricSpecCase_ == 4) && (exactMatchSpecBuilder_ != null)) {
        return exactMatchSpecBuilder_.getMessageOrBuilder();
      } else {
        if (metricSpecCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchSpec exact_match_spec = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExactMatchSpec,
            com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExactMatchSpecOrBuilder>
        getExactMatchSpecFieldBuilder() {
      if (exactMatchSpecBuilder_ == null) {
        if (!(metricSpecCase_ == 4)) {
          metricSpec_ = com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.getDefaultInstance();
        }
        exactMatchSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExactMatchSpec,
                com.google.cloud.aiplatform.v1beta1.ExactMatchSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ExactMatchSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ExactMatchSpec) metricSpec_,
                getParentForChildren(),
                isClean());
        metricSpec_ = null;
      }
      metricSpecCase_ = 4;
      onChanged();
      return exactMatchSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BleuSpec,
            com.google.cloud.aiplatform.v1beta1.BleuSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.BleuSpecOrBuilder>
        bleuSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     *
     * @return Whether the bleuSpec field is set.
     */
    @java.lang.Override
    public boolean hasBleuSpec() {
      return metricSpecCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     *
     * @return The bleuSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BleuSpec getBleuSpec() {
      if (bleuSpecBuilder_ == null) {
        if (metricSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance();
      } else {
        if (metricSpecCase_ == 5) {
          return bleuSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    public Builder setBleuSpec(com.google.cloud.aiplatform.v1beta1.BleuSpec value) {
      if (bleuSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricSpec_ = value;
        onChanged();
      } else {
        bleuSpecBuilder_.setMessage(value);
      }
      metricSpecCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    public Builder setBleuSpec(
        com.google.cloud.aiplatform.v1beta1.BleuSpec.Builder builderForValue) {
      if (bleuSpecBuilder_ == null) {
        metricSpec_ = builderForValue.build();
        onChanged();
      } else {
        bleuSpecBuilder_.setMessage(builderForValue.build());
      }
      metricSpecCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    public Builder mergeBleuSpec(com.google.cloud.aiplatform.v1beta1.BleuSpec value) {
      if (bleuSpecBuilder_ == null) {
        if (metricSpecCase_ == 5
            && metricSpec_ != com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance()) {
          metricSpec_ =
              com.google.cloud.aiplatform.v1beta1.BleuSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricSpec_ = value;
        }
        onChanged();
      } else {
        if (metricSpecCase_ == 5) {
          bleuSpecBuilder_.mergeFrom(value);
        } else {
          bleuSpecBuilder_.setMessage(value);
        }
      }
      metricSpecCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    public Builder clearBleuSpec() {
      if (bleuSpecBuilder_ == null) {
        if (metricSpecCase_ == 5) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
          onChanged();
        }
      } else {
        if (metricSpecCase_ == 5) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
        }
        bleuSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BleuSpec.Builder getBleuSpecBuilder() {
      return getBleuSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BleuSpecOrBuilder getBleuSpecOrBuilder() {
      if ((metricSpecCase_ == 5) && (bleuSpecBuilder_ != null)) {
        return bleuSpecBuilder_.getMessageOrBuilder();
      } else {
        if (metricSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuSpec bleu_spec = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BleuSpec,
            com.google.cloud.aiplatform.v1beta1.BleuSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.BleuSpecOrBuilder>
        getBleuSpecFieldBuilder() {
      if (bleuSpecBuilder_ == null) {
        if (!(metricSpecCase_ == 5)) {
          metricSpec_ = com.google.cloud.aiplatform.v1beta1.BleuSpec.getDefaultInstance();
        }
        bleuSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BleuSpec,
                com.google.cloud.aiplatform.v1beta1.BleuSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.BleuSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BleuSpec) metricSpec_,
                getParentForChildren(),
                isClean());
        metricSpec_ = null;
      }
      metricSpecCase_ = 5;
      onChanged();
      return bleuSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RougeSpec,
            com.google.cloud.aiplatform.v1beta1.RougeSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.RougeSpecOrBuilder>
        rougeSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     *
     * @return Whether the rougeSpec field is set.
     */
    @java.lang.Override
    public boolean hasRougeSpec() {
      return metricSpecCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     *
     * @return The rougeSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RougeSpec getRougeSpec() {
      if (rougeSpecBuilder_ == null) {
        if (metricSpecCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance();
      } else {
        if (metricSpecCase_ == 6) {
          return rougeSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    public Builder setRougeSpec(com.google.cloud.aiplatform.v1beta1.RougeSpec value) {
      if (rougeSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricSpec_ = value;
        onChanged();
      } else {
        rougeSpecBuilder_.setMessage(value);
      }
      metricSpecCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    public Builder setRougeSpec(
        com.google.cloud.aiplatform.v1beta1.RougeSpec.Builder builderForValue) {
      if (rougeSpecBuilder_ == null) {
        metricSpec_ = builderForValue.build();
        onChanged();
      } else {
        rougeSpecBuilder_.setMessage(builderForValue.build());
      }
      metricSpecCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    public Builder mergeRougeSpec(com.google.cloud.aiplatform.v1beta1.RougeSpec value) {
      if (rougeSpecBuilder_ == null) {
        if (metricSpecCase_ == 6
            && metricSpec_ != com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance()) {
          metricSpec_ =
              com.google.cloud.aiplatform.v1beta1.RougeSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricSpec_ = value;
        }
        onChanged();
      } else {
        if (metricSpecCase_ == 6) {
          rougeSpecBuilder_.mergeFrom(value);
        } else {
          rougeSpecBuilder_.setMessage(value);
        }
      }
      metricSpecCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    public Builder clearRougeSpec() {
      if (rougeSpecBuilder_ == null) {
        if (metricSpecCase_ == 6) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
          onChanged();
        }
      } else {
        if (metricSpecCase_ == 6) {
          metricSpecCase_ = 0;
          metricSpec_ = null;
        }
        rougeSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RougeSpec.Builder getRougeSpecBuilder() {
      return getRougeSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RougeSpecOrBuilder getRougeSpecOrBuilder() {
      if ((metricSpecCase_ == 6) && (rougeSpecBuilder_ != null)) {
        return rougeSpecBuilder_.getMessageOrBuilder();
      } else {
        if (metricSpecCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Spec for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeSpec rouge_spec = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RougeSpec,
            com.google.cloud.aiplatform.v1beta1.RougeSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.RougeSpecOrBuilder>
        getRougeSpecFieldBuilder() {
      if (rougeSpecBuilder_ == null) {
        if (!(metricSpecCase_ == 6)) {
          metricSpec_ = com.google.cloud.aiplatform.v1beta1.RougeSpec.getDefaultInstance();
        }
        rougeSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RougeSpec,
                com.google.cloud.aiplatform.v1beta1.RougeSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.RougeSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.RougeSpec) metricSpec_,
                getParentForChildren(),
                isClean());
        metricSpec_ = null;
      }
      metricSpecCase_ = 6;
      onChanged();
      return rougeSpecBuilder_;
    }

    private java.util.List<java.lang.Integer> aggregationMetrics_ =
        java.util.Collections.emptyList();

    private void ensureAggregationMetricsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        aggregationMetrics_ = new java.util.ArrayList<java.lang.Integer>(aggregationMetrics_);
        bitField0_ |= 0x00000020;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the aggregationMetrics.
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>
        getAggregationMetricsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>(
          aggregationMetrics_, aggregationMetrics_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of aggregationMetrics.
     */
    public int getAggregationMetricsCount() {
      return aggregationMetrics_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The aggregationMetrics at the given index.
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric getAggregationMetrics(
        int index) {
      return aggregationMetrics_converter_.convert(aggregationMetrics_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The aggregationMetrics to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAggregationMetricsIsMutable();
      aggregationMetrics_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The aggregationMetrics to add.
     * @return This builder for chaining.
     */
    public Builder addAggregationMetrics(
        com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAggregationMetricsIsMutable();
      aggregationMetrics_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The aggregationMetrics to add.
     * @return This builder for chaining.
     */
    public Builder addAllAggregationMetrics(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric>
            values) {
      ensureAggregationMetricsIsMutable();
      for (com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric value : values) {
        aggregationMetrics_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAggregationMetrics() {
      aggregationMetrics_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for aggregationMetrics.
     */
    public java.util.List<java.lang.Integer> getAggregationMetricsValueList() {
      return java.util.Collections.unmodifiableList(aggregationMetrics_);
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of aggregationMetrics at the given index.
     */
    public int getAggregationMetricsValue(int index) {
      return aggregationMetrics_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for aggregationMetrics to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationMetricsValue(int index, int value) {
      ensureAggregationMetricsIsMutable();
      aggregationMetrics_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for aggregationMetrics to add.
     * @return This builder for chaining.
     */
    public Builder addAggregationMetricsValue(int value) {
      ensureAggregationMetricsIsMutable();
      aggregationMetrics_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The aggregation metrics to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metrics = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for aggregationMetrics to add.
     * @return This builder for chaining.
     */
    public Builder addAllAggregationMetricsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureAggregationMetricsIsMutable();
      for (int value : values) {
        aggregationMetrics_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Metric)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Metric)
  private static final com.google.cloud.aiplatform.v1beta1.Metric DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Metric();
  }

  public static com.google.cloud.aiplatform.v1beta1.Metric getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Metric> PARSER =
      new com.google.protobuf.AbstractParser<Metric>() {
        @java.lang.Override
        public Metric parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Metric> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Metric> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Metric getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
