/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Specification of a container for serving predictions. Some fields in this
 * message correspond to fields in the [Kubernetes Container v1 core
 * specification](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelContainerSpec}
 */
public final class ModelContainerSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
    ModelContainerSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ModelContainerSpec.newBuilder() to construct.
  private ModelContainerSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelContainerSpec() {
    imageUri_ = "";
    command_ = com.google.protobuf.LazyStringArrayList.emptyList();
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    env_ = java.util.Collections.emptyList();
    ports_ = java.util.Collections.emptyList();
    predictRoute_ = "";
    healthRoute_ = "";
    invokeRoutePrefix_ = "";
    grpcPorts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelContainerSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.class,
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder.class);
  }

  private int bitField0_;
  public static final int IMAGE_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. Immutable. URI of the Docker image to be used as the custom
   * container for serving predictions. This URI must identify an image in
   * Artifact Registry or Container Registry. Learn more about the [container
   * publishing
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
   * including permissions requirements for the Vertex AI Service Agent.
   *
   * The container image is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
   * stored internally, and this original path is afterwards not used.
   *
   * To learn about the requirements for the Docker image itself, see
   * [Custom container
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
   *
   * You can use the URI to one of Vertex AI's [pre-built container images for
   * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
   * in this field.
   * </pre>
   *
   * <code>
   * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. URI of the Docker image to be used as the custom
   * container for serving predictions. This URI must identify an image in
   * Artifact Registry or Container Registry. Learn more about the [container
   * publishing
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
   * including permissions requirements for the Vertex AI Service Agent.
   *
   * The container image is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
   * stored internally, and this original path is afterwards not used.
   *
   * To learn about the requirements for the Docker image itself, see
   * [Custom container
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
   *
   * You can use the URI to one of Vertex AI's [pre-built container images for
   * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
   * in this field.
   * </pre>
   *
   * <code>
   * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMAND_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList command_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
   * the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
   * exists. If this field is not specified and the container does not have an
   * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
   * `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the command.
   */
  public com.google.protobuf.ProtocolStringList getCommandList() {
    return command_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
   * the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
   * exists. If this field is not specified and the container does not have an
   * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
   * `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of command.
   */
  public int getCommandCount() {
    return command_.size();
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
   * the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
   * exists. If this field is not specified and the container does not have an
   * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
   * `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The command at the given index.
   */
  public java.lang.String getCommand(int index) {
    return command_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
   * the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
   * exists. If this field is not specified and the container does not have an
   * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
   * `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the command at the given index.
   */
  public com.google.protobuf.ByteString getCommandBytes(int index) {
    return command_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
   * field, then the command from the `command` field runs without any
   * additional arguments. See the [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
   * field, then the command from the `command` field runs without any
   * additional arguments. See the [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
   * field, then the command from the `command` field runs without any
   * additional arguments. See the [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
   * field, then the command from the `command` field runs without any
   * additional arguments. See the [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
   * cannot reference environment variables set in the Docker image. In order
   * for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int ENV_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> env_;

  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList() {
    return env_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
      getEnvOrBuilderList() {
    return env_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getEnvCount() {
    return env_.size();
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index) {
    return env_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index) {
    return env_.get(index);
  }

  public static final int PORTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Port> ports_;

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Port> getPortsList() {
    return ports_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
      getPortsOrBuilderList() {
    return ports_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getPortsCount() {
    return ports_.size();
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Port getPorts(int index) {
    return ports_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PortOrBuilder getPortsOrBuilder(int index) {
    return ports_.get(index);
  }

  public static final int PREDICT_ROUTE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predictRoute_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send prediction requests to.
   * Vertex AI forwards requests sent using
   * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
   * to this path on the container's IP address and port. Vertex AI then returns
   * the container's response in the API response.
   *
   * For example, if you set this field to `/foo`, then when Vertex AI
   * receives a prediction request, it forwards the request body in a POST
   * request to the `/foo` path on the port of your container specified by the
   * first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code
   *   as the [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The predictRoute.
   */
  @java.lang.Override
  public java.lang.String getPredictRoute() {
    java.lang.Object ref = predictRoute_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predictRoute_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send prediction requests to.
   * Vertex AI forwards requests sent using
   * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
   * to this path on the container's IP address and port. Vertex AI then returns
   * the container's response in the API response.
   *
   * For example, if you set this field to `/foo`, then when Vertex AI
   * receives a prediction request, it forwards the request body in a POST
   * request to the `/foo` path on the port of your container specified by the
   * first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code
   *   as the [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for predictRoute.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredictRouteBytes() {
    java.lang.Object ref = predictRoute_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predictRoute_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_ROUTE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object healthRoute_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send health checks to. Vertex AI
   * intermittently sends GET requests to this path on the container's IP
   * address and port to check that the container is healthy. Read more about
   * [health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
   *
   * For example, if you set this field to `/bar`, then Vertex AI
   * intermittently sends a GET request to the `/bar` path on the port of your
   * container specified by the first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code as the
   *   [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The healthRoute.
   */
  @java.lang.Override
  public java.lang.String getHealthRoute() {
    java.lang.Object ref = healthRoute_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthRoute_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send health checks to. Vertex AI
   * intermittently sends GET requests to this path on the container's IP
   * address and port to check that the container is healthy. Read more about
   * [health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
   *
   * For example, if you set this field to `/bar`, then Vertex AI
   * intermittently sends a GET request to the `/bar` path on the port of your
   * container specified by the first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code as the
   *   [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for healthRoute.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthRouteBytes() {
    java.lang.Object ref = healthRoute_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthRoute_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVOKE_ROUTE_PREFIX_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object invokeRoutePrefix_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
   * supported value right now. By setting this field, any non-root route on
   * this model will be accessible with [PredictionService.Invoke] eg:
   * "/invoke/foo/bar".
   *
   * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
   * default to using `predict_route` if this field is not set. If this field
   * is set, the Model can only be deployed to dedicated endpoint.
   * </pre>
   *
   * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The invokeRoutePrefix.
   */
  @java.lang.Override
  public java.lang.String getInvokeRoutePrefix() {
    java.lang.Object ref = invokeRoutePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      invokeRoutePrefix_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
   * supported value right now. By setting this field, any non-root route on
   * this model will be accessible with [PredictionService.Invoke] eg:
   * "/invoke/foo/bar".
   *
   * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
   * default to using `predict_route` if this field is not set. If this field
   * is set, the Model can only be deployed to dedicated endpoint.
   * </pre>
   *
   * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for invokeRoutePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInvokeRoutePrefixBytes() {
    java.lang.Object ref = invokeRoutePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      invokeRoutePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GRPC_PORTS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Port> grpcPorts_;

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Port> getGrpcPortsList() {
    return grpcPorts_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
      getGrpcPortsOrBuilderList() {
    return grpcPorts_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getGrpcPortsCount() {
    return grpcPorts_.size();
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Port getGrpcPorts(int index) {
    return grpcPorts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PortOrBuilder getGrpcPortsOrBuilder(int index) {
    return grpcPorts_.get(index);
  }

  public static final int DEPLOYMENT_TIMEOUT_FIELD_NUMBER = 10;
  private com.google.protobuf.Duration deploymentTimeout_;

  /**
   *
   *
   * <pre>
   * Immutable. Deployment timeout.
   * Limit for deployment timeout is 2 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the deploymentTimeout field is set.
   */
  @java.lang.Override
  public boolean hasDeploymentTimeout() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Deployment timeout.
   * Limit for deployment timeout is 2 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The deploymentTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDeploymentTimeout() {
    return deploymentTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : deploymentTimeout_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Deployment timeout.
   * Limit for deployment timeout is 2 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDeploymentTimeoutOrBuilder() {
    return deploymentTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : deploymentTimeout_;
  }

  public static final int SHARED_MEMORY_SIZE_MB_FIELD_NUMBER = 11;
  private long sharedMemorySizeMb_ = 0L;

  /**
   *
   *
   * <pre>
   * Immutable. The amount of the VM memory to reserve as the shared memory for
   * the model in megabytes.
   * </pre>
   *
   * <code>int64 shared_memory_size_mb = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The sharedMemorySizeMb.
   */
  @java.lang.Override
  public long getSharedMemorySizeMb() {
    return sharedMemorySizeMb_;
  }

  public static final int STARTUP_PROBE_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1beta1.Probe startupProbe_;

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes startup probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the startupProbe field is set.
   */
  @java.lang.Override
  public boolean hasStartupProbe() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes startup probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The startupProbe.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Probe getStartupProbe() {
    return startupProbe_ == null
        ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
        : startupProbe_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes startup probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder getStartupProbeOrBuilder() {
    return startupProbe_ == null
        ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
        : startupProbe_;
  }

  public static final int HEALTH_PROBE_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.Probe healthProbe_;

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes readiness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the healthProbe field is set.
   */
  @java.lang.Override
  public boolean hasHealthProbe() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes readiness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The healthProbe.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Probe getHealthProbe() {
    return healthProbe_ == null
        ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
        : healthProbe_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes readiness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder getHealthProbeOrBuilder() {
    return healthProbe_ == null
        ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
        : healthProbe_;
  }

  public static final int LIVENESS_PROBE_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1beta1.Probe livenessProbe_;

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes liveness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the livenessProbe field is set.
   */
  @java.lang.Override
  public boolean hasLivenessProbe() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes liveness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The livenessProbe.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Probe getLivenessProbe() {
    return livenessProbe_ == null
        ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
        : livenessProbe_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes liveness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder getLivenessProbeOrBuilder() {
    return livenessProbe_ == null
        ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
        : livenessProbe_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUri_);
    }
    for (int i = 0; i < command_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, command_.getRaw(i));
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
    }
    for (int i = 0; i < env_.size(); i++) {
      output.writeMessage(4, env_.get(i));
    }
    for (int i = 0; i < ports_.size(); i++) {
      output.writeMessage(5, ports_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predictRoute_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, predictRoute_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(healthRoute_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, healthRoute_);
    }
    for (int i = 0; i < grpcPorts_.size(); i++) {
      output.writeMessage(9, grpcPorts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getDeploymentTimeout());
    }
    if (sharedMemorySizeMb_ != 0L) {
      output.writeInt64(11, sharedMemorySizeMb_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getStartupProbe());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getHealthProbe());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getLivenessProbe());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(invokeRoutePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, invokeRoutePrefix_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < command_.size(); i++) {
        dataSize += computeStringSizeNoTag(command_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCommandList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    for (int i = 0; i < env_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, env_.get(i));
    }
    for (int i = 0; i < ports_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, ports_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predictRoute_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, predictRoute_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(healthRoute_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, healthRoute_);
    }
    for (int i = 0; i < grpcPorts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, grpcPorts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDeploymentTimeout());
    }
    if (sharedMemorySizeMb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, sharedMemorySizeMb_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getStartupProbe());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getHealthProbe());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getLivenessProbe());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(invokeRoutePrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, invokeRoutePrefix_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelContainerSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelContainerSpec other =
        (com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) obj;

    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getCommandList().equals(other.getCommandList())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (!getPortsList().equals(other.getPortsList())) return false;
    if (!getPredictRoute().equals(other.getPredictRoute())) return false;
    if (!getHealthRoute().equals(other.getHealthRoute())) return false;
    if (!getInvokeRoutePrefix().equals(other.getInvokeRoutePrefix())) return false;
    if (!getGrpcPortsList().equals(other.getGrpcPortsList())) return false;
    if (hasDeploymentTimeout() != other.hasDeploymentTimeout()) return false;
    if (hasDeploymentTimeout()) {
      if (!getDeploymentTimeout().equals(other.getDeploymentTimeout())) return false;
    }
    if (getSharedMemorySizeMb() != other.getSharedMemorySizeMb()) return false;
    if (hasStartupProbe() != other.hasStartupProbe()) return false;
    if (hasStartupProbe()) {
      if (!getStartupProbe().equals(other.getStartupProbe())) return false;
    }
    if (hasHealthProbe() != other.hasHealthProbe()) return false;
    if (hasHealthProbe()) {
      if (!getHealthProbe().equals(other.getHealthProbe())) return false;
    }
    if (hasLivenessProbe() != other.hasLivenessProbe()) return false;
    if (hasLivenessProbe()) {
      if (!getLivenessProbe().equals(other.getLivenessProbe())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    if (getCommandCount() > 0) {
      hash = (37 * hash) + COMMAND_FIELD_NUMBER;
      hash = (53 * hash) + getCommandList().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    if (getPortsCount() > 0) {
      hash = (37 * hash) + PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getPortsList().hashCode();
    }
    hash = (37 * hash) + PREDICT_ROUTE_FIELD_NUMBER;
    hash = (53 * hash) + getPredictRoute().hashCode();
    hash = (37 * hash) + HEALTH_ROUTE_FIELD_NUMBER;
    hash = (53 * hash) + getHealthRoute().hashCode();
    hash = (37 * hash) + INVOKE_ROUTE_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getInvokeRoutePrefix().hashCode();
    if (getGrpcPortsCount() > 0) {
      hash = (37 * hash) + GRPC_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getGrpcPortsList().hashCode();
    }
    if (hasDeploymentTimeout()) {
      hash = (37 * hash) + DEPLOYMENT_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getDeploymentTimeout().hashCode();
    }
    hash = (37 * hash) + SHARED_MEMORY_SIZE_MB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSharedMemorySizeMb());
    if (hasStartupProbe()) {
      hash = (37 * hash) + STARTUP_PROBE_FIELD_NUMBER;
      hash = (53 * hash) + getStartupProbe().hashCode();
    }
    if (hasHealthProbe()) {
      hash = (37 * hash) + HEALTH_PROBE_FIELD_NUMBER;
      hash = (53 * hash) + getHealthProbe().hashCode();
    }
    if (hasLivenessProbe()) {
      hash = (37 * hash) + LIVENESS_PROBE_FIELD_NUMBER;
      hash = (53 * hash) + getLivenessProbe().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specification of a container for serving predictions. Some fields in this
   * message correspond to fields in the [Kubernetes Container v1 core
   * specification](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelContainerSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.class,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEnvFieldBuilder();
        getPortsFieldBuilder();
        getGrpcPortsFieldBuilder();
        getDeploymentTimeoutFieldBuilder();
        getStartupProbeFieldBuilder();
        getHealthProbeFieldBuilder();
        getLivenessProbeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      imageUri_ = "";
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
      } else {
        env_ = null;
        envBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (portsBuilder_ == null) {
        ports_ = java.util.Collections.emptyList();
      } else {
        ports_ = null;
        portsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      predictRoute_ = "";
      healthRoute_ = "";
      invokeRoutePrefix_ = "";
      if (grpcPortsBuilder_ == null) {
        grpcPorts_ = java.util.Collections.emptyList();
      } else {
        grpcPorts_ = null;
        grpcPortsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      deploymentTimeout_ = null;
      if (deploymentTimeoutBuilder_ != null) {
        deploymentTimeoutBuilder_.dispose();
        deploymentTimeoutBuilder_ = null;
      }
      sharedMemorySizeMb_ = 0L;
      startupProbe_ = null;
      if (startupProbeBuilder_ != null) {
        startupProbeBuilder_.dispose();
        startupProbeBuilder_ = null;
      }
      healthProbe_ = null;
      if (healthProbeBuilder_ != null) {
        healthProbeBuilder_.dispose();
        healthProbeBuilder_ = null;
      }
      livenessProbe_ = null;
      if (livenessProbeBuilder_ != null) {
        livenessProbeBuilder_.dispose();
        livenessProbeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec build() {
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec result =
          new com.google.cloud.aiplatform.v1beta1.ModelContainerSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ModelContainerSpec result) {
      if (envBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          env_ = java.util.Collections.unmodifiableList(env_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.env_ = env_;
      } else {
        result.env_ = envBuilder_.build();
      }
      if (portsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          ports_ = java.util.Collections.unmodifiableList(ports_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.ports_ = ports_;
      } else {
        result.ports_ = portsBuilder_.build();
      }
      if (grpcPortsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          grpcPorts_ = java.util.Collections.unmodifiableList(grpcPorts_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.grpcPorts_ = grpcPorts_;
      } else {
        result.grpcPorts_ = grpcPortsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelContainerSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.imageUri_ = imageUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        command_.makeImmutable();
        result.command_ = command_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.predictRoute_ = predictRoute_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.healthRoute_ = healthRoute_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.invokeRoutePrefix_ = invokeRoutePrefix_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deploymentTimeout_ =
            deploymentTimeoutBuilder_ == null
                ? deploymentTimeout_
                : deploymentTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.sharedMemorySizeMb_ = sharedMemorySizeMb_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.startupProbe_ =
            startupProbeBuilder_ == null ? startupProbe_ : startupProbeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.healthProbe_ =
            healthProbeBuilder_ == null ? healthProbe_ : healthProbeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.livenessProbe_ =
            livenessProbeBuilder_ == null ? livenessProbe_ : livenessProbeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelContainerSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance())
        return this;
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.command_.isEmpty()) {
        if (command_.isEmpty()) {
          command_ = other.command_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCommandIsMutable();
          command_.addAll(other.command_);
        }
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000004;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (envBuilder_ == null) {
        if (!other.env_.isEmpty()) {
          if (env_.isEmpty()) {
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureEnvIsMutable();
            env_.addAll(other.env_);
          }
          onChanged();
        }
      } else {
        if (!other.env_.isEmpty()) {
          if (envBuilder_.isEmpty()) {
            envBuilder_.dispose();
            envBuilder_ = null;
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000008);
            envBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnvFieldBuilder()
                    : null;
          } else {
            envBuilder_.addAllMessages(other.env_);
          }
        }
      }
      if (portsBuilder_ == null) {
        if (!other.ports_.isEmpty()) {
          if (ports_.isEmpty()) {
            ports_ = other.ports_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensurePortsIsMutable();
            ports_.addAll(other.ports_);
          }
          onChanged();
        }
      } else {
        if (!other.ports_.isEmpty()) {
          if (portsBuilder_.isEmpty()) {
            portsBuilder_.dispose();
            portsBuilder_ = null;
            ports_ = other.ports_;
            bitField0_ = (bitField0_ & ~0x00000010);
            portsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPortsFieldBuilder()
                    : null;
          } else {
            portsBuilder_.addAllMessages(other.ports_);
          }
        }
      }
      if (!other.getPredictRoute().isEmpty()) {
        predictRoute_ = other.predictRoute_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getHealthRoute().isEmpty()) {
        healthRoute_ = other.healthRoute_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getInvokeRoutePrefix().isEmpty()) {
        invokeRoutePrefix_ = other.invokeRoutePrefix_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (grpcPortsBuilder_ == null) {
        if (!other.grpcPorts_.isEmpty()) {
          if (grpcPorts_.isEmpty()) {
            grpcPorts_ = other.grpcPorts_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureGrpcPortsIsMutable();
            grpcPorts_.addAll(other.grpcPorts_);
          }
          onChanged();
        }
      } else {
        if (!other.grpcPorts_.isEmpty()) {
          if (grpcPortsBuilder_.isEmpty()) {
            grpcPortsBuilder_.dispose();
            grpcPortsBuilder_ = null;
            grpcPorts_ = other.grpcPorts_;
            bitField0_ = (bitField0_ & ~0x00000100);
            grpcPortsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGrpcPortsFieldBuilder()
                    : null;
          } else {
            grpcPortsBuilder_.addAllMessages(other.grpcPorts_);
          }
        }
      }
      if (other.hasDeploymentTimeout()) {
        mergeDeploymentTimeout(other.getDeploymentTimeout());
      }
      if (other.getSharedMemorySizeMb() != 0L) {
        setSharedMemorySizeMb(other.getSharedMemorySizeMb());
      }
      if (other.hasStartupProbe()) {
        mergeStartupProbe(other.getStartupProbe());
      }
      if (other.hasHealthProbe()) {
        mergeHealthProbe(other.getHealthProbe());
      }
      if (other.hasLivenessProbe()) {
        mergeLivenessProbe(other.getLivenessProbe());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                imageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCommandIsMutable();
                command_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.EnvVar m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.EnvVar.parser(), extensionRegistry);
                if (envBuilder_ == null) {
                  ensureEnvIsMutable();
                  env_.add(m);
                } else {
                  envBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.aiplatform.v1beta1.Port m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Port.parser(), extensionRegistry);
                if (portsBuilder_ == null) {
                  ensurePortsIsMutable();
                  ports_.add(m);
                } else {
                  portsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                predictRoute_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                healthRoute_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                com.google.cloud.aiplatform.v1beta1.Port m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Port.parser(), extensionRegistry);
                if (grpcPortsBuilder_ == null) {
                  ensureGrpcPortsIsMutable();
                  grpcPorts_.add(m);
                } else {
                  grpcPortsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getDeploymentTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                sharedMemorySizeMb_ = input.readInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getStartupProbeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getHealthProbeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getLivenessProbeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                invokeRoutePrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom
     * container for serving predictions. This URI must identify an image in
     * Artifact Registry or Container Registry. Learn more about the [container
     * publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     *
     * The container image is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
     * stored internally, and this original path is afterwards not used.
     *
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     *
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom
     * container for serving predictions. This URI must identify an image in
     * Artifact Registry or Container Registry. Learn more about the [container
     * publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     *
     * The container image is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
     * stored internally, and this original path is afterwards not used.
     *
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     *
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom
     * container for serving predictions. This URI must identify an image in
     * Artifact Registry or Container Registry. Learn more about the [container
     * publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     *
     * The container image is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
     * stored internally, and this original path is afterwards not used.
     *
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     *
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom
     * container for serving predictions. This URI must identify an image in
     * Artifact Registry or Container Registry. Learn more about the [container
     * publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     *
     * The container image is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
     * stored internally, and this original path is afterwards not used.
     *
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     *
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {
      imageUri_ = getDefaultInstance().getImageUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom
     * container for serving predictions. This URI must identify an image in
     * Artifact Registry or Container Registry. Learn more about the [container
     * publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     *
     * The container image is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel],
     * stored internally, and this original path is afterwards not used.
     *
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     *
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList command_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCommandIsMutable() {
      if (!command_.isModifiable()) {
        command_ = new com.google.protobuf.LazyStringArrayList(command_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the command.
     */
    public com.google.protobuf.ProtocolStringList getCommandList() {
      command_.makeImmutable();
      return command_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of command.
     */
    public int getCommandCount() {
      return command_.size();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    public java.lang.String getCommand(int index) {
      return command_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    public com.google.protobuf.ByteString getCommandBytes(int index) {
      return command_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index to set the value at.
     * @param value The command to set.
     * @return This builder for chaining.
     */
    public Builder setCommand(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The command to add.
     * @return This builder for chaining.
     */
    public Builder addCommand(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param values The command to add.
     * @return This builder for chaining.
     */
    public Builder addAllCommand(java.lang.Iterable<java.lang.String> values) {
      ensureCommandIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, command_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommand() {
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This
     * overrides the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or
     * the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either
     * exists. If this field is not specified and the container does not have an
     * `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and
     * `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes of the command to add.
     * @return This builder for chaining.
     */
    public Builder addCommandBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCommandIsMutable();
      command_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container
     * starts. This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     *
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command]
     * field, then the command from the `command` field runs without any
     * additional arguments. See the [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the
     * [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field. You
     * cannot reference environment variables set in the Docker image. In order
     * for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> env_ =
        java.util.Collections.emptyList();

    private void ensureEnvIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        env_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.EnvVar>(env_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EnvVar,
            com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
            com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        envBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList() {
      if (envBuilder_ == null) {
        return java.util.Collections.unmodifiableList(env_);
      } else {
        return envBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getEnvCount() {
      if (envBuilder_ == null) {
        return env_.size();
      } else {
        return envBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEnv(int index, com.google.cloud.aiplatform.v1beta1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.set(index, value);
        onChanged();
      } else {
        envBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEnv(
        int index, com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.set(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(com.google.cloud.aiplatform.v1beta1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(value);
        onChanged();
      } else {
        envBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(int index, com.google.cloud.aiplatform.v1beta1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(index, value);
        onChanged();
      } else {
        envBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(
        int index, com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllEnv(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.EnvVar> values) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
        onChanged();
      } else {
        envBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearEnv() {
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        envBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removeEnv(int index) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.remove(index);
        onChanged();
      } else {
        envBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder getEnvBuilder(int index) {
      return getEnvFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        getEnvOrBuilderList() {
      if (envBuilder_ != null) {
        return envBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(env_);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder addEnvBuilder() {
      return getEnvFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.EnvVar.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder addEnvBuilder(int index) {
      return getEnvFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.EnvVar.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the
     * container starts running, code running in the container can read these
     * environment variables.
     *
     * Additionally, the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can
     * reference these variables. Later entries in this list can also reference
     * earlier entries. For example, the following example sets the variable
     * `VAR_2` to have the value `foo bar`:
     *
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     *
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     *
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar.Builder> getEnvBuilderList() {
      return getEnvFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EnvVar,
            com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
            com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        getEnvFieldBuilder() {
      if (envBuilder_ == null) {
        envBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EnvVar,
                com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
                com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>(
                env_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        env_ = null;
      }
      return envBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Port> ports_ =
        java.util.Collections.emptyList();

    private void ensurePortsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        ports_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Port>(ports_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Port,
            com.google.cloud.aiplatform.v1beta1.Port.Builder,
            com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        portsBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Port> getPortsList() {
      if (portsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ports_);
      } else {
        return portsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getPortsCount() {
      if (portsBuilder_ == null) {
        return ports_.size();
      } else {
        return portsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port getPorts(int index) {
      if (portsBuilder_ == null) {
        return ports_.get(index);
      } else {
        return portsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setPorts(int index, com.google.cloud.aiplatform.v1beta1.Port value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.set(index, value);
        onChanged();
      } else {
        portsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setPorts(
        int index, com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.set(index, builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(com.google.cloud.aiplatform.v1beta1.Port value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.add(value);
        onChanged();
      } else {
        portsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(int index, com.google.cloud.aiplatform.v1beta1.Port value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.add(index, value);
        onChanged();
      } else {
        portsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.add(builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(
        int index, com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.add(index, builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllPorts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Port> values) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
        onChanged();
      } else {
        portsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearPorts() {
      if (portsBuilder_ == null) {
        ports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        portsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removePorts(int index) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.remove(index);
        onChanged();
      } else {
        portsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder getPortsBuilder(int index) {
      return getPortsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PortOrBuilder getPortsOrBuilder(int index) {
      if (portsBuilder_ == null) {
        return ports_.get(index);
      } else {
        return portsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        getPortsOrBuilderList() {
      if (portsBuilder_ != null) {
        return portsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ports_);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder addPortsBuilder() {
      return getPortsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Port.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder addPortsBuilder(int index) {
      return getPortsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Port.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     *
     * If you do not specify this field, it defaults to following value:
     *
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Port.Builder> getPortsBuilderList() {
      return getPortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Port,
            com.google.cloud.aiplatform.v1beta1.Port.Builder,
            com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        getPortsFieldBuilder() {
      if (portsBuilder_ == null) {
        portsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Port,
                com.google.cloud.aiplatform.v1beta1.Port.Builder,
                com.google.cloud.aiplatform.v1beta1.PortOrBuilder>(
                ports_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        ports_ = null;
      }
      return portsBuilder_;
    }

    private java.lang.Object predictRoute_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to.
     * Vertex AI forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
     * to this path on the container's IP address and port. Vertex AI then returns
     * the container's response in the API response.
     *
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The predictRoute.
     */
    public java.lang.String getPredictRoute() {
      java.lang.Object ref = predictRoute_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predictRoute_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to.
     * Vertex AI forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
     * to this path on the container's IP address and port. Vertex AI then returns
     * the container's response in the API response.
     *
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for predictRoute.
     */
    public com.google.protobuf.ByteString getPredictRouteBytes() {
      java.lang.Object ref = predictRoute_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predictRoute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to.
     * Vertex AI forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
     * to this path on the container's IP address and port. Vertex AI then returns
     * the container's response in the API response.
     *
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The predictRoute to set.
     * @return This builder for chaining.
     */
    public Builder setPredictRoute(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predictRoute_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to.
     * Vertex AI forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
     * to this path on the container's IP address and port. Vertex AI then returns
     * the container's response in the API response.
     *
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredictRoute() {
      predictRoute_ = getDefaultInstance().getPredictRoute();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to.
     * Vertex AI forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict]
     * to this path on the container's IP address and port. Vertex AI then returns
     * the container's response in the API response.
     *
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for predictRoute to set.
     * @return This builder for chaining.
     */
    public Builder setPredictRouteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predictRoute_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object healthRoute_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     *
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The healthRoute.
     */
    public java.lang.String getHealthRoute() {
      java.lang.Object ref = healthRoute_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthRoute_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     *
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for healthRoute.
     */
    public com.google.protobuf.ByteString getHealthRouteBytes() {
      java.lang.Object ref = healthRoute_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthRoute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     *
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The healthRoute to set.
     * @return This builder for chaining.
     */
    public Builder setHealthRoute(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      healthRoute_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     *
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthRoute() {
      healthRoute_ = getDefaultInstance().getHealthRoute();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     *
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     *
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an
     * Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     *
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
     * [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the
     * `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for healthRoute to set.
     * @return This builder for chaining.
     */
    public Builder setHealthRouteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      healthRoute_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object invokeRoutePrefix_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
     * supported value right now. By setting this field, any non-root route on
     * this model will be accessible with [PredictionService.Invoke] eg:
     * "/invoke/foo/bar".
     *
     * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
     * default to using `predict_route` if this field is not set. If this field
     * is set, the Model can only be deployed to dedicated endpoint.
     * </pre>
     *
     * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The invokeRoutePrefix.
     */
    public java.lang.String getInvokeRoutePrefix() {
      java.lang.Object ref = invokeRoutePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        invokeRoutePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
     * supported value right now. By setting this field, any non-root route on
     * this model will be accessible with [PredictionService.Invoke] eg:
     * "/invoke/foo/bar".
     *
     * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
     * default to using `predict_route` if this field is not set. If this field
     * is set, the Model can only be deployed to dedicated endpoint.
     * </pre>
     *
     * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for invokeRoutePrefix.
     */
    public com.google.protobuf.ByteString getInvokeRoutePrefixBytes() {
      java.lang.Object ref = invokeRoutePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        invokeRoutePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
     * supported value right now. By setting this field, any non-root route on
     * this model will be accessible with [PredictionService.Invoke] eg:
     * "/invoke/foo/bar".
     *
     * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
     * default to using `predict_route` if this field is not set. If this field
     * is set, the Model can only be deployed to dedicated endpoint.
     * </pre>
     *
     * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The invokeRoutePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setInvokeRoutePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      invokeRoutePrefix_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
     * supported value right now. By setting this field, any non-root route on
     * this model will be accessible with [PredictionService.Invoke] eg:
     * "/invoke/foo/bar".
     *
     * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
     * default to using `predict_route` if this field is not set. If this field
     * is set, the Model can only be deployed to dedicated endpoint.
     * </pre>
     *
     * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvokeRoutePrefix() {
      invokeRoutePrefix_ = getDefaultInstance().getInvokeRoutePrefix();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Invoke route prefix for the custom container. "/&#42;" is the only
     * supported value right now. By setting this field, any non-root route on
     * this model will be accessible with [PredictionService.Invoke] eg:
     * "/invoke/foo/bar".
     *
     * Only one of `predict_route` or `invoke_route_prefix` can be set, and we
     * default to using `predict_route` if this field is not set. If this field
     * is set, the Model can only be deployed to dedicated endpoint.
     * </pre>
     *
     * <code>string invoke_route_prefix = 15 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for invokeRoutePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setInvokeRoutePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      invokeRoutePrefix_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Port> grpcPorts_ =
        java.util.Collections.emptyList();

    private void ensureGrpcPortsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        grpcPorts_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Port>(grpcPorts_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Port,
            com.google.cloud.aiplatform.v1beta1.Port.Builder,
            com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        grpcPortsBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Port> getGrpcPortsList() {
      if (grpcPortsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(grpcPorts_);
      } else {
        return grpcPortsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getGrpcPortsCount() {
      if (grpcPortsBuilder_ == null) {
        return grpcPorts_.size();
      } else {
        return grpcPortsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port getGrpcPorts(int index) {
      if (grpcPortsBuilder_ == null) {
        return grpcPorts_.get(index);
      } else {
        return grpcPortsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setGrpcPorts(int index, com.google.cloud.aiplatform.v1beta1.Port value) {
      if (grpcPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGrpcPortsIsMutable();
        grpcPorts_.set(index, value);
        onChanged();
      } else {
        grpcPortsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setGrpcPorts(
        int index, com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (grpcPortsBuilder_ == null) {
        ensureGrpcPortsIsMutable();
        grpcPorts_.set(index, builderForValue.build());
        onChanged();
      } else {
        grpcPortsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addGrpcPorts(com.google.cloud.aiplatform.v1beta1.Port value) {
      if (grpcPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGrpcPortsIsMutable();
        grpcPorts_.add(value);
        onChanged();
      } else {
        grpcPortsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addGrpcPorts(int index, com.google.cloud.aiplatform.v1beta1.Port value) {
      if (grpcPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGrpcPortsIsMutable();
        grpcPorts_.add(index, value);
        onChanged();
      } else {
        grpcPortsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addGrpcPorts(com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (grpcPortsBuilder_ == null) {
        ensureGrpcPortsIsMutable();
        grpcPorts_.add(builderForValue.build());
        onChanged();
      } else {
        grpcPortsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addGrpcPorts(
        int index, com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (grpcPortsBuilder_ == null) {
        ensureGrpcPortsIsMutable();
        grpcPorts_.add(index, builderForValue.build());
        onChanged();
      } else {
        grpcPortsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllGrpcPorts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Port> values) {
      if (grpcPortsBuilder_ == null) {
        ensureGrpcPortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, grpcPorts_);
        onChanged();
      } else {
        grpcPortsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearGrpcPorts() {
      if (grpcPortsBuilder_ == null) {
        grpcPorts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        grpcPortsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removeGrpcPorts(int index) {
      if (grpcPortsBuilder_ == null) {
        ensureGrpcPortsIsMutable();
        grpcPorts_.remove(index);
        onChanged();
      } else {
        grpcPortsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder getGrpcPortsBuilder(int index) {
      return getGrpcPortsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PortOrBuilder getGrpcPortsOrBuilder(int index) {
      if (grpcPortsBuilder_ == null) {
        return grpcPorts_.get(index);
      } else {
        return grpcPortsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        getGrpcPortsOrBuilderList() {
      if (grpcPortsBuilder_ != null) {
        return grpcPortsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(grpcPorts_);
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder addGrpcPortsBuilder() {
      return getGrpcPortsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Port.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder addGrpcPortsBuilder(int index) {
      return getGrpcPortsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Port.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends liveness and health checks to this port.
     *
     * If you do not specify this field, gRPC requests to the container will be
     * disabled.
     *
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Port.Builder>
        getGrpcPortsBuilderList() {
      return getGrpcPortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Port,
            com.google.cloud.aiplatform.v1beta1.Port.Builder,
            com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        getGrpcPortsFieldBuilder() {
      if (grpcPortsBuilder_ == null) {
        grpcPortsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Port,
                com.google.cloud.aiplatform.v1beta1.Port.Builder,
                com.google.cloud.aiplatform.v1beta1.PortOrBuilder>(
                grpcPorts_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        grpcPorts_ = null;
      }
      return grpcPortsBuilder_;
    }

    private com.google.protobuf.Duration deploymentTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        deploymentTimeoutBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the deploymentTimeout field is set.
     */
    public boolean hasDeploymentTimeout() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The deploymentTimeout.
     */
    public com.google.protobuf.Duration getDeploymentTimeout() {
      if (deploymentTimeoutBuilder_ == null) {
        return deploymentTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : deploymentTimeout_;
      } else {
        return deploymentTimeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDeploymentTimeout(com.google.protobuf.Duration value) {
      if (deploymentTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentTimeout_ = value;
      } else {
        deploymentTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDeploymentTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (deploymentTimeoutBuilder_ == null) {
        deploymentTimeout_ = builderForValue.build();
      } else {
        deploymentTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeDeploymentTimeout(com.google.protobuf.Duration value) {
      if (deploymentTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && deploymentTimeout_ != null
            && deploymentTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDeploymentTimeoutBuilder().mergeFrom(value);
        } else {
          deploymentTimeout_ = value;
        }
      } else {
        deploymentTimeoutBuilder_.mergeFrom(value);
      }
      if (deploymentTimeout_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearDeploymentTimeout() {
      bitField0_ = (bitField0_ & ~0x00000200);
      deploymentTimeout_ = null;
      if (deploymentTimeoutBuilder_ != null) {
        deploymentTimeoutBuilder_.dispose();
        deploymentTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDeploymentTimeoutBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDeploymentTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDeploymentTimeoutOrBuilder() {
      if (deploymentTimeoutBuilder_ != null) {
        return deploymentTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return deploymentTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : deploymentTimeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Deployment timeout.
     * Limit for deployment timeout is 2 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDeploymentTimeoutFieldBuilder() {
      if (deploymentTimeoutBuilder_ == null) {
        deploymentTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDeploymentTimeout(), getParentForChildren(), isClean());
        deploymentTimeout_ = null;
      }
      return deploymentTimeoutBuilder_;
    }

    private long sharedMemorySizeMb_;

    /**
     *
     *
     * <pre>
     * Immutable. The amount of the VM memory to reserve as the shared memory for
     * the model in megabytes.
     * </pre>
     *
     * <code>int64 shared_memory_size_mb = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The sharedMemorySizeMb.
     */
    @java.lang.Override
    public long getSharedMemorySizeMb() {
      return sharedMemorySizeMb_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The amount of the VM memory to reserve as the shared memory for
     * the model in megabytes.
     * </pre>
     *
     * <code>int64 shared_memory_size_mb = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The sharedMemorySizeMb to set.
     * @return This builder for chaining.
     */
    public Builder setSharedMemorySizeMb(long value) {

      sharedMemorySizeMb_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The amount of the VM memory to reserve as the shared memory for
     * the model in megabytes.
     * </pre>
     *
     * <code>int64 shared_memory_size_mb = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSharedMemorySizeMb() {
      bitField0_ = (bitField0_ & ~0x00000400);
      sharedMemorySizeMb_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Probe startupProbe_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Probe,
            com.google.cloud.aiplatform.v1beta1.Probe.Builder,
            com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>
        startupProbeBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the startupProbe field is set.
     */
    public boolean hasStartupProbe() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The startupProbe.
     */
    public com.google.cloud.aiplatform.v1beta1.Probe getStartupProbe() {
      if (startupProbeBuilder_ == null) {
        return startupProbe_ == null
            ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
            : startupProbe_;
      } else {
        return startupProbeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setStartupProbe(com.google.cloud.aiplatform.v1beta1.Probe value) {
      if (startupProbeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startupProbe_ = value;
      } else {
        startupProbeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setStartupProbe(
        com.google.cloud.aiplatform.v1beta1.Probe.Builder builderForValue) {
      if (startupProbeBuilder_ == null) {
        startupProbe_ = builderForValue.build();
      } else {
        startupProbeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeStartupProbe(com.google.cloud.aiplatform.v1beta1.Probe value) {
      if (startupProbeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && startupProbe_ != null
            && startupProbe_ != com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()) {
          getStartupProbeBuilder().mergeFrom(value);
        } else {
          startupProbe_ = value;
        }
      } else {
        startupProbeBuilder_.mergeFrom(value);
      }
      if (startupProbe_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearStartupProbe() {
      bitField0_ = (bitField0_ & ~0x00000800);
      startupProbe_ = null;
      if (startupProbeBuilder_ != null) {
        startupProbeBuilder_.dispose();
        startupProbeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Probe.Builder getStartupProbeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getStartupProbeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder getStartupProbeOrBuilder() {
      if (startupProbeBuilder_ != null) {
        return startupProbeBuilder_.getMessageOrBuilder();
      } else {
        return startupProbe_ == null
            ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
            : startupProbe_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes startup probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Probe,
            com.google.cloud.aiplatform.v1beta1.Probe.Builder,
            com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>
        getStartupProbeFieldBuilder() {
      if (startupProbeBuilder_ == null) {
        startupProbeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Probe,
                com.google.cloud.aiplatform.v1beta1.Probe.Builder,
                com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>(
                getStartupProbe(), getParentForChildren(), isClean());
        startupProbe_ = null;
      }
      return startupProbeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Probe healthProbe_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Probe,
            com.google.cloud.aiplatform.v1beta1.Probe.Builder,
            com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>
        healthProbeBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the healthProbe field is set.
     */
    public boolean hasHealthProbe() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The healthProbe.
     */
    public com.google.cloud.aiplatform.v1beta1.Probe getHealthProbe() {
      if (healthProbeBuilder_ == null) {
        return healthProbe_ == null
            ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
            : healthProbe_;
      } else {
        return healthProbeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setHealthProbe(com.google.cloud.aiplatform.v1beta1.Probe value) {
      if (healthProbeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        healthProbe_ = value;
      } else {
        healthProbeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setHealthProbe(
        com.google.cloud.aiplatform.v1beta1.Probe.Builder builderForValue) {
      if (healthProbeBuilder_ == null) {
        healthProbe_ = builderForValue.build();
      } else {
        healthProbeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeHealthProbe(com.google.cloud.aiplatform.v1beta1.Probe value) {
      if (healthProbeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && healthProbe_ != null
            && healthProbe_ != com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()) {
          getHealthProbeBuilder().mergeFrom(value);
        } else {
          healthProbe_ = value;
        }
      } else {
        healthProbeBuilder_.mergeFrom(value);
      }
      if (healthProbe_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearHealthProbe() {
      bitField0_ = (bitField0_ & ~0x00001000);
      healthProbe_ = null;
      if (healthProbeBuilder_ != null) {
        healthProbeBuilder_.dispose();
        healthProbeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Probe.Builder getHealthProbeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getHealthProbeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder getHealthProbeOrBuilder() {
      if (healthProbeBuilder_ != null) {
        return healthProbeBuilder_.getMessageOrBuilder();
      } else {
        return healthProbe_ == null
            ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
            : healthProbe_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes readiness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Probe,
            com.google.cloud.aiplatform.v1beta1.Probe.Builder,
            com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>
        getHealthProbeFieldBuilder() {
      if (healthProbeBuilder_ == null) {
        healthProbeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Probe,
                com.google.cloud.aiplatform.v1beta1.Probe.Builder,
                com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>(
                getHealthProbe(), getParentForChildren(), isClean());
        healthProbe_ = null;
      }
      return healthProbeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Probe livenessProbe_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Probe,
            com.google.cloud.aiplatform.v1beta1.Probe.Builder,
            com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>
        livenessProbeBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the livenessProbe field is set.
     */
    public boolean hasLivenessProbe() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The livenessProbe.
     */
    public com.google.cloud.aiplatform.v1beta1.Probe getLivenessProbe() {
      if (livenessProbeBuilder_ == null) {
        return livenessProbe_ == null
            ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
            : livenessProbe_;
      } else {
        return livenessProbeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setLivenessProbe(com.google.cloud.aiplatform.v1beta1.Probe value) {
      if (livenessProbeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        livenessProbe_ = value;
      } else {
        livenessProbeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setLivenessProbe(
        com.google.cloud.aiplatform.v1beta1.Probe.Builder builderForValue) {
      if (livenessProbeBuilder_ == null) {
        livenessProbe_ = builderForValue.build();
      } else {
        livenessProbeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeLivenessProbe(com.google.cloud.aiplatform.v1beta1.Probe value) {
      if (livenessProbeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && livenessProbe_ != null
            && livenessProbe_ != com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()) {
          getLivenessProbeBuilder().mergeFrom(value);
        } else {
          livenessProbe_ = value;
        }
      } else {
        livenessProbeBuilder_.mergeFrom(value);
      }
      if (livenessProbe_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearLivenessProbe() {
      bitField0_ = (bitField0_ & ~0x00002000);
      livenessProbe_ = null;
      if (livenessProbeBuilder_ != null) {
        livenessProbeBuilder_.dispose();
        livenessProbeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Probe.Builder getLivenessProbeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getLivenessProbeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder getLivenessProbeOrBuilder() {
      if (livenessProbeBuilder_ != null) {
        return livenessProbeBuilder_.getMessageOrBuilder();
      } else {
        return livenessProbe_ == null
            ? com.google.cloud.aiplatform.v1beta1.Probe.getDefaultInstance()
            : livenessProbe_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Specification for Kubernetes liveness probe.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Probe liveness_probe = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Probe,
            com.google.cloud.aiplatform.v1beta1.Probe.Builder,
            com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>
        getLivenessProbeFieldBuilder() {
      if (livenessProbeBuilder_ == null) {
        livenessProbeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Probe,
                com.google.cloud.aiplatform.v1beta1.Probe.Builder,
                com.google.cloud.aiplatform.v1beta1.ProbeOrBuilder>(
                getLivenessProbe(), getParentForChildren(), isClean());
        livenessProbe_ = null;
      }
      return livenessProbeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
  private static final com.google.cloud.aiplatform.v1beta1.ModelContainerSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelContainerSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelContainerSpec> PARSER =
      new com.google.protobuf.AbstractParser<ModelContainerSpec>() {
        @java.lang.Override
        public ModelContainerSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelContainerSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelContainerSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
