/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/service_networking.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for PSC-I.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PscInterfaceConfig}
 */
public final class PscInterfaceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PscInterfaceConfig)
    PscInterfaceConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PscInterfaceConfig.newBuilder() to construct.
  private PscInterfaceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PscInterfaceConfig() {
    networkAttachment_ = "";
    dnsPeeringConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PscInterfaceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ServiceNetworkingProto
        .internal_static_google_cloud_aiplatform_v1beta1_PscInterfaceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ServiceNetworkingProto
        .internal_static_google_cloud_aiplatform_v1beta1_PscInterfaceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.class,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder.class);
  }

  public static final int NETWORK_ATTACHMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkAttachment_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the Compute Engine
   * [network
   * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
   * attach to the resource within the region and user project.
   * To specify this field, you must have already [created a network attachment]
   * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
   * This field is only used for resources using PSC-I.
   * </pre>
   *
   * <code>
   * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The networkAttachment.
   */
  @java.lang.Override
  public java.lang.String getNetworkAttachment() {
    java.lang.Object ref = networkAttachment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkAttachment_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the Compute Engine
   * [network
   * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
   * attach to the resource within the region and user project.
   * To specify this field, you must have already [created a network attachment]
   * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
   * This field is only used for resources using PSC-I.
   * </pre>
   *
   * <code>
   * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for networkAttachment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkAttachmentBytes() {
    java.lang.Object ref = networkAttachment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkAttachment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DNS_PEERING_CONFIGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig> dnsPeeringConfigs_;

  /**
   *
   *
   * <pre>
   * Optional. DNS peering configurations. When specified, Vertex AI will
   * attempt to configure DNS peering zones in the tenant project VPC
   * to resolve the specified domains using the target network's Cloud DNS.
   * The user must grant the dns.peer role to the Vertex AI Service Agent
   * on the target project.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig>
      getDnsPeeringConfigsList() {
    return dnsPeeringConfigs_;
  }

  /**
   *
   *
   * <pre>
   * Optional. DNS peering configurations. When specified, Vertex AI will
   * attempt to configure DNS peering zones in the tenant project VPC
   * to resolve the specified domains using the target network's Cloud DNS.
   * The user must grant the dns.peer role to the Vertex AI Service Agent
   * on the target project.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder>
      getDnsPeeringConfigsOrBuilderList() {
    return dnsPeeringConfigs_;
  }

  /**
   *
   *
   * <pre>
   * Optional. DNS peering configurations. When specified, Vertex AI will
   * attempt to configure DNS peering zones in the tenant project VPC
   * to resolve the specified domains using the target network's Cloud DNS.
   * The user must grant the dns.peer role to the Vertex AI Service Agent
   * on the target project.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getDnsPeeringConfigsCount() {
    return dnsPeeringConfigs_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. DNS peering configurations. When specified, Vertex AI will
   * attempt to configure DNS peering zones in the tenant project VPC
   * to resolve the specified domains using the target network's Cloud DNS.
   * The user must grant the dns.peer role to the Vertex AI Service Agent
   * on the target project.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig getDnsPeeringConfigs(int index) {
    return dnsPeeringConfigs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. DNS peering configurations. When specified, Vertex AI will
   * attempt to configure DNS peering zones in the tenant project VPC
   * to resolve the specified domains using the target network's Cloud DNS.
   * The user must grant the dns.peer role to the Vertex AI Service Agent
   * on the target project.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder
      getDnsPeeringConfigsOrBuilder(int index) {
    return dnsPeeringConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkAttachment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, networkAttachment_);
    }
    for (int i = 0; i < dnsPeeringConfigs_.size(); i++) {
      output.writeMessage(2, dnsPeeringConfigs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkAttachment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, networkAttachment_);
    }
    for (int i = 0; i < dnsPeeringConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, dnsPeeringConfigs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig other =
        (com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig) obj;

    if (!getNetworkAttachment().equals(other.getNetworkAttachment())) return false;
    if (!getDnsPeeringConfigsList().equals(other.getDnsPeeringConfigsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NETWORK_ATTACHMENT_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkAttachment().hashCode();
    if (getDnsPeeringConfigsCount() > 0) {
      hash = (37 * hash) + DNS_PEERING_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getDnsPeeringConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration for PSC-I.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PscInterfaceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PscInterfaceConfig)
      com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ServiceNetworkingProto
          .internal_static_google_cloud_aiplatform_v1beta1_PscInterfaceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ServiceNetworkingProto
          .internal_static_google_cloud_aiplatform_v1beta1_PscInterfaceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.class,
              com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      networkAttachment_ = "";
      if (dnsPeeringConfigsBuilder_ == null) {
        dnsPeeringConfigs_ = java.util.Collections.emptyList();
      } else {
        dnsPeeringConfigs_ = null;
        dnsPeeringConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ServiceNetworkingProto
          .internal_static_google_cloud_aiplatform_v1beta1_PscInterfaceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig build() {
      com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig result =
          new com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig result) {
      if (dnsPeeringConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dnsPeeringConfigs_ = java.util.Collections.unmodifiableList(dnsPeeringConfigs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dnsPeeringConfigs_ = dnsPeeringConfigs_;
      } else {
        result.dnsPeeringConfigs_ = dnsPeeringConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.networkAttachment_ = networkAttachment_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance())
        return this;
      if (!other.getNetworkAttachment().isEmpty()) {
        networkAttachment_ = other.networkAttachment_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dnsPeeringConfigsBuilder_ == null) {
        if (!other.dnsPeeringConfigs_.isEmpty()) {
          if (dnsPeeringConfigs_.isEmpty()) {
            dnsPeeringConfigs_ = other.dnsPeeringConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDnsPeeringConfigsIsMutable();
            dnsPeeringConfigs_.addAll(other.dnsPeeringConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.dnsPeeringConfigs_.isEmpty()) {
          if (dnsPeeringConfigsBuilder_.isEmpty()) {
            dnsPeeringConfigsBuilder_.dispose();
            dnsPeeringConfigsBuilder_ = null;
            dnsPeeringConfigs_ = other.dnsPeeringConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dnsPeeringConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDnsPeeringConfigsFieldBuilder()
                    : null;
          } else {
            dnsPeeringConfigsBuilder_.addAllMessages(other.dnsPeeringConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                networkAttachment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.parser(),
                        extensionRegistry);
                if (dnsPeeringConfigsBuilder_ == null) {
                  ensureDnsPeeringConfigsIsMutable();
                  dnsPeeringConfigs_.add(m);
                } else {
                  dnsPeeringConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object networkAttachment_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the Compute Engine
     * [network
     * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
     * attach to the resource within the region and user project.
     * To specify this field, you must have already [created a network attachment]
     * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
     * This field is only used for resources using PSC-I.
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The networkAttachment.
     */
    public java.lang.String getNetworkAttachment() {
      java.lang.Object ref = networkAttachment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkAttachment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Compute Engine
     * [network
     * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
     * attach to the resource within the region and user project.
     * To specify this field, you must have already [created a network attachment]
     * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
     * This field is only used for resources using PSC-I.
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for networkAttachment.
     */
    public com.google.protobuf.ByteString getNetworkAttachmentBytes() {
      java.lang.Object ref = networkAttachment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkAttachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Compute Engine
     * [network
     * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
     * attach to the resource within the region and user project.
     * To specify this field, you must have already [created a network attachment]
     * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
     * This field is only used for resources using PSC-I.
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The networkAttachment to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkAttachment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkAttachment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Compute Engine
     * [network
     * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
     * attach to the resource within the region and user project.
     * To specify this field, you must have already [created a network attachment]
     * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
     * This field is only used for resources using PSC-I.
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkAttachment() {
      networkAttachment_ = getDefaultInstance().getNetworkAttachment();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Compute Engine
     * [network
     * attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
     * attach to the resource within the region and user project.
     * To specify this field, you must have already [created a network attachment]
     * (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
     * This field is only used for resources using PSC-I.
     * </pre>
     *
     * <code>
     * string network_attachment = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for networkAttachment to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkAttachmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkAttachment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig>
        dnsPeeringConfigs_ = java.util.Collections.emptyList();

    private void ensureDnsPeeringConfigsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dnsPeeringConfigs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig>(
                dnsPeeringConfigs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig,
            com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder>
        dnsPeeringConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig>
        getDnsPeeringConfigsList() {
      if (dnsPeeringConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dnsPeeringConfigs_);
      } else {
        return dnsPeeringConfigsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getDnsPeeringConfigsCount() {
      if (dnsPeeringConfigsBuilder_ == null) {
        return dnsPeeringConfigs_.size();
      } else {
        return dnsPeeringConfigsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig getDnsPeeringConfigs(int index) {
      if (dnsPeeringConfigsBuilder_ == null) {
        return dnsPeeringConfigs_.get(index);
      } else {
        return dnsPeeringConfigsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDnsPeeringConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig value) {
      if (dnsPeeringConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.set(index, value);
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDnsPeeringConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder builderForValue) {
      if (dnsPeeringConfigsBuilder_ == null) {
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDnsPeeringConfigs(
        com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig value) {
      if (dnsPeeringConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.add(value);
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDnsPeeringConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig value) {
      if (dnsPeeringConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.add(index, value);
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDnsPeeringConfigs(
        com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder builderForValue) {
      if (dnsPeeringConfigsBuilder_ == null) {
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDnsPeeringConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder builderForValue) {
      if (dnsPeeringConfigsBuilder_ == null) {
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllDnsPeeringConfigs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig> values) {
      if (dnsPeeringConfigsBuilder_ == null) {
        ensureDnsPeeringConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dnsPeeringConfigs_);
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDnsPeeringConfigs() {
      if (dnsPeeringConfigsBuilder_ == null) {
        dnsPeeringConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeDnsPeeringConfigs(int index) {
      if (dnsPeeringConfigsBuilder_ == null) {
        ensureDnsPeeringConfigsIsMutable();
        dnsPeeringConfigs_.remove(index);
        onChanged();
      } else {
        dnsPeeringConfigsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder getDnsPeeringConfigsBuilder(
        int index) {
      return getDnsPeeringConfigsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder
        getDnsPeeringConfigsOrBuilder(int index) {
      if (dnsPeeringConfigsBuilder_ == null) {
        return dnsPeeringConfigs_.get(index);
      } else {
        return dnsPeeringConfigsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder>
        getDnsPeeringConfigsOrBuilderList() {
      if (dnsPeeringConfigsBuilder_ != null) {
        return dnsPeeringConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dnsPeeringConfigs_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder
        addDnsPeeringConfigsBuilder() {
      return getDnsPeeringConfigsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder addDnsPeeringConfigsBuilder(
        int index) {
      return getDnsPeeringConfigsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. DNS peering configurations. When specified, Vertex AI will
     * attempt to configure DNS peering zones in the tenant project VPC
     * to resolve the specified domains using the target network's Cloud DNS.
     * The user must grant the dns.peer role to the Vertex AI Service Agent
     * on the target project.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DnsPeeringConfig dns_peering_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder>
        getDnsPeeringConfigsBuilderList() {
      return getDnsPeeringConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig,
            com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder>
        getDnsPeeringConfigsFieldBuilder() {
      if (dnsPeeringConfigsBuilder_ == null) {
        dnsPeeringConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig,
                com.google.cloud.aiplatform.v1beta1.DnsPeeringConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.DnsPeeringConfigOrBuilder>(
                dnsPeeringConfigs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        dnsPeeringConfigs_ = null;
      }
      return dnsPeeringConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PscInterfaceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PscInterfaceConfig)
  private static final com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PscInterfaceConfig> PARSER =
      new com.google.protobuf.AbstractParser<PscInterfaceConfig>() {
        @java.lang.Override
        public PscInterfaceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PscInterfaceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PscInterfaceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
