/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A RagChunk includes the content of a chunk of a RagFile, and associated
 * metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagChunk}
 */
public final class RagChunk extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagChunk)
    RagChunkOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagChunk.newBuilder() to construct.
  private RagChunk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagChunk() {
    text_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagChunk();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RagChunk.class,
            com.google.cloud.aiplatform.v1beta1.RagChunk.Builder.class);
  }

  public interface PageSpanOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagChunk.PageSpan)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Page where chunk starts in the document. Inclusive. 1-indexed.
     * </pre>
     *
     * <code>int32 first_page = 1;</code>
     *
     * @return The firstPage.
     */
    int getFirstPage();

    /**
     *
     *
     * <pre>
     * Page where chunk ends in the document. Inclusive. 1-indexed.
     * </pre>
     *
     * <code>int32 last_page = 2;</code>
     *
     * @return The lastPage.
     */
    int getLastPage();
  }

  /**
   *
   *
   * <pre>
   * Represents where the chunk starts and ends in the document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagChunk.PageSpan}
   */
  public static final class PageSpan extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagChunk.PageSpan)
      PageSpanOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PageSpan.newBuilder() to construct.
    private PageSpan(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PageSpan() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PageSpan();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_PageSpan_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_PageSpan_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.class,
              com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder.class);
    }

    public static final int FIRST_PAGE_FIELD_NUMBER = 1;
    private int firstPage_ = 0;

    /**
     *
     *
     * <pre>
     * Page where chunk starts in the document. Inclusive. 1-indexed.
     * </pre>
     *
     * <code>int32 first_page = 1;</code>
     *
     * @return The firstPage.
     */
    @java.lang.Override
    public int getFirstPage() {
      return firstPage_;
    }

    public static final int LAST_PAGE_FIELD_NUMBER = 2;
    private int lastPage_ = 0;

    /**
     *
     *
     * <pre>
     * Page where chunk ends in the document. Inclusive. 1-indexed.
     * </pre>
     *
     * <code>int32 last_page = 2;</code>
     *
     * @return The lastPage.
     */
    @java.lang.Override
    public int getLastPage() {
      return lastPage_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (firstPage_ != 0) {
        output.writeInt32(1, firstPage_);
      }
      if (lastPage_ != 0) {
        output.writeInt32(2, lastPage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (firstPage_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, firstPage_);
      }
      if (lastPage_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, lastPage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan other =
          (com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan) obj;

      if (getFirstPage() != other.getFirstPage()) return false;
      if (getLastPage() != other.getLastPage()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIRST_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getFirstPage();
      hash = (37 * hash) + LAST_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getLastPage();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents where the chunk starts and ends in the document.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagChunk.PageSpan}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagChunk.PageSpan)
        com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpanOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_PageSpan_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_PageSpan_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.class,
                com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        firstPage_ = 0;
        lastPage_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_PageSpan_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan build() {
        com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan result =
            new com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.firstPage_ = firstPage_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.lastPage_ = lastPage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan other) {
        if (other == com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance())
          return this;
        if (other.getFirstPage() != 0) {
          setFirstPage(other.getFirstPage());
        }
        if (other.getLastPage() != 0) {
          setLastPage(other.getLastPage());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  firstPage_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  lastPage_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int firstPage_;

      /**
       *
       *
       * <pre>
       * Page where chunk starts in the document. Inclusive. 1-indexed.
       * </pre>
       *
       * <code>int32 first_page = 1;</code>
       *
       * @return The firstPage.
       */
      @java.lang.Override
      public int getFirstPage() {
        return firstPage_;
      }

      /**
       *
       *
       * <pre>
       * Page where chunk starts in the document. Inclusive. 1-indexed.
       * </pre>
       *
       * <code>int32 first_page = 1;</code>
       *
       * @param value The firstPage to set.
       * @return This builder for chaining.
       */
      public Builder setFirstPage(int value) {

        firstPage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Page where chunk starts in the document. Inclusive. 1-indexed.
       * </pre>
       *
       * <code>int32 first_page = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFirstPage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        firstPage_ = 0;
        onChanged();
        return this;
      }

      private int lastPage_;

      /**
       *
       *
       * <pre>
       * Page where chunk ends in the document. Inclusive. 1-indexed.
       * </pre>
       *
       * <code>int32 last_page = 2;</code>
       *
       * @return The lastPage.
       */
      @java.lang.Override
      public int getLastPage() {
        return lastPage_;
      }

      /**
       *
       *
       * <pre>
       * Page where chunk ends in the document. Inclusive. 1-indexed.
       * </pre>
       *
       * <code>int32 last_page = 2;</code>
       *
       * @param value The lastPage to set.
       * @return This builder for chaining.
       */
      public Builder setLastPage(int value) {

        lastPage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Page where chunk ends in the document. Inclusive. 1-indexed.
       * </pre>
       *
       * <code>int32 last_page = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLastPage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        lastPage_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagChunk.PageSpan)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagChunk.PageSpan)
    private static final com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan();
    }

    public static com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PageSpan> PARSER =
        new com.google.protobuf.AbstractParser<PageSpan>() {
          @java.lang.Override
          public PageSpan parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PageSpan> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PageSpan> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object text_ = "";

  /**
   *
   *
   * <pre>
   * The content of the chunk.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The content of the chunk.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The bytes for text.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SPAN_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan pageSpan_;

  /**
   *
   *
   * <pre>
   * If populated, represents where the chunk starts and ends in the document.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
   *
   * @return Whether the pageSpan field is set.
   */
  @java.lang.Override
  public boolean hasPageSpan() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * If populated, represents where the chunk starts and ends in the document.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
   *
   * @return The pageSpan.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan getPageSpan() {
    return pageSpan_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance()
        : pageSpan_;
  }

  /**
   *
   *
   * <pre>
   * If populated, represents where the chunk starts and ends in the document.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpanOrBuilder getPageSpanOrBuilder() {
    return pageSpan_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance()
        : pageSpan_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getPageSpan());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPageSpan());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagChunk)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RagChunk other =
        (com.google.cloud.aiplatform.v1beta1.RagChunk) obj;

    if (!getText().equals(other.getText())) return false;
    if (hasPageSpan() != other.hasPageSpan()) return false;
    if (hasPageSpan()) {
      if (!getPageSpan().equals(other.getPageSpan())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    if (hasPageSpan()) {
      hash = (37 * hash) + PAGE_SPAN_FIELD_NUMBER;
      hash = (53 * hash) + getPageSpan().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.RagChunk prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A RagChunk includes the content of a chunk of a RagFile, and associated
   * metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagChunk}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagChunk)
      com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagChunk.class,
              com.google.cloud.aiplatform.v1beta1.RagChunk.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RagChunk.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPageSpanFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      text_ = "";
      pageSpan_ = null;
      if (pageSpanBuilder_ != null) {
        pageSpanBuilder_.dispose();
        pageSpanBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagChunk_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagChunk getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagChunk build() {
      com.google.cloud.aiplatform.v1beta1.RagChunk result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagChunk buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RagChunk result =
          new com.google.cloud.aiplatform.v1beta1.RagChunk(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagChunk result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.text_ = text_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSpan_ = pageSpanBuilder_ == null ? pageSpan_ : pageSpanBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RagChunk) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagChunk) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagChunk other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance()) return this;
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPageSpan()) {
        mergePageSpan(other.getPageSpan());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                text_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPageSpanFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * The content of the chunk.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The content of the chunk.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The content of the chunk.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content of the chunk.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      text_ = getDefaultInstance().getText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content of the chunk.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan pageSpan_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan,
            com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder,
            com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpanOrBuilder>
        pageSpanBuilder_;

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     *
     * @return Whether the pageSpan field is set.
     */
    public boolean hasPageSpan() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     *
     * @return The pageSpan.
     */
    public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan getPageSpan() {
      if (pageSpanBuilder_ == null) {
        return pageSpan_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance()
            : pageSpan_;
      } else {
        return pageSpanBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    public Builder setPageSpan(com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan value) {
      if (pageSpanBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageSpan_ = value;
      } else {
        pageSpanBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    public Builder setPageSpan(
        com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder builderForValue) {
      if (pageSpanBuilder_ == null) {
        pageSpan_ = builderForValue.build();
      } else {
        pageSpanBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    public Builder mergePageSpan(com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan value) {
      if (pageSpanBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && pageSpan_ != null
            && pageSpan_
                != com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance()) {
          getPageSpanBuilder().mergeFrom(value);
        } else {
          pageSpan_ = value;
        }
      } else {
        pageSpanBuilder_.mergeFrom(value);
      }
      if (pageSpan_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    public Builder clearPageSpan() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSpan_ = null;
      if (pageSpanBuilder_ != null) {
        pageSpanBuilder_.dispose();
        pageSpanBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder getPageSpanBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPageSpanFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpanOrBuilder getPageSpanOrBuilder() {
      if (pageSpanBuilder_ != null) {
        return pageSpanBuilder_.getMessageOrBuilder();
      } else {
        return pageSpan_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.getDefaultInstance()
            : pageSpan_;
      }
    }

    /**
     *
     *
     * <pre>
     * If populated, represents where the chunk starts and ends in the document.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1beta1.RagChunk.PageSpan page_span = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan,
            com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder,
            com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpanOrBuilder>
        getPageSpanFieldBuilder() {
      if (pageSpanBuilder_ == null) {
        pageSpanBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan,
                com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpan.Builder,
                com.google.cloud.aiplatform.v1beta1.RagChunk.PageSpanOrBuilder>(
                getPageSpan(), getParentForChildren(), isClean());
        pageSpan_ = null;
      }
      return pageSpanBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagChunk)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagChunk)
  private static final com.google.cloud.aiplatform.v1beta1.RagChunk DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagChunk();
  }

  public static com.google.cloud.aiplatform.v1beta1.RagChunk getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagChunk> PARSER =
      new com.google.protobuf.AbstractParser<RagChunk>() {
        @java.lang.Override
        public RagChunk parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagChunk> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagChunk> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagChunk getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
