/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Relevant contexts for one query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagContexts}
 */
public final class RagContexts extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagContexts)
    RagContextsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagContexts.newBuilder() to construct.
  private RagContexts(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagContexts() {
    contexts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagContexts();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RagContexts.class,
            com.google.cloud.aiplatform.v1beta1.RagContexts.Builder.class);
  }

  public interface ContextOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RagContexts.Context)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If the file is imported from Cloud Storage or Google Drive, source_uri
     * will be original file URI in Cloud Storage or Google Drive; if file is
     * uploaded, source_uri will be file display name.
     * </pre>
     *
     * <code>string source_uri = 1;</code>
     *
     * @return The sourceUri.
     */
    java.lang.String getSourceUri();

    /**
     *
     *
     * <pre>
     * If the file is imported from Cloud Storage or Google Drive, source_uri
     * will be original file URI in Cloud Storage or Google Drive; if file is
     * uploaded, source_uri will be file display name.
     * </pre>
     *
     * <code>string source_uri = 1;</code>
     *
     * @return The bytes for sourceUri.
     */
    com.google.protobuf.ByteString getSourceUriBytes();

    /**
     *
     *
     * <pre>
     * The file display name.
     * </pre>
     *
     * <code>string source_display_name = 5;</code>
     *
     * @return The sourceDisplayName.
     */
    java.lang.String getSourceDisplayName();

    /**
     *
     *
     * <pre>
     * The file display name.
     * </pre>
     *
     * <code>string source_display_name = 5;</code>
     *
     * @return The bytes for sourceDisplayName.
     */
    com.google.protobuf.ByteString getSourceDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * The text chunk.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The text.
     */
    java.lang.String getText();

    /**
     *
     *
     * <pre>
     * The text chunk.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * The distance between the query dense embedding vector and the context
     * text vector.
     * </pre>
     *
     * <code>double distance = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.distance is deprecated. See
     *     google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=182
     * @return The distance.
     */
    @java.lang.Deprecated
    double getDistance();

    /**
     *
     *
     * <pre>
     * The distance between the query sparse embedding vector and the context
     * text vector.
     * </pre>
     *
     * <code>double sparse_distance = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.sparse_distance is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=186
     * @return The sparseDistance.
     */
    @java.lang.Deprecated
    double getSparseDistance();

    /**
     *
     *
     * <pre>
     * According to the underlying Vector DB and the selected metric type, the
     * score can be either the distance or the similarity between the query and
     * the context and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the context. The larger the distance, the
     * less relevant the context is to the query. The range is [0, 2], while 0
     * means the most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return Whether the score field is set.
     */
    boolean hasScore();

    /**
     *
     *
     * <pre>
     * According to the underlying Vector DB and the selected metric type, the
     * score can be either the distance or the similarity between the query and
     * the context and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the context. The larger the distance, the
     * less relevant the context is to the query. The range is [0, 2], while 0
     * means the most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return The score.
     */
    double getScore();

    /**
     *
     *
     * <pre>
     * Context of the retrieved chunk.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
     *
     * @return Whether the chunk field is set.
     */
    boolean hasChunk();

    /**
     *
     *
     * <pre>
     * Context of the retrieved chunk.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
     *
     * @return The chunk.
     */
    com.google.cloud.aiplatform.v1beta1.RagChunk getChunk();

    /**
     *
     *
     * <pre>
     * Context of the retrieved chunk.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
     */
    com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder getChunkOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A context of the query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagContexts.Context}
   */
  public static final class Context extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagContexts.Context)
      ContextOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Context.newBuilder() to construct.
    private Context(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Context() {
      sourceUri_ = "";
      sourceDisplayName_ = "";
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Context();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_Context_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_Context_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagContexts.Context.class,
              com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder.class);
    }

    private int bitField0_;
    public static final int SOURCE_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceUri_ = "";

    /**
     *
     *
     * <pre>
     * If the file is imported from Cloud Storage or Google Drive, source_uri
     * will be original file URI in Cloud Storage or Google Drive; if file is
     * uploaded, source_uri will be file display name.
     * </pre>
     *
     * <code>string source_uri = 1;</code>
     *
     * @return The sourceUri.
     */
    @java.lang.Override
    public java.lang.String getSourceUri() {
      java.lang.Object ref = sourceUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * If the file is imported from Cloud Storage or Google Drive, source_uri
     * will be original file URI in Cloud Storage or Google Drive; if file is
     * uploaded, source_uri will be file display name.
     * </pre>
     *
     * <code>string source_uri = 1;</code>
     *
     * @return The bytes for sourceUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceUriBytes() {
      java.lang.Object ref = sourceUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_DISPLAY_NAME_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * The file display name.
     * </pre>
     *
     * <code>string source_display_name = 5;</code>
     *
     * @return The sourceDisplayName.
     */
    @java.lang.Override
    public java.lang.String getSourceDisplayName() {
      java.lang.Object ref = sourceDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDisplayName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The file display name.
     * </pre>
     *
     * <code>string source_display_name = 5;</code>
     *
     * @return The bytes for sourceDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceDisplayNameBytes() {
      java.lang.Object ref = sourceDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * The text chunk.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The text chunk.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISTANCE_FIELD_NUMBER = 3;
    private double distance_ = 0D;

    /**
     *
     *
     * <pre>
     * The distance between the query dense embedding vector and the context
     * text vector.
     * </pre>
     *
     * <code>double distance = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.distance is deprecated. See
     *     google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=182
     * @return The distance.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getDistance() {
      return distance_;
    }

    public static final int SPARSE_DISTANCE_FIELD_NUMBER = 4;
    private double sparseDistance_ = 0D;

    /**
     *
     *
     * <pre>
     * The distance between the query sparse embedding vector and the context
     * text vector.
     * </pre>
     *
     * <code>double sparse_distance = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.sparse_distance is
     *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=186
     * @return The sparseDistance.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getSparseDistance() {
      return sparseDistance_;
    }

    public static final int SCORE_FIELD_NUMBER = 6;
    private double score_ = 0D;

    /**
     *
     *
     * <pre>
     * According to the underlying Vector DB and the selected metric type, the
     * score can be either the distance or the similarity between the query and
     * the context and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the context. The larger the distance, the
     * less relevant the context is to the query. The range is [0, 2], while 0
     * means the most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * According to the underlying Vector DB and the selected metric type, the
     * score can be either the distance or the similarity between the query and
     * the context and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the context. The larger the distance, the
     * less relevant the context is to the query. The range is [0, 2], while 0
     * means the most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    public static final int CHUNK_FIELD_NUMBER = 7;
    private com.google.cloud.aiplatform.v1beta1.RagChunk chunk_;

    /**
     *
     *
     * <pre>
     * Context of the retrieved chunk.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
     *
     * @return Whether the chunk field is set.
     */
    @java.lang.Override
    public boolean hasChunk() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Context of the retrieved chunk.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
     *
     * @return The chunk.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagChunk getChunk() {
      return chunk_ == null
          ? com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance()
          : chunk_;
    }

    /**
     *
     *
     * <pre>
     * Context of the retrieved chunk.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder getChunkOrBuilder() {
      return chunk_ == null
          ? com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance()
          : chunk_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, text_);
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        output.writeDouble(3, distance_);
      }
      if (java.lang.Double.doubleToRawLongBits(sparseDistance_) != 0) {
        output.writeDouble(4, sparseDistance_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sourceDisplayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(6, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(7, getChunk());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, text_);
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, distance_);
      }
      if (java.lang.Double.doubleToRawLongBits(sparseDistance_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, sparseDistance_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, sourceDisplayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getChunk());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagContexts.Context)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RagContexts.Context other =
          (com.google.cloud.aiplatform.v1beta1.RagContexts.Context) obj;

      if (!getSourceUri().equals(other.getSourceUri())) return false;
      if (!getSourceDisplayName().equals(other.getSourceDisplayName())) return false;
      if (!getText().equals(other.getText())) return false;
      if (java.lang.Double.doubleToLongBits(getDistance())
          != java.lang.Double.doubleToLongBits(other.getDistance())) return false;
      if (java.lang.Double.doubleToLongBits(getSparseDistance())
          != java.lang.Double.doubleToLongBits(other.getSparseDistance())) return false;
      if (hasScore() != other.hasScore()) return false;
      if (hasScore()) {
        if (java.lang.Double.doubleToLongBits(getScore())
            != java.lang.Double.doubleToLongBits(other.getScore())) return false;
      }
      if (hasChunk() != other.hasChunk()) return false;
      if (hasChunk()) {
        if (!getChunk().equals(other.getChunk())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_URI_FIELD_NUMBER;
      hash = (53 * hash) + getSourceUri().hashCode();
      hash = (37 * hash) + SOURCE_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDisplayName().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDistance()));
      hash = (37 * hash) + SPARSE_DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getSparseDistance()));
      if (hasScore()) {
        hash = (37 * hash) + SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getScore()));
      }
      if (hasChunk()) {
        hash = (37 * hash) + CHUNK_FIELD_NUMBER;
        hash = (53 * hash) + getChunk().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RagContexts.Context prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A context of the query.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagContexts.Context}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagContexts.Context)
        com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_Context_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_Context_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RagContexts.Context.class,
                com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.RagContexts.Context.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getChunkFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sourceUri_ = "";
        sourceDisplayName_ = "";
        text_ = "";
        distance_ = 0D;
        sparseDistance_ = 0D;
        score_ = 0D;
        chunk_ = null;
        if (chunkBuilder_ != null) {
          chunkBuilder_.dispose();
          chunkBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_Context_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagContexts.Context getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RagContexts.Context.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagContexts.Context build() {
        com.google.cloud.aiplatform.v1beta1.RagContexts.Context result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RagContexts.Context buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RagContexts.Context result =
            new com.google.cloud.aiplatform.v1beta1.RagContexts.Context(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagContexts.Context result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sourceUri_ = sourceUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.sourceDisplayName_ = sourceDisplayName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.distance_ = distance_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.sparseDistance_ = sparseDistance_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.score_ = score_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.chunk_ = chunkBuilder_ == null ? chunk_ : chunkBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.RagContexts.Context) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagContexts.Context) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagContexts.Context other) {
        if (other == com.google.cloud.aiplatform.v1beta1.RagContexts.Context.getDefaultInstance())
          return this;
        if (!other.getSourceUri().isEmpty()) {
          sourceUri_ = other.sourceUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSourceDisplayName().isEmpty()) {
          sourceDisplayName_ = other.sourceDisplayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getDistance() != 0D) {
          setDistance(other.getDistance());
        }
        if (other.getSparseDistance() != 0D) {
          setSparseDistance(other.getSparseDistance());
        }
        if (other.hasScore()) {
          setScore(other.getScore());
        }
        if (other.hasChunk()) {
          mergeChunk(other.getChunk());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  sourceUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 25:
                {
                  distance_ = input.readDouble();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 25
              case 33:
                {
                  sparseDistance_ = input.readDouble();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 33
              case 42:
                {
                  sourceDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 42
              case 49:
                {
                  score_ = input.readDouble();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 49
              case 58:
                {
                  input.readMessage(getChunkFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object sourceUri_ = "";

      /**
       *
       *
       * <pre>
       * If the file is imported from Cloud Storage or Google Drive, source_uri
       * will be original file URI in Cloud Storage or Google Drive; if file is
       * uploaded, source_uri will be file display name.
       * </pre>
       *
       * <code>string source_uri = 1;</code>
       *
       * @return The sourceUri.
       */
      public java.lang.String getSourceUri() {
        java.lang.Object ref = sourceUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * If the file is imported from Cloud Storage or Google Drive, source_uri
       * will be original file URI in Cloud Storage or Google Drive; if file is
       * uploaded, source_uri will be file display name.
       * </pre>
       *
       * <code>string source_uri = 1;</code>
       *
       * @return The bytes for sourceUri.
       */
      public com.google.protobuf.ByteString getSourceUriBytes() {
        java.lang.Object ref = sourceUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * If the file is imported from Cloud Storage or Google Drive, source_uri
       * will be original file URI in Cloud Storage or Google Drive; if file is
       * uploaded, source_uri will be file display name.
       * </pre>
       *
       * <code>string source_uri = 1;</code>
       *
       * @param value The sourceUri to set.
       * @return This builder for chaining.
       */
      public Builder setSourceUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If the file is imported from Cloud Storage or Google Drive, source_uri
       * will be original file URI in Cloud Storage or Google Drive; if file is
       * uploaded, source_uri will be file display name.
       * </pre>
       *
       * <code>string source_uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceUri() {
        sourceUri_ = getDefaultInstance().getSourceUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If the file is imported from Cloud Storage or Google Drive, source_uri
       * will be original file URI in Cloud Storage or Google Drive; if file is
       * uploaded, source_uri will be file display name.
       * </pre>
       *
       * <code>string source_uri = 1;</code>
       *
       * @param value The bytes for sourceUri to set.
       * @return This builder for chaining.
       */
      public Builder setSourceUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object sourceDisplayName_ = "";

      /**
       *
       *
       * <pre>
       * The file display name.
       * </pre>
       *
       * <code>string source_display_name = 5;</code>
       *
       * @return The sourceDisplayName.
       */
      public java.lang.String getSourceDisplayName() {
        java.lang.Object ref = sourceDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The file display name.
       * </pre>
       *
       * <code>string source_display_name = 5;</code>
       *
       * @return The bytes for sourceDisplayName.
       */
      public com.google.protobuf.ByteString getSourceDisplayNameBytes() {
        java.lang.Object ref = sourceDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The file display name.
       * </pre>
       *
       * <code>string source_display_name = 5;</code>
       *
       * @param value The sourceDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setSourceDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The file display name.
       * </pre>
       *
       * <code>string source_display_name = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceDisplayName() {
        sourceDisplayName_ = getDefaultInstance().getSourceDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The file display name.
       * </pre>
       *
       * <code>string source_display_name = 5;</code>
       *
       * @param value The bytes for sourceDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setSourceDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object text_ = "";

      /**
       *
       *
       * <pre>
       * The text chunk.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The text chunk.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The text chunk.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The text chunk.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The text chunk.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private double distance_;

      /**
       *
       *
       * <pre>
       * The distance between the query dense embedding vector and the context
       * text vector.
       * </pre>
       *
       * <code>double distance = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.distance is deprecated. See
       *     google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=182
       * @return The distance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public double getDistance() {
        return distance_;
      }

      /**
       *
       *
       * <pre>
       * The distance between the query dense embedding vector and the context
       * text vector.
       * </pre>
       *
       * <code>double distance = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.distance is deprecated. See
       *     google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=182
       * @param value The distance to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setDistance(double value) {

        distance_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The distance between the query dense embedding vector and the context
       * text vector.
       * </pre>
       *
       * <code>double distance = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.distance is deprecated. See
       *     google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=182
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000008);
        distance_ = 0D;
        onChanged();
        return this;
      }

      private double sparseDistance_;

      /**
       *
       *
       * <pre>
       * The distance between the query sparse embedding vector and the context
       * text vector.
       * </pre>
       *
       * <code>double sparse_distance = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.sparse_distance is
       *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=186
       * @return The sparseDistance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public double getSparseDistance() {
        return sparseDistance_;
      }

      /**
       *
       *
       * <pre>
       * The distance between the query sparse embedding vector and the context
       * text vector.
       * </pre>
       *
       * <code>double sparse_distance = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.sparse_distance is
       *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=186
       * @param value The sparseDistance to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setSparseDistance(double value) {

        sparseDistance_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The distance between the query sparse embedding vector and the context
       * text vector.
       * </pre>
       *
       * <code>double sparse_distance = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.RagContexts.Context.sparse_distance is
       *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_service.proto;l=186
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearSparseDistance() {
        bitField0_ = (bitField0_ & ~0x00000010);
        sparseDistance_ = 0D;
        onChanged();
        return this;
      }

      private double score_;

      /**
       *
       *
       * <pre>
       * According to the underlying Vector DB and the selected metric type, the
       * score can be either the distance or the similarity between the query and
       * the context and its range depends on the metric type.
       *
       * For example, if the metric type is COSINE_DISTANCE, it represents the
       * distance between the query and the context. The larger the distance, the
       * less relevant the context is to the query. The range is [0, 2], while 0
       * means the most relevant and 2 means the least relevant.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @return Whether the score field is set.
       */
      @java.lang.Override
      public boolean hasScore() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * According to the underlying Vector DB and the selected metric type, the
       * score can be either the distance or the similarity between the query and
       * the context and its range depends on the metric type.
       *
       * For example, if the metric type is COSINE_DISTANCE, it represents the
       * distance between the query and the context. The larger the distance, the
       * less relevant the context is to the query. The range is [0, 2], while 0
       * means the most relevant and 2 means the least relevant.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public double getScore() {
        return score_;
      }

      /**
       *
       *
       * <pre>
       * According to the underlying Vector DB and the selected metric type, the
       * score can be either the distance or the similarity between the query and
       * the context and its range depends on the metric type.
       *
       * For example, if the metric type is COSINE_DISTANCE, it represents the
       * distance between the query and the context. The larger the distance, the
       * less relevant the context is to the query. The range is [0, 2], while 0
       * means the most relevant and 2 means the least relevant.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(double value) {

        score_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * According to the underlying Vector DB and the selected metric type, the
       * score can be either the distance or the similarity between the query and
       * the context and its range depends on the metric type.
       *
       * For example, if the metric type is COSINE_DISTANCE, it represents the
       * distance between the query and the context. The larger the distance, the
       * less relevant the context is to the query. The range is [0, 2], while 0
       * means the most relevant and 2 means the least relevant.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000020);
        score_ = 0D;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.RagChunk chunk_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RagChunk,
              com.google.cloud.aiplatform.v1beta1.RagChunk.Builder,
              com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder>
          chunkBuilder_;

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       *
       * @return Whether the chunk field is set.
       */
      public boolean hasChunk() {
        return ((bitField0_ & 0x00000040) != 0);
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       *
       * @return The chunk.
       */
      public com.google.cloud.aiplatform.v1beta1.RagChunk getChunk() {
        if (chunkBuilder_ == null) {
          return chunk_ == null
              ? com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance()
              : chunk_;
        } else {
          return chunkBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      public Builder setChunk(com.google.cloud.aiplatform.v1beta1.RagChunk value) {
        if (chunkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          chunk_ = value;
        } else {
          chunkBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      public Builder setChunk(
          com.google.cloud.aiplatform.v1beta1.RagChunk.Builder builderForValue) {
        if (chunkBuilder_ == null) {
          chunk_ = builderForValue.build();
        } else {
          chunkBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      public Builder mergeChunk(com.google.cloud.aiplatform.v1beta1.RagChunk value) {
        if (chunkBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && chunk_ != null
              && chunk_ != com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance()) {
            getChunkBuilder().mergeFrom(value);
          } else {
            chunk_ = value;
          }
        } else {
          chunkBuilder_.mergeFrom(value);
        }
        if (chunk_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      public Builder clearChunk() {
        bitField0_ = (bitField0_ & ~0x00000040);
        chunk_ = null;
        if (chunkBuilder_ != null) {
          chunkBuilder_.dispose();
          chunkBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.RagChunk.Builder getChunkBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getChunkFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder getChunkOrBuilder() {
        if (chunkBuilder_ != null) {
          return chunkBuilder_.getMessageOrBuilder();
        } else {
          return chunk_ == null
              ? com.google.cloud.aiplatform.v1beta1.RagChunk.getDefaultInstance()
              : chunk_;
        }
      }

      /**
       *
       *
       * <pre>
       * Context of the retrieved chunk.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.RagChunk chunk = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RagChunk,
              com.google.cloud.aiplatform.v1beta1.RagChunk.Builder,
              com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder>
          getChunkFieldBuilder() {
        if (chunkBuilder_ == null) {
          chunkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.RagChunk,
                  com.google.cloud.aiplatform.v1beta1.RagChunk.Builder,
                  com.google.cloud.aiplatform.v1beta1.RagChunkOrBuilder>(
                  getChunk(), getParentForChildren(), isClean());
          chunk_ = null;
        }
        return chunkBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagContexts.Context)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagContexts.Context)
    private static final com.google.cloud.aiplatform.v1beta1.RagContexts.Context DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagContexts.Context();
    }

    public static com.google.cloud.aiplatform.v1beta1.RagContexts.Context getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Context> PARSER =
        new com.google.protobuf.AbstractParser<Context>() {
          @java.lang.Override
          public Context parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Context> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Context> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagContexts.Context getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CONTEXTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.RagContexts.Context> contexts_;

  /**
   *
   *
   * <pre>
   * All its contexts.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.RagContexts.Context> getContextsList() {
    return contexts_;
  }

  /**
   *
   *
   * <pre>
   * All its contexts.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder>
      getContextsOrBuilderList() {
    return contexts_;
  }

  /**
   *
   *
   * <pre>
   * All its contexts.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
   */
  @java.lang.Override
  public int getContextsCount() {
    return contexts_.size();
  }

  /**
   *
   *
   * <pre>
   * All its contexts.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagContexts.Context getContexts(int index) {
    return contexts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * All its contexts.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder getContextsOrBuilder(
      int index) {
    return contexts_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < contexts_.size(); i++) {
      output.writeMessage(1, contexts_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < contexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, contexts_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagContexts)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RagContexts other =
        (com.google.cloud.aiplatform.v1beta1.RagContexts) obj;

    if (!getContextsList().equals(other.getContextsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getContextsCount() > 0) {
      hash = (37 * hash) + CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getContextsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.RagContexts prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Relevant contexts for one query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagContexts}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagContexts)
      com.google.cloud.aiplatform.v1beta1.RagContextsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagContexts.class,
              com.google.cloud.aiplatform.v1beta1.RagContexts.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RagContexts.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (contextsBuilder_ == null) {
        contexts_ = java.util.Collections.emptyList();
      } else {
        contexts_ = null;
        contextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagContexts_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagContexts getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RagContexts.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagContexts build() {
      com.google.cloud.aiplatform.v1beta1.RagContexts result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagContexts buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RagContexts result =
          new com.google.cloud.aiplatform.v1beta1.RagContexts(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.RagContexts result) {
      if (contextsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          contexts_ = java.util.Collections.unmodifiableList(contexts_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.contexts_ = contexts_;
      } else {
        result.contexts_ = contextsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagContexts result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RagContexts) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagContexts) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagContexts other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RagContexts.getDefaultInstance())
        return this;
      if (contextsBuilder_ == null) {
        if (!other.contexts_.isEmpty()) {
          if (contexts_.isEmpty()) {
            contexts_ = other.contexts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureContextsIsMutable();
            contexts_.addAll(other.contexts_);
          }
          onChanged();
        }
      } else {
        if (!other.contexts_.isEmpty()) {
          if (contextsBuilder_.isEmpty()) {
            contextsBuilder_.dispose();
            contextsBuilder_ = null;
            contexts_ = other.contexts_;
            bitField0_ = (bitField0_ & ~0x00000001);
            contextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContextsFieldBuilder()
                    : null;
          } else {
            contextsBuilder_.addAllMessages(other.contexts_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.RagContexts.Context m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.RagContexts.Context.parser(),
                        extensionRegistry);
                if (contextsBuilder_ == null) {
                  ensureContextsIsMutable();
                  contexts_.add(m);
                } else {
                  contextsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.RagContexts.Context> contexts_ =
        java.util.Collections.emptyList();

    private void ensureContextsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        contexts_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.RagContexts.Context>(
                contexts_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagContexts.Context,
            com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder,
            com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder>
        contextsBuilder_;

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.RagContexts.Context>
        getContextsList() {
      if (contextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contexts_);
      } else {
        return contextsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public int getContextsCount() {
      if (contextsBuilder_ == null) {
        return contexts_.size();
      } else {
        return contextsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagContexts.Context getContexts(int index) {
      if (contextsBuilder_ == null) {
        return contexts_.get(index);
      } else {
        return contextsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder setContexts(
        int index, com.google.cloud.aiplatform.v1beta1.RagContexts.Context value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.set(index, value);
        onChanged();
      } else {
        contextsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder setContexts(
        int index,
        com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder addContexts(com.google.cloud.aiplatform.v1beta1.RagContexts.Context value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.add(value);
        onChanged();
      } else {
        contextsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder addContexts(
        int index, com.google.cloud.aiplatform.v1beta1.RagContexts.Context value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.add(index, value);
        onChanged();
      } else {
        contextsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder addContexts(
        com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.add(builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder addContexts(
        int index,
        com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder addAllContexts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.RagContexts.Context>
            values) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contexts_);
        onChanged();
      } else {
        contextsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder clearContexts() {
      if (contextsBuilder_ == null) {
        contexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        contextsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public Builder removeContexts(int index) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.remove(index);
        onChanged();
      } else {
        contextsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder getContextsBuilder(
        int index) {
      return getContextsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder getContextsOrBuilder(
        int index) {
      if (contextsBuilder_ == null) {
        return contexts_.get(index);
      } else {
        return contextsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder>
        getContextsOrBuilderList() {
      if (contextsBuilder_ != null) {
        return contextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contexts_);
      }
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder addContextsBuilder() {
      return getContextsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.RagContexts.Context.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder addContextsBuilder(
        int index) {
      return getContextsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.RagContexts.Context.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All its contexts.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.RagContexts.Context contexts = 1;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder>
        getContextsBuilderList() {
      return getContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagContexts.Context,
            com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder,
            com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder>
        getContextsFieldBuilder() {
      if (contextsBuilder_ == null) {
        contextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagContexts.Context,
                com.google.cloud.aiplatform.v1beta1.RagContexts.Context.Builder,
                com.google.cloud.aiplatform.v1beta1.RagContexts.ContextOrBuilder>(
                contexts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        contexts_ = null;
      }
      return contextsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagContexts)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagContexts)
  private static final com.google.cloud.aiplatform.v1beta1.RagContexts DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagContexts();
  }

  public static com.google.cloud.aiplatform.v1beta1.RagContexts getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagContexts> PARSER =
      new com.google.protobuf.AbstractParser<RagContexts>() {
        @java.lang.Override
        public RagContexts parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagContexts> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagContexts> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagContexts getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
