/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata config for RagFile.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagFileMetadataConfig}
 */
public final class RagFileMetadataConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagFileMetadataConfig)
    RagFileMetadataConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagFileMetadataConfig.newBuilder() to construct.
  private RagFileMetadataConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagFileMetadataConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagFileMetadataConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagFileMetadataConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagFileMetadataConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.class,
            com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.Builder.class);
  }

  private int metadataSchemaSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadataSchemaSource_;

  public enum MetadataSchemaSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_METADATA_SCHEMA_SOURCE(1),
    GOOGLE_DRIVE_METADATA_SCHEMA_SOURCE(2),
    INLINE_METADATA_SCHEMA_SOURCE(3),
    METADATASCHEMASOURCE_NOT_SET(0);
    private final int value;

    private MetadataSchemaSourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataSchemaSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataSchemaSourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_METADATA_SCHEMA_SOURCE;
        case 2:
          return GOOGLE_DRIVE_METADATA_SCHEMA_SOURCE;
        case 3:
          return INLINE_METADATA_SCHEMA_SOURCE;
        case 0:
          return METADATASCHEMASOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataSchemaSourceCase getMetadataSchemaSourceCase() {
    return MetadataSchemaSourceCase.forNumber(metadataSchemaSourceCase_);
  }

  private int metadataSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadataSource_;

  public enum MetadataSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_METADATA_SOURCE(4),
    GOOGLE_DRIVE_METADATA_SOURCE(5),
    INLINE_METADATA_SOURCE(6),
    METADATASOURCE_NOT_SET(0);
    private final int value;

    private MetadataSourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataSourceCase forNumber(int value) {
      switch (value) {
        case 4:
          return GCS_METADATA_SOURCE;
        case 5:
          return GOOGLE_DRIVE_METADATA_SOURCE;
        case 6:
          return INLINE_METADATA_SOURCE;
        case 0:
          return METADATASOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataSourceCase getMetadataSourceCase() {
    return MetadataSourceCase.forNumber(metadataSourceCase_);
  }

  public static final int GCS_METADATA_SCHEMA_SOURCE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
   * - `gs://bucket_name/my_directory`
   * If providing a directory, the metadata schema will be read from
   * the files that ends with "metadata_schema.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
   *
   * @return Whether the gcsMetadataSchemaSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsMetadataSchemaSource() {
    return metadataSchemaSourceCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
   * - `gs://bucket_name/my_directory`
   * If providing a directory, the metadata schema will be read from
   * the files that ends with "metadata_schema.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
   *
   * @return The gcsMetadataSchemaSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsMetadataSchemaSource() {
    if (metadataSchemaSourceCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
   * - `gs://bucket_name/my_directory`
   * If providing a directory, the metadata schema will be read from
   * the files that ends with "metadata_schema.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder
      getGcsMetadataSchemaSourceOrBuilder() {
    if (metadataSchemaSourceCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  public static final int GOOGLE_DRIVE_METADATA_SCHEMA_SOURCE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * If providing a folder, the metadata schema will be read from
   * the files that ends with "metadata_schema.json" in the directory.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
   * </code>
   *
   * @return Whether the googleDriveMetadataSchemaSource field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDriveMetadataSchemaSource() {
    return metadataSchemaSourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * If providing a folder, the metadata schema will be read from
   * the files that ends with "metadata_schema.json" in the directory.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
   * </code>
   *
   * @return The googleDriveMetadataSchemaSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource
      getGoogleDriveMetadataSchemaSource() {
    if (metadataSchemaSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * If providing a folder, the metadata schema will be read from
   * the files that ends with "metadata_schema.json" in the directory.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
      getGoogleDriveMetadataSchemaSourceOrBuilder() {
    if (metadataSchemaSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  public static final int INLINE_METADATA_SCHEMA_SOURCE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Inline metadata schema source. Must be a JSON string.
   * </pre>
   *
   * <code>string inline_metadata_schema_source = 3;</code>
   *
   * @return Whether the inlineMetadataSchemaSource field is set.
   */
  public boolean hasInlineMetadataSchemaSource() {
    return metadataSchemaSourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Inline metadata schema source. Must be a JSON string.
   * </pre>
   *
   * <code>string inline_metadata_schema_source = 3;</code>
   *
   * @return The inlineMetadataSchemaSource.
   */
  public java.lang.String getInlineMetadataSchemaSource() {
    java.lang.Object ref = "";
    if (metadataSchemaSourceCase_ == 3) {
      ref = metadataSchemaSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (metadataSchemaSourceCase_ == 3) {
        metadataSchemaSource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Inline metadata schema source. Must be a JSON string.
   * </pre>
   *
   * <code>string inline_metadata_schema_source = 3;</code>
   *
   * @return The bytes for inlineMetadataSchemaSource.
   */
  public com.google.protobuf.ByteString getInlineMetadataSchemaSourceBytes() {
    java.lang.Object ref = "";
    if (metadataSchemaSourceCase_ == 3) {
      ref = metadataSchemaSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (metadataSchemaSourceCase_ == 3) {
        metadataSchemaSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_METADATA_SOURCE_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/metadata.json`
   * - `gs://bucket_name/my_directory`
   * If providing a directory, the metadata will be read from
   * the files that ends with "metadata.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
   *
   * @return Whether the gcsMetadataSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsMetadataSource() {
    return metadataSourceCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/metadata.json`
   * - `gs://bucket_name/my_directory`
   * If providing a directory, the metadata will be read from
   * the files that ends with "metadata.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
   *
   * @return The gcsMetadataSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsMetadataSource() {
    if (metadataSourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/metadata.json`
   * - `gs://bucket_name/my_directory`
   * If providing a directory, the metadata will be read from
   * the files that ends with "metadata.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsMetadataSourceOrBuilder() {
    if (metadataSourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  public static final int GOOGLE_DRIVE_METADATA_SOURCE_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * If providing a directory, the metadata will be read from
   * the files that ends with "metadata.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
   * </code>
   *
   * @return Whether the googleDriveMetadataSource field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDriveMetadataSource() {
    return metadataSourceCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * If providing a directory, the metadata will be read from
   * the files that ends with "metadata.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
   * </code>
   *
   * @return The googleDriveMetadataSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveMetadataSource() {
    if (metadataSourceCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * If providing a directory, the metadata will be read from
   * the files that ends with "metadata.json" in the directory.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
      getGoogleDriveMetadataSourceOrBuilder() {
    if (metadataSourceCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  public static final int INLINE_METADATA_SOURCE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Inline metadata source. Must be a JSON string.
   * </pre>
   *
   * <code>string inline_metadata_source = 6;</code>
   *
   * @return Whether the inlineMetadataSource field is set.
   */
  public boolean hasInlineMetadataSource() {
    return metadataSourceCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Inline metadata source. Must be a JSON string.
   * </pre>
   *
   * <code>string inline_metadata_source = 6;</code>
   *
   * @return The inlineMetadataSource.
   */
  public java.lang.String getInlineMetadataSource() {
    java.lang.Object ref = "";
    if (metadataSourceCase_ == 6) {
      ref = metadataSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (metadataSourceCase_ == 6) {
        metadataSource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Inline metadata source. Must be a JSON string.
   * </pre>
   *
   * <code>string inline_metadata_source = 6;</code>
   *
   * @return The bytes for inlineMetadataSource.
   */
  public com.google.protobuf.ByteString getInlineMetadataSourceBytes() {
    java.lang.Object ref = "";
    if (metadataSourceCase_ == 6) {
      ref = metadataSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (metadataSourceCase_ == 6) {
        metadataSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (metadataSchemaSourceCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_);
    }
    if (metadataSchemaSourceCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_);
    }
    if (metadataSchemaSourceCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, metadataSchemaSource_);
    }
    if (metadataSourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_);
    }
    if (metadataSourceCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_);
    }
    if (metadataSourceCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, metadataSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (metadataSchemaSourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_);
    }
    if (metadataSchemaSourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_);
    }
    if (metadataSchemaSourceCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, metadataSchemaSource_);
    }
    if (metadataSourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_);
    }
    if (metadataSourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_);
    }
    if (metadataSourceCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, metadataSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig other =
        (com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig) obj;

    if (!getMetadataSchemaSourceCase().equals(other.getMetadataSchemaSourceCase())) return false;
    switch (metadataSchemaSourceCase_) {
      case 1:
        if (!getGcsMetadataSchemaSource().equals(other.getGcsMetadataSchemaSource())) return false;
        break;
      case 2:
        if (!getGoogleDriveMetadataSchemaSource()
            .equals(other.getGoogleDriveMetadataSchemaSource())) return false;
        break;
      case 3:
        if (!getInlineMetadataSchemaSource().equals(other.getInlineMetadataSchemaSource()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getMetadataSourceCase().equals(other.getMetadataSourceCase())) return false;
    switch (metadataSourceCase_) {
      case 4:
        if (!getGcsMetadataSource().equals(other.getGcsMetadataSource())) return false;
        break;
      case 5:
        if (!getGoogleDriveMetadataSource().equals(other.getGoogleDriveMetadataSource()))
          return false;
        break;
      case 6:
        if (!getInlineMetadataSource().equals(other.getInlineMetadataSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (metadataSchemaSourceCase_) {
      case 1:
        hash = (37 * hash) + GCS_METADATA_SCHEMA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsMetadataSchemaSource().hashCode();
        break;
      case 2:
        hash = (37 * hash) + GOOGLE_DRIVE_METADATA_SCHEMA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleDriveMetadataSchemaSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + INLINE_METADATA_SCHEMA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineMetadataSchemaSource().hashCode();
        break;
      case 0:
      default:
    }
    switch (metadataSourceCase_) {
      case 4:
        hash = (37 * hash) + GCS_METADATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsMetadataSource().hashCode();
        break;
      case 5:
        hash = (37 * hash) + GOOGLE_DRIVE_METADATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleDriveMetadataSource().hashCode();
        break;
      case 6:
        hash = (37 * hash) + INLINE_METADATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineMetadataSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata config for RagFile.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagFileMetadataConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagFileMetadataConfig)
      com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagFileMetadataConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagFileMetadataConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.class,
              com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsMetadataSchemaSourceBuilder_ != null) {
        gcsMetadataSchemaSourceBuilder_.clear();
      }
      if (googleDriveMetadataSchemaSourceBuilder_ != null) {
        googleDriveMetadataSchemaSourceBuilder_.clear();
      }
      if (gcsMetadataSourceBuilder_ != null) {
        gcsMetadataSourceBuilder_.clear();
      }
      if (googleDriveMetadataSourceBuilder_ != null) {
        googleDriveMetadataSourceBuilder_.clear();
      }
      metadataSchemaSourceCase_ = 0;
      metadataSchemaSource_ = null;
      metadataSourceCase_ = 0;
      metadataSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagFileMetadataConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig build() {
      com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig result =
          new com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig result) {
      result.metadataSchemaSourceCase_ = metadataSchemaSourceCase_;
      result.metadataSchemaSource_ = this.metadataSchemaSource_;
      if (metadataSchemaSourceCase_ == 1 && gcsMetadataSchemaSourceBuilder_ != null) {
        result.metadataSchemaSource_ = gcsMetadataSchemaSourceBuilder_.build();
      }
      if (metadataSchemaSourceCase_ == 2 && googleDriveMetadataSchemaSourceBuilder_ != null) {
        result.metadataSchemaSource_ = googleDriveMetadataSchemaSourceBuilder_.build();
      }
      result.metadataSourceCase_ = metadataSourceCase_;
      result.metadataSource_ = this.metadataSource_;
      if (metadataSourceCase_ == 4 && gcsMetadataSourceBuilder_ != null) {
        result.metadataSource_ = gcsMetadataSourceBuilder_.build();
      }
      if (metadataSourceCase_ == 5 && googleDriveMetadataSourceBuilder_ != null) {
        result.metadataSource_ = googleDriveMetadataSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.getDefaultInstance())
        return this;
      switch (other.getMetadataSchemaSourceCase()) {
        case GCS_METADATA_SCHEMA_SOURCE:
          {
            mergeGcsMetadataSchemaSource(other.getGcsMetadataSchemaSource());
            break;
          }
        case GOOGLE_DRIVE_METADATA_SCHEMA_SOURCE:
          {
            mergeGoogleDriveMetadataSchemaSource(other.getGoogleDriveMetadataSchemaSource());
            break;
          }
        case INLINE_METADATA_SCHEMA_SOURCE:
          {
            metadataSchemaSourceCase_ = 3;
            metadataSchemaSource_ = other.metadataSchemaSource_;
            onChanged();
            break;
          }
        case METADATASCHEMASOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getMetadataSourceCase()) {
        case GCS_METADATA_SOURCE:
          {
            mergeGcsMetadataSource(other.getGcsMetadataSource());
            break;
          }
        case GOOGLE_DRIVE_METADATA_SOURCE:
          {
            mergeGoogleDriveMetadataSource(other.getGoogleDriveMetadataSource());
            break;
          }
        case INLINE_METADATA_SOURCE:
          {
            metadataSourceCase_ = 6;
            metadataSource_ = other.metadataSource_;
            onChanged();
            break;
          }
        case METADATASOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getGcsMetadataSchemaSourceFieldBuilder().getBuilder(), extensionRegistry);
                metadataSchemaSourceCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getGoogleDriveMetadataSchemaSourceFieldBuilder().getBuilder(),
                    extensionRegistry);
                metadataSchemaSourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                metadataSchemaSourceCase_ = 3;
                metadataSchemaSource_ = s;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGcsMetadataSourceFieldBuilder().getBuilder(), extensionRegistry);
                metadataSourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getGoogleDriveMetadataSourceFieldBuilder().getBuilder(), extensionRegistry);
                metadataSourceCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                metadataSourceCase_ = 6;
                metadataSource_ = s;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metadataSchemaSourceCase_ = 0;
    private java.lang.Object metadataSchemaSource_;

    public MetadataSchemaSourceCase getMetadataSchemaSourceCase() {
      return MetadataSchemaSourceCase.forNumber(metadataSchemaSourceCase_);
    }

    public Builder clearMetadataSchemaSource() {
      metadataSchemaSourceCase_ = 0;
      metadataSchemaSource_ = null;
      onChanged();
      return this;
    }

    private int metadataSourceCase_ = 0;
    private java.lang.Object metadataSource_;

    public MetadataSourceCase getMetadataSourceCase() {
      return MetadataSourceCase.forNumber(metadataSourceCase_);
    }

    public Builder clearMetadataSource() {
      metadataSourceCase_ = 0;
      metadataSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        gcsMetadataSchemaSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     *
     * @return Whether the gcsMetadataSchemaSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsMetadataSchemaSource() {
      return metadataSchemaSourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     *
     * @return The gcsMetadataSchemaSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsMetadataSchemaSource() {
      if (gcsMetadataSchemaSourceBuilder_ == null) {
        if (metadataSchemaSourceCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      } else {
        if (metadataSchemaSourceCase_ == 1) {
          return gcsMetadataSchemaSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    public Builder setGcsMetadataSchemaSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsMetadataSchemaSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataSchemaSource_ = value;
        onChanged();
      } else {
        gcsMetadataSchemaSourceBuilder_.setMessage(value);
      }
      metadataSchemaSourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    public Builder setGcsMetadataSchemaSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsMetadataSchemaSourceBuilder_ == null) {
        metadataSchemaSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsMetadataSchemaSourceBuilder_.setMessage(builderForValue.build());
      }
      metadataSchemaSourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    public Builder mergeGcsMetadataSchemaSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsMetadataSchemaSourceBuilder_ == null) {
        if (metadataSchemaSourceCase_ == 1
            && metadataSchemaSource_
                != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
          metadataSchemaSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataSchemaSource_ = value;
        }
        onChanged();
      } else {
        if (metadataSchemaSourceCase_ == 1) {
          gcsMetadataSchemaSourceBuilder_.mergeFrom(value);
        } else {
          gcsMetadataSchemaSourceBuilder_.setMessage(value);
        }
      }
      metadataSchemaSourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    public Builder clearGcsMetadataSchemaSource() {
      if (gcsMetadataSchemaSourceBuilder_ == null) {
        if (metadataSchemaSourceCase_ == 1) {
          metadataSchemaSourceCase_ = 0;
          metadataSchemaSource_ = null;
          onChanged();
        }
      } else {
        if (metadataSchemaSourceCase_ == 1) {
          metadataSchemaSourceCase_ = 0;
          metadataSchemaSource_ = null;
        }
        gcsMetadataSchemaSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder
        getGcsMetadataSchemaSourceBuilder() {
      return getGcsMetadataSchemaSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder
        getGcsMetadataSchemaSourceOrBuilder() {
      if ((metadataSchemaSourceCase_ == 1) && (gcsMetadataSchemaSourceBuilder_ != null)) {
        return gcsMetadataSchemaSourceBuilder_.getMessageOrBuilder();
      } else {
        if (metadataSchemaSourceCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_schema_source = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        getGcsMetadataSchemaSourceFieldBuilder() {
      if (gcsMetadataSchemaSourceBuilder_ == null) {
        if (!(metadataSchemaSourceCase_ == 1)) {
          metadataSchemaSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
        gcsMetadataSchemaSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsSource,
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSchemaSource_,
                getParentForChildren(),
                isClean());
        metadataSchemaSource_ = null;
      }
      metadataSchemaSourceCase_ = 1;
      onChanged();
      return gcsMetadataSchemaSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        googleDriveMetadataSchemaSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     *
     * @return Whether the googleDriveMetadataSchemaSource field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDriveMetadataSchemaSource() {
      return metadataSchemaSourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     *
     * @return The googleDriveMetadataSchemaSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource
        getGoogleDriveMetadataSchemaSource() {
      if (googleDriveMetadataSchemaSourceBuilder_ == null) {
        if (metadataSchemaSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      } else {
        if (metadataSchemaSourceCase_ == 2) {
          return googleDriveMetadataSchemaSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    public Builder setGoogleDriveMetadataSchemaSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveMetadataSchemaSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataSchemaSource_ = value;
        onChanged();
      } else {
        googleDriveMetadataSchemaSourceBuilder_.setMessage(value);
      }
      metadataSchemaSourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    public Builder setGoogleDriveMetadataSchemaSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder builderForValue) {
      if (googleDriveMetadataSchemaSourceBuilder_ == null) {
        metadataSchemaSource_ = builderForValue.build();
        onChanged();
      } else {
        googleDriveMetadataSchemaSourceBuilder_.setMessage(builderForValue.build());
      }
      metadataSchemaSourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    public Builder mergeGoogleDriveMetadataSchemaSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveMetadataSchemaSourceBuilder_ == null) {
        if (metadataSchemaSourceCase_ == 2
            && metadataSchemaSource_
                != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance()) {
          metadataSchemaSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataSchemaSource_ = value;
        }
        onChanged();
      } else {
        if (metadataSchemaSourceCase_ == 2) {
          googleDriveMetadataSchemaSourceBuilder_.mergeFrom(value);
        } else {
          googleDriveMetadataSchemaSourceBuilder_.setMessage(value);
        }
      }
      metadataSchemaSourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    public Builder clearGoogleDriveMetadataSchemaSource() {
      if (googleDriveMetadataSchemaSourceBuilder_ == null) {
        if (metadataSchemaSourceCase_ == 2) {
          metadataSchemaSourceCase_ = 0;
          metadataSchemaSource_ = null;
          onChanged();
        }
      } else {
        if (metadataSchemaSourceCase_ == 2) {
          metadataSchemaSourceCase_ = 0;
          metadataSchemaSource_ = null;
        }
        googleDriveMetadataSchemaSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder
        getGoogleDriveMetadataSchemaSourceBuilder() {
      return getGoogleDriveMetadataSchemaSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
        getGoogleDriveMetadataSchemaSourceOrBuilder() {
      if ((metadataSchemaSourceCase_ == 2) && (googleDriveMetadataSchemaSourceBuilder_ != null)) {
        return googleDriveMetadataSchemaSourceBuilder_.getMessageOrBuilder();
      } else {
        if (metadataSchemaSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a folder, the metadata schema will be read from
     * the files that ends with "metadata_schema.json" in the directory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_schema_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        getGoogleDriveMetadataSchemaSourceFieldBuilder() {
      if (googleDriveMetadataSchemaSourceBuilder_ == null) {
        if (!(metadataSchemaSourceCase_ == 2)) {
          metadataSchemaSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
        }
        googleDriveMetadataSchemaSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSchemaSource_,
                getParentForChildren(),
                isClean());
        metadataSchemaSource_ = null;
      }
      metadataSchemaSourceCase_ = 2;
      onChanged();
      return googleDriveMetadataSchemaSourceBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata schema source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_schema_source = 3;</code>
     *
     * @return Whether the inlineMetadataSchemaSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineMetadataSchemaSource() {
      return metadataSchemaSourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata schema source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_schema_source = 3;</code>
     *
     * @return The inlineMetadataSchemaSource.
     */
    @java.lang.Override
    public java.lang.String getInlineMetadataSchemaSource() {
      java.lang.Object ref = "";
      if (metadataSchemaSourceCase_ == 3) {
        ref = metadataSchemaSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (metadataSchemaSourceCase_ == 3) {
          metadataSchemaSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Inline metadata schema source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_schema_source = 3;</code>
     *
     * @return The bytes for inlineMetadataSchemaSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInlineMetadataSchemaSourceBytes() {
      java.lang.Object ref = "";
      if (metadataSchemaSourceCase_ == 3) {
        ref = metadataSchemaSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (metadataSchemaSourceCase_ == 3) {
          metadataSchemaSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Inline metadata schema source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_schema_source = 3;</code>
     *
     * @param value The inlineMetadataSchemaSource to set.
     * @return This builder for chaining.
     */
    public Builder setInlineMetadataSchemaSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataSchemaSourceCase_ = 3;
      metadataSchemaSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata schema source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_schema_source = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInlineMetadataSchemaSource() {
      if (metadataSchemaSourceCase_ == 3) {
        metadataSchemaSourceCase_ = 0;
        metadataSchemaSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata schema source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_schema_source = 3;</code>
     *
     * @param value The bytes for inlineMetadataSchemaSource to set.
     * @return This builder for chaining.
     */
    public Builder setInlineMetadataSchemaSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataSchemaSourceCase_ = 3;
      metadataSchemaSource_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        gcsMetadataSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     *
     * @return Whether the gcsMetadataSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsMetadataSource() {
      return metadataSourceCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     *
     * @return The gcsMetadataSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsMetadataSource() {
      if (gcsMetadataSourceBuilder_ == null) {
        if (metadataSourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      } else {
        if (metadataSourceCase_ == 4) {
          return gcsMetadataSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    public Builder setGcsMetadataSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsMetadataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataSource_ = value;
        onChanged();
      } else {
        gcsMetadataSourceBuilder_.setMessage(value);
      }
      metadataSourceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    public Builder setGcsMetadataSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsMetadataSourceBuilder_ == null) {
        metadataSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsMetadataSourceBuilder_.setMessage(builderForValue.build());
      }
      metadataSourceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    public Builder mergeGcsMetadataSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsMetadataSourceBuilder_ == null) {
        if (metadataSourceCase_ == 4
            && metadataSource_
                != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
          metadataSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataSource_ = value;
        }
        onChanged();
      } else {
        if (metadataSourceCase_ == 4) {
          gcsMetadataSourceBuilder_.mergeFrom(value);
        } else {
          gcsMetadataSourceBuilder_.setMessage(value);
        }
      }
      metadataSourceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    public Builder clearGcsMetadataSource() {
      if (gcsMetadataSourceBuilder_ == null) {
        if (metadataSourceCase_ == 4) {
          metadataSourceCase_ = 0;
          metadataSource_ = null;
          onChanged();
        }
      } else {
        if (metadataSourceCase_ == 4) {
          metadataSourceCase_ = 0;
          metadataSource_ = null;
        }
        gcsMetadataSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsMetadataSourceBuilder() {
      return getGcsMetadataSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsMetadataSourceOrBuilder() {
      if ((metadataSourceCase_ == 4) && (gcsMetadataSourceBuilder_ != null)) {
        return gcsMetadataSourceBuilder_.getMessageOrBuilder();
      } else {
        if (metadataSourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/metadata.json`
     * - `gs://bucket_name/my_directory`
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_metadata_source = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        getGcsMetadataSourceFieldBuilder() {
      if (gcsMetadataSourceBuilder_ == null) {
        if (!(metadataSourceCase_ == 4)) {
          metadataSource_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
        gcsMetadataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsSource,
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsSource) metadataSource_,
                getParentForChildren(),
                isClean());
        metadataSource_ = null;
      }
      metadataSourceCase_ = 4;
      onChanged();
      return gcsMetadataSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        googleDriveMetadataSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     *
     * @return Whether the googleDriveMetadataSource field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDriveMetadataSource() {
      return metadataSourceCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     *
     * @return The googleDriveMetadataSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveMetadataSource() {
      if (googleDriveMetadataSourceBuilder_ == null) {
        if (metadataSourceCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      } else {
        if (metadataSourceCase_ == 5) {
          return googleDriveMetadataSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    public Builder setGoogleDriveMetadataSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveMetadataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataSource_ = value;
        onChanged();
      } else {
        googleDriveMetadataSourceBuilder_.setMessage(value);
      }
      metadataSourceCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    public Builder setGoogleDriveMetadataSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder builderForValue) {
      if (googleDriveMetadataSourceBuilder_ == null) {
        metadataSource_ = builderForValue.build();
        onChanged();
      } else {
        googleDriveMetadataSourceBuilder_.setMessage(builderForValue.build());
      }
      metadataSourceCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    public Builder mergeGoogleDriveMetadataSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveMetadataSourceBuilder_ == null) {
        if (metadataSourceCase_ == 5
            && metadataSource_
                != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance()) {
          metadataSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadataSource_ = value;
        }
        onChanged();
      } else {
        if (metadataSourceCase_ == 5) {
          googleDriveMetadataSourceBuilder_.mergeFrom(value);
        } else {
          googleDriveMetadataSourceBuilder_.setMessage(value);
        }
      }
      metadataSourceCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    public Builder clearGoogleDriveMetadataSource() {
      if (googleDriveMetadataSourceBuilder_ == null) {
        if (metadataSourceCase_ == 5) {
          metadataSourceCase_ = 0;
          metadataSource_ = null;
          onChanged();
        }
      } else {
        if (metadataSourceCase_ == 5) {
          metadataSourceCase_ = 0;
          metadataSource_ = null;
        }
        googleDriveMetadataSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder
        getGoogleDriveMetadataSourceBuilder() {
      return getGoogleDriveMetadataSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
        getGoogleDriveMetadataSourceOrBuilder() {
      if ((metadataSourceCase_ == 5) && (googleDriveMetadataSourceBuilder_ != null)) {
        return googleDriveMetadataSourceBuilder_.getMessageOrBuilder();
      } else {
        if (metadataSourceCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * If providing a directory, the metadata will be read from
     * the files that ends with "metadata.json" in the directory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_metadata_source = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        getGoogleDriveMetadataSourceFieldBuilder() {
      if (googleDriveMetadataSourceBuilder_ == null) {
        if (!(metadataSourceCase_ == 5)) {
          metadataSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
        }
        googleDriveMetadataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) metadataSource_,
                getParentForChildren(),
                isClean());
        metadataSource_ = null;
      }
      metadataSourceCase_ = 5;
      onChanged();
      return googleDriveMetadataSourceBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_source = 6;</code>
     *
     * @return Whether the inlineMetadataSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineMetadataSource() {
      return metadataSourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_source = 6;</code>
     *
     * @return The inlineMetadataSource.
     */
    @java.lang.Override
    public java.lang.String getInlineMetadataSource() {
      java.lang.Object ref = "";
      if (metadataSourceCase_ == 6) {
        ref = metadataSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (metadataSourceCase_ == 6) {
          metadataSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Inline metadata source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_source = 6;</code>
     *
     * @return The bytes for inlineMetadataSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInlineMetadataSourceBytes() {
      java.lang.Object ref = "";
      if (metadataSourceCase_ == 6) {
        ref = metadataSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (metadataSourceCase_ == 6) {
          metadataSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Inline metadata source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_source = 6;</code>
     *
     * @param value The inlineMetadataSource to set.
     * @return This builder for chaining.
     */
    public Builder setInlineMetadataSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataSourceCase_ = 6;
      metadataSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_source = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInlineMetadataSource() {
      if (metadataSourceCase_ == 6) {
        metadataSourceCase_ = 0;
        metadataSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Inline metadata source. Must be a JSON string.
     * </pre>
     *
     * <code>string inline_metadata_source = 6;</code>
     *
     * @param value The bytes for inlineMetadataSource to set.
     * @return This builder for chaining.
     */
    public Builder setInlineMetadataSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataSourceCase_ = 6;
      metadataSource_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagFileMetadataConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagFileMetadataConfig)
  private static final com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagFileMetadataConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagFileMetadataConfig>() {
        @java.lang.Override
        public RagFileMetadataConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagFileMetadataConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagFileMetadataConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
