/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/reasoning_engine.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for how Agent Engine sub-resources should manage context.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec}
 */
public final class ReasoningEngineContextSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec)
    ReasoningEngineContextSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReasoningEngineContextSpec.newBuilder() to construct.
  private ReasoningEngineContextSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReasoningEngineContextSpec() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReasoningEngineContextSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
        .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
        .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.class,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.Builder.class);
  }

  public interface MemoryBankConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to generate memories for the Memory Bank.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the generationConfig field is set.
     */
    boolean hasGenerationConfig();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to generate memories for the Memory Bank.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The generationConfig.
     */
    com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig
        getGenerationConfig();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to generate memories for the Memory Bank.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .GenerationConfigOrBuilder
        getGenerationConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to perform similarity search on memories.
     * If not set, the Memory Bank will use the default embedding model
     * `text-embedding-005`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the similaritySearchConfig field is set.
     */
    boolean hasSimilaritySearchConfig();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to perform similarity search on memories.
     * If not set, the Memory Bank will use the default embedding model
     * `text-embedding-005`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The similaritySearchConfig.
     */
    com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .SimilaritySearchConfig
        getSimilaritySearchConfig();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to perform similarity search on memories.
     * If not set, the Memory Bank will use the default embedding model
     * `text-embedding-005`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .SimilaritySearchConfigOrBuilder
        getSimilaritySearchConfigOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Specification for a Memory Bank.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig}
   */
  public static final class MemoryBankConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)
      MemoryBankConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MemoryBankConfig.newBuilder() to construct.
    private MemoryBankConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MemoryBankConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MemoryBankConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.class,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .Builder.class);
    }

    public interface GenerationConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The model used to generate memories.
       * Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The model.
       */
      java.lang.String getModel();

      /**
       *
       *
       * <pre>
       * Required. The model used to generate memories.
       * Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for model.
       */
      com.google.protobuf.ByteString getModelBytes();
    }

    /**
     *
     *
     * <pre>
     * Configuration for how to generate memories.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig}
     */
    public static final class GenerationConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig)
        GenerationConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use GenerationConfig.newBuilder() to construct.
      private GenerationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GenerationConfig() {
        model_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GenerationConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .GenerationConfig.class,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .GenerationConfig.Builder.class);
      }

      public static final int MODEL_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object model_ = "";

      /**
       *
       *
       * <pre>
       * Required. The model used to generate memories.
       * Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The model.
       */
      @java.lang.Override
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The model used to generate memories.
       * Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for model.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .GenerationConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .GenerationConfig
            other =
                (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                        .GenerationConfig)
                    obj;

        if (!getModel().equals(other.getModel())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getModel().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configuration for how to generate memories.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig)
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .GenerationConfig.class,
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .GenerationConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          model_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .GenerationConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .GenerationConfig
            build() {
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .GenerationConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig
              result =
                  new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
                      .MemoryBankConfig.GenerationConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .GenerationConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.model_ = model_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                        .GenerationConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .GenerationConfig
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig.getDefaultInstance()) return this;
          if (!other.getModel().isEmpty()) {
            model_ = other.model_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    model_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object model_ = "";

        /**
         *
         *
         * <pre>
         * Required. The model used to generate memories.
         * Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The model.
         */
        public java.lang.String getModel() {
          java.lang.Object ref = model_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            model_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate memories.
         * Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for model.
         */
        public com.google.protobuf.ByteString getModelBytes() {
          java.lang.Object ref = model_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            model_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate memories.
         * Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The model to set.
         * @return This builder for chaining.
         */
        public Builder setModel(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          model_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate memories.
         * Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModel() {
          model_ = getDefaultInstance().getModel();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate memories.
         * Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for model to set.
         * @return This builder for chaining.
         */
        public Builder setModelBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          model_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig)
      private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
              .MemoryBankConfig.GenerationConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .GenerationConfig();
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GenerationConfig> PARSER =
          new com.google.protobuf.AbstractParser<GenerationConfig>() {
            @java.lang.Override
            public GenerationConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GenerationConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GenerationConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SimilaritySearchConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The model used to generate embeddings to lookup similar
       * memories. Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The embeddingModel.
       */
      java.lang.String getEmbeddingModel();

      /**
       *
       *
       * <pre>
       * Required. The model used to generate embeddings to lookup similar
       * memories. Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for embeddingModel.
       */
      com.google.protobuf.ByteString getEmbeddingModelBytes();
    }

    /**
     *
     *
     * <pre>
     * Configuration for how to perform similarity search on memories.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig}
     */
    public static final class SimilaritySearchConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig)
        SimilaritySearchConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use SimilaritySearchConfig.newBuilder() to construct.
      private SimilaritySearchConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SimilaritySearchConfig() {
        embeddingModel_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SimilaritySearchConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .SimilaritySearchConfig.class,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .SimilaritySearchConfig.Builder.class);
      }

      public static final int EMBEDDING_MODEL_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object embeddingModel_ = "";

      /**
       *
       *
       * <pre>
       * Required. The model used to generate embeddings to lookup similar
       * memories. Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The embeddingModel.
       */
      @java.lang.Override
      public java.lang.String getEmbeddingModel() {
        java.lang.Object ref = embeddingModel_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          embeddingModel_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The model used to generate embeddings to lookup similar
       * memories. Format:
       * `projects/{project}/locations/{location}/publishers/google/models/{model}`
       * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
       * </pre>
       *
       * <code>
       * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for embeddingModel.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEmbeddingModelBytes() {
        java.lang.Object ref = embeddingModel_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          embeddingModel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(embeddingModel_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, embeddingModel_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(embeddingModel_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, embeddingModel_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .SimilaritySearchConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .SimilaritySearchConfig
            other =
                (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                        .SimilaritySearchConfig)
                    obj;

        if (!getEmbeddingModel().equals(other.getEmbeddingModel())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + EMBEDDING_MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getEmbeddingModel().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configuration for how to perform similarity search on memories.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig)
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .SimilaritySearchConfig.class,
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .SimilaritySearchConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          embeddingModel_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .SimilaritySearchConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .SimilaritySearchConfig
            build() {
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .SimilaritySearchConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig
              result =
                  new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
                      .MemoryBankConfig.SimilaritySearchConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .SimilaritySearchConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.embeddingModel_ = embeddingModel_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                        .SimilaritySearchConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .SimilaritySearchConfig
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig.getDefaultInstance()) return this;
          if (!other.getEmbeddingModel().isEmpty()) {
            embeddingModel_ = other.embeddingModel_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    embeddingModel_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object embeddingModel_ = "";

        /**
         *
         *
         * <pre>
         * Required. The model used to generate embeddings to lookup similar
         * memories. Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The embeddingModel.
         */
        public java.lang.String getEmbeddingModel() {
          java.lang.Object ref = embeddingModel_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            embeddingModel_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate embeddings to lookup similar
         * memories. Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for embeddingModel.
         */
        public com.google.protobuf.ByteString getEmbeddingModelBytes() {
          java.lang.Object ref = embeddingModel_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            embeddingModel_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate embeddings to lookup similar
         * memories. Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The embeddingModel to set.
         * @return This builder for chaining.
         */
        public Builder setEmbeddingModel(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          embeddingModel_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate embeddings to lookup similar
         * memories. Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEmbeddingModel() {
          embeddingModel_ = getDefaultInstance().getEmbeddingModel();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The model used to generate embeddings to lookup similar
         * memories. Format:
         * `projects/{project}/locations/{location}/publishers/google/models/{model}`
         * or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
         * </pre>
         *
         * <code>
         * string embedding_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for embeddingModel to set.
         * @return This builder for chaining.
         */
        public Builder setEmbeddingModelBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          embeddingModel_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig)
      private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
              .MemoryBankConfig.SimilaritySearchConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .SimilaritySearchConfig();
      }

      public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SimilaritySearchConfig> PARSER =
          new com.google.protobuf.AbstractParser<SimilaritySearchConfig>() {
            @java.lang.Override
            public SimilaritySearchConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SimilaritySearchConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SimilaritySearchConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int GENERATION_CONFIG_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .GenerationConfig
        generationConfig_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to generate memories for the Memory Bank.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the generationConfig field is set.
     */
    @java.lang.Override
    public boolean hasGenerationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to generate memories for the Memory Bank.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The generationConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .GenerationConfig
        getGenerationConfig() {
      return generationConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig.getDefaultInstance()
          : generationConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to generate memories for the Memory Bank.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .GenerationConfigOrBuilder
        getGenerationConfigOrBuilder() {
      return generationConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig.getDefaultInstance()
          : generationConfig_;
    }

    public static final int SIMILARITY_SEARCH_CONFIG_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .SimilaritySearchConfig
        similaritySearchConfig_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to perform similarity search on memories.
     * If not set, the Memory Bank will use the default embedding model
     * `text-embedding-005`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the similaritySearchConfig field is set.
     */
    @java.lang.Override
    public boolean hasSimilaritySearchConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to perform similarity search on memories.
     * If not set, the Memory Bank will use the default embedding model
     * `text-embedding-005`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The similaritySearchConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .SimilaritySearchConfig
        getSimilaritySearchConfig() {
      return similaritySearchConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig.getDefaultInstance()
          : similaritySearchConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for how to perform similarity search on memories.
     * If not set, the Memory Bank will use the default embedding model
     * `text-embedding-005`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .SimilaritySearchConfigOrBuilder
        getSimilaritySearchConfigOrBuilder() {
      return similaritySearchConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig.getDefaultInstance()
          : similaritySearchConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getGenerationConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getSimilaritySearchConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGenerationConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getSimilaritySearchConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig other =
          (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig) obj;

      if (hasGenerationConfig() != other.hasGenerationConfig()) return false;
      if (hasGenerationConfig()) {
        if (!getGenerationConfig().equals(other.getGenerationConfig())) return false;
      }
      if (hasSimilaritySearchConfig() != other.hasSimilaritySearchConfig()) return false;
      if (hasSimilaritySearchConfig()) {
        if (!getSimilaritySearchConfig().equals(other.getSimilaritySearchConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasGenerationConfig()) {
        hash = (37 * hash) + GENERATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGenerationConfig().hashCode();
      }
      if (hasSimilaritySearchConfig()) {
        hash = (37 * hash) + SIMILARITY_SEARCH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSimilaritySearchConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Specification for a Memory Bank.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .class,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getGenerationConfigFieldBuilder();
          getSimilaritySearchConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        generationConfig_ = null;
        if (generationConfigBuilder_ != null) {
          generationConfigBuilder_.dispose();
          generationConfigBuilder_ = null;
        }
        similaritySearchConfig_ = null;
        if (similaritySearchConfigBuilder_ != null) {
          similaritySearchConfigBuilder_.dispose();
          similaritySearchConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_MemoryBankConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig result =
            new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.generationConfig_ =
              generationConfigBuilder_ == null
                  ? generationConfig_
                  : generationConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.similaritySearchConfig_ =
              similaritySearchConfigBuilder_ == null
                  ? similaritySearchConfig_
                  : similaritySearchConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .getDefaultInstance()) return this;
        if (other.hasGenerationConfig()) {
          mergeGenerationConfig(other.getGenerationConfig());
        }
        if (other.hasSimilaritySearchConfig()) {
          mergeSimilaritySearchConfig(other.getSimilaritySearchConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getGenerationConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getSimilaritySearchConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          generationConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfigOrBuilder>
          generationConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the generationConfig field is set.
       */
      public boolean hasGenerationConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The generationConfig.
       */
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig
          getGenerationConfig() {
        if (generationConfigBuilder_ == null) {
          return generationConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig.getDefaultInstance()
              : generationConfig_;
        } else {
          return generationConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setGenerationConfig(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig
              value) {
        if (generationConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          generationConfig_ = value;
        } else {
          generationConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setGenerationConfig(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig.Builder
              builderForValue) {
        if (generationConfigBuilder_ == null) {
          generationConfig_ = builderForValue.build();
        } else {
          generationConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeGenerationConfig(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig
              value) {
        if (generationConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && generationConfig_ != null
              && generationConfig_
                  != com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .GenerationConfig.getDefaultInstance()) {
            getGenerationConfigBuilder().mergeFrom(value);
          } else {
            generationConfig_ = value;
          }
        } else {
          generationConfigBuilder_.mergeFrom(value);
        }
        if (generationConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearGenerationConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        generationConfig_ = null;
        if (generationConfigBuilder_ != null) {
          generationConfigBuilder_.dispose();
          generationConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfig.Builder
          getGenerationConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getGenerationConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .GenerationConfigOrBuilder
          getGenerationConfigOrBuilder() {
        if (generationConfigBuilder_ != null) {
          return generationConfigBuilder_.getMessageOrBuilder();
        } else {
          return generationConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig.getDefaultInstance()
              : generationConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to generate memories for the Memory Bank.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig generation_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .GenerationConfigOrBuilder>
          getGenerationConfigFieldBuilder() {
        if (generationConfigBuilder_ == null) {
          generationConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .GenerationConfig,
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .GenerationConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .GenerationConfigOrBuilder>(
                  getGenerationConfig(), getParentForChildren(), isClean());
          generationConfig_ = null;
        }
        return generationConfigBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          similaritySearchConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfigOrBuilder>
          similaritySearchConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the similaritySearchConfig field is set.
       */
      public boolean hasSimilaritySearchConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The similaritySearchConfig.
       */
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig
          getSimilaritySearchConfig() {
        if (similaritySearchConfigBuilder_ == null) {
          return similaritySearchConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig.getDefaultInstance()
              : similaritySearchConfig_;
        } else {
          return similaritySearchConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSimilaritySearchConfig(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig
              value) {
        if (similaritySearchConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          similaritySearchConfig_ = value;
        } else {
          similaritySearchConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSimilaritySearchConfig(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig.Builder
              builderForValue) {
        if (similaritySearchConfigBuilder_ == null) {
          similaritySearchConfig_ = builderForValue.build();
        } else {
          similaritySearchConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeSimilaritySearchConfig(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig
              value) {
        if (similaritySearchConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && similaritySearchConfig_ != null
              && similaritySearchConfig_
                  != com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .SimilaritySearchConfig.getDefaultInstance()) {
            getSimilaritySearchConfigBuilder().mergeFrom(value);
          } else {
            similaritySearchConfig_ = value;
          }
        } else {
          similaritySearchConfigBuilder_.mergeFrom(value);
        }
        if (similaritySearchConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSimilaritySearchConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        similaritySearchConfig_ = null;
        if (similaritySearchConfigBuilder_ != null) {
          similaritySearchConfigBuilder_.dispose();
          similaritySearchConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfig.Builder
          getSimilaritySearchConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSimilaritySearchConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
              .SimilaritySearchConfigOrBuilder
          getSimilaritySearchConfigOrBuilder() {
        if (similaritySearchConfigBuilder_ != null) {
          return similaritySearchConfigBuilder_.getMessageOrBuilder();
        } else {
          return similaritySearchConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig.getDefaultInstance()
              : similaritySearchConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for how to perform similarity search on memories.
       * If not set, the Memory Bank will use the default embedding model
       * `text-embedding-005`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig similarity_search_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                  .SimilaritySearchConfigOrBuilder>
          getSimilaritySearchConfigFieldBuilder() {
        if (similaritySearchConfigBuilder_ == null) {
          similaritySearchConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .SimilaritySearchConfig,
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .SimilaritySearchConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                      .SimilaritySearchConfigOrBuilder>(
                  getSimilaritySearchConfig(), getParentForChildren(), isClean());
          similaritySearchConfig_ = null;
        }
        return similaritySearchConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
            .MemoryBankConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MemoryBankConfig> PARSER =
        new com.google.protobuf.AbstractParser<MemoryBankConfig>() {
          @java.lang.Override
          public MemoryBankConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MemoryBankConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MemoryBankConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int MEMORY_BANK_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
      memoryBankConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Specification for a Memory Bank, which manages memories for the
   * Agent Engine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the memoryBankConfig field is set.
   */
  @java.lang.Override
  public boolean hasMemoryBankConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Specification for a Memory Bank, which manages memories for the
   * Agent Engine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The memoryBankConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
      getMemoryBankConfig() {
    return memoryBankConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .getDefaultInstance()
        : memoryBankConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specification for a Memory Bank, which manages memories for the
   * Agent Engine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfigOrBuilder
      getMemoryBankConfigOrBuilder() {
    return memoryBankConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
            .getDefaultInstance()
        : memoryBankConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getMemoryBankConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMemoryBankConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec other =
        (com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec) obj;

    if (hasMemoryBankConfig() != other.hasMemoryBankConfig()) return false;
    if (hasMemoryBankConfig()) {
      if (!getMemoryBankConfig().equals(other.getMemoryBankConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMemoryBankConfig()) {
      hash = (37 * hash) + MEMORY_BANK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMemoryBankConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration for how Agent Engine sub-resources should manage context.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec)
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.class,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMemoryBankConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      memoryBankConfig_ = null;
      if (memoryBankConfigBuilder_ != null) {
        memoryBankConfigBuilder_.dispose();
        memoryBankConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineContextSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec build() {
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec result =
          new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.memoryBankConfig_ =
            memoryBankConfigBuilder_ == null ? memoryBankConfig_ : memoryBankConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.getDefaultInstance())
        return this;
      if (other.hasMemoryBankConfig()) {
        mergeMemoryBankConfig(other.getMemoryBankConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getMemoryBankConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        memoryBankConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
                .MemoryBankConfigOrBuilder>
        memoryBankConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the memoryBankConfig field is set.
     */
    public boolean hasMemoryBankConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The memoryBankConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
        getMemoryBankConfig() {
      if (memoryBankConfigBuilder_ == null) {
        return memoryBankConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .getDefaultInstance()
            : memoryBankConfig_;
      } else {
        return memoryBankConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMemoryBankConfig(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig value) {
      if (memoryBankConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        memoryBankConfig_ = value;
      } else {
        memoryBankConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMemoryBankConfig(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.Builder
            builderForValue) {
      if (memoryBankConfigBuilder_ == null) {
        memoryBankConfig_ = builderForValue.build();
      } else {
        memoryBankConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMemoryBankConfig(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig value) {
      if (memoryBankConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && memoryBankConfig_ != null
            && memoryBankConfig_
                != com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .getDefaultInstance()) {
          getMemoryBankConfigBuilder().mergeFrom(value);
        } else {
          memoryBankConfig_ = value;
        }
      } else {
        memoryBankConfigBuilder_.mergeFrom(value);
      }
      if (memoryBankConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMemoryBankConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      memoryBankConfig_ = null;
      if (memoryBankConfigBuilder_ != null) {
        memoryBankConfigBuilder_.dispose();
        memoryBankConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.Builder
        getMemoryBankConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getMemoryBankConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfigOrBuilder
        getMemoryBankConfigOrBuilder() {
      if (memoryBankConfigBuilder_ != null) {
        return memoryBankConfigBuilder_.getMessageOrBuilder();
      } else {
        return memoryBankConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                .getDefaultInstance()
            : memoryBankConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specification for a Memory Bank, which manages memories for the
     * Agent Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig memory_bank_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
                .MemoryBankConfigOrBuilder>
        getMemoryBankConfigFieldBuilder() {
      if (memoryBankConfigBuilder_ == null) {
        memoryBankConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
                    .MemoryBankConfigOrBuilder>(
                getMemoryBankConfig(), getParentForChildren(), isClean());
        memoryBankConfig_ = null;
      }
      return memoryBankConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec)
  private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReasoningEngineContextSpec> PARSER =
      new com.google.protobuf.AbstractParser<ReasoningEngineContextSpec>() {
        @java.lang.Override
        public ReasoningEngineContextSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReasoningEngineContextSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReasoningEngineContextSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
