/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vizier_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

public interface SuggestTrialsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.SuggestTrialsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The project and location that the Study belongs to.
   * Format: `projects/{project}/locations/{location}/studies/{study}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The project and location that the Study belongs to.
   * Format: `projects/{project}/locations/{location}/studies/{study}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The number of suggestions requested. It must be positive.
   * </pre>
   *
   * <code>int32 suggestion_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The suggestionCount.
   */
  int getSuggestionCount();

  /**
   *
   *
   * <pre>
   * Required. The identifier of the client that is requesting the suggestion.
   *
   * If multiple SuggestTrialsRequests have the same `client_id`,
   * the service will return the identical suggested Trial if the Trial is
   * pending, and provide a new Trial if the last suggested Trial was completed.
   * </pre>
   *
   * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clientId.
   */
  java.lang.String getClientId();

  /**
   *
   *
   * <pre>
   * Required. The identifier of the client that is requesting the suggestion.
   *
   * If multiple SuggestTrialsRequests have the same `client_id`,
   * the service will return the identical suggested Trial if the Trial is
   * pending, and provide a new Trial if the last suggested Trial was completed.
   * </pre>
   *
   * <code>string client_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clientId.
   */
  com.google.protobuf.ByteString getClientIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1beta1.TrialContext> getContextsList();

  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.TrialContext getContexts(int index);

  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getContextsCount();

  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TrialContextOrBuilder>
      getContextsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. This allows you to specify the "context" for a Trial; a context
   * is a slice (a subspace) of the search space.
   *
   * Typical uses for contexts:
   * 1) You are using Vizier to tune a server for best performance, but there's
   *   a strong weekly cycle.  The context specifies the day-of-week.
   *   This allows Tuesday to generalize from Wednesday without assuming that
   *   everything is identical.
   * 2) Imagine you're optimizing some medical treatment for people.
   *   As they walk in the door, you know certain facts about them
   *   (e.g. sex, weight, height, blood-pressure).  Put that information in the
   *   context, and Vizier will adapt its suggestions to the patient.
   * 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
   *   conditions as contexts, and Vizier will generalize between "A" and "B"
   *   conditions.  If they are similar, this will allow Vizier to converge
   *   to the optimum faster than if "A" and "B" were separate Studies.
   *   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
   *   CreateTrial() RPC; that's the asynchronous option where you don't need a
   *   close association between contexts and suggestions.
   *
   * NOTE: All the Parameters you set in a context MUST be defined in the
   *   Study.
   * NOTE: You must supply 0 or $suggestion_count contexts.
   *   If you don't supply any contexts, Vizier will make suggestions
   *   from the full search space specified in the StudySpec; if you supply
   *   a full set of context, each suggestion will match the corresponding
   *   context.
   * NOTE: A Context with no features set matches anything, and allows
   *   suggestions from the full search space.
   * NOTE: Contexts MUST lie within the search space specified in the
   *   StudySpec.  It's an error if they don't.
   * NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
   *   new suggestions are generated.
   * NOTE: Generation of suggestions involves a match between a Context and
   *   (optionally) a REQUESTED trial; if that match is not fully specified, a
   *   suggestion will be geneated in the merged subspace.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.TrialContext contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.TrialContextOrBuilder getContextsOrBuilder(int index);
}
