/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExampleStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_EXAMPLE_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/exampleStores/{example_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String exampleStore;

    @Deprecated
    protected ExampleStoreName() {
        this.project = null;
        this.location = null;
        this.exampleStore = null;
    }

    private ExampleStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.exampleStore = (String)Preconditions.checkNotNull((Object)builder.getExampleStore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExampleStore() {
        return this.exampleStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExampleStoreName of(String project, String location, String exampleStore) {
        return ExampleStoreName.newBuilder().setProject(project).setLocation(location).setExampleStore(exampleStore).build();
    }

    public static String format(String project, String location, String exampleStore) {
        return ExampleStoreName.newBuilder().setProject(project).setLocation(location).setExampleStore(exampleStore).build().toString();
    }

    public static ExampleStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_EXAMPLE_STORE.validatedMatch(formattedString, "ExampleStoreName.parse: formattedString not in valid format");
        return ExampleStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("example_store"));
    }

    public static List<ExampleStoreName> parseList(List<String> formattedStrings) {
        ArrayList<ExampleStoreName> list = new ArrayList<ExampleStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExampleStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExampleStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExampleStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_EXAMPLE_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExampleStoreName exampleStoreName = this;
            synchronized (exampleStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.exampleStore != null) {
                        fieldMapBuilder.put((Object)"example_store", (Object)this.exampleStore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_EXAMPLE_STORE.instantiate(new String[]{"project", this.project, "location", this.location, "example_store", this.exampleStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExampleStoreName that = (ExampleStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.exampleStore, that.exampleStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.exampleStore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String exampleStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExampleStore() {
            return this.exampleStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setExampleStore(String exampleStore) {
            this.exampleStore = exampleStore;
            return this;
        }

        private Builder(ExampleStoreName exampleStoreName) {
            this.project = exampleStoreName.project;
            this.location = exampleStoreName.location;
            this.exampleStore = exampleStoreName.exampleStore;
        }

        public ExampleStoreName build() {
            return new ExampleStoreName(this);
        }
    }
}

