/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GatewayName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GATEWAY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/gateways/{gateway}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String gateway;

    @Deprecated
    protected GatewayName() {
        this.project = null;
        this.location = null;
        this.gateway = null;
    }

    private GatewayName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.gateway = (String)Preconditions.checkNotNull((Object)builder.getGateway());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGateway() {
        return this.gateway;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GatewayName of(String project, String location, String gateway) {
        return GatewayName.newBuilder().setProject(project).setLocation(location).setGateway(gateway).build();
    }

    public static String format(String project, String location, String gateway) {
        return GatewayName.newBuilder().setProject(project).setLocation(location).setGateway(gateway).build().toString();
    }

    public static GatewayName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GATEWAY.validatedMatch(formattedString, "GatewayName.parse: formattedString not in valid format");
        return GatewayName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("gateway"));
    }

    public static List<GatewayName> parseList(List<String> formattedStrings) {
        ArrayList<GatewayName> list = new ArrayList<GatewayName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GatewayName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GatewayName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GatewayName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GATEWAY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GatewayName gatewayName = this;
            synchronized (gatewayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.gateway != null) {
                        fieldMapBuilder.put((Object)"gateway", (Object)this.gateway);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GATEWAY.instantiate(new String[]{"project", this.project, "location", this.location, "gateway", this.gateway});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GatewayName that = (GatewayName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.gateway, that.gateway);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.gateway);
    }

    public static class Builder {
        private String project;
        private String location;
        private String gateway;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGateway() {
            return this.gateway;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        private Builder(GatewayName gatewayName) {
            this.project = gatewayName.project;
            this.location = gatewayName.location;
            this.gateway = gatewayName.gateway;
        }

        public GatewayName build() {
            return new GatewayName(this);
        }
    }
}

