/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/apikeys/v2/apikeys.proto

package com.google.api.apikeys.v2;

public interface CreateKeyRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.api.apikeys.v2.CreateKeyRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The project in which the API key is created.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The project in which the API key is created.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The API key fields to set at creation time.
   * You can configure only the `display_name`, `restrictions`, and
   * `annotations` fields.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.Key key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the key field is set.
   */
  boolean hasKey();
  /**
   *
   *
   * <pre>
   * Required. The API key fields to set at creation time.
   * You can configure only the `display_name`, `restrictions`, and
   * `annotations` fields.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.Key key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The key.
   */
  com.google.api.apikeys.v2.Key getKey();
  /**
   *
   *
   * <pre>
   * Required. The API key fields to set at creation time.
   * You can configure only the `display_name`, `restrictions`, and
   * `annotations` fields.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.Key key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  com.google.api.apikeys.v2.KeyOrBuilder getKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * User specified key id (optional). If specified, it will become the final
   * component of the key resource name.
   *
   * The id must be unique within the project, must conform with RFC-1034,
   * is restricted to lower-cased letters, and has a maximum length of 63
   * characters. In another word, the id must match the regular
   * expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   *
   * The id must NOT be a UUID-like string.
   * </pre>
   *
   * <code>string key_id = 3;</code>
   *
   * @return The keyId.
   */
  java.lang.String getKeyId();
  /**
   *
   *
   * <pre>
   * User specified key id (optional). If specified, it will become the final
   * component of the key resource name.
   *
   * The id must be unique within the project, must conform with RFC-1034,
   * is restricted to lower-cased letters, and has a maximum length of 63
   * characters. In another word, the id must match the regular
   * expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   *
   * The id must NOT be a UUID-like string.
   * </pre>
   *
   * <code>string key_id = 3;</code>
   *
   * @return The bytes for keyId.
   */
  com.google.protobuf.ByteString getKeyIdBytes();
}
