/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/apikeys/v2/resources.proto

package com.google.api.apikeys.v2;

/**
 *
 *
 * <pre>
 * Describes the restrictions on the key.
 * </pre>
 *
 * Protobuf type {@code google.api.apikeys.v2.Restrictions}
 */
public final class Restrictions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.apikeys.v2.Restrictions)
    RestrictionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Restrictions.newBuilder() to construct.
  private Restrictions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Restrictions() {
    apiTargets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Restrictions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.apikeys.v2.ResourcesProto
        .internal_static_google_api_apikeys_v2_Restrictions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.apikeys.v2.ResourcesProto
        .internal_static_google_api_apikeys_v2_Restrictions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.apikeys.v2.Restrictions.class,
            com.google.api.apikeys.v2.Restrictions.Builder.class);
  }

  private int clientRestrictionsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object clientRestrictions_;

  public enum ClientRestrictionsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BROWSER_KEY_RESTRICTIONS(1),
    SERVER_KEY_RESTRICTIONS(2),
    ANDROID_KEY_RESTRICTIONS(3),
    IOS_KEY_RESTRICTIONS(4),
    CLIENTRESTRICTIONS_NOT_SET(0);
    private final int value;

    private ClientRestrictionsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClientRestrictionsCase valueOf(int value) {
      return forNumber(value);
    }

    public static ClientRestrictionsCase forNumber(int value) {
      switch (value) {
        case 1:
          return BROWSER_KEY_RESTRICTIONS;
        case 2:
          return SERVER_KEY_RESTRICTIONS;
        case 3:
          return ANDROID_KEY_RESTRICTIONS;
        case 4:
          return IOS_KEY_RESTRICTIONS;
        case 0:
          return CLIENTRESTRICTIONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ClientRestrictionsCase getClientRestrictionsCase() {
    return ClientRestrictionsCase.forNumber(clientRestrictionsCase_);
  }

  public static final int BROWSER_KEY_RESTRICTIONS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The HTTP referrers (websites) that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
   *
   * @return Whether the browserKeyRestrictions field is set.
   */
  @java.lang.Override
  public boolean hasBrowserKeyRestrictions() {
    return clientRestrictionsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The HTTP referrers (websites) that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
   *
   * @return The browserKeyRestrictions.
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.BrowserKeyRestrictions getBrowserKeyRestrictions() {
    if (clientRestrictionsCase_ == 1) {
      return (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The HTTP referrers (websites) that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.BrowserKeyRestrictionsOrBuilder
      getBrowserKeyRestrictionsOrBuilder() {
    if (clientRestrictionsCase_ == 1) {
      return (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance();
  }

  public static final int SERVER_KEY_RESTRICTIONS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The IP addresses of callers that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
   *
   * @return Whether the serverKeyRestrictions field is set.
   */
  @java.lang.Override
  public boolean hasServerKeyRestrictions() {
    return clientRestrictionsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The IP addresses of callers that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
   *
   * @return The serverKeyRestrictions.
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.ServerKeyRestrictions getServerKeyRestrictions() {
    if (clientRestrictionsCase_ == 2) {
      return (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The IP addresses of callers that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.ServerKeyRestrictionsOrBuilder
      getServerKeyRestrictionsOrBuilder() {
    if (clientRestrictionsCase_ == 2) {
      return (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance();
  }

  public static final int ANDROID_KEY_RESTRICTIONS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The Android apps that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
   *
   * @return Whether the androidKeyRestrictions field is set.
   */
  @java.lang.Override
  public boolean hasAndroidKeyRestrictions() {
    return clientRestrictionsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The Android apps that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
   *
   * @return The androidKeyRestrictions.
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.AndroidKeyRestrictions getAndroidKeyRestrictions() {
    if (clientRestrictionsCase_ == 3) {
      return (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Android apps that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.AndroidKeyRestrictionsOrBuilder
      getAndroidKeyRestrictionsOrBuilder() {
    if (clientRestrictionsCase_ == 3) {
      return (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance();
  }

  public static final int IOS_KEY_RESTRICTIONS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The iOS apps that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
   *
   * @return Whether the iosKeyRestrictions field is set.
   */
  @java.lang.Override
  public boolean hasIosKeyRestrictions() {
    return clientRestrictionsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The iOS apps that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
   *
   * @return The iosKeyRestrictions.
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.IosKeyRestrictions getIosKeyRestrictions() {
    if (clientRestrictionsCase_ == 4) {
      return (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The iOS apps that are allowed to use the key.
   * </pre>
   *
   * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.IosKeyRestrictionsOrBuilder getIosKeyRestrictionsOrBuilder() {
    if (clientRestrictionsCase_ == 4) {
      return (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_;
    }
    return com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance();
  }

  public static final int API_TARGETS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.apikeys.v2.ApiTarget> apiTargets_;
  /**
   *
   *
   * <pre>
   * A restriction for a specific service and optionally one or
   * more specific methods. Requests are allowed if they
   * match any of these restrictions. If no restrictions are
   * specified, all targets are allowed.
   * </pre>
   *
   * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.apikeys.v2.ApiTarget> getApiTargetsList() {
    return apiTargets_;
  }
  /**
   *
   *
   * <pre>
   * A restriction for a specific service and optionally one or
   * more specific methods. Requests are allowed if they
   * match any of these restrictions. If no restrictions are
   * specified, all targets are allowed.
   * </pre>
   *
   * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.apikeys.v2.ApiTargetOrBuilder>
      getApiTargetsOrBuilderList() {
    return apiTargets_;
  }
  /**
   *
   *
   * <pre>
   * A restriction for a specific service and optionally one or
   * more specific methods. Requests are allowed if they
   * match any of these restrictions. If no restrictions are
   * specified, all targets are allowed.
   * </pre>
   *
   * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
   */
  @java.lang.Override
  public int getApiTargetsCount() {
    return apiTargets_.size();
  }
  /**
   *
   *
   * <pre>
   * A restriction for a specific service and optionally one or
   * more specific methods. Requests are allowed if they
   * match any of these restrictions. If no restrictions are
   * specified, all targets are allowed.
   * </pre>
   *
   * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.ApiTarget getApiTargets(int index) {
    return apiTargets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A restriction for a specific service and optionally one or
   * more specific methods. Requests are allowed if they
   * match any of these restrictions. If no restrictions are
   * specified, all targets are allowed.
   * </pre>
   *
   * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
   */
  @java.lang.Override
  public com.google.api.apikeys.v2.ApiTargetOrBuilder getApiTargetsOrBuilder(int index) {
    return apiTargets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (clientRestrictionsCase_ == 1) {
      output.writeMessage(
          1, (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_);
    }
    if (clientRestrictionsCase_ == 2) {
      output.writeMessage(2, (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_);
    }
    if (clientRestrictionsCase_ == 3) {
      output.writeMessage(
          3, (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_);
    }
    if (clientRestrictionsCase_ == 4) {
      output.writeMessage(4, (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_);
    }
    for (int i = 0; i < apiTargets_.size(); i++) {
      output.writeMessage(5, apiTargets_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (clientRestrictionsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_);
    }
    if (clientRestrictionsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_);
    }
    if (clientRestrictionsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_);
    }
    if (clientRestrictionsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_);
    }
    for (int i = 0; i < apiTargets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, apiTargets_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.apikeys.v2.Restrictions)) {
      return super.equals(obj);
    }
    com.google.api.apikeys.v2.Restrictions other = (com.google.api.apikeys.v2.Restrictions) obj;

    if (!getApiTargetsList().equals(other.getApiTargetsList())) return false;
    if (!getClientRestrictionsCase().equals(other.getClientRestrictionsCase())) return false;
    switch (clientRestrictionsCase_) {
      case 1:
        if (!getBrowserKeyRestrictions().equals(other.getBrowserKeyRestrictions())) return false;
        break;
      case 2:
        if (!getServerKeyRestrictions().equals(other.getServerKeyRestrictions())) return false;
        break;
      case 3:
        if (!getAndroidKeyRestrictions().equals(other.getAndroidKeyRestrictions())) return false;
        break;
      case 4:
        if (!getIosKeyRestrictions().equals(other.getIosKeyRestrictions())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getApiTargetsCount() > 0) {
      hash = (37 * hash) + API_TARGETS_FIELD_NUMBER;
      hash = (53 * hash) + getApiTargetsList().hashCode();
    }
    switch (clientRestrictionsCase_) {
      case 1:
        hash = (37 * hash) + BROWSER_KEY_RESTRICTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getBrowserKeyRestrictions().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SERVER_KEY_RESTRICTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getServerKeyRestrictions().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ANDROID_KEY_RESTRICTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAndroidKeyRestrictions().hashCode();
        break;
      case 4:
        hash = (37 * hash) + IOS_KEY_RESTRICTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getIosKeyRestrictions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.Restrictions parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.apikeys.v2.Restrictions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.apikeys.v2.Restrictions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.apikeys.v2.Restrictions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the restrictions on the key.
   * </pre>
   *
   * Protobuf type {@code google.api.apikeys.v2.Restrictions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.apikeys.v2.Restrictions)
      com.google.api.apikeys.v2.RestrictionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.apikeys.v2.ResourcesProto
          .internal_static_google_api_apikeys_v2_Restrictions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.apikeys.v2.ResourcesProto
          .internal_static_google_api_apikeys_v2_Restrictions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.apikeys.v2.Restrictions.class,
              com.google.api.apikeys.v2.Restrictions.Builder.class);
    }

    // Construct using com.google.api.apikeys.v2.Restrictions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (browserKeyRestrictionsBuilder_ != null) {
        browserKeyRestrictionsBuilder_.clear();
      }
      if (serverKeyRestrictionsBuilder_ != null) {
        serverKeyRestrictionsBuilder_.clear();
      }
      if (androidKeyRestrictionsBuilder_ != null) {
        androidKeyRestrictionsBuilder_.clear();
      }
      if (iosKeyRestrictionsBuilder_ != null) {
        iosKeyRestrictionsBuilder_.clear();
      }
      if (apiTargetsBuilder_ == null) {
        apiTargets_ = java.util.Collections.emptyList();
      } else {
        apiTargets_ = null;
        apiTargetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      clientRestrictionsCase_ = 0;
      clientRestrictions_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.apikeys.v2.ResourcesProto
          .internal_static_google_api_apikeys_v2_Restrictions_descriptor;
    }

    @java.lang.Override
    public com.google.api.apikeys.v2.Restrictions getDefaultInstanceForType() {
      return com.google.api.apikeys.v2.Restrictions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.apikeys.v2.Restrictions build() {
      com.google.api.apikeys.v2.Restrictions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.apikeys.v2.Restrictions buildPartial() {
      com.google.api.apikeys.v2.Restrictions result =
          new com.google.api.apikeys.v2.Restrictions(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.apikeys.v2.Restrictions result) {
      if (apiTargetsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          apiTargets_ = java.util.Collections.unmodifiableList(apiTargets_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.apiTargets_ = apiTargets_;
      } else {
        result.apiTargets_ = apiTargetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.apikeys.v2.Restrictions result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.api.apikeys.v2.Restrictions result) {
      result.clientRestrictionsCase_ = clientRestrictionsCase_;
      result.clientRestrictions_ = this.clientRestrictions_;
      if (clientRestrictionsCase_ == 1 && browserKeyRestrictionsBuilder_ != null) {
        result.clientRestrictions_ = browserKeyRestrictionsBuilder_.build();
      }
      if (clientRestrictionsCase_ == 2 && serverKeyRestrictionsBuilder_ != null) {
        result.clientRestrictions_ = serverKeyRestrictionsBuilder_.build();
      }
      if (clientRestrictionsCase_ == 3 && androidKeyRestrictionsBuilder_ != null) {
        result.clientRestrictions_ = androidKeyRestrictionsBuilder_.build();
      }
      if (clientRestrictionsCase_ == 4 && iosKeyRestrictionsBuilder_ != null) {
        result.clientRestrictions_ = iosKeyRestrictionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.apikeys.v2.Restrictions) {
        return mergeFrom((com.google.api.apikeys.v2.Restrictions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.apikeys.v2.Restrictions other) {
      if (other == com.google.api.apikeys.v2.Restrictions.getDefaultInstance()) return this;
      if (apiTargetsBuilder_ == null) {
        if (!other.apiTargets_.isEmpty()) {
          if (apiTargets_.isEmpty()) {
            apiTargets_ = other.apiTargets_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureApiTargetsIsMutable();
            apiTargets_.addAll(other.apiTargets_);
          }
          onChanged();
        }
      } else {
        if (!other.apiTargets_.isEmpty()) {
          if (apiTargetsBuilder_.isEmpty()) {
            apiTargetsBuilder_.dispose();
            apiTargetsBuilder_ = null;
            apiTargets_ = other.apiTargets_;
            bitField0_ = (bitField0_ & ~0x00000010);
            apiTargetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getApiTargetsFieldBuilder()
                    : null;
          } else {
            apiTargetsBuilder_.addAllMessages(other.apiTargets_);
          }
        }
      }
      switch (other.getClientRestrictionsCase()) {
        case BROWSER_KEY_RESTRICTIONS:
          {
            mergeBrowserKeyRestrictions(other.getBrowserKeyRestrictions());
            break;
          }
        case SERVER_KEY_RESTRICTIONS:
          {
            mergeServerKeyRestrictions(other.getServerKeyRestrictions());
            break;
          }
        case ANDROID_KEY_RESTRICTIONS:
          {
            mergeAndroidKeyRestrictions(other.getAndroidKeyRestrictions());
            break;
          }
        case IOS_KEY_RESTRICTIONS:
          {
            mergeIosKeyRestrictions(other.getIosKeyRestrictions());
            break;
          }
        case CLIENTRESTRICTIONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getBrowserKeyRestrictionsFieldBuilder().getBuilder(), extensionRegistry);
                clientRestrictionsCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getServerKeyRestrictionsFieldBuilder().getBuilder(), extensionRegistry);
                clientRestrictionsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAndroidKeyRestrictionsFieldBuilder().getBuilder(), extensionRegistry);
                clientRestrictionsCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getIosKeyRestrictionsFieldBuilder().getBuilder(), extensionRegistry);
                clientRestrictionsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                com.google.api.apikeys.v2.ApiTarget m =
                    input.readMessage(
                        com.google.api.apikeys.v2.ApiTarget.parser(), extensionRegistry);
                if (apiTargetsBuilder_ == null) {
                  ensureApiTargetsIsMutable();
                  apiTargets_.add(m);
                } else {
                  apiTargetsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int clientRestrictionsCase_ = 0;
    private java.lang.Object clientRestrictions_;

    public ClientRestrictionsCase getClientRestrictionsCase() {
      return ClientRestrictionsCase.forNumber(clientRestrictionsCase_);
    }

    public Builder clearClientRestrictions() {
      clientRestrictionsCase_ = 0;
      clientRestrictions_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.BrowserKeyRestrictions,
            com.google.api.apikeys.v2.BrowserKeyRestrictions.Builder,
            com.google.api.apikeys.v2.BrowserKeyRestrictionsOrBuilder>
        browserKeyRestrictionsBuilder_;
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     *
     * @return Whether the browserKeyRestrictions field is set.
     */
    @java.lang.Override
    public boolean hasBrowserKeyRestrictions() {
      return clientRestrictionsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     *
     * @return The browserKeyRestrictions.
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.BrowserKeyRestrictions getBrowserKeyRestrictions() {
      if (browserKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 1) {
          return (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance();
      } else {
        if (clientRestrictionsCase_ == 1) {
          return browserKeyRestrictionsBuilder_.getMessage();
        }
        return com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    public Builder setBrowserKeyRestrictions(
        com.google.api.apikeys.v2.BrowserKeyRestrictions value) {
      if (browserKeyRestrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientRestrictions_ = value;
        onChanged();
      } else {
        browserKeyRestrictionsBuilder_.setMessage(value);
      }
      clientRestrictionsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    public Builder setBrowserKeyRestrictions(
        com.google.api.apikeys.v2.BrowserKeyRestrictions.Builder builderForValue) {
      if (browserKeyRestrictionsBuilder_ == null) {
        clientRestrictions_ = builderForValue.build();
        onChanged();
      } else {
        browserKeyRestrictionsBuilder_.setMessage(builderForValue.build());
      }
      clientRestrictionsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    public Builder mergeBrowserKeyRestrictions(
        com.google.api.apikeys.v2.BrowserKeyRestrictions value) {
      if (browserKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 1
            && clientRestrictions_
                != com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance()) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.BrowserKeyRestrictions.newBuilder(
                      (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          clientRestrictions_ = value;
        }
        onChanged();
      } else {
        if (clientRestrictionsCase_ == 1) {
          browserKeyRestrictionsBuilder_.mergeFrom(value);
        } else {
          browserKeyRestrictionsBuilder_.setMessage(value);
        }
      }
      clientRestrictionsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    public Builder clearBrowserKeyRestrictions() {
      if (browserKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 1) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
          onChanged();
        }
      } else {
        if (clientRestrictionsCase_ == 1) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
        }
        browserKeyRestrictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    public com.google.api.apikeys.v2.BrowserKeyRestrictions.Builder
        getBrowserKeyRestrictionsBuilder() {
      return getBrowserKeyRestrictionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.BrowserKeyRestrictionsOrBuilder
        getBrowserKeyRestrictionsOrBuilder() {
      if ((clientRestrictionsCase_ == 1) && (browserKeyRestrictionsBuilder_ != null)) {
        return browserKeyRestrictionsBuilder_.getMessageOrBuilder();
      } else {
        if (clientRestrictionsCase_ == 1) {
          return (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP referrers (websites) that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.BrowserKeyRestrictions browser_key_restrictions = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.BrowserKeyRestrictions,
            com.google.api.apikeys.v2.BrowserKeyRestrictions.Builder,
            com.google.api.apikeys.v2.BrowserKeyRestrictionsOrBuilder>
        getBrowserKeyRestrictionsFieldBuilder() {
      if (browserKeyRestrictionsBuilder_ == null) {
        if (!(clientRestrictionsCase_ == 1)) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.BrowserKeyRestrictions.getDefaultInstance();
        }
        browserKeyRestrictionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.apikeys.v2.BrowserKeyRestrictions,
                com.google.api.apikeys.v2.BrowserKeyRestrictions.Builder,
                com.google.api.apikeys.v2.BrowserKeyRestrictionsOrBuilder>(
                (com.google.api.apikeys.v2.BrowserKeyRestrictions) clientRestrictions_,
                getParentForChildren(),
                isClean());
        clientRestrictions_ = null;
      }
      clientRestrictionsCase_ = 1;
      onChanged();
      return browserKeyRestrictionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.ServerKeyRestrictions,
            com.google.api.apikeys.v2.ServerKeyRestrictions.Builder,
            com.google.api.apikeys.v2.ServerKeyRestrictionsOrBuilder>
        serverKeyRestrictionsBuilder_;
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     *
     * @return Whether the serverKeyRestrictions field is set.
     */
    @java.lang.Override
    public boolean hasServerKeyRestrictions() {
      return clientRestrictionsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     *
     * @return The serverKeyRestrictions.
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.ServerKeyRestrictions getServerKeyRestrictions() {
      if (serverKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 2) {
          return (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance();
      } else {
        if (clientRestrictionsCase_ == 2) {
          return serverKeyRestrictionsBuilder_.getMessage();
        }
        return com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    public Builder setServerKeyRestrictions(com.google.api.apikeys.v2.ServerKeyRestrictions value) {
      if (serverKeyRestrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientRestrictions_ = value;
        onChanged();
      } else {
        serverKeyRestrictionsBuilder_.setMessage(value);
      }
      clientRestrictionsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    public Builder setServerKeyRestrictions(
        com.google.api.apikeys.v2.ServerKeyRestrictions.Builder builderForValue) {
      if (serverKeyRestrictionsBuilder_ == null) {
        clientRestrictions_ = builderForValue.build();
        onChanged();
      } else {
        serverKeyRestrictionsBuilder_.setMessage(builderForValue.build());
      }
      clientRestrictionsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    public Builder mergeServerKeyRestrictions(
        com.google.api.apikeys.v2.ServerKeyRestrictions value) {
      if (serverKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 2
            && clientRestrictions_
                != com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance()) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.ServerKeyRestrictions.newBuilder(
                      (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          clientRestrictions_ = value;
        }
        onChanged();
      } else {
        if (clientRestrictionsCase_ == 2) {
          serverKeyRestrictionsBuilder_.mergeFrom(value);
        } else {
          serverKeyRestrictionsBuilder_.setMessage(value);
        }
      }
      clientRestrictionsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    public Builder clearServerKeyRestrictions() {
      if (serverKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 2) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
          onChanged();
        }
      } else {
        if (clientRestrictionsCase_ == 2) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
        }
        serverKeyRestrictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    public com.google.api.apikeys.v2.ServerKeyRestrictions.Builder
        getServerKeyRestrictionsBuilder() {
      return getServerKeyRestrictionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.ServerKeyRestrictionsOrBuilder
        getServerKeyRestrictionsOrBuilder() {
      if ((clientRestrictionsCase_ == 2) && (serverKeyRestrictionsBuilder_ != null)) {
        return serverKeyRestrictionsBuilder_.getMessageOrBuilder();
      } else {
        if (clientRestrictionsCase_ == 2) {
          return (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The IP addresses of callers that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.ServerKeyRestrictions server_key_restrictions = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.ServerKeyRestrictions,
            com.google.api.apikeys.v2.ServerKeyRestrictions.Builder,
            com.google.api.apikeys.v2.ServerKeyRestrictionsOrBuilder>
        getServerKeyRestrictionsFieldBuilder() {
      if (serverKeyRestrictionsBuilder_ == null) {
        if (!(clientRestrictionsCase_ == 2)) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.ServerKeyRestrictions.getDefaultInstance();
        }
        serverKeyRestrictionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.apikeys.v2.ServerKeyRestrictions,
                com.google.api.apikeys.v2.ServerKeyRestrictions.Builder,
                com.google.api.apikeys.v2.ServerKeyRestrictionsOrBuilder>(
                (com.google.api.apikeys.v2.ServerKeyRestrictions) clientRestrictions_,
                getParentForChildren(),
                isClean());
        clientRestrictions_ = null;
      }
      clientRestrictionsCase_ = 2;
      onChanged();
      return serverKeyRestrictionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.AndroidKeyRestrictions,
            com.google.api.apikeys.v2.AndroidKeyRestrictions.Builder,
            com.google.api.apikeys.v2.AndroidKeyRestrictionsOrBuilder>
        androidKeyRestrictionsBuilder_;
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     *
     * @return Whether the androidKeyRestrictions field is set.
     */
    @java.lang.Override
    public boolean hasAndroidKeyRestrictions() {
      return clientRestrictionsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     *
     * @return The androidKeyRestrictions.
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.AndroidKeyRestrictions getAndroidKeyRestrictions() {
      if (androidKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 3) {
          return (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance();
      } else {
        if (clientRestrictionsCase_ == 3) {
          return androidKeyRestrictionsBuilder_.getMessage();
        }
        return com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    public Builder setAndroidKeyRestrictions(
        com.google.api.apikeys.v2.AndroidKeyRestrictions value) {
      if (androidKeyRestrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientRestrictions_ = value;
        onChanged();
      } else {
        androidKeyRestrictionsBuilder_.setMessage(value);
      }
      clientRestrictionsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    public Builder setAndroidKeyRestrictions(
        com.google.api.apikeys.v2.AndroidKeyRestrictions.Builder builderForValue) {
      if (androidKeyRestrictionsBuilder_ == null) {
        clientRestrictions_ = builderForValue.build();
        onChanged();
      } else {
        androidKeyRestrictionsBuilder_.setMessage(builderForValue.build());
      }
      clientRestrictionsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    public Builder mergeAndroidKeyRestrictions(
        com.google.api.apikeys.v2.AndroidKeyRestrictions value) {
      if (androidKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 3
            && clientRestrictions_
                != com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance()) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.AndroidKeyRestrictions.newBuilder(
                      (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          clientRestrictions_ = value;
        }
        onChanged();
      } else {
        if (clientRestrictionsCase_ == 3) {
          androidKeyRestrictionsBuilder_.mergeFrom(value);
        } else {
          androidKeyRestrictionsBuilder_.setMessage(value);
        }
      }
      clientRestrictionsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    public Builder clearAndroidKeyRestrictions() {
      if (androidKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 3) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
          onChanged();
        }
      } else {
        if (clientRestrictionsCase_ == 3) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
        }
        androidKeyRestrictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    public com.google.api.apikeys.v2.AndroidKeyRestrictions.Builder
        getAndroidKeyRestrictionsBuilder() {
      return getAndroidKeyRestrictionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.AndroidKeyRestrictionsOrBuilder
        getAndroidKeyRestrictionsOrBuilder() {
      if ((clientRestrictionsCase_ == 3) && (androidKeyRestrictionsBuilder_ != null)) {
        return androidKeyRestrictionsBuilder_.getMessageOrBuilder();
      } else {
        if (clientRestrictionsCase_ == 3) {
          return (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Android apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.AndroidKeyRestrictions android_key_restrictions = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.AndroidKeyRestrictions,
            com.google.api.apikeys.v2.AndroidKeyRestrictions.Builder,
            com.google.api.apikeys.v2.AndroidKeyRestrictionsOrBuilder>
        getAndroidKeyRestrictionsFieldBuilder() {
      if (androidKeyRestrictionsBuilder_ == null) {
        if (!(clientRestrictionsCase_ == 3)) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.AndroidKeyRestrictions.getDefaultInstance();
        }
        androidKeyRestrictionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.apikeys.v2.AndroidKeyRestrictions,
                com.google.api.apikeys.v2.AndroidKeyRestrictions.Builder,
                com.google.api.apikeys.v2.AndroidKeyRestrictionsOrBuilder>(
                (com.google.api.apikeys.v2.AndroidKeyRestrictions) clientRestrictions_,
                getParentForChildren(),
                isClean());
        clientRestrictions_ = null;
      }
      clientRestrictionsCase_ = 3;
      onChanged();
      return androidKeyRestrictionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.IosKeyRestrictions,
            com.google.api.apikeys.v2.IosKeyRestrictions.Builder,
            com.google.api.apikeys.v2.IosKeyRestrictionsOrBuilder>
        iosKeyRestrictionsBuilder_;
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     *
     * @return Whether the iosKeyRestrictions field is set.
     */
    @java.lang.Override
    public boolean hasIosKeyRestrictions() {
      return clientRestrictionsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     *
     * @return The iosKeyRestrictions.
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.IosKeyRestrictions getIosKeyRestrictions() {
      if (iosKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 4) {
          return (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance();
      } else {
        if (clientRestrictionsCase_ == 4) {
          return iosKeyRestrictionsBuilder_.getMessage();
        }
        return com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    public Builder setIosKeyRestrictions(com.google.api.apikeys.v2.IosKeyRestrictions value) {
      if (iosKeyRestrictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientRestrictions_ = value;
        onChanged();
      } else {
        iosKeyRestrictionsBuilder_.setMessage(value);
      }
      clientRestrictionsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    public Builder setIosKeyRestrictions(
        com.google.api.apikeys.v2.IosKeyRestrictions.Builder builderForValue) {
      if (iosKeyRestrictionsBuilder_ == null) {
        clientRestrictions_ = builderForValue.build();
        onChanged();
      } else {
        iosKeyRestrictionsBuilder_.setMessage(builderForValue.build());
      }
      clientRestrictionsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    public Builder mergeIosKeyRestrictions(com.google.api.apikeys.v2.IosKeyRestrictions value) {
      if (iosKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 4
            && clientRestrictions_
                != com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance()) {
          clientRestrictions_ =
              com.google.api.apikeys.v2.IosKeyRestrictions.newBuilder(
                      (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          clientRestrictions_ = value;
        }
        onChanged();
      } else {
        if (clientRestrictionsCase_ == 4) {
          iosKeyRestrictionsBuilder_.mergeFrom(value);
        } else {
          iosKeyRestrictionsBuilder_.setMessage(value);
        }
      }
      clientRestrictionsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    public Builder clearIosKeyRestrictions() {
      if (iosKeyRestrictionsBuilder_ == null) {
        if (clientRestrictionsCase_ == 4) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
          onChanged();
        }
      } else {
        if (clientRestrictionsCase_ == 4) {
          clientRestrictionsCase_ = 0;
          clientRestrictions_ = null;
        }
        iosKeyRestrictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    public com.google.api.apikeys.v2.IosKeyRestrictions.Builder getIosKeyRestrictionsBuilder() {
      return getIosKeyRestrictionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    @java.lang.Override
    public com.google.api.apikeys.v2.IosKeyRestrictionsOrBuilder getIosKeyRestrictionsOrBuilder() {
      if ((clientRestrictionsCase_ == 4) && (iosKeyRestrictionsBuilder_ != null)) {
        return iosKeyRestrictionsBuilder_.getMessageOrBuilder();
      } else {
        if (clientRestrictionsCase_ == 4) {
          return (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_;
        }
        return com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The iOS apps that are allowed to use the key.
     * </pre>
     *
     * <code>.google.api.apikeys.v2.IosKeyRestrictions ios_key_restrictions = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.apikeys.v2.IosKeyRestrictions,
            com.google.api.apikeys.v2.IosKeyRestrictions.Builder,
            com.google.api.apikeys.v2.IosKeyRestrictionsOrBuilder>
        getIosKeyRestrictionsFieldBuilder() {
      if (iosKeyRestrictionsBuilder_ == null) {
        if (!(clientRestrictionsCase_ == 4)) {
          clientRestrictions_ = com.google.api.apikeys.v2.IosKeyRestrictions.getDefaultInstance();
        }
        iosKeyRestrictionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.apikeys.v2.IosKeyRestrictions,
                com.google.api.apikeys.v2.IosKeyRestrictions.Builder,
                com.google.api.apikeys.v2.IosKeyRestrictionsOrBuilder>(
                (com.google.api.apikeys.v2.IosKeyRestrictions) clientRestrictions_,
                getParentForChildren(),
                isClean());
        clientRestrictions_ = null;
      }
      clientRestrictionsCase_ = 4;
      onChanged();
      return iosKeyRestrictionsBuilder_;
    }

    private java.util.List<com.google.api.apikeys.v2.ApiTarget> apiTargets_ =
        java.util.Collections.emptyList();

    private void ensureApiTargetsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        apiTargets_ = new java.util.ArrayList<com.google.api.apikeys.v2.ApiTarget>(apiTargets_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.apikeys.v2.ApiTarget,
            com.google.api.apikeys.v2.ApiTarget.Builder,
            com.google.api.apikeys.v2.ApiTargetOrBuilder>
        apiTargetsBuilder_;

    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public java.util.List<com.google.api.apikeys.v2.ApiTarget> getApiTargetsList() {
      if (apiTargetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(apiTargets_);
      } else {
        return apiTargetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public int getApiTargetsCount() {
      if (apiTargetsBuilder_ == null) {
        return apiTargets_.size();
      } else {
        return apiTargetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public com.google.api.apikeys.v2.ApiTarget getApiTargets(int index) {
      if (apiTargetsBuilder_ == null) {
        return apiTargets_.get(index);
      } else {
        return apiTargetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder setApiTargets(int index, com.google.api.apikeys.v2.ApiTarget value) {
      if (apiTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApiTargetsIsMutable();
        apiTargets_.set(index, value);
        onChanged();
      } else {
        apiTargetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder setApiTargets(
        int index, com.google.api.apikeys.v2.ApiTarget.Builder builderForValue) {
      if (apiTargetsBuilder_ == null) {
        ensureApiTargetsIsMutable();
        apiTargets_.set(index, builderForValue.build());
        onChanged();
      } else {
        apiTargetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder addApiTargets(com.google.api.apikeys.v2.ApiTarget value) {
      if (apiTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApiTargetsIsMutable();
        apiTargets_.add(value);
        onChanged();
      } else {
        apiTargetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder addApiTargets(int index, com.google.api.apikeys.v2.ApiTarget value) {
      if (apiTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApiTargetsIsMutable();
        apiTargets_.add(index, value);
        onChanged();
      } else {
        apiTargetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder addApiTargets(com.google.api.apikeys.v2.ApiTarget.Builder builderForValue) {
      if (apiTargetsBuilder_ == null) {
        ensureApiTargetsIsMutable();
        apiTargets_.add(builderForValue.build());
        onChanged();
      } else {
        apiTargetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder addApiTargets(
        int index, com.google.api.apikeys.v2.ApiTarget.Builder builderForValue) {
      if (apiTargetsBuilder_ == null) {
        ensureApiTargetsIsMutable();
        apiTargets_.add(index, builderForValue.build());
        onChanged();
      } else {
        apiTargetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder addAllApiTargets(
        java.lang.Iterable<? extends com.google.api.apikeys.v2.ApiTarget> values) {
      if (apiTargetsBuilder_ == null) {
        ensureApiTargetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, apiTargets_);
        onChanged();
      } else {
        apiTargetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder clearApiTargets() {
      if (apiTargetsBuilder_ == null) {
        apiTargets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        apiTargetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public Builder removeApiTargets(int index) {
      if (apiTargetsBuilder_ == null) {
        ensureApiTargetsIsMutable();
        apiTargets_.remove(index);
        onChanged();
      } else {
        apiTargetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public com.google.api.apikeys.v2.ApiTarget.Builder getApiTargetsBuilder(int index) {
      return getApiTargetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public com.google.api.apikeys.v2.ApiTargetOrBuilder getApiTargetsOrBuilder(int index) {
      if (apiTargetsBuilder_ == null) {
        return apiTargets_.get(index);
      } else {
        return apiTargetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public java.util.List<? extends com.google.api.apikeys.v2.ApiTargetOrBuilder>
        getApiTargetsOrBuilderList() {
      if (apiTargetsBuilder_ != null) {
        return apiTargetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(apiTargets_);
      }
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public com.google.api.apikeys.v2.ApiTarget.Builder addApiTargetsBuilder() {
      return getApiTargetsFieldBuilder()
          .addBuilder(com.google.api.apikeys.v2.ApiTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public com.google.api.apikeys.v2.ApiTarget.Builder addApiTargetsBuilder(int index) {
      return getApiTargetsFieldBuilder()
          .addBuilder(index, com.google.api.apikeys.v2.ApiTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A restriction for a specific service and optionally one or
     * more specific methods. Requests are allowed if they
     * match any of these restrictions. If no restrictions are
     * specified, all targets are allowed.
     * </pre>
     *
     * <code>repeated .google.api.apikeys.v2.ApiTarget api_targets = 5;</code>
     */
    public java.util.List<com.google.api.apikeys.v2.ApiTarget.Builder> getApiTargetsBuilderList() {
      return getApiTargetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.apikeys.v2.ApiTarget,
            com.google.api.apikeys.v2.ApiTarget.Builder,
            com.google.api.apikeys.v2.ApiTargetOrBuilder>
        getApiTargetsFieldBuilder() {
      if (apiTargetsBuilder_ == null) {
        apiTargetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.apikeys.v2.ApiTarget,
                com.google.api.apikeys.v2.ApiTarget.Builder,
                com.google.api.apikeys.v2.ApiTargetOrBuilder>(
                apiTargets_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        apiTargets_ = null;
      }
      return apiTargetsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.apikeys.v2.Restrictions)
  }

  // @@protoc_insertion_point(class_scope:google.api.apikeys.v2.Restrictions)
  private static final com.google.api.apikeys.v2.Restrictions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.apikeys.v2.Restrictions();
  }

  public static com.google.api.apikeys.v2.Restrictions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Restrictions> PARSER =
      new com.google.protobuf.AbstractParser<Restrictions>() {
        @java.lang.Override
        public Restrictions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Restrictions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Restrictions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.apikeys.v2.Restrictions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
