/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/apikeys/v2/resources.proto

// Protobuf Java Version: 3.25.3
package com.google.api.apikeys.v2;

/**
 *
 *
 * <pre>
 * A restriction for a specific service and optionally one or multiple
 * specific methods. Both fields are case insensitive.
 * </pre>
 *
 * Protobuf type {@code google.api.apikeys.v2.ApiTarget}
 */
public final class ApiTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.apikeys.v2.ApiTarget)
    ApiTargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ApiTarget.newBuilder() to construct.
  private ApiTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ApiTarget() {
    service_ = "";
    methods_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ApiTarget();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.apikeys.v2.ResourcesProto
        .internal_static_google_api_apikeys_v2_ApiTarget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.apikeys.v2.ResourcesProto
        .internal_static_google_api_apikeys_v2_ApiTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.apikeys.v2.ApiTarget.class,
            com.google.api.apikeys.v2.ApiTarget.Builder.class);
  }

  public static final int SERVICE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * The service for this restriction. It should be the canonical
   * service name, for example: `translate.googleapis.com`.
   * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
   * to get a list of services that are enabled in the project.
   * </pre>
   *
   * <code>string service = 1;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service for this restriction. It should be the canonical
   * service name, for example: `translate.googleapis.com`.
   * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
   * to get a list of services that are enabled in the project.
   * </pre>
   *
   * <code>string service = 1;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METHODS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList methods_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. List of one or more methods that can be called.
   * If empty, all methods for the service are allowed. A wildcard
   * (*) can be used as the last symbol.
   * Valid examples:
   *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
   *   `TranslateText`
   *   `Get*`
   *   `translate.googleapis.com.Get*`
   * </pre>
   *
   * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the methods.
   */
  public com.google.protobuf.ProtocolStringList getMethodsList() {
    return methods_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of one or more methods that can be called.
   * If empty, all methods for the service are allowed. A wildcard
   * (*) can be used as the last symbol.
   * Valid examples:
   *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
   *   `TranslateText`
   *   `Get*`
   *   `translate.googleapis.com.Get*`
   * </pre>
   *
   * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of methods.
   */
  public int getMethodsCount() {
    return methods_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of one or more methods that can be called.
   * If empty, all methods for the service are allowed. A wildcard
   * (*) can be used as the last symbol.
   * Valid examples:
   *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
   *   `TranslateText`
   *   `Get*`
   *   `translate.googleapis.com.Get*`
   * </pre>
   *
   * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The methods at the given index.
   */
  public java.lang.String getMethods(int index) {
    return methods_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of one or more methods that can be called.
   * If empty, all methods for the service are allowed. A wildcard
   * (*) can be used as the last symbol.
   * Valid examples:
   *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
   *   `TranslateText`
   *   `Get*`
   *   `translate.googleapis.com.Get*`
   * </pre>
   *
   * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the methods at the given index.
   */
  public com.google.protobuf.ByteString getMethodsBytes(int index) {
    return methods_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    for (int i = 0; i < methods_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, methods_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < methods_.size(); i++) {
        dataSize += computeStringSizeNoTag(methods_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMethodsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.apikeys.v2.ApiTarget)) {
      return super.equals(obj);
    }
    com.google.api.apikeys.v2.ApiTarget other = (com.google.api.apikeys.v2.ApiTarget) obj;

    if (!getService().equals(other.getService())) return false;
    if (!getMethodsList().equals(other.getMethodsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    if (getMethodsCount() > 0) {
      hash = (37 * hash) + METHODS_FIELD_NUMBER;
      hash = (53 * hash) + getMethodsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.apikeys.v2.ApiTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.apikeys.v2.ApiTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A restriction for a specific service and optionally one or multiple
   * specific methods. Both fields are case insensitive.
   * </pre>
   *
   * Protobuf type {@code google.api.apikeys.v2.ApiTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.apikeys.v2.ApiTarget)
      com.google.api.apikeys.v2.ApiTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.apikeys.v2.ResourcesProto
          .internal_static_google_api_apikeys_v2_ApiTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.apikeys.v2.ResourcesProto
          .internal_static_google_api_apikeys_v2_ApiTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.apikeys.v2.ApiTarget.class,
              com.google.api.apikeys.v2.ApiTarget.Builder.class);
    }

    // Construct using com.google.api.apikeys.v2.ApiTarget.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      service_ = "";
      methods_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.apikeys.v2.ResourcesProto
          .internal_static_google_api_apikeys_v2_ApiTarget_descriptor;
    }

    @java.lang.Override
    public com.google.api.apikeys.v2.ApiTarget getDefaultInstanceForType() {
      return com.google.api.apikeys.v2.ApiTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.apikeys.v2.ApiTarget build() {
      com.google.api.apikeys.v2.ApiTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.apikeys.v2.ApiTarget buildPartial() {
      com.google.api.apikeys.v2.ApiTarget result = new com.google.api.apikeys.v2.ApiTarget(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.apikeys.v2.ApiTarget result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        methods_.makeImmutable();
        result.methods_ = methods_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.apikeys.v2.ApiTarget) {
        return mergeFrom((com.google.api.apikeys.v2.ApiTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.apikeys.v2.ApiTarget other) {
      if (other == com.google.api.apikeys.v2.ApiTarget.getDefaultInstance()) return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.methods_.isEmpty()) {
        if (methods_.isEmpty()) {
          methods_ = other.methods_;
          bitField0_ |= 0x00000002;
        } else {
          ensureMethodsIsMutable();
          methods_.addAll(other.methods_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMethodsIsMutable();
                methods_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * The service for this restriction. It should be the canonical
     * service name, for example: `translate.googleapis.com`.
     * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
     * to get a list of services that are enabled in the project.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service for this restriction. It should be the canonical
     * service name, for example: `translate.googleapis.com`.
     * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
     * to get a list of services that are enabled in the project.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service for this restriction. It should be the canonical
     * service name, for example: `translate.googleapis.com`.
     * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
     * to get a list of services that are enabled in the project.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service for this restriction. It should be the canonical
     * service name, for example: `translate.googleapis.com`.
     * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
     * to get a list of services that are enabled in the project.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service for this restriction. It should be the canonical
     * service name, for example: `translate.googleapis.com`.
     * You can use [`gcloud services list`](/sdk/gcloud/reference/services/list)
     * to get a list of services that are enabled in the project.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList methods_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMethodsIsMutable() {
      if (!methods_.isModifiable()) {
        methods_ = new com.google.protobuf.LazyStringArrayList(methods_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the methods.
     */
    public com.google.protobuf.ProtocolStringList getMethodsList() {
      methods_.makeImmutable();
      return methods_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of methods.
     */
    public int getMethodsCount() {
      return methods_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The methods at the given index.
     */
    public java.lang.String getMethods(int index) {
      return methods_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the methods at the given index.
     */
    public com.google.protobuf.ByteString getMethodsBytes(int index) {
      return methods_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The methods to set.
     * @return This builder for chaining.
     */
    public Builder setMethods(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMethodsIsMutable();
      methods_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The methods to add.
     * @return This builder for chaining.
     */
    public Builder addMethods(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMethodsIsMutable();
      methods_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The methods to add.
     * @return This builder for chaining.
     */
    public Builder addAllMethods(java.lang.Iterable<java.lang.String> values) {
      ensureMethodsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, methods_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMethods() {
      methods_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of one or more methods that can be called.
     * If empty, all methods for the service are allowed. A wildcard
     * (*) can be used as the last symbol.
     * Valid examples:
     *   `google.cloud.translate.v2.TranslateService.GetSupportedLanguage`
     *   `TranslateText`
     *   `Get*`
     *   `translate.googleapis.com.Get*`
     * </pre>
     *
     * <code>repeated string methods = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the methods to add.
     * @return This builder for chaining.
     */
    public Builder addMethodsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMethodsIsMutable();
      methods_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.apikeys.v2.ApiTarget)
  }

  // @@protoc_insertion_point(class_scope:google.api.apikeys.v2.ApiTarget)
  private static final com.google.api.apikeys.v2.ApiTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.apikeys.v2.ApiTarget();
  }

  public static com.google.api.apikeys.v2.ApiTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ApiTarget> PARSER =
      new com.google.protobuf.AbstractParser<ApiTarget>() {
        @java.lang.Override
        public ApiTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ApiTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ApiTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.apikeys.v2.ApiTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
