/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NpmPackageName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_NPM_PACKAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/npmPackages/{npm_package}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String npmPackage;

    @Deprecated
    protected NpmPackageName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.npmPackage = null;
    }

    private NpmPackageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.npmPackage = (String)Preconditions.checkNotNull((Object)builder.getNpmPackage());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getNpmPackage() {
        return this.npmPackage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NpmPackageName of(String project, String location, String repository, String npmPackage) {
        return NpmPackageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setNpmPackage(npmPackage).build();
    }

    public static String format(String project, String location, String repository, String npmPackage) {
        return NpmPackageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setNpmPackage(npmPackage).build().toString();
    }

    public static NpmPackageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_NPM_PACKAGE.validatedMatch(formattedString, "NpmPackageName.parse: formattedString not in valid format");
        return NpmPackageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("npm_package"));
    }

    public static List<NpmPackageName> parseList(List<String> formattedStrings) {
        ArrayList<NpmPackageName> list = new ArrayList<NpmPackageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NpmPackageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NpmPackageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NpmPackageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_NPM_PACKAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NpmPackageName npmPackageName = this;
            synchronized (npmPackageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.npmPackage != null) {
                        fieldMapBuilder.put((Object)"npm_package", (Object)this.npmPackage);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_NPM_PACKAGE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "npm_package", this.npmPackage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NpmPackageName that = (NpmPackageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.npmPackage, that.npmPackage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.npmPackage);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String npmPackage;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getNpmPackage() {
            return this.npmPackage;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setNpmPackage(String npmPackage) {
            this.npmPackage = npmPackage;
            return this;
        }

        private Builder(NpmPackageName npmPackageName) {
            this.project = npmPackageName.project;
            this.location = npmPackageName.location;
            this.repository = npmPackageName.repository;
            this.npmPackage = npmPackageName.npmPackage;
        }

        public NpmPackageName build() {
            return new NpmPackageName(this);
        }
    }
}

