/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MavenArtifactName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_MAVEN_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/mavenArtifacts/{maven_artifact}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String mavenArtifact;

    @Deprecated
    protected MavenArtifactName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.mavenArtifact = null;
    }

    private MavenArtifactName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.mavenArtifact = (String)Preconditions.checkNotNull((Object)builder.getMavenArtifact());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getMavenArtifact() {
        return this.mavenArtifact;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MavenArtifactName of(String project, String location, String repository, String mavenArtifact) {
        return MavenArtifactName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setMavenArtifact(mavenArtifact).build();
    }

    public static String format(String project, String location, String repository, String mavenArtifact) {
        return MavenArtifactName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setMavenArtifact(mavenArtifact).build().toString();
    }

    public static MavenArtifactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_MAVEN_ARTIFACT.validatedMatch(formattedString, "MavenArtifactName.parse: formattedString not in valid format");
        return MavenArtifactName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("maven_artifact"));
    }

    public static List<MavenArtifactName> parseList(List<String> formattedStrings) {
        ArrayList<MavenArtifactName> list = new ArrayList<MavenArtifactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MavenArtifactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MavenArtifactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MavenArtifactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_MAVEN_ARTIFACT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MavenArtifactName mavenArtifactName = this;
            synchronized (mavenArtifactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.mavenArtifact != null) {
                        fieldMapBuilder.put((Object)"maven_artifact", (Object)this.mavenArtifact);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_MAVEN_ARTIFACT.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "maven_artifact", this.mavenArtifact});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MavenArtifactName that = (MavenArtifactName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.mavenArtifact, that.mavenArtifact);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mavenArtifact);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String mavenArtifact;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getMavenArtifact() {
            return this.mavenArtifact;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setMavenArtifact(String mavenArtifact) {
            this.mavenArtifact = mavenArtifact;
            return this;
        }

        private Builder(MavenArtifactName mavenArtifactName) {
            this.project = mavenArtifactName.project;
            this.location = mavenArtifactName.location;
            this.repository = mavenArtifactName.repository;
            this.mavenArtifact = mavenArtifactName.mavenArtifact;
        }

        public MavenArtifactName build() {
            return new MavenArtifactName(this);
        }
    }
}

