/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FileName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_FILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/files/{file}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String file;

    @Deprecated
    protected FileName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.file = null;
    }

    private FileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.file = (String)Preconditions.checkNotNull((Object)builder.getFile());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getFile() {
        return this.file;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FileName of(String project, String location, String repository, String file) {
        return FileName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setFile(file).build();
    }

    public static String format(String project, String location, String repository, String file) {
        return FileName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setFile(file).build().toString();
    }

    public static FileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_FILE.validatedMatch(formattedString, "FileName.parse: formattedString not in valid format");
        return FileName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("file"));
    }

    public static List<FileName> parseList(List<String> formattedStrings) {
        ArrayList<FileName> list = new ArrayList<FileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_FILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FileName fileName = this;
            synchronized (fileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.file != null) {
                        fieldMapBuilder.put((Object)"file", (Object)this.file);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_FILE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "file", this.file});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FileName that = (FileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.file, that.file);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.file);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String file;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getFile() {
            return this.file;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setFile(String file) {
            this.file = file;
            return this;
        }

        private Builder(FileName fileName) {
            this.project = fileName.project;
            this.location = fileName.location;
            this.repository = fileName.repository;
            this.file = fileName.file;
        }

        public FileName build() {
            return new FileName(this);
        }
    }
}

