/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttachmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_ATTACHMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/attachments/{attachment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String attachment;

    @Deprecated
    protected AttachmentName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.attachment = null;
    }

    private AttachmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.attachment = (String)Preconditions.checkNotNull((Object)builder.getAttachment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttachmentName of(String project, String location, String repository, String attachment) {
        return AttachmentName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setAttachment(attachment).build();
    }

    public static String format(String project, String location, String repository, String attachment) {
        return AttachmentName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setAttachment(attachment).build().toString();
    }

    public static AttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_ATTACHMENT.validatedMatch(formattedString, "AttachmentName.parse: formattedString not in valid format");
        return AttachmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("attachment"));
    }

    public static List<AttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<AttachmentName> list = new ArrayList<AttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_ATTACHMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttachmentName attachmentName = this;
            synchronized (attachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.attachment != null) {
                        fieldMapBuilder.put((Object)"attachment", (Object)this.attachment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_ATTACHMENT.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "attachment", this.attachment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttachmentName that = (AttachmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.attachment, that.attachment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.attachment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String attachment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getAttachment() {
            return this.attachment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setAttachment(String attachment) {
            this.attachment = attachment;
            return this;
        }

        private Builder(AttachmentName attachmentName) {
            this.project = attachmentName.project;
            this.location = attachmentName.location;
            this.repository = attachmentName.repository;
            this.attachment = attachmentName.attachment;
        }

        public AttachmentName build() {
            return new AttachmentName(this);
        }
    }
}

