/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RepositoryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;

    @Deprecated
    protected RepositoryName() {
        this.project = null;
        this.location = null;
        this.repository = null;
    }

    private RepositoryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RepositoryName of(String project, String location, String repository) {
        return RepositoryName.newBuilder().setProject(project).setLocation(location).setRepository(repository).build();
    }

    public static String format(String project, String location, String repository) {
        return RepositoryName.newBuilder().setProject(project).setLocation(location).setRepository(repository).build().toString();
    }

    public static RepositoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY.validatedMatch(formattedString, "RepositoryName.parse: formattedString not in valid format");
        return RepositoryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"));
    }

    public static List<RepositoryName> parseList(List<String> formattedStrings) {
        ArrayList<RepositoryName> list = new ArrayList<RepositoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RepositoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RepositoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RepositoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RepositoryName repositoryName = this;
            synchronized (repositoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RepositoryName that = (RepositoryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.repository);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        private Builder(RepositoryName repositoryName) {
            this.project = repositoryName.project;
            this.location = repositoryName.location;
            this.repository = repositoryName.repository;
        }

        public RepositoryName build() {
            return new RepositoryName(this);
        }
    }
}

