/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p1beta1/assets.proto

package com.google.cloud.asset.v1p1beta1;

/**
 *
 *
 * <pre>
 * The result for a IAM Policy search.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p1beta1.IamPolicySearchResult}
 */
public final class IamPolicySearchResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p1beta1.IamPolicySearchResult)
    IamPolicySearchResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IamPolicySearchResult.newBuilder() to construct.
  private IamPolicySearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IamPolicySearchResult() {
    resource_ = "";
    project_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IamPolicySearchResult();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private IamPolicySearchResult(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              resource_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              project_ = s;
              break;
            }
          case 34:
            {
              com.google.iam.v1.Policy.Builder subBuilder = null;
              if (policy_ != null) {
                subBuilder = policy_.toBuilder();
              }
              policy_ = input.readMessage(com.google.iam.v1.Policy.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(policy_);
                policy_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder
                  subBuilder = null;
              if (explanation_ != null) {
                subBuilder = explanation_.toBuilder();
              }
              explanation_ =
                  input.readMessage(
                      com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(explanation_);
                explanation_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p1beta1.AssetProto
        .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p1beta1.AssetProto
        .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.class,
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Builder.class);
  }

  public interface ExplanationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    int getMatchedPermissionsCount();
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    boolean containsMatchedPermissions(java.lang.String key);
    /** Use {@link #getMatchedPermissionsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
        getMatchedPermissions();
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
        getMatchedPermissionsMap();
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    com.google.cloud.asset.v1p1beta1.Permissions getMatchedPermissionsOrDefault(
        java.lang.String key, com.google.cloud.asset.v1p1beta1.Permissions defaultValue);
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    com.google.cloud.asset.v1p1beta1.Permissions getMatchedPermissionsOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Explanation about the IAM policy search result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation}
   */
  public static final class Explanation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)
      ExplanationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Explanation.newBuilder() to construct.
    private Explanation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Explanation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Explanation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Explanation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  matchedPermissions_ =
                      com.google.protobuf.MapField.newMapField(
                          MatchedPermissionsDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000001;
                }
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
                    matchedPermissions__ =
                        input.readMessage(
                            MatchedPermissionsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                matchedPermissions_
                    .getMutableMap()
                    .put(matchedPermissions__.getKey(), matchedPermissions__.getValue());
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_Explanation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetMatchedPermissions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_Explanation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.class,
              com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder.class);
    }

    public static final int MATCHED_PERMISSIONS_FIELD_NUMBER = 1;

    private static final class MatchedPermissionsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
                      newDefaultInstance(
                          com.google.cloud.asset.v1p1beta1.AssetProto
                              .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_Explanation_MatchedPermissionsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.asset.v1p1beta1.Permissions.getDefaultInstance());
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
        matchedPermissions_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
        internalGetMatchedPermissions() {
      if (matchedPermissions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MatchedPermissionsDefaultEntryHolder.defaultEntry);
      }
      return matchedPermissions_;
    }

    public int getMatchedPermissionsCount() {
      return internalGetMatchedPermissions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    @java.lang.Override
    public boolean containsMatchedPermissions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetMatchedPermissions().getMap().containsKey(key);
    }
    /** Use {@link #getMatchedPermissionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
        getMatchedPermissions() {
      return getMatchedPermissionsMap();
    }
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
        getMatchedPermissionsMap() {
      return internalGetMatchedPermissions().getMap();
    }
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.Permissions getMatchedPermissionsOrDefault(
        java.lang.String key, com.google.cloud.asset.v1p1beta1.Permissions defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions> map =
          internalGetMatchedPermissions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The map from roles to their included permission matching the permission
     * query (e.g. containing `policy.role.permissions:`). A sample role string:
     * "roles/compute.instanceAdmin". The roles can also be found in the
     * returned `policy` bindings. Note that the map is populated only if
     * requesting with a permission query.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.Permissions getMatchedPermissionsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions> map =
          internalGetMatchedPermissions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetMatchedPermissions(),
          MatchedPermissionsDefaultEntryHolder.defaultEntry,
          1);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          entry : internalGetMatchedPermissions().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
            matchedPermissions__ =
                MatchedPermissionsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, matchedPermissions__);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation other =
          (com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation) obj;

      if (!internalGetMatchedPermissions().equals(other.internalGetMatchedPermissions()))
        return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetMatchedPermissions().getMap().isEmpty()) {
        hash = (37 * hash) + MATCHED_PERMISSIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetMatchedPermissions().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.ExplanationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p1beta1.AssetProto
            .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_Explanation_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMatchedPermissions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableMatchedPermissions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p1beta1.AssetProto
            .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_Explanation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.class,
                com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder.class);
      }

      // Construct using
      // com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        internalGetMutableMatchedPermissions().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p1beta1.AssetProto
            .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_Explanation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation build() {
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation buildPartial() {
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation result =
            new com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation(this);
        int from_bitField0_ = bitField0_;
        result.matchedPermissions_ = internalGetMatchedPermissions();
        result.matchedPermissions_.makeImmutable();
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation) {
          return mergeFrom(
              (com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation other) {
        if (other
            == com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
                .getDefaultInstance()) return this;
        internalGetMutableMatchedPermissions().mergeFrom(other.internalGetMatchedPermissions());
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          matchedPermissions_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          internalGetMatchedPermissions() {
        if (matchedPermissions_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              MatchedPermissionsDefaultEntryHolder.defaultEntry);
        }
        return matchedPermissions_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          internalGetMutableMatchedPermissions() {
        onChanged();
        ;
        if (matchedPermissions_ == null) {
          matchedPermissions_ =
              com.google.protobuf.MapField.newMapField(
                  MatchedPermissionsDefaultEntryHolder.defaultEntry);
        }
        if (!matchedPermissions_.isMutable()) {
          matchedPermissions_ = matchedPermissions_.copy();
        }
        return matchedPermissions_;
      }

      public int getMatchedPermissionsCount() {
        return internalGetMatchedPermissions().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      @java.lang.Override
      public boolean containsMatchedPermissions(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        return internalGetMatchedPermissions().getMap().containsKey(key);
      }
      /** Use {@link #getMatchedPermissionsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          getMatchedPermissions() {
        return getMatchedPermissionsMap();
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          getMatchedPermissionsMap() {
        return internalGetMatchedPermissions().getMap();
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.asset.v1p1beta1.Permissions getMatchedPermissionsOrDefault(
          java.lang.String key, com.google.cloud.asset.v1p1beta1.Permissions defaultValue) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions> map =
            internalGetMatchedPermissions().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.asset.v1p1beta1.Permissions getMatchedPermissionsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions> map =
            internalGetMatchedPermissions().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearMatchedPermissions() {
        internalGetMutableMatchedPermissions().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      public Builder removeMatchedPermissions(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableMatchedPermissions().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions>
          getMutableMatchedPermissions() {
        return internalGetMutableMatchedPermissions().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      public Builder putMatchedPermissions(
          java.lang.String key, com.google.cloud.asset.v1p1beta1.Permissions value) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        if (value == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableMatchedPermissions().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The map from roles to their included permission matching the permission
       * query (e.g. containing `policy.role.permissions:`). A sample role string:
       * "roles/compute.instanceAdmin". The roles can also be found in the
       * returned `policy` bindings. Note that the map is populated only if
       * requesting with a permission query.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.asset.v1p1beta1.Permissions&gt; matched_permissions = 1;
       * </code>
       */
      public Builder putAllMatchedPermissions(
          java.util.Map<java.lang.String, com.google.cloud.asset.v1p1beta1.Permissions> values) {
        internalGetMutableMatchedPermissions().getMutableMap().putAll(values);
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation)
    private static final com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation();
    }

    public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Explanation> PARSER =
        new com.google.protobuf.AbstractParser<Explanation>() {
          @java.lang.Override
          public Explanation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Explanation(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Explanation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Explanation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 1;
  private volatile java.lang.Object resource_;
  /**
   *
   *
   * <pre>
   * The [full resource
   * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * of the resource associated with this IAM policy.
   * </pre>
   *
   * <code>string resource = 1;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [full resource
   * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * of the resource associated with this IAM policy.
   * </pre>
   *
   * <code>string resource = 1;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 3;
  private volatile java.lang.Object project_;
  /**
   *
   *
   * <pre>
   * The project that the associated GCP resource belongs to, in the form of
   * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
   * instance, Cloud Storage bucket), the project field will indicate the
   * project that contains the resource. If an IAM policy is set on a folder or
   * orgnization, the project field will be empty.
   * </pre>
   *
   * <code>string project = 3;</code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project that the associated GCP resource belongs to, in the form of
   * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
   * instance, Cloud Storage bucket), the project field will indicate the
   * project that contains the resource. If an IAM policy is set on a folder or
   * orgnization, the project field will be empty.
   * </pre>
   *
   * <code>string project = 3;</code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_FIELD_NUMBER = 4;
  private com.google.iam.v1.Policy policy_;
  /**
   *
   *
   * <pre>
   * The IAM policy directly set on the given resource. Note that the original
   * IAM policy can contain multiple bindings. This only contains the bindings
   * that match the given query. For queries that don't contain a constrain on
   * policies (e.g. an empty query), this contains all the bindings.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 4;</code>
   *
   * @return Whether the policy field is set.
   */
  @java.lang.Override
  public boolean hasPolicy() {
    return policy_ != null;
  }
  /**
   *
   *
   * <pre>
   * The IAM policy directly set on the given resource. Note that the original
   * IAM policy can contain multiple bindings. This only contains the bindings
   * that match the given query. For queries that don't contain a constrain on
   * policies (e.g. an empty query), this contains all the bindings.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 4;</code>
   *
   * @return The policy.
   */
  @java.lang.Override
  public com.google.iam.v1.Policy getPolicy() {
    return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
  }
  /**
   *
   *
   * <pre>
   * The IAM policy directly set on the given resource. Note that the original
   * IAM policy can contain multiple bindings. This only contains the bindings
   * that match the given query. For queries that don't contain a constrain on
   * policies (e.g. an empty query), this contains all the bindings.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 4;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder() {
    return getPolicy();
  }

  public static final int EXPLANATION_FIELD_NUMBER = 5;
  private com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation_;
  /**
   *
   *
   * <pre>
   * Explanation about the IAM policy search result. It contains additional
   * information to explain why the search result matches the query.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
   *
   * @return Whether the explanation field is set.
   */
  @java.lang.Override
  public boolean hasExplanation() {
    return explanation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Explanation about the IAM policy search result. It contains additional
   * information to explain why the search result matches the query.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
   *
   * @return The explanation.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation getExplanation() {
    return explanation_ == null
        ? com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.getDefaultInstance()
        : explanation_;
  }
  /**
   *
   *
   * <pre>
   * Explanation about the IAM policy search result. It contains additional
   * information to explain why the search result matches the query.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.ExplanationOrBuilder
      getExplanationOrBuilder() {
    return getExplanation();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, project_);
    }
    if (policy_ != null) {
      output.writeMessage(4, getPolicy());
    }
    if (explanation_ != null) {
      output.writeMessage(5, getExplanation());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, project_);
    }
    if (policy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPolicy());
    }
    if (explanation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getExplanation());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p1beta1.IamPolicySearchResult)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p1beta1.IamPolicySearchResult other =
        (com.google.cloud.asset.v1p1beta1.IamPolicySearchResult) obj;

    if (!getResource().equals(other.getResource())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (hasPolicy() != other.hasPolicy()) return false;
    if (hasPolicy()) {
      if (!getPolicy().equals(other.getPolicy())) return false;
    }
    if (hasExplanation() != other.hasExplanation()) return false;
    if (hasExplanation()) {
      if (!getExplanation().equals(other.getExplanation())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    if (hasPolicy()) {
      hash = (37 * hash) + POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getPolicy().hashCode();
    }
    if (hasExplanation()) {
      hash = (37 * hash) + EXPLANATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplanation().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.asset.v1p1beta1.IamPolicySearchResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The result for a IAM Policy search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p1beta1.IamPolicySearchResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p1beta1.IamPolicySearchResult)
      com.google.cloud.asset.v1p1beta1.IamPolicySearchResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.class,
              com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      resource_ = "";

      project_ = "";

      if (policyBuilder_ == null) {
        policy_ = null;
      } else {
        policy_ = null;
        policyBuilder_ = null;
      }
      if (explanationBuilder_ == null) {
        explanation_ = null;
      } else {
        explanation_ = null;
        explanationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_IamPolicySearchResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult build() {
      com.google.cloud.asset.v1p1beta1.IamPolicySearchResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult buildPartial() {
      com.google.cloud.asset.v1p1beta1.IamPolicySearchResult result =
          new com.google.cloud.asset.v1p1beta1.IamPolicySearchResult(this);
      result.resource_ = resource_;
      result.project_ = project_;
      if (policyBuilder_ == null) {
        result.policy_ = policy_;
      } else {
        result.policy_ = policyBuilder_.build();
      }
      if (explanationBuilder_ == null) {
        result.explanation_ = explanation_;
      } else {
        result.explanation_ = explanationBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p1beta1.IamPolicySearchResult) {
        return mergeFrom((com.google.cloud.asset.v1p1beta1.IamPolicySearchResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p1beta1.IamPolicySearchResult other) {
      if (other == com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.getDefaultInstance())
        return this;
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        onChanged();
      }
      if (other.hasPolicy()) {
        mergePolicy(other.getPolicy());
      }
      if (other.hasExplanation()) {
        mergeExplanation(other.getExplanation());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.asset.v1p1beta1.IamPolicySearchResult parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.asset.v1p1beta1.IamPolicySearchResult) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * The [full resource
     * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * of the resource associated with this IAM policy.
     * </pre>
     *
     * <code>string resource = 1;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [full resource
     * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * of the resource associated with this IAM policy.
     * </pre>
     *
     * <code>string resource = 1;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [full resource
     * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * of the resource associated with this IAM policy.
     * </pre>
     *
     * <code>string resource = 1;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [full resource
     * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * of the resource associated with this IAM policy.
     * </pre>
     *
     * <code>string resource = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {

      resource_ = getDefaultInstance().getResource();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [full resource
     * name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * of the resource associated with this IAM policy.
     * </pre>
     *
     * <code>string resource = 1;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      resource_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * The project that the associated GCP resource belongs to, in the form of
     * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
     * instance, Cloud Storage bucket), the project field will indicate the
     * project that contains the resource. If an IAM policy is set on a folder or
     * orgnization, the project field will be empty.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that the associated GCP resource belongs to, in the form of
     * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
     * instance, Cloud Storage bucket), the project field will indicate the
     * project that contains the resource. If an IAM policy is set on a folder or
     * orgnization, the project field will be empty.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that the associated GCP resource belongs to, in the form of
     * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
     * instance, Cloud Storage bucket), the project field will indicate the
     * project that contains the resource. If an IAM policy is set on a folder or
     * orgnization, the project field will be empty.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      project_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project that the associated GCP resource belongs to, in the form of
     * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
     * instance, Cloud Storage bucket), the project field will indicate the
     * project that contains the resource. If an IAM policy is set on a folder or
     * orgnization, the project field will be empty.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {

      project_ = getDefaultInstance().getProject();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project that the associated GCP resource belongs to, in the form of
     * `projects/{project_number}`. If an IAM policy is set on a resource (like VM
     * instance, Cloud Storage bucket), the project field will indicate the
     * project that contains the resource. If an IAM policy is set on a folder or
     * orgnization, the project field will be empty.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      project_ = value;
      onChanged();
      return this;
    }

    private com.google.iam.v1.Policy policy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Policy,
            com.google.iam.v1.Policy.Builder,
            com.google.iam.v1.PolicyOrBuilder>
        policyBuilder_;
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     *
     * @return Whether the policy field is set.
     */
    public boolean hasPolicy() {
      return policyBuilder_ != null || policy_ != null;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     *
     * @return The policy.
     */
    public com.google.iam.v1.Policy getPolicy() {
      if (policyBuilder_ == null) {
        return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
      } else {
        return policyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    public Builder setPolicy(com.google.iam.v1.Policy value) {
      if (policyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policy_ = value;
        onChanged();
      } else {
        policyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    public Builder setPolicy(com.google.iam.v1.Policy.Builder builderForValue) {
      if (policyBuilder_ == null) {
        policy_ = builderForValue.build();
        onChanged();
      } else {
        policyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    public Builder mergePolicy(com.google.iam.v1.Policy value) {
      if (policyBuilder_ == null) {
        if (policy_ != null) {
          policy_ = com.google.iam.v1.Policy.newBuilder(policy_).mergeFrom(value).buildPartial();
        } else {
          policy_ = value;
        }
        onChanged();
      } else {
        policyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    public Builder clearPolicy() {
      if (policyBuilder_ == null) {
        policy_ = null;
        onChanged();
      } else {
        policy_ = null;
        policyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    public com.google.iam.v1.Policy.Builder getPolicyBuilder() {

      onChanged();
      return getPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    public com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder() {
      if (policyBuilder_ != null) {
        return policyBuilder_.getMessageOrBuilder();
      } else {
        return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The IAM policy directly set on the given resource. Note that the original
     * IAM policy can contain multiple bindings. This only contains the bindings
     * that match the given query. For queries that don't contain a constrain on
     * policies (e.g. an empty query), this contains all the bindings.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Policy,
            com.google.iam.v1.Policy.Builder,
            com.google.iam.v1.PolicyOrBuilder>
        getPolicyFieldBuilder() {
      if (policyBuilder_ == null) {
        policyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.iam.v1.Policy,
                com.google.iam.v1.Policy.Builder,
                com.google.iam.v1.PolicyOrBuilder>(getPolicy(), getParentForChildren(), isClean());
        policy_ = null;
      }
      return policyBuilder_;
    }

    private com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation,
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder,
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.ExplanationOrBuilder>
        explanationBuilder_;
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     *
     * @return Whether the explanation field is set.
     */
    public boolean hasExplanation() {
      return explanationBuilder_ != null || explanation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     *
     * @return The explanation.
     */
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation getExplanation() {
      if (explanationBuilder_ == null) {
        return explanation_ == null
            ? com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
                .getDefaultInstance()
            : explanation_;
      } else {
        return explanationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    public Builder setExplanation(
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation value) {
      if (explanationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanation_ = value;
        onChanged();
      } else {
        explanationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    public Builder setExplanation(
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder
            builderForValue) {
      if (explanationBuilder_ == null) {
        explanation_ = builderForValue.build();
        onChanged();
      } else {
        explanationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    public Builder mergeExplanation(
        com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation value) {
      if (explanationBuilder_ == null) {
        if (explanation_ != null) {
          explanation_ =
              com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.newBuilder(
                      explanation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          explanation_ = value;
        }
        onChanged();
      } else {
        explanationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    public Builder clearExplanation() {
      if (explanationBuilder_ == null) {
        explanation_ = null;
        onChanged();
      } else {
        explanation_ = null;
        explanationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder
        getExplanationBuilder() {

      onChanged();
      return getExplanationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.ExplanationOrBuilder
        getExplanationOrBuilder() {
      if (explanationBuilder_ != null) {
        return explanationBuilder_.getMessageOrBuilder();
      } else {
        return explanation_ == null
            ? com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation
                .getDefaultInstance()
            : explanation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation about the IAM policy search result. It contains additional
     * information to explain why the search result matches the query.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation explanation = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation,
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder,
            com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.ExplanationOrBuilder>
        getExplanationFieldBuilder() {
      if (explanationBuilder_ == null) {
        explanationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation,
                com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.Explanation.Builder,
                com.google.cloud.asset.v1p1beta1.IamPolicySearchResult.ExplanationOrBuilder>(
                getExplanation(), getParentForChildren(), isClean());
        explanation_ = null;
      }
      return explanationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p1beta1.IamPolicySearchResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p1beta1.IamPolicySearchResult)
  private static final com.google.cloud.asset.v1p1beta1.IamPolicySearchResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p1beta1.IamPolicySearchResult();
  }

  public static com.google.cloud.asset.v1p1beta1.IamPolicySearchResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IamPolicySearchResult> PARSER =
      new com.google.protobuf.AbstractParser<IamPolicySearchResult>() {
        @java.lang.Override
        public IamPolicySearchResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new IamPolicySearchResult(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<IamPolicySearchResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IamPolicySearchResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p1beta1.IamPolicySearchResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
