/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p1beta1/assets.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.asset.v1p1beta1;

/**
 *
 *
 * <pre>
 * The standard metadata of a cloud resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p1beta1.StandardResourceMetadata}
 */
public final class StandardResourceMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p1beta1.StandardResourceMetadata)
    StandardResourceMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StandardResourceMetadata.newBuilder() to construct.
  private StandardResourceMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StandardResourceMetadata() {
    name_ = "";
    assetType_ = "";
    project_ = "";
    displayName_ = "";
    description_ = "";
    additionalAttributes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    location_ = "";
    networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StandardResourceMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p1beta1.AssetProto
        .internal_static_google_cloud_asset_v1p1beta1_StandardResourceMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p1beta1.AssetProto
        .internal_static_google_cloud_asset_v1p1beta1_StandardResourceMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.class,
            com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name. For example:
   * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
   * See [Resource
   * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * for more information.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name. For example:
   * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
   * See [Resource
   * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * for more information.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSET_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object assetType_ = "";
  /**
   *
   *
   * <pre>
   * The type of this resource.
   * For example: "compute.googleapis.com/Disk".
   * </pre>
   *
   * <code>string asset_type = 2;</code>
   *
   * @return The assetType.
   */
  @java.lang.Override
  public java.lang.String getAssetType() {
    java.lang.Object ref = assetType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assetType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of this resource.
   * For example: "compute.googleapis.com/Disk".
   * </pre>
   *
   * <code>string asset_type = 2;</code>
   *
   * @return The bytes for assetType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAssetTypeBytes() {
    java.lang.Object ref = assetType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      assetType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * The project that this resource belongs to, in the form of
   * `projects/{project_number}`.
   * </pre>
   *
   * <code>string project = 3;</code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project that this resource belongs to, in the form of
   * `projects/{project_number}`.
   * </pre>
   *
   * <code>string project = 3;</code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of this resource.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of this resource.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of this resource. Maximum length
   * could be up to 1M bytes.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One or more paragraphs of text description of this resource. Maximum length
   * could be up to 1M bytes.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDITIONAL_ATTRIBUTES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList additionalAttributes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Additional searchable attributes of this resource.
   * Informational only. The exact set of attributes is subject to change.
   * For example: project id, DNS name etc.
   * </pre>
   *
   * <code>repeated string additional_attributes = 10;</code>
   *
   * @return A list containing the additionalAttributes.
   */
  public com.google.protobuf.ProtocolStringList getAdditionalAttributesList() {
    return additionalAttributes_;
  }
  /**
   *
   *
   * <pre>
   * Additional searchable attributes of this resource.
   * Informational only. The exact set of attributes is subject to change.
   * For example: project id, DNS name etc.
   * </pre>
   *
   * <code>repeated string additional_attributes = 10;</code>
   *
   * @return The count of additionalAttributes.
   */
  public int getAdditionalAttributesCount() {
    return additionalAttributes_.size();
  }
  /**
   *
   *
   * <pre>
   * Additional searchable attributes of this resource.
   * Informational only. The exact set of attributes is subject to change.
   * For example: project id, DNS name etc.
   * </pre>
   *
   * <code>repeated string additional_attributes = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The additionalAttributes at the given index.
   */
  public java.lang.String getAdditionalAttributes(int index) {
    return additionalAttributes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Additional searchable attributes of this resource.
   * Informational only. The exact set of attributes is subject to change.
   * For example: project id, DNS name etc.
   * </pre>
   *
   * <code>repeated string additional_attributes = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the additionalAttributes at the given index.
   */
  public com.google.protobuf.ByteString getAdditionalAttributesBytes(int index) {
    return additionalAttributes_.getByteString(index);
  }

  public static final int LOCATION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Location can be "global", regional like "us-east1", or zonal like
   * "us-west1-b".
   * </pre>
   *
   * <code>string location = 11;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Location can be "global", regional like "us-east1", or zonal like
   * "us-west1-b".
   * </pre>
   *
   * <code>string location = 11;</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 12;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.asset.v1p1beta1.AssetProto
                .internal_static_google_cloud_asset_v1p1beta1_StandardResourceMetadata_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource. See [Labelling and grouping Google
   * Cloud
   * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource. See [Labelling and grouping Google
   * Cloud
   * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource. See [Labelling and grouping Google
   * Cloud
   * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource. See [Labelling and grouping Google
   * Cloud
   * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 12;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NETWORK_TAGS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList networkTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Network tags associated with this resource. Like labels, network tags are a
   * type of annotations used to group Google Cloud resources. See [Labelling
   * Google Cloud
   * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>repeated string network_tags = 13;</code>
   *
   * @return A list containing the networkTags.
   */
  public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
    return networkTags_;
  }
  /**
   *
   *
   * <pre>
   * Network tags associated with this resource. Like labels, network tags are a
   * type of annotations used to group Google Cloud resources. See [Labelling
   * Google Cloud
   * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>repeated string network_tags = 13;</code>
   *
   * @return The count of networkTags.
   */
  public int getNetworkTagsCount() {
    return networkTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Network tags associated with this resource. Like labels, network tags are a
   * type of annotations used to group Google Cloud resources. See [Labelling
   * Google Cloud
   * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>repeated string network_tags = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The networkTags at the given index.
   */
  public java.lang.String getNetworkTags(int index) {
    return networkTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Network tags associated with this resource. Like labels, network tags are a
   * type of annotations used to group Google Cloud resources. See [Labelling
   * Google Cloud
   * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
   * for more information.
   * </pre>
   *
   * <code>repeated string network_tags = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the networkTags at the given index.
   */
  public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
    return networkTags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, assetType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    for (int i = 0; i < additionalAttributes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 10, additionalAttributes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, location_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 12);
    for (int i = 0; i < networkTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, networkTags_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, assetType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < additionalAttributes_.size(); i++) {
        dataSize += computeStringSizeNoTag(additionalAttributes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAdditionalAttributesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, location_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < networkTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(networkTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNetworkTagsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p1beta1.StandardResourceMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p1beta1.StandardResourceMetadata other =
        (com.google.cloud.asset.v1p1beta1.StandardResourceMetadata) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAssetType().equals(other.getAssetType())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAdditionalAttributesList().equals(other.getAdditionalAttributesList())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getNetworkTagsList().equals(other.getNetworkTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ASSET_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getAssetType().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getAdditionalAttributesCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalAttributesList().hashCode();
    }
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getNetworkTagsCount() > 0) {
      hash = (37 * hash) + NETWORK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.asset.v1p1beta1.StandardResourceMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The standard metadata of a cloud resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p1beta1.StandardResourceMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p1beta1.StandardResourceMetadata)
      com.google.cloud.asset.v1p1beta1.StandardResourceMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_StandardResourceMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_StandardResourceMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.class,
              com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      assetType_ = "";
      project_ = "";
      displayName_ = "";
      description_ = "";
      additionalAttributes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      location_ = "";
      internalGetMutableLabels().clear();
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p1beta1.AssetProto
          .internal_static_google_cloud_asset_v1p1beta1_StandardResourceMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.StandardResourceMetadata getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.StandardResourceMetadata build() {
      com.google.cloud.asset.v1p1beta1.StandardResourceMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p1beta1.StandardResourceMetadata buildPartial() {
      com.google.cloud.asset.v1p1beta1.StandardResourceMetadata result =
          new com.google.cloud.asset.v1p1beta1.StandardResourceMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.asset.v1p1beta1.StandardResourceMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.assetType_ = assetType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        additionalAttributes_.makeImmutable();
        result.additionalAttributes_ = additionalAttributes_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        networkTags_.makeImmutable();
        result.networkTags_ = networkTags_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p1beta1.StandardResourceMetadata) {
        return mergeFrom((com.google.cloud.asset.v1p1beta1.StandardResourceMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p1beta1.StandardResourceMetadata other) {
      if (other == com.google.cloud.asset.v1p1beta1.StandardResourceMetadata.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAssetType().isEmpty()) {
        assetType_ = other.assetType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.additionalAttributes_.isEmpty()) {
        if (additionalAttributes_.isEmpty()) {
          additionalAttributes_ = other.additionalAttributes_;
          bitField0_ |= 0x00000020;
        } else {
          ensureAdditionalAttributesIsMutable();
          additionalAttributes_.addAll(other.additionalAttributes_);
        }
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (!other.networkTags_.isEmpty()) {
        if (networkTags_.isEmpty()) {
          networkTags_ = other.networkTags_;
          bitField0_ |= 0x00000100;
        } else {
          ensureNetworkTagsIsMutable();
          networkTags_.addAll(other.networkTags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                assetType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAdditionalAttributesIsMutable();
                additionalAttributes_.add(s);
                break;
              } // case 82
            case 90:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNetworkTagsIsMutable();
                networkTags_.add(s);
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object assetType_ = "";
    /**
     *
     *
     * <pre>
     * The type of this resource.
     * For example: "compute.googleapis.com/Disk".
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @return The assetType.
     */
    public java.lang.String getAssetType() {
      java.lang.Object ref = assetType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assetType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of this resource.
     * For example: "compute.googleapis.com/Disk".
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @return The bytes for assetType.
     */
    public com.google.protobuf.ByteString getAssetTypeBytes() {
      java.lang.Object ref = assetType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assetType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of this resource.
     * For example: "compute.googleapis.com/Disk".
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @param value The assetType to set.
     * @return This builder for chaining.
     */
    public Builder setAssetType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      assetType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of this resource.
     * For example: "compute.googleapis.com/Disk".
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssetType() {
      assetType_ = getDefaultInstance().getAssetType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of this resource.
     * For example: "compute.googleapis.com/Disk".
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @param value The bytes for assetType to set.
     * @return This builder for chaining.
     */
    public Builder setAssetTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      assetType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * The project that this resource belongs to, in the form of
     * `projects/{project_number}`.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that this resource belongs to, in the form of
     * `projects/{project_number}`.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that this resource belongs to, in the form of
     * `projects/{project_number}`.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project that this resource belongs to, in the form of
     * `projects/{project_number}`.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project that this resource belongs to, in the form of
     * `projects/{project_number}`.
     * </pre>
     *
     * <code>string project = 3;</code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of this resource.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of this resource.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of this resource.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of this resource.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of this resource.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList additionalAttributes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAdditionalAttributesIsMutable() {
      if (!additionalAttributes_.isModifiable()) {
        additionalAttributes_ = new com.google.protobuf.LazyStringArrayList(additionalAttributes_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @return A list containing the additionalAttributes.
     */
    public com.google.protobuf.ProtocolStringList getAdditionalAttributesList() {
      additionalAttributes_.makeImmutable();
      return additionalAttributes_;
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @return The count of additionalAttributes.
     */
    public int getAdditionalAttributesCount() {
      return additionalAttributes_.size();
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The additionalAttributes at the given index.
     */
    public java.lang.String getAdditionalAttributes(int index) {
      return additionalAttributes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the additionalAttributes at the given index.
     */
    public com.google.protobuf.ByteString getAdditionalAttributesBytes(int index) {
      return additionalAttributes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The additionalAttributes to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalAttributes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdditionalAttributesIsMutable();
      additionalAttributes_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @param value The additionalAttributes to add.
     * @return This builder for chaining.
     */
    public Builder addAdditionalAttributes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdditionalAttributesIsMutable();
      additionalAttributes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @param values The additionalAttributes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdditionalAttributes(java.lang.Iterable<java.lang.String> values) {
      ensureAdditionalAttributesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, additionalAttributes_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdditionalAttributes() {
      additionalAttributes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional searchable attributes of this resource.
     * Informational only. The exact set of attributes is subject to change.
     * For example: project id, DNS name etc.
     * </pre>
     *
     * <code>repeated string additional_attributes = 10;</code>
     *
     * @param value The bytes of the additionalAttributes to add.
     * @return This builder for chaining.
     */
    public Builder addAdditionalAttributesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAdditionalAttributesIsMutable();
      additionalAttributes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Location can be "global", regional like "us-east1", or zonal like
     * "us-west1-b".
     * </pre>
     *
     * <code>string location = 11;</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Location can be "global", regional like "us-east1", or zonal like
     * "us-west1-b".
     * </pre>
     *
     * <code>string location = 11;</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Location can be "global", regional like "us-east1", or zonal like
     * "us-west1-b".
     * </pre>
     *
     * <code>string location = 11;</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location can be "global", regional like "us-east1", or zonal like
     * "us-west1-b".
     * </pre>
     *
     * <code>string location = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location can be "global", regional like "us-east1", or zonal like
     * "us-west1-b".
     * </pre>
     *
     * <code>string location = 11;</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource. See [Labelling and grouping Google
     * Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 12;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList networkTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNetworkTagsIsMutable() {
      if (!networkTags_.isModifiable()) {
        networkTags_ = new com.google.protobuf.LazyStringArrayList(networkTags_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @return A list containing the networkTags.
     */
    public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
      networkTags_.makeImmutable();
      return networkTags_;
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @return The count of networkTags.
     */
    public int getNetworkTagsCount() {
      return networkTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The networkTags at the given index.
     */
    public java.lang.String getNetworkTags(int index) {
      return networkTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the networkTags at the given index.
     */
    public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
      return networkTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The networkTags to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @param value The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @param values The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllNetworkTags(java.lang.Iterable<java.lang.String> values) {
      ensureNetworkTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkTags_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTags() {
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](lhttps://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information.
     * </pre>
     *
     * <code>repeated string network_tags = 13;</code>
     *
     * @param value The bytes of the networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p1beta1.StandardResourceMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p1beta1.StandardResourceMetadata)
  private static final com.google.cloud.asset.v1p1beta1.StandardResourceMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p1beta1.StandardResourceMetadata();
  }

  public static com.google.cloud.asset.v1p1beta1.StandardResourceMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StandardResourceMetadata> PARSER =
      new com.google.protobuf.AbstractParser<StandardResourceMetadata>() {
        @java.lang.Override
        public StandardResourceMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StandardResourceMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StandardResourceMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p1beta1.StandardResourceMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
