/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p4beta1/asset_service.proto

package com.google.cloud.asset.v1p4beta1;

/**
 *
 *
 * <pre>
 * A request message for [AssetService.ExportIamPolicyAnalysis][google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis].
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest}
 */
public final class ExportIamPolicyAnalysisRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest)
    ExportIamPolicyAnalysisRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportIamPolicyAnalysisRequest.newBuilder() to construct.
  private ExportIamPolicyAnalysisRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportIamPolicyAnalysisRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportIamPolicyAnalysisRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ExportIamPolicyAnalysisRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.Builder subBuilder = null;
              if (analysisQuery_ != null) {
                subBuilder = analysisQuery_.toBuilder();
              }
              analysisQuery_ =
                  input.readMessage(
                      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(analysisQuery_);
                analysisQuery_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder
                  subBuilder = null;
              if (options_ != null) {
                subBuilder = options_.toBuilder();
              }
              options_ =
                  input.readMessage(
                      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(options_);
                options_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder subBuilder =
                  null;
              if (outputConfig_ != null) {
                subBuilder = outputConfig_.toBuilder();
              }
              outputConfig_ =
                  input.readMessage(
                      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputConfig_);
                outputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p4beta1.AssetServiceProto
        .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p4beta1.AssetServiceProto
        .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.class,
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Builder.class);
  }

  public interface OptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. If true, the identities section of the result will expand any
     * Google groups appearing in an IAM policy binding.
     * If [identity_selector][] is specified, the identity in the result will
     * be determined by the selector, and this flag will have no effect.
     * Default is false.
     * </pre>
     *
     * <code>bool expand_groups = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expandGroups.
     */
    boolean getExpandGroups();

    /**
     *
     *
     * <pre>
     * Optional. If true, the access section of result will expand any roles
     * appearing in IAM policy bindings to include their permissions.
     * If [access_selector][] is specified, the access section of the result
     * will be determined by the selector, and this flag will have no effect.
     * Default is false.
     * </pre>
     *
     * <code>bool expand_roles = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expandRoles.
     */
    boolean getExpandRoles();

    /**
     *
     *
     * <pre>
     * Optional. If true, the resource section of the result will expand any
     * resource attached to an IAM policy to include resources lower in the
     * resource hierarchy.
     * For example, if the request analyzes for which resources user A has
     * permission P, and the results include an IAM policy with P on a GCP
     * folder, the results will also include resources in that folder with
     * permission P.
     * If [resource_selector][] is specified, the resource section of the result
     * will be determined by the selector, and this flag will have no effect.
     * Default is false.
     * </pre>
     *
     * <code>bool expand_resources = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expandResources.
     */
    boolean getExpandResources();

    /**
     *
     *
     * <pre>
     * Optional. If true, the result will output resource edges, starting
     * from the policy attached resource, to any expanded resources.
     * Default is false.
     * </pre>
     *
     * <code>bool output_resource_edges = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputResourceEdges.
     */
    boolean getOutputResourceEdges();

    /**
     *
     *
     * <pre>
     * Optional. If true, the result will output group identity edges, starting
     * from the binding's group members, to any expanded identities.
     * Default is false.
     * </pre>
     *
     * <code>bool output_group_edges = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputGroupEdges.
     */
    boolean getOutputGroupEdges();

    /**
     *
     *
     * <pre>
     * Optional. If true, the response will include access analysis from identities to
     * resources via service account impersonation. This is a very expensive
     * operation, because many derived queries will be executed.
     * For example, if the request analyzes for which resources user A has
     * permission P, and there's an IAM policy states user A has
     * iam.serviceAccounts.getAccessToken permission to a service account SA,
     * and there's another IAM policy states service account SA has permission P
     * to a GCP folder F, then user A potentially has access to the GCP folder
     * F. And those advanced analysis results will be included in
     * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
     * Another example, if the request analyzes for who has
     * permission P to a GCP folder F, and there's an IAM policy states user A
     * has iam.serviceAccounts.actAs permission to a service account SA, and
     * there's another IAM policy states service account SA has permission P to
     * the GCP folder F, then user A potentially has access to the GCP folder
     * F. And those advanced analysis results will be included in
     * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
     * Default is false.
     * </pre>
     *
     * <code>
     * bool analyze_service_account_impersonation = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The analyzeServiceAccountImpersonation.
     */
    boolean getAnalyzeServiceAccountImpersonation();
  }
  /**
   *
   *
   * <pre>
   * Contains request options.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options}
   */
  public static final class Options extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)
      OptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Options.newBuilder() to construct.
    private Options(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Options() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Options();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Options(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                expandGroups_ = input.readBool();
                break;
              }
            case 16:
              {
                expandRoles_ = input.readBool();
                break;
              }
            case 24:
              {
                expandResources_ = input.readBool();
                break;
              }
            case 32:
              {
                outputResourceEdges_ = input.readBool();
                break;
              }
            case 40:
              {
                outputGroupEdges_ = input.readBool();
                break;
              }
            case 48:
              {
                analyzeServiceAccountImpersonation_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_Options_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_Options_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.class,
              com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder
                  .class);
    }

    public static final int EXPAND_GROUPS_FIELD_NUMBER = 1;
    private boolean expandGroups_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the identities section of the result will expand any
     * Google groups appearing in an IAM policy binding.
     * If [identity_selector][] is specified, the identity in the result will
     * be determined by the selector, and this flag will have no effect.
     * Default is false.
     * </pre>
     *
     * <code>bool expand_groups = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expandGroups.
     */
    @java.lang.Override
    public boolean getExpandGroups() {
      return expandGroups_;
    }

    public static final int EXPAND_ROLES_FIELD_NUMBER = 2;
    private boolean expandRoles_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the access section of result will expand any roles
     * appearing in IAM policy bindings to include their permissions.
     * If [access_selector][] is specified, the access section of the result
     * will be determined by the selector, and this flag will have no effect.
     * Default is false.
     * </pre>
     *
     * <code>bool expand_roles = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expandRoles.
     */
    @java.lang.Override
    public boolean getExpandRoles() {
      return expandRoles_;
    }

    public static final int EXPAND_RESOURCES_FIELD_NUMBER = 3;
    private boolean expandResources_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the resource section of the result will expand any
     * resource attached to an IAM policy to include resources lower in the
     * resource hierarchy.
     * For example, if the request analyzes for which resources user A has
     * permission P, and the results include an IAM policy with P on a GCP
     * folder, the results will also include resources in that folder with
     * permission P.
     * If [resource_selector][] is specified, the resource section of the result
     * will be determined by the selector, and this flag will have no effect.
     * Default is false.
     * </pre>
     *
     * <code>bool expand_resources = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expandResources.
     */
    @java.lang.Override
    public boolean getExpandResources() {
      return expandResources_;
    }

    public static final int OUTPUT_RESOURCE_EDGES_FIELD_NUMBER = 4;
    private boolean outputResourceEdges_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the result will output resource edges, starting
     * from the policy attached resource, to any expanded resources.
     * Default is false.
     * </pre>
     *
     * <code>bool output_resource_edges = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputResourceEdges.
     */
    @java.lang.Override
    public boolean getOutputResourceEdges() {
      return outputResourceEdges_;
    }

    public static final int OUTPUT_GROUP_EDGES_FIELD_NUMBER = 5;
    private boolean outputGroupEdges_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the result will output group identity edges, starting
     * from the binding's group members, to any expanded identities.
     * Default is false.
     * </pre>
     *
     * <code>bool output_group_edges = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputGroupEdges.
     */
    @java.lang.Override
    public boolean getOutputGroupEdges() {
      return outputGroupEdges_;
    }

    public static final int ANALYZE_SERVICE_ACCOUNT_IMPERSONATION_FIELD_NUMBER = 6;
    private boolean analyzeServiceAccountImpersonation_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the response will include access analysis from identities to
     * resources via service account impersonation. This is a very expensive
     * operation, because many derived queries will be executed.
     * For example, if the request analyzes for which resources user A has
     * permission P, and there's an IAM policy states user A has
     * iam.serviceAccounts.getAccessToken permission to a service account SA,
     * and there's another IAM policy states service account SA has permission P
     * to a GCP folder F, then user A potentially has access to the GCP folder
     * F. And those advanced analysis results will be included in
     * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
     * Another example, if the request analyzes for who has
     * permission P to a GCP folder F, and there's an IAM policy states user A
     * has iam.serviceAccounts.actAs permission to a service account SA, and
     * there's another IAM policy states service account SA has permission P to
     * the GCP folder F, then user A potentially has access to the GCP folder
     * F. And those advanced analysis results will be included in
     * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
     * Default is false.
     * </pre>
     *
     * <code>
     * bool analyze_service_account_impersonation = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The analyzeServiceAccountImpersonation.
     */
    @java.lang.Override
    public boolean getAnalyzeServiceAccountImpersonation() {
      return analyzeServiceAccountImpersonation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (expandGroups_ != false) {
        output.writeBool(1, expandGroups_);
      }
      if (expandRoles_ != false) {
        output.writeBool(2, expandRoles_);
      }
      if (expandResources_ != false) {
        output.writeBool(3, expandResources_);
      }
      if (outputResourceEdges_ != false) {
        output.writeBool(4, outputResourceEdges_);
      }
      if (outputGroupEdges_ != false) {
        output.writeBool(5, outputGroupEdges_);
      }
      if (analyzeServiceAccountImpersonation_ != false) {
        output.writeBool(6, analyzeServiceAccountImpersonation_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (expandGroups_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, expandGroups_);
      }
      if (expandRoles_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, expandRoles_);
      }
      if (expandResources_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, expandResources_);
      }
      if (outputResourceEdges_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, outputResourceEdges_);
      }
      if (outputGroupEdges_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, outputGroupEdges_);
      }
      if (analyzeServiceAccountImpersonation_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                6, analyzeServiceAccountImpersonation_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options other =
          (com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options) obj;

      if (getExpandGroups() != other.getExpandGroups()) return false;
      if (getExpandRoles() != other.getExpandRoles()) return false;
      if (getExpandResources() != other.getExpandResources()) return false;
      if (getOutputResourceEdges() != other.getOutputResourceEdges()) return false;
      if (getOutputGroupEdges() != other.getOutputGroupEdges()) return false;
      if (getAnalyzeServiceAccountImpersonation() != other.getAnalyzeServiceAccountImpersonation())
        return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPAND_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpandGroups());
      hash = (37 * hash) + EXPAND_ROLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpandRoles());
      hash = (37 * hash) + EXPAND_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpandResources());
      hash = (37 * hash) + OUTPUT_RESOURCE_EDGES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOutputResourceEdges());
      hash = (37 * hash) + OUTPUT_GROUP_EDGES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOutputGroupEdges());
      hash = (37 * hash) + ANALYZE_SERVICE_ACCOUNT_IMPERSONATION_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getAnalyzeServiceAccountImpersonation());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains request options.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.OptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetServiceProto
            .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_Options_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetServiceProto
            .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_Options_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.class,
                com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        expandGroups_ = false;

        expandRoles_ = false;

        expandResources_ = false;

        outputResourceEdges_ = false;

        outputGroupEdges_ = false;

        analyzeServiceAccountImpersonation_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetServiceProto
            .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_Options_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options build() {
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
          buildPartial() {
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options result =
            new com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options(this);
        result.expandGroups_ = expandGroups_;
        result.expandRoles_ = expandRoles_;
        result.expandResources_ = expandResources_;
        result.outputResourceEdges_ = outputResourceEdges_;
        result.outputGroupEdges_ = outputGroupEdges_;
        result.analyzeServiceAccountImpersonation_ = analyzeServiceAccountImpersonation_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
                .getDefaultInstance()) return this;
        if (other.getExpandGroups() != false) {
          setExpandGroups(other.getExpandGroups());
        }
        if (other.getExpandRoles() != false) {
          setExpandRoles(other.getExpandRoles());
        }
        if (other.getExpandResources() != false) {
          setExpandResources(other.getExpandResources());
        }
        if (other.getOutputResourceEdges() != false) {
          setOutputResourceEdges(other.getOutputResourceEdges());
        }
        if (other.getOutputGroupEdges() != false) {
          setOutputGroupEdges(other.getOutputGroupEdges());
        }
        if (other.getAnalyzeServiceAccountImpersonation() != false) {
          setAnalyzeServiceAccountImpersonation(other.getAnalyzeServiceAccountImpersonation());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean expandGroups_;
      /**
       *
       *
       * <pre>
       * Optional. If true, the identities section of the result will expand any
       * Google groups appearing in an IAM policy binding.
       * If [identity_selector][] is specified, the identity in the result will
       * be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_groups = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The expandGroups.
       */
      @java.lang.Override
      public boolean getExpandGroups() {
        return expandGroups_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the identities section of the result will expand any
       * Google groups appearing in an IAM policy binding.
       * If [identity_selector][] is specified, the identity in the result will
       * be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_groups = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The expandGroups to set.
       * @return This builder for chaining.
       */
      public Builder setExpandGroups(boolean value) {

        expandGroups_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the identities section of the result will expand any
       * Google groups appearing in an IAM policy binding.
       * If [identity_selector][] is specified, the identity in the result will
       * be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_groups = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpandGroups() {

        expandGroups_ = false;
        onChanged();
        return this;
      }

      private boolean expandRoles_;
      /**
       *
       *
       * <pre>
       * Optional. If true, the access section of result will expand any roles
       * appearing in IAM policy bindings to include their permissions.
       * If [access_selector][] is specified, the access section of the result
       * will be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_roles = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The expandRoles.
       */
      @java.lang.Override
      public boolean getExpandRoles() {
        return expandRoles_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the access section of result will expand any roles
       * appearing in IAM policy bindings to include their permissions.
       * If [access_selector][] is specified, the access section of the result
       * will be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_roles = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The expandRoles to set.
       * @return This builder for chaining.
       */
      public Builder setExpandRoles(boolean value) {

        expandRoles_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the access section of result will expand any roles
       * appearing in IAM policy bindings to include their permissions.
       * If [access_selector][] is specified, the access section of the result
       * will be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_roles = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpandRoles() {

        expandRoles_ = false;
        onChanged();
        return this;
      }

      private boolean expandResources_;
      /**
       *
       *
       * <pre>
       * Optional. If true, the resource section of the result will expand any
       * resource attached to an IAM policy to include resources lower in the
       * resource hierarchy.
       * For example, if the request analyzes for which resources user A has
       * permission P, and the results include an IAM policy with P on a GCP
       * folder, the results will also include resources in that folder with
       * permission P.
       * If [resource_selector][] is specified, the resource section of the result
       * will be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_resources = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The expandResources.
       */
      @java.lang.Override
      public boolean getExpandResources() {
        return expandResources_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the resource section of the result will expand any
       * resource attached to an IAM policy to include resources lower in the
       * resource hierarchy.
       * For example, if the request analyzes for which resources user A has
       * permission P, and the results include an IAM policy with P on a GCP
       * folder, the results will also include resources in that folder with
       * permission P.
       * If [resource_selector][] is specified, the resource section of the result
       * will be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_resources = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The expandResources to set.
       * @return This builder for chaining.
       */
      public Builder setExpandResources(boolean value) {

        expandResources_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the resource section of the result will expand any
       * resource attached to an IAM policy to include resources lower in the
       * resource hierarchy.
       * For example, if the request analyzes for which resources user A has
       * permission P, and the results include an IAM policy with P on a GCP
       * folder, the results will also include resources in that folder with
       * permission P.
       * If [resource_selector][] is specified, the resource section of the result
       * will be determined by the selector, and this flag will have no effect.
       * Default is false.
       * </pre>
       *
       * <code>bool expand_resources = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpandResources() {

        expandResources_ = false;
        onChanged();
        return this;
      }

      private boolean outputResourceEdges_;
      /**
       *
       *
       * <pre>
       * Optional. If true, the result will output resource edges, starting
       * from the policy attached resource, to any expanded resources.
       * Default is false.
       * </pre>
       *
       * <code>bool output_resource_edges = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The outputResourceEdges.
       */
      @java.lang.Override
      public boolean getOutputResourceEdges() {
        return outputResourceEdges_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the result will output resource edges, starting
       * from the policy attached resource, to any expanded resources.
       * Default is false.
       * </pre>
       *
       * <code>bool output_resource_edges = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The outputResourceEdges to set.
       * @return This builder for chaining.
       */
      public Builder setOutputResourceEdges(boolean value) {

        outputResourceEdges_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the result will output resource edges, starting
       * from the policy attached resource, to any expanded resources.
       * Default is false.
       * </pre>
       *
       * <code>bool output_resource_edges = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOutputResourceEdges() {

        outputResourceEdges_ = false;
        onChanged();
        return this;
      }

      private boolean outputGroupEdges_;
      /**
       *
       *
       * <pre>
       * Optional. If true, the result will output group identity edges, starting
       * from the binding's group members, to any expanded identities.
       * Default is false.
       * </pre>
       *
       * <code>bool output_group_edges = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The outputGroupEdges.
       */
      @java.lang.Override
      public boolean getOutputGroupEdges() {
        return outputGroupEdges_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the result will output group identity edges, starting
       * from the binding's group members, to any expanded identities.
       * Default is false.
       * </pre>
       *
       * <code>bool output_group_edges = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The outputGroupEdges to set.
       * @return This builder for chaining.
       */
      public Builder setOutputGroupEdges(boolean value) {

        outputGroupEdges_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the result will output group identity edges, starting
       * from the binding's group members, to any expanded identities.
       * Default is false.
       * </pre>
       *
       * <code>bool output_group_edges = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOutputGroupEdges() {

        outputGroupEdges_ = false;
        onChanged();
        return this;
      }

      private boolean analyzeServiceAccountImpersonation_;
      /**
       *
       *
       * <pre>
       * Optional. If true, the response will include access analysis from identities to
       * resources via service account impersonation. This is a very expensive
       * operation, because many derived queries will be executed.
       * For example, if the request analyzes for which resources user A has
       * permission P, and there's an IAM policy states user A has
       * iam.serviceAccounts.getAccessToken permission to a service account SA,
       * and there's another IAM policy states service account SA has permission P
       * to a GCP folder F, then user A potentially has access to the GCP folder
       * F. And those advanced analysis results will be included in
       * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
       * Another example, if the request analyzes for who has
       * permission P to a GCP folder F, and there's an IAM policy states user A
       * has iam.serviceAccounts.actAs permission to a service account SA, and
       * there's another IAM policy states service account SA has permission P to
       * the GCP folder F, then user A potentially has access to the GCP folder
       * F. And those advanced analysis results will be included in
       * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
       * Default is false.
       * </pre>
       *
       * <code>
       * bool analyze_service_account_impersonation = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The analyzeServiceAccountImpersonation.
       */
      @java.lang.Override
      public boolean getAnalyzeServiceAccountImpersonation() {
        return analyzeServiceAccountImpersonation_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the response will include access analysis from identities to
       * resources via service account impersonation. This is a very expensive
       * operation, because many derived queries will be executed.
       * For example, if the request analyzes for which resources user A has
       * permission P, and there's an IAM policy states user A has
       * iam.serviceAccounts.getAccessToken permission to a service account SA,
       * and there's another IAM policy states service account SA has permission P
       * to a GCP folder F, then user A potentially has access to the GCP folder
       * F. And those advanced analysis results will be included in
       * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
       * Another example, if the request analyzes for who has
       * permission P to a GCP folder F, and there's an IAM policy states user A
       * has iam.serviceAccounts.actAs permission to a service account SA, and
       * there's another IAM policy states service account SA has permission P to
       * the GCP folder F, then user A potentially has access to the GCP folder
       * F. And those advanced analysis results will be included in
       * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
       * Default is false.
       * </pre>
       *
       * <code>
       * bool analyze_service_account_impersonation = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The analyzeServiceAccountImpersonation to set.
       * @return This builder for chaining.
       */
      public Builder setAnalyzeServiceAccountImpersonation(boolean value) {

        analyzeServiceAccountImpersonation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If true, the response will include access analysis from identities to
       * resources via service account impersonation. This is a very expensive
       * operation, because many derived queries will be executed.
       * For example, if the request analyzes for which resources user A has
       * permission P, and there's an IAM policy states user A has
       * iam.serviceAccounts.getAccessToken permission to a service account SA,
       * and there's another IAM policy states service account SA has permission P
       * to a GCP folder F, then user A potentially has access to the GCP folder
       * F. And those advanced analysis results will be included in
       * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
       * Another example, if the request analyzes for who has
       * permission P to a GCP folder F, and there's an IAM policy states user A
       * has iam.serviceAccounts.actAs permission to a service account SA, and
       * there's another IAM policy states service account SA has permission P to
       * the GCP folder F, then user A potentially has access to the GCP folder
       * F. And those advanced analysis results will be included in
       * [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
       * Default is false.
       * </pre>
       *
       * <code>
       * bool analyze_service_account_impersonation = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnalyzeServiceAccountImpersonation() {

        analyzeServiceAccountImpersonation_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options)
    private static final com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options();
    }

    public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Options> PARSER =
        new com.google.protobuf.AbstractParser<Options>() {
          @java.lang.Override
          public Options parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Options(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Options> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Options> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ANALYSIS_QUERY_FIELD_NUMBER = 1;
  private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysisQuery_;
  /**
   *
   *
   * <pre>
   * Required. The request query.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the analysisQuery field is set.
   */
  @java.lang.Override
  public boolean hasAnalysisQuery() {
    return analysisQuery_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The request query.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The analysisQuery.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery getAnalysisQuery() {
    return analysisQuery_ == null
        ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.getDefaultInstance()
        : analysisQuery_;
  }
  /**
   *
   *
   * <pre>
   * Required. The request query.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQueryOrBuilder
      getAnalysisQueryOrBuilder() {
    return getAnalysisQuery();
  }

  public static final int OPTIONS_FIELD_NUMBER = 2;
  private com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options_;
  /**
   *
   *
   * <pre>
   * Optional. The request options.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the options field is set.
   */
  @java.lang.Override
  public boolean hasOptions() {
    return options_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The request options.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The options.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options getOptions() {
    return options_ == null
        ? com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
            .getDefaultInstance()
        : options_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The request options.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.OptionsOrBuilder
      getOptionsOrBuilder() {
    return getOptions();
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Output configuration indicating where the results will be output to.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Output configuration indicating where the results will be output to.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Output configuration indicating where the results will be output to.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return getOutputConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (analysisQuery_ != null) {
      output.writeMessage(1, getAnalysisQuery());
    }
    if (options_ != null) {
      output.writeMessage(2, getOptions());
    }
    if (outputConfig_ != null) {
      output.writeMessage(3, getOutputConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (analysisQuery_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAnalysisQuery());
    }
    if (options_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOptions());
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOutputConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest other =
        (com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest) obj;

    if (hasAnalysisQuery() != other.hasAnalysisQuery()) return false;
    if (hasAnalysisQuery()) {
      if (!getAnalysisQuery().equals(other.getAnalysisQuery())) return false;
    }
    if (hasOptions() != other.hasOptions()) return false;
    if (hasOptions()) {
      if (!getOptions().equals(other.getOptions())) return false;
    }
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAnalysisQuery()) {
      hash = (37 * hash) + ANALYSIS_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getAnalysisQuery().hashCode();
    }
    if (hasOptions()) {
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOptions().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request message for [AssetService.ExportIamPolicyAnalysis][google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis].
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest)
      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.class,
              com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (analysisQueryBuilder_ == null) {
        analysisQuery_ = null;
      } else {
        analysisQuery_ = null;
        analysisQueryBuilder_ = null;
      }
      if (optionsBuilder_ == null) {
        options_ = null;
      } else {
        options_ = null;
        optionsBuilder_ = null;
      }
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_ExportIamPolicyAnalysisRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest
        getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest build() {
      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest buildPartial() {
      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest result =
          new com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest(this);
      if (analysisQueryBuilder_ == null) {
        result.analysisQuery_ = analysisQuery_;
      } else {
        result.analysisQuery_ = analysisQueryBuilder_.build();
      }
      if (optionsBuilder_ == null) {
        result.options_ = options_;
      } else {
        result.options_ = optionsBuilder_.build();
      }
      if (outputConfigBuilder_ == null) {
        result.outputConfig_ = outputConfig_;
      } else {
        result.outputConfig_ = outputConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest) {
        return mergeFrom((com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest other) {
      if (other
          == com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.getDefaultInstance())
        return this;
      if (other.hasAnalysisQuery()) {
        mergeAnalysisQuery(other.getAnalysisQuery());
      }
      if (other.hasOptions()) {
        mergeOptions(other.getOptions());
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysisQuery_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQueryOrBuilder>
        analysisQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the analysisQuery field is set.
     */
    public boolean hasAnalysisQuery() {
      return analysisQueryBuilder_ != null || analysisQuery_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The analysisQuery.
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery getAnalysisQuery() {
      if (analysisQueryBuilder_ == null) {
        return analysisQuery_ == null
            ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.getDefaultInstance()
            : analysisQuery_;
      } else {
        return analysisQueryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAnalysisQuery(com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery value) {
      if (analysisQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        analysisQuery_ = value;
        onChanged();
      } else {
        analysisQueryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAnalysisQuery(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.Builder builderForValue) {
      if (analysisQueryBuilder_ == null) {
        analysisQuery_ = builderForValue.build();
        onChanged();
      } else {
        analysisQueryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAnalysisQuery(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery value) {
      if (analysisQueryBuilder_ == null) {
        if (analysisQuery_ != null) {
          analysisQuery_ =
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.newBuilder(analysisQuery_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          analysisQuery_ = value;
        }
        onChanged();
      } else {
        analysisQueryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAnalysisQuery() {
      if (analysisQueryBuilder_ == null) {
        analysisQuery_ = null;
        onChanged();
      } else {
        analysisQuery_ = null;
        analysisQueryBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.Builder
        getAnalysisQueryBuilder() {

      onChanged();
      return getAnalysisQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQueryOrBuilder
        getAnalysisQueryOrBuilder() {
      if (analysisQueryBuilder_ != null) {
        return analysisQueryBuilder_.getMessageOrBuilder();
      } else {
        return analysisQuery_ == null
            ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.getDefaultInstance()
            : analysisQuery_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The request query.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery analysis_query = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQueryOrBuilder>
        getAnalysisQueryFieldBuilder() {
      if (analysisQueryBuilder_ == null) {
        analysisQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.Builder,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisQueryOrBuilder>(
                getAnalysisQuery(), getParentForChildren(), isClean());
        analysisQuery_ = null;
      }
      return analysisQueryBuilder_;
    }

    private com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options,
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder,
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.OptionsOrBuilder>
        optionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the options field is set.
     */
    public boolean hasOptions() {
      return optionsBuilder_ != null || options_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The options.
     */
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options getOptions() {
      if (optionsBuilder_ == null) {
        return options_ == null
            ? com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
                .getDefaultInstance()
            : options_;
      } else {
        return optionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOptions(
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options value) {
      if (optionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        options_ = value;
        onChanged();
      } else {
        optionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOptions(
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder
            builderForValue) {
      if (optionsBuilder_ == null) {
        options_ = builderForValue.build();
        onChanged();
      } else {
        optionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOptions(
        com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options value) {
      if (optionsBuilder_ == null) {
        if (options_ != null) {
          options_ =
              com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.newBuilder(
                      options_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          options_ = value;
        }
        onChanged();
      } else {
        optionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOptions() {
      if (optionsBuilder_ == null) {
        options_ = null;
        onChanged();
      } else {
        options_ = null;
        optionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder
        getOptionsBuilder() {

      onChanged();
      return getOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.OptionsOrBuilder
        getOptionsOrBuilder() {
      if (optionsBuilder_ != null) {
        return optionsBuilder_.getMessageOrBuilder();
      } else {
        return options_ == null
            ? com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
                .getDefaultInstance()
            : options_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The request options.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options,
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder,
            com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.OptionsOrBuilder>
        getOptionsFieldBuilder() {
      if (optionsBuilder_ == null) {
        optionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options,
                com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options.Builder,
                com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.OptionsOrBuilder>(
                getOptions(), getParentForChildren(), isClean());
        options_ = null;
      }
      return optionsBuilder_;
    }

    private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return outputConfigBuilder_ != null || outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (outputConfig_ != null) {
          outputConfig_ =
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.newBuilder(
                      outputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputConfig_ = value;
        }
        onChanged();
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
        onChanged();
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder
        getOutputConfigBuilder() {

      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration indicating where the results will be output to.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest)
  private static final com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest();
  }

  public static com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportIamPolicyAnalysisRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportIamPolicyAnalysisRequest>() {
        @java.lang.Override
        public ExportIamPolicyAnalysisRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ExportIamPolicyAnalysisRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ExportIamPolicyAnalysisRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportIamPolicyAnalysisRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
