/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p4beta1/asset_service.proto

package com.google.cloud.asset.v1p4beta1;

/**
 *
 *
 * <pre>
 * Output configuration for export IAM policy analysis destination.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig}
 */
public final class IamPolicyAnalysisOutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig)
    IamPolicyAnalysisOutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IamPolicyAnalysisOutputConfig.newBuilder() to construct.
  private IamPolicyAnalysisOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IamPolicyAnalysisOutputConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IamPolicyAnalysisOutputConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private IamPolicyAnalysisOutputConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.Builder
                  subBuilder = null;
              if (destinationCase_ == 1) {
                subBuilder =
                    ((com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
                            destination_)
                        .toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
                        destination_);
                destination_ = subBuilder.buildPartial();
              }
              destinationCase_ = 1;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p4beta1.AssetServiceProto
        .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p4beta1.AssetServiceProto
        .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.class,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder.class);
  }

  public interface GcsDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The uri of the Cloud Storage object. It's the same uri that is used by
     * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
     * Editing Object
     * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
     * for more information.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Required. The uri of the Cloud Storage object. It's the same uri that is used by
     * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
     * Editing Object
     * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
     * for more information.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();
  }
  /**
   *
   *
   * <pre>
   * A Cloud Storage location.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination}
   */
  public static final class GcsDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
      GcsDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsDestination.newBuilder() to construct.
    private GcsDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsDestination() {
      uri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsDestination();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private GcsDestination(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                uri_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_GcsDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_GcsDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.Builder
                  .class);
    }

    public static final int URI_FIELD_NUMBER = 1;
    private volatile java.lang.Object uri_;
    /**
     *
     *
     * <pre>
     * Required. The uri of the Cloud Storage object. It's the same uri that is used by
     * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
     * Editing Object
     * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
     * for more information.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The uri of the Cloud Storage object. It's the same uri that is used by
     * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
     * Editing Object
     * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
     * for more information.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage location.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetServiceProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_GcsDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetServiceProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_GcsDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        uri_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetServiceProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_GcsDestination_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
          buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination(this);
        result.uri_ = uri_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                .getDefaultInstance()) return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The uri of the Cloud Storage object. It's the same uri that is used by
       * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
       * Editing Object
       * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
       * for more information.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The uri of the Cloud Storage object. It's the same uri that is used by
       * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
       * Editing Object
       * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
       * for more information.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The uri of the Cloud Storage object. It's the same uri that is used by
       * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
       * Editing Object
       * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
       * for more information.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        uri_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The uri of the Cloud Storage object. It's the same uri that is used by
       * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
       * Editing Object
       * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
       * for more information.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {

        uri_ = getDefaultInstance().getUri();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The uri of the Cloud Storage object. It's the same uri that is used by
       * gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
       * Editing Object
       * Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
       * for more information.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        uri_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
            .GcsDestination
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsDestination> PARSER =
        new com.google.protobuf.AbstractParser<GcsDestination>() {
          @java.lang.Override
          public GcsDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new GcsDestination(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<GcsDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int destinationCase_ = 0;
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(1),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Destination on Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
   * </code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Destination on Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
   * </code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
      getGcsDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
          destination_;
    }
    return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Destination on Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestinationOrBuilder
      getGcsDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
          destination_;
    }
    return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
              destination_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
                  destination_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig other =
        (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig) obj;

    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output configuration for export IAM policy analysis destination.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig)
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p4beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisOutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
        getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig build() {
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig buildPartial() {
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig result =
          new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig(this);
      if (destinationCase_ == 1) {
        if (gcsDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcsDestinationBuilder_.build();
        }
      }
      result.destinationCase_ = destinationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig) {
        return mergeFrom((com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig other) {
      if (other
          == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.getDefaultInstance())
        return this;
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
        getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
              destination_;
        }
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
            .getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    public Builder setGcsDestination(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    public Builder setGcsDestination(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.Builder
            builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    public Builder mergeGcsDestination(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_
                != com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                    .getDefaultInstance()) {
          destination_ =
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                  .newBuilder(
                      (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
                              .GcsDestination)
                          destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsDestinationBuilder_.mergeFrom(value);
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.Builder
        getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
              destination_;
        }
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Destination on Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination gcs_destination = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ =
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                  .getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
                    .Builder,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
                    .GcsDestinationOrBuilder>(
                (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination)
                    destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      ;
      return gcsDestinationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig)
  private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig();
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IamPolicyAnalysisOutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<IamPolicyAnalysisOutputConfig>() {
        @java.lang.Override
        public IamPolicyAnalysisOutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new IamPolicyAnalysisOutputConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<IamPolicyAnalysisOutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IamPolicyAnalysisOutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
