/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p4beta1/assets.proto

package com.google.cloud.asset.v1p4beta1;

/**
 *
 *
 * <pre>
 * IAM Policy analysis result, consisting of one IAM policy binding and derived
 * access control lists.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult}
 */
public final class IamPolicyAnalysisResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult)
    IamPolicyAnalysisResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IamPolicyAnalysisResult.newBuilder() to construct.
  private IamPolicyAnalysisResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IamPolicyAnalysisResult() {
    attachedResourceFullName_ = "";
    accessControlLists_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IamPolicyAnalysisResult();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private IamPolicyAnalysisResult(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              attachedResourceFullName_ = s;
              break;
            }
          case 18:
            {
              com.google.iam.v1.Binding.Builder subBuilder = null;
              if (iamBinding_ != null) {
                subBuilder = iamBinding_.toBuilder();
              }
              iamBinding_ =
                  input.readMessage(com.google.iam.v1.Binding.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(iamBinding_);
                iamBinding_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                accessControlLists_ =
                    new java.util.ArrayList<
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult
                            .AccessControlList>();
                mutable_bitField0_ |= 0x00000001;
              }
              accessControlLists_.add(
                  input.readMessage(
                      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder
                  subBuilder = null;
              if (identityList_ != null) {
                subBuilder = identityList_.toBuilder();
              }
              identityList_ =
                  input.readMessage(
                      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(identityList_);
                identityList_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              fullyExplored_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        accessControlLists_ = java.util.Collections.unmodifiableList(accessControlLists_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p4beta1.AssetProto
        .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p4beta1.AssetProto
        .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.class,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Builder.class);
  }

  public interface AnalysisStateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Google standard error code that best describes the state.
     * For example:
     * - OK means the node has been successfully explored;
     * - PERMISSION_DENIED means an access denied error is encountered;
     * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
     * </pre>
     *
     * <code>.google.rpc.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    int getCodeValue();
    /**
     *
     *
     * <pre>
     * The Google standard error code that best describes the state.
     * For example:
     * - OK means the node has been successfully explored;
     * - PERMISSION_DENIED means an access denied error is encountered;
     * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
     * </pre>
     *
     * <code>.google.rpc.Code code = 1;</code>
     *
     * @return The code.
     */
    com.google.rpc.Code getCode();

    /**
     *
     *
     * <pre>
     * The human-readable description of the cause of failure.
     * </pre>
     *
     * <code>string cause = 2;</code>
     *
     * @return The cause.
     */
    java.lang.String getCause();
    /**
     *
     *
     * <pre>
     * The human-readable description of the cause of failure.
     * </pre>
     *
     * <code>string cause = 2;</code>
     *
     * @return The bytes for cause.
     */
    com.google.protobuf.ByteString getCauseBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents analysis state of each node in the result graph or non-critical
   * errors in the response.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState}
   */
  public static final class AnalysisState extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)
      AnalysisStateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnalysisState.newBuilder() to construct.
    private AnalysisState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnalysisState() {
      code_ = 0;
      cause_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnalysisState();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private AnalysisState(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();

                code_ = rawValue;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                cause_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AnalysisState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AnalysisState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder.class);
    }

    public static final int CODE_FIELD_NUMBER = 1;
    private int code_;
    /**
     *
     *
     * <pre>
     * The Google standard error code that best describes the state.
     * For example:
     * - OK means the node has been successfully explored;
     * - PERMISSION_DENIED means an access denied error is encountered;
     * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
     * </pre>
     *
     * <code>.google.rpc.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * The Google standard error code that best describes the state.
     * For example:
     * - OK means the node has been successfully explored;
     * - PERMISSION_DENIED means an access denied error is encountered;
     * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
     * </pre>
     *
     * <code>.google.rpc.Code code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.rpc.Code getCode() {
      @SuppressWarnings("deprecation")
      com.google.rpc.Code result = com.google.rpc.Code.valueOf(code_);
      return result == null ? com.google.rpc.Code.UNRECOGNIZED : result;
    }

    public static final int CAUSE_FIELD_NUMBER = 2;
    private volatile java.lang.Object cause_;
    /**
     *
     *
     * <pre>
     * The human-readable description of the cause of failure.
     * </pre>
     *
     * <code>string cause = 2;</code>
     *
     * @return The cause.
     */
    @java.lang.Override
    public java.lang.String getCause() {
      java.lang.Object ref = cause_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cause_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the cause of failure.
     * </pre>
     *
     * <code>string cause = 2;</code>
     *
     * @return The bytes for cause.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCauseBytes() {
      java.lang.Object ref = cause_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cause_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (code_ != com.google.rpc.Code.OK.getNumber()) {
        output.writeEnum(1, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cause_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cause_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (code_ != com.google.rpc.Code.OK.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cause_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cause_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState) obj;

      if (code_ != other.code_) return false;
      if (!getCause().equals(other.getCause())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + code_;
      hash = (37 * hash) + CAUSE_FIELD_NUMBER;
      hash = (53 * hash) + getCause().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents analysis state of each node in the result graph or non-critical
     * errors in the response.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AnalysisState_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AnalysisState_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        code_ = 0;

        cause_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AnalysisState_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState(this);
        result.code_ = code_;
        result.cause_ = cause_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                .getDefaultInstance()) return this;
        if (other.code_ != 0) {
          setCodeValue(other.getCodeValue());
        }
        if (!other.getCause().isEmpty()) {
          cause_ = other.cause_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int code_ = 0;
      /**
       *
       *
       * <pre>
       * The Google standard error code that best describes the state.
       * For example:
       * - OK means the node has been successfully explored;
       * - PERMISSION_DENIED means an access denied error is encountered;
       * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
       * </pre>
       *
       * <code>.google.rpc.Code code = 1;</code>
       *
       * @return The enum numeric value on the wire for code.
       */
      @java.lang.Override
      public int getCodeValue() {
        return code_;
      }
      /**
       *
       *
       * <pre>
       * The Google standard error code that best describes the state.
       * For example:
       * - OK means the node has been successfully explored;
       * - PERMISSION_DENIED means an access denied error is encountered;
       * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
       * </pre>
       *
       * <code>.google.rpc.Code code = 1;</code>
       *
       * @param value The enum numeric value on the wire for code to set.
       * @return This builder for chaining.
       */
      public Builder setCodeValue(int value) {

        code_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google standard error code that best describes the state.
       * For example:
       * - OK means the node has been successfully explored;
       * - PERMISSION_DENIED means an access denied error is encountered;
       * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
       * </pre>
       *
       * <code>.google.rpc.Code code = 1;</code>
       *
       * @return The code.
       */
      @java.lang.Override
      public com.google.rpc.Code getCode() {
        @SuppressWarnings("deprecation")
        com.google.rpc.Code result = com.google.rpc.Code.valueOf(code_);
        return result == null ? com.google.rpc.Code.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * The Google standard error code that best describes the state.
       * For example:
       * - OK means the node has been successfully explored;
       * - PERMISSION_DENIED means an access denied error is encountered;
       * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
       * </pre>
       *
       * <code>.google.rpc.Code code = 1;</code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(com.google.rpc.Code value) {
        if (value == null) {
          throw new NullPointerException();
        }

        code_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google standard error code that best describes the state.
       * For example:
       * - OK means the node has been successfully explored;
       * - PERMISSION_DENIED means an access denied error is encountered;
       * - DEADLINE_EXCEEDED means the node hasn't been explored in time;
       * </pre>
       *
       * <code>.google.rpc.Code code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {

        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object cause_ = "";
      /**
       *
       *
       * <pre>
       * The human-readable description of the cause of failure.
       * </pre>
       *
       * <code>string cause = 2;</code>
       *
       * @return The cause.
       */
      public java.lang.String getCause() {
        java.lang.Object ref = cause_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cause_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The human-readable description of the cause of failure.
       * </pre>
       *
       * <code>string cause = 2;</code>
       *
       * @return The bytes for cause.
       */
      public com.google.protobuf.ByteString getCauseBytes() {
        java.lang.Object ref = cause_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cause_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The human-readable description of the cause of failure.
       * </pre>
       *
       * <code>string cause = 2;</code>
       *
       * @param value The cause to set.
       * @return This builder for chaining.
       */
      public Builder setCause(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        cause_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The human-readable description of the cause of failure.
       * </pre>
       *
       * <code>string cause = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCause() {

        cause_ = getDefaultInstance().getCause();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The human-readable description of the cause of failure.
       * </pre>
       *
       * <code>string cause = 2;</code>
       *
       * @param value The bytes for cause to set.
       * @return This builder for chaining.
       */
      public Builder setCauseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        cause_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnalysisState> PARSER =
        new com.google.protobuf.AbstractParser<AnalysisState>() {
          @java.lang.Override
          public AnalysisState parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new AnalysisState(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<AnalysisState> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnalysisState> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The [full resource name](https://aip.dev/122#full-resource-names).
     * </pre>
     *
     * <code>string full_resource_name = 1;</code>
     *
     * @return The fullResourceName.
     */
    java.lang.String getFullResourceName();
    /**
     *
     *
     * <pre>
     * The [full resource name](https://aip.dev/122#full-resource-names).
     * </pre>
     *
     * <code>string full_resource_name = 1;</code>
     *
     * @return The bytes for fullResourceName.
     */
    com.google.protobuf.ByteString getFullResourceNameBytes();

    /**
     *
     *
     * <pre>
     * The analysis state of this resource node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return Whether the analysisState field is set.
     */
    boolean hasAnalysisState();
    /**
     *
     *
     * <pre>
     * The analysis state of this resource node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return The analysisState.
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState getAnalysisState();
    /**
     *
     *
     * <pre>
     * The analysis state of this resource node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
        getAnalysisStateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A GCP resource that appears in an access control list.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource}
   */
  public static final class Resource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)
      ResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Resource.newBuilder() to construct.
    private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Resource() {
      fullResourceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Resource();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Resource(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                fullResourceName_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
                    subBuilder = null;
                if (analysisState_ != null) {
                  subBuilder = analysisState_.toBuilder();
                }
                analysisState_ =
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(analysisState_);
                  analysisState_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Resource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Resource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder.class);
    }

    public static final int FULL_RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object fullResourceName_;
    /**
     *
     *
     * <pre>
     * The [full resource name](https://aip.dev/122#full-resource-names).
     * </pre>
     *
     * <code>string full_resource_name = 1;</code>
     *
     * @return The fullResourceName.
     */
    @java.lang.Override
    public java.lang.String getFullResourceName() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullResourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The [full resource name](https://aip.dev/122#full-resource-names).
     * </pre>
     *
     * <code>string full_resource_name = 1;</code>
     *
     * @return The bytes for fullResourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFullResourceNameBytes() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANALYSIS_STATE_FIELD_NUMBER = 2;
    private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysisState_;
    /**
     *
     *
     * <pre>
     * The analysis state of this resource node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return Whether the analysisState field is set.
     */
    @java.lang.Override
    public boolean hasAnalysisState() {
      return analysisState_ != null;
    }
    /**
     *
     *
     * <pre>
     * The analysis state of this resource node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return The analysisState.
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        getAnalysisState() {
      return analysisState_ == null
          ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
              .getDefaultInstance()
          : analysisState_;
    }
    /**
     *
     *
     * <pre>
     * The analysis state of this resource node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
        getAnalysisStateOrBuilder() {
      return getAnalysisState();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fullResourceName_);
      }
      if (analysisState_ != null) {
        output.writeMessage(2, getAnalysisState());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fullResourceName_);
      }
      if (analysisState_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAnalysisState());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource) obj;

      if (!getFullResourceName().equals(other.getFullResourceName())) return false;
      if (hasAnalysisState() != other.hasAnalysisState()) return false;
      if (hasAnalysisState()) {
        if (!getAnalysisState().equals(other.getAnalysisState())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FULL_RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFullResourceName().hashCode();
      if (hasAnalysisState()) {
        hash = (37 * hash) + ANALYSIS_STATE_FIELD_NUMBER;
        hash = (53 * hash) + getAnalysisState().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A GCP resource that appears in an access control list.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Resource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Resource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder.class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        fullResourceName_ = "";

        if (analysisStateBuilder_ == null) {
          analysisState_ = null;
        } else {
          analysisState_ = null;
          analysisStateBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Resource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource(this);
        result.fullResourceName_ = fullResourceName_;
        if (analysisStateBuilder_ == null) {
          result.analysisState_ = analysisState_;
        } else {
          result.analysisState_ = analysisStateBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
                .getDefaultInstance()) return this;
        if (!other.getFullResourceName().isEmpty()) {
          fullResourceName_ = other.fullResourceName_;
          onChanged();
        }
        if (other.hasAnalysisState()) {
          mergeAnalysisState(other.getAnalysisState());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object fullResourceName_ = "";
      /**
       *
       *
       * <pre>
       * The [full resource name](https://aip.dev/122#full-resource-names).
       * </pre>
       *
       * <code>string full_resource_name = 1;</code>
       *
       * @return The fullResourceName.
       */
      public java.lang.String getFullResourceName() {
        java.lang.Object ref = fullResourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fullResourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The [full resource name](https://aip.dev/122#full-resource-names).
       * </pre>
       *
       * <code>string full_resource_name = 1;</code>
       *
       * @return The bytes for fullResourceName.
       */
      public com.google.protobuf.ByteString getFullResourceNameBytes() {
        java.lang.Object ref = fullResourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fullResourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The [full resource name](https://aip.dev/122#full-resource-names).
       * </pre>
       *
       * <code>string full_resource_name = 1;</code>
       *
       * @param value The fullResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setFullResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fullResourceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [full resource name](https://aip.dev/122#full-resource-names).
       * </pre>
       *
       * <code>string full_resource_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFullResourceName() {

        fullResourceName_ = getDefaultInstance().getFullResourceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [full resource name](https://aip.dev/122#full-resource-names).
       * </pre>
       *
       * <code>string full_resource_name = 1;</code>
       *
       * @param value The bytes for fullResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setFullResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        fullResourceName_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysisState_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>
          analysisStateBuilder_;
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       *
       * @return Whether the analysisState field is set.
       */
      public boolean hasAnalysisState() {
        return analysisStateBuilder_ != null || analysisState_ != null;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       *
       * @return The analysisState.
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
          getAnalysisState() {
        if (analysisStateBuilder_ == null) {
          return analysisState_ == null
              ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                  .getDefaultInstance()
              : analysisState_;
        } else {
          return analysisStateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder setAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState value) {
        if (analysisStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          analysisState_ = value;
          onChanged();
        } else {
          analysisStateBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder setAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
              builderForValue) {
        if (analysisStateBuilder_ == null) {
          analysisState_ = builderForValue.build();
          onChanged();
        } else {
          analysisStateBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder mergeAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState value) {
        if (analysisStateBuilder_ == null) {
          if (analysisState_ != null) {
            analysisState_ =
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.newBuilder(
                        analysisState_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            analysisState_ = value;
          }
          onChanged();
        } else {
          analysisStateBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder clearAnalysisState() {
        if (analysisStateBuilder_ == null) {
          analysisState_ = null;
          onChanged();
        } else {
          analysisState_ = null;
          analysisStateBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
          getAnalysisStateBuilder() {

        onChanged();
        return getAnalysisStateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
          getAnalysisStateOrBuilder() {
        if (analysisStateBuilder_ != null) {
          return analysisStateBuilder_.getMessageOrBuilder();
        } else {
          return analysisState_ == null
              ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                  .getDefaultInstance()
              : analysisState_;
        }
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this resource node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>
          getAnalysisStateFieldBuilder() {
        if (analysisStateBuilder_ == null) {
          analysisStateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>(
                  getAnalysisState(), getParentForChildren(), isClean());
          analysisState_ = null;
        }
        return analysisStateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Resource> PARSER =
        new com.google.protobuf.AbstractParser<Resource>() {
          @java.lang.Override
          public Resource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Resource(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Resource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Resource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AccessOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The role.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return Whether the role field is set.
     */
    boolean hasRole();
    /**
     *
     *
     * <pre>
     * The role.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return The role.
     */
    java.lang.String getRole();
    /**
     *
     *
     * <pre>
     * The role.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return The bytes for role.
     */
    com.google.protobuf.ByteString getRoleBytes();

    /**
     *
     *
     * <pre>
     * The permission.
     * </pre>
     *
     * <code>string permission = 2;</code>
     *
     * @return Whether the permission field is set.
     */
    boolean hasPermission();
    /**
     *
     *
     * <pre>
     * The permission.
     * </pre>
     *
     * <code>string permission = 2;</code>
     *
     * @return The permission.
     */
    java.lang.String getPermission();
    /**
     *
     *
     * <pre>
     * The permission.
     * </pre>
     *
     * <code>string permission = 2;</code>
     *
     * @return The bytes for permission.
     */
    com.google.protobuf.ByteString getPermissionBytes();

    /**
     *
     *
     * <pre>
     * The analysis state of this access node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
     * </code>
     *
     * @return Whether the analysisState field is set.
     */
    boolean hasAnalysisState();
    /**
     *
     *
     * <pre>
     * The analysis state of this access node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
     * </code>
     *
     * @return The analysisState.
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState getAnalysisState();
    /**
     *
     *
     * <pre>
     * The analysis state of this access node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
        getAnalysisStateOrBuilder();

    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.OneofAccessCase
        getOneofAccessCase();
  }
  /**
   *
   *
   * <pre>
   * A role or permission that appears in an access control list.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access}
   */
  public static final class Access extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)
      AccessOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Access.newBuilder() to construct.
    private Access(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Access() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Access();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Access(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                oneofAccessCase_ = 1;
                oneofAccess_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                oneofAccessCase_ = 2;
                oneofAccess_ = s;
                break;
              }
            case 26:
              {
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
                    subBuilder = null;
                if (analysisState_ != null) {
                  subBuilder = analysisState_.toBuilder();
                }
                analysisState_ =
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(analysisState_);
                  analysisState_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Access_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Access_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder.class);
    }

    private int oneofAccessCase_ = 0;
    private java.lang.Object oneofAccess_;

    public enum OneofAccessCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ROLE(1),
      PERMISSION(2),
      ONEOFACCESS_NOT_SET(0);
      private final int value;

      private OneofAccessCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OneofAccessCase valueOf(int value) {
        return forNumber(value);
      }

      public static OneofAccessCase forNumber(int value) {
        switch (value) {
          case 1:
            return ROLE;
          case 2:
            return PERMISSION;
          case 0:
            return ONEOFACCESS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OneofAccessCase getOneofAccessCase() {
      return OneofAccessCase.forNumber(oneofAccessCase_);
    }

    public static final int ROLE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The role.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return Whether the role field is set.
     */
    public boolean hasRole() {
      return oneofAccessCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The role.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return The role.
     */
    public java.lang.String getRole() {
      java.lang.Object ref = "";
      if (oneofAccessCase_ == 1) {
        ref = oneofAccess_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (oneofAccessCase_ == 1) {
          oneofAccess_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The role.
     * </pre>
     *
     * <code>string role = 1;</code>
     *
     * @return The bytes for role.
     */
    public com.google.protobuf.ByteString getRoleBytes() {
      java.lang.Object ref = "";
      if (oneofAccessCase_ == 1) {
        ref = oneofAccess_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (oneofAccessCase_ == 1) {
          oneofAccess_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PERMISSION_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The permission.
     * </pre>
     *
     * <code>string permission = 2;</code>
     *
     * @return Whether the permission field is set.
     */
    public boolean hasPermission() {
      return oneofAccessCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The permission.
     * </pre>
     *
     * <code>string permission = 2;</code>
     *
     * @return The permission.
     */
    public java.lang.String getPermission() {
      java.lang.Object ref = "";
      if (oneofAccessCase_ == 2) {
        ref = oneofAccess_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (oneofAccessCase_ == 2) {
          oneofAccess_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The permission.
     * </pre>
     *
     * <code>string permission = 2;</code>
     *
     * @return The bytes for permission.
     */
    public com.google.protobuf.ByteString getPermissionBytes() {
      java.lang.Object ref = "";
      if (oneofAccessCase_ == 2) {
        ref = oneofAccess_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (oneofAccessCase_ == 2) {
          oneofAccess_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANALYSIS_STATE_FIELD_NUMBER = 3;
    private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysisState_;
    /**
     *
     *
     * <pre>
     * The analysis state of this access node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
     * </code>
     *
     * @return Whether the analysisState field is set.
     */
    @java.lang.Override
    public boolean hasAnalysisState() {
      return analysisState_ != null;
    }
    /**
     *
     *
     * <pre>
     * The analysis state of this access node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
     * </code>
     *
     * @return The analysisState.
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        getAnalysisState() {
      return analysisState_ == null
          ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
              .getDefaultInstance()
          : analysisState_;
    }
    /**
     *
     *
     * <pre>
     * The analysis state of this access node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
        getAnalysisStateOrBuilder() {
      return getAnalysisState();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (oneofAccessCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, oneofAccess_);
      }
      if (oneofAccessCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, oneofAccess_);
      }
      if (analysisState_ != null) {
        output.writeMessage(3, getAnalysisState());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (oneofAccessCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, oneofAccess_);
      }
      if (oneofAccessCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, oneofAccess_);
      }
      if (analysisState_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAnalysisState());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access) obj;

      if (hasAnalysisState() != other.hasAnalysisState()) return false;
      if (hasAnalysisState()) {
        if (!getAnalysisState().equals(other.getAnalysisState())) return false;
      }
      if (!getOneofAccessCase().equals(other.getOneofAccessCase())) return false;
      switch (oneofAccessCase_) {
        case 1:
          if (!getRole().equals(other.getRole())) return false;
          break;
        case 2:
          if (!getPermission().equals(other.getPermission())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAnalysisState()) {
        hash = (37 * hash) + ANALYSIS_STATE_FIELD_NUMBER;
        hash = (53 * hash) + getAnalysisState().hashCode();
      }
      switch (oneofAccessCase_) {
        case 1:
          hash = (37 * hash) + ROLE_FIELD_NUMBER;
          hash = (53 * hash) + getRole().hashCode();
          break;
        case 2:
          hash = (37 * hash) + PERMISSION_FIELD_NUMBER;
          hash = (53 * hash) + getPermission().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A role or permission that appears in an access control list.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Access_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Access_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder.class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (analysisStateBuilder_ == null) {
          analysisState_ = null;
        } else {
          analysisState_ = null;
          analysisStateBuilder_ = null;
        }
        oneofAccessCase_ = 0;
        oneofAccess_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Access_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access(this);
        if (oneofAccessCase_ == 1) {
          result.oneofAccess_ = oneofAccess_;
        }
        if (oneofAccessCase_ == 2) {
          result.oneofAccess_ = oneofAccess_;
        }
        if (analysisStateBuilder_ == null) {
          result.analysisState_ = analysisState_;
        } else {
          result.analysisState_ = analysisStateBuilder_.build();
        }
        result.oneofAccessCase_ = oneofAccessCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access) {
          return mergeFrom((com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.getDefaultInstance())
          return this;
        if (other.hasAnalysisState()) {
          mergeAnalysisState(other.getAnalysisState());
        }
        switch (other.getOneofAccessCase()) {
          case ROLE:
            {
              oneofAccessCase_ = 1;
              oneofAccess_ = other.oneofAccess_;
              onChanged();
              break;
            }
          case PERMISSION:
            {
              oneofAccessCase_ = 2;
              oneofAccess_ = other.oneofAccess_;
              onChanged();
              break;
            }
          case ONEOFACCESS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int oneofAccessCase_ = 0;
      private java.lang.Object oneofAccess_;

      public OneofAccessCase getOneofAccessCase() {
        return OneofAccessCase.forNumber(oneofAccessCase_);
      }

      public Builder clearOneofAccess() {
        oneofAccessCase_ = 0;
        oneofAccess_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The role.
       * </pre>
       *
       * <code>string role = 1;</code>
       *
       * @return Whether the role field is set.
       */
      @java.lang.Override
      public boolean hasRole() {
        return oneofAccessCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The role.
       * </pre>
       *
       * <code>string role = 1;</code>
       *
       * @return The role.
       */
      @java.lang.Override
      public java.lang.String getRole() {
        java.lang.Object ref = "";
        if (oneofAccessCase_ == 1) {
          ref = oneofAccess_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (oneofAccessCase_ == 1) {
            oneofAccess_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The role.
       * </pre>
       *
       * <code>string role = 1;</code>
       *
       * @return The bytes for role.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRoleBytes() {
        java.lang.Object ref = "";
        if (oneofAccessCase_ == 1) {
          ref = oneofAccess_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (oneofAccessCase_ == 1) {
            oneofAccess_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The role.
       * </pre>
       *
       * <code>string role = 1;</code>
       *
       * @param value The role to set.
       * @return This builder for chaining.
       */
      public Builder setRole(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneofAccessCase_ = 1;
        oneofAccess_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The role.
       * </pre>
       *
       * <code>string role = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRole() {
        if (oneofAccessCase_ == 1) {
          oneofAccessCase_ = 0;
          oneofAccess_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The role.
       * </pre>
       *
       * <code>string role = 1;</code>
       *
       * @param value The bytes for role to set.
       * @return This builder for chaining.
       */
      public Builder setRoleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        oneofAccessCase_ = 1;
        oneofAccess_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The permission.
       * </pre>
       *
       * <code>string permission = 2;</code>
       *
       * @return Whether the permission field is set.
       */
      @java.lang.Override
      public boolean hasPermission() {
        return oneofAccessCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The permission.
       * </pre>
       *
       * <code>string permission = 2;</code>
       *
       * @return The permission.
       */
      @java.lang.Override
      public java.lang.String getPermission() {
        java.lang.Object ref = "";
        if (oneofAccessCase_ == 2) {
          ref = oneofAccess_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (oneofAccessCase_ == 2) {
            oneofAccess_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The permission.
       * </pre>
       *
       * <code>string permission = 2;</code>
       *
       * @return The bytes for permission.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPermissionBytes() {
        java.lang.Object ref = "";
        if (oneofAccessCase_ == 2) {
          ref = oneofAccess_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (oneofAccessCase_ == 2) {
            oneofAccess_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The permission.
       * </pre>
       *
       * <code>string permission = 2;</code>
       *
       * @param value The permission to set.
       * @return This builder for chaining.
       */
      public Builder setPermission(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneofAccessCase_ = 2;
        oneofAccess_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The permission.
       * </pre>
       *
       * <code>string permission = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPermission() {
        if (oneofAccessCase_ == 2) {
          oneofAccessCase_ = 0;
          oneofAccess_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The permission.
       * </pre>
       *
       * <code>string permission = 2;</code>
       *
       * @param value The bytes for permission to set.
       * @return This builder for chaining.
       */
      public Builder setPermissionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        oneofAccessCase_ = 2;
        oneofAccess_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysisState_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>
          analysisStateBuilder_;
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       *
       * @return Whether the analysisState field is set.
       */
      public boolean hasAnalysisState() {
        return analysisStateBuilder_ != null || analysisState_ != null;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       *
       * @return The analysisState.
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
          getAnalysisState() {
        if (analysisStateBuilder_ == null) {
          return analysisState_ == null
              ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                  .getDefaultInstance()
              : analysisState_;
        } else {
          return analysisStateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      public Builder setAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState value) {
        if (analysisStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          analysisState_ = value;
          onChanged();
        } else {
          analysisStateBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      public Builder setAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
              builderForValue) {
        if (analysisStateBuilder_ == null) {
          analysisState_ = builderForValue.build();
          onChanged();
        } else {
          analysisStateBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      public Builder mergeAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState value) {
        if (analysisStateBuilder_ == null) {
          if (analysisState_ != null) {
            analysisState_ =
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.newBuilder(
                        analysisState_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            analysisState_ = value;
          }
          onChanged();
        } else {
          analysisStateBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      public Builder clearAnalysisState() {
        if (analysisStateBuilder_ == null) {
          analysisState_ = null;
          onChanged();
        } else {
          analysisState_ = null;
          analysisStateBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
          getAnalysisStateBuilder() {

        onChanged();
        return getAnalysisStateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
          getAnalysisStateOrBuilder() {
        if (analysisStateBuilder_ != null) {
          return analysisStateBuilder_.getMessageOrBuilder();
        } else {
          return analysisState_ == null
              ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                  .getDefaultInstance()
              : analysisState_;
        }
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this access node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>
          getAnalysisStateFieldBuilder() {
        if (analysisStateBuilder_ == null) {
          analysisStateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>(
                  getAnalysisState(), getParentForChildren(), isClean());
          analysisState_ = null;
        }
        return analysisStateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Access> PARSER =
        new com.google.protobuf.AbstractParser<Access>() {
          @java.lang.Override
          public Access parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Access(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Access> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Access> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EdgeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The source node of the edge.
     * </pre>
     *
     * <code>string source_node = 1;</code>
     *
     * @return The sourceNode.
     */
    java.lang.String getSourceNode();
    /**
     *
     *
     * <pre>
     * The source node of the edge.
     * </pre>
     *
     * <code>string source_node = 1;</code>
     *
     * @return The bytes for sourceNode.
     */
    com.google.protobuf.ByteString getSourceNodeBytes();

    /**
     *
     *
     * <pre>
     * The target node of the edge.
     * </pre>
     *
     * <code>string target_node = 2;</code>
     *
     * @return The targetNode.
     */
    java.lang.String getTargetNode();
    /**
     *
     *
     * <pre>
     * The target node of the edge.
     * </pre>
     *
     * <code>string target_node = 2;</code>
     *
     * @return The bytes for targetNode.
     */
    com.google.protobuf.ByteString getTargetNodeBytes();
  }
  /**
   *
   *
   * <pre>
   * A directional edge.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge}
   */
  public static final class Edge extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)
      EdgeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Edge.newBuilder() to construct.
    private Edge(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Edge() {
      sourceNode_ = "";
      targetNode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Edge();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Edge(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                sourceNode_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                targetNode_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Edge_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Edge_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder.class);
    }

    public static final int SOURCE_NODE_FIELD_NUMBER = 1;
    private volatile java.lang.Object sourceNode_;
    /**
     *
     *
     * <pre>
     * The source node of the edge.
     * </pre>
     *
     * <code>string source_node = 1;</code>
     *
     * @return The sourceNode.
     */
    @java.lang.Override
    public java.lang.String getSourceNode() {
      java.lang.Object ref = sourceNode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceNode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The source node of the edge.
     * </pre>
     *
     * <code>string source_node = 1;</code>
     *
     * @return The bytes for sourceNode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceNodeBytes() {
      java.lang.Object ref = sourceNode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceNode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_NODE_FIELD_NUMBER = 2;
    private volatile java.lang.Object targetNode_;
    /**
     *
     *
     * <pre>
     * The target node of the edge.
     * </pre>
     *
     * <code>string target_node = 2;</code>
     *
     * @return The targetNode.
     */
    @java.lang.Override
    public java.lang.String getTargetNode() {
      java.lang.Object ref = targetNode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetNode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The target node of the edge.
     * </pre>
     *
     * <code>string target_node = 2;</code>
     *
     * @return The bytes for targetNode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetNodeBytes() {
      java.lang.Object ref = targetNode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetNode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceNode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetNode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetNode_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceNode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetNode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetNode_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge) obj;

      if (!getSourceNode().equals(other.getSourceNode())) return false;
      if (!getTargetNode().equals(other.getTargetNode())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_NODE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNode().hashCode();
      hash = (37 * hash) + TARGET_NODE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetNode().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A directional edge.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Edge_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Edge_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder.class);
      }

      // Construct using com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        sourceNode_ = "";

        targetNode_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Edge_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge(this);
        result.sourceNode_ = sourceNode_;
        result.targetNode_ = targetNode_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge) {
          return mergeFrom((com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.getDefaultInstance())
          return this;
        if (!other.getSourceNode().isEmpty()) {
          sourceNode_ = other.sourceNode_;
          onChanged();
        }
        if (!other.getTargetNode().isEmpty()) {
          targetNode_ = other.targetNode_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object sourceNode_ = "";
      /**
       *
       *
       * <pre>
       * The source node of the edge.
       * </pre>
       *
       * <code>string source_node = 1;</code>
       *
       * @return The sourceNode.
       */
      public java.lang.String getSourceNode() {
        java.lang.Object ref = sourceNode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceNode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source node of the edge.
       * </pre>
       *
       * <code>string source_node = 1;</code>
       *
       * @return The bytes for sourceNode.
       */
      public com.google.protobuf.ByteString getSourceNodeBytes() {
        java.lang.Object ref = sourceNode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceNode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source node of the edge.
       * </pre>
       *
       * <code>string source_node = 1;</code>
       *
       * @param value The sourceNode to set.
       * @return This builder for chaining.
       */
      public Builder setSourceNode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        sourceNode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source node of the edge.
       * </pre>
       *
       * <code>string source_node = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceNode() {

        sourceNode_ = getDefaultInstance().getSourceNode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source node of the edge.
       * </pre>
       *
       * <code>string source_node = 1;</code>
       *
       * @param value The bytes for sourceNode to set.
       * @return This builder for chaining.
       */
      public Builder setSourceNodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        sourceNode_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object targetNode_ = "";
      /**
       *
       *
       * <pre>
       * The target node of the edge.
       * </pre>
       *
       * <code>string target_node = 2;</code>
       *
       * @return The targetNode.
       */
      public java.lang.String getTargetNode() {
        java.lang.Object ref = targetNode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetNode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The target node of the edge.
       * </pre>
       *
       * <code>string target_node = 2;</code>
       *
       * @return The bytes for targetNode.
       */
      public com.google.protobuf.ByteString getTargetNodeBytes() {
        java.lang.Object ref = targetNode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetNode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The target node of the edge.
       * </pre>
       *
       * <code>string target_node = 2;</code>
       *
       * @param value The targetNode to set.
       * @return This builder for chaining.
       */
      public Builder setTargetNode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        targetNode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The target node of the edge.
       * </pre>
       *
       * <code>string target_node = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetNode() {

        targetNode_ = getDefaultInstance().getTargetNode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The target node of the edge.
       * </pre>
       *
       * <code>string target_node = 2;</code>
       *
       * @param value The bytes for targetNode to set.
       * @return This builder for chaining.
       */
      public Builder setTargetNodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        targetNode_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Edge> PARSER =
        new com.google.protobuf.AbstractParser<Edge>() {
          @java.lang.Override
          public Edge parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Edge(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Edge> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Edge> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IdentityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The identity name in any form of members appear in
     * [IAM policy
     * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
     * as:
     * - user:foo&#64;google.com
     * - group:group1&#64;google.com
     * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
     * - projectOwner:some_project_id
     * - domain:google.com
     * - allUsers
     * - etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The identity name in any form of members appear in
     * [IAM policy
     * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
     * as:
     * - user:foo&#64;google.com
     * - group:group1&#64;google.com
     * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
     * - projectOwner:some_project_id
     * - domain:google.com
     * - allUsers
     * - etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The analysis state of this identity node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return Whether the analysisState field is set.
     */
    boolean hasAnalysisState();
    /**
     *
     *
     * <pre>
     * The analysis state of this identity node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return The analysisState.
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState getAnalysisState();
    /**
     *
     *
     * <pre>
     * The analysis state of this identity node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
        getAnalysisStateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * An identity that appears in an access control list.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity}
   */
  public static final class Identity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)
      IdentityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Identity.newBuilder() to construct.
    private Identity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Identity() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Identity();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Identity(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
                    subBuilder = null;
                if (analysisState_ != null) {
                  subBuilder = analysisState_.toBuilder();
                }
                analysisState_ =
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(analysisState_);
                  analysisState_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Identity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Identity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * The identity name in any form of members appear in
     * [IAM policy
     * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
     * as:
     * - user:foo&#64;google.com
     * - group:group1&#64;google.com
     * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
     * - projectOwner:some_project_id
     * - domain:google.com
     * - allUsers
     * - etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The identity name in any form of members appear in
     * [IAM policy
     * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
     * as:
     * - user:foo&#64;google.com
     * - group:group1&#64;google.com
     * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
     * - projectOwner:some_project_id
     * - domain:google.com
     * - allUsers
     * - etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANALYSIS_STATE_FIELD_NUMBER = 2;
    private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysisState_;
    /**
     *
     *
     * <pre>
     * The analysis state of this identity node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return Whether the analysisState field is set.
     */
    @java.lang.Override
    public boolean hasAnalysisState() {
      return analysisState_ != null;
    }
    /**
     *
     *
     * <pre>
     * The analysis state of this identity node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     *
     * @return The analysisState.
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
        getAnalysisState() {
      return analysisState_ == null
          ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
              .getDefaultInstance()
          : analysisState_;
    }
    /**
     *
     *
     * <pre>
     * The analysis state of this identity node.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
        getAnalysisStateOrBuilder() {
      return getAnalysisState();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (analysisState_ != null) {
        output.writeMessage(2, getAnalysisState());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (analysisState_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAnalysisState());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity) obj;

      if (!getName().equals(other.getName())) return false;
      if (hasAnalysisState() != other.hasAnalysisState()) return false;
      if (hasAnalysisState()) {
        if (!getAnalysisState().equals(other.getAnalysisState())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasAnalysisState()) {
        hash = (37 * hash) + ANALYSIS_STATE_FIELD_NUMBER;
        hash = (53 * hash) + getAnalysisState().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An identity that appears in an access control list.
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Identity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Identity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder.class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        if (analysisStateBuilder_ == null) {
          analysisState_ = null;
        } else {
          analysisState_ = null;
          analysisStateBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_Identity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity(this);
        result.name_ = name_;
        if (analysisStateBuilder_ == null) {
          result.analysisState_ = analysisState_;
        } else {
          result.analysisState_ = analysisStateBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.hasAnalysisState()) {
          mergeAnalysisState(other.getAnalysisState());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The identity name in any form of members appear in
       * [IAM policy
       * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
       * as:
       * - user:foo&#64;google.com
       * - group:group1&#64;google.com
       * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
       * - projectOwner:some_project_id
       * - domain:google.com
       * - allUsers
       * - etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The identity name in any form of members appear in
       * [IAM policy
       * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
       * as:
       * - user:foo&#64;google.com
       * - group:group1&#64;google.com
       * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
       * - projectOwner:some_project_id
       * - domain:google.com
       * - allUsers
       * - etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The identity name in any form of members appear in
       * [IAM policy
       * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
       * as:
       * - user:foo&#64;google.com
       * - group:group1&#64;google.com
       * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
       * - projectOwner:some_project_id
       * - domain:google.com
       * - allUsers
       * - etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The identity name in any form of members appear in
       * [IAM policy
       * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
       * as:
       * - user:foo&#64;google.com
       * - group:group1&#64;google.com
       * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
       * - projectOwner:some_project_id
       * - domain:google.com
       * - allUsers
       * - etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The identity name in any form of members appear in
       * [IAM policy
       * binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
       * as:
       * - user:foo&#64;google.com
       * - group:group1&#64;google.com
       * - serviceAccount:s1&#64;prj1.iam.gserviceaccount.com
       * - projectOwner:some_project_id
       * - domain:google.com
       * - allUsers
       * - etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysisState_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>
          analysisStateBuilder_;
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       *
       * @return Whether the analysisState field is set.
       */
      public boolean hasAnalysisState() {
        return analysisStateBuilder_ != null || analysisState_ != null;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       *
       * @return The analysisState.
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
          getAnalysisState() {
        if (analysisStateBuilder_ == null) {
          return analysisState_ == null
              ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                  .getDefaultInstance()
              : analysisState_;
        } else {
          return analysisStateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder setAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState value) {
        if (analysisStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          analysisState_ = value;
          onChanged();
        } else {
          analysisStateBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder setAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
              builderForValue) {
        if (analysisStateBuilder_ == null) {
          analysisState_ = builderForValue.build();
          onChanged();
        } else {
          analysisStateBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder mergeAnalysisState(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState value) {
        if (analysisStateBuilder_ == null) {
          if (analysisState_ != null) {
            analysisState_ =
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.newBuilder(
                        analysisState_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            analysisState_ = value;
          }
          onChanged();
        } else {
          analysisStateBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public Builder clearAnalysisState() {
        if (analysisStateBuilder_ == null) {
          analysisState_ = null;
          onChanged();
        } else {
          analysisState_ = null;
          analysisStateBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder
          getAnalysisStateBuilder() {

        onChanged();
        return getAnalysisStateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder
          getAnalysisStateOrBuilder() {
        if (analysisStateBuilder_ != null) {
          return analysisStateBuilder_.getMessageOrBuilder();
        } else {
          return analysisState_ == null
              ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
                  .getDefaultInstance()
              : analysisState_;
        }
      }
      /**
       *
       *
       * <pre>
       * The analysis state of this identity node.
       * </pre>
       *
       * <code>
       * .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState analysis_state = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>
          getAnalysisStateFieldBuilder() {
        if (analysisStateBuilder_ == null) {
          analysisStateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisStateOrBuilder>(
                  getAnalysisState(), getParentForChildren(), isClean());
          analysisState_ = null;
        }
        return analysisStateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Identity> PARSER =
        new com.google.protobuf.AbstractParser<Identity>() {
          @java.lang.Override
          public Identity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Identity(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Identity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Identity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AccessControlListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>
        getResourcesList();
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource getResources(int index);
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    int getResourcesCount();
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder>
        getResourcesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder
        getResourcesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>
        getAccessesList();
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access getAccesses(int index);
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    int getAccessesCount();
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder>
        getAccessesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder getAccessesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
        getResourceEdgesList();
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge getResourceEdges(int index);
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    int getResourceEdgesCount();
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    java.util.List<? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
        getResourceEdgesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder
        getResourceEdgesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * An access control list, derived from the above IAM policy binding, which
   * contains a set of resources and accesses. May include one
   * item from each set to compose an access control entry.
   * NOTICE that there could be multiple access control lists for one IAM policy
   * binding. The access control lists are created based on resource and access
   * combinations.
   * For example, assume we have the following cases in one IAM policy binding:
   * - Permission P1 and P2 apply to resource R1 and R2;
   * - Permission P3 applies to resource R2 and R3;
   * This will result in the following access control lists:
   * - AccessControlList 1: [R1, R2], [P1, P2]
   * - AccessControlList 2: [R2, R3], [P3]
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList}
   */
  public static final class AccessControlList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)
      AccessControlListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AccessControlList.newBuilder() to construct.
    private AccessControlList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AccessControlList() {
      resources_ = java.util.Collections.emptyList();
      accesses_ = java.util.Collections.emptyList();
      resourceEdges_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AccessControlList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private AccessControlList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  resources_ =
                      new java.util.ArrayList<
                          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>();
                  mutable_bitField0_ |= 0x00000001;
                }
                resources_.add(
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.parser(),
                        extensionRegistry));
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  accesses_ =
                      new java.util.ArrayList<
                          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>();
                  mutable_bitField0_ |= 0x00000002;
                }
                accesses_.add(
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.parser(),
                        extensionRegistry));
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                  resourceEdges_ =
                      new java.util.ArrayList<
                          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>();
                  mutable_bitField0_ |= 0x00000004;
                }
                resourceEdges_.add(
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          resources_ = java.util.Collections.unmodifiableList(resources_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          accesses_ = java.util.Collections.unmodifiableList(accesses_);
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          resourceEdges_ = java.util.Collections.unmodifiableList(resourceEdges_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AccessControlList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AccessControlList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
                  .class);
    }

    public static final int RESOURCES_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>
        resources_;
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>
        getResourcesList() {
      return resources_;
    }
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder>
        getResourcesOrBuilderList() {
      return resources_;
    }
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    @java.lang.Override
    public int getResourcesCount() {
      return resources_.size();
    }
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource getResources(
        int index) {
      return resources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The resources that match one of the following conditions:
     * - The resource_selector, if it is specified in request;
     * - Otherwise, resources reachable from the policy attached resource.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder
        getResourcesOrBuilder(int index) {
      return resources_.get(index);
    }

    public static final int ACCESSES_FIELD_NUMBER = 2;
    private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>
        accesses_;
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>
        getAccessesList() {
      return accesses_;
    }
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder>
        getAccessesOrBuilderList() {
      return accesses_;
    }
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    @java.lang.Override
    public int getAccessesCount() {
      return accesses_.size();
    }
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access getAccesses(int index) {
      return accesses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The accesses that match one of the following conditions:
     * - The access_selector, if it is specified in request;
     * - Otherwise, access specifiers reachable from the policy binding's role.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder
        getAccessesOrBuilder(int index) {
      return accesses_.get(index);
    }

    public static final int RESOURCE_EDGES_FIELD_NUMBER = 3;
    private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
        resourceEdges_;
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
        getResourceEdgesList() {
      return resourceEdges_;
    }
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
        getResourceEdgesOrBuilderList() {
      return resourceEdges_;
    }
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    @java.lang.Override
    public int getResourceEdgesCount() {
      return resourceEdges_.size();
    }
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge getResourceEdges(
        int index) {
      return resourceEdges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Resource edges of the graph starting from the policy attached
     * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
     * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
     * contains the full resource name of a child resource. This field is
     * present only if the output_resource_edges option is enabled in request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder
        getResourceEdgesOrBuilder(int index) {
      return resourceEdges_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < resources_.size(); i++) {
        output.writeMessage(1, resources_.get(i));
      }
      for (int i = 0; i < accesses_.size(); i++) {
        output.writeMessage(2, accesses_.get(i));
      }
      for (int i = 0; i < resourceEdges_.size(); i++) {
        output.writeMessage(3, resourceEdges_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < resources_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, resources_.get(i));
      }
      for (int i = 0; i < accesses_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, accesses_.get(i));
      }
      for (int i = 0; i < resourceEdges_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, resourceEdges_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList) obj;

      if (!getResourcesList().equals(other.getResourcesList())) return false;
      if (!getAccessesList().equals(other.getAccessesList())) return false;
      if (!getResourceEdgesList().equals(other.getResourceEdgesList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getResourcesCount() > 0) {
        hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getResourcesList().hashCode();
      }
      if (getAccessesCount() > 0) {
        hash = (37 * hash) + ACCESSES_FIELD_NUMBER;
        hash = (53 * hash) + getAccessesList().hashCode();
      }
      if (getResourceEdgesCount() > 0) {
        hash = (37 * hash) + RESOURCE_EDGES_FIELD_NUMBER;
        hash = (53 * hash) + getResourceEdgesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An access control list, derived from the above IAM policy binding, which
     * contains a set of resources and accesses. May include one
     * item from each set to compose an access control entry.
     * NOTICE that there could be multiple access control lists for one IAM policy
     * binding. The access control lists are created based on resource and access
     * combinations.
     * For example, assume we have the following cases in one IAM policy binding:
     * - Permission P1 and P2 apply to resource R1 and R2;
     * - Permission P3 applies to resource R2 and R3;
     * This will result in the following access control lists:
     * - AccessControlList 1: [R1, R2], [P1, P2]
     * - AccessControlList 2: [R2, R3], [P3]
     * </pre>
     *
     * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AccessControlList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AccessControlList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getResourcesFieldBuilder();
          getAccessesFieldBuilder();
          getResourceEdgesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (resourcesBuilder_ == null) {
          resources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          resourcesBuilder_.clear();
        }
        if (accessesBuilder_ == null) {
          accesses_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          accessesBuilder_.clear();
        }
        if (resourceEdgesBuilder_ == null) {
          resourceEdges_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          resourceEdgesBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_AccessControlList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
          buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList(this);
        int from_bitField0_ = bitField0_;
        if (resourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            resources_ = java.util.Collections.unmodifiableList(resources_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.resources_ = resources_;
        } else {
          result.resources_ = resourcesBuilder_.build();
        }
        if (accessesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            accesses_ = java.util.Collections.unmodifiableList(accesses_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.accesses_ = accesses_;
        } else {
          result.accesses_ = accessesBuilder_.build();
        }
        if (resourceEdgesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            resourceEdges_ = java.util.Collections.unmodifiableList(resourceEdges_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.resourceEdges_ = resourceEdges_;
        } else {
          result.resourceEdges_ = resourceEdgesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
                .getDefaultInstance()) return this;
        if (resourcesBuilder_ == null) {
          if (!other.resources_.isEmpty()) {
            if (resources_.isEmpty()) {
              resources_ = other.resources_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureResourcesIsMutable();
              resources_.addAll(other.resources_);
            }
            onChanged();
          }
        } else {
          if (!other.resources_.isEmpty()) {
            if (resourcesBuilder_.isEmpty()) {
              resourcesBuilder_.dispose();
              resourcesBuilder_ = null;
              resources_ = other.resources_;
              bitField0_ = (bitField0_ & ~0x00000001);
              resourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getResourcesFieldBuilder()
                      : null;
            } else {
              resourcesBuilder_.addAllMessages(other.resources_);
            }
          }
        }
        if (accessesBuilder_ == null) {
          if (!other.accesses_.isEmpty()) {
            if (accesses_.isEmpty()) {
              accesses_ = other.accesses_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureAccessesIsMutable();
              accesses_.addAll(other.accesses_);
            }
            onChanged();
          }
        } else {
          if (!other.accesses_.isEmpty()) {
            if (accessesBuilder_.isEmpty()) {
              accessesBuilder_.dispose();
              accessesBuilder_ = null;
              accesses_ = other.accesses_;
              bitField0_ = (bitField0_ & ~0x00000002);
              accessesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAccessesFieldBuilder()
                      : null;
            } else {
              accessesBuilder_.addAllMessages(other.accesses_);
            }
          }
        }
        if (resourceEdgesBuilder_ == null) {
          if (!other.resourceEdges_.isEmpty()) {
            if (resourceEdges_.isEmpty()) {
              resourceEdges_ = other.resourceEdges_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureResourceEdgesIsMutable();
              resourceEdges_.addAll(other.resourceEdges_);
            }
            onChanged();
          }
        } else {
          if (!other.resourceEdges_.isEmpty()) {
            if (resourceEdgesBuilder_.isEmpty()) {
              resourceEdgesBuilder_.dispose();
              resourceEdgesBuilder_ = null;
              resourceEdges_ = other.resourceEdges_;
              bitField0_ = (bitField0_ & ~0x00000004);
              resourceEdgesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getResourceEdgesFieldBuilder()
                      : null;
            } else {
              resourceEdgesBuilder_.addAllMessages(other.resourceEdges_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>
          resources_ = java.util.Collections.emptyList();

      private void ensureResourcesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          resources_ =
              new java.util.ArrayList<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>(resources_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder>
          resourcesBuilder_;

      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>
          getResourcesList() {
        if (resourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(resources_);
        } else {
          return resourcesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public int getResourcesCount() {
        if (resourcesBuilder_ == null) {
          return resources_.size();
        } else {
          return resourcesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource getResources(
          int index) {
        if (resourcesBuilder_ == null) {
          return resources_.get(index);
        } else {
          return resourcesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder setResources(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource value) {
        if (resourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourcesIsMutable();
          resources_.set(index, value);
          onChanged();
        } else {
          resourcesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder setResources(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder
              builderForValue) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.set(index, builderForValue.build());
          onChanged();
        } else {
          resourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder addResources(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource value) {
        if (resourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourcesIsMutable();
          resources_.add(value);
          onChanged();
        } else {
          resourcesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder addResources(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource value) {
        if (resourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourcesIsMutable();
          resources_.add(index, value);
          onChanged();
        } else {
          resourcesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder addResources(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder
              builderForValue) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.add(builderForValue.build());
          onChanged();
        } else {
          resourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder addResources(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder
              builderForValue) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.add(index, builderForValue.build());
          onChanged();
        } else {
          resourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder addAllResources(
          java.lang.Iterable<
                  ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource>
              values) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resources_);
          onChanged();
        } else {
          resourcesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder clearResources() {
        if (resourcesBuilder_ == null) {
          resources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          resourcesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public Builder removeResources(int index) {
        if (resourcesBuilder_ == null) {
          ensureResourcesIsMutable();
          resources_.remove(index);
          onChanged();
        } else {
          resourcesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder
          getResourcesBuilder(int index) {
        return getResourcesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder
          getResourcesOrBuilder(int index) {
        if (resourcesBuilder_ == null) {
          return resources_.get(index);
        } else {
          return resourcesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder>
          getResourcesOrBuilderList() {
        if (resourcesBuilder_ != null) {
          return resourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(resources_);
        }
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder
          addResourcesBuilder() {
        return getResourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder
          addResourcesBuilder(int index) {
        return getResourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The resources that match one of the following conditions:
       * - The resource_selector, if it is specified in request;
       * - Otherwise, resources reachable from the policy attached resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource resources = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder>
          getResourcesBuilderList() {
        return getResourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder>
          getResourcesFieldBuilder() {
        if (resourcesBuilder_ == null) {
          resourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Resource.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.ResourceOrBuilder>(
                  resources_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          resources_ = null;
        }
        return resourcesBuilder_;
      }

      private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>
          accesses_ = java.util.Collections.emptyList();

      private void ensureAccessesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          accesses_ =
              new java.util.ArrayList<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>(accesses_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder>
          accessesBuilder_;

      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>
          getAccessesList() {
        if (accessesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(accesses_);
        } else {
          return accessesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public int getAccessesCount() {
        if (accessesBuilder_ == null) {
          return accesses_.size();
        } else {
          return accessesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access getAccesses(
          int index) {
        if (accessesBuilder_ == null) {
          return accesses_.get(index);
        } else {
          return accessesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder setAccesses(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access value) {
        if (accessesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAccessesIsMutable();
          accesses_.set(index, value);
          onChanged();
        } else {
          accessesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder setAccesses(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder builderForValue) {
        if (accessesBuilder_ == null) {
          ensureAccessesIsMutable();
          accesses_.set(index, builderForValue.build());
          onChanged();
        } else {
          accessesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder addAccesses(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access value) {
        if (accessesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAccessesIsMutable();
          accesses_.add(value);
          onChanged();
        } else {
          accessesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder addAccesses(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access value) {
        if (accessesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAccessesIsMutable();
          accesses_.add(index, value);
          onChanged();
        } else {
          accessesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder addAccesses(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder builderForValue) {
        if (accessesBuilder_ == null) {
          ensureAccessesIsMutable();
          accesses_.add(builderForValue.build());
          onChanged();
        } else {
          accessesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder addAccesses(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder builderForValue) {
        if (accessesBuilder_ == null) {
          ensureAccessesIsMutable();
          accesses_.add(index, builderForValue.build());
          onChanged();
        } else {
          accessesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder addAllAccesses(
          java.lang.Iterable<
                  ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access>
              values) {
        if (accessesBuilder_ == null) {
          ensureAccessesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accesses_);
          onChanged();
        } else {
          accessesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder clearAccesses() {
        if (accessesBuilder_ == null) {
          accesses_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          accessesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public Builder removeAccesses(int index) {
        if (accessesBuilder_ == null) {
          ensureAccessesIsMutable();
          accesses_.remove(index);
          onChanged();
        } else {
          accessesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder
          getAccessesBuilder(int index) {
        return getAccessesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder
          getAccessesOrBuilder(int index) {
        if (accessesBuilder_ == null) {
          return accesses_.get(index);
        } else {
          return accessesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder>
          getAccessesOrBuilderList() {
        if (accessesBuilder_ != null) {
          return accessesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(accesses_);
        }
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder
          addAccessesBuilder() {
        return getAccessesFieldBuilder()
            .addBuilder(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder
          addAccessesBuilder(int index) {
        return getAccessesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The accesses that match one of the following conditions:
       * - The access_selector, if it is specified in request;
       * - Otherwise, access specifiers reachable from the policy binding's role.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access accesses = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder>
          getAccessesBuilderList() {
        return getAccessesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder>
          getAccessesFieldBuilder() {
        if (accessesBuilder_ == null) {
          accessesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Access.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessOrBuilder>(
                  accesses_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          accesses_ = null;
        }
        return accessesBuilder_;
      }

      private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
          resourceEdges_ = java.util.Collections.emptyList();

      private void ensureResourceEdgesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          resourceEdges_ =
              new java.util.ArrayList<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>(resourceEdges_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
          resourceEdgesBuilder_;

      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
          getResourceEdgesList() {
        if (resourceEdgesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(resourceEdges_);
        } else {
          return resourceEdgesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public int getResourceEdgesCount() {
        if (resourceEdgesBuilder_ == null) {
          return resourceEdges_.size();
        } else {
          return resourceEdgesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge getResourceEdges(
          int index) {
        if (resourceEdgesBuilder_ == null) {
          return resourceEdges_.get(index);
        } else {
          return resourceEdgesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder setResourceEdges(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge value) {
        if (resourceEdgesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourceEdgesIsMutable();
          resourceEdges_.set(index, value);
          onChanged();
        } else {
          resourceEdgesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder setResourceEdges(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder builderForValue) {
        if (resourceEdgesBuilder_ == null) {
          ensureResourceEdgesIsMutable();
          resourceEdges_.set(index, builderForValue.build());
          onChanged();
        } else {
          resourceEdgesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder addResourceEdges(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge value) {
        if (resourceEdgesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourceEdgesIsMutable();
          resourceEdges_.add(value);
          onChanged();
        } else {
          resourceEdgesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder addResourceEdges(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge value) {
        if (resourceEdgesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResourceEdgesIsMutable();
          resourceEdges_.add(index, value);
          onChanged();
        } else {
          resourceEdgesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder addResourceEdges(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder builderForValue) {
        if (resourceEdgesBuilder_ == null) {
          ensureResourceEdgesIsMutable();
          resourceEdges_.add(builderForValue.build());
          onChanged();
        } else {
          resourceEdgesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder addResourceEdges(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder builderForValue) {
        if (resourceEdgesBuilder_ == null) {
          ensureResourceEdgesIsMutable();
          resourceEdges_.add(index, builderForValue.build());
          onChanged();
        } else {
          resourceEdgesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder addAllResourceEdges(
          java.lang.Iterable<
                  ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
              values) {
        if (resourceEdgesBuilder_ == null) {
          ensureResourceEdgesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceEdges_);
          onChanged();
        } else {
          resourceEdgesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder clearResourceEdges() {
        if (resourceEdgesBuilder_ == null) {
          resourceEdges_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          resourceEdgesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public Builder removeResourceEdges(int index) {
        if (resourceEdgesBuilder_ == null) {
          ensureResourceEdgesIsMutable();
          resourceEdges_.remove(index);
          onChanged();
        } else {
          resourceEdgesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder
          getResourceEdgesBuilder(int index) {
        return getResourceEdgesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder
          getResourceEdgesOrBuilder(int index) {
        if (resourceEdgesBuilder_ == null) {
          return resourceEdges_.get(index);
        } else {
          return resourceEdgesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
          getResourceEdgesOrBuilderList() {
        if (resourceEdgesBuilder_ != null) {
          return resourceEdgesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(resourceEdges_);
        }
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder
          addResourceEdgesBuilder() {
        return getResourceEdgesFieldBuilder()
            .addBuilder(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder
          addResourceEdgesBuilder(int index) {
        return getResourceEdgesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Resource edges of the graph starting from the policy attached
       * resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node] contains
       * the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node]
       * contains the full resource name of a child resource. This field is
       * present only if the output_resource_edges option is enabled in request.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge resource_edges = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder>
          getResourceEdgesBuilderList() {
        return getResourceEdgesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
          getResourceEdgesFieldBuilder() {
        if (resourceEdgesBuilder_ == null) {
          resourceEdgesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>(
                  resourceEdges_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          resourceEdges_ = null;
        }
        return resourceEdgesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AccessControlList> PARSER =
        new com.google.protobuf.AbstractParser<AccessControlList>() {
          @java.lang.Override
          public AccessControlList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new AccessControlList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<AccessControlList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AccessControlList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IdentityListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>
        getIdentitiesList();
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity getIdentities(int index);
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    int getIdentitiesCount();
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder>
        getIdentitiesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder
        getIdentitiesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
        getGroupEdgesList();
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge getGroupEdges(int index);
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    int getGroupEdgesCount();
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    java.util.List<? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
        getGroupEdgesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder getGroupEdgesOrBuilder(
        int index);
  }
  /** Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList} */
  public static final class IdentityList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)
      IdentityListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IdentityList.newBuilder() to construct.
    private IdentityList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IdentityList() {
      identities_ = java.util.Collections.emptyList();
      groupEdges_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IdentityList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IdentityList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  identities_ =
                      new java.util.ArrayList<
                          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>();
                  mutable_bitField0_ |= 0x00000001;
                }
                identities_.add(
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.parser(),
                        extensionRegistry));
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  groupEdges_ =
                      new java.util.ArrayList<
                          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>();
                  mutable_bitField0_ |= 0x00000002;
                }
                groupEdges_.add(
                    input.readMessage(
                        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          identities_ = java.util.Collections.unmodifiableList(identities_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          groupEdges_ = java.util.Collections.unmodifiableList(groupEdges_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_IdentityList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_IdentityList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder.class);
    }

    public static final int IDENTITIES_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>
        identities_;
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>
        getIdentitiesList() {
      return identities_;
    }
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder>
        getIdentitiesOrBuilderList() {
      return identities_;
    }
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    @java.lang.Override
    public int getIdentitiesCount() {
      return identities_.size();
    }
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity getIdentities(
        int index) {
      return identities_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Only the identities that match one of the following conditions will be
     * presented:
     * - The identity_selector, if it is specified in request;
     * - Otherwise, identities reachable from the policy binding's members.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder
        getIdentitiesOrBuilder(int index) {
      return identities_.get(index);
    }

    public static final int GROUP_EDGES_FIELD_NUMBER = 2;
    private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
        groupEdges_;
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
        getGroupEdgesList() {
      return groupEdges_;
    }
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
        getGroupEdgesOrBuilderList() {
      return groupEdges_;
    }
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    @java.lang.Override
    public int getGroupEdgesCount() {
      return groupEdges_.size();
    }
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge getGroupEdges(int index) {
      return groupEdges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Group identity edges of the graph starting from the binding's
     * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
     * contains a group, such as "group:parent&#64;google.com". The
     * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
     * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
     * This field is present only if the output_group_edges option is enabled in
     * request.
     * </pre>
     *
     * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder
        getGroupEdgesOrBuilder(int index) {
      return groupEdges_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < identities_.size(); i++) {
        output.writeMessage(1, identities_.get(i));
      }
      for (int i = 0; i < groupEdges_.size(); i++) {
        output.writeMessage(2, groupEdges_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < identities_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, identities_.get(i));
      }
      for (int i = 0; i < groupEdges_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, groupEdges_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)) {
        return super.equals(obj);
      }
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList other =
          (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList) obj;

      if (!getIdentitiesList().equals(other.getIdentitiesList())) return false;
      if (!getGroupEdgesList().equals(other.getGroupEdgesList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getIdentitiesCount() > 0) {
        hash = (37 * hash) + IDENTITIES_FIELD_NUMBER;
        hash = (53 * hash) + getIdentitiesList().hashCode();
      }
      if (getGroupEdgesCount() > 0) {
        hash = (37 * hash) + GROUP_EDGES_FIELD_NUMBER;
        hash = (53 * hash) + getGroupEdgesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_IdentityList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_IdentityList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.class,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getIdentitiesFieldBuilder();
          getGroupEdgesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (identitiesBuilder_ == null) {
          identities_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          identitiesBuilder_.clear();
        }
        if (groupEdgesBuilder_ == null) {
          groupEdges_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          groupEdgesBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.asset.v1p4beta1.AssetProto
            .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_IdentityList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
          getDefaultInstanceForType() {
        return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList build() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList buildPartial() {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList result =
            new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList(this);
        int from_bitField0_ = bitField0_;
        if (identitiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            identities_ = java.util.Collections.unmodifiableList(identities_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.identities_ = identities_;
        } else {
          result.identities_ = identitiesBuilder_.build();
        }
        if (groupEdgesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            groupEdges_ = java.util.Collections.unmodifiableList(groupEdges_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.groupEdges_ = groupEdges_;
        } else {
          result.groupEdges_ = groupEdgesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList) {
          return mergeFrom(
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList other) {
        if (other
            == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
                .getDefaultInstance()) return this;
        if (identitiesBuilder_ == null) {
          if (!other.identities_.isEmpty()) {
            if (identities_.isEmpty()) {
              identities_ = other.identities_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureIdentitiesIsMutable();
              identities_.addAll(other.identities_);
            }
            onChanged();
          }
        } else {
          if (!other.identities_.isEmpty()) {
            if (identitiesBuilder_.isEmpty()) {
              identitiesBuilder_.dispose();
              identitiesBuilder_ = null;
              identities_ = other.identities_;
              bitField0_ = (bitField0_ & ~0x00000001);
              identitiesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getIdentitiesFieldBuilder()
                      : null;
            } else {
              identitiesBuilder_.addAllMessages(other.identities_);
            }
          }
        }
        if (groupEdgesBuilder_ == null) {
          if (!other.groupEdges_.isEmpty()) {
            if (groupEdges_.isEmpty()) {
              groupEdges_ = other.groupEdges_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureGroupEdgesIsMutable();
              groupEdges_.addAll(other.groupEdges_);
            }
            onChanged();
          }
        } else {
          if (!other.groupEdges_.isEmpty()) {
            if (groupEdgesBuilder_.isEmpty()) {
              groupEdgesBuilder_.dispose();
              groupEdgesBuilder_ = null;
              groupEdges_ = other.groupEdges_;
              bitField0_ = (bitField0_ & ~0x00000002);
              groupEdgesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getGroupEdgesFieldBuilder()
                      : null;
            } else {
              groupEdgesBuilder_.addAllMessages(other.groupEdges_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>
          identities_ = java.util.Collections.emptyList();

      private void ensureIdentitiesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          identities_ =
              new java.util.ArrayList<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>(identities_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder>
          identitiesBuilder_;

      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>
          getIdentitiesList() {
        if (identitiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(identities_);
        } else {
          return identitiesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public int getIdentitiesCount() {
        if (identitiesBuilder_ == null) {
          return identities_.size();
        } else {
          return identitiesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity getIdentities(
          int index) {
        if (identitiesBuilder_ == null) {
          return identities_.get(index);
        } else {
          return identitiesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder setIdentities(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity value) {
        if (identitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIdentitiesIsMutable();
          identities_.set(index, value);
          onChanged();
        } else {
          identitiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder setIdentities(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder
              builderForValue) {
        if (identitiesBuilder_ == null) {
          ensureIdentitiesIsMutable();
          identities_.set(index, builderForValue.build());
          onChanged();
        } else {
          identitiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder addIdentities(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity value) {
        if (identitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIdentitiesIsMutable();
          identities_.add(value);
          onChanged();
        } else {
          identitiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder addIdentities(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity value) {
        if (identitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIdentitiesIsMutable();
          identities_.add(index, value);
          onChanged();
        } else {
          identitiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder addIdentities(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder
              builderForValue) {
        if (identitiesBuilder_ == null) {
          ensureIdentitiesIsMutable();
          identities_.add(builderForValue.build());
          onChanged();
        } else {
          identitiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder addIdentities(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder
              builderForValue) {
        if (identitiesBuilder_ == null) {
          ensureIdentitiesIsMutable();
          identities_.add(index, builderForValue.build());
          onChanged();
        } else {
          identitiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder addAllIdentities(
          java.lang.Iterable<
                  ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity>
              values) {
        if (identitiesBuilder_ == null) {
          ensureIdentitiesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, identities_);
          onChanged();
        } else {
          identitiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder clearIdentities() {
        if (identitiesBuilder_ == null) {
          identities_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          identitiesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public Builder removeIdentities(int index) {
        if (identitiesBuilder_ == null) {
          ensureIdentitiesIsMutable();
          identities_.remove(index);
          onChanged();
        } else {
          identitiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder
          getIdentitiesBuilder(int index) {
        return getIdentitiesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder
          getIdentitiesOrBuilder(int index) {
        if (identitiesBuilder_ == null) {
          return identities_.get(index);
        } else {
          return identitiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder>
          getIdentitiesOrBuilderList() {
        if (identitiesBuilder_ != null) {
          return identitiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(identities_);
        }
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder
          addIdentitiesBuilder() {
        return getIdentitiesFieldBuilder()
            .addBuilder(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder
          addIdentitiesBuilder(int index) {
        return getIdentitiesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Only the identities that match one of the following conditions will be
       * presented:
       * - The identity_selector, if it is specified in request;
       * - Otherwise, identities reachable from the policy binding's members.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity identities = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder>
          getIdentitiesBuilderList() {
        return getIdentitiesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder>
          getIdentitiesFieldBuilder() {
        if (identitiesBuilder_ == null) {
          identitiesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Identity.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityOrBuilder>(
                  identities_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          identities_ = null;
        }
        return identitiesBuilder_;
      }

      private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
          groupEdges_ = java.util.Collections.emptyList();

      private void ensureGroupEdgesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          groupEdges_ =
              new java.util.ArrayList<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>(groupEdges_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
          groupEdgesBuilder_;

      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
          getGroupEdgesList() {
        if (groupEdgesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(groupEdges_);
        } else {
          return groupEdgesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public int getGroupEdgesCount() {
        if (groupEdgesBuilder_ == null) {
          return groupEdges_.size();
        } else {
          return groupEdgesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge getGroupEdges(
          int index) {
        if (groupEdgesBuilder_ == null) {
          return groupEdges_.get(index);
        } else {
          return groupEdgesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder setGroupEdges(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge value) {
        if (groupEdgesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupEdgesIsMutable();
          groupEdges_.set(index, value);
          onChanged();
        } else {
          groupEdgesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder setGroupEdges(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder builderForValue) {
        if (groupEdgesBuilder_ == null) {
          ensureGroupEdgesIsMutable();
          groupEdges_.set(index, builderForValue.build());
          onChanged();
        } else {
          groupEdgesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder addGroupEdges(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge value) {
        if (groupEdgesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupEdgesIsMutable();
          groupEdges_.add(value);
          onChanged();
        } else {
          groupEdgesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder addGroupEdges(
          int index, com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge value) {
        if (groupEdgesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupEdgesIsMutable();
          groupEdges_.add(index, value);
          onChanged();
        } else {
          groupEdgesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder addGroupEdges(
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder builderForValue) {
        if (groupEdgesBuilder_ == null) {
          ensureGroupEdgesIsMutable();
          groupEdges_.add(builderForValue.build());
          onChanged();
        } else {
          groupEdgesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder addGroupEdges(
          int index,
          com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder builderForValue) {
        if (groupEdgesBuilder_ == null) {
          ensureGroupEdgesIsMutable();
          groupEdges_.add(index, builderForValue.build());
          onChanged();
        } else {
          groupEdgesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder addAllGroupEdges(
          java.lang.Iterable<
                  ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge>
              values) {
        if (groupEdgesBuilder_ == null) {
          ensureGroupEdgesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groupEdges_);
          onChanged();
        } else {
          groupEdgesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder clearGroupEdges() {
        if (groupEdgesBuilder_ == null) {
          groupEdges_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          groupEdgesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public Builder removeGroupEdges(int index) {
        if (groupEdgesBuilder_ == null) {
          ensureGroupEdgesIsMutable();
          groupEdges_.remove(index);
          onChanged();
        } else {
          groupEdgesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder
          getGroupEdgesBuilder(int index) {
        return getGroupEdgesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder
          getGroupEdgesOrBuilder(int index) {
        if (groupEdgesBuilder_ == null) {
          return groupEdges_.get(index);
        } else {
          return groupEdgesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
          getGroupEdgesOrBuilderList() {
        if (groupEdgesBuilder_ != null) {
          return groupEdgesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(groupEdges_);
        }
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder
          addGroupEdgesBuilder() {
        return getGroupEdgesFieldBuilder()
            .addBuilder(
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder
          addGroupEdgesBuilder(int index) {
        return getGroupEdgesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Group identity edges of the graph starting from the binding's
       * group members to any node of the [identities][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.source_node]
       * contains a group, such as "group:parent&#64;google.com". The
       * [Edge.target_node][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
       * such as "group:child&#64;google.com" or "user:foo&#64;google.com".
       * This field is present only if the output_group_edges option is enabled in
       * request.
       * </pre>
       *
       * <code>repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge group_edges = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder>
          getGroupEdgesBuilderList() {
        return getGroupEdgesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>
          getGroupEdgesFieldBuilder() {
        if (groupEdgesBuilder_ == null) {
          groupEdgesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Edge.Builder,
                  com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.EdgeOrBuilder>(
                  groupEdges_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          groupEdges_ = null;
        }
        return groupEdgesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList)
    private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList();
    }

    public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IdentityList> PARSER =
        new com.google.protobuf.AbstractParser<IdentityList>() {
          @java.lang.Override
          public IdentityList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IdentityList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IdentityList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IdentityList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ATTACHED_RESOURCE_FULL_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object attachedResourceFullName_;
  /**
   *
   *
   * <pre>
   * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
   * </pre>
   *
   * <code>string attached_resource_full_name = 1;</code>
   *
   * @return The attachedResourceFullName.
   */
  @java.lang.Override
  public java.lang.String getAttachedResourceFullName() {
    java.lang.Object ref = attachedResourceFullName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attachedResourceFullName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
   * </pre>
   *
   * <code>string attached_resource_full_name = 1;</code>
   *
   * @return The bytes for attachedResourceFullName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttachedResourceFullNameBytes() {
    java.lang.Object ref = attachedResourceFullName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attachedResourceFullName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IAM_BINDING_FIELD_NUMBER = 2;
  private com.google.iam.v1.Binding iamBinding_;
  /**
   *
   *
   * <pre>
   * The Cloud IAM policy binding under analysis.
   * </pre>
   *
   * <code>.google.iam.v1.Binding iam_binding = 2;</code>
   *
   * @return Whether the iamBinding field is set.
   */
  @java.lang.Override
  public boolean hasIamBinding() {
    return iamBinding_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Cloud IAM policy binding under analysis.
   * </pre>
   *
   * <code>.google.iam.v1.Binding iam_binding = 2;</code>
   *
   * @return The iamBinding.
   */
  @java.lang.Override
  public com.google.iam.v1.Binding getIamBinding() {
    return iamBinding_ == null ? com.google.iam.v1.Binding.getDefaultInstance() : iamBinding_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud IAM policy binding under analysis.
   * </pre>
   *
   * <code>.google.iam.v1.Binding iam_binding = 2;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.BindingOrBuilder getIamBindingOrBuilder() {
    return getIamBinding();
  }

  public static final int ACCESS_CONTROL_LISTS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList>
      accessControlLists_;
  /**
   *
   *
   * <pre>
   * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match resource and access selectors specified in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList>
      getAccessControlListsList() {
    return accessControlLists_;
  }
  /**
   *
   *
   * <pre>
   * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match resource and access selectors specified in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder>
      getAccessControlListsOrBuilderList() {
    return accessControlLists_;
  }
  /**
   *
   *
   * <pre>
   * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match resource and access selectors specified in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
   * </code>
   */
  @java.lang.Override
  public int getAccessControlListsCount() {
    return accessControlLists_.size();
  }
  /**
   *
   *
   * <pre>
   * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match resource and access selectors specified in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
      getAccessControlLists(int index) {
    return accessControlLists_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match resource and access selectors specified in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder
      getAccessControlListsOrBuilder(int index) {
    return accessControlLists_.get(index);
  }

  public static final int IDENTITY_LIST_FIELD_NUMBER = 4;
  private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identityList_;
  /**
   *
   *
   * <pre>
   * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match identity selector specified in the request.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
   * </code>
   *
   * @return Whether the identityList field is set.
   */
  @java.lang.Override
  public boolean hasIdentityList() {
    return identityList_ != null;
  }
  /**
   *
   *
   * <pre>
   * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match identity selector specified in the request.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
   * </code>
   *
   * @return The identityList.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList getIdentityList() {
    return identityList_ == null
        ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.getDefaultInstance()
        : identityList_;
  }
  /**
   *
   *
   * <pre>
   * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
   * potentially match identity selector specified in the request.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityListOrBuilder
      getIdentityListOrBuilder() {
    return getIdentityList();
  }

  public static final int FULLY_EXPLORED_FIELD_NUMBER = 5;
  private boolean fullyExplored_;
  /**
   *
   *
   * <pre>
   * Represents whether all nodes in the transitive closure of the
   * [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] node have been explored.
   * </pre>
   *
   * <code>bool fully_explored = 5;</code>
   *
   * @return The fullyExplored.
   */
  @java.lang.Override
  public boolean getFullyExplored() {
    return fullyExplored_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attachedResourceFullName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, attachedResourceFullName_);
    }
    if (iamBinding_ != null) {
      output.writeMessage(2, getIamBinding());
    }
    for (int i = 0; i < accessControlLists_.size(); i++) {
      output.writeMessage(3, accessControlLists_.get(i));
    }
    if (identityList_ != null) {
      output.writeMessage(4, getIdentityList());
    }
    if (fullyExplored_ != false) {
      output.writeBool(5, fullyExplored_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attachedResourceFullName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(1, attachedResourceFullName_);
    }
    if (iamBinding_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getIamBinding());
    }
    for (int i = 0; i < accessControlLists_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, accessControlLists_.get(i));
    }
    if (identityList_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getIdentityList());
    }
    if (fullyExplored_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, fullyExplored_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult other =
        (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult) obj;

    if (!getAttachedResourceFullName().equals(other.getAttachedResourceFullName())) return false;
    if (hasIamBinding() != other.hasIamBinding()) return false;
    if (hasIamBinding()) {
      if (!getIamBinding().equals(other.getIamBinding())) return false;
    }
    if (!getAccessControlListsList().equals(other.getAccessControlListsList())) return false;
    if (hasIdentityList() != other.hasIdentityList()) return false;
    if (hasIdentityList()) {
      if (!getIdentityList().equals(other.getIdentityList())) return false;
    }
    if (getFullyExplored() != other.getFullyExplored()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ATTACHED_RESOURCE_FULL_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getAttachedResourceFullName().hashCode();
    if (hasIamBinding()) {
      hash = (37 * hash) + IAM_BINDING_FIELD_NUMBER;
      hash = (53 * hash) + getIamBinding().hashCode();
    }
    if (getAccessControlListsCount() > 0) {
      hash = (37 * hash) + ACCESS_CONTROL_LISTS_FIELD_NUMBER;
      hash = (53 * hash) + getAccessControlListsList().hashCode();
    }
    if (hasIdentityList()) {
      hash = (37 * hash) + IDENTITY_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getIdentityList().hashCode();
    }
    hash = (37 * hash) + FULLY_EXPLORED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFullyExplored());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * IAM Policy analysis result, consisting of one IAM policy binding and derived
   * access control lists.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult)
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.class,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAccessControlListsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      attachedResourceFullName_ = "";

      if (iamBindingBuilder_ == null) {
        iamBinding_ = null;
      } else {
        iamBinding_ = null;
        iamBindingBuilder_ = null;
      }
      if (accessControlListsBuilder_ == null) {
        accessControlLists_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        accessControlListsBuilder_.clear();
      }
      if (identityListBuilder_ == null) {
        identityList_ = null;
      } else {
        identityList_ = null;
        identityListBuilder_ = null;
      }
      fullyExplored_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p4beta1.AssetProto
          .internal_static_google_cloud_asset_v1p4beta1_IamPolicyAnalysisResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult build() {
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult buildPartial() {
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult result =
          new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult(this);
      int from_bitField0_ = bitField0_;
      result.attachedResourceFullName_ = attachedResourceFullName_;
      if (iamBindingBuilder_ == null) {
        result.iamBinding_ = iamBinding_;
      } else {
        result.iamBinding_ = iamBindingBuilder_.build();
      }
      if (accessControlListsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          accessControlLists_ = java.util.Collections.unmodifiableList(accessControlLists_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.accessControlLists_ = accessControlLists_;
      } else {
        result.accessControlLists_ = accessControlListsBuilder_.build();
      }
      if (identityListBuilder_ == null) {
        result.identityList_ = identityList_;
      } else {
        result.identityList_ = identityListBuilder_.build();
      }
      result.fullyExplored_ = fullyExplored_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult) {
        return mergeFrom((com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult other) {
      if (other == com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.getDefaultInstance())
        return this;
      if (!other.getAttachedResourceFullName().isEmpty()) {
        attachedResourceFullName_ = other.attachedResourceFullName_;
        onChanged();
      }
      if (other.hasIamBinding()) {
        mergeIamBinding(other.getIamBinding());
      }
      if (accessControlListsBuilder_ == null) {
        if (!other.accessControlLists_.isEmpty()) {
          if (accessControlLists_.isEmpty()) {
            accessControlLists_ = other.accessControlLists_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAccessControlListsIsMutable();
            accessControlLists_.addAll(other.accessControlLists_);
          }
          onChanged();
        }
      } else {
        if (!other.accessControlLists_.isEmpty()) {
          if (accessControlListsBuilder_.isEmpty()) {
            accessControlListsBuilder_.dispose();
            accessControlListsBuilder_ = null;
            accessControlLists_ = other.accessControlLists_;
            bitField0_ = (bitField0_ & ~0x00000001);
            accessControlListsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAccessControlListsFieldBuilder()
                    : null;
          } else {
            accessControlListsBuilder_.addAllMessages(other.accessControlLists_);
          }
        }
      }
      if (other.hasIdentityList()) {
        mergeIdentityList(other.getIdentityList());
      }
      if (other.getFullyExplored() != false) {
        setFullyExplored(other.getFullyExplored());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object attachedResourceFullName_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
     * </pre>
     *
     * <code>string attached_resource_full_name = 1;</code>
     *
     * @return The attachedResourceFullName.
     */
    public java.lang.String getAttachedResourceFullName() {
      java.lang.Object ref = attachedResourceFullName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attachedResourceFullName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
     * </pre>
     *
     * <code>string attached_resource_full_name = 1;</code>
     *
     * @return The bytes for attachedResourceFullName.
     */
    public com.google.protobuf.ByteString getAttachedResourceFullNameBytes() {
      java.lang.Object ref = attachedResourceFullName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attachedResourceFullName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
     * </pre>
     *
     * <code>string attached_resource_full_name = 1;</code>
     *
     * @param value The attachedResourceFullName to set.
     * @return This builder for chaining.
     */
    public Builder setAttachedResourceFullName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      attachedResourceFullName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
     * </pre>
     *
     * <code>string attached_resource_full_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttachedResourceFullName() {

      attachedResourceFullName_ = getDefaultInstance().getAttachedResourceFullName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resource to which the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] policy attaches.
     * </pre>
     *
     * <code>string attached_resource_full_name = 1;</code>
     *
     * @param value The bytes for attachedResourceFullName to set.
     * @return This builder for chaining.
     */
    public Builder setAttachedResourceFullNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      attachedResourceFullName_ = value;
      onChanged();
      return this;
    }

    private com.google.iam.v1.Binding iamBinding_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Binding,
            com.google.iam.v1.Binding.Builder,
            com.google.iam.v1.BindingOrBuilder>
        iamBindingBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     *
     * @return Whether the iamBinding field is set.
     */
    public boolean hasIamBinding() {
      return iamBindingBuilder_ != null || iamBinding_ != null;
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     *
     * @return The iamBinding.
     */
    public com.google.iam.v1.Binding getIamBinding() {
      if (iamBindingBuilder_ == null) {
        return iamBinding_ == null ? com.google.iam.v1.Binding.getDefaultInstance() : iamBinding_;
      } else {
        return iamBindingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    public Builder setIamBinding(com.google.iam.v1.Binding value) {
      if (iamBindingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        iamBinding_ = value;
        onChanged();
      } else {
        iamBindingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    public Builder setIamBinding(com.google.iam.v1.Binding.Builder builderForValue) {
      if (iamBindingBuilder_ == null) {
        iamBinding_ = builderForValue.build();
        onChanged();
      } else {
        iamBindingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    public Builder mergeIamBinding(com.google.iam.v1.Binding value) {
      if (iamBindingBuilder_ == null) {
        if (iamBinding_ != null) {
          iamBinding_ =
              com.google.iam.v1.Binding.newBuilder(iamBinding_).mergeFrom(value).buildPartial();
        } else {
          iamBinding_ = value;
        }
        onChanged();
      } else {
        iamBindingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    public Builder clearIamBinding() {
      if (iamBindingBuilder_ == null) {
        iamBinding_ = null;
        onChanged();
      } else {
        iamBinding_ = null;
        iamBindingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    public com.google.iam.v1.Binding.Builder getIamBindingBuilder() {

      onChanged();
      return getIamBindingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    public com.google.iam.v1.BindingOrBuilder getIamBindingOrBuilder() {
      if (iamBindingBuilder_ != null) {
        return iamBindingBuilder_.getMessageOrBuilder();
      } else {
        return iamBinding_ == null ? com.google.iam.v1.Binding.getDefaultInstance() : iamBinding_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud IAM policy binding under analysis.
     * </pre>
     *
     * <code>.google.iam.v1.Binding iam_binding = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Binding,
            com.google.iam.v1.Binding.Builder,
            com.google.iam.v1.BindingOrBuilder>
        getIamBindingFieldBuilder() {
      if (iamBindingBuilder_ == null) {
        iamBindingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.iam.v1.Binding,
                com.google.iam.v1.Binding.Builder,
                com.google.iam.v1.BindingOrBuilder>(
                getIamBinding(), getParentForChildren(), isClean());
        iamBinding_ = null;
      }
      return iamBindingBuilder_;
    }

    private java.util.List<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList>
        accessControlLists_ = java.util.Collections.emptyList();

    private void ensureAccessControlListsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        accessControlLists_ =
            new java.util.ArrayList<
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList>(
                accessControlLists_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder>
        accessControlListsBuilder_;

    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList>
        getAccessControlListsList() {
      if (accessControlListsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accessControlLists_);
      } else {
        return accessControlListsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public int getAccessControlListsCount() {
      if (accessControlListsBuilder_ == null) {
        return accessControlLists_.size();
      } else {
        return accessControlListsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
        getAccessControlLists(int index) {
      if (accessControlListsBuilder_ == null) {
        return accessControlLists_.get(index);
      } else {
        return accessControlListsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder setAccessControlLists(
        int index,
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList value) {
      if (accessControlListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessControlListsIsMutable();
        accessControlLists_.set(index, value);
        onChanged();
      } else {
        accessControlListsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder setAccessControlLists(
        int index,
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
            builderForValue) {
      if (accessControlListsBuilder_ == null) {
        ensureAccessControlListsIsMutable();
        accessControlLists_.set(index, builderForValue.build());
        onChanged();
      } else {
        accessControlListsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder addAccessControlLists(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList value) {
      if (accessControlListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessControlListsIsMutable();
        accessControlLists_.add(value);
        onChanged();
      } else {
        accessControlListsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder addAccessControlLists(
        int index,
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList value) {
      if (accessControlListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessControlListsIsMutable();
        accessControlLists_.add(index, value);
        onChanged();
      } else {
        accessControlListsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder addAccessControlLists(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
            builderForValue) {
      if (accessControlListsBuilder_ == null) {
        ensureAccessControlListsIsMutable();
        accessControlLists_.add(builderForValue.build());
        onChanged();
      } else {
        accessControlListsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder addAccessControlLists(
        int index,
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
            builderForValue) {
      if (accessControlListsBuilder_ == null) {
        ensureAccessControlListsIsMutable();
        accessControlLists_.add(index, builderForValue.build());
        onChanged();
      } else {
        accessControlListsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder addAllAccessControlLists(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList>
            values) {
      if (accessControlListsBuilder_ == null) {
        ensureAccessControlListsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accessControlLists_);
        onChanged();
      } else {
        accessControlListsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder clearAccessControlLists() {
      if (accessControlListsBuilder_ == null) {
        accessControlLists_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        accessControlListsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public Builder removeAccessControlLists(int index) {
      if (accessControlListsBuilder_ == null) {
        ensureAccessControlListsIsMutable();
        accessControlLists_.remove(index);
        onChanged();
      } else {
        accessControlListsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
        getAccessControlListsBuilder(int index) {
      return getAccessControlListsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder
        getAccessControlListsOrBuilder(int index) {
      if (accessControlListsBuilder_ == null) {
        return accessControlLists_.get(index);
      } else {
        return accessControlListsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder>
        getAccessControlListsOrBuilderList() {
      if (accessControlListsBuilder_ != null) {
        return accessControlListsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accessControlLists_);
      }
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
        addAccessControlListsBuilder() {
      return getAccessControlListsFieldBuilder()
          .addBuilder(
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder
        addAccessControlListsBuilder(int index) {
      return getAccessControlListsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The access control lists derived from the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match resource and access selectors specified in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList access_control_lists = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder>
        getAccessControlListsBuilderList() {
      return getAccessControlListsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlListOrBuilder>
        getAccessControlListsFieldBuilder() {
      if (accessControlListsBuilder_ == null) {
        accessControlListsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AccessControlList.Builder,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult
                    .AccessControlListOrBuilder>(
                accessControlLists_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        accessControlLists_ = null;
      }
      return accessControlListsBuilder_;
    }

    private com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identityList_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityListOrBuilder>
        identityListBuilder_;
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     *
     * @return Whether the identityList field is set.
     */
    public boolean hasIdentityList() {
      return identityListBuilder_ != null || identityList_ != null;
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     *
     * @return The identityList.
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList getIdentityList() {
      if (identityListBuilder_ == null) {
        return identityList_ == null
            ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
                .getDefaultInstance()
            : identityList_;
      } else {
        return identityListBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    public Builder setIdentityList(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList value) {
      if (identityListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identityList_ = value;
        onChanged();
      } else {
        identityListBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    public Builder setIdentityList(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder
            builderForValue) {
      if (identityListBuilder_ == null) {
        identityList_ = builderForValue.build();
        onChanged();
      } else {
        identityListBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    public Builder mergeIdentityList(
        com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList value) {
      if (identityListBuilder_ == null) {
        if (identityList_ != null) {
          identityList_ =
              com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.newBuilder(
                      identityList_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identityList_ = value;
        }
        onChanged();
      } else {
        identityListBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    public Builder clearIdentityList() {
      if (identityListBuilder_ == null) {
        identityList_ = null;
        onChanged();
      } else {
        identityList_ = null;
        identityListBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder
        getIdentityListBuilder() {

      onChanged();
      return getIdentityListFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityListOrBuilder
        getIdentityListOrBuilder() {
      if (identityListBuilder_ != null) {
        return identityListBuilder_.getMessageOrBuilder();
      } else {
        return identityList_ == null
            ? com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList
                .getDefaultInstance()
            : identityList_;
      }
    }
    /**
     *
     *
     * <pre>
     * The identity list derived from members of the [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] that match or
     * potentially match identity selector specified in the request.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList identity_list = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder,
            com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityListOrBuilder>
        getIdentityListFieldBuilder() {
      if (identityListBuilder_ == null) {
        identityListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityList.Builder,
                com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.IdentityListOrBuilder>(
                getIdentityList(), getParentForChildren(), isClean());
        identityList_ = null;
      }
      return identityListBuilder_;
    }

    private boolean fullyExplored_;
    /**
     *
     *
     * <pre>
     * Represents whether all nodes in the transitive closure of the
     * [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] node have been explored.
     * </pre>
     *
     * <code>bool fully_explored = 5;</code>
     *
     * @return The fullyExplored.
     */
    @java.lang.Override
    public boolean getFullyExplored() {
      return fullyExplored_;
    }
    /**
     *
     *
     * <pre>
     * Represents whether all nodes in the transitive closure of the
     * [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] node have been explored.
     * </pre>
     *
     * <code>bool fully_explored = 5;</code>
     *
     * @param value The fullyExplored to set.
     * @return This builder for chaining.
     */
    public Builder setFullyExplored(boolean value) {

      fullyExplored_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents whether all nodes in the transitive closure of the
     * [iam_binding][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.iam_binding] node have been explored.
     * </pre>
     *
     * <code>bool fully_explored = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullyExplored() {

      fullyExplored_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult)
  private static final com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult();
  }

  public static com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IamPolicyAnalysisResult> PARSER =
      new com.google.protobuf.AbstractParser<IamPolicyAnalysisResult>() {
        @java.lang.Override
        public IamPolicyAnalysisResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new IamPolicyAnalysisResult(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<IamPolicyAnalysisResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IamPolicyAnalysisResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
