/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p5beta1/assets.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.asset.v1p5beta1;

/**
 *
 *
 * <pre>
 * An asset in Google Cloud. An asset can be any resource in the Google Cloud
 * [resource
 * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
 * a resource outside the Google Cloud resource hierarchy (such as Google
 * Kubernetes Engine clusters and objects), or a policy (e.g. IAM policy).
 * See [Supported asset
 * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
 * for more information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p5beta1.Asset}
 */
public final class Asset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p5beta1.Asset)
    AssetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Asset.newBuilder() to construct.
  private Asset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Asset() {
    name_ = "";
    assetType_ = "";
    orgPolicy_ = java.util.Collections.emptyList();
    ancestors_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Asset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p5beta1.AssetProto
        .internal_static_google_cloud_asset_v1p5beta1_Asset_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p5beta1.AssetProto
        .internal_static_google_cloud_asset_v1p5beta1_Asset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p5beta1.Asset.class,
            com.google.cloud.asset.v1p5beta1.Asset.Builder.class);
  }

  private int bitField0_;
  private int accessContextPolicyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object accessContextPolicy_;

  public enum AccessContextPolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ACCESS_POLICY(7),
    ACCESS_LEVEL(8),
    SERVICE_PERIMETER(9),
    ACCESSCONTEXTPOLICY_NOT_SET(0);
    private final int value;

    private AccessContextPolicyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AccessContextPolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static AccessContextPolicyCase forNumber(int value) {
      switch (value) {
        case 7:
          return ACCESS_POLICY;
        case 8:
          return ACCESS_LEVEL;
        case 9:
          return SERVICE_PERIMETER;
        case 0:
          return ACCESSCONTEXTPOLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AccessContextPolicyCase getAccessContextPolicyCase() {
    return AccessContextPolicyCase.forNumber(accessContextPolicyCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the asset. Example:
   * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
   *
   * See [Resource
   * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * for more information.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the asset. Example:
   * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
   *
   * See [Resource
   * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * for more information.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSET_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object assetType_ = "";
  /**
   *
   *
   * <pre>
   * The type of the asset. Example: `compute.googleapis.com/Disk`
   *
   * See [Supported asset
   * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
   * for more information.
   * </pre>
   *
   * <code>string asset_type = 2;</code>
   *
   * @return The assetType.
   */
  @java.lang.Override
  public java.lang.String getAssetType() {
    java.lang.Object ref = assetType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assetType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the asset. Example: `compute.googleapis.com/Disk`
   *
   * See [Supported asset
   * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
   * for more information.
   * </pre>
   *
   * <code>string asset_type = 2;</code>
   *
   * @return The bytes for assetType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAssetTypeBytes() {
    java.lang.Object ref = assetType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      assetType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 3;
  private com.google.cloud.asset.v1p5beta1.Resource resource_;
  /**
   *
   *
   * <pre>
   * A representation of the resource.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A representation of the resource.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p5beta1.Resource getResource() {
    return resource_ == null
        ? com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance()
        : resource_;
  }
  /**
   *
   *
   * <pre>
   * A representation of the resource.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p5beta1.ResourceOrBuilder getResourceOrBuilder() {
    return resource_ == null
        ? com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance()
        : resource_;
  }

  public static final int IAM_POLICY_FIELD_NUMBER = 4;
  private com.google.iam.v1.Policy iamPolicy_;
  /**
   *
   *
   * <pre>
   * A representation of the IAM policy set on a Google Cloud resource.
   * There can be a maximum of one IAM policy set on any given resource.
   * In addition, IAM policies inherit their granted access scope from any
   * policies set on parent resources in the resource hierarchy. Therefore, the
   * effectively policy is the union of both the policy set on this resource
   * and each policy set on all of the resource's ancestry resource levels in
   * the hierarchy. See
   * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
   * for more information.
   * </pre>
   *
   * <code>.google.iam.v1.Policy iam_policy = 4;</code>
   *
   * @return Whether the iamPolicy field is set.
   */
  @java.lang.Override
  public boolean hasIamPolicy() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A representation of the IAM policy set on a Google Cloud resource.
   * There can be a maximum of one IAM policy set on any given resource.
   * In addition, IAM policies inherit their granted access scope from any
   * policies set on parent resources in the resource hierarchy. Therefore, the
   * effectively policy is the union of both the policy set on this resource
   * and each policy set on all of the resource's ancestry resource levels in
   * the hierarchy. See
   * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
   * for more information.
   * </pre>
   *
   * <code>.google.iam.v1.Policy iam_policy = 4;</code>
   *
   * @return The iamPolicy.
   */
  @java.lang.Override
  public com.google.iam.v1.Policy getIamPolicy() {
    return iamPolicy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : iamPolicy_;
  }
  /**
   *
   *
   * <pre>
   * A representation of the IAM policy set on a Google Cloud resource.
   * There can be a maximum of one IAM policy set on any given resource.
   * In addition, IAM policies inherit their granted access scope from any
   * policies set on parent resources in the resource hierarchy. Therefore, the
   * effectively policy is the union of both the policy set on this resource
   * and each policy set on all of the resource's ancestry resource levels in
   * the hierarchy. See
   * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
   * for more information.
   * </pre>
   *
   * <code>.google.iam.v1.Policy iam_policy = 4;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.PolicyOrBuilder getIamPolicyOrBuilder() {
    return iamPolicy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : iamPolicy_;
  }

  public static final int ORG_POLICY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.orgpolicy.v1.Policy> orgPolicy_;
  /**
   *
   *
   * <pre>
   * A representation of an [organization
   * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
   * There can be more than one organization policy with different constraints
   * set on a given resource.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.orgpolicy.v1.Policy> getOrgPolicyList() {
    return orgPolicy_;
  }
  /**
   *
   *
   * <pre>
   * A representation of an [organization
   * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
   * There can be more than one organization policy with different constraints
   * set on a given resource.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.orgpolicy.v1.PolicyOrBuilder>
      getOrgPolicyOrBuilderList() {
    return orgPolicy_;
  }
  /**
   *
   *
   * <pre>
   * A representation of an [organization
   * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
   * There can be more than one organization policy with different constraints
   * set on a given resource.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
   */
  @java.lang.Override
  public int getOrgPolicyCount() {
    return orgPolicy_.size();
  }
  /**
   *
   *
   * <pre>
   * A representation of an [organization
   * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
   * There can be more than one organization policy with different constraints
   * set on a given resource.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy getOrgPolicy(int index) {
    return orgPolicy_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A representation of an [organization
   * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
   * There can be more than one organization policy with different constraints
   * set on a given resource.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.PolicyOrBuilder getOrgPolicyOrBuilder(int index) {
    return orgPolicy_.get(index);
  }

  public static final int ACCESS_POLICY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Please also refer to the [access policy user
   * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
   *
   * @return Whether the accessPolicy field is set.
   */
  @java.lang.Override
  public boolean hasAccessPolicy() {
    return accessContextPolicyCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Please also refer to the [access policy user
   * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
   *
   * @return The accessPolicy.
   */
  @java.lang.Override
  public com.google.identity.accesscontextmanager.v1.AccessPolicy getAccessPolicy() {
    if (accessContextPolicyCase_ == 7) {
      return (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_;
    }
    return com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Please also refer to the [access policy user
   * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
   */
  @java.lang.Override
  public com.google.identity.accesscontextmanager.v1.AccessPolicyOrBuilder
      getAccessPolicyOrBuilder() {
    if (accessContextPolicyCase_ == 7) {
      return (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_;
    }
    return com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance();
  }

  public static final int ACCESS_LEVEL_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Please also refer to the [access level user
   * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
   *
   * @return Whether the accessLevel field is set.
   */
  @java.lang.Override
  public boolean hasAccessLevel() {
    return accessContextPolicyCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Please also refer to the [access level user
   * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
   *
   * @return The accessLevel.
   */
  @java.lang.Override
  public com.google.identity.accesscontextmanager.v1.AccessLevel getAccessLevel() {
    if (accessContextPolicyCase_ == 8) {
      return (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_;
    }
    return com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Please also refer to the [access level user
   * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
   */
  @java.lang.Override
  public com.google.identity.accesscontextmanager.v1.AccessLevelOrBuilder
      getAccessLevelOrBuilder() {
    if (accessContextPolicyCase_ == 8) {
      return (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_;
    }
    return com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance();
  }

  public static final int SERVICE_PERIMETER_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Please also refer to the [service perimeter user
   * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
   *
   * @return Whether the servicePerimeter field is set.
   */
  @java.lang.Override
  public boolean hasServicePerimeter() {
    return accessContextPolicyCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Please also refer to the [service perimeter user
   * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
   *
   * @return The servicePerimeter.
   */
  @java.lang.Override
  public com.google.identity.accesscontextmanager.v1.ServicePerimeter getServicePerimeter() {
    if (accessContextPolicyCase_ == 9) {
      return (com.google.identity.accesscontextmanager.v1.ServicePerimeter) accessContextPolicy_;
    }
    return com.google.identity.accesscontextmanager.v1.ServicePerimeter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Please also refer to the [service perimeter user
   * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
   * </pre>
   *
   * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
   */
  @java.lang.Override
  public com.google.identity.accesscontextmanager.v1.ServicePerimeterOrBuilder
      getServicePerimeterOrBuilder() {
    if (accessContextPolicyCase_ == 9) {
      return (com.google.identity.accesscontextmanager.v1.ServicePerimeter) accessContextPolicy_;
    }
    return com.google.identity.accesscontextmanager.v1.ServicePerimeter.getDefaultInstance();
  }

  public static final int ANCESTORS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ancestors_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The ancestry path of an asset in Google Cloud [resource
   * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
   * represented as a list of relative resource names. An ancestry path starts
   * with the closest ancestor in the hierarchy and ends at root. If the asset
   * is a project, folder, or organization, the ancestry path starts from the
   * asset itself.
   *
   * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
   * </pre>
   *
   * <code>repeated string ancestors = 10;</code>
   *
   * @return A list containing the ancestors.
   */
  public com.google.protobuf.ProtocolStringList getAncestorsList() {
    return ancestors_;
  }
  /**
   *
   *
   * <pre>
   * The ancestry path of an asset in Google Cloud [resource
   * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
   * represented as a list of relative resource names. An ancestry path starts
   * with the closest ancestor in the hierarchy and ends at root. If the asset
   * is a project, folder, or organization, the ancestry path starts from the
   * asset itself.
   *
   * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
   * </pre>
   *
   * <code>repeated string ancestors = 10;</code>
   *
   * @return The count of ancestors.
   */
  public int getAncestorsCount() {
    return ancestors_.size();
  }
  /**
   *
   *
   * <pre>
   * The ancestry path of an asset in Google Cloud [resource
   * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
   * represented as a list of relative resource names. An ancestry path starts
   * with the closest ancestor in the hierarchy and ends at root. If the asset
   * is a project, folder, or organization, the ancestry path starts from the
   * asset itself.
   *
   * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
   * </pre>
   *
   * <code>repeated string ancestors = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The ancestors at the given index.
   */
  public java.lang.String getAncestors(int index) {
    return ancestors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The ancestry path of an asset in Google Cloud [resource
   * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
   * represented as a list of relative resource names. An ancestry path starts
   * with the closest ancestor in the hierarchy and ends at root. If the asset
   * is a project, folder, or organization, the ancestry path starts from the
   * asset itself.
   *
   * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
   * </pre>
   *
   * <code>repeated string ancestors = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ancestors at the given index.
   */
  public com.google.protobuf.ByteString getAncestorsBytes(int index) {
    return ancestors_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, assetType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getResource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getIamPolicy());
    }
    for (int i = 0; i < orgPolicy_.size(); i++) {
      output.writeMessage(6, orgPolicy_.get(i));
    }
    if (accessContextPolicyCase_ == 7) {
      output.writeMessage(
          7, (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_);
    }
    if (accessContextPolicyCase_ == 8) {
      output.writeMessage(
          8, (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_);
    }
    if (accessContextPolicyCase_ == 9) {
      output.writeMessage(
          9, (com.google.identity.accesscontextmanager.v1.ServicePerimeter) accessContextPolicy_);
    }
    for (int i = 0; i < ancestors_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, ancestors_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, assetType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getIamPolicy());
    }
    for (int i = 0; i < orgPolicy_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, orgPolicy_.get(i));
    }
    if (accessContextPolicyCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_);
    }
    if (accessContextPolicyCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_);
    }
    if (accessContextPolicyCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.identity.accesscontextmanager.v1.ServicePerimeter) accessContextPolicy_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ancestors_.size(); i++) {
        dataSize += computeStringSizeNoTag(ancestors_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAncestorsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p5beta1.Asset)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p5beta1.Asset other = (com.google.cloud.asset.v1p5beta1.Asset) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAssetType().equals(other.getAssetType())) return false;
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (hasIamPolicy() != other.hasIamPolicy()) return false;
    if (hasIamPolicy()) {
      if (!getIamPolicy().equals(other.getIamPolicy())) return false;
    }
    if (!getOrgPolicyList().equals(other.getOrgPolicyList())) return false;
    if (!getAncestorsList().equals(other.getAncestorsList())) return false;
    if (!getAccessContextPolicyCase().equals(other.getAccessContextPolicyCase())) return false;
    switch (accessContextPolicyCase_) {
      case 7:
        if (!getAccessPolicy().equals(other.getAccessPolicy())) return false;
        break;
      case 8:
        if (!getAccessLevel().equals(other.getAccessLevel())) return false;
        break;
      case 9:
        if (!getServicePerimeter().equals(other.getServicePerimeter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ASSET_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getAssetType().hashCode();
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    if (hasIamPolicy()) {
      hash = (37 * hash) + IAM_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getIamPolicy().hashCode();
    }
    if (getOrgPolicyCount() > 0) {
      hash = (37 * hash) + ORG_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getOrgPolicyList().hashCode();
    }
    if (getAncestorsCount() > 0) {
      hash = (37 * hash) + ANCESTORS_FIELD_NUMBER;
      hash = (53 * hash) + getAncestorsList().hashCode();
    }
    switch (accessContextPolicyCase_) {
      case 7:
        hash = (37 * hash) + ACCESS_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getAccessPolicy().hashCode();
        break;
      case 8:
        hash = (37 * hash) + ACCESS_LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + getAccessLevel().hashCode();
        break;
      case 9:
        hash = (37 * hash) + SERVICE_PERIMETER_FIELD_NUMBER;
        hash = (53 * hash) + getServicePerimeter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.asset.v1p5beta1.Asset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An asset in Google Cloud. An asset can be any resource in the Google Cloud
   * [resource
   * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
   * a resource outside the Google Cloud resource hierarchy (such as Google
   * Kubernetes Engine clusters and objects), or a policy (e.g. IAM policy).
   * See [Supported asset
   * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
   * for more information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p5beta1.Asset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p5beta1.Asset)
      com.google.cloud.asset.v1p5beta1.AssetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p5beta1.AssetProto
          .internal_static_google_cloud_asset_v1p5beta1_Asset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p5beta1.AssetProto
          .internal_static_google_cloud_asset_v1p5beta1_Asset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p5beta1.Asset.class,
              com.google.cloud.asset.v1p5beta1.Asset.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p5beta1.Asset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceFieldBuilder();
        getIamPolicyFieldBuilder();
        getOrgPolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      assetType_ = "";
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      iamPolicy_ = null;
      if (iamPolicyBuilder_ != null) {
        iamPolicyBuilder_.dispose();
        iamPolicyBuilder_ = null;
      }
      if (orgPolicyBuilder_ == null) {
        orgPolicy_ = java.util.Collections.emptyList();
      } else {
        orgPolicy_ = null;
        orgPolicyBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (accessPolicyBuilder_ != null) {
        accessPolicyBuilder_.clear();
      }
      if (accessLevelBuilder_ != null) {
        accessLevelBuilder_.clear();
      }
      if (servicePerimeterBuilder_ != null) {
        servicePerimeterBuilder_.clear();
      }
      ancestors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      accessContextPolicyCase_ = 0;
      accessContextPolicy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p5beta1.AssetProto
          .internal_static_google_cloud_asset_v1p5beta1_Asset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.Asset getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p5beta1.Asset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.Asset build() {
      com.google.cloud.asset.v1p5beta1.Asset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.Asset buildPartial() {
      com.google.cloud.asset.v1p5beta1.Asset result =
          new com.google.cloud.asset.v1p5beta1.Asset(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.asset.v1p5beta1.Asset result) {
      if (orgPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          orgPolicy_ = java.util.Collections.unmodifiableList(orgPolicy_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.orgPolicy_ = orgPolicy_;
      } else {
        result.orgPolicy_ = orgPolicyBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.asset.v1p5beta1.Asset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.assetType_ = assetType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.iamPolicy_ = iamPolicyBuilder_ == null ? iamPolicy_ : iamPolicyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        ancestors_.makeImmutable();
        result.ancestors_ = ancestors_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.asset.v1p5beta1.Asset result) {
      result.accessContextPolicyCase_ = accessContextPolicyCase_;
      result.accessContextPolicy_ = this.accessContextPolicy_;
      if (accessContextPolicyCase_ == 7 && accessPolicyBuilder_ != null) {
        result.accessContextPolicy_ = accessPolicyBuilder_.build();
      }
      if (accessContextPolicyCase_ == 8 && accessLevelBuilder_ != null) {
        result.accessContextPolicy_ = accessLevelBuilder_.build();
      }
      if (accessContextPolicyCase_ == 9 && servicePerimeterBuilder_ != null) {
        result.accessContextPolicy_ = servicePerimeterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p5beta1.Asset) {
        return mergeFrom((com.google.cloud.asset.v1p5beta1.Asset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p5beta1.Asset other) {
      if (other == com.google.cloud.asset.v1p5beta1.Asset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAssetType().isEmpty()) {
        assetType_ = other.assetType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (other.hasIamPolicy()) {
        mergeIamPolicy(other.getIamPolicy());
      }
      if (orgPolicyBuilder_ == null) {
        if (!other.orgPolicy_.isEmpty()) {
          if (orgPolicy_.isEmpty()) {
            orgPolicy_ = other.orgPolicy_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureOrgPolicyIsMutable();
            orgPolicy_.addAll(other.orgPolicy_);
          }
          onChanged();
        }
      } else {
        if (!other.orgPolicy_.isEmpty()) {
          if (orgPolicyBuilder_.isEmpty()) {
            orgPolicyBuilder_.dispose();
            orgPolicyBuilder_ = null;
            orgPolicy_ = other.orgPolicy_;
            bitField0_ = (bitField0_ & ~0x00000010);
            orgPolicyBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOrgPolicyFieldBuilder()
                    : null;
          } else {
            orgPolicyBuilder_.addAllMessages(other.orgPolicy_);
          }
        }
      }
      if (!other.ancestors_.isEmpty()) {
        if (ancestors_.isEmpty()) {
          ancestors_ = other.ancestors_;
          bitField0_ |= 0x00000100;
        } else {
          ensureAncestorsIsMutable();
          ancestors_.addAll(other.ancestors_);
        }
        onChanged();
      }
      switch (other.getAccessContextPolicyCase()) {
        case ACCESS_POLICY:
          {
            mergeAccessPolicy(other.getAccessPolicy());
            break;
          }
        case ACCESS_LEVEL:
          {
            mergeAccessLevel(other.getAccessLevel());
            break;
          }
        case SERVICE_PERIMETER:
          {
            mergeServicePerimeter(other.getServicePerimeter());
            break;
          }
        case ACCESSCONTEXTPOLICY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                assetType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getIamPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                com.google.cloud.orgpolicy.v1.Policy m =
                    input.readMessage(
                        com.google.cloud.orgpolicy.v1.Policy.parser(), extensionRegistry);
                if (orgPolicyBuilder_ == null) {
                  ensureOrgPolicyIsMutable();
                  orgPolicy_.add(m);
                } else {
                  orgPolicyBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getAccessPolicyFieldBuilder().getBuilder(), extensionRegistry);
                accessContextPolicyCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getAccessLevelFieldBuilder().getBuilder(), extensionRegistry);
                accessContextPolicyCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getServicePerimeterFieldBuilder().getBuilder(), extensionRegistry);
                accessContextPolicyCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAncestorsIsMutable();
                ancestors_.add(s);
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int accessContextPolicyCase_ = 0;
    private java.lang.Object accessContextPolicy_;

    public AccessContextPolicyCase getAccessContextPolicyCase() {
      return AccessContextPolicyCase.forNumber(accessContextPolicyCase_);
    }

    public Builder clearAccessContextPolicy() {
      accessContextPolicyCase_ = 0;
      accessContextPolicy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the asset. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
     *
     * See [Resource
     * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the asset. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
     *
     * See [Resource
     * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the asset. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
     *
     * See [Resource
     * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the asset. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
     *
     * See [Resource
     * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the asset. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
     *
     * See [Resource
     * names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object assetType_ = "";
    /**
     *
     *
     * <pre>
     * The type of the asset. Example: `compute.googleapis.com/Disk`
     *
     * See [Supported asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * for more information.
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @return The assetType.
     */
    public java.lang.String getAssetType() {
      java.lang.Object ref = assetType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assetType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the asset. Example: `compute.googleapis.com/Disk`
     *
     * See [Supported asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * for more information.
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @return The bytes for assetType.
     */
    public com.google.protobuf.ByteString getAssetTypeBytes() {
      java.lang.Object ref = assetType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assetType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the asset. Example: `compute.googleapis.com/Disk`
     *
     * See [Supported asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * for more information.
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @param value The assetType to set.
     * @return This builder for chaining.
     */
    public Builder setAssetType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      assetType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the asset. Example: `compute.googleapis.com/Disk`
     *
     * See [Supported asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * for more information.
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssetType() {
      assetType_ = getDefaultInstance().getAssetType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the asset. Example: `compute.googleapis.com/Disk`
     *
     * See [Supported asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * for more information.
     * </pre>
     *
     * <code>string asset_type = 2;</code>
     *
     * @param value The bytes for assetType to set.
     * @return This builder for chaining.
     */
    public Builder setAssetTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      assetType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.asset.v1p5beta1.Resource resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p5beta1.Resource,
            com.google.cloud.asset.v1p5beta1.Resource.Builder,
            com.google.cloud.asset.v1p5beta1.ResourceOrBuilder>
        resourceBuilder_;
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     *
     * @return The resource.
     */
    public com.google.cloud.asset.v1p5beta1.Resource getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null
            ? com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance()
            : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    public Builder setResource(com.google.cloud.asset.v1p5beta1.Resource value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    public Builder setResource(com.google.cloud.asset.v1p5beta1.Resource.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    public Builder mergeResource(com.google.cloud.asset.v1p5beta1.Resource value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resource_ != null
            && resource_ != com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      if (resource_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    public com.google.cloud.asset.v1p5beta1.Resource.Builder getResourceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    public com.google.cloud.asset.v1p5beta1.ResourceOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null
            ? com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance()
            : resource_;
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of the resource.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.Resource resource = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.asset.v1p5beta1.Resource,
            com.google.cloud.asset.v1p5beta1.Resource.Builder,
            com.google.cloud.asset.v1p5beta1.ResourceOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.asset.v1p5beta1.Resource,
                com.google.cloud.asset.v1p5beta1.Resource.Builder,
                com.google.cloud.asset.v1p5beta1.ResourceOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private com.google.iam.v1.Policy iamPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Policy,
            com.google.iam.v1.Policy.Builder,
            com.google.iam.v1.PolicyOrBuilder>
        iamPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     *
     * @return Whether the iamPolicy field is set.
     */
    public boolean hasIamPolicy() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     *
     * @return The iamPolicy.
     */
    public com.google.iam.v1.Policy getIamPolicy() {
      if (iamPolicyBuilder_ == null) {
        return iamPolicy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : iamPolicy_;
      } else {
        return iamPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    public Builder setIamPolicy(com.google.iam.v1.Policy value) {
      if (iamPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        iamPolicy_ = value;
      } else {
        iamPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    public Builder setIamPolicy(com.google.iam.v1.Policy.Builder builderForValue) {
      if (iamPolicyBuilder_ == null) {
        iamPolicy_ = builderForValue.build();
      } else {
        iamPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    public Builder mergeIamPolicy(com.google.iam.v1.Policy value) {
      if (iamPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && iamPolicy_ != null
            && iamPolicy_ != com.google.iam.v1.Policy.getDefaultInstance()) {
          getIamPolicyBuilder().mergeFrom(value);
        } else {
          iamPolicy_ = value;
        }
      } else {
        iamPolicyBuilder_.mergeFrom(value);
      }
      if (iamPolicy_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    public Builder clearIamPolicy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      iamPolicy_ = null;
      if (iamPolicyBuilder_ != null) {
        iamPolicyBuilder_.dispose();
        iamPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    public com.google.iam.v1.Policy.Builder getIamPolicyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getIamPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    public com.google.iam.v1.PolicyOrBuilder getIamPolicyOrBuilder() {
      if (iamPolicyBuilder_ != null) {
        return iamPolicyBuilder_.getMessageOrBuilder();
      } else {
        return iamPolicy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : iamPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of the IAM policy set on a Google Cloud resource.
     * There can be a maximum of one IAM policy set on any given resource.
     * In addition, IAM policies inherit their granted access scope from any
     * policies set on parent resources in the resource hierarchy. Therefore, the
     * effectively policy is the union of both the policy set on this resource
     * and each policy set on all of the resource's ancestry resource levels in
     * the hierarchy. See
     * [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
     * for more information.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Policy,
            com.google.iam.v1.Policy.Builder,
            com.google.iam.v1.PolicyOrBuilder>
        getIamPolicyFieldBuilder() {
      if (iamPolicyBuilder_ == null) {
        iamPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.iam.v1.Policy,
                com.google.iam.v1.Policy.Builder,
                com.google.iam.v1.PolicyOrBuilder>(
                getIamPolicy(), getParentForChildren(), isClean());
        iamPolicy_ = null;
      }
      return iamPolicyBuilder_;
    }

    private java.util.List<com.google.cloud.orgpolicy.v1.Policy> orgPolicy_ =
        java.util.Collections.emptyList();

    private void ensureOrgPolicyIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        orgPolicy_ = new java.util.ArrayList<com.google.cloud.orgpolicy.v1.Policy>(orgPolicy_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy,
            com.google.cloud.orgpolicy.v1.Policy.Builder,
            com.google.cloud.orgpolicy.v1.PolicyOrBuilder>
        orgPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public java.util.List<com.google.cloud.orgpolicy.v1.Policy> getOrgPolicyList() {
      if (orgPolicyBuilder_ == null) {
        return java.util.Collections.unmodifiableList(orgPolicy_);
      } else {
        return orgPolicyBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public int getOrgPolicyCount() {
      if (orgPolicyBuilder_ == null) {
        return orgPolicy_.size();
      } else {
        return orgPolicyBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy getOrgPolicy(int index) {
      if (orgPolicyBuilder_ == null) {
        return orgPolicy_.get(index);
      } else {
        return orgPolicyBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder setOrgPolicy(int index, com.google.cloud.orgpolicy.v1.Policy value) {
      if (orgPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrgPolicyIsMutable();
        orgPolicy_.set(index, value);
        onChanged();
      } else {
        orgPolicyBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder setOrgPolicy(
        int index, com.google.cloud.orgpolicy.v1.Policy.Builder builderForValue) {
      if (orgPolicyBuilder_ == null) {
        ensureOrgPolicyIsMutable();
        orgPolicy_.set(index, builderForValue.build());
        onChanged();
      } else {
        orgPolicyBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder addOrgPolicy(com.google.cloud.orgpolicy.v1.Policy value) {
      if (orgPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrgPolicyIsMutable();
        orgPolicy_.add(value);
        onChanged();
      } else {
        orgPolicyBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder addOrgPolicy(int index, com.google.cloud.orgpolicy.v1.Policy value) {
      if (orgPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrgPolicyIsMutable();
        orgPolicy_.add(index, value);
        onChanged();
      } else {
        orgPolicyBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder addOrgPolicy(com.google.cloud.orgpolicy.v1.Policy.Builder builderForValue) {
      if (orgPolicyBuilder_ == null) {
        ensureOrgPolicyIsMutable();
        orgPolicy_.add(builderForValue.build());
        onChanged();
      } else {
        orgPolicyBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder addOrgPolicy(
        int index, com.google.cloud.orgpolicy.v1.Policy.Builder builderForValue) {
      if (orgPolicyBuilder_ == null) {
        ensureOrgPolicyIsMutable();
        orgPolicy_.add(index, builderForValue.build());
        onChanged();
      } else {
        orgPolicyBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder addAllOrgPolicy(
        java.lang.Iterable<? extends com.google.cloud.orgpolicy.v1.Policy> values) {
      if (orgPolicyBuilder_ == null) {
        ensureOrgPolicyIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, orgPolicy_);
        onChanged();
      } else {
        orgPolicyBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder clearOrgPolicy() {
      if (orgPolicyBuilder_ == null) {
        orgPolicy_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        orgPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public Builder removeOrgPolicy(int index) {
      if (orgPolicyBuilder_ == null) {
        ensureOrgPolicyIsMutable();
        orgPolicy_.remove(index);
        onChanged();
      } else {
        orgPolicyBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy.Builder getOrgPolicyBuilder(int index) {
      return getOrgPolicyFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public com.google.cloud.orgpolicy.v1.PolicyOrBuilder getOrgPolicyOrBuilder(int index) {
      if (orgPolicyBuilder_ == null) {
        return orgPolicy_.get(index);
      } else {
        return orgPolicyBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.orgpolicy.v1.PolicyOrBuilder>
        getOrgPolicyOrBuilderList() {
      if (orgPolicyBuilder_ != null) {
        return orgPolicyBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(orgPolicy_);
      }
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy.Builder addOrgPolicyBuilder() {
      return getOrgPolicyFieldBuilder()
          .addBuilder(com.google.cloud.orgpolicy.v1.Policy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy.Builder addOrgPolicyBuilder(int index) {
      return getOrgPolicyFieldBuilder()
          .addBuilder(index, com.google.cloud.orgpolicy.v1.Policy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A representation of an [organization
     * policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
     * There can be more than one organization policy with different constraints
     * set on a given resource.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v1.Policy org_policy = 6;</code>
     */
    public java.util.List<com.google.cloud.orgpolicy.v1.Policy.Builder> getOrgPolicyBuilderList() {
      return getOrgPolicyFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy,
            com.google.cloud.orgpolicy.v1.Policy.Builder,
            com.google.cloud.orgpolicy.v1.PolicyOrBuilder>
        getOrgPolicyFieldBuilder() {
      if (orgPolicyBuilder_ == null) {
        orgPolicyBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.orgpolicy.v1.Policy,
                com.google.cloud.orgpolicy.v1.Policy.Builder,
                com.google.cloud.orgpolicy.v1.PolicyOrBuilder>(
                orgPolicy_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        orgPolicy_ = null;
      }
      return orgPolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.identity.accesscontextmanager.v1.AccessPolicy,
            com.google.identity.accesscontextmanager.v1.AccessPolicy.Builder,
            com.google.identity.accesscontextmanager.v1.AccessPolicyOrBuilder>
        accessPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     *
     * @return Whether the accessPolicy field is set.
     */
    @java.lang.Override
    public boolean hasAccessPolicy() {
      return accessContextPolicyCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     *
     * @return The accessPolicy.
     */
    @java.lang.Override
    public com.google.identity.accesscontextmanager.v1.AccessPolicy getAccessPolicy() {
      if (accessPolicyBuilder_ == null) {
        if (accessContextPolicyCase_ == 7) {
          return (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_;
        }
        return com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance();
      } else {
        if (accessContextPolicyCase_ == 7) {
          return accessPolicyBuilder_.getMessage();
        }
        return com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    public Builder setAccessPolicy(com.google.identity.accesscontextmanager.v1.AccessPolicy value) {
      if (accessPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accessContextPolicy_ = value;
        onChanged();
      } else {
        accessPolicyBuilder_.setMessage(value);
      }
      accessContextPolicyCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    public Builder setAccessPolicy(
        com.google.identity.accesscontextmanager.v1.AccessPolicy.Builder builderForValue) {
      if (accessPolicyBuilder_ == null) {
        accessContextPolicy_ = builderForValue.build();
        onChanged();
      } else {
        accessPolicyBuilder_.setMessage(builderForValue.build());
      }
      accessContextPolicyCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    public Builder mergeAccessPolicy(
        com.google.identity.accesscontextmanager.v1.AccessPolicy value) {
      if (accessPolicyBuilder_ == null) {
        if (accessContextPolicyCase_ == 7
            && accessContextPolicy_
                != com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance()) {
          accessContextPolicy_ =
              com.google.identity.accesscontextmanager.v1.AccessPolicy.newBuilder(
                      (com.google.identity.accesscontextmanager.v1.AccessPolicy)
                          accessContextPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          accessContextPolicy_ = value;
        }
        onChanged();
      } else {
        if (accessContextPolicyCase_ == 7) {
          accessPolicyBuilder_.mergeFrom(value);
        } else {
          accessPolicyBuilder_.setMessage(value);
        }
      }
      accessContextPolicyCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    public Builder clearAccessPolicy() {
      if (accessPolicyBuilder_ == null) {
        if (accessContextPolicyCase_ == 7) {
          accessContextPolicyCase_ = 0;
          accessContextPolicy_ = null;
          onChanged();
        }
      } else {
        if (accessContextPolicyCase_ == 7) {
          accessContextPolicyCase_ = 0;
          accessContextPolicy_ = null;
        }
        accessPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    public com.google.identity.accesscontextmanager.v1.AccessPolicy.Builder
        getAccessPolicyBuilder() {
      return getAccessPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    @java.lang.Override
    public com.google.identity.accesscontextmanager.v1.AccessPolicyOrBuilder
        getAccessPolicyOrBuilder() {
      if ((accessContextPolicyCase_ == 7) && (accessPolicyBuilder_ != null)) {
        return accessPolicyBuilder_.getMessageOrBuilder();
      } else {
        if (accessContextPolicyCase_ == 7) {
          return (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_;
        }
        return com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access policy user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessPolicy access_policy = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.identity.accesscontextmanager.v1.AccessPolicy,
            com.google.identity.accesscontextmanager.v1.AccessPolicy.Builder,
            com.google.identity.accesscontextmanager.v1.AccessPolicyOrBuilder>
        getAccessPolicyFieldBuilder() {
      if (accessPolicyBuilder_ == null) {
        if (!(accessContextPolicyCase_ == 7)) {
          accessContextPolicy_ =
              com.google.identity.accesscontextmanager.v1.AccessPolicy.getDefaultInstance();
        }
        accessPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.identity.accesscontextmanager.v1.AccessPolicy,
                com.google.identity.accesscontextmanager.v1.AccessPolicy.Builder,
                com.google.identity.accesscontextmanager.v1.AccessPolicyOrBuilder>(
                (com.google.identity.accesscontextmanager.v1.AccessPolicy) accessContextPolicy_,
                getParentForChildren(),
                isClean());
        accessContextPolicy_ = null;
      }
      accessContextPolicyCase_ = 7;
      onChanged();
      return accessPolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.identity.accesscontextmanager.v1.AccessLevel,
            com.google.identity.accesscontextmanager.v1.AccessLevel.Builder,
            com.google.identity.accesscontextmanager.v1.AccessLevelOrBuilder>
        accessLevelBuilder_;
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     *
     * @return Whether the accessLevel field is set.
     */
    @java.lang.Override
    public boolean hasAccessLevel() {
      return accessContextPolicyCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     *
     * @return The accessLevel.
     */
    @java.lang.Override
    public com.google.identity.accesscontextmanager.v1.AccessLevel getAccessLevel() {
      if (accessLevelBuilder_ == null) {
        if (accessContextPolicyCase_ == 8) {
          return (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_;
        }
        return com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance();
      } else {
        if (accessContextPolicyCase_ == 8) {
          return accessLevelBuilder_.getMessage();
        }
        return com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    public Builder setAccessLevel(com.google.identity.accesscontextmanager.v1.AccessLevel value) {
      if (accessLevelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accessContextPolicy_ = value;
        onChanged();
      } else {
        accessLevelBuilder_.setMessage(value);
      }
      accessContextPolicyCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    public Builder setAccessLevel(
        com.google.identity.accesscontextmanager.v1.AccessLevel.Builder builderForValue) {
      if (accessLevelBuilder_ == null) {
        accessContextPolicy_ = builderForValue.build();
        onChanged();
      } else {
        accessLevelBuilder_.setMessage(builderForValue.build());
      }
      accessContextPolicyCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    public Builder mergeAccessLevel(com.google.identity.accesscontextmanager.v1.AccessLevel value) {
      if (accessLevelBuilder_ == null) {
        if (accessContextPolicyCase_ == 8
            && accessContextPolicy_
                != com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance()) {
          accessContextPolicy_ =
              com.google.identity.accesscontextmanager.v1.AccessLevel.newBuilder(
                      (com.google.identity.accesscontextmanager.v1.AccessLevel)
                          accessContextPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          accessContextPolicy_ = value;
        }
        onChanged();
      } else {
        if (accessContextPolicyCase_ == 8) {
          accessLevelBuilder_.mergeFrom(value);
        } else {
          accessLevelBuilder_.setMessage(value);
        }
      }
      accessContextPolicyCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    public Builder clearAccessLevel() {
      if (accessLevelBuilder_ == null) {
        if (accessContextPolicyCase_ == 8) {
          accessContextPolicyCase_ = 0;
          accessContextPolicy_ = null;
          onChanged();
        }
      } else {
        if (accessContextPolicyCase_ == 8) {
          accessContextPolicyCase_ = 0;
          accessContextPolicy_ = null;
        }
        accessLevelBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    public com.google.identity.accesscontextmanager.v1.AccessLevel.Builder getAccessLevelBuilder() {
      return getAccessLevelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    @java.lang.Override
    public com.google.identity.accesscontextmanager.v1.AccessLevelOrBuilder
        getAccessLevelOrBuilder() {
      if ((accessContextPolicyCase_ == 8) && (accessLevelBuilder_ != null)) {
        return accessLevelBuilder_.getMessageOrBuilder();
      } else {
        if (accessContextPolicyCase_ == 8) {
          return (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_;
        }
        return com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [access level user
     * guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.AccessLevel access_level = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.identity.accesscontextmanager.v1.AccessLevel,
            com.google.identity.accesscontextmanager.v1.AccessLevel.Builder,
            com.google.identity.accesscontextmanager.v1.AccessLevelOrBuilder>
        getAccessLevelFieldBuilder() {
      if (accessLevelBuilder_ == null) {
        if (!(accessContextPolicyCase_ == 8)) {
          accessContextPolicy_ =
              com.google.identity.accesscontextmanager.v1.AccessLevel.getDefaultInstance();
        }
        accessLevelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.identity.accesscontextmanager.v1.AccessLevel,
                com.google.identity.accesscontextmanager.v1.AccessLevel.Builder,
                com.google.identity.accesscontextmanager.v1.AccessLevelOrBuilder>(
                (com.google.identity.accesscontextmanager.v1.AccessLevel) accessContextPolicy_,
                getParentForChildren(),
                isClean());
        accessContextPolicy_ = null;
      }
      accessContextPolicyCase_ = 8;
      onChanged();
      return accessLevelBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.identity.accesscontextmanager.v1.ServicePerimeter,
            com.google.identity.accesscontextmanager.v1.ServicePerimeter.Builder,
            com.google.identity.accesscontextmanager.v1.ServicePerimeterOrBuilder>
        servicePerimeterBuilder_;
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     *
     * @return Whether the servicePerimeter field is set.
     */
    @java.lang.Override
    public boolean hasServicePerimeter() {
      return accessContextPolicyCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     *
     * @return The servicePerimeter.
     */
    @java.lang.Override
    public com.google.identity.accesscontextmanager.v1.ServicePerimeter getServicePerimeter() {
      if (servicePerimeterBuilder_ == null) {
        if (accessContextPolicyCase_ == 9) {
          return (com.google.identity.accesscontextmanager.v1.ServicePerimeter)
              accessContextPolicy_;
        }
        return com.google.identity.accesscontextmanager.v1.ServicePerimeter.getDefaultInstance();
      } else {
        if (accessContextPolicyCase_ == 9) {
          return servicePerimeterBuilder_.getMessage();
        }
        return com.google.identity.accesscontextmanager.v1.ServicePerimeter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    public Builder setServicePerimeter(
        com.google.identity.accesscontextmanager.v1.ServicePerimeter value) {
      if (servicePerimeterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accessContextPolicy_ = value;
        onChanged();
      } else {
        servicePerimeterBuilder_.setMessage(value);
      }
      accessContextPolicyCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    public Builder setServicePerimeter(
        com.google.identity.accesscontextmanager.v1.ServicePerimeter.Builder builderForValue) {
      if (servicePerimeterBuilder_ == null) {
        accessContextPolicy_ = builderForValue.build();
        onChanged();
      } else {
        servicePerimeterBuilder_.setMessage(builderForValue.build());
      }
      accessContextPolicyCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    public Builder mergeServicePerimeter(
        com.google.identity.accesscontextmanager.v1.ServicePerimeter value) {
      if (servicePerimeterBuilder_ == null) {
        if (accessContextPolicyCase_ == 9
            && accessContextPolicy_
                != com.google.identity.accesscontextmanager.v1.ServicePerimeter
                    .getDefaultInstance()) {
          accessContextPolicy_ =
              com.google.identity.accesscontextmanager.v1.ServicePerimeter.newBuilder(
                      (com.google.identity.accesscontextmanager.v1.ServicePerimeter)
                          accessContextPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          accessContextPolicy_ = value;
        }
        onChanged();
      } else {
        if (accessContextPolicyCase_ == 9) {
          servicePerimeterBuilder_.mergeFrom(value);
        } else {
          servicePerimeterBuilder_.setMessage(value);
        }
      }
      accessContextPolicyCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    public Builder clearServicePerimeter() {
      if (servicePerimeterBuilder_ == null) {
        if (accessContextPolicyCase_ == 9) {
          accessContextPolicyCase_ = 0;
          accessContextPolicy_ = null;
          onChanged();
        }
      } else {
        if (accessContextPolicyCase_ == 9) {
          accessContextPolicyCase_ = 0;
          accessContextPolicy_ = null;
        }
        servicePerimeterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    public com.google.identity.accesscontextmanager.v1.ServicePerimeter.Builder
        getServicePerimeterBuilder() {
      return getServicePerimeterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    @java.lang.Override
    public com.google.identity.accesscontextmanager.v1.ServicePerimeterOrBuilder
        getServicePerimeterOrBuilder() {
      if ((accessContextPolicyCase_ == 9) && (servicePerimeterBuilder_ != null)) {
        return servicePerimeterBuilder_.getMessageOrBuilder();
      } else {
        if (accessContextPolicyCase_ == 9) {
          return (com.google.identity.accesscontextmanager.v1.ServicePerimeter)
              accessContextPolicy_;
        }
        return com.google.identity.accesscontextmanager.v1.ServicePerimeter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Please also refer to the [service perimeter user
     * guide](https://cloud.google.com/vpc-service-controls/docs/overview).
     * </pre>
     *
     * <code>.google.identity.accesscontextmanager.v1.ServicePerimeter service_perimeter = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.identity.accesscontextmanager.v1.ServicePerimeter,
            com.google.identity.accesscontextmanager.v1.ServicePerimeter.Builder,
            com.google.identity.accesscontextmanager.v1.ServicePerimeterOrBuilder>
        getServicePerimeterFieldBuilder() {
      if (servicePerimeterBuilder_ == null) {
        if (!(accessContextPolicyCase_ == 9)) {
          accessContextPolicy_ =
              com.google.identity.accesscontextmanager.v1.ServicePerimeter.getDefaultInstance();
        }
        servicePerimeterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.identity.accesscontextmanager.v1.ServicePerimeter,
                com.google.identity.accesscontextmanager.v1.ServicePerimeter.Builder,
                com.google.identity.accesscontextmanager.v1.ServicePerimeterOrBuilder>(
                (com.google.identity.accesscontextmanager.v1.ServicePerimeter) accessContextPolicy_,
                getParentForChildren(),
                isClean());
        accessContextPolicy_ = null;
      }
      accessContextPolicyCase_ = 9;
      onChanged();
      return servicePerimeterBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList ancestors_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAncestorsIsMutable() {
      if (!ancestors_.isModifiable()) {
        ancestors_ = new com.google.protobuf.LazyStringArrayList(ancestors_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @return A list containing the ancestors.
     */
    public com.google.protobuf.ProtocolStringList getAncestorsList() {
      ancestors_.makeImmutable();
      return ancestors_;
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @return The count of ancestors.
     */
    public int getAncestorsCount() {
      return ancestors_.size();
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The ancestors at the given index.
     */
    public java.lang.String getAncestors(int index) {
      return ancestors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ancestors at the given index.
     */
    public com.google.protobuf.ByteString getAncestorsBytes(int index) {
      return ancestors_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The ancestors to set.
     * @return This builder for chaining.
     */
    public Builder setAncestors(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAncestorsIsMutable();
      ancestors_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @param value The ancestors to add.
     * @return This builder for chaining.
     */
    public Builder addAncestors(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAncestorsIsMutable();
      ancestors_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @param values The ancestors to add.
     * @return This builder for chaining.
     */
    public Builder addAllAncestors(java.lang.Iterable<java.lang.String> values) {
      ensureAncestorsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ancestors_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAncestors() {
      ancestors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ancestry path of an asset in Google Cloud [resource
     * hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
     * represented as a list of relative resource names. An ancestry path starts
     * with the closest ancestor in the hierarchy and ends at root. If the asset
     * is a project, folder, or organization, the ancestry path starts from the
     * asset itself.
     *
     * Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
     * </pre>
     *
     * <code>repeated string ancestors = 10;</code>
     *
     * @param value The bytes of the ancestors to add.
     * @return This builder for chaining.
     */
    public Builder addAncestorsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAncestorsIsMutable();
      ancestors_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p5beta1.Asset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p5beta1.Asset)
  private static final com.google.cloud.asset.v1p5beta1.Asset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p5beta1.Asset();
  }

  public static com.google.cloud.asset.v1p5beta1.Asset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Asset> PARSER =
      new com.google.protobuf.AbstractParser<Asset>() {
        @java.lang.Override
        public Asset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Asset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Asset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p5beta1.Asset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
