/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p5beta1/asset_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.asset.v1p5beta1;

/**
 *
 *
 * <pre>
 * ListAssets request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p5beta1.ListAssetsRequest}
 */
public final class ListAssetsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p5beta1.ListAssetsRequest)
    ListAssetsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListAssetsRequest.newBuilder() to construct.
  private ListAssetsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListAssetsRequest() {
    parent_ = "";
    assetTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    contentType_ = 0;
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListAssetsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p5beta1.AssetServiceProto
        .internal_static_google_cloud_asset_v1p5beta1_ListAssetsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p5beta1.AssetServiceProto
        .internal_static_google_cloud_asset_v1p5beta1_ListAssetsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p5beta1.ListAssetsRequest.class,
            com.google.cloud.asset.v1p5beta1.ListAssetsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the organization or project the assets belong to. Format:
   * "organizations/[organization-number]" (such as "organizations/123"),
   * "projects/[project-id]" (such as "projects/my-project-id"), or
   * "projects/[project-number]" (such as "projects/12345").
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the organization or project the assets belong to. Format:
   * "organizations/[organization-number]" (such as "organizations/123"),
   * "projects/[project-id]" (such as "projects/my-project-id"), or
   * "projects/[project-number]" (such as "projects/12345").
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * Timestamp to take an asset snapshot. This can only be set to a timestamp
   * between the current time and the current time minus 35 days (inclusive).
   * If not specified, the current time will be used. Due to delays in resource
   * data collection and indexing, there is a volatile window during which
   * running the same query may get different results.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Timestamp to take an asset snapshot. This can only be set to a timestamp
   * between the current time and the current time minus 35 days (inclusive).
   * If not specified, the current time will be used. Due to delays in resource
   * data collection and indexing, there is a volatile window during which
   * running the same query may get different results.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp to take an asset snapshot. This can only be set to a timestamp
   * between the current time and the current time minus 35 days (inclusive).
   * If not specified, the current time will be used. Due to delays in resource
   * data collection and indexing, there is a volatile window during which
   * running the same query may get different results.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }

  public static final int ASSET_TYPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList assetTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of asset types to take a snapshot for. For example:
   * "compute.googleapis.com/Disk".
   *
   * Regular expression is also supported. For example:
   *
   * * "compute.googleapis.com.*" snapshots resources whose asset type starts
   * with "compute.googleapis.com".
   * * ".*Instance" snapshots resources whose asset type ends with "Instance".
   * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
   *
   * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
   * regular expression syntax. If the regular expression does not match any
   * supported asset type, an INVALID_ARGUMENT error will be returned.
   *
   * If specified, only matching assets will be returned, otherwise, it will
   * snapshot all asset types. See [Introduction to Cloud Asset
   * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
   * for all supported asset types.
   * </pre>
   *
   * <code>repeated string asset_types = 3;</code>
   *
   * @return A list containing the assetTypes.
   */
  public com.google.protobuf.ProtocolStringList getAssetTypesList() {
    return assetTypes_;
  }
  /**
   *
   *
   * <pre>
   * A list of asset types to take a snapshot for. For example:
   * "compute.googleapis.com/Disk".
   *
   * Regular expression is also supported. For example:
   *
   * * "compute.googleapis.com.*" snapshots resources whose asset type starts
   * with "compute.googleapis.com".
   * * ".*Instance" snapshots resources whose asset type ends with "Instance".
   * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
   *
   * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
   * regular expression syntax. If the regular expression does not match any
   * supported asset type, an INVALID_ARGUMENT error will be returned.
   *
   * If specified, only matching assets will be returned, otherwise, it will
   * snapshot all asset types. See [Introduction to Cloud Asset
   * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
   * for all supported asset types.
   * </pre>
   *
   * <code>repeated string asset_types = 3;</code>
   *
   * @return The count of assetTypes.
   */
  public int getAssetTypesCount() {
    return assetTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of asset types to take a snapshot for. For example:
   * "compute.googleapis.com/Disk".
   *
   * Regular expression is also supported. For example:
   *
   * * "compute.googleapis.com.*" snapshots resources whose asset type starts
   * with "compute.googleapis.com".
   * * ".*Instance" snapshots resources whose asset type ends with "Instance".
   * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
   *
   * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
   * regular expression syntax. If the regular expression does not match any
   * supported asset type, an INVALID_ARGUMENT error will be returned.
   *
   * If specified, only matching assets will be returned, otherwise, it will
   * snapshot all asset types. See [Introduction to Cloud Asset
   * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
   * for all supported asset types.
   * </pre>
   *
   * <code>repeated string asset_types = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The assetTypes at the given index.
   */
  public java.lang.String getAssetTypes(int index) {
    return assetTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of asset types to take a snapshot for. For example:
   * "compute.googleapis.com/Disk".
   *
   * Regular expression is also supported. For example:
   *
   * * "compute.googleapis.com.*" snapshots resources whose asset type starts
   * with "compute.googleapis.com".
   * * ".*Instance" snapshots resources whose asset type ends with "Instance".
   * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
   *
   * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
   * regular expression syntax. If the regular expression does not match any
   * supported asset type, an INVALID_ARGUMENT error will be returned.
   *
   * If specified, only matching assets will be returned, otherwise, it will
   * snapshot all asset types. See [Introduction to Cloud Asset
   * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
   * for all supported asset types.
   * </pre>
   *
   * <code>repeated string asset_types = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the assetTypes at the given index.
   */
  public com.google.protobuf.ByteString getAssetTypesBytes(int index) {
    return assetTypes_.getByteString(index);
  }

  public static final int CONTENT_TYPE_FIELD_NUMBER = 4;
  private int contentType_ = 0;
  /**
   *
   *
   * <pre>
   * Asset content type. If not specified, no content but the asset name will
   * be returned.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
   *
   * @return The enum numeric value on the wire for contentType.
   */
  @java.lang.Override
  public int getContentTypeValue() {
    return contentType_;
  }
  /**
   *
   *
   * <pre>
   * Asset content type. If not specified, no content but the asset name will
   * be returned.
   * </pre>
   *
   * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
   *
   * @return The contentType.
   */
  @java.lang.Override
  public com.google.cloud.asset.v1p5beta1.ContentType getContentType() {
    com.google.cloud.asset.v1p5beta1.ContentType result =
        com.google.cloud.asset.v1p5beta1.ContentType.forNumber(contentType_);
    return result == null ? com.google.cloud.asset.v1p5beta1.ContentType.UNRECOGNIZED : result;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * The maximum number of assets to be returned in a single response. Default
   * is 100, minimum is 1, and maximum is 1000.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * The `next_page_token` returned from the previous `ListAssetsResponse`, or
   * unspecified for the first `ListAssetsRequest`. It is a continuation of a
   * prior `ListAssets` call, and the API should return the next page of assets.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The `next_page_token` returned from the previous `ListAssetsResponse`, or
   * unspecified for the first `ListAssetsRequest`. It is a continuation of a
   * prior `ListAssets` call, and the API should return the next page of assets.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getReadTime());
    }
    for (int i = 0; i < assetTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, assetTypes_.getRaw(i));
    }
    if (contentType_
        != com.google.cloud.asset.v1p5beta1.ContentType.CONTENT_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, contentType_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReadTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < assetTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(assetTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAssetTypesList().size();
    }
    if (contentType_
        != com.google.cloud.asset.v1p5beta1.ContentType.CONTENT_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, contentType_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p5beta1.ListAssetsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p5beta1.ListAssetsRequest other =
        (com.google.cloud.asset.v1p5beta1.ListAssetsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getAssetTypesList().equals(other.getAssetTypesList())) return false;
    if (contentType_ != other.contentType_) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    if (getAssetTypesCount() > 0) {
      hash = (37 * hash) + ASSET_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getAssetTypesList().hashCode();
    }
    hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + contentType_;
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.asset.v1p5beta1.ListAssetsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ListAssets request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p5beta1.ListAssetsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p5beta1.ListAssetsRequest)
      com.google.cloud.asset.v1p5beta1.ListAssetsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p5beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p5beta1_ListAssetsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p5beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p5beta1_ListAssetsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p5beta1.ListAssetsRequest.class,
              com.google.cloud.asset.v1p5beta1.ListAssetsRequest.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p5beta1.ListAssetsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReadTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      assetTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      contentType_ = 0;
      pageSize_ = 0;
      pageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p5beta1.AssetServiceProto
          .internal_static_google_cloud_asset_v1p5beta1_ListAssetsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.ListAssetsRequest getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p5beta1.ListAssetsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.ListAssetsRequest build() {
      com.google.cloud.asset.v1p5beta1.ListAssetsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.ListAssetsRequest buildPartial() {
      com.google.cloud.asset.v1p5beta1.ListAssetsRequest result =
          new com.google.cloud.asset.v1p5beta1.ListAssetsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.asset.v1p5beta1.ListAssetsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.readTime_ = readTimeBuilder_ == null ? readTime_ : readTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        assetTypes_.makeImmutable();
        result.assetTypes_ = assetTypes_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.contentType_ = contentType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pageToken_ = pageToken_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p5beta1.ListAssetsRequest) {
        return mergeFrom((com.google.cloud.asset.v1p5beta1.ListAssetsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p5beta1.ListAssetsRequest other) {
      if (other == com.google.cloud.asset.v1p5beta1.ListAssetsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      if (!other.assetTypes_.isEmpty()) {
        if (assetTypes_.isEmpty()) {
          assetTypes_ = other.assetTypes_;
          bitField0_ |= 0x00000004;
        } else {
          ensureAssetTypesIsMutable();
          assetTypes_.addAll(other.assetTypes_);
        }
        onChanged();
      }
      if (other.contentType_ != 0) {
        setContentTypeValue(other.getContentTypeValue());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssetTypesIsMutable();
                assetTypes_.add(s);
                break;
              } // case 26
            case 32:
              {
                contentType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the organization or project the assets belong to. Format:
     * "organizations/[organization-number]" (such as "organizations/123"),
     * "projects/[project-id]" (such as "projects/my-project-id"), or
     * "projects/[project-number]" (such as "projects/12345").
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization or project the assets belong to. Format:
     * "organizations/[organization-number]" (such as "organizations/123"),
     * "projects/[project-id]" (such as "projects/my-project-id"), or
     * "projects/[project-number]" (such as "projects/12345").
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization or project the assets belong to. Format:
     * "organizations/[organization-number]" (such as "organizations/123"),
     * "projects/[project-id]" (such as "projects/my-project-id"), or
     * "projects/[project-number]" (such as "projects/12345").
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization or project the assets belong to. Format:
     * "organizations/[organization-number]" (such as "organizations/123"),
     * "projects/[project-id]" (such as "projects/my-project-id"), or
     * "projects/[project-number]" (such as "projects/12345").
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization or project the assets belong to. Format:
     * "organizations/[organization-number]" (such as "organizations/123"),
     * "projects/[project-id]" (such as "projects/my-project-id"), or
     * "projects/[project-number]" (such as "projects/12345").
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
      } else {
        readTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && readTime_ != null
            && readTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReadTimeBuilder().mergeFrom(value);
        } else {
          readTime_ = value;
        }
      } else {
        readTimeBuilder_.mergeFrom(value);
      }
      if (readTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder clearReadTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp to take an asset snapshot. This can only be set to a timestamp
     * between the current time and the current time minus 35 days (inclusive).
     * If not specified, the current time will be used. Due to delays in resource
     * data collection and indexing, there is a volatile window during which
     * running the same query may get different results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList assetTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssetTypesIsMutable() {
      if (!assetTypes_.isModifiable()) {
        assetTypes_ = new com.google.protobuf.LazyStringArrayList(assetTypes_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @return A list containing the assetTypes.
     */
    public com.google.protobuf.ProtocolStringList getAssetTypesList() {
      assetTypes_.makeImmutable();
      return assetTypes_;
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @return The count of assetTypes.
     */
    public int getAssetTypesCount() {
      return assetTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The assetTypes at the given index.
     */
    public java.lang.String getAssetTypes(int index) {
      return assetTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the assetTypes at the given index.
     */
    public com.google.protobuf.ByteString getAssetTypesBytes(int index) {
      return assetTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The assetTypes to set.
     * @return This builder for chaining.
     */
    public Builder setAssetTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssetTypesIsMutable();
      assetTypes_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @param value The assetTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAssetTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssetTypesIsMutable();
      assetTypes_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @param values The assetTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssetTypes(java.lang.Iterable<java.lang.String> values) {
      ensureAssetTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, assetTypes_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssetTypes() {
      assetTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of asset types to take a snapshot for. For example:
     * "compute.googleapis.com/Disk".
     *
     * Regular expression is also supported. For example:
     *
     * * "compute.googleapis.com.*" snapshots resources whose asset type starts
     * with "compute.googleapis.com".
     * * ".*Instance" snapshots resources whose asset type ends with "Instance".
     * * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     * If specified, only matching assets will be returned, otherwise, it will
     * snapshot all asset types. See [Introduction to Cloud Asset
     * Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     * for all supported asset types.
     * </pre>
     *
     * <code>repeated string asset_types = 3;</code>
     *
     * @param value The bytes of the assetTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAssetTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssetTypesIsMutable();
      assetTypes_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int contentType_ = 0;
    /**
     *
     *
     * <pre>
     * Asset content type. If not specified, no content but the asset name will
     * be returned.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    @java.lang.Override
    public int getContentTypeValue() {
      return contentType_;
    }
    /**
     *
     *
     * <pre>
     * Asset content type. If not specified, no content but the asset name will
     * be returned.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for contentType to set.
     * @return This builder for chaining.
     */
    public Builder setContentTypeValue(int value) {
      contentType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset content type. If not specified, no content but the asset name will
     * be returned.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
     *
     * @return The contentType.
     */
    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.ContentType getContentType() {
      com.google.cloud.asset.v1p5beta1.ContentType result =
          com.google.cloud.asset.v1p5beta1.ContentType.forNumber(contentType_);
      return result == null ? com.google.cloud.asset.v1p5beta1.ContentType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Asset content type. If not specified, no content but the asset name will
     * be returned.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
     *
     * @param value The contentType to set.
     * @return This builder for chaining.
     */
    public Builder setContentType(com.google.cloud.asset.v1p5beta1.ContentType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      contentType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset content type. If not specified, no content but the asset name will
     * be returned.
     * </pre>
     *
     * <code>.google.cloud.asset.v1p5beta1.ContentType content_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      contentType_ = 0;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The maximum number of assets to be returned in a single response. Default
     * is 100, minimum is 1, and maximum is 1000.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of assets to be returned in a single response. Default
     * is 100, minimum is 1, and maximum is 1000.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of assets to be returned in a single response. Default
     * is 100, minimum is 1, and maximum is 1000.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000010);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * The `next_page_token` returned from the previous `ListAssetsResponse`, or
     * unspecified for the first `ListAssetsRequest`. It is a continuation of a
     * prior `ListAssets` call, and the API should return the next page of assets.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` returned from the previous `ListAssetsResponse`, or
     * unspecified for the first `ListAssetsRequest`. It is a continuation of a
     * prior `ListAssets` call, and the API should return the next page of assets.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` returned from the previous `ListAssetsResponse`, or
     * unspecified for the first `ListAssetsRequest`. It is a continuation of a
     * prior `ListAssets` call, and the API should return the next page of assets.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` returned from the previous `ListAssetsResponse`, or
     * unspecified for the first `ListAssetsRequest`. It is a continuation of a
     * prior `ListAssets` call, and the API should return the next page of assets.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` returned from the previous `ListAssetsResponse`, or
     * unspecified for the first `ListAssetsRequest`. It is a continuation of a
     * prior `ListAssets` call, and the API should return the next page of assets.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p5beta1.ListAssetsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p5beta1.ListAssetsRequest)
  private static final com.google.cloud.asset.v1p5beta1.ListAssetsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p5beta1.ListAssetsRequest();
  }

  public static com.google.cloud.asset.v1p5beta1.ListAssetsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListAssetsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListAssetsRequest>() {
        @java.lang.Override
        public ListAssetsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListAssetsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListAssetsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p5beta1.ListAssetsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
