/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/asset/v1p5beta1/assets.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.asset.v1p5beta1;

/**
 *
 *
 * <pre>
 * A representation of a Google Cloud resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.asset.v1p5beta1.Resource}
 */
public final class Resource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.asset.v1p5beta1.Resource)
    ResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Resource.newBuilder() to construct.
  private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Resource() {
    version_ = "";
    discoveryDocumentUri_ = "";
    discoveryName_ = "";
    resourceUrl_ = "";
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Resource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.asset.v1p5beta1.AssetProto
        .internal_static_google_cloud_asset_v1p5beta1_Resource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.asset.v1p5beta1.AssetProto
        .internal_static_google_cloud_asset_v1p5beta1_Resource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.asset.v1p5beta1.Resource.class,
            com.google.cloud.asset.v1p5beta1.Resource.Builder.class);
  }

  private int bitField0_;
  public static final int VERSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * The API version. Example: "v1".
   * </pre>
   *
   * <code>string version = 1;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The API version. Example: "v1".
   * </pre>
   *
   * <code>string version = 1;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISCOVERY_DOCUMENT_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object discoveryDocumentUri_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the discovery document containing the resource's JSON schema.
   * Example:
   * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
   *
   * This value is unspecified for resources that do not have an API based on a
   * discovery document, such as Cloud Bigtable.
   * </pre>
   *
   * <code>string discovery_document_uri = 2;</code>
   *
   * @return The discoveryDocumentUri.
   */
  @java.lang.Override
  public java.lang.String getDiscoveryDocumentUri() {
    java.lang.Object ref = discoveryDocumentUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      discoveryDocumentUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the discovery document containing the resource's JSON schema.
   * Example:
   * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
   *
   * This value is unspecified for resources that do not have an API based on a
   * discovery document, such as Cloud Bigtable.
   * </pre>
   *
   * <code>string discovery_document_uri = 2;</code>
   *
   * @return The bytes for discoveryDocumentUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiscoveryDocumentUriBytes() {
    java.lang.Object ref = discoveryDocumentUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      discoveryDocumentUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISCOVERY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object discoveryName_ = "";
  /**
   *
   *
   * <pre>
   * The JSON schema name listed in the discovery document. Example:
   * `Project`
   *
   * This value is unspecified for resources that do not have an API based on a
   * discovery document, such as Cloud Bigtable.
   * </pre>
   *
   * <code>string discovery_name = 3;</code>
   *
   * @return The discoveryName.
   */
  @java.lang.Override
  public java.lang.String getDiscoveryName() {
    java.lang.Object ref = discoveryName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      discoveryName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The JSON schema name listed in the discovery document. Example:
   * `Project`
   *
   * This value is unspecified for resources that do not have an API based on a
   * discovery document, such as Cloud Bigtable.
   * </pre>
   *
   * <code>string discovery_name = 3;</code>
   *
   * @return The bytes for discoveryName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiscoveryNameBytes() {
    java.lang.Object ref = discoveryName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      discoveryName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_URL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceUrl_ = "";
  /**
   *
   *
   * <pre>
   * The REST URL for accessing the resource. An HTTP `GET` request using this
   * URL returns the resource itself. Example:
   * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
   *
   * This value is unspecified for resources without a REST API.
   * </pre>
   *
   * <code>string resource_url = 4;</code>
   *
   * @return The resourceUrl.
   */
  @java.lang.Override
  public java.lang.String getResourceUrl() {
    java.lang.Object ref = resourceUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The REST URL for accessing the resource. An HTTP `GET` request using this
   * URL returns the resource itself. Example:
   * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
   *
   * This value is unspecified for resources without a REST API.
   * </pre>
   *
   * <code>string resource_url = 4;</code>
   *
   * @return The bytes for resourceUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceUrlBytes() {
    java.lang.Object ref = resourceUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the immediate parent of this resource. See
   * [Resource
   * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * for more information.
   *
   * For Google Cloud assets, this value is the parent resource defined in the
   * [IAM policy
   * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
   * Example:
   * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
   *
   * For third-party assets, this field may be set differently.
   * </pre>
   *
   * <code>string parent = 5;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the immediate parent of this resource. See
   * [Resource
   * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
   * for more information.
   *
   * For Google Cloud assets, this value is the parent resource defined in the
   * [IAM policy
   * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
   * Example:
   * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
   *
   * For third-party assets, this field may be set differently.
   * </pre>
   *
   * <code>string parent = 5;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Struct data_;
  /**
   *
   *
   * <pre>
   * The content of the resource, in which some sensitive fields are removed
   * and may not be present.
   * </pre>
   *
   * <code>.google.protobuf.Struct data = 6;</code>
   *
   * @return Whether the data field is set.
   */
  @java.lang.Override
  public boolean hasData() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The content of the resource, in which some sensitive fields are removed
   * and may not be present.
   * </pre>
   *
   * <code>.google.protobuf.Struct data = 6;</code>
   *
   * @return The data.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getData() {
    return data_ == null ? com.google.protobuf.Struct.getDefaultInstance() : data_;
  }
  /**
   *
   *
   * <pre>
   * The content of the resource, in which some sensitive fields are removed
   * and may not be present.
   * </pre>
   *
   * <code>.google.protobuf.Struct data = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getDataOrBuilder() {
    return data_ == null ? com.google.protobuf.Struct.getDefaultInstance() : data_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(discoveryDocumentUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, discoveryDocumentUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(discoveryName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, discoveryName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getData());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(discoveryDocumentUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, discoveryDocumentUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(discoveryName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, discoveryName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getData());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.asset.v1p5beta1.Resource)) {
      return super.equals(obj);
    }
    com.google.cloud.asset.v1p5beta1.Resource other =
        (com.google.cloud.asset.v1p5beta1.Resource) obj;

    if (!getVersion().equals(other.getVersion())) return false;
    if (!getDiscoveryDocumentUri().equals(other.getDiscoveryDocumentUri())) return false;
    if (!getDiscoveryName().equals(other.getDiscoveryName())) return false;
    if (!getResourceUrl().equals(other.getResourceUrl())) return false;
    if (!getParent().equals(other.getParent())) return false;
    if (hasData() != other.hasData()) return false;
    if (hasData()) {
      if (!getData().equals(other.getData())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + DISCOVERY_DOCUMENT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDiscoveryDocumentUri().hashCode();
    hash = (37 * hash) + DISCOVERY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDiscoveryName().hashCode();
    hash = (37 * hash) + RESOURCE_URL_FIELD_NUMBER;
    hash = (53 * hash) + getResourceUrl().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasData()) {
      hash = (37 * hash) + DATA_FIELD_NUMBER;
      hash = (53 * hash) + getData().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.asset.v1p5beta1.Resource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.asset.v1p5beta1.Resource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a Google Cloud resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.asset.v1p5beta1.Resource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.asset.v1p5beta1.Resource)
      com.google.cloud.asset.v1p5beta1.ResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.asset.v1p5beta1.AssetProto
          .internal_static_google_cloud_asset_v1p5beta1_Resource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.asset.v1p5beta1.AssetProto
          .internal_static_google_cloud_asset_v1p5beta1_Resource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.asset.v1p5beta1.Resource.class,
              com.google.cloud.asset.v1p5beta1.Resource.Builder.class);
    }

    // Construct using com.google.cloud.asset.v1p5beta1.Resource.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      version_ = "";
      discoveryDocumentUri_ = "";
      discoveryName_ = "";
      resourceUrl_ = "";
      parent_ = "";
      data_ = null;
      if (dataBuilder_ != null) {
        dataBuilder_.dispose();
        dataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.asset.v1p5beta1.AssetProto
          .internal_static_google_cloud_asset_v1p5beta1_Resource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.Resource getDefaultInstanceForType() {
      return com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.Resource build() {
      com.google.cloud.asset.v1p5beta1.Resource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.asset.v1p5beta1.Resource buildPartial() {
      com.google.cloud.asset.v1p5beta1.Resource result =
          new com.google.cloud.asset.v1p5beta1.Resource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.asset.v1p5beta1.Resource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.discoveryDocumentUri_ = discoveryDocumentUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.discoveryName_ = discoveryName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resourceUrl_ = resourceUrl_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.data_ = dataBuilder_ == null ? data_ : dataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.asset.v1p5beta1.Resource) {
        return mergeFrom((com.google.cloud.asset.v1p5beta1.Resource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.asset.v1p5beta1.Resource other) {
      if (other == com.google.cloud.asset.v1p5beta1.Resource.getDefaultInstance()) return this;
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDiscoveryDocumentUri().isEmpty()) {
        discoveryDocumentUri_ = other.discoveryDocumentUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDiscoveryName().isEmpty()) {
        discoveryName_ = other.discoveryName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getResourceUrl().isEmpty()) {
        resourceUrl_ = other.resourceUrl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasData()) {
        mergeData(other.getData());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                discoveryDocumentUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                discoveryName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                resourceUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The API version. Example: "v1".
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The API version. Example: "v1".
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The API version. Example: "v1".
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The API version. Example: "v1".
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The API version. Example: "v1".
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object discoveryDocumentUri_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the discovery document containing the resource's JSON schema.
     * Example:
     * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_document_uri = 2;</code>
     *
     * @return The discoveryDocumentUri.
     */
    public java.lang.String getDiscoveryDocumentUri() {
      java.lang.Object ref = discoveryDocumentUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        discoveryDocumentUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the discovery document containing the resource's JSON schema.
     * Example:
     * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_document_uri = 2;</code>
     *
     * @return The bytes for discoveryDocumentUri.
     */
    public com.google.protobuf.ByteString getDiscoveryDocumentUriBytes() {
      java.lang.Object ref = discoveryDocumentUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        discoveryDocumentUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the discovery document containing the resource's JSON schema.
     * Example:
     * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_document_uri = 2;</code>
     *
     * @param value The discoveryDocumentUri to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryDocumentUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      discoveryDocumentUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the discovery document containing the resource's JSON schema.
     * Example:
     * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_document_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiscoveryDocumentUri() {
      discoveryDocumentUri_ = getDefaultInstance().getDiscoveryDocumentUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the discovery document containing the resource's JSON schema.
     * Example:
     * `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_document_uri = 2;</code>
     *
     * @param value The bytes for discoveryDocumentUri to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryDocumentUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      discoveryDocumentUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object discoveryName_ = "";
    /**
     *
     *
     * <pre>
     * The JSON schema name listed in the discovery document. Example:
     * `Project`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_name = 3;</code>
     *
     * @return The discoveryName.
     */
    public java.lang.String getDiscoveryName() {
      java.lang.Object ref = discoveryName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        discoveryName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JSON schema name listed in the discovery document. Example:
     * `Project`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_name = 3;</code>
     *
     * @return The bytes for discoveryName.
     */
    public com.google.protobuf.ByteString getDiscoveryNameBytes() {
      java.lang.Object ref = discoveryName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        discoveryName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JSON schema name listed in the discovery document. Example:
     * `Project`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_name = 3;</code>
     *
     * @param value The discoveryName to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      discoveryName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JSON schema name listed in the discovery document. Example:
     * `Project`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiscoveryName() {
      discoveryName_ = getDefaultInstance().getDiscoveryName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JSON schema name listed in the discovery document. Example:
     * `Project`
     *
     * This value is unspecified for resources that do not have an API based on a
     * discovery document, such as Cloud Bigtable.
     * </pre>
     *
     * <code>string discovery_name = 3;</code>
     *
     * @param value The bytes for discoveryName to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      discoveryName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object resourceUrl_ = "";
    /**
     *
     *
     * <pre>
     * The REST URL for accessing the resource. An HTTP `GET` request using this
     * URL returns the resource itself. Example:
     * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
     *
     * This value is unspecified for resources without a REST API.
     * </pre>
     *
     * <code>string resource_url = 4;</code>
     *
     * @return The resourceUrl.
     */
    public java.lang.String getResourceUrl() {
      java.lang.Object ref = resourceUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The REST URL for accessing the resource. An HTTP `GET` request using this
     * URL returns the resource itself. Example:
     * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
     *
     * This value is unspecified for resources without a REST API.
     * </pre>
     *
     * <code>string resource_url = 4;</code>
     *
     * @return The bytes for resourceUrl.
     */
    public com.google.protobuf.ByteString getResourceUrlBytes() {
      java.lang.Object ref = resourceUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The REST URL for accessing the resource. An HTTP `GET` request using this
     * URL returns the resource itself. Example:
     * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
     *
     * This value is unspecified for resources without a REST API.
     * </pre>
     *
     * <code>string resource_url = 4;</code>
     *
     * @param value The resourceUrl to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The REST URL for accessing the resource. An HTTP `GET` request using this
     * URL returns the resource itself. Example:
     * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
     *
     * This value is unspecified for resources without a REST API.
     * </pre>
     *
     * <code>string resource_url = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceUrl() {
      resourceUrl_ = getDefaultInstance().getResourceUrl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The REST URL for accessing the resource. An HTTP `GET` request using this
     * URL returns the resource itself. Example:
     * `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
     *
     * This value is unspecified for resources without a REST API.
     * </pre>
     *
     * <code>string resource_url = 4;</code>
     *
     * @param value The bytes for resourceUrl to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the immediate parent of this resource. See
     * [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * For Google Cloud assets, this value is the parent resource defined in the
     * [IAM policy
     * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
     * Example:
     * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
     *
     * For third-party assets, this field may be set differently.
     * </pre>
     *
     * <code>string parent = 5;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the immediate parent of this resource. See
     * [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * For Google Cloud assets, this value is the parent resource defined in the
     * [IAM policy
     * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
     * Example:
     * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
     *
     * For third-party assets, this field may be set differently.
     * </pre>
     *
     * <code>string parent = 5;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the immediate parent of this resource. See
     * [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * For Google Cloud assets, this value is the parent resource defined in the
     * [IAM policy
     * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
     * Example:
     * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
     *
     * For third-party assets, this field may be set differently.
     * </pre>
     *
     * <code>string parent = 5;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the immediate parent of this resource. See
     * [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * For Google Cloud assets, this value is the parent resource defined in the
     * [IAM policy
     * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
     * Example:
     * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
     *
     * For third-party assets, this field may be set differently.
     * </pre>
     *
     * <code>string parent = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the immediate parent of this resource. See
     * [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * For Google Cloud assets, this value is the parent resource defined in the
     * [IAM policy
     * hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
     * Example:
     * `//cloudresourcemanager.googleapis.com/projects/my_project_123`
     *
     * For third-party assets, this field may be set differently.
     * </pre>
     *
     * <code>string parent = 5;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct data_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        dataBuilder_;
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     *
     * @return Whether the data field is set.
     */
    public boolean hasData() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     *
     * @return The data.
     */
    public com.google.protobuf.Struct getData() {
      if (dataBuilder_ == null) {
        return data_ == null ? com.google.protobuf.Struct.getDefaultInstance() : data_;
      } else {
        return dataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    public Builder setData(com.google.protobuf.Struct value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
      } else {
        dataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    public Builder setData(com.google.protobuf.Struct.Builder builderForValue) {
      if (dataBuilder_ == null) {
        data_ = builderForValue.build();
      } else {
        dataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    public Builder mergeData(com.google.protobuf.Struct value) {
      if (dataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && data_ != null
            && data_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getDataBuilder().mergeFrom(value);
        } else {
          data_ = value;
        }
      } else {
        dataBuilder_.mergeFrom(value);
      }
      if (data_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    public Builder clearData() {
      bitField0_ = (bitField0_ & ~0x00000020);
      data_ = null;
      if (dataBuilder_ != null) {
        dataBuilder_.dispose();
        dataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    public com.google.protobuf.Struct.Builder getDataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    public com.google.protobuf.StructOrBuilder getDataOrBuilder() {
      if (dataBuilder_ != null) {
        return dataBuilder_.getMessageOrBuilder();
      } else {
        return data_ == null ? com.google.protobuf.Struct.getDefaultInstance() : data_;
      }
    }
    /**
     *
     *
     * <pre>
     * The content of the resource, in which some sensitive fields are removed
     * and may not be present.
     * </pre>
     *
     * <code>.google.protobuf.Struct data = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getDataFieldBuilder() {
      if (dataBuilder_ == null) {
        dataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(getData(), getParentForChildren(), isClean());
        data_ = null;
      }
      return dataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.asset.v1p5beta1.Resource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.asset.v1p5beta1.Resource)
  private static final com.google.cloud.asset.v1p5beta1.Resource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.asset.v1p5beta1.Resource();
  }

  public static com.google.cloud.asset.v1p5beta1.Resource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Resource> PARSER =
      new com.google.protobuf.AbstractParser<Resource>() {
        @java.lang.Override
        public Resource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Resource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Resource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.asset.v1p5beta1.Resource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
