/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelEvaluationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/models/{model}/modelEvaluations/{model_evaluation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String model;
    private final String modelEvaluation;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModel() {
        return this.model;
    }

    public String getModelEvaluation() {
        return this.modelEvaluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ModelEvaluationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
        this.modelEvaluation = (String)Preconditions.checkNotNull((Object)builder.getModelEvaluation());
    }

    public static ModelEvaluationName of(String project, String location, String model, String modelEvaluation) {
        return ModelEvaluationName.newBuilder().setProject(project).setLocation(location).setModel(model).setModelEvaluation(modelEvaluation).build();
    }

    public static String format(String project, String location, String model, String modelEvaluation) {
        return ModelEvaluationName.newBuilder().setProject(project).setLocation(location).setModel(model).setModelEvaluation(modelEvaluation).build().toString();
    }

    public static ModelEvaluationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ModelEvaluationName.parse: formattedString not in valid format");
        return ModelEvaluationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model"), (String)matchMap.get("model_evaluation"));
    }

    public static List<ModelEvaluationName> parseList(List<String> formattedStrings) {
        ArrayList<ModelEvaluationName> list = new ArrayList<ModelEvaluationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelEvaluationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelEvaluationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelEvaluationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelEvaluationName modelEvaluationName = this;
            synchronized (modelEvaluationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"model", (Object)this.model);
                    fieldMapBuilder.put((Object)"modelEvaluation", (Object)this.modelEvaluation);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "model", this.model, "model_evaluation", this.modelEvaluation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ModelEvaluationName) {
            ModelEvaluationName that = (ModelEvaluationName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.model.equals(that.model) && this.modelEvaluation.equals(that.modelEvaluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.model.hashCode();
        h *= 1000003;
        return h ^= this.modelEvaluation.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String model;
        private String modelEvaluation;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModel() {
            return this.model;
        }

        public String getModelEvaluation() {
            return this.modelEvaluation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setModelEvaluation(String modelEvaluation) {
            this.modelEvaluation = modelEvaluation;
            return this;
        }

        private Builder() {
        }

        private Builder(ModelEvaluationName modelEvaluationName) {
            this.project = modelEvaluationName.project;
            this.location = modelEvaluationName.location;
            this.model = modelEvaluationName.model;
            this.modelEvaluation = modelEvaluationName.modelEvaluation;
        }

        public ModelEvaluationName build() {
            return new ModelEvaluationName(this);
        }
    }
}

