/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/operations.proto

package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Details of BatchPredict operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.BatchPredictOperationMetadata}
 */
public final class BatchPredictOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.BatchPredictOperationMetadata)
    BatchPredictOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchPredictOperationMetadata.newBuilder() to construct.
  private BatchPredictOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchPredictOperationMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchPredictOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BatchPredictOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.automl.v1.BatchPredictInputConfig.Builder subBuilder = null;
              if (inputConfig_ != null) {
                subBuilder = inputConfig_.toBuilder();
              }
              inputConfig_ =
                  input.readMessage(
                      com.google.cloud.automl.v1.BatchPredictInputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputConfig_);
                inputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                      .Builder
                  subBuilder = null;
              if (outputInfo_ != null) {
                subBuilder = outputInfo_.toBuilder();
              }
              outputInfo_ =
                  input.readMessage(
                      com.google.cloud.automl.v1.BatchPredictOperationMetadata
                          .BatchPredictOutputInfo.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputInfo_);
                outputInfo_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.Operations
        .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.Operations
        .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.class,
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.Builder.class);
  }

  public interface BatchPredictOutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();

    public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
            .OutputLocationCase
        getOutputLocationCase();
  }
  /**
   *
   *
   * <pre>
   * Further describes this batch predict's output.
   * Supplements
   * [BatchPredictOutputConfig][google.cloud.automl.v1.BatchPredictOutputConfig].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo}
   */
  public static final class BatchPredictOutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
      BatchPredictOutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchPredictOutputInfo.newBuilder() to construct.
    private BatchPredictOutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchPredictOutputInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchPredictOutputInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private BatchPredictOutputInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                outputLocationCase_ = 1;
                outputLocation_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_BatchPredictOutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_BatchPredictOutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo.class,
              com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                  .Builder.class);
    }

    private int outputLocationCase_ = 0;
    private java.lang.Object outputLocation_;

    public enum OutputLocationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_OUTPUT_DIRECTORY(1),
      OUTPUTLOCATION_NOT_SET(0);
      private final int value;

      private OutputLocationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OutputLocationCase valueOf(int value) {
        return forNumber(value);
      }

      public static OutputLocationCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCS_OUTPUT_DIRECTORY;
          case 0:
            return OUTPUTLOCATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OutputLocationCase getOutputLocationCase() {
      return OutputLocationCase.forNumber(outputLocationCase_);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputLocationCase_ == 1) {
          outputLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputLocationCase_ == 1) {
          outputLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (outputLocationCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, outputLocation_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (outputLocationCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, outputLocation_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo other =
          (com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo) obj;

      if (!getOutputLocationCase().equals(other.getOutputLocationCase())) return false;
      switch (outputLocationCase_) {
        case 1:
          if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (outputLocationCase_) {
        case 1:
          hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
          hash = (53 * hash) + getGcsOutputDirectory().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes this batch predict's output.
     * Supplements
     * [BatchPredictOutputConfig][google.cloud.automl.v1.BatchPredictOutputConfig].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_BatchPredictOutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_BatchPredictOutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                    .class,
                com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        outputLocationCase_ = 0;
        outputLocation_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_BatchPredictOutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
          build() {
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
          buildPartial() {
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo result =
            new com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo(
                this);
        if (outputLocationCase_ == 1) {
          result.outputLocation_ = outputLocation_;
        }
        result.outputLocationCase_ = outputLocationCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo) {
          return mergeFrom(
              (com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo other) {
        if (other
            == com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                .getDefaultInstance()) return this;
        switch (other.getOutputLocationCase()) {
          case GCS_OUTPUT_DIRECTORY:
            {
              outputLocationCase_ = 1;
              outputLocation_ = other.outputLocation_;
              onChanged();
              break;
            }
          case OUTPUTLOCATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int outputLocationCase_ = 0;
      private java.lang.Object outputLocation_;

      public OutputLocationCase getOutputLocationCase() {
        return OutputLocationCase.forNumber(outputLocationCase_);
      }

      public Builder clearOutputLocation() {
        outputLocationCase_ = 0;
        outputLocation_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The gcsOutputDirectory.
       */
      @java.lang.Override
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputLocationCase_ == 1) {
            outputLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputLocationCase_ == 1) {
            outputLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        if (outputLocationCase_ == 1) {
          outputLocationCase_ = 0;
          outputLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo)
    private static final com.google.cloud.automl.v1.BatchPredictOperationMetadata
            .BatchPredictOutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo();
    }

    public static com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchPredictOutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<BatchPredictOutputInfo>() {
          @java.lang.Override
          public BatchPredictOutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new BatchPredictOutputInfo(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<BatchPredictOutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchPredictOutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.automl.v1.BatchPredictInputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The input config that was given upon starting this
   * batch predict operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return inputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The input config that was given upon starting this
   * batch predict operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.BatchPredictInputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.automl.v1.BatchPredictInputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The input config that was given upon starting this
   * batch predict operation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.BatchPredictInputConfigOrBuilder getInputConfigOrBuilder() {
    return getInputConfig();
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
      outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing this batch predict's output.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  @java.lang.Override
  public boolean hasOutputInfo() {
    return outputInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing this batch predict's output.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
   * </code>
   *
   * @return The outputInfo.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
      getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing this batch predict's output.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return getOutputInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputConfig_ != null) {
      output.writeMessage(1, getInputConfig());
    }
    if (outputInfo_ != null) {
      output.writeMessage(2, getOutputInfo());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputConfig());
    }
    if (outputInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputInfo());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.BatchPredictOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.BatchPredictOperationMetadata other =
        (com.google.cloud.automl.v1.BatchPredictOperationMetadata) obj;

    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1.BatchPredictOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of BatchPredict operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.BatchPredictOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.BatchPredictOperationMetadata)
      com.google.cloud.automl.v1.BatchPredictOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.BatchPredictOperationMetadata.class,
              com.google.cloud.automl.v1.BatchPredictOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.BatchPredictOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_BatchPredictOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.BatchPredictOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata build() {
      com.google.cloud.automl.v1.BatchPredictOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata buildPartial() {
      com.google.cloud.automl.v1.BatchPredictOperationMetadata result =
          new com.google.cloud.automl.v1.BatchPredictOperationMetadata(this);
      if (inputConfigBuilder_ == null) {
        result.inputConfig_ = inputConfig_;
      } else {
        result.inputConfig_ = inputConfigBuilder_.build();
      }
      if (outputInfoBuilder_ == null) {
        result.outputInfo_ = outputInfo_;
      } else {
        result.outputInfo_ = outputInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.BatchPredictOperationMetadata) {
        return mergeFrom((com.google.cloud.automl.v1.BatchPredictOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.BatchPredictOperationMetadata other) {
      if (other == com.google.cloud.automl.v1.BatchPredictOperationMetadata.getDefaultInstance())
        return this;
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1.BatchPredictOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1.BatchPredictOperationMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.cloud.automl.v1.BatchPredictInputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.BatchPredictInputConfig,
            com.google.cloud.automl.v1.BatchPredictInputConfig.Builder,
            com.google.cloud.automl.v1.BatchPredictInputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return inputConfigBuilder_ != null || inputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.automl.v1.BatchPredictInputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.automl.v1.BatchPredictInputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(com.google.cloud.automl.v1.BatchPredictInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(
        com.google.cloud.automl.v1.BatchPredictInputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    public Builder mergeInputConfig(com.google.cloud.automl.v1.BatchPredictInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (inputConfig_ != null) {
          inputConfig_ =
              com.google.cloud.automl.v1.BatchPredictInputConfig.newBuilder(inputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputConfig_ = value;
        }
        onChanged();
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    public Builder clearInputConfig() {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
        onChanged();
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    public com.google.cloud.automl.v1.BatchPredictInputConfig.Builder getInputConfigBuilder() {

      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    public com.google.cloud.automl.v1.BatchPredictInputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.automl.v1.BatchPredictInputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The input config that was given upon starting this
     * batch predict operation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.BatchPredictInputConfig input_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.BatchPredictInputConfig,
            com.google.cloud.automl.v1.BatchPredictInputConfig.Builder,
            com.google.cloud.automl.v1.BatchPredictInputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.BatchPredictInputConfig,
                com.google.cloud.automl.v1.BatchPredictInputConfig.Builder,
                com.google.cloud.automl.v1.BatchPredictInputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo,
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo.Builder,
            com.google.cloud.automl.v1.BatchPredictOperationMetadata
                .BatchPredictOutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return outputInfoBuilder_ != null || outputInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
        getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo.Builder
            builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (outputInfo_ != null) {
          outputInfo_ =
              com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                  .newBuilder(outputInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputInfo_ = value;
        }
        onChanged();
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    public Builder clearOutputInfo() {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
        onChanged();
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo.Builder
        getOutputInfoBuilder() {

      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this batch predict's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo output_info = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo,
            com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo.Builder,
            com.google.cloud.automl.v1.BatchPredictOperationMetadata
                .BatchPredictOutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo,
                com.google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
                    .Builder,
                com.google.cloud.automl.v1.BatchPredictOperationMetadata
                    .BatchPredictOutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.BatchPredictOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.BatchPredictOperationMetadata)
  private static final com.google.cloud.automl.v1.BatchPredictOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.BatchPredictOperationMetadata();
  }

  public static com.google.cloud.automl.v1.BatchPredictOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchPredictOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchPredictOperationMetadata>() {
        @java.lang.Override
        public BatchPredictOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BatchPredictOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BatchPredictOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchPredictOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.BatchPredictOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
