/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/io.proto

package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Output configuration for BatchPredict Action.
 * As destination the
 * [gcs_destination][google.cloud.automl.v1.BatchPredictOutputConfig.gcs_destination]
 * must be set unless specified otherwise for a domain. If gcs_destination is
 * set then in the given directory a new directory is created. Its name
 * will be
 * "prediction-&lt;model-display-name&gt;-&lt;timestamp-of-prediction-call&gt;",
 * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. The contents
 * of it depends on the ML problem the predictions are made for.
 *  *  For Image Classification:
 *         In the created directory files `image_classification_1.jsonl`,
 *         `image_classification_2.jsonl`,...,`image_classification_N.jsonl`
 *         will be created, where N may be 1, and depends on the
 *         total number of the successfully predicted images and annotations.
 *         A single image will be listed only once with all its annotations,
 *         and its annotations will never be split across files.
 *         Each .JSONL file will contain, per line, a JSON representation of a
 *         proto that wraps image's "ID" : "&lt;id_value&gt;" followed by a list of
 *         zero or more AnnotationPayload protos (called annotations), which
 *         have classification detail populated.
 *         If prediction for any image failed (partially or completely), then an
 *         additional `errors_1.jsonl`, `errors_2.jsonl`,..., `errors_N.jsonl`
 *         files will be created (N depends on total number of failed
 *         predictions). These files will have a JSON representation of a proto
 *         that wraps the same "ID" : "&lt;id_value&gt;" but here followed by
 *         exactly one
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *         containing only `code` and `message`fields.
 *  *  For Image Object Detection:
 *         In the created directory files `image_object_detection_1.jsonl`,
 *         `image_object_detection_2.jsonl`,...,`image_object_detection_N.jsonl`
 *         will be created, where N may be 1, and depends on the
 *         total number of the successfully predicted images and annotations.
 *         Each .JSONL file will contain, per line, a JSON representation of a
 *         proto that wraps image's "ID" : "&lt;id_value&gt;" followed by a list of
 *         zero or more AnnotationPayload protos (called annotations), which
 *         have image_object_detection detail populated. A single image will
 *         be listed only once with all its annotations, and its annotations
 *         will never be split across files.
 *         If prediction for any image failed (partially or completely), then
 *         additional `errors_1.jsonl`, `errors_2.jsonl`,..., `errors_N.jsonl`
 *         files will be created (N depends on total number of failed
 *         predictions). These files will have a JSON representation of a proto
 *         that wraps the same "ID" : "&lt;id_value&gt;" but here followed by
 *         exactly one
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *         containing only `code` and `message`fields.
 *  *  For Video Classification:
 *         In the created directory a video_classification.csv file, and a .JSON
 *         file per each video classification requested in the input (i.e. each
 *         line in given CSV(s)), will be created.
 *         The format of video_classification.csv is:
 * GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END,JSON_FILE_NAME,STATUS
 *         where:
 *         GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END = matches 1 to 1
 *             the prediction input lines (i.e. video_classification.csv has
 *             precisely the same number of lines as the prediction input had.)
 *         JSON_FILE_NAME = Name of .JSON file in the output directory, which
 *             contains prediction responses for the video time segment.
 *         STATUS = "OK" if prediction completed successfully, or an error code
 *             with message otherwise. If STATUS is not "OK" then the .JSON file
 *             for that line may not exist or be empty.
 *         Each .JSON file, assuming STATUS is "OK", will contain a list of
 *         AnnotationPayload protos in JSON format, which are the predictions
 *         for the video time segment the file is assigned to in the
 *         video_classification.csv. All AnnotationPayload protos will have
 *         video_classification field set, and will be sorted by
 *         video_classification.type field (note that the returned types are
 *         governed by `classifaction_types` parameter in
 *         [PredictService.BatchPredictRequest.params][]).
 *  *  For Video Object Tracking:
 *         In the created directory a video_object_tracking.csv file will be
 *         created, and multiple files video_object_trackinng_1.json,
 *         video_object_trackinng_2.json,..., video_object_trackinng_N.json,
 *         where N is the number of requests in the input (i.e. the number of
 *         lines in given CSV(s)).
 *         The format of video_object_tracking.csv is:
 * GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END,JSON_FILE_NAME,STATUS
 *         where:
 *         GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END = matches 1 to 1
 *             the prediction input lines (i.e. video_object_tracking.csv has
 *             precisely the same number of lines as the prediction input had.)
 *         JSON_FILE_NAME = Name of .JSON file in the output directory, which
 *             contains prediction responses for the video time segment.
 *         STATUS = "OK" if prediction completed successfully, or an error
 *             code with message otherwise. If STATUS is not "OK" then the .JSON
 *             file for that line may not exist or be empty.
 *         Each .JSON file, assuming STATUS is "OK", will contain a list of
 *         AnnotationPayload protos in JSON format, which are the predictions
 *         for each frame of the video time segment the file is assigned to in
 *         video_object_tracking.csv. All AnnotationPayload protos will have
 *         video_object_tracking field set.
 *  *  For Text Classification:
 *         In the created directory files `text_classification_1.jsonl`,
 *         `text_classification_2.jsonl`,...,`text_classification_N.jsonl`
 *         will be created, where N may be 1, and depends on the
 *         total number of inputs and annotations found.
 *         Each .JSONL file will contain, per line, a JSON representation of a
 *         proto that wraps input text file (or document) in
 *         the text snippet (or document) proto and a list of
 *         zero or more AnnotationPayload protos (called annotations), which
 *         have classification detail populated. A single text file (or
 *         document) will be listed only once with all its annotations, and its
 *         annotations will never be split across files.
 *         If prediction for any input file (or document) failed (partially or
 *         completely), then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
 *         `errors_N.jsonl` files will be created (N depends on total number of
 *         failed predictions). These files will have a JSON representation of a
 *         proto that wraps input file followed by exactly one
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *         containing only `code` and `message`.
 *  *  For Text Sentiment:
 *         In the created directory files `text_sentiment_1.jsonl`,
 *         `text_sentiment_2.jsonl`,...,`text_sentiment_N.jsonl`
 *         will be created, where N may be 1, and depends on the
 *         total number of inputs and annotations found.
 *         Each .JSONL file will contain, per line, a JSON representation of a
 *         proto that wraps input text file (or document) in
 *         the text snippet (or document) proto and a list of
 *         zero or more AnnotationPayload protos (called annotations), which
 *         have text_sentiment detail populated. A single text file (or
 *         document) will be listed only once with all its annotations, and its
 *         annotations will never be split across files.
 *         If prediction for any input file (or document) failed (partially or
 *         completely), then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
 *         `errors_N.jsonl` files will be created (N depends on total number of
 *         failed predictions). These files will have a JSON representation of a
 *         proto that wraps input file followed by exactly one
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *         containing only `code` and `message`.
 *   *  For Text Extraction:
 *         In the created directory files `text_extraction_1.jsonl`,
 *         `text_extraction_2.jsonl`,...,`text_extraction_N.jsonl`
 *         will be created, where N may be 1, and depends on the
 *         total number of inputs and annotations found.
 *         The contents of these .JSONL file(s) depend on whether the input
 *         used inline text, or documents.
 *         If input was inline, then each .JSONL file will contain, per line,
 *           a JSON representation of a proto that wraps given in request text
 *           snippet's "id" (if specified), followed by input text snippet,
 *           and a list of zero or more
 *           AnnotationPayload protos (called annotations), which have
 *           text_extraction detail populated. A single text snippet will be
 *           listed only once with all its annotations, and its annotations will
 *           never be split across files.
 *         If input used documents, then each .JSONL file will contain, per
 *           line, a JSON representation of a proto that wraps given in request
 *           document proto, followed by its OCR-ed representation in the form
 *           of a text snippet, finally followed by a list of zero or more
 *           AnnotationPayload protos (called annotations), which have
 *           text_extraction detail populated and refer, via their indices, to
 *           the OCR-ed text snippet. A single document (and its text snippet)
 *           will be listed only once with all its annotations, and its
 *           annotations will never be split across files.
 *         If prediction for any text snippet failed (partially or completely),
 *         then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
 *         `errors_N.jsonl` files will be created (N depends on total number of
 *         failed predictions). These files will have a JSON representation of a
 *         proto that wraps either the "id" : "&lt;id_value&gt;" (in case of inline)
 *         or the document proto (in case of document) but here followed by
 *         exactly one
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *         containing only `code` and `message`.
 *  *  For Tables:
 *         Output depends on whether
 * [gcs_destination][google.cloud.automl.v1p1beta.BatchPredictOutputConfig.gcs_destination]
 *         or
 * [bigquery_destination][google.cloud.automl.v1p1beta.BatchPredictOutputConfig.bigquery_destination]
 *         is set (either is allowed).
 *         Google Cloud Storage case:
 *           In the created directory files `tables_1.csv`, `tables_2.csv`,...,
 *           `tables_N.csv` will be created, where N may be 1, and depends on
 *           the total number of the successfully predicted rows.
 *           For all CLASSIFICATION
 * [prediction_type-s][google.cloud.automl.v1p1beta.TablesModelMetadata.prediction_type]:
 *             Each .csv file will contain a header, listing all columns'
 * [display_name-s][google.cloud.automl.v1p1beta.ColumnSpec.display_name]
 *             given on input followed by M target column names in the format of
 * "&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
 * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;_&lt;target
 *             value&gt;_score" where M is the number of distinct target values,
 *             i.e. number of distinct values in the target column of the table
 *             used to train the model. Subsequent lines will contain the
 *             respective values of successfully predicted rows, with the last,
 *             i.e. the target, columns having the corresponding prediction
 *             [scores][google.cloud.automl.v1p1beta.TablesAnnotation.score].
 *           For REGRESSION and FORECASTING
 * [prediction_type-s][google.cloud.automl.v1p1beta.TablesModelMetadata.prediction_type]:
 *             Each .csv file will contain a header, listing all columns'
 *             [display_name-s][google.cloud.automl.v1p1beta.display_name]
 *             given on input followed by the predicted target column with name
 *             in the format of
 * "predicted_&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
 * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;"
 *             Subsequent lines will contain the respective values of
 *             successfully predicted rows, with the last, i.e. the target,
 *             column having the predicted target value.
 *             If prediction for any rows failed, then an additional
 *             `errors_1.csv`, `errors_2.csv`,..., `errors_N.csv` will be
 *             created (N depends on total number of failed rows). These files
 *             will have analogous format as `tables_*.csv`, but always with a
 *             single target column having
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *             represented as a JSON string, and containing only `code` and
 *             `message`.
 *         BigQuery case:
 * [bigquery_destination][google.cloud.automl.v1p1beta.OutputConfig.bigquery_destination]
 *           pointing to a BigQuery project must be set. In the given project a
 *           new dataset will be created with name
 *           `prediction_&lt;model-display-name&gt;_&lt;timestamp-of-prediction-call&gt;`
 *           where &lt;model-display-name&gt; will be made
 *           BigQuery-dataset-name compatible (e.g. most special characters will
 *           become underscores), and timestamp will be in
 *           YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
 *           two tables will be created, `predictions`, and `errors`.
 *           The `predictions` table's column names will be the input columns'
 * [display_name-s][google.cloud.automl.v1p1beta.ColumnSpec.display_name]
 *           followed by the target column with name in the format of
 * "predicted_&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
 * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;"
 *           The input feature columns will contain the respective values of
 *           successfully predicted rows, with the target column having an
 *           ARRAY of
 * [AnnotationPayloads][google.cloud.automl.v1p1beta.AnnotationPayload],
 *           represented as STRUCT-s, containing
 *           [TablesAnnotation][google.cloud.automl.v1p1beta.TablesAnnotation].
 *           The `errors` table contains rows for which the prediction has
 *           failed, it has analogous input columns while the target column name
 *           is in the format of
 * "errors_&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
 * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;",
 *           and as a value has
 * [`google.rpc.Status`](https:
 * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
 *           represented as a STRUCT, and containing only `code` and `message`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.BatchPredictOutputConfig}
 */
public final class BatchPredictOutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.BatchPredictOutputConfig)
    BatchPredictOutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchPredictOutputConfig.newBuilder() to construct.
  private BatchPredictOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchPredictOutputConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchPredictOutputConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BatchPredictOutputConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.automl.v1.GcsDestination.Builder subBuilder = null;
              if (destinationCase_ == 1) {
                subBuilder = ((com.google.cloud.automl.v1.GcsDestination) destination_).toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.automl.v1.GcsDestination.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.automl.v1.GcsDestination) destination_);
                destination_ = subBuilder.buildPartial();
              }
              destinationCase_ = 1;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.Io
        .internal_static_google_cloud_automl_v1_BatchPredictOutputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.Io
        .internal_static_google_cloud_automl_v1_BatchPredictOutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.BatchPredictOutputConfig.class,
            com.google.cloud.automl.v1.BatchPredictOutputConfig.Builder.class);
  }

  private int destinationCase_ = 0;
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(1),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the directory where the output is to
   * be written to.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the directory where the output is to
   * be written to.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.GcsDestination getGcsDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.automl.v1.GcsDestination) destination_;
    }
    return com.google.cloud.automl.v1.GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the directory where the output is to
   * be written to.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.automl.v1.GcsDestination) destination_;
    }
    return com.google.cloud.automl.v1.GcsDestination.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.automl.v1.GcsDestination) destination_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.automl.v1.GcsDestination) destination_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.BatchPredictOutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.BatchPredictOutputConfig other =
        (com.google.cloud.automl.v1.BatchPredictOutputConfig) obj;

    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1.BatchPredictOutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output configuration for BatchPredict Action.
   * As destination the
   * [gcs_destination][google.cloud.automl.v1.BatchPredictOutputConfig.gcs_destination]
   * must be set unless specified otherwise for a domain. If gcs_destination is
   * set then in the given directory a new directory is created. Its name
   * will be
   * "prediction-&lt;model-display-name&gt;-&lt;timestamp-of-prediction-call&gt;",
   * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. The contents
   * of it depends on the ML problem the predictions are made for.
   *  *  For Image Classification:
   *         In the created directory files `image_classification_1.jsonl`,
   *         `image_classification_2.jsonl`,...,`image_classification_N.jsonl`
   *         will be created, where N may be 1, and depends on the
   *         total number of the successfully predicted images and annotations.
   *         A single image will be listed only once with all its annotations,
   *         and its annotations will never be split across files.
   *         Each .JSONL file will contain, per line, a JSON representation of a
   *         proto that wraps image's "ID" : "&lt;id_value&gt;" followed by a list of
   *         zero or more AnnotationPayload protos (called annotations), which
   *         have classification detail populated.
   *         If prediction for any image failed (partially or completely), then an
   *         additional `errors_1.jsonl`, `errors_2.jsonl`,..., `errors_N.jsonl`
   *         files will be created (N depends on total number of failed
   *         predictions). These files will have a JSON representation of a proto
   *         that wraps the same "ID" : "&lt;id_value&gt;" but here followed by
   *         exactly one
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *         containing only `code` and `message`fields.
   *  *  For Image Object Detection:
   *         In the created directory files `image_object_detection_1.jsonl`,
   *         `image_object_detection_2.jsonl`,...,`image_object_detection_N.jsonl`
   *         will be created, where N may be 1, and depends on the
   *         total number of the successfully predicted images and annotations.
   *         Each .JSONL file will contain, per line, a JSON representation of a
   *         proto that wraps image's "ID" : "&lt;id_value&gt;" followed by a list of
   *         zero or more AnnotationPayload protos (called annotations), which
   *         have image_object_detection detail populated. A single image will
   *         be listed only once with all its annotations, and its annotations
   *         will never be split across files.
   *         If prediction for any image failed (partially or completely), then
   *         additional `errors_1.jsonl`, `errors_2.jsonl`,..., `errors_N.jsonl`
   *         files will be created (N depends on total number of failed
   *         predictions). These files will have a JSON representation of a proto
   *         that wraps the same "ID" : "&lt;id_value&gt;" but here followed by
   *         exactly one
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *         containing only `code` and `message`fields.
   *  *  For Video Classification:
   *         In the created directory a video_classification.csv file, and a .JSON
   *         file per each video classification requested in the input (i.e. each
   *         line in given CSV(s)), will be created.
   *         The format of video_classification.csv is:
   * GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END,JSON_FILE_NAME,STATUS
   *         where:
   *         GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END = matches 1 to 1
   *             the prediction input lines (i.e. video_classification.csv has
   *             precisely the same number of lines as the prediction input had.)
   *         JSON_FILE_NAME = Name of .JSON file in the output directory, which
   *             contains prediction responses for the video time segment.
   *         STATUS = "OK" if prediction completed successfully, or an error code
   *             with message otherwise. If STATUS is not "OK" then the .JSON file
   *             for that line may not exist or be empty.
   *         Each .JSON file, assuming STATUS is "OK", will contain a list of
   *         AnnotationPayload protos in JSON format, which are the predictions
   *         for the video time segment the file is assigned to in the
   *         video_classification.csv. All AnnotationPayload protos will have
   *         video_classification field set, and will be sorted by
   *         video_classification.type field (note that the returned types are
   *         governed by `classifaction_types` parameter in
   *         [PredictService.BatchPredictRequest.params][]).
   *  *  For Video Object Tracking:
   *         In the created directory a video_object_tracking.csv file will be
   *         created, and multiple files video_object_trackinng_1.json,
   *         video_object_trackinng_2.json,..., video_object_trackinng_N.json,
   *         where N is the number of requests in the input (i.e. the number of
   *         lines in given CSV(s)).
   *         The format of video_object_tracking.csv is:
   * GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END,JSON_FILE_NAME,STATUS
   *         where:
   *         GCS_FILE_PATH,TIME_SEGMENT_START,TIME_SEGMENT_END = matches 1 to 1
   *             the prediction input lines (i.e. video_object_tracking.csv has
   *             precisely the same number of lines as the prediction input had.)
   *         JSON_FILE_NAME = Name of .JSON file in the output directory, which
   *             contains prediction responses for the video time segment.
   *         STATUS = "OK" if prediction completed successfully, or an error
   *             code with message otherwise. If STATUS is not "OK" then the .JSON
   *             file for that line may not exist or be empty.
   *         Each .JSON file, assuming STATUS is "OK", will contain a list of
   *         AnnotationPayload protos in JSON format, which are the predictions
   *         for each frame of the video time segment the file is assigned to in
   *         video_object_tracking.csv. All AnnotationPayload protos will have
   *         video_object_tracking field set.
   *  *  For Text Classification:
   *         In the created directory files `text_classification_1.jsonl`,
   *         `text_classification_2.jsonl`,...,`text_classification_N.jsonl`
   *         will be created, where N may be 1, and depends on the
   *         total number of inputs and annotations found.
   *         Each .JSONL file will contain, per line, a JSON representation of a
   *         proto that wraps input text file (or document) in
   *         the text snippet (or document) proto and a list of
   *         zero or more AnnotationPayload protos (called annotations), which
   *         have classification detail populated. A single text file (or
   *         document) will be listed only once with all its annotations, and its
   *         annotations will never be split across files.
   *         If prediction for any input file (or document) failed (partially or
   *         completely), then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
   *         `errors_N.jsonl` files will be created (N depends on total number of
   *         failed predictions). These files will have a JSON representation of a
   *         proto that wraps input file followed by exactly one
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *         containing only `code` and `message`.
   *  *  For Text Sentiment:
   *         In the created directory files `text_sentiment_1.jsonl`,
   *         `text_sentiment_2.jsonl`,...,`text_sentiment_N.jsonl`
   *         will be created, where N may be 1, and depends on the
   *         total number of inputs and annotations found.
   *         Each .JSONL file will contain, per line, a JSON representation of a
   *         proto that wraps input text file (or document) in
   *         the text snippet (or document) proto and a list of
   *         zero or more AnnotationPayload protos (called annotations), which
   *         have text_sentiment detail populated. A single text file (or
   *         document) will be listed only once with all its annotations, and its
   *         annotations will never be split across files.
   *         If prediction for any input file (or document) failed (partially or
   *         completely), then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
   *         `errors_N.jsonl` files will be created (N depends on total number of
   *         failed predictions). These files will have a JSON representation of a
   *         proto that wraps input file followed by exactly one
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *         containing only `code` and `message`.
   *   *  For Text Extraction:
   *         In the created directory files `text_extraction_1.jsonl`,
   *         `text_extraction_2.jsonl`,...,`text_extraction_N.jsonl`
   *         will be created, where N may be 1, and depends on the
   *         total number of inputs and annotations found.
   *         The contents of these .JSONL file(s) depend on whether the input
   *         used inline text, or documents.
   *         If input was inline, then each .JSONL file will contain, per line,
   *           a JSON representation of a proto that wraps given in request text
   *           snippet's "id" (if specified), followed by input text snippet,
   *           and a list of zero or more
   *           AnnotationPayload protos (called annotations), which have
   *           text_extraction detail populated. A single text snippet will be
   *           listed only once with all its annotations, and its annotations will
   *           never be split across files.
   *         If input used documents, then each .JSONL file will contain, per
   *           line, a JSON representation of a proto that wraps given in request
   *           document proto, followed by its OCR-ed representation in the form
   *           of a text snippet, finally followed by a list of zero or more
   *           AnnotationPayload protos (called annotations), which have
   *           text_extraction detail populated and refer, via their indices, to
   *           the OCR-ed text snippet. A single document (and its text snippet)
   *           will be listed only once with all its annotations, and its
   *           annotations will never be split across files.
   *         If prediction for any text snippet failed (partially or completely),
   *         then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
   *         `errors_N.jsonl` files will be created (N depends on total number of
   *         failed predictions). These files will have a JSON representation of a
   *         proto that wraps either the "id" : "&lt;id_value&gt;" (in case of inline)
   *         or the document proto (in case of document) but here followed by
   *         exactly one
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *         containing only `code` and `message`.
   *  *  For Tables:
   *         Output depends on whether
   * [gcs_destination][google.cloud.automl.v1p1beta.BatchPredictOutputConfig.gcs_destination]
   *         or
   * [bigquery_destination][google.cloud.automl.v1p1beta.BatchPredictOutputConfig.bigquery_destination]
   *         is set (either is allowed).
   *         Google Cloud Storage case:
   *           In the created directory files `tables_1.csv`, `tables_2.csv`,...,
   *           `tables_N.csv` will be created, where N may be 1, and depends on
   *           the total number of the successfully predicted rows.
   *           For all CLASSIFICATION
   * [prediction_type-s][google.cloud.automl.v1p1beta.TablesModelMetadata.prediction_type]:
   *             Each .csv file will contain a header, listing all columns'
   * [display_name-s][google.cloud.automl.v1p1beta.ColumnSpec.display_name]
   *             given on input followed by M target column names in the format of
   * "&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
   * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;_&lt;target
   *             value&gt;_score" where M is the number of distinct target values,
   *             i.e. number of distinct values in the target column of the table
   *             used to train the model. Subsequent lines will contain the
   *             respective values of successfully predicted rows, with the last,
   *             i.e. the target, columns having the corresponding prediction
   *             [scores][google.cloud.automl.v1p1beta.TablesAnnotation.score].
   *           For REGRESSION and FORECASTING
   * [prediction_type-s][google.cloud.automl.v1p1beta.TablesModelMetadata.prediction_type]:
   *             Each .csv file will contain a header, listing all columns'
   *             [display_name-s][google.cloud.automl.v1p1beta.display_name]
   *             given on input followed by the predicted target column with name
   *             in the format of
   * "predicted_&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
   * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;"
   *             Subsequent lines will contain the respective values of
   *             successfully predicted rows, with the last, i.e. the target,
   *             column having the predicted target value.
   *             If prediction for any rows failed, then an additional
   *             `errors_1.csv`, `errors_2.csv`,..., `errors_N.csv` will be
   *             created (N depends on total number of failed rows). These files
   *             will have analogous format as `tables_*.csv`, but always with a
   *             single target column having
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *             represented as a JSON string, and containing only `code` and
   *             `message`.
   *         BigQuery case:
   * [bigquery_destination][google.cloud.automl.v1p1beta.OutputConfig.bigquery_destination]
   *           pointing to a BigQuery project must be set. In the given project a
   *           new dataset will be created with name
   *           `prediction_&lt;model-display-name&gt;_&lt;timestamp-of-prediction-call&gt;`
   *           where &lt;model-display-name&gt; will be made
   *           BigQuery-dataset-name compatible (e.g. most special characters will
   *           become underscores), and timestamp will be in
   *           YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
   *           two tables will be created, `predictions`, and `errors`.
   *           The `predictions` table's column names will be the input columns'
   * [display_name-s][google.cloud.automl.v1p1beta.ColumnSpec.display_name]
   *           followed by the target column with name in the format of
   * "predicted_&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
   * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;"
   *           The input feature columns will contain the respective values of
   *           successfully predicted rows, with the target column having an
   *           ARRAY of
   * [AnnotationPayloads][google.cloud.automl.v1p1beta.AnnotationPayload],
   *           represented as STRUCT-s, containing
   *           [TablesAnnotation][google.cloud.automl.v1p1beta.TablesAnnotation].
   *           The `errors` table contains rows for which the prediction has
   *           failed, it has analogous input columns while the target column name
   *           is in the format of
   * "errors_&lt;[target_column_specs][google.cloud.automl.v1p1beta.TablesModelMetadata.target_column_spec]
   * [display_name][google.cloud.automl.v1p1beta.ColumnSpec.display_name]&gt;",
   *           and as a value has
   * [`google.rpc.Status`](https:
   * //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
   *           represented as a STRUCT, and containing only `code` and `message`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.BatchPredictOutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.BatchPredictOutputConfig)
      com.google.cloud.automl.v1.BatchPredictOutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Io
          .internal_static_google_cloud_automl_v1_BatchPredictOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Io
          .internal_static_google_cloud_automl_v1_BatchPredictOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.BatchPredictOutputConfig.class,
              com.google.cloud.automl.v1.BatchPredictOutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.BatchPredictOutputConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.Io
          .internal_static_google_cloud_automl_v1_BatchPredictOutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOutputConfig getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.BatchPredictOutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOutputConfig build() {
      com.google.cloud.automl.v1.BatchPredictOutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.BatchPredictOutputConfig buildPartial() {
      com.google.cloud.automl.v1.BatchPredictOutputConfig result =
          new com.google.cloud.automl.v1.BatchPredictOutputConfig(this);
      if (destinationCase_ == 1) {
        if (gcsDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcsDestinationBuilder_.build();
        }
      }
      result.destinationCase_ = destinationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.BatchPredictOutputConfig) {
        return mergeFrom((com.google.cloud.automl.v1.BatchPredictOutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.BatchPredictOutputConfig other) {
      if (other == com.google.cloud.automl.v1.BatchPredictOutputConfig.getDefaultInstance())
        return this;
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1.BatchPredictOutputConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1.BatchPredictOutputConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.GcsDestination,
            com.google.cloud.automl.v1.GcsDestination.Builder,
            com.google.cloud.automl.v1.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.automl.v1.GcsDestination) destination_;
        }
        return com.google.cloud.automl.v1.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGcsDestination(com.google.cloud.automl.v1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGcsDestination(
        com.google.cloud.automl.v1.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeGcsDestination(com.google.cloud.automl.v1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_ != com.google.cloud.automl.v1.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.automl.v1.GcsDestination.newBuilder(
                      (com.google.cloud.automl.v1.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsDestinationBuilder_.mergeFrom(value);
        }
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.automl.v1.GcsDestination.Builder getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.automl.v1.GcsDestination) destination_;
        }
        return com.google.cloud.automl.v1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the directory where the output is to
     * be written to.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.GcsDestination,
            com.google.cloud.automl.v1.GcsDestination.Builder,
            com.google.cloud.automl.v1.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ = com.google.cloud.automl.v1.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.GcsDestination,
                com.google.cloud.automl.v1.GcsDestination.Builder,
                com.google.cloud.automl.v1.GcsDestinationOrBuilder>(
                (com.google.cloud.automl.v1.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      ;
      return gcsDestinationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.BatchPredictOutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.BatchPredictOutputConfig)
  private static final com.google.cloud.automl.v1.BatchPredictOutputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.BatchPredictOutputConfig();
  }

  public static com.google.cloud.automl.v1.BatchPredictOutputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchPredictOutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<BatchPredictOutputConfig>() {
        @java.lang.Override
        public BatchPredictOutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BatchPredictOutputConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BatchPredictOutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchPredictOutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.BatchPredictOutputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
