/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/operations.proto

package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Details of ExportData operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.ExportDataOperationMetadata}
 */
public final class ExportDataOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.ExportDataOperationMetadata)
    ExportDataOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportDataOperationMetadata.newBuilder() to construct.
  private ExportDataOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportDataOperationMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportDataOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ExportDataOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder
                  subBuilder = null;
              if (outputInfo_ != null) {
                subBuilder = outputInfo_.toBuilder();
              }
              outputInfo_ =
                  input.readMessage(
                      com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputInfo_);
                outputInfo_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.Operations
        .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.Operations
        .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.ExportDataOperationMetadata.class,
            com.google.cloud.automl.v1.ExportDataOperationMetadata.Builder.class);
  }

  public interface ExportDataOutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the exported data is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the exported data is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();

    public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
            .OutputLocationCase
        getOutputLocationCase();
  }
  /**
   *
   *
   * <pre>
   * Further describes this export data's output.
   * Supplements
   * [OutputConfig][google.cloud.automl.v1.OutputConfig].
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo}
   */
  public static final class ExportDataOutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)
      ExportDataOutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExportDataOutputInfo.newBuilder() to construct.
    private ExportDataOutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExportDataOutputInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExportDataOutputInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ExportDataOutputInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                outputLocationCase_ = 1;
                outputLocation_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_ExportDataOutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_ExportDataOutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.class,
              com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder
                  .class);
    }

    private int outputLocationCase_ = 0;
    private java.lang.Object outputLocation_;

    public enum OutputLocationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_OUTPUT_DIRECTORY(1),
      OUTPUTLOCATION_NOT_SET(0);
      private final int value;

      private OutputLocationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OutputLocationCase valueOf(int value) {
        return forNumber(value);
      }

      public static OutputLocationCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCS_OUTPUT_DIRECTORY;
          case 0:
            return OUTPUTLOCATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OutputLocationCase getOutputLocationCase() {
      return OutputLocationCase.forNumber(outputLocationCase_);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the exported data is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputLocationCase_ == 1) {
          outputLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the exported data is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputLocationCase_ == 1) {
          outputLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (outputLocationCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, outputLocation_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (outputLocationCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, outputLocation_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo other =
          (com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo) obj;

      if (!getOutputLocationCase().equals(other.getOutputLocationCase())) return false;
      switch (outputLocationCase_) {
        case 1:
          if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (outputLocationCase_) {
        case 1:
          hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
          hash = (53 * hash) + getGcsOutputDirectory().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes this export data's output.
     * Supplements
     * [OutputConfig][google.cloud.automl.v1.OutputConfig].
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_ExportDataOutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_ExportDataOutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.class,
                com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        outputLocationCase_ = 0;
        outputLocation_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_ExportDataOutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo build() {
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
          buildPartial() {
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo result =
            new com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo(this);
        if (outputLocationCase_ == 1) {
          result.outputLocation_ = outputLocation_;
        }
        result.outputLocationCase_ = outputLocationCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo) {
          return mergeFrom(
              (com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo other) {
        if (other
            == com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
                .getDefaultInstance()) return this;
        switch (other.getOutputLocationCase()) {
          case GCS_OUTPUT_DIRECTORY:
            {
              outputLocationCase_ = 1;
              outputLocation_ = other.outputLocation_;
              onChanged();
              break;
            }
          case OUTPUTLOCATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int outputLocationCase_ = 0;
      private java.lang.Object outputLocation_;

      public OutputLocationCase getOutputLocationCase() {
        return OutputLocationCase.forNumber(outputLocationCase_);
      }

      public Builder clearOutputLocation() {
        outputLocationCase_ = 0;
        outputLocation_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the exported data is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The gcsOutputDirectory.
       */
      @java.lang.Override
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputLocationCase_ == 1) {
            outputLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the exported data is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputLocationCase_ == 1) {
            outputLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the exported data is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the exported data is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        if (outputLocationCase_ == 1) {
          outputLocationCase_ = 0;
          outputLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the exported data is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo)
    private static final com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo();
    }

    public static com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExportDataOutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<ExportDataOutputInfo>() {
          @java.lang.Override
          public ExportDataOutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ExportDataOutputInfo(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ExportDataOutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExportDataOutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 1;
  private com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing this export data's output.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  @java.lang.Override
  public boolean hasOutputInfo() {
    return outputInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing this export data's output.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
   * </code>
   *
   * @return The outputInfo.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
      getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing this export data's output.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return getOutputInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (outputInfo_ != null) {
      output.writeMessage(1, getOutputInfo());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (outputInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOutputInfo());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.ExportDataOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.ExportDataOperationMetadata other =
        (com.google.cloud.automl.v1.ExportDataOperationMetadata) obj;

    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1.ExportDataOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of ExportData operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.ExportDataOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.ExportDataOperationMetadata)
      com.google.cloud.automl.v1.ExportDataOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.ExportDataOperationMetadata.class,
              com.google.cloud.automl.v1.ExportDataOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.ExportDataOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportDataOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportDataOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.ExportDataOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportDataOperationMetadata build() {
      com.google.cloud.automl.v1.ExportDataOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportDataOperationMetadata buildPartial() {
      com.google.cloud.automl.v1.ExportDataOperationMetadata result =
          new com.google.cloud.automl.v1.ExportDataOperationMetadata(this);
      if (outputInfoBuilder_ == null) {
        result.outputInfo_ = outputInfo_;
      } else {
        result.outputInfo_ = outputInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.ExportDataOperationMetadata) {
        return mergeFrom((com.google.cloud.automl.v1.ExportDataOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.ExportDataOperationMetadata other) {
      if (other == com.google.cloud.automl.v1.ExportDataOperationMetadata.getDefaultInstance())
        return this;
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1.ExportDataOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1.ExportDataOperationMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo,
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder,
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return outputInfoBuilder_ != null || outputInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
        getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder
            builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (outputInfo_ != null) {
          outputInfo_ =
              com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
                  .newBuilder(outputInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputInfo_ = value;
        }
        onChanged();
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    public Builder clearOutputInfo() {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
        onChanged();
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder
        getOutputInfoBuilder() {

      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    public com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing this export data's output.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo output_info = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo,
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder,
            com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo,
                com.google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo.Builder,
                com.google.cloud.automl.v1.ExportDataOperationMetadata
                    .ExportDataOutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.ExportDataOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.ExportDataOperationMetadata)
  private static final com.google.cloud.automl.v1.ExportDataOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.ExportDataOperationMetadata();
  }

  public static com.google.cloud.automl.v1.ExportDataOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportDataOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ExportDataOperationMetadata>() {
        @java.lang.Override
        public ExportDataOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ExportDataOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ExportDataOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportDataOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.ExportDataOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
