/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/image.proto

package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Model metadata for image classification.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.ImageClassificationModelMetadata}
 */
public final class ImageClassificationModelMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.ImageClassificationModelMetadata)
    ImageClassificationModelMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImageClassificationModelMetadata.newBuilder() to construct.
  private ImageClassificationModelMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImageClassificationModelMetadata() {
    baseModelId_ = "";
    stopReason_ = "";
    modelType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImageClassificationModelMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImageClassificationModelMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              baseModelId_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              stopReason_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelType_ = s;
              break;
            }
          case 105:
            {
              nodeQps_ = input.readDouble();
              break;
            }
          case 112:
            {
              nodeCount_ = input.readInt64();
              break;
            }
          case 128:
            {
              trainBudgetMilliNodeHours_ = input.readInt64();
              break;
            }
          case 136:
            {
              trainCostMilliNodeHours_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.ImageProto
        .internal_static_google_cloud_automl_v1_ImageClassificationModelMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.ImageProto
        .internal_static_google_cloud_automl_v1_ImageClassificationModelMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.ImageClassificationModelMetadata.class,
            com.google.cloud.automl.v1.ImageClassificationModelMetadata.Builder.class);
  }

  public static final int BASE_MODEL_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object baseModelId_;
  /**
   *
   *
   * <pre>
   * Optional. The ID of the `base` model. If it is specified, the new model
   * will be created based on the `base` model. Otherwise, the new model will be
   * created from scratch. The `base` model must be in the same
   * `project` and `location` as the new model to create, and have the same
   * `model_type`.
   * </pre>
   *
   * <code>string base_model_id = 1;</code>
   *
   * @return The baseModelId.
   */
  @java.lang.Override
  public java.lang.String getBaseModelId() {
    java.lang.Object ref = baseModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseModelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The ID of the `base` model. If it is specified, the new model
   * will be created based on the `base` model. Otherwise, the new model will be
   * created from scratch. The `base` model must be in the same
   * `project` and `location` as the new model to create, and have the same
   * `model_type`.
   * </pre>
   *
   * <code>string base_model_id = 1;</code>
   *
   * @return The bytes for baseModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseModelIdBytes() {
    java.lang.Object ref = baseModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAIN_BUDGET_MILLI_NODE_HOURS_FIELD_NUMBER = 16;
  private long trainBudgetMilliNodeHours_;
  /**
   *
   *
   * <pre>
   * The train budget of creating this model, expressed in milli node
   * hours i.e. 1,000 value in this field means 1 node hour. The actual
   * `train_cost` will be equal or less than this value. If further model
   * training ceases to provide any improvements, it will stop without using
   * full budget and the stop_reason will be `MODEL_CONVERGED`.
   * Note, node_hour  = actual_hour * number_of_nodes_invovled.
   * For model type `cloud`(default), the train budget must be between 8,000
   * and 800,000 milli node hours, inclusive. The default value is 192, 000
   * which represents one day in wall time. For model type
   * `mobile-low-latency-1`, `mobile-versatile-1`, `mobile-high-accuracy-1`,
   * `mobile-core-ml-low-latency-1`, `mobile-core-ml-versatile-1`,
   * `mobile-core-ml-high-accuracy-1`, the train budget must be between 1,000
   * and 100,000 milli node hours, inclusive. The default value is 24, 000 which
   * represents one day in wall time.
   * </pre>
   *
   * <code>int64 train_budget_milli_node_hours = 16;</code>
   *
   * @return The trainBudgetMilliNodeHours.
   */
  @java.lang.Override
  public long getTrainBudgetMilliNodeHours() {
    return trainBudgetMilliNodeHours_;
  }

  public static final int TRAIN_COST_MILLI_NODE_HOURS_FIELD_NUMBER = 17;
  private long trainCostMilliNodeHours_;
  /**
   *
   *
   * <pre>
   * Output only. The actual train cost of creating this model, expressed in
   * milli node hours, i.e. 1,000 value in this field means 1 node hour.
   * Guaranteed to not exceed the train budget.
   * </pre>
   *
   * <code>int64 train_cost_milli_node_hours = 17;</code>
   *
   * @return The trainCostMilliNodeHours.
   */
  @java.lang.Override
  public long getTrainCostMilliNodeHours() {
    return trainCostMilliNodeHours_;
  }

  public static final int STOP_REASON_FIELD_NUMBER = 5;
  private volatile java.lang.Object stopReason_;
  /**
   *
   *
   * <pre>
   * Output only. The reason that this create model operation stopped,
   * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
   * </pre>
   *
   * <code>string stop_reason = 5;</code>
   *
   * @return The stopReason.
   */
  @java.lang.Override
  public java.lang.String getStopReason() {
    java.lang.Object ref = stopReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stopReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The reason that this create model operation stopped,
   * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
   * </pre>
   *
   * <code>string stop_reason = 5;</code>
   *
   * @return The bytes for stopReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStopReasonBytes() {
    java.lang.Object ref = stopReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stopReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_TYPE_FIELD_NUMBER = 7;
  private volatile java.lang.Object modelType_;
  /**
   *
   *
   * <pre>
   * Optional. Type of the model. The available values are:
   * *   `cloud` - Model to be used via prediction calls to AutoML API.
   *               This is the default value.
   * *   `mobile-low-latency-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
   *               with TensorFlow afterwards. Expected to have low latency, but
   *               may have lower prediction quality than other models.
   * *   `mobile-versatile-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
   *               with TensorFlow afterwards.
   * *   `mobile-high-accuracy-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
   *               with TensorFlow afterwards.  Expected to have a higher
   *               latency, but should also have a higher prediction quality
   *               than other models.
   * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
   *               ML afterwards. Expected to have low latency, but may have
   *               lower prediction quality than other models.
   * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
   *               ML afterwards.
   * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
   *               providing prediction via AutoML API, can also be exported
   *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
   *               Core ML afterwards.  Expected to have a higher latency, but
   *               should also have a higher prediction quality than other
   *               models.
   * </pre>
   *
   * <code>string model_type = 7;</code>
   *
   * @return The modelType.
   */
  @java.lang.Override
  public java.lang.String getModelType() {
    java.lang.Object ref = modelType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Type of the model. The available values are:
   * *   `cloud` - Model to be used via prediction calls to AutoML API.
   *               This is the default value.
   * *   `mobile-low-latency-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
   *               with TensorFlow afterwards. Expected to have low latency, but
   *               may have lower prediction quality than other models.
   * *   `mobile-versatile-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
   *               with TensorFlow afterwards.
   * *   `mobile-high-accuracy-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
   *               with TensorFlow afterwards.  Expected to have a higher
   *               latency, but should also have a higher prediction quality
   *               than other models.
   * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
   *               ML afterwards. Expected to have low latency, but may have
   *               lower prediction quality than other models.
   * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
   *               prediction via AutoML API, can also be exported (see
   *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
   *               ML afterwards.
   * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
   *               providing prediction via AutoML API, can also be exported
   *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
   *               Core ML afterwards.  Expected to have a higher latency, but
   *               should also have a higher prediction quality than other
   *               models.
   * </pre>
   *
   * <code>string model_type = 7;</code>
   *
   * @return The bytes for modelType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelTypeBytes() {
    java.lang.Object ref = modelType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_QPS_FIELD_NUMBER = 13;
  private double nodeQps_;
  /**
   *
   *
   * <pre>
   * Output only. An approximate number of online prediction QPS that can
   * be supported by this model per each node on which it is deployed.
   * </pre>
   *
   * <code>double node_qps = 13;</code>
   *
   * @return The nodeQps.
   */
  @java.lang.Override
  public double getNodeQps() {
    return nodeQps_;
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 14;
  private long nodeCount_;
  /**
   *
   *
   * <pre>
   * Output only. The number of nodes this model is deployed on. A node is an
   * abstraction of a machine resource, which can handle online prediction QPS
   * as given in the node_qps field.
   * </pre>
   *
   * <code>int64 node_count = 14;</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public long getNodeCount() {
    return nodeCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getBaseModelIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, baseModelId_);
    }
    if (!getStopReasonBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, stopReason_);
    }
    if (!getModelTypeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, modelType_);
    }
    if (nodeQps_ != 0D) {
      output.writeDouble(13, nodeQps_);
    }
    if (nodeCount_ != 0L) {
      output.writeInt64(14, nodeCount_);
    }
    if (trainBudgetMilliNodeHours_ != 0L) {
      output.writeInt64(16, trainBudgetMilliNodeHours_);
    }
    if (trainCostMilliNodeHours_ != 0L) {
      output.writeInt64(17, trainCostMilliNodeHours_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getBaseModelIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, baseModelId_);
    }
    if (!getStopReasonBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, stopReason_);
    }
    if (!getModelTypeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, modelType_);
    }
    if (nodeQps_ != 0D) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(13, nodeQps_);
    }
    if (nodeCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(14, nodeCount_);
    }
    if (trainBudgetMilliNodeHours_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(16, trainBudgetMilliNodeHours_);
    }
    if (trainCostMilliNodeHours_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(17, trainCostMilliNodeHours_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.ImageClassificationModelMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.ImageClassificationModelMetadata other =
        (com.google.cloud.automl.v1.ImageClassificationModelMetadata) obj;

    if (!getBaseModelId().equals(other.getBaseModelId())) return false;
    if (getTrainBudgetMilliNodeHours() != other.getTrainBudgetMilliNodeHours()) return false;
    if (getTrainCostMilliNodeHours() != other.getTrainCostMilliNodeHours()) return false;
    if (!getStopReason().equals(other.getStopReason())) return false;
    if (!getModelType().equals(other.getModelType())) return false;
    if (java.lang.Double.doubleToLongBits(getNodeQps())
        != java.lang.Double.doubleToLongBits(other.getNodeQps())) return false;
    if (getNodeCount() != other.getNodeCount()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BASE_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBaseModelId().hashCode();
    hash = (37 * hash) + TRAIN_BUDGET_MILLI_NODE_HOURS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrainBudgetMilliNodeHours());
    hash = (37 * hash) + TRAIN_COST_MILLI_NODE_HOURS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrainCostMilliNodeHours());
    hash = (37 * hash) + STOP_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getStopReason().hashCode();
    hash = (37 * hash) + MODEL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getModelType().hashCode();
    hash = (37 * hash) + NODE_QPS_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getNodeQps()));
    hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNodeCount());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1.ImageClassificationModelMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Model metadata for image classification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.ImageClassificationModelMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.ImageClassificationModelMetadata)
      com.google.cloud.automl.v1.ImageClassificationModelMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.ImageProto
          .internal_static_google_cloud_automl_v1_ImageClassificationModelMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.ImageProto
          .internal_static_google_cloud_automl_v1_ImageClassificationModelMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.ImageClassificationModelMetadata.class,
              com.google.cloud.automl.v1.ImageClassificationModelMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.ImageClassificationModelMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      baseModelId_ = "";

      trainBudgetMilliNodeHours_ = 0L;

      trainCostMilliNodeHours_ = 0L;

      stopReason_ = "";

      modelType_ = "";

      nodeQps_ = 0D;

      nodeCount_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.ImageProto
          .internal_static_google_cloud_automl_v1_ImageClassificationModelMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ImageClassificationModelMetadata getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.ImageClassificationModelMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ImageClassificationModelMetadata build() {
      com.google.cloud.automl.v1.ImageClassificationModelMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ImageClassificationModelMetadata buildPartial() {
      com.google.cloud.automl.v1.ImageClassificationModelMetadata result =
          new com.google.cloud.automl.v1.ImageClassificationModelMetadata(this);
      result.baseModelId_ = baseModelId_;
      result.trainBudgetMilliNodeHours_ = trainBudgetMilliNodeHours_;
      result.trainCostMilliNodeHours_ = trainCostMilliNodeHours_;
      result.stopReason_ = stopReason_;
      result.modelType_ = modelType_;
      result.nodeQps_ = nodeQps_;
      result.nodeCount_ = nodeCount_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.ImageClassificationModelMetadata) {
        return mergeFrom((com.google.cloud.automl.v1.ImageClassificationModelMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.ImageClassificationModelMetadata other) {
      if (other == com.google.cloud.automl.v1.ImageClassificationModelMetadata.getDefaultInstance())
        return this;
      if (!other.getBaseModelId().isEmpty()) {
        baseModelId_ = other.baseModelId_;
        onChanged();
      }
      if (other.getTrainBudgetMilliNodeHours() != 0L) {
        setTrainBudgetMilliNodeHours(other.getTrainBudgetMilliNodeHours());
      }
      if (other.getTrainCostMilliNodeHours() != 0L) {
        setTrainCostMilliNodeHours(other.getTrainCostMilliNodeHours());
      }
      if (!other.getStopReason().isEmpty()) {
        stopReason_ = other.stopReason_;
        onChanged();
      }
      if (!other.getModelType().isEmpty()) {
        modelType_ = other.modelType_;
        onChanged();
      }
      if (other.getNodeQps() != 0D) {
        setNodeQps(other.getNodeQps());
      }
      if (other.getNodeCount() != 0L) {
        setNodeCount(other.getNodeCount());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.automl.v1.ImageClassificationModelMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.automl.v1.ImageClassificationModelMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object baseModelId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The ID of the `base` model. If it is specified, the new model
     * will be created based on the `base` model. Otherwise, the new model will be
     * created from scratch. The `base` model must be in the same
     * `project` and `location` as the new model to create, and have the same
     * `model_type`.
     * </pre>
     *
     * <code>string base_model_id = 1;</code>
     *
     * @return The baseModelId.
     */
    public java.lang.String getBaseModelId() {
      java.lang.Object ref = baseModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the `base` model. If it is specified, the new model
     * will be created based on the `base` model. Otherwise, the new model will be
     * created from scratch. The `base` model must be in the same
     * `project` and `location` as the new model to create, and have the same
     * `model_type`.
     * </pre>
     *
     * <code>string base_model_id = 1;</code>
     *
     * @return The bytes for baseModelId.
     */
    public com.google.protobuf.ByteString getBaseModelIdBytes() {
      java.lang.Object ref = baseModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the `base` model. If it is specified, the new model
     * will be created based on the `base` model. Otherwise, the new model will be
     * created from scratch. The `base` model must be in the same
     * `project` and `location` as the new model to create, and have the same
     * `model_type`.
     * </pre>
     *
     * <code>string base_model_id = 1;</code>
     *
     * @param value The baseModelId to set.
     * @return This builder for chaining.
     */
    public Builder setBaseModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      baseModelId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the `base` model. If it is specified, the new model
     * will be created based on the `base` model. Otherwise, the new model will be
     * created from scratch. The `base` model must be in the same
     * `project` and `location` as the new model to create, and have the same
     * `model_type`.
     * </pre>
     *
     * <code>string base_model_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseModelId() {

      baseModelId_ = getDefaultInstance().getBaseModelId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the `base` model. If it is specified, the new model
     * will be created based on the `base` model. Otherwise, the new model will be
     * created from scratch. The `base` model must be in the same
     * `project` and `location` as the new model to create, and have the same
     * `model_type`.
     * </pre>
     *
     * <code>string base_model_id = 1;</code>
     *
     * @param value The bytes for baseModelId to set.
     * @return This builder for chaining.
     */
    public Builder setBaseModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      baseModelId_ = value;
      onChanged();
      return this;
    }

    private long trainBudgetMilliNodeHours_;
    /**
     *
     *
     * <pre>
     * The train budget of creating this model, expressed in milli node
     * hours i.e. 1,000 value in this field means 1 node hour. The actual
     * `train_cost` will be equal or less than this value. If further model
     * training ceases to provide any improvements, it will stop without using
     * full budget and the stop_reason will be `MODEL_CONVERGED`.
     * Note, node_hour  = actual_hour * number_of_nodes_invovled.
     * For model type `cloud`(default), the train budget must be between 8,000
     * and 800,000 milli node hours, inclusive. The default value is 192, 000
     * which represents one day in wall time. For model type
     * `mobile-low-latency-1`, `mobile-versatile-1`, `mobile-high-accuracy-1`,
     * `mobile-core-ml-low-latency-1`, `mobile-core-ml-versatile-1`,
     * `mobile-core-ml-high-accuracy-1`, the train budget must be between 1,000
     * and 100,000 milli node hours, inclusive. The default value is 24, 000 which
     * represents one day in wall time.
     * </pre>
     *
     * <code>int64 train_budget_milli_node_hours = 16;</code>
     *
     * @return The trainBudgetMilliNodeHours.
     */
    @java.lang.Override
    public long getTrainBudgetMilliNodeHours() {
      return trainBudgetMilliNodeHours_;
    }
    /**
     *
     *
     * <pre>
     * The train budget of creating this model, expressed in milli node
     * hours i.e. 1,000 value in this field means 1 node hour. The actual
     * `train_cost` will be equal or less than this value. If further model
     * training ceases to provide any improvements, it will stop without using
     * full budget and the stop_reason will be `MODEL_CONVERGED`.
     * Note, node_hour  = actual_hour * number_of_nodes_invovled.
     * For model type `cloud`(default), the train budget must be between 8,000
     * and 800,000 milli node hours, inclusive. The default value is 192, 000
     * which represents one day in wall time. For model type
     * `mobile-low-latency-1`, `mobile-versatile-1`, `mobile-high-accuracy-1`,
     * `mobile-core-ml-low-latency-1`, `mobile-core-ml-versatile-1`,
     * `mobile-core-ml-high-accuracy-1`, the train budget must be between 1,000
     * and 100,000 milli node hours, inclusive. The default value is 24, 000 which
     * represents one day in wall time.
     * </pre>
     *
     * <code>int64 train_budget_milli_node_hours = 16;</code>
     *
     * @param value The trainBudgetMilliNodeHours to set.
     * @return This builder for chaining.
     */
    public Builder setTrainBudgetMilliNodeHours(long value) {

      trainBudgetMilliNodeHours_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The train budget of creating this model, expressed in milli node
     * hours i.e. 1,000 value in this field means 1 node hour. The actual
     * `train_cost` will be equal or less than this value. If further model
     * training ceases to provide any improvements, it will stop without using
     * full budget and the stop_reason will be `MODEL_CONVERGED`.
     * Note, node_hour  = actual_hour * number_of_nodes_invovled.
     * For model type `cloud`(default), the train budget must be between 8,000
     * and 800,000 milli node hours, inclusive. The default value is 192, 000
     * which represents one day in wall time. For model type
     * `mobile-low-latency-1`, `mobile-versatile-1`, `mobile-high-accuracy-1`,
     * `mobile-core-ml-low-latency-1`, `mobile-core-ml-versatile-1`,
     * `mobile-core-ml-high-accuracy-1`, the train budget must be between 1,000
     * and 100,000 milli node hours, inclusive. The default value is 24, 000 which
     * represents one day in wall time.
     * </pre>
     *
     * <code>int64 train_budget_milli_node_hours = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainBudgetMilliNodeHours() {

      trainBudgetMilliNodeHours_ = 0L;
      onChanged();
      return this;
    }

    private long trainCostMilliNodeHours_;
    /**
     *
     *
     * <pre>
     * Output only. The actual train cost of creating this model, expressed in
     * milli node hours, i.e. 1,000 value in this field means 1 node hour.
     * Guaranteed to not exceed the train budget.
     * </pre>
     *
     * <code>int64 train_cost_milli_node_hours = 17;</code>
     *
     * @return The trainCostMilliNodeHours.
     */
    @java.lang.Override
    public long getTrainCostMilliNodeHours() {
      return trainCostMilliNodeHours_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The actual train cost of creating this model, expressed in
     * milli node hours, i.e. 1,000 value in this field means 1 node hour.
     * Guaranteed to not exceed the train budget.
     * </pre>
     *
     * <code>int64 train_cost_milli_node_hours = 17;</code>
     *
     * @param value The trainCostMilliNodeHours to set.
     * @return This builder for chaining.
     */
    public Builder setTrainCostMilliNodeHours(long value) {

      trainCostMilliNodeHours_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The actual train cost of creating this model, expressed in
     * milli node hours, i.e. 1,000 value in this field means 1 node hour.
     * Guaranteed to not exceed the train budget.
     * </pre>
     *
     * <code>int64 train_cost_milli_node_hours = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainCostMilliNodeHours() {

      trainCostMilliNodeHours_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object stopReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The reason that this create model operation stopped,
     * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
     * </pre>
     *
     * <code>string stop_reason = 5;</code>
     *
     * @return The stopReason.
     */
    public java.lang.String getStopReason() {
      java.lang.Object ref = stopReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stopReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason that this create model operation stopped,
     * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
     * </pre>
     *
     * <code>string stop_reason = 5;</code>
     *
     * @return The bytes for stopReason.
     */
    public com.google.protobuf.ByteString getStopReasonBytes() {
      java.lang.Object ref = stopReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stopReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason that this create model operation stopped,
     * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
     * </pre>
     *
     * <code>string stop_reason = 5;</code>
     *
     * @param value The stopReason to set.
     * @return This builder for chaining.
     */
    public Builder setStopReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      stopReason_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason that this create model operation stopped,
     * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
     * </pre>
     *
     * <code>string stop_reason = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStopReason() {

      stopReason_ = getDefaultInstance().getStopReason();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason that this create model operation stopped,
     * e.g. `BUDGET_REACHED`, `MODEL_CONVERGED`.
     * </pre>
     *
     * <code>string stop_reason = 5;</code>
     *
     * @param value The bytes for stopReason to set.
     * @return This builder for chaining.
     */
    public Builder setStopReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      stopReason_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object modelType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Type of the model. The available values are:
     * *   `cloud` - Model to be used via prediction calls to AutoML API.
     *               This is the default value.
     * *   `mobile-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards. Expected to have low latency, but
     *               may have lower prediction quality than other models.
     * *   `mobile-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.
     * *   `mobile-high-accuracy-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.  Expected to have a higher
     *               latency, but should also have a higher prediction quality
     *               than other models.
     * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards. Expected to have low latency, but may have
     *               lower prediction quality than other models.
     * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards.
     * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
     *               providing prediction via AutoML API, can also be exported
     *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
     *               Core ML afterwards.  Expected to have a higher latency, but
     *               should also have a higher prediction quality than other
     *               models.
     * </pre>
     *
     * <code>string model_type = 7;</code>
     *
     * @return The modelType.
     */
    public java.lang.String getModelType() {
      java.lang.Object ref = modelType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the model. The available values are:
     * *   `cloud` - Model to be used via prediction calls to AutoML API.
     *               This is the default value.
     * *   `mobile-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards. Expected to have low latency, but
     *               may have lower prediction quality than other models.
     * *   `mobile-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.
     * *   `mobile-high-accuracy-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.  Expected to have a higher
     *               latency, but should also have a higher prediction quality
     *               than other models.
     * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards. Expected to have low latency, but may have
     *               lower prediction quality than other models.
     * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards.
     * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
     *               providing prediction via AutoML API, can also be exported
     *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
     *               Core ML afterwards.  Expected to have a higher latency, but
     *               should also have a higher prediction quality than other
     *               models.
     * </pre>
     *
     * <code>string model_type = 7;</code>
     *
     * @return The bytes for modelType.
     */
    public com.google.protobuf.ByteString getModelTypeBytes() {
      java.lang.Object ref = modelType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the model. The available values are:
     * *   `cloud` - Model to be used via prediction calls to AutoML API.
     *               This is the default value.
     * *   `mobile-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards. Expected to have low latency, but
     *               may have lower prediction quality than other models.
     * *   `mobile-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.
     * *   `mobile-high-accuracy-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.  Expected to have a higher
     *               latency, but should also have a higher prediction quality
     *               than other models.
     * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards. Expected to have low latency, but may have
     *               lower prediction quality than other models.
     * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards.
     * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
     *               providing prediction via AutoML API, can also be exported
     *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
     *               Core ML afterwards.  Expected to have a higher latency, but
     *               should also have a higher prediction quality than other
     *               models.
     * </pre>
     *
     * <code>string model_type = 7;</code>
     *
     * @param value The modelType to set.
     * @return This builder for chaining.
     */
    public Builder setModelType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the model. The available values are:
     * *   `cloud` - Model to be used via prediction calls to AutoML API.
     *               This is the default value.
     * *   `mobile-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards. Expected to have low latency, but
     *               may have lower prediction quality than other models.
     * *   `mobile-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.
     * *   `mobile-high-accuracy-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.  Expected to have a higher
     *               latency, but should also have a higher prediction quality
     *               than other models.
     * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards. Expected to have low latency, but may have
     *               lower prediction quality than other models.
     * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards.
     * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
     *               providing prediction via AutoML API, can also be exported
     *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
     *               Core ML afterwards.  Expected to have a higher latency, but
     *               should also have a higher prediction quality than other
     *               models.
     * </pre>
     *
     * <code>string model_type = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelType() {

      modelType_ = getDefaultInstance().getModelType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the model. The available values are:
     * *   `cloud` - Model to be used via prediction calls to AutoML API.
     *               This is the default value.
     * *   `mobile-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards. Expected to have low latency, but
     *               may have lower prediction quality than other models.
     * *   `mobile-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.
     * *   `mobile-high-accuracy-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile or edge device
     *               with TensorFlow afterwards.  Expected to have a higher
     *               latency, but should also have a higher prediction quality
     *               than other models.
     * *   `mobile-core-ml-low-latency-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards. Expected to have low latency, but may have
     *               lower prediction quality than other models.
     * *   `mobile-core-ml-versatile-1` - A model that, in addition to providing
     *               prediction via AutoML API, can also be exported (see
     *               [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with Core
     *               ML afterwards.
     * *   `mobile-core-ml-high-accuracy-1` - A model that, in addition to
     *               providing prediction via AutoML API, can also be exported
     *               (see [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel]) and used on a mobile device with
     *               Core ML afterwards.  Expected to have a higher latency, but
     *               should also have a higher prediction quality than other
     *               models.
     * </pre>
     *
     * <code>string model_type = 7;</code>
     *
     * @param value The bytes for modelType to set.
     * @return This builder for chaining.
     */
    public Builder setModelTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelType_ = value;
      onChanged();
      return this;
    }

    private double nodeQps_;
    /**
     *
     *
     * <pre>
     * Output only. An approximate number of online prediction QPS that can
     * be supported by this model per each node on which it is deployed.
     * </pre>
     *
     * <code>double node_qps = 13;</code>
     *
     * @return The nodeQps.
     */
    @java.lang.Override
    public double getNodeQps() {
      return nodeQps_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An approximate number of online prediction QPS that can
     * be supported by this model per each node on which it is deployed.
     * </pre>
     *
     * <code>double node_qps = 13;</code>
     *
     * @param value The nodeQps to set.
     * @return This builder for chaining.
     */
    public Builder setNodeQps(double value) {

      nodeQps_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An approximate number of online prediction QPS that can
     * be supported by this model per each node on which it is deployed.
     * </pre>
     *
     * <code>double node_qps = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeQps() {

      nodeQps_ = 0D;
      onChanged();
      return this;
    }

    private long nodeCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of nodes this model is deployed on. A node is an
     * abstraction of a machine resource, which can handle online prediction QPS
     * as given in the node_qps field.
     * </pre>
     *
     * <code>int64 node_count = 14;</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public long getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of nodes this model is deployed on. A node is an
     * abstraction of a machine resource, which can handle online prediction QPS
     * as given in the node_qps field.
     * </pre>
     *
     * <code>int64 node_count = 14;</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(long value) {

      nodeCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of nodes this model is deployed on. A node is an
     * abstraction of a machine resource, which can handle online prediction QPS
     * as given in the node_qps field.
     * </pre>
     *
     * <code>int64 node_count = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {

      nodeCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.ImageClassificationModelMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.ImageClassificationModelMetadata)
  private static final com.google.cloud.automl.v1.ImageClassificationModelMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.ImageClassificationModelMetadata();
  }

  public static com.google.cloud.automl.v1.ImageClassificationModelMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImageClassificationModelMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImageClassificationModelMetadata>() {
        @java.lang.Override
        public ImageClassificationModelMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImageClassificationModelMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImageClassificationModelMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImageClassificationModelMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.ImageClassificationModelMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
