/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/operations.proto

package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Details of ExportModel operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.ExportModelOperationMetadata}
 */
public final class ExportModelOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.ExportModelOperationMetadata)
    ExportModelOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportModelOperationMetadata.newBuilder() to construct.
  private ExportModelOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportModelOperationMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportModelOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.Operations
        .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.Operations
        .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.ExportModelOperationMetadata.class,
            com.google.cloud.automl.v1.ExportModelOperationMetadata.Builder.class);
  }

  public interface ExportModelOutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();
  }
  /**
   *
   *
   * <pre>
   * Further describes the output of model export.
   * Supplements
   * [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo}
   */
  public static final class ExportModelOutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)
      ExportModelOutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExportModelOutputInfo.newBuilder() to construct.
    private ExportModelOutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExportModelOutputInfo() {
      gcsOutputDirectory_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExportModelOutputInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_ExportModelOutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_ExportModelOutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.class,
              com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.Builder
                  .class);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsOutputDirectory_ = "";
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The gcsOutputDirectory.
     */
    @java.lang.Override
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsOutputDirectory_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full path of the Google Cloud Storage directory created, into which
     * the model will be exported.
     * </pre>
     *
     * <code>string gcs_output_directory = 1;</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsOutputDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsOutputDirectory_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsOutputDirectory_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsOutputDirectory_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsOutputDirectory_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo other =
          (com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo) obj;

      if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getGcsOutputDirectory().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes the output of model export.
     * Supplements
     * [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_ExportModelOutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_ExportModelOutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.class,
                com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        gcsOutputDirectory_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1.Operations
            .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_ExportModelOutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo build() {
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
          buildPartial() {
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo result =
            new com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.gcsOutputDirectory_ = gcsOutputDirectory_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo) {
          return mergeFrom(
              (com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo other) {
        if (other
            == com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
                .getDefaultInstance()) return this;
        if (!other.getGcsOutputDirectory().isEmpty()) {
          gcsOutputDirectory_ = other.gcsOutputDirectory_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  gcsOutputDirectory_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object gcsOutputDirectory_ = "";
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The gcsOutputDirectory.
       */
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsOutputDirectory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsOutputDirectory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsOutputDirectory_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        gcsOutputDirectory_ = getDefaultInstance().getGcsOutputDirectory();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full path of the Google Cloud Storage directory created, into which
       * the model will be exported.
       * </pre>
       *
       * <code>string gcs_output_directory = 1;</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsOutputDirectory_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo)
    private static final com.google.cloud.automl.v1.ExportModelOperationMetadata
            .ExportModelOutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo();
    }

    public static com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExportModelOutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<ExportModelOutputInfo>() {
          @java.lang.Override
          public ExportModelOutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExportModelOutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExportModelOutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  @java.lang.Override
  public boolean hasOutputInfo() {
    return outputInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
   * </code>
   *
   * @return The outputInfo.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
      getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return outputInfo_ == null
        ? com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (outputInfo_ != null) {
      output.writeMessage(2, getOutputInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (outputInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.ExportModelOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.ExportModelOperationMetadata other =
        (com.google.cloud.automl.v1.ExportModelOperationMetadata) obj;

    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1.ExportModelOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of ExportModel operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.ExportModelOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.ExportModelOperationMetadata)
      com.google.cloud.automl.v1.ExportModelOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.ExportModelOperationMetadata.class,
              com.google.cloud.automl.v1.ExportModelOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.ExportModelOperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      outputInfo_ = null;
      if (outputInfoBuilder_ != null) {
        outputInfoBuilder_.dispose();
        outputInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.Operations
          .internal_static_google_cloud_automl_v1_ExportModelOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportModelOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.ExportModelOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportModelOperationMetadata build() {
      com.google.cloud.automl.v1.ExportModelOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ExportModelOperationMetadata buildPartial() {
      com.google.cloud.automl.v1.ExportModelOperationMetadata result =
          new com.google.cloud.automl.v1.ExportModelOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1.ExportModelOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.outputInfo_ = outputInfoBuilder_ == null ? outputInfo_ : outputInfoBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.ExportModelOperationMetadata) {
        return mergeFrom((com.google.cloud.automl.v1.ExportModelOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.ExportModelOperationMetadata other) {
      if (other == com.google.cloud.automl.v1.ExportModelOperationMetadata.getDefaultInstance())
        return this;
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getOutputInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo,
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.Builder,
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
        getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
      } else {
        outputInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.Builder
            builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && outputInfo_ != null
            && outputInfo_
                != com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
                    .getDefaultInstance()) {
          getOutputInfoBuilder().mergeFrom(value);
        } else {
          outputInfo_ = value;
        }
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public Builder clearOutputInfo() {
      bitField0_ = (bitField0_ & ~0x00000001);
      outputInfo_ = null;
      if (outputInfoBuilder_ != null) {
        outputInfoBuilder_.dispose();
        outputInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.Builder
        getOutputInfoBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
                .getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo output_info = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo,
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo.Builder,
            com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo,
                com.google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
                    .Builder,
                com.google.cloud.automl.v1.ExportModelOperationMetadata
                    .ExportModelOutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.ExportModelOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.ExportModelOperationMetadata)
  private static final com.google.cloud.automl.v1.ExportModelOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.ExportModelOperationMetadata();
  }

  public static com.google.cloud.automl.v1.ExportModelOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportModelOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ExportModelOperationMetadata>() {
        @java.lang.Override
        public ExportModelOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportModelOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportModelOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.ExportModelOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
