/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/text_sentiment.proto

package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Model evaluation metrics for text sentiment problems.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.TextSentimentEvaluationMetrics}
 */
public final class TextSentimentEvaluationMetrics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.TextSentimentEvaluationMetrics)
    TextSentimentEvaluationMetricsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextSentimentEvaluationMetrics.newBuilder() to construct.
  private TextSentimentEvaluationMetrics(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextSentimentEvaluationMetrics() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextSentimentEvaluationMetrics();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.TextSentimentProto
        .internal_static_google_cloud_automl_v1_TextSentimentEvaluationMetrics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.TextSentimentProto
        .internal_static_google_cloud_automl_v1_TextSentimentEvaluationMetrics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.class,
            com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.Builder.class);
  }

  public static final int PRECISION_FIELD_NUMBER = 1;
  private float precision_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Precision.
   * </pre>
   *
   * <code>float precision = 1;</code>
   *
   * @return The precision.
   */
  @java.lang.Override
  public float getPrecision() {
    return precision_;
  }

  public static final int RECALL_FIELD_NUMBER = 2;
  private float recall_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Recall.
   * </pre>
   *
   * <code>float recall = 2;</code>
   *
   * @return The recall.
   */
  @java.lang.Override
  public float getRecall() {
    return recall_;
  }

  public static final int F1_SCORE_FIELD_NUMBER = 3;
  private float f1Score_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. The harmonic mean of recall and precision.
   * </pre>
   *
   * <code>float f1_score = 3;</code>
   *
   * @return The f1Score.
   */
  @java.lang.Override
  public float getF1Score() {
    return f1Score_;
  }

  public static final int MEAN_ABSOLUTE_ERROR_FIELD_NUMBER = 4;
  private float meanAbsoluteError_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Mean absolute error. Only set for the overall model
   * evaluation, not for evaluation of a single annotation spec.
   * </pre>
   *
   * <code>float mean_absolute_error = 4;</code>
   *
   * @return The meanAbsoluteError.
   */
  @java.lang.Override
  public float getMeanAbsoluteError() {
    return meanAbsoluteError_;
  }

  public static final int MEAN_SQUARED_ERROR_FIELD_NUMBER = 5;
  private float meanSquaredError_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Mean squared error. Only set for the overall model
   * evaluation, not for evaluation of a single annotation spec.
   * </pre>
   *
   * <code>float mean_squared_error = 5;</code>
   *
   * @return The meanSquaredError.
   */
  @java.lang.Override
  public float getMeanSquaredError() {
    return meanSquaredError_;
  }

  public static final int LINEAR_KAPPA_FIELD_NUMBER = 6;
  private float linearKappa_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Linear weighted kappa. Only set for the overall model
   * evaluation, not for evaluation of a single annotation spec.
   * </pre>
   *
   * <code>float linear_kappa = 6;</code>
   *
   * @return The linearKappa.
   */
  @java.lang.Override
  public float getLinearKappa() {
    return linearKappa_;
  }

  public static final int QUADRATIC_KAPPA_FIELD_NUMBER = 7;
  private float quadraticKappa_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Quadratic weighted kappa. Only set for the overall model
   * evaluation, not for evaluation of a single annotation spec.
   * </pre>
   *
   * <code>float quadratic_kappa = 7;</code>
   *
   * @return The quadraticKappa.
   */
  @java.lang.Override
  public float getQuadraticKappa() {
    return quadraticKappa_;
  }

  public static final int CONFUSION_MATRIX_FIELD_NUMBER = 8;
  private com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
      confusionMatrix_;
  /**
   *
   *
   * <pre>
   * Output only. Confusion matrix of the evaluation.
   * Only set for the overall model evaluation, not for evaluation of a single
   * annotation spec.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
   * </code>
   *
   * @return Whether the confusionMatrix field is set.
   */
  @java.lang.Override
  public boolean hasConfusionMatrix() {
    return confusionMatrix_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Confusion matrix of the evaluation.
   * Only set for the overall model evaluation, not for evaluation of a single
   * annotation spec.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
   * </code>
   *
   * @return The confusionMatrix.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
      getConfusionMatrix() {
    return confusionMatrix_ == null
        ? com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
            .getDefaultInstance()
        : confusionMatrix_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Confusion matrix of the evaluation.
   * Only set for the overall model evaluation, not for evaluation of a single
   * annotation spec.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrixOrBuilder
      getConfusionMatrixOrBuilder() {
    return confusionMatrix_ == null
        ? com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
            .getDefaultInstance()
        : confusionMatrix_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Float.floatToRawIntBits(precision_) != 0) {
      output.writeFloat(1, precision_);
    }
    if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
      output.writeFloat(2, recall_);
    }
    if (java.lang.Float.floatToRawIntBits(f1Score_) != 0) {
      output.writeFloat(3, f1Score_);
    }
    if (java.lang.Float.floatToRawIntBits(meanAbsoluteError_) != 0) {
      output.writeFloat(4, meanAbsoluteError_);
    }
    if (java.lang.Float.floatToRawIntBits(meanSquaredError_) != 0) {
      output.writeFloat(5, meanSquaredError_);
    }
    if (java.lang.Float.floatToRawIntBits(linearKappa_) != 0) {
      output.writeFloat(6, linearKappa_);
    }
    if (java.lang.Float.floatToRawIntBits(quadraticKappa_) != 0) {
      output.writeFloat(7, quadraticKappa_);
    }
    if (confusionMatrix_ != null) {
      output.writeMessage(8, getConfusionMatrix());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Float.floatToRawIntBits(precision_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, precision_);
    }
    if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
    }
    if (java.lang.Float.floatToRawIntBits(f1Score_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, f1Score_);
    }
    if (java.lang.Float.floatToRawIntBits(meanAbsoluteError_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, meanAbsoluteError_);
    }
    if (java.lang.Float.floatToRawIntBits(meanSquaredError_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, meanSquaredError_);
    }
    if (java.lang.Float.floatToRawIntBits(linearKappa_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, linearKappa_);
    }
    if (java.lang.Float.floatToRawIntBits(quadraticKappa_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, quadraticKappa_);
    }
    if (confusionMatrix_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getConfusionMatrix());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.TextSentimentEvaluationMetrics)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.TextSentimentEvaluationMetrics other =
        (com.google.cloud.automl.v1.TextSentimentEvaluationMetrics) obj;

    if (java.lang.Float.floatToIntBits(getPrecision())
        != java.lang.Float.floatToIntBits(other.getPrecision())) return false;
    if (java.lang.Float.floatToIntBits(getRecall())
        != java.lang.Float.floatToIntBits(other.getRecall())) return false;
    if (java.lang.Float.floatToIntBits(getF1Score())
        != java.lang.Float.floatToIntBits(other.getF1Score())) return false;
    if (java.lang.Float.floatToIntBits(getMeanAbsoluteError())
        != java.lang.Float.floatToIntBits(other.getMeanAbsoluteError())) return false;
    if (java.lang.Float.floatToIntBits(getMeanSquaredError())
        != java.lang.Float.floatToIntBits(other.getMeanSquaredError())) return false;
    if (java.lang.Float.floatToIntBits(getLinearKappa())
        != java.lang.Float.floatToIntBits(other.getLinearKappa())) return false;
    if (java.lang.Float.floatToIntBits(getQuadraticKappa())
        != java.lang.Float.floatToIntBits(other.getQuadraticKappa())) return false;
    if (hasConfusionMatrix() != other.hasConfusionMatrix()) return false;
    if (hasConfusionMatrix()) {
      if (!getConfusionMatrix().equals(other.getConfusionMatrix())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecision());
    hash = (37 * hash) + RECALL_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
    hash = (37 * hash) + F1_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1Score());
    hash = (37 * hash) + MEAN_ABSOLUTE_ERROR_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getMeanAbsoluteError());
    hash = (37 * hash) + MEAN_SQUARED_ERROR_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getMeanSquaredError());
    hash = (37 * hash) + LINEAR_KAPPA_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getLinearKappa());
    hash = (37 * hash) + QUADRATIC_KAPPA_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getQuadraticKappa());
    if (hasConfusionMatrix()) {
      hash = (37 * hash) + CONFUSION_MATRIX_FIELD_NUMBER;
      hash = (53 * hash) + getConfusionMatrix().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1.TextSentimentEvaluationMetrics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for text sentiment problems.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.TextSentimentEvaluationMetrics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.TextSentimentEvaluationMetrics)
      com.google.cloud.automl.v1.TextSentimentEvaluationMetricsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.TextSentimentProto
          .internal_static_google_cloud_automl_v1_TextSentimentEvaluationMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.TextSentimentProto
          .internal_static_google_cloud_automl_v1_TextSentimentEvaluationMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.class,
              com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      precision_ = 0F;
      recall_ = 0F;
      f1Score_ = 0F;
      meanAbsoluteError_ = 0F;
      meanSquaredError_ = 0F;
      linearKappa_ = 0F;
      quadraticKappa_ = 0F;
      confusionMatrix_ = null;
      if (confusionMatrixBuilder_ != null) {
        confusionMatrixBuilder_.dispose();
        confusionMatrixBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.TextSentimentProto
          .internal_static_google_cloud_automl_v1_TextSentimentEvaluationMetrics_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.TextSentimentEvaluationMetrics getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.TextSentimentEvaluationMetrics build() {
      com.google.cloud.automl.v1.TextSentimentEvaluationMetrics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.TextSentimentEvaluationMetrics buildPartial() {
      com.google.cloud.automl.v1.TextSentimentEvaluationMetrics result =
          new com.google.cloud.automl.v1.TextSentimentEvaluationMetrics(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1.TextSentimentEvaluationMetrics result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.precision_ = precision_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.recall_ = recall_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.f1Score_ = f1Score_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.meanAbsoluteError_ = meanAbsoluteError_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.meanSquaredError_ = meanSquaredError_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.linearKappa_ = linearKappa_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.quadraticKappa_ = quadraticKappa_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.confusionMatrix_ =
            confusionMatrixBuilder_ == null ? confusionMatrix_ : confusionMatrixBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.TextSentimentEvaluationMetrics) {
        return mergeFrom((com.google.cloud.automl.v1.TextSentimentEvaluationMetrics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.TextSentimentEvaluationMetrics other) {
      if (other == com.google.cloud.automl.v1.TextSentimentEvaluationMetrics.getDefaultInstance())
        return this;
      if (other.getPrecision() != 0F) {
        setPrecision(other.getPrecision());
      }
      if (other.getRecall() != 0F) {
        setRecall(other.getRecall());
      }
      if (other.getF1Score() != 0F) {
        setF1Score(other.getF1Score());
      }
      if (other.getMeanAbsoluteError() != 0F) {
        setMeanAbsoluteError(other.getMeanAbsoluteError());
      }
      if (other.getMeanSquaredError() != 0F) {
        setMeanSquaredError(other.getMeanSquaredError());
      }
      if (other.getLinearKappa() != 0F) {
        setLinearKappa(other.getLinearKappa());
      }
      if (other.getQuadraticKappa() != 0F) {
        setQuadraticKappa(other.getQuadraticKappa());
      }
      if (other.hasConfusionMatrix()) {
        mergeConfusionMatrix(other.getConfusionMatrix());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                precision_ = input.readFloat();
                bitField0_ |= 0x00000001;
                break;
              } // case 13
            case 21:
              {
                recall_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            case 29:
              {
                f1Score_ = input.readFloat();
                bitField0_ |= 0x00000004;
                break;
              } // case 29
            case 37:
              {
                meanAbsoluteError_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            case 45:
              {
                meanSquaredError_ = input.readFloat();
                bitField0_ |= 0x00000010;
                break;
              } // case 45
            case 53:
              {
                linearKappa_ = input.readFloat();
                bitField0_ |= 0x00000020;
                break;
              } // case 53
            case 61:
              {
                quadraticKappa_ = input.readFloat();
                bitField0_ |= 0x00000040;
                break;
              } // case 61
            case 66:
              {
                input.readMessage(getConfusionMatrixFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private float precision_;
    /**
     *
     *
     * <pre>
     * Output only. Precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public float getPrecision() {
      return precision_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     *
     * @param value The precision to set.
     * @return This builder for chaining.
     */
    public Builder setPrecision(float value) {

      precision_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrecision() {
      bitField0_ = (bitField0_ & ~0x00000001);
      precision_ = 0F;
      onChanged();
      return this;
    }

    private float recall_;
    /**
     *
     *
     * <pre>
     * Output only. Recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    @java.lang.Override
    public float getRecall() {
      return recall_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @param value The recall to set.
     * @return This builder for chaining.
     */
    public Builder setRecall(float value) {

      recall_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecall() {
      bitField0_ = (bitField0_ & ~0x00000002);
      recall_ = 0F;
      onChanged();
      return this;
    }

    private float f1Score_;
    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     *
     * @return The f1Score.
     */
    @java.lang.Override
    public float getF1Score() {
      return f1Score_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     *
     * @param value The f1Score to set.
     * @return This builder for chaining.
     */
    public Builder setF1Score(float value) {

      f1Score_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearF1Score() {
      bitField0_ = (bitField0_ & ~0x00000004);
      f1Score_ = 0F;
      onChanged();
      return this;
    }

    private float meanAbsoluteError_;
    /**
     *
     *
     * <pre>
     * Output only. Mean absolute error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_absolute_error = 4;</code>
     *
     * @return The meanAbsoluteError.
     */
    @java.lang.Override
    public float getMeanAbsoluteError() {
      return meanAbsoluteError_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Mean absolute error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_absolute_error = 4;</code>
     *
     * @param value The meanAbsoluteError to set.
     * @return This builder for chaining.
     */
    public Builder setMeanAbsoluteError(float value) {

      meanAbsoluteError_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Mean absolute error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_absolute_error = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeanAbsoluteError() {
      bitField0_ = (bitField0_ & ~0x00000008);
      meanAbsoluteError_ = 0F;
      onChanged();
      return this;
    }

    private float meanSquaredError_;
    /**
     *
     *
     * <pre>
     * Output only. Mean squared error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_squared_error = 5;</code>
     *
     * @return The meanSquaredError.
     */
    @java.lang.Override
    public float getMeanSquaredError() {
      return meanSquaredError_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Mean squared error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_squared_error = 5;</code>
     *
     * @param value The meanSquaredError to set.
     * @return This builder for chaining.
     */
    public Builder setMeanSquaredError(float value) {

      meanSquaredError_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Mean squared error. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float mean_squared_error = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeanSquaredError() {
      bitField0_ = (bitField0_ & ~0x00000010);
      meanSquaredError_ = 0F;
      onChanged();
      return this;
    }

    private float linearKappa_;
    /**
     *
     *
     * <pre>
     * Output only. Linear weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float linear_kappa = 6;</code>
     *
     * @return The linearKappa.
     */
    @java.lang.Override
    public float getLinearKappa() {
      return linearKappa_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Linear weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float linear_kappa = 6;</code>
     *
     * @param value The linearKappa to set.
     * @return This builder for chaining.
     */
    public Builder setLinearKappa(float value) {

      linearKappa_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Linear weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float linear_kappa = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinearKappa() {
      bitField0_ = (bitField0_ & ~0x00000020);
      linearKappa_ = 0F;
      onChanged();
      return this;
    }

    private float quadraticKappa_;
    /**
     *
     *
     * <pre>
     * Output only. Quadratic weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float quadratic_kappa = 7;</code>
     *
     * @return The quadraticKappa.
     */
    @java.lang.Override
    public float getQuadraticKappa() {
      return quadraticKappa_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Quadratic weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float quadratic_kappa = 7;</code>
     *
     * @param value The quadraticKappa to set.
     * @return This builder for chaining.
     */
    public Builder setQuadraticKappa(float value) {

      quadraticKappa_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Quadratic weighted kappa. Only set for the overall model
     * evaluation, not for evaluation of a single annotation spec.
     * </pre>
     *
     * <code>float quadratic_kappa = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuadraticKappa() {
      bitField0_ = (bitField0_ & ~0x00000040);
      quadraticKappa_ = 0F;
      onChanged();
      return this;
    }

    private com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
        confusionMatrix_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix,
            com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix.Builder,
            com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrixOrBuilder>
        confusionMatrixBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     *
     * @return Whether the confusionMatrix field is set.
     */
    public boolean hasConfusionMatrix() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     *
     * @return The confusionMatrix.
     */
    public com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
        getConfusionMatrix() {
      if (confusionMatrixBuilder_ == null) {
        return confusionMatrix_ == null
            ? com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
                .getDefaultInstance()
            : confusionMatrix_;
      } else {
        return confusionMatrixBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public Builder setConfusionMatrix(
        com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix value) {
      if (confusionMatrixBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confusionMatrix_ = value;
      } else {
        confusionMatrixBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public Builder setConfusionMatrix(
        com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix.Builder
            builderForValue) {
      if (confusionMatrixBuilder_ == null) {
        confusionMatrix_ = builderForValue.build();
      } else {
        confusionMatrixBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public Builder mergeConfusionMatrix(
        com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix value) {
      if (confusionMatrixBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && confusionMatrix_ != null
            && confusionMatrix_
                != com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
                    .getDefaultInstance()) {
          getConfusionMatrixBuilder().mergeFrom(value);
        } else {
          confusionMatrix_ = value;
        }
      } else {
        confusionMatrixBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public Builder clearConfusionMatrix() {
      bitField0_ = (bitField0_ & ~0x00000080);
      confusionMatrix_ = null;
      if (confusionMatrixBuilder_ != null) {
        confusionMatrixBuilder_.dispose();
        confusionMatrixBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix.Builder
        getConfusionMatrixBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getConfusionMatrixFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    public com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrixOrBuilder
        getConfusionMatrixOrBuilder() {
      if (confusionMatrixBuilder_ != null) {
        return confusionMatrixBuilder_.getMessageOrBuilder();
      } else {
        return confusionMatrix_ == null
            ? com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix
                .getDefaultInstance()
            : confusionMatrix_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Confusion matrix of the evaluation.
     * Only set for the overall model evaluation, not for evaluation of a single
     * annotation spec.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix confusion_matrix = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix,
            com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix.Builder,
            com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrixOrBuilder>
        getConfusionMatrixFieldBuilder() {
      if (confusionMatrixBuilder_ == null) {
        confusionMatrixBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix,
                com.google.cloud.automl.v1.ClassificationEvaluationMetrics.ConfusionMatrix.Builder,
                com.google.cloud.automl.v1.ClassificationEvaluationMetrics
                    .ConfusionMatrixOrBuilder>(
                getConfusionMatrix(), getParentForChildren(), isClean());
        confusionMatrix_ = null;
      }
      return confusionMatrixBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.TextSentimentEvaluationMetrics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.TextSentimentEvaluationMetrics)
  private static final com.google.cloud.automl.v1.TextSentimentEvaluationMetrics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.TextSentimentEvaluationMetrics();
  }

  public static com.google.cloud.automl.v1.TextSentimentEvaluationMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextSentimentEvaluationMetrics> PARSER =
      new com.google.protobuf.AbstractParser<TextSentimentEvaluationMetrics>() {
        @java.lang.Override
        public TextSentimentEvaluationMetrics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextSentimentEvaluationMetrics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextSentimentEvaluationMetrics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.TextSentimentEvaluationMetrics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
