/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/annotation_payload.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Contains annotation information that is relevant to AutoML.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.AnnotationPayload}
 */
public final class AnnotationPayload extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.AnnotationPayload)
    AnnotationPayloadOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotationPayload.newBuilder() to construct.
  private AnnotationPayload(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotationPayload() {
    annotationSpecId_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotationPayload();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.AnnotationPayloadOuterClass
        .internal_static_google_cloud_automl_v1_AnnotationPayload_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.AnnotationPayloadOuterClass
        .internal_static_google_cloud_automl_v1_AnnotationPayload_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.AnnotationPayload.class,
            com.google.cloud.automl.v1.AnnotationPayload.Builder.class);
  }

  private int detailCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object detail_;

  public enum DetailCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSLATION(2),
    CLASSIFICATION(3),
    IMAGE_OBJECT_DETECTION(4),
    TEXT_EXTRACTION(6),
    TEXT_SENTIMENT(7),
    DETAIL_NOT_SET(0);
    private final int value;

    private DetailCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailCase forNumber(int value) {
      switch (value) {
        case 2:
          return TRANSLATION;
        case 3:
          return CLASSIFICATION;
        case 4:
          return IMAGE_OBJECT_DETECTION;
        case 6:
          return TEXT_EXTRACTION;
        case 7:
          return TEXT_SENTIMENT;
        case 0:
          return DETAIL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailCase getDetailCase() {
    return DetailCase.forNumber(detailCase_);
  }

  public static final int TRANSLATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Annotation details for translation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
   *
   * @return Whether the translation field is set.
   */
  @java.lang.Override
  public boolean hasTranslation() {
    return detailCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Annotation details for translation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
   *
   * @return The translation.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.TranslationAnnotation getTranslation() {
    if (detailCase_ == 2) {
      return (com.google.cloud.automl.v1.TranslationAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation details for translation.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.TranslationAnnotationOrBuilder getTranslationOrBuilder() {
    if (detailCase_ == 2) {
      return (com.google.cloud.automl.v1.TranslationAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance();
  }

  public static final int CLASSIFICATION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Annotation details for content or image classification.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
   *
   * @return Whether the classification field is set.
   */
  @java.lang.Override
  public boolean hasClassification() {
    return detailCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Annotation details for content or image classification.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
   *
   * @return The classification.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ClassificationAnnotation getClassification() {
    if (detailCase_ == 3) {
      return (com.google.cloud.automl.v1.ClassificationAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation details for content or image classification.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ClassificationAnnotationOrBuilder getClassificationOrBuilder() {
    if (detailCase_ == 3) {
      return (com.google.cloud.automl.v1.ClassificationAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance();
  }

  public static final int IMAGE_OBJECT_DETECTION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Annotation details for image object detection.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;</code>
   *
   * @return Whether the imageObjectDetection field is set.
   */
  @java.lang.Override
  public boolean hasImageObjectDetection() {
    return detailCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Annotation details for image object detection.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;</code>
   *
   * @return The imageObjectDetection.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ImageObjectDetectionAnnotation getImageObjectDetection() {
    if (detailCase_ == 4) {
      return (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation details for image object detection.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.ImageObjectDetectionAnnotationOrBuilder
      getImageObjectDetectionOrBuilder() {
    if (detailCase_ == 4) {
      return (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance();
  }

  public static final int TEXT_EXTRACTION_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Annotation details for text extraction.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
   *
   * @return Whether the textExtraction field is set.
   */
  @java.lang.Override
  public boolean hasTextExtraction() {
    return detailCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Annotation details for text extraction.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
   *
   * @return The textExtraction.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.TextExtractionAnnotation getTextExtraction() {
    if (detailCase_ == 6) {
      return (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation details for text extraction.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.TextExtractionAnnotationOrBuilder getTextExtractionOrBuilder() {
    if (detailCase_ == 6) {
      return (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance();
  }

  public static final int TEXT_SENTIMENT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Annotation details for text sentiment.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
   *
   * @return Whether the textSentiment field is set.
   */
  @java.lang.Override
  public boolean hasTextSentiment() {
    return detailCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Annotation details for text sentiment.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
   *
   * @return The textSentiment.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.TextSentimentAnnotation getTextSentiment() {
    if (detailCase_ == 7) {
      return (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation details for text sentiment.
   * </pre>
   *
   * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.TextSentimentAnnotationOrBuilder getTextSentimentOrBuilder() {
    if (detailCase_ == 7) {
      return (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_;
    }
    return com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance();
  }

  public static final int ANNOTATION_SPEC_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object annotationSpecId_ = "";
  /**
   *
   *
   * <pre>
   * Output only . The resource ID of the annotation spec that
   * this annotation pertains to. The annotation spec comes from either an
   * ancestor dataset, or the dataset that was used to train the model in use.
   * </pre>
   *
   * <code>string annotation_spec_id = 1;</code>
   *
   * @return The annotationSpecId.
   */
  @java.lang.Override
  public java.lang.String getAnnotationSpecId() {
    java.lang.Object ref = annotationSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only . The resource ID of the annotation spec that
   * this annotation pertains to. The annotation spec comes from either an
   * ancestor dataset, or the dataset that was used to train the model in use.
   * </pre>
   *
   * <code>string annotation_spec_id = 1;</code>
   *
   * @return The bytes for annotationSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationSpecIdBytes() {
    java.lang.Object ref = annotationSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The value of
   * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
   * when the model was trained. Because this field returns a value at model
   * training time, for different models trained using the same dataset, the
   * returned value could be different as model owner could update the
   * `display_name` between any two model training.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The value of
   * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
   * when the model was trained. Because this field returns a value at model
   * training time, for different models trained using the same dataset, the
   * returned value could be different as model owner could update the
   * `display_name` between any two model training.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, annotationSpecId_);
    }
    if (detailCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.automl.v1.TranslationAnnotation) detail_);
    }
    if (detailCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.automl.v1.ClassificationAnnotation) detail_);
    }
    if (detailCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (detailCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_);
    }
    if (detailCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, annotationSpecId_);
    }
    if (detailCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.automl.v1.TranslationAnnotation) detail_);
    }
    if (detailCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.automl.v1.ClassificationAnnotation) detail_);
    }
    if (detailCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (detailCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_);
    }
    if (detailCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.AnnotationPayload)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.AnnotationPayload other =
        (com.google.cloud.automl.v1.AnnotationPayload) obj;

    if (!getAnnotationSpecId().equals(other.getAnnotationSpecId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDetailCase().equals(other.getDetailCase())) return false;
    switch (detailCase_) {
      case 2:
        if (!getTranslation().equals(other.getTranslation())) return false;
        break;
      case 3:
        if (!getClassification().equals(other.getClassification())) return false;
        break;
      case 4:
        if (!getImageObjectDetection().equals(other.getImageObjectDetection())) return false;
        break;
      case 6:
        if (!getTextExtraction().equals(other.getTextExtraction())) return false;
        break;
      case 7:
        if (!getTextSentiment().equals(other.getTextSentiment())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANNOTATION_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationSpecId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    switch (detailCase_) {
      case 2:
        hash = (37 * hash) + TRANSLATION_FIELD_NUMBER;
        hash = (53 * hash) + getTranslation().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CLASSIFICATION_FIELD_NUMBER;
        hash = (53 * hash) + getClassification().hashCode();
        break;
      case 4:
        hash = (37 * hash) + IMAGE_OBJECT_DETECTION_FIELD_NUMBER;
        hash = (53 * hash) + getImageObjectDetection().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TEXT_EXTRACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTextExtraction().hashCode();
        break;
      case 7:
        hash = (37 * hash) + TEXT_SENTIMENT_FIELD_NUMBER;
        hash = (53 * hash) + getTextSentiment().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.AnnotationPayload parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1.AnnotationPayload prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains annotation information that is relevant to AutoML.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.AnnotationPayload}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.AnnotationPayload)
      com.google.cloud.automl.v1.AnnotationPayloadOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.AnnotationPayloadOuterClass
          .internal_static_google_cloud_automl_v1_AnnotationPayload_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.AnnotationPayloadOuterClass
          .internal_static_google_cloud_automl_v1_AnnotationPayload_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.AnnotationPayload.class,
              com.google.cloud.automl.v1.AnnotationPayload.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.AnnotationPayload.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (translationBuilder_ != null) {
        translationBuilder_.clear();
      }
      if (classificationBuilder_ != null) {
        classificationBuilder_.clear();
      }
      if (imageObjectDetectionBuilder_ != null) {
        imageObjectDetectionBuilder_.clear();
      }
      if (textExtractionBuilder_ != null) {
        textExtractionBuilder_.clear();
      }
      if (textSentimentBuilder_ != null) {
        textSentimentBuilder_.clear();
      }
      annotationSpecId_ = "";
      displayName_ = "";
      detailCase_ = 0;
      detail_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.AnnotationPayloadOuterClass
          .internal_static_google_cloud_automl_v1_AnnotationPayload_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.AnnotationPayload getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.AnnotationPayload.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.AnnotationPayload build() {
      com.google.cloud.automl.v1.AnnotationPayload result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.AnnotationPayload buildPartial() {
      com.google.cloud.automl.v1.AnnotationPayload result =
          new com.google.cloud.automl.v1.AnnotationPayload(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1.AnnotationPayload result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.annotationSpecId_ = annotationSpecId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.displayName_ = displayName_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.automl.v1.AnnotationPayload result) {
      result.detailCase_ = detailCase_;
      result.detail_ = this.detail_;
      if (detailCase_ == 2 && translationBuilder_ != null) {
        result.detail_ = translationBuilder_.build();
      }
      if (detailCase_ == 3 && classificationBuilder_ != null) {
        result.detail_ = classificationBuilder_.build();
      }
      if (detailCase_ == 4 && imageObjectDetectionBuilder_ != null) {
        result.detail_ = imageObjectDetectionBuilder_.build();
      }
      if (detailCase_ == 6 && textExtractionBuilder_ != null) {
        result.detail_ = textExtractionBuilder_.build();
      }
      if (detailCase_ == 7 && textSentimentBuilder_ != null) {
        result.detail_ = textSentimentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.AnnotationPayload) {
        return mergeFrom((com.google.cloud.automl.v1.AnnotationPayload) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1.AnnotationPayload other) {
      if (other == com.google.cloud.automl.v1.AnnotationPayload.getDefaultInstance()) return this;
      if (!other.getAnnotationSpecId().isEmpty()) {
        annotationSpecId_ = other.annotationSpecId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getDetailCase()) {
        case TRANSLATION:
          {
            mergeTranslation(other.getTranslation());
            break;
          }
        case CLASSIFICATION:
          {
            mergeClassification(other.getClassification());
            break;
          }
        case IMAGE_OBJECT_DETECTION:
          {
            mergeImageObjectDetection(other.getImageObjectDetection());
            break;
          }
        case TEXT_EXTRACTION:
          {
            mergeTextExtraction(other.getTextExtraction());
            break;
          }
        case TEXT_SENTIMENT:
          {
            mergeTextSentiment(other.getTextSentiment());
            break;
          }
        case DETAIL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                annotationSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTranslationFieldBuilder().getBuilder(), extensionRegistry);
                detailCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getClassificationFieldBuilder().getBuilder(), extensionRegistry);
                detailCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getImageObjectDetectionFieldBuilder().getBuilder(), extensionRegistry);
                detailCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTextExtractionFieldBuilder().getBuilder(), extensionRegistry);
                detailCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTextSentimentFieldBuilder().getBuilder(), extensionRegistry);
                detailCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int detailCase_ = 0;
    private java.lang.Object detail_;

    public DetailCase getDetailCase() {
      return DetailCase.forNumber(detailCase_);
    }

    public Builder clearDetail() {
      detailCase_ = 0;
      detail_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.TranslationAnnotation,
            com.google.cloud.automl.v1.TranslationAnnotation.Builder,
            com.google.cloud.automl.v1.TranslationAnnotationOrBuilder>
        translationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     *
     * @return Whether the translation field is set.
     */
    @java.lang.Override
    public boolean hasTranslation() {
      return detailCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     *
     * @return The translation.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.TranslationAnnotation getTranslation() {
      if (translationBuilder_ == null) {
        if (detailCase_ == 2) {
          return (com.google.cloud.automl.v1.TranslationAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance();
      } else {
        if (detailCase_ == 2) {
          return translationBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    public Builder setTranslation(com.google.cloud.automl.v1.TranslationAnnotation value) {
      if (translationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        detail_ = value;
        onChanged();
      } else {
        translationBuilder_.setMessage(value);
      }
      detailCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    public Builder setTranslation(
        com.google.cloud.automl.v1.TranslationAnnotation.Builder builderForValue) {
      if (translationBuilder_ == null) {
        detail_ = builderForValue.build();
        onChanged();
      } else {
        translationBuilder_.setMessage(builderForValue.build());
      }
      detailCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    public Builder mergeTranslation(com.google.cloud.automl.v1.TranslationAnnotation value) {
      if (translationBuilder_ == null) {
        if (detailCase_ == 2
            && detail_ != com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance()) {
          detail_ =
              com.google.cloud.automl.v1.TranslationAnnotation.newBuilder(
                      (com.google.cloud.automl.v1.TranslationAnnotation) detail_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          detail_ = value;
        }
        onChanged();
      } else {
        if (detailCase_ == 2) {
          translationBuilder_.mergeFrom(value);
        } else {
          translationBuilder_.setMessage(value);
        }
      }
      detailCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    public Builder clearTranslation() {
      if (translationBuilder_ == null) {
        if (detailCase_ == 2) {
          detailCase_ = 0;
          detail_ = null;
          onChanged();
        }
      } else {
        if (detailCase_ == 2) {
          detailCase_ = 0;
          detail_ = null;
        }
        translationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    public com.google.cloud.automl.v1.TranslationAnnotation.Builder getTranslationBuilder() {
      return getTranslationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.TranslationAnnotationOrBuilder getTranslationOrBuilder() {
      if ((detailCase_ == 2) && (translationBuilder_ != null)) {
        return translationBuilder_.getMessageOrBuilder();
      } else {
        if (detailCase_ == 2) {
          return (com.google.cloud.automl.v1.TranslationAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for translation.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TranslationAnnotation translation = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.TranslationAnnotation,
            com.google.cloud.automl.v1.TranslationAnnotation.Builder,
            com.google.cloud.automl.v1.TranslationAnnotationOrBuilder>
        getTranslationFieldBuilder() {
      if (translationBuilder_ == null) {
        if (!(detailCase_ == 2)) {
          detail_ = com.google.cloud.automl.v1.TranslationAnnotation.getDefaultInstance();
        }
        translationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.TranslationAnnotation,
                com.google.cloud.automl.v1.TranslationAnnotation.Builder,
                com.google.cloud.automl.v1.TranslationAnnotationOrBuilder>(
                (com.google.cloud.automl.v1.TranslationAnnotation) detail_,
                getParentForChildren(),
                isClean());
        detail_ = null;
      }
      detailCase_ = 2;
      onChanged();
      return translationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ClassificationAnnotation,
            com.google.cloud.automl.v1.ClassificationAnnotation.Builder,
            com.google.cloud.automl.v1.ClassificationAnnotationOrBuilder>
        classificationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     *
     * @return Whether the classification field is set.
     */
    @java.lang.Override
    public boolean hasClassification() {
      return detailCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     *
     * @return The classification.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.ClassificationAnnotation getClassification() {
      if (classificationBuilder_ == null) {
        if (detailCase_ == 3) {
          return (com.google.cloud.automl.v1.ClassificationAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance();
      } else {
        if (detailCase_ == 3) {
          return classificationBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    public Builder setClassification(com.google.cloud.automl.v1.ClassificationAnnotation value) {
      if (classificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        detail_ = value;
        onChanged();
      } else {
        classificationBuilder_.setMessage(value);
      }
      detailCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    public Builder setClassification(
        com.google.cloud.automl.v1.ClassificationAnnotation.Builder builderForValue) {
      if (classificationBuilder_ == null) {
        detail_ = builderForValue.build();
        onChanged();
      } else {
        classificationBuilder_.setMessage(builderForValue.build());
      }
      detailCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    public Builder mergeClassification(com.google.cloud.automl.v1.ClassificationAnnotation value) {
      if (classificationBuilder_ == null) {
        if (detailCase_ == 3
            && detail_
                != com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance()) {
          detail_ =
              com.google.cloud.automl.v1.ClassificationAnnotation.newBuilder(
                      (com.google.cloud.automl.v1.ClassificationAnnotation) detail_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          detail_ = value;
        }
        onChanged();
      } else {
        if (detailCase_ == 3) {
          classificationBuilder_.mergeFrom(value);
        } else {
          classificationBuilder_.setMessage(value);
        }
      }
      detailCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    public Builder clearClassification() {
      if (classificationBuilder_ == null) {
        if (detailCase_ == 3) {
          detailCase_ = 0;
          detail_ = null;
          onChanged();
        }
      } else {
        if (detailCase_ == 3) {
          detailCase_ = 0;
          detail_ = null;
        }
        classificationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    public com.google.cloud.automl.v1.ClassificationAnnotation.Builder getClassificationBuilder() {
      return getClassificationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.ClassificationAnnotationOrBuilder
        getClassificationOrBuilder() {
      if ((detailCase_ == 3) && (classificationBuilder_ != null)) {
        return classificationBuilder_.getMessageOrBuilder();
      } else {
        if (detailCase_ == 3) {
          return (com.google.cloud.automl.v1.ClassificationAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for content or image classification.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ClassificationAnnotation classification = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ClassificationAnnotation,
            com.google.cloud.automl.v1.ClassificationAnnotation.Builder,
            com.google.cloud.automl.v1.ClassificationAnnotationOrBuilder>
        getClassificationFieldBuilder() {
      if (classificationBuilder_ == null) {
        if (!(detailCase_ == 3)) {
          detail_ = com.google.cloud.automl.v1.ClassificationAnnotation.getDefaultInstance();
        }
        classificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.ClassificationAnnotation,
                com.google.cloud.automl.v1.ClassificationAnnotation.Builder,
                com.google.cloud.automl.v1.ClassificationAnnotationOrBuilder>(
                (com.google.cloud.automl.v1.ClassificationAnnotation) detail_,
                getParentForChildren(),
                isClean());
        detail_ = null;
      }
      detailCase_ = 3;
      onChanged();
      return classificationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ImageObjectDetectionAnnotation,
            com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.Builder,
            com.google.cloud.automl.v1.ImageObjectDetectionAnnotationOrBuilder>
        imageObjectDetectionBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     *
     * @return Whether the imageObjectDetection field is set.
     */
    @java.lang.Override
    public boolean hasImageObjectDetection() {
      return detailCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     *
     * @return The imageObjectDetection.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.ImageObjectDetectionAnnotation getImageObjectDetection() {
      if (imageObjectDetectionBuilder_ == null) {
        if (detailCase_ == 4) {
          return (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance();
      } else {
        if (detailCase_ == 4) {
          return imageObjectDetectionBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    public Builder setImageObjectDetection(
        com.google.cloud.automl.v1.ImageObjectDetectionAnnotation value) {
      if (imageObjectDetectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        detail_ = value;
        onChanged();
      } else {
        imageObjectDetectionBuilder_.setMessage(value);
      }
      detailCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    public Builder setImageObjectDetection(
        com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.Builder builderForValue) {
      if (imageObjectDetectionBuilder_ == null) {
        detail_ = builderForValue.build();
        onChanged();
      } else {
        imageObjectDetectionBuilder_.setMessage(builderForValue.build());
      }
      detailCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    public Builder mergeImageObjectDetection(
        com.google.cloud.automl.v1.ImageObjectDetectionAnnotation value) {
      if (imageObjectDetectionBuilder_ == null) {
        if (detailCase_ == 4
            && detail_
                != com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance()) {
          detail_ =
              com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.newBuilder(
                      (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          detail_ = value;
        }
        onChanged();
      } else {
        if (detailCase_ == 4) {
          imageObjectDetectionBuilder_.mergeFrom(value);
        } else {
          imageObjectDetectionBuilder_.setMessage(value);
        }
      }
      detailCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    public Builder clearImageObjectDetection() {
      if (imageObjectDetectionBuilder_ == null) {
        if (detailCase_ == 4) {
          detailCase_ = 0;
          detail_ = null;
          onChanged();
        }
      } else {
        if (detailCase_ == 4) {
          detailCase_ = 0;
          detail_ = null;
        }
        imageObjectDetectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    public com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.Builder
        getImageObjectDetectionBuilder() {
      return getImageObjectDetectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.ImageObjectDetectionAnnotationOrBuilder
        getImageObjectDetectionOrBuilder() {
      if ((detailCase_ == 4) && (imageObjectDetectionBuilder_ != null)) {
        return imageObjectDetectionBuilder_.getMessageOrBuilder();
      } else {
        if (detailCase_ == 4) {
          return (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for image object detection.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.ImageObjectDetectionAnnotation image_object_detection = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.ImageObjectDetectionAnnotation,
            com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.Builder,
            com.google.cloud.automl.v1.ImageObjectDetectionAnnotationOrBuilder>
        getImageObjectDetectionFieldBuilder() {
      if (imageObjectDetectionBuilder_ == null) {
        if (!(detailCase_ == 4)) {
          detail_ = com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.getDefaultInstance();
        }
        imageObjectDetectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.ImageObjectDetectionAnnotation,
                com.google.cloud.automl.v1.ImageObjectDetectionAnnotation.Builder,
                com.google.cloud.automl.v1.ImageObjectDetectionAnnotationOrBuilder>(
                (com.google.cloud.automl.v1.ImageObjectDetectionAnnotation) detail_,
                getParentForChildren(),
                isClean());
        detail_ = null;
      }
      detailCase_ = 4;
      onChanged();
      return imageObjectDetectionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.TextExtractionAnnotation,
            com.google.cloud.automl.v1.TextExtractionAnnotation.Builder,
            com.google.cloud.automl.v1.TextExtractionAnnotationOrBuilder>
        textExtractionBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     *
     * @return Whether the textExtraction field is set.
     */
    @java.lang.Override
    public boolean hasTextExtraction() {
      return detailCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     *
     * @return The textExtraction.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.TextExtractionAnnotation getTextExtraction() {
      if (textExtractionBuilder_ == null) {
        if (detailCase_ == 6) {
          return (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance();
      } else {
        if (detailCase_ == 6) {
          return textExtractionBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    public Builder setTextExtraction(com.google.cloud.automl.v1.TextExtractionAnnotation value) {
      if (textExtractionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        detail_ = value;
        onChanged();
      } else {
        textExtractionBuilder_.setMessage(value);
      }
      detailCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    public Builder setTextExtraction(
        com.google.cloud.automl.v1.TextExtractionAnnotation.Builder builderForValue) {
      if (textExtractionBuilder_ == null) {
        detail_ = builderForValue.build();
        onChanged();
      } else {
        textExtractionBuilder_.setMessage(builderForValue.build());
      }
      detailCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    public Builder mergeTextExtraction(com.google.cloud.automl.v1.TextExtractionAnnotation value) {
      if (textExtractionBuilder_ == null) {
        if (detailCase_ == 6
            && detail_
                != com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance()) {
          detail_ =
              com.google.cloud.automl.v1.TextExtractionAnnotation.newBuilder(
                      (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          detail_ = value;
        }
        onChanged();
      } else {
        if (detailCase_ == 6) {
          textExtractionBuilder_.mergeFrom(value);
        } else {
          textExtractionBuilder_.setMessage(value);
        }
      }
      detailCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    public Builder clearTextExtraction() {
      if (textExtractionBuilder_ == null) {
        if (detailCase_ == 6) {
          detailCase_ = 0;
          detail_ = null;
          onChanged();
        }
      } else {
        if (detailCase_ == 6) {
          detailCase_ = 0;
          detail_ = null;
        }
        textExtractionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    public com.google.cloud.automl.v1.TextExtractionAnnotation.Builder getTextExtractionBuilder() {
      return getTextExtractionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.TextExtractionAnnotationOrBuilder
        getTextExtractionOrBuilder() {
      if ((detailCase_ == 6) && (textExtractionBuilder_ != null)) {
        return textExtractionBuilder_.getMessageOrBuilder();
      } else {
        if (detailCase_ == 6) {
          return (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text extraction.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextExtractionAnnotation text_extraction = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.TextExtractionAnnotation,
            com.google.cloud.automl.v1.TextExtractionAnnotation.Builder,
            com.google.cloud.automl.v1.TextExtractionAnnotationOrBuilder>
        getTextExtractionFieldBuilder() {
      if (textExtractionBuilder_ == null) {
        if (!(detailCase_ == 6)) {
          detail_ = com.google.cloud.automl.v1.TextExtractionAnnotation.getDefaultInstance();
        }
        textExtractionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.TextExtractionAnnotation,
                com.google.cloud.automl.v1.TextExtractionAnnotation.Builder,
                com.google.cloud.automl.v1.TextExtractionAnnotationOrBuilder>(
                (com.google.cloud.automl.v1.TextExtractionAnnotation) detail_,
                getParentForChildren(),
                isClean());
        detail_ = null;
      }
      detailCase_ = 6;
      onChanged();
      return textExtractionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.TextSentimentAnnotation,
            com.google.cloud.automl.v1.TextSentimentAnnotation.Builder,
            com.google.cloud.automl.v1.TextSentimentAnnotationOrBuilder>
        textSentimentBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     *
     * @return Whether the textSentiment field is set.
     */
    @java.lang.Override
    public boolean hasTextSentiment() {
      return detailCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     *
     * @return The textSentiment.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.TextSentimentAnnotation getTextSentiment() {
      if (textSentimentBuilder_ == null) {
        if (detailCase_ == 7) {
          return (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance();
      } else {
        if (detailCase_ == 7) {
          return textSentimentBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    public Builder setTextSentiment(com.google.cloud.automl.v1.TextSentimentAnnotation value) {
      if (textSentimentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        detail_ = value;
        onChanged();
      } else {
        textSentimentBuilder_.setMessage(value);
      }
      detailCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    public Builder setTextSentiment(
        com.google.cloud.automl.v1.TextSentimentAnnotation.Builder builderForValue) {
      if (textSentimentBuilder_ == null) {
        detail_ = builderForValue.build();
        onChanged();
      } else {
        textSentimentBuilder_.setMessage(builderForValue.build());
      }
      detailCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    public Builder mergeTextSentiment(com.google.cloud.automl.v1.TextSentimentAnnotation value) {
      if (textSentimentBuilder_ == null) {
        if (detailCase_ == 7
            && detail_ != com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance()) {
          detail_ =
              com.google.cloud.automl.v1.TextSentimentAnnotation.newBuilder(
                      (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          detail_ = value;
        }
        onChanged();
      } else {
        if (detailCase_ == 7) {
          textSentimentBuilder_.mergeFrom(value);
        } else {
          textSentimentBuilder_.setMessage(value);
        }
      }
      detailCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    public Builder clearTextSentiment() {
      if (textSentimentBuilder_ == null) {
        if (detailCase_ == 7) {
          detailCase_ = 0;
          detail_ = null;
          onChanged();
        }
      } else {
        if (detailCase_ == 7) {
          detailCase_ = 0;
          detail_ = null;
        }
        textSentimentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    public com.google.cloud.automl.v1.TextSentimentAnnotation.Builder getTextSentimentBuilder() {
      return getTextSentimentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1.TextSentimentAnnotationOrBuilder getTextSentimentOrBuilder() {
      if ((detailCase_ == 7) && (textSentimentBuilder_ != null)) {
        return textSentimentBuilder_.getMessageOrBuilder();
      } else {
        if (detailCase_ == 7) {
          return (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_;
        }
        return com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation details for text sentiment.
     * </pre>
     *
     * <code>.google.cloud.automl.v1.TextSentimentAnnotation text_sentiment = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1.TextSentimentAnnotation,
            com.google.cloud.automl.v1.TextSentimentAnnotation.Builder,
            com.google.cloud.automl.v1.TextSentimentAnnotationOrBuilder>
        getTextSentimentFieldBuilder() {
      if (textSentimentBuilder_ == null) {
        if (!(detailCase_ == 7)) {
          detail_ = com.google.cloud.automl.v1.TextSentimentAnnotation.getDefaultInstance();
        }
        textSentimentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1.TextSentimentAnnotation,
                com.google.cloud.automl.v1.TextSentimentAnnotation.Builder,
                com.google.cloud.automl.v1.TextSentimentAnnotationOrBuilder>(
                (com.google.cloud.automl.v1.TextSentimentAnnotation) detail_,
                getParentForChildren(),
                isClean());
        detail_ = null;
      }
      detailCase_ = 7;
      onChanged();
      return textSentimentBuilder_;
    }

    private java.lang.Object annotationSpecId_ = "";
    /**
     *
     *
     * <pre>
     * Output only . The resource ID of the annotation spec that
     * this annotation pertains to. The annotation spec comes from either an
     * ancestor dataset, or the dataset that was used to train the model in use.
     * </pre>
     *
     * <code>string annotation_spec_id = 1;</code>
     *
     * @return The annotationSpecId.
     */
    public java.lang.String getAnnotationSpecId() {
      java.lang.Object ref = annotationSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only . The resource ID of the annotation spec that
     * this annotation pertains to. The annotation spec comes from either an
     * ancestor dataset, or the dataset that was used to train the model in use.
     * </pre>
     *
     * <code>string annotation_spec_id = 1;</code>
     *
     * @return The bytes for annotationSpecId.
     */
    public com.google.protobuf.ByteString getAnnotationSpecIdBytes() {
      java.lang.Object ref = annotationSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only . The resource ID of the annotation spec that
     * this annotation pertains to. The annotation spec comes from either an
     * ancestor dataset, or the dataset that was used to train the model in use.
     * </pre>
     *
     * <code>string annotation_spec_id = 1;</code>
     *
     * @param value The annotationSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      annotationSpecId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only . The resource ID of the annotation spec that
     * this annotation pertains to. The annotation spec comes from either an
     * ancestor dataset, or the dataset that was used to train the model in use.
     * </pre>
     *
     * <code>string annotation_spec_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSpecId() {
      annotationSpecId_ = getDefaultInstance().getAnnotationSpecId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only . The resource ID of the annotation spec that
     * this annotation pertains to. The annotation spec comes from either an
     * ancestor dataset, or the dataset that was used to train the model in use.
     * </pre>
     *
     * <code>string annotation_spec_id = 1;</code>
     *
     * @param value The bytes for annotationSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      annotationSpecId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
     * when the model was trained. Because this field returns a value at model
     * training time, for different models trained using the same dataset, the
     * returned value could be different as model owner could update the
     * `display_name` between any two model training.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
     * when the model was trained. Because this field returns a value at model
     * training time, for different models trained using the same dataset, the
     * returned value could be different as model owner could update the
     * `display_name` between any two model training.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
     * when the model was trained. Because this field returns a value at model
     * training time, for different models trained using the same dataset, the
     * returned value could be different as model owner could update the
     * `display_name` between any two model training.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
     * when the model was trained. Because this field returns a value at model
     * training time, for different models trained using the same dataset, the
     * returned value could be different as model owner could update the
     * `display_name` between any two model training.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1.AnnotationSpec.display_name]
     * when the model was trained. Because this field returns a value at model
     * training time, for different models trained using the same dataset, the
     * returned value could be different as model owner could update the
     * `display_name` between any two model training.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.AnnotationPayload)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.AnnotationPayload)
  private static final com.google.cloud.automl.v1.AnnotationPayload DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.AnnotationPayload();
  }

  public static com.google.cloud.automl.v1.AnnotationPayload getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotationPayload> PARSER =
      new com.google.protobuf.AbstractParser<AnnotationPayload>() {
        @java.lang.Override
        public AnnotationPayload parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotationPayload> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotationPayload> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.AnnotationPayload getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
