/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1/detection.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.automl.v1;

/**
 *
 *
 * <pre>
 * Model evaluation metrics for image object detection problems.
 * Evaluates prediction quality of labeled bounding boxes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics}
 */
public final class ImageObjectDetectionEvaluationMetrics
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics)
    ImageObjectDetectionEvaluationMetricsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImageObjectDetectionEvaluationMetrics.newBuilder() to construct.
  private ImageObjectDetectionEvaluationMetrics(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImageObjectDetectionEvaluationMetrics() {
    boundingBoxMetricsEntries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImageObjectDetectionEvaluationMetrics();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1.Detection
        .internal_static_google_cloud_automl_v1_ImageObjectDetectionEvaluationMetrics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1.Detection
        .internal_static_google_cloud_automl_v1_ImageObjectDetectionEvaluationMetrics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.class,
            com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.Builder.class);
  }

  public static final int EVALUATED_BOUNDING_BOX_COUNT_FIELD_NUMBER = 1;
  private int evaluatedBoundingBoxCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The total number of bounding boxes (i.e. summed over all
   * images) the ground truth used to create this evaluation had.
   * </pre>
   *
   * <code>int32 evaluated_bounding_box_count = 1;</code>
   *
   * @return The evaluatedBoundingBoxCount.
   */
  @java.lang.Override
  public int getEvaluatedBoundingBoxCount() {
    return evaluatedBoundingBoxCount_;
  }

  public static final int BOUNDING_BOX_METRICS_ENTRIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.automl.v1.BoundingBoxMetricsEntry>
      boundingBoxMetricsEntries_;
  /**
   *
   *
   * <pre>
   * Output only. The bounding boxes match metrics for each
   * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * pair.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.automl.v1.BoundingBoxMetricsEntry>
      getBoundingBoxMetricsEntriesList() {
    return boundingBoxMetricsEntries_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The bounding boxes match metrics for each
   * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * pair.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder>
      getBoundingBoxMetricsEntriesOrBuilderList() {
    return boundingBoxMetricsEntries_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The bounding boxes match metrics for each
   * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * pair.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
   * </code>
   */
  @java.lang.Override
  public int getBoundingBoxMetricsEntriesCount() {
    return boundingBoxMetricsEntries_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The bounding boxes match metrics for each
   * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * pair.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.BoundingBoxMetricsEntry getBoundingBoxMetricsEntries(
      int index) {
    return boundingBoxMetricsEntries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The bounding boxes match metrics for each
   * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
   * pair.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder
      getBoundingBoxMetricsEntriesOrBuilder(int index) {
    return boundingBoxMetricsEntries_.get(index);
  }

  public static final int BOUNDING_BOX_MEAN_AVERAGE_PRECISION_FIELD_NUMBER = 3;
  private float boundingBoxMeanAveragePrecision_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. The single metric for bounding boxes evaluation:
   * the mean_average_precision averaged over all bounding_box_metrics_entries.
   * </pre>
   *
   * <code>float bounding_box_mean_average_precision = 3;</code>
   *
   * @return The boundingBoxMeanAveragePrecision.
   */
  @java.lang.Override
  public float getBoundingBoxMeanAveragePrecision() {
    return boundingBoxMeanAveragePrecision_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (evaluatedBoundingBoxCount_ != 0) {
      output.writeInt32(1, evaluatedBoundingBoxCount_);
    }
    for (int i = 0; i < boundingBoxMetricsEntries_.size(); i++) {
      output.writeMessage(2, boundingBoxMetricsEntries_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(boundingBoxMeanAveragePrecision_) != 0) {
      output.writeFloat(3, boundingBoxMeanAveragePrecision_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (evaluatedBoundingBoxCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, evaluatedBoundingBoxCount_);
    }
    for (int i = 0; i < boundingBoxMetricsEntries_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, boundingBoxMetricsEntries_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(boundingBoxMeanAveragePrecision_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeFloatSize(
              3, boundingBoxMeanAveragePrecision_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics other =
        (com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics) obj;

    if (getEvaluatedBoundingBoxCount() != other.getEvaluatedBoundingBoxCount()) return false;
    if (!getBoundingBoxMetricsEntriesList().equals(other.getBoundingBoxMetricsEntriesList()))
      return false;
    if (java.lang.Float.floatToIntBits(getBoundingBoxMeanAveragePrecision())
        != java.lang.Float.floatToIntBits(other.getBoundingBoxMeanAveragePrecision())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EVALUATED_BOUNDING_BOX_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getEvaluatedBoundingBoxCount();
    if (getBoundingBoxMetricsEntriesCount() > 0) {
      hash = (37 * hash) + BOUNDING_BOX_METRICS_ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingBoxMetricsEntriesList().hashCode();
    }
    hash = (37 * hash) + BOUNDING_BOX_MEAN_AVERAGE_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoundingBoxMeanAveragePrecision());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image object detection problems.
   * Evaluates prediction quality of labeled bounding boxes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics)
      com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetricsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1.Detection
          .internal_static_google_cloud_automl_v1_ImageObjectDetectionEvaluationMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1.Detection
          .internal_static_google_cloud_automl_v1_ImageObjectDetectionEvaluationMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.class,
              com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      evaluatedBoundingBoxCount_ = 0;
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        boundingBoxMetricsEntries_ = java.util.Collections.emptyList();
      } else {
        boundingBoxMetricsEntries_ = null;
        boundingBoxMetricsEntriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      boundingBoxMeanAveragePrecision_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1.Detection
          .internal_static_google_cloud_automl_v1_ImageObjectDetectionEvaluationMetrics_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics
        getDefaultInstanceForType() {
      return com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics build() {
      com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics buildPartial() {
      com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics result =
          new com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics result) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          boundingBoxMetricsEntries_ =
              java.util.Collections.unmodifiableList(boundingBoxMetricsEntries_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.boundingBoxMetricsEntries_ = boundingBoxMetricsEntries_;
      } else {
        result.boundingBoxMetricsEntries_ = boundingBoxMetricsEntriesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.evaluatedBoundingBoxCount_ = evaluatedBoundingBoxCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.boundingBoxMeanAveragePrecision_ = boundingBoxMeanAveragePrecision_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics) {
        return mergeFrom((com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics other) {
      if (other
          == com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics.getDefaultInstance())
        return this;
      if (other.getEvaluatedBoundingBoxCount() != 0) {
        setEvaluatedBoundingBoxCount(other.getEvaluatedBoundingBoxCount());
      }
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        if (!other.boundingBoxMetricsEntries_.isEmpty()) {
          if (boundingBoxMetricsEntries_.isEmpty()) {
            boundingBoxMetricsEntries_ = other.boundingBoxMetricsEntries_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBoundingBoxMetricsEntriesIsMutable();
            boundingBoxMetricsEntries_.addAll(other.boundingBoxMetricsEntries_);
          }
          onChanged();
        }
      } else {
        if (!other.boundingBoxMetricsEntries_.isEmpty()) {
          if (boundingBoxMetricsEntriesBuilder_.isEmpty()) {
            boundingBoxMetricsEntriesBuilder_.dispose();
            boundingBoxMetricsEntriesBuilder_ = null;
            boundingBoxMetricsEntries_ = other.boundingBoxMetricsEntries_;
            bitField0_ = (bitField0_ & ~0x00000002);
            boundingBoxMetricsEntriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBoundingBoxMetricsEntriesFieldBuilder()
                    : null;
          } else {
            boundingBoxMetricsEntriesBuilder_.addAllMessages(other.boundingBoxMetricsEntries_);
          }
        }
      }
      if (other.getBoundingBoxMeanAveragePrecision() != 0F) {
        setBoundingBoxMeanAveragePrecision(other.getBoundingBoxMeanAveragePrecision());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                evaluatedBoundingBoxCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.cloud.automl.v1.BoundingBoxMetricsEntry m =
                    input.readMessage(
                        com.google.cloud.automl.v1.BoundingBoxMetricsEntry.parser(),
                        extensionRegistry);
                if (boundingBoxMetricsEntriesBuilder_ == null) {
                  ensureBoundingBoxMetricsEntriesIsMutable();
                  boundingBoxMetricsEntries_.add(m);
                } else {
                  boundingBoxMetricsEntriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 29:
              {
                boundingBoxMeanAveragePrecision_ = input.readFloat();
                bitField0_ |= 0x00000004;
                break;
              } // case 29
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int evaluatedBoundingBoxCount_;
    /**
     *
     *
     * <pre>
     * Output only. The total number of bounding boxes (i.e. summed over all
     * images) the ground truth used to create this evaluation had.
     * </pre>
     *
     * <code>int32 evaluated_bounding_box_count = 1;</code>
     *
     * @return The evaluatedBoundingBoxCount.
     */
    @java.lang.Override
    public int getEvaluatedBoundingBoxCount() {
      return evaluatedBoundingBoxCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of bounding boxes (i.e. summed over all
     * images) the ground truth used to create this evaluation had.
     * </pre>
     *
     * <code>int32 evaluated_bounding_box_count = 1;</code>
     *
     * @param value The evaluatedBoundingBoxCount to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluatedBoundingBoxCount(int value) {

      evaluatedBoundingBoxCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of bounding boxes (i.e. summed over all
     * images) the ground truth used to create this evaluation had.
     * </pre>
     *
     * <code>int32 evaluated_bounding_box_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvaluatedBoundingBoxCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      evaluatedBoundingBoxCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.automl.v1.BoundingBoxMetricsEntry>
        boundingBoxMetricsEntries_ = java.util.Collections.emptyList();

    private void ensureBoundingBoxMetricsEntriesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        boundingBoxMetricsEntries_ =
            new java.util.ArrayList<com.google.cloud.automl.v1.BoundingBoxMetricsEntry>(
                boundingBoxMetricsEntries_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1.BoundingBoxMetricsEntry,
            com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder,
            com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder>
        boundingBoxMetricsEntriesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1.BoundingBoxMetricsEntry>
        getBoundingBoxMetricsEntriesList() {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(boundingBoxMetricsEntries_);
      } else {
        return boundingBoxMetricsEntriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public int getBoundingBoxMetricsEntriesCount() {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        return boundingBoxMetricsEntries_.size();
      } else {
        return boundingBoxMetricsEntriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BoundingBoxMetricsEntry getBoundingBoxMetricsEntries(
        int index) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        return boundingBoxMetricsEntries_.get(index);
      } else {
        return boundingBoxMetricsEntriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder setBoundingBoxMetricsEntries(
        int index, com.google.cloud.automl.v1.BoundingBoxMetricsEntry value) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.set(index, value);
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder setBoundingBoxMetricsEntries(
        int index, com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder builderForValue) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.set(index, builderForValue.build());
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder addBoundingBoxMetricsEntries(
        com.google.cloud.automl.v1.BoundingBoxMetricsEntry value) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.add(value);
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder addBoundingBoxMetricsEntries(
        int index, com.google.cloud.automl.v1.BoundingBoxMetricsEntry value) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.add(index, value);
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder addBoundingBoxMetricsEntries(
        com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder builderForValue) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.add(builderForValue.build());
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder addBoundingBoxMetricsEntries(
        int index, com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder builderForValue) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.add(index, builderForValue.build());
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder addAllBoundingBoxMetricsEntries(
        java.lang.Iterable<? extends com.google.cloud.automl.v1.BoundingBoxMetricsEntry> values) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        ensureBoundingBoxMetricsEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, boundingBoxMetricsEntries_);
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder clearBoundingBoxMetricsEntries() {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        boundingBoxMetricsEntries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public Builder removeBoundingBoxMetricsEntries(int index) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        ensureBoundingBoxMetricsEntriesIsMutable();
        boundingBoxMetricsEntries_.remove(index);
        onChanged();
      } else {
        boundingBoxMetricsEntriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder
        getBoundingBoxMetricsEntriesBuilder(int index) {
      return getBoundingBoxMetricsEntriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder
        getBoundingBoxMetricsEntriesOrBuilder(int index) {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        return boundingBoxMetricsEntries_.get(index);
      } else {
        return boundingBoxMetricsEntriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder>
        getBoundingBoxMetricsEntriesOrBuilderList() {
      if (boundingBoxMetricsEntriesBuilder_ != null) {
        return boundingBoxMetricsEntriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(boundingBoxMetricsEntries_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder
        addBoundingBoxMetricsEntriesBuilder() {
      return getBoundingBoxMetricsEntriesFieldBuilder()
          .addBuilder(com.google.cloud.automl.v1.BoundingBoxMetricsEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder
        addBoundingBoxMetricsEntriesBuilder(int index) {
      return getBoundingBoxMetricsEntriesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.automl.v1.BoundingBoxMetricsEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The bounding boxes match metrics for each
     * Intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99
     * pair.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1.BoundingBoxMetricsEntry bounding_box_metrics_entries = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder>
        getBoundingBoxMetricsEntriesBuilderList() {
      return getBoundingBoxMetricsEntriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1.BoundingBoxMetricsEntry,
            com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder,
            com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder>
        getBoundingBoxMetricsEntriesFieldBuilder() {
      if (boundingBoxMetricsEntriesBuilder_ == null) {
        boundingBoxMetricsEntriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1.BoundingBoxMetricsEntry,
                com.google.cloud.automl.v1.BoundingBoxMetricsEntry.Builder,
                com.google.cloud.automl.v1.BoundingBoxMetricsEntryOrBuilder>(
                boundingBoxMetricsEntries_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        boundingBoxMetricsEntries_ = null;
      }
      return boundingBoxMetricsEntriesBuilder_;
    }

    private float boundingBoxMeanAveragePrecision_;
    /**
     *
     *
     * <pre>
     * Output only. The single metric for bounding boxes evaluation:
     * the mean_average_precision averaged over all bounding_box_metrics_entries.
     * </pre>
     *
     * <code>float bounding_box_mean_average_precision = 3;</code>
     *
     * @return The boundingBoxMeanAveragePrecision.
     */
    @java.lang.Override
    public float getBoundingBoxMeanAveragePrecision() {
      return boundingBoxMeanAveragePrecision_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The single metric for bounding boxes evaluation:
     * the mean_average_precision averaged over all bounding_box_metrics_entries.
     * </pre>
     *
     * <code>float bounding_box_mean_average_precision = 3;</code>
     *
     * @param value The boundingBoxMeanAveragePrecision to set.
     * @return This builder for chaining.
     */
    public Builder setBoundingBoxMeanAveragePrecision(float value) {

      boundingBoxMeanAveragePrecision_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The single metric for bounding boxes evaluation:
     * the mean_average_precision averaged over all bounding_box_metrics_entries.
     * </pre>
     *
     * <code>float bounding_box_mean_average_precision = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoundingBoxMeanAveragePrecision() {
      bitField0_ = (bitField0_ & ~0x00000004);
      boundingBoxMeanAveragePrecision_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics)
  private static final com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics();
  }

  public static com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImageObjectDetectionEvaluationMetrics> PARSER =
      new com.google.protobuf.AbstractParser<ImageObjectDetectionEvaluationMetrics>() {
        @java.lang.Override
        public ImageObjectDetectionEvaluationMetrics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImageObjectDetectionEvaluationMetrics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImageObjectDetectionEvaluationMetrics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1.ImageObjectDetectionEvaluationMetrics
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
