/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/tables.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata for a dataset used for AutoML Tables.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.TablesDatasetMetadata}
 */
public final class TablesDatasetMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TablesDatasetMetadata)
    TablesDatasetMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TablesDatasetMetadata.newBuilder() to construct.
  private TablesDatasetMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TablesDatasetMetadata() {
    primaryTableSpecId_ = "";
    targetColumnSpecId_ = "";
    weightColumnSpecId_ = "";
    mlUseColumnSpecId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TablesDatasetMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Tables
        .internal_static_google_cloud_automl_v1beta1_TablesDatasetMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetTargetColumnCorrelations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Tables
        .internal_static_google_cloud_automl_v1beta1_TablesDatasetMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.TablesDatasetMetadata.class,
            com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder.class);
  }

  public static final int PRIMARY_TABLE_SPEC_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object primaryTableSpecId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The table_spec_id of the primary table of this dataset.
   * </pre>
   *
   * <code>string primary_table_spec_id = 1;</code>
   *
   * @return The primaryTableSpecId.
   */
  @java.lang.Override
  public java.lang.String getPrimaryTableSpecId() {
    java.lang.Object ref = primaryTableSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      primaryTableSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The table_spec_id of the primary table of this dataset.
   * </pre>
   *
   * <code>string primary_table_spec_id = 1;</code>
   *
   * @return The bytes for primaryTableSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrimaryTableSpecIdBytes() {
    java.lang.Object ref = primaryTableSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      primaryTableSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_COLUMN_SPEC_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetColumnSpecId_ = "";
  /**
   *
   *
   * <pre>
   * column_spec_id of the primary table's column that should be used as the
   * training &amp; prediction target.
   * This column must be non-nullable and have one of following data types
   * (otherwise model creation will error):
   * * CATEGORY
   * * FLOAT64
   * If the type is CATEGORY , only up to
   * 100 unique values may exist in that column across all rows.
   * NOTE: Updates of this field will instantly affect any other users
   * concurrently working with the dataset.
   * </pre>
   *
   * <code>string target_column_spec_id = 2;</code>
   *
   * @return The targetColumnSpecId.
   */
  @java.lang.Override
  public java.lang.String getTargetColumnSpecId() {
    java.lang.Object ref = targetColumnSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetColumnSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * column_spec_id of the primary table's column that should be used as the
   * training &amp; prediction target.
   * This column must be non-nullable and have one of following data types
   * (otherwise model creation will error):
   * * CATEGORY
   * * FLOAT64
   * If the type is CATEGORY , only up to
   * 100 unique values may exist in that column across all rows.
   * NOTE: Updates of this field will instantly affect any other users
   * concurrently working with the dataset.
   * </pre>
   *
   * <code>string target_column_spec_id = 2;</code>
   *
   * @return The bytes for targetColumnSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetColumnSpecIdBytes() {
    java.lang.Object ref = targetColumnSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetColumnSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEIGHT_COLUMN_SPEC_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object weightColumnSpecId_ = "";
  /**
   *
   *
   * <pre>
   * column_spec_id of the primary table's column that should be used as the
   * weight column, i.e. the higher the value the more important the row will be
   * during model training.
   * Required type: FLOAT64.
   * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
   *                 ignored for training.
   * If not set all rows are assumed to have equal weight of 1.
   * NOTE: Updates of this field will instantly affect any other users
   * concurrently working with the dataset.
   * </pre>
   *
   * <code>string weight_column_spec_id = 3;</code>
   *
   * @return The weightColumnSpecId.
   */
  @java.lang.Override
  public java.lang.String getWeightColumnSpecId() {
    java.lang.Object ref = weightColumnSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      weightColumnSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * column_spec_id of the primary table's column that should be used as the
   * weight column, i.e. the higher the value the more important the row will be
   * during model training.
   * Required type: FLOAT64.
   * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
   *                 ignored for training.
   * If not set all rows are assumed to have equal weight of 1.
   * NOTE: Updates of this field will instantly affect any other users
   * concurrently working with the dataset.
   * </pre>
   *
   * <code>string weight_column_spec_id = 3;</code>
   *
   * @return The bytes for weightColumnSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWeightColumnSpecIdBytes() {
    java.lang.Object ref = weightColumnSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      weightColumnSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ML_USE_COLUMN_SPEC_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mlUseColumnSpecId_ = "";
  /**
   *
   *
   * <pre>
   * column_spec_id of the primary table column which specifies a possible ML
   * use of the row, i.e. the column will be used to split the rows into TRAIN,
   * VALIDATE and TEST sets.
   * Required type: STRING.
   * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
   * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
   * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
   * that if a given ml use distribution makes it impossible to create a "good"
   * model, that call will error describing the issue.
   * If both this column_spec_id and primary table's time_column_spec_id are not
   * set, then all rows are treated as `UNASSIGNED`.
   * NOTE: Updates of this field will instantly affect any other users
   * concurrently working with the dataset.
   * </pre>
   *
   * <code>string ml_use_column_spec_id = 4;</code>
   *
   * @return The mlUseColumnSpecId.
   */
  @java.lang.Override
  public java.lang.String getMlUseColumnSpecId() {
    java.lang.Object ref = mlUseColumnSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mlUseColumnSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * column_spec_id of the primary table column which specifies a possible ML
   * use of the row, i.e. the column will be used to split the rows into TRAIN,
   * VALIDATE and TEST sets.
   * Required type: STRING.
   * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
   * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
   * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
   * that if a given ml use distribution makes it impossible to create a "good"
   * model, that call will error describing the issue.
   * If both this column_spec_id and primary table's time_column_spec_id are not
   * set, then all rows are treated as `UNASSIGNED`.
   * NOTE: Updates of this field will instantly affect any other users
   * concurrently working with the dataset.
   * </pre>
   *
   * <code>string ml_use_column_spec_id = 4;</code>
   *
   * @return The bytes for mlUseColumnSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMlUseColumnSpecIdBytes() {
    java.lang.Object ref = mlUseColumnSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mlUseColumnSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_COLUMN_CORRELATIONS_FIELD_NUMBER = 6;

  private static final class TargetColumnCorrelationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
                    newDefaultInstance(
                        com.google.cloud.automl.v1beta1.Tables
                            .internal_static_google_cloud_automl_v1beta1_TablesDatasetMetadata_TargetColumnCorrelationsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.automl.v1beta1.CorrelationStats.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
      targetColumnCorrelations_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
      internalGetTargetColumnCorrelations() {
    if (targetColumnCorrelations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TargetColumnCorrelationsDefaultEntryHolder.defaultEntry);
    }
    return targetColumnCorrelations_;
  }

  public int getTargetColumnCorrelationsCount() {
    return internalGetTargetColumnCorrelations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Correlations between
   * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
   * and other columns of the
   * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
   * Only set if the target column is set. Mapping from other column spec id to
   * its CorrelationStats with the target column.
   * This field may be stale, see the stats_update_time field for
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
   * </code>
   */
  @java.lang.Override
  public boolean containsTargetColumnCorrelations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTargetColumnCorrelations().getMap().containsKey(key);
  }
  /** Use {@link #getTargetColumnCorrelationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
      getTargetColumnCorrelations() {
    return getTargetColumnCorrelationsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Correlations between
   * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
   * and other columns of the
   * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
   * Only set if the target column is set. Mapping from other column spec id to
   * its CorrelationStats with the target column.
   * This field may be stale, see the stats_update_time field for
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
      getTargetColumnCorrelationsMap() {
    return internalGetTargetColumnCorrelations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Correlations between
   * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
   * and other columns of the
   * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
   * Only set if the target column is set. Mapping from other column spec id to
   * its CorrelationStats with the target column.
   * This field may be stale, see the stats_update_time field for
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.automl.v1beta1.CorrelationStats
      getTargetColumnCorrelationsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.automl.v1beta1.CorrelationStats defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats> map =
        internalGetTargetColumnCorrelations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Correlations between
   * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
   * and other columns of the
   * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
   * Only set if the target column is set. Mapping from other column spec id to
   * its CorrelationStats with the target column.
   * This field may be stale, see the stats_update_time field for
   * for the timestamp at which these stats were last updated.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.CorrelationStats getTargetColumnCorrelationsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats> map =
        internalGetTargetColumnCorrelations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATS_UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp statsUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent timestamp when target_column_correlations
   * field and all descendant ColumnSpec.data_stats and
   * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
   * changes that happened to the dataset afterwards are not reflected in these
   * fields values. The regeneration happens in the background on a best effort
   * basis.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
   *
   * @return Whether the statsUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasStatsUpdateTime() {
    return statsUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent timestamp when target_column_correlations
   * field and all descendant ColumnSpec.data_stats and
   * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
   * changes that happened to the dataset afterwards are not reflected in these
   * fields values. The regeneration happens in the background on a best effort
   * basis.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
   *
   * @return The statsUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStatsUpdateTime() {
    return statsUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : statsUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent timestamp when target_column_correlations
   * field and all descendant ColumnSpec.data_stats and
   * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
   * changes that happened to the dataset afterwards are not reflected in these
   * fields values. The regeneration happens in the background on a best effort
   * basis.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStatsUpdateTimeOrBuilder() {
    return statsUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : statsUpdateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryTableSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, primaryTableSpecId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetColumnSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetColumnSpecId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(weightColumnSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, weightColumnSpecId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mlUseColumnSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, mlUseColumnSpecId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetTargetColumnCorrelations(),
        TargetColumnCorrelationsDefaultEntryHolder.defaultEntry,
        6);
    if (statsUpdateTime_ != null) {
      output.writeMessage(7, getStatsUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryTableSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, primaryTableSpecId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetColumnSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetColumnSpecId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(weightColumnSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, weightColumnSpecId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mlUseColumnSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, mlUseColumnSpecId_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        entry : internalGetTargetColumnCorrelations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
          targetColumnCorrelations__ =
              TargetColumnCorrelationsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, targetColumnCorrelations__);
    }
    if (statsUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStatsUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.TablesDatasetMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.TablesDatasetMetadata other =
        (com.google.cloud.automl.v1beta1.TablesDatasetMetadata) obj;

    if (!getPrimaryTableSpecId().equals(other.getPrimaryTableSpecId())) return false;
    if (!getTargetColumnSpecId().equals(other.getTargetColumnSpecId())) return false;
    if (!getWeightColumnSpecId().equals(other.getWeightColumnSpecId())) return false;
    if (!getMlUseColumnSpecId().equals(other.getMlUseColumnSpecId())) return false;
    if (!internalGetTargetColumnCorrelations().equals(other.internalGetTargetColumnCorrelations()))
      return false;
    if (hasStatsUpdateTime() != other.hasStatsUpdateTime()) return false;
    if (hasStatsUpdateTime()) {
      if (!getStatsUpdateTime().equals(other.getStatsUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRIMARY_TABLE_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPrimaryTableSpecId().hashCode();
    hash = (37 * hash) + TARGET_COLUMN_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetColumnSpecId().hashCode();
    hash = (37 * hash) + WEIGHT_COLUMN_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getWeightColumnSpecId().hashCode();
    hash = (37 * hash) + ML_USE_COLUMN_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getMlUseColumnSpecId().hashCode();
    if (!internalGetTargetColumnCorrelations().getMap().isEmpty()) {
      hash = (37 * hash) + TARGET_COLUMN_CORRELATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTargetColumnCorrelations().hashCode();
    }
    if (hasStatsUpdateTime()) {
      hash = (37 * hash) + STATS_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStatsUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1beta1.TablesDatasetMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for a dataset used for AutoML Tables.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TablesDatasetMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TablesDatasetMetadata)
      com.google.cloud.automl.v1beta1.TablesDatasetMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Tables
          .internal_static_google_cloud_automl_v1beta1_TablesDatasetMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetTargetColumnCorrelations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableTargetColumnCorrelations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Tables
          .internal_static_google_cloud_automl_v1beta1_TablesDatasetMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TablesDatasetMetadata.class,
              com.google.cloud.automl.v1beta1.TablesDatasetMetadata.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.TablesDatasetMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      primaryTableSpecId_ = "";
      targetColumnSpecId_ = "";
      weightColumnSpecId_ = "";
      mlUseColumnSpecId_ = "";
      internalGetMutableTargetColumnCorrelations().clear();
      statsUpdateTime_ = null;
      if (statsUpdateTimeBuilder_ != null) {
        statsUpdateTimeBuilder_.dispose();
        statsUpdateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Tables
          .internal_static_google_cloud_automl_v1beta1_TablesDatasetMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesDatasetMetadata getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesDatasetMetadata build() {
      com.google.cloud.automl.v1beta1.TablesDatasetMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesDatasetMetadata buildPartial() {
      com.google.cloud.automl.v1beta1.TablesDatasetMetadata result =
          new com.google.cloud.automl.v1beta1.TablesDatasetMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.TablesDatasetMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.primaryTableSpecId_ = primaryTableSpecId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.targetColumnSpecId_ = targetColumnSpecId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.weightColumnSpecId_ = weightColumnSpecId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mlUseColumnSpecId_ = mlUseColumnSpecId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.targetColumnCorrelations_ = internalGetTargetColumnCorrelations();
        result.targetColumnCorrelations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.statsUpdateTime_ =
            statsUpdateTimeBuilder_ == null ? statsUpdateTime_ : statsUpdateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.TablesDatasetMetadata) {
        return mergeFrom((com.google.cloud.automl.v1beta1.TablesDatasetMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.TablesDatasetMetadata other) {
      if (other == com.google.cloud.automl.v1beta1.TablesDatasetMetadata.getDefaultInstance())
        return this;
      if (!other.getPrimaryTableSpecId().isEmpty()) {
        primaryTableSpecId_ = other.primaryTableSpecId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTargetColumnSpecId().isEmpty()) {
        targetColumnSpecId_ = other.targetColumnSpecId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getWeightColumnSpecId().isEmpty()) {
        weightColumnSpecId_ = other.weightColumnSpecId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getMlUseColumnSpecId().isEmpty()) {
        mlUseColumnSpecId_ = other.mlUseColumnSpecId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableTargetColumnCorrelations()
          .mergeFrom(other.internalGetTargetColumnCorrelations());
      bitField0_ |= 0x00000010;
      if (other.hasStatsUpdateTime()) {
        mergeStatsUpdateTime(other.getStatsUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                primaryTableSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                targetColumnSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                weightColumnSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                mlUseColumnSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
                    targetColumnCorrelations__ =
                        input.readMessage(
                            TargetColumnCorrelationsDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableTargetColumnCorrelations()
                    .getMutableMap()
                    .put(
                        targetColumnCorrelations__.getKey(), targetColumnCorrelations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStatsUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object primaryTableSpecId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The table_spec_id of the primary table of this dataset.
     * </pre>
     *
     * <code>string primary_table_spec_id = 1;</code>
     *
     * @return The primaryTableSpecId.
     */
    public java.lang.String getPrimaryTableSpecId() {
      java.lang.Object ref = primaryTableSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryTableSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The table_spec_id of the primary table of this dataset.
     * </pre>
     *
     * <code>string primary_table_spec_id = 1;</code>
     *
     * @return The bytes for primaryTableSpecId.
     */
    public com.google.protobuf.ByteString getPrimaryTableSpecIdBytes() {
      java.lang.Object ref = primaryTableSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryTableSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The table_spec_id of the primary table of this dataset.
     * </pre>
     *
     * <code>string primary_table_spec_id = 1;</code>
     *
     * @param value The primaryTableSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryTableSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      primaryTableSpecId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The table_spec_id of the primary table of this dataset.
     * </pre>
     *
     * <code>string primary_table_spec_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryTableSpecId() {
      primaryTableSpecId_ = getDefaultInstance().getPrimaryTableSpecId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The table_spec_id of the primary table of this dataset.
     * </pre>
     *
     * <code>string primary_table_spec_id = 1;</code>
     *
     * @param value The bytes for primaryTableSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryTableSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      primaryTableSpecId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object targetColumnSpecId_ = "";
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * training &amp; prediction target.
     * This column must be non-nullable and have one of following data types
     * (otherwise model creation will error):
     * * CATEGORY
     * * FLOAT64
     * If the type is CATEGORY , only up to
     * 100 unique values may exist in that column across all rows.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string target_column_spec_id = 2;</code>
     *
     * @return The targetColumnSpecId.
     */
    public java.lang.String getTargetColumnSpecId() {
      java.lang.Object ref = targetColumnSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetColumnSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * training &amp; prediction target.
     * This column must be non-nullable and have one of following data types
     * (otherwise model creation will error):
     * * CATEGORY
     * * FLOAT64
     * If the type is CATEGORY , only up to
     * 100 unique values may exist in that column across all rows.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string target_column_spec_id = 2;</code>
     *
     * @return The bytes for targetColumnSpecId.
     */
    public com.google.protobuf.ByteString getTargetColumnSpecIdBytes() {
      java.lang.Object ref = targetColumnSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetColumnSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * training &amp; prediction target.
     * This column must be non-nullable and have one of following data types
     * (otherwise model creation will error):
     * * CATEGORY
     * * FLOAT64
     * If the type is CATEGORY , only up to
     * 100 unique values may exist in that column across all rows.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string target_column_spec_id = 2;</code>
     *
     * @param value The targetColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetColumnSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetColumnSpecId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * training &amp; prediction target.
     * This column must be non-nullable and have one of following data types
     * (otherwise model creation will error):
     * * CATEGORY
     * * FLOAT64
     * If the type is CATEGORY , only up to
     * 100 unique values may exist in that column across all rows.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string target_column_spec_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetColumnSpecId() {
      targetColumnSpecId_ = getDefaultInstance().getTargetColumnSpecId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * training &amp; prediction target.
     * This column must be non-nullable and have one of following data types
     * (otherwise model creation will error):
     * * CATEGORY
     * * FLOAT64
     * If the type is CATEGORY , only up to
     * 100 unique values may exist in that column across all rows.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string target_column_spec_id = 2;</code>
     *
     * @param value The bytes for targetColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetColumnSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetColumnSpecId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object weightColumnSpecId_ = "";
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * weight column, i.e. the higher the value the more important the row will be
     * during model training.
     * Required type: FLOAT64.
     * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
     *                 ignored for training.
     * If not set all rows are assumed to have equal weight of 1.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string weight_column_spec_id = 3;</code>
     *
     * @return The weightColumnSpecId.
     */
    public java.lang.String getWeightColumnSpecId() {
      java.lang.Object ref = weightColumnSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        weightColumnSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * weight column, i.e. the higher the value the more important the row will be
     * during model training.
     * Required type: FLOAT64.
     * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
     *                 ignored for training.
     * If not set all rows are assumed to have equal weight of 1.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string weight_column_spec_id = 3;</code>
     *
     * @return The bytes for weightColumnSpecId.
     */
    public com.google.protobuf.ByteString getWeightColumnSpecIdBytes() {
      java.lang.Object ref = weightColumnSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        weightColumnSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * weight column, i.e. the higher the value the more important the row will be
     * during model training.
     * Required type: FLOAT64.
     * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
     *                 ignored for training.
     * If not set all rows are assumed to have equal weight of 1.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string weight_column_spec_id = 3;</code>
     *
     * @param value The weightColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setWeightColumnSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      weightColumnSpecId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * weight column, i.e. the higher the value the more important the row will be
     * during model training.
     * Required type: FLOAT64.
     * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
     *                 ignored for training.
     * If not set all rows are assumed to have equal weight of 1.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string weight_column_spec_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWeightColumnSpecId() {
      weightColumnSpecId_ = getDefaultInstance().getWeightColumnSpecId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table's column that should be used as the
     * weight column, i.e. the higher the value the more important the row will be
     * during model training.
     * Required type: FLOAT64.
     * Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
     *                 ignored for training.
     * If not set all rows are assumed to have equal weight of 1.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string weight_column_spec_id = 3;</code>
     *
     * @param value The bytes for weightColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setWeightColumnSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      weightColumnSpecId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object mlUseColumnSpecId_ = "";
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table column which specifies a possible ML
     * use of the row, i.e. the column will be used to split the rows into TRAIN,
     * VALIDATE and TEST sets.
     * Required type: STRING.
     * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
     * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
     * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
     * that if a given ml use distribution makes it impossible to create a "good"
     * model, that call will error describing the issue.
     * If both this column_spec_id and primary table's time_column_spec_id are not
     * set, then all rows are treated as `UNASSIGNED`.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string ml_use_column_spec_id = 4;</code>
     *
     * @return The mlUseColumnSpecId.
     */
    public java.lang.String getMlUseColumnSpecId() {
      java.lang.Object ref = mlUseColumnSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mlUseColumnSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table column which specifies a possible ML
     * use of the row, i.e. the column will be used to split the rows into TRAIN,
     * VALIDATE and TEST sets.
     * Required type: STRING.
     * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
     * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
     * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
     * that if a given ml use distribution makes it impossible to create a "good"
     * model, that call will error describing the issue.
     * If both this column_spec_id and primary table's time_column_spec_id are not
     * set, then all rows are treated as `UNASSIGNED`.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string ml_use_column_spec_id = 4;</code>
     *
     * @return The bytes for mlUseColumnSpecId.
     */
    public com.google.protobuf.ByteString getMlUseColumnSpecIdBytes() {
      java.lang.Object ref = mlUseColumnSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mlUseColumnSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table column which specifies a possible ML
     * use of the row, i.e. the column will be used to split the rows into TRAIN,
     * VALIDATE and TEST sets.
     * Required type: STRING.
     * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
     * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
     * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
     * that if a given ml use distribution makes it impossible to create a "good"
     * model, that call will error describing the issue.
     * If both this column_spec_id and primary table's time_column_spec_id are not
     * set, then all rows are treated as `UNASSIGNED`.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string ml_use_column_spec_id = 4;</code>
     *
     * @param value The mlUseColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setMlUseColumnSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mlUseColumnSpecId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table column which specifies a possible ML
     * use of the row, i.e. the column will be used to split the rows into TRAIN,
     * VALIDATE and TEST sets.
     * Required type: STRING.
     * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
     * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
     * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
     * that if a given ml use distribution makes it impossible to create a "good"
     * model, that call will error describing the issue.
     * If both this column_spec_id and primary table's time_column_spec_id are not
     * set, then all rows are treated as `UNASSIGNED`.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string ml_use_column_spec_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMlUseColumnSpecId() {
      mlUseColumnSpecId_ = getDefaultInstance().getMlUseColumnSpecId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the primary table column which specifies a possible ML
     * use of the row, i.e. the column will be used to split the rows into TRAIN,
     * VALIDATE and TEST sets.
     * Required type: STRING.
     * This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
     * among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
     * case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
     * that if a given ml use distribution makes it impossible to create a "good"
     * model, that call will error describing the issue.
     * If both this column_spec_id and primary table's time_column_spec_id are not
     * set, then all rows are treated as `UNASSIGNED`.
     * NOTE: Updates of this field will instantly affect any other users
     * concurrently working with the dataset.
     * </pre>
     *
     * <code>string ml_use_column_spec_id = 4;</code>
     *
     * @param value The bytes for mlUseColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setMlUseColumnSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mlUseColumnSpecId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        targetColumnCorrelations_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        internalGetTargetColumnCorrelations() {
      if (targetColumnCorrelations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TargetColumnCorrelationsDefaultEntryHolder.defaultEntry);
      }
      return targetColumnCorrelations_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        internalGetMutableTargetColumnCorrelations() {
      if (targetColumnCorrelations_ == null) {
        targetColumnCorrelations_ =
            com.google.protobuf.MapField.newMapField(
                TargetColumnCorrelationsDefaultEntryHolder.defaultEntry);
      }
      if (!targetColumnCorrelations_.isMutable()) {
        targetColumnCorrelations_ = targetColumnCorrelations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return targetColumnCorrelations_;
    }

    public int getTargetColumnCorrelationsCount() {
      return internalGetTargetColumnCorrelations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    @java.lang.Override
    public boolean containsTargetColumnCorrelations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTargetColumnCorrelations().getMap().containsKey(key);
    }
    /** Use {@link #getTargetColumnCorrelationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        getTargetColumnCorrelations() {
      return getTargetColumnCorrelationsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        getTargetColumnCorrelationsMap() {
      return internalGetTargetColumnCorrelations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.automl.v1beta1.CorrelationStats
        getTargetColumnCorrelationsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.automl.v1beta1.CorrelationStats defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats> map =
          internalGetTargetColumnCorrelations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.CorrelationStats getTargetColumnCorrelationsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats> map =
          internalGetTargetColumnCorrelations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTargetColumnCorrelations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableTargetColumnCorrelations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    public Builder removeTargetColumnCorrelations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTargetColumnCorrelations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats>
        getMutableTargetColumnCorrelations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableTargetColumnCorrelations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    public Builder putTargetColumnCorrelations(
        java.lang.String key, com.google.cloud.automl.v1beta1.CorrelationStats value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTargetColumnCorrelations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Correlations between
     * [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
     * and other columns of the
     * [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
     * Only set if the target column is set. Mapping from other column spec id to
     * its CorrelationStats with the target column.
     * This field may be stale, see the stats_update_time field for
     * for the timestamp at which these stats were last updated.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.automl.v1beta1.CorrelationStats&gt; target_column_correlations = 6;
     * </code>
     */
    public Builder putAllTargetColumnCorrelations(
        java.util.Map<java.lang.String, com.google.cloud.automl.v1beta1.CorrelationStats> values) {
      internalGetMutableTargetColumnCorrelations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp statsUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        statsUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     *
     * @return Whether the statsUpdateTime field is set.
     */
    public boolean hasStatsUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     *
     * @return The statsUpdateTime.
     */
    public com.google.protobuf.Timestamp getStatsUpdateTime() {
      if (statsUpdateTimeBuilder_ == null) {
        return statsUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : statsUpdateTime_;
      } else {
        return statsUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    public Builder setStatsUpdateTime(com.google.protobuf.Timestamp value) {
      if (statsUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statsUpdateTime_ = value;
      } else {
        statsUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    public Builder setStatsUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (statsUpdateTimeBuilder_ == null) {
        statsUpdateTime_ = builderForValue.build();
      } else {
        statsUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    public Builder mergeStatsUpdateTime(com.google.protobuf.Timestamp value) {
      if (statsUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && statsUpdateTime_ != null
            && statsUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStatsUpdateTimeBuilder().mergeFrom(value);
        } else {
          statsUpdateTime_ = value;
        }
      } else {
        statsUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    public Builder clearStatsUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      statsUpdateTime_ = null;
      if (statsUpdateTimeBuilder_ != null) {
        statsUpdateTimeBuilder_.dispose();
        statsUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStatsUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStatsUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStatsUpdateTimeOrBuilder() {
      if (statsUpdateTimeBuilder_ != null) {
        return statsUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return statsUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : statsUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent timestamp when target_column_correlations
     * field and all descendant ColumnSpec.data_stats and
     * ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
     * changes that happened to the dataset afterwards are not reflected in these
     * fields values. The regeneration happens in the background on a best effort
     * basis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_update_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStatsUpdateTimeFieldBuilder() {
      if (statsUpdateTimeBuilder_ == null) {
        statsUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStatsUpdateTime(), getParentForChildren(), isClean());
        statsUpdateTime_ = null;
      }
      return statsUpdateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TablesDatasetMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TablesDatasetMetadata)
  private static final com.google.cloud.automl.v1beta1.TablesDatasetMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.TablesDatasetMetadata();
  }

  public static com.google.cloud.automl.v1beta1.TablesDatasetMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TablesDatasetMetadata> PARSER =
      new com.google.protobuf.AbstractParser<TablesDatasetMetadata>() {
        @java.lang.Override
        public TablesDatasetMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TablesDatasetMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TablesDatasetMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TablesDatasetMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
