/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/detection.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Bounding box matching model metrics for a single intersection-over-union
 * threshold and multiple label match confidence thresholds.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.BoundingBoxMetricsEntry}
 */
public final class BoundingBoxMetricsEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry)
    BoundingBoxMetricsEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BoundingBoxMetricsEntry.newBuilder() to construct.
  private BoundingBoxMetricsEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BoundingBoxMetricsEntry() {
    confidenceMetricsEntries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BoundingBoxMetricsEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.Detection
        .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.Detection
        .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.class,
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.Builder.class);
  }

  public interface ConfidenceMetricsEntryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The confidence threshold value used to compute the metrics.
     * </pre>
     *
     * <code>float confidence_threshold = 1;</code>
     *
     * @return The confidenceThreshold.
     */
    float getConfidenceThreshold();

    /**
     *
     *
     * <pre>
     * Output only. Recall under the given confidence threshold.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    float getRecall();

    /**
     *
     *
     * <pre>
     * Output only. Precision under the given confidence threshold.
     * </pre>
     *
     * <code>float precision = 3;</code>
     *
     * @return The precision.
     */
    float getPrecision();

    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 4;</code>
     *
     * @return The f1Score.
     */
    float getF1Score();
  }
  /**
   *
   *
   * <pre>
   * Metrics for a single confidence threshold.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry}
   */
  public static final class ConfidenceMetricsEntry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)
      ConfidenceMetricsEntryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConfidenceMetricsEntry.newBuilder() to construct.
    private ConfidenceMetricsEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConfidenceMetricsEntry() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConfidenceMetricsEntry();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_ConfidenceMetricsEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_ConfidenceMetricsEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.class,
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
                  .class);
    }

    public static final int CONFIDENCE_THRESHOLD_FIELD_NUMBER = 1;
    private float confidenceThreshold_ = 0F;
    /**
     *
     *
     * <pre>
     * Output only. The confidence threshold value used to compute the metrics.
     * </pre>
     *
     * <code>float confidence_threshold = 1;</code>
     *
     * @return The confidenceThreshold.
     */
    @java.lang.Override
    public float getConfidenceThreshold() {
      return confidenceThreshold_;
    }

    public static final int RECALL_FIELD_NUMBER = 2;
    private float recall_ = 0F;
    /**
     *
     *
     * <pre>
     * Output only. Recall under the given confidence threshold.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    @java.lang.Override
    public float getRecall() {
      return recall_;
    }

    public static final int PRECISION_FIELD_NUMBER = 3;
    private float precision_ = 0F;
    /**
     *
     *
     * <pre>
     * Output only. Precision under the given confidence threshold.
     * </pre>
     *
     * <code>float precision = 3;</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public float getPrecision() {
      return precision_;
    }

    public static final int F1_SCORE_FIELD_NUMBER = 4;
    private float f1Score_ = 0F;
    /**
     *
     *
     * <pre>
     * Output only. The harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 4;</code>
     *
     * @return The f1Score.
     */
    @java.lang.Override
    public float getF1Score() {
      return f1Score_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(confidenceThreshold_) != 0) {
        output.writeFloat(1, confidenceThreshold_);
      }
      if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
        output.writeFloat(2, recall_);
      }
      if (java.lang.Float.floatToRawIntBits(precision_) != 0) {
        output.writeFloat(3, precision_);
      }
      if (java.lang.Float.floatToRawIntBits(f1Score_) != 0) {
        output.writeFloat(4, f1Score_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(confidenceThreshold_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, confidenceThreshold_);
      }
      if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
      }
      if (java.lang.Float.floatToRawIntBits(precision_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, precision_);
      }
      if (java.lang.Float.floatToRawIntBits(f1Score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, f1Score_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry other =
          (com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry) obj;

      if (java.lang.Float.floatToIntBits(getConfidenceThreshold())
          != java.lang.Float.floatToIntBits(other.getConfidenceThreshold())) return false;
      if (java.lang.Float.floatToIntBits(getRecall())
          != java.lang.Float.floatToIntBits(other.getRecall())) return false;
      if (java.lang.Float.floatToIntBits(getPrecision())
          != java.lang.Float.floatToIntBits(other.getPrecision())) return false;
      if (java.lang.Float.floatToIntBits(getF1Score())
          != java.lang.Float.floatToIntBits(other.getF1Score())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONFIDENCE_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidenceThreshold());
      hash = (37 * hash) + RECALL_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
      hash = (37 * hash) + PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecision());
      hash = (37 * hash) + F1_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1Score());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metrics for a single confidence threshold.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.Detection
            .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_ConfidenceMetricsEntry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.Detection
            .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_ConfidenceMetricsEntry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
                    .class,
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        confidenceThreshold_ = 0F;
        recall_ = 0F;
        precision_ = 0F;
        f1Score_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.Detection
            .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_ConfidenceMetricsEntry_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
          build() {
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
          buildPartial() {
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry result =
            new com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.confidenceThreshold_ = confidenceThreshold_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recall_ = recall_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.precision_ = precision_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.f1Score_ = f1Score_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry) {
          return mergeFrom(
              (com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry other) {
        if (other
            == com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
                .getDefaultInstance()) return this;
        if (other.getConfidenceThreshold() != 0F) {
          setConfidenceThreshold(other.getConfidenceThreshold());
        }
        if (other.getRecall() != 0F) {
          setRecall(other.getRecall());
        }
        if (other.getPrecision() != 0F) {
          setPrecision(other.getPrecision());
        }
        if (other.getF1Score() != 0F) {
          setF1Score(other.getF1Score());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  confidenceThreshold_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  recall_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  precision_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 37:
                {
                  f1Score_ = input.readFloat();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 37
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float confidenceThreshold_;
      /**
       *
       *
       * <pre>
       * Output only. The confidence threshold value used to compute the metrics.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @return The confidenceThreshold.
       */
      @java.lang.Override
      public float getConfidenceThreshold() {
        return confidenceThreshold_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The confidence threshold value used to compute the metrics.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @param value The confidenceThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setConfidenceThreshold(float value) {

        confidenceThreshold_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The confidence threshold value used to compute the metrics.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidenceThreshold() {
        bitField0_ = (bitField0_ & ~0x00000001);
        confidenceThreshold_ = 0F;
        onChanged();
        return this;
      }

      private float recall_;
      /**
       *
       *
       * <pre>
       * Output only. Recall under the given confidence threshold.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return The recall.
       */
      @java.lang.Override
      public float getRecall() {
        return recall_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Recall under the given confidence threshold.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @param value The recall to set.
       * @return This builder for chaining.
       */
      public Builder setRecall(float value) {

        recall_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Recall under the given confidence threshold.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecall() {
        bitField0_ = (bitField0_ & ~0x00000002);
        recall_ = 0F;
        onChanged();
        return this;
      }

      private float precision_;
      /**
       *
       *
       * <pre>
       * Output only. Precision under the given confidence threshold.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @return The precision.
       */
      @java.lang.Override
      public float getPrecision() {
        return precision_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Precision under the given confidence threshold.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @param value The precision to set.
       * @return This builder for chaining.
       */
      public Builder setPrecision(float value) {

        precision_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Precision under the given confidence threshold.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrecision() {
        bitField0_ = (bitField0_ & ~0x00000004);
        precision_ = 0F;
        onChanged();
        return this;
      }

      private float f1Score_;
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @return The f1Score.
       */
      @java.lang.Override
      public float getF1Score() {
        return f1Score_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @param value The f1Score to set.
       * @return This builder for chaining.
       */
      public Builder setF1Score(float value) {

        f1Score_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearF1Score() {
        bitField0_ = (bitField0_ & ~0x00000008);
        f1Score_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry)
    private static final com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry
            .ConfidenceMetricsEntry
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry();
    }

    public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConfidenceMetricsEntry> PARSER =
        new com.google.protobuf.AbstractParser<ConfidenceMetricsEntry>() {
          @java.lang.Override
          public ConfidenceMetricsEntry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConfidenceMetricsEntry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConfidenceMetricsEntry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int IOU_THRESHOLD_FIELD_NUMBER = 1;
  private float iouThreshold_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. The intersection-over-union threshold value used to compute
   * this metrics entry.
   * </pre>
   *
   * <code>float iou_threshold = 1;</code>
   *
   * @return The iouThreshold.
   */
  @java.lang.Override
  public float getIouThreshold() {
    return iouThreshold_;
  }

  public static final int MEAN_AVERAGE_PRECISION_FIELD_NUMBER = 2;
  private float meanAveragePrecision_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. The mean average precision, most often close to au_prc.
   * </pre>
   *
   * <code>float mean_average_precision = 2;</code>
   *
   * @return The meanAveragePrecision.
   */
  @java.lang.Override
  public float getMeanAveragePrecision() {
    return meanAveragePrecision_;
  }

  public static final int CONFIDENCE_METRICS_ENTRIES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry>
      confidenceMetricsEntries_;
  /**
   *
   *
   * <pre>
   * Output only. Metrics for each label-match confidence_threshold from
   * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
   * derived from them.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry>
      getConfidenceMetricsEntriesList() {
    return confidenceMetricsEntries_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metrics for each label-match confidence_threshold from
   * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
   * derived from them.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry
                  .ConfidenceMetricsEntryOrBuilder>
      getConfidenceMetricsEntriesOrBuilderList() {
    return confidenceMetricsEntries_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metrics for each label-match confidence_threshold from
   * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
   * derived from them.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  @java.lang.Override
  public int getConfidenceMetricsEntriesCount() {
    return confidenceMetricsEntries_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Metrics for each label-match confidence_threshold from
   * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
   * derived from them.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
      getConfidenceMetricsEntries(int index) {
    return confidenceMetricsEntries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Metrics for each label-match confidence_threshold from
   * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
   * derived from them.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntryOrBuilder
      getConfidenceMetricsEntriesOrBuilder(int index) {
    return confidenceMetricsEntries_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Float.floatToRawIntBits(iouThreshold_) != 0) {
      output.writeFloat(1, iouThreshold_);
    }
    if (java.lang.Float.floatToRawIntBits(meanAveragePrecision_) != 0) {
      output.writeFloat(2, meanAveragePrecision_);
    }
    for (int i = 0; i < confidenceMetricsEntries_.size(); i++) {
      output.writeMessage(3, confidenceMetricsEntries_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Float.floatToRawIntBits(iouThreshold_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, iouThreshold_);
    }
    if (java.lang.Float.floatToRawIntBits(meanAveragePrecision_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, meanAveragePrecision_);
    }
    for (int i = 0; i < confidenceMetricsEntries_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, confidenceMetricsEntries_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry other =
        (com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry) obj;

    if (java.lang.Float.floatToIntBits(getIouThreshold())
        != java.lang.Float.floatToIntBits(other.getIouThreshold())) return false;
    if (java.lang.Float.floatToIntBits(getMeanAveragePrecision())
        != java.lang.Float.floatToIntBits(other.getMeanAveragePrecision())) return false;
    if (!getConfidenceMetricsEntriesList().equals(other.getConfidenceMetricsEntriesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IOU_THRESHOLD_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getIouThreshold());
    hash = (37 * hash) + MEAN_AVERAGE_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getMeanAveragePrecision());
    if (getConfidenceMetricsEntriesCount() > 0) {
      hash = (37 * hash) + CONFIDENCE_METRICS_ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getConfidenceMetricsEntriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Bounding box matching model metrics for a single intersection-over-union
   * threshold and multiple label match confidence thresholds.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.BoundingBoxMetricsEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry)
      com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.class,
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      iouThreshold_ = 0F;
      meanAveragePrecision_ = 0F;
      if (confidenceMetricsEntriesBuilder_ == null) {
        confidenceMetricsEntries_ = java.util.Collections.emptyList();
      } else {
        confidenceMetricsEntries_ = null;
        confidenceMetricsEntriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.Detection
          .internal_static_google_cloud_automl_v1beta1_BoundingBoxMetricsEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry build() {
      com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry buildPartial() {
      com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry result =
          new com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry result) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          confidenceMetricsEntries_ =
              java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.confidenceMetricsEntries_ = confidenceMetricsEntries_;
      } else {
        result.confidenceMetricsEntries_ = confidenceMetricsEntriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.iouThreshold_ = iouThreshold_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.meanAveragePrecision_ = meanAveragePrecision_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry) {
        return mergeFrom((com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry other) {
      if (other == com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.getDefaultInstance())
        return this;
      if (other.getIouThreshold() != 0F) {
        setIouThreshold(other.getIouThreshold());
      }
      if (other.getMeanAveragePrecision() != 0F) {
        setMeanAveragePrecision(other.getMeanAveragePrecision());
      }
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (!other.confidenceMetricsEntries_.isEmpty()) {
          if (confidenceMetricsEntries_.isEmpty()) {
            confidenceMetricsEntries_ = other.confidenceMetricsEntries_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConfidenceMetricsEntriesIsMutable();
            confidenceMetricsEntries_.addAll(other.confidenceMetricsEntries_);
          }
          onChanged();
        }
      } else {
        if (!other.confidenceMetricsEntries_.isEmpty()) {
          if (confidenceMetricsEntriesBuilder_.isEmpty()) {
            confidenceMetricsEntriesBuilder_.dispose();
            confidenceMetricsEntriesBuilder_ = null;
            confidenceMetricsEntries_ = other.confidenceMetricsEntries_;
            bitField0_ = (bitField0_ & ~0x00000004);
            confidenceMetricsEntriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConfidenceMetricsEntriesFieldBuilder()
                    : null;
          } else {
            confidenceMetricsEntriesBuilder_.addAllMessages(other.confidenceMetricsEntries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                iouThreshold_ = input.readFloat();
                bitField0_ |= 0x00000001;
                break;
              } // case 13
            case 21:
              {
                meanAveragePrecision_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            case 26:
              {
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry m =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry
                            .ConfidenceMetricsEntry.parser(),
                        extensionRegistry);
                if (confidenceMetricsEntriesBuilder_ == null) {
                  ensureConfidenceMetricsEntriesIsMutable();
                  confidenceMetricsEntries_.add(m);
                } else {
                  confidenceMetricsEntriesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private float iouThreshold_;
    /**
     *
     *
     * <pre>
     * Output only. The intersection-over-union threshold value used to compute
     * this metrics entry.
     * </pre>
     *
     * <code>float iou_threshold = 1;</code>
     *
     * @return The iouThreshold.
     */
    @java.lang.Override
    public float getIouThreshold() {
      return iouThreshold_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The intersection-over-union threshold value used to compute
     * this metrics entry.
     * </pre>
     *
     * <code>float iou_threshold = 1;</code>
     *
     * @param value The iouThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setIouThreshold(float value) {

      iouThreshold_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The intersection-over-union threshold value used to compute
     * this metrics entry.
     * </pre>
     *
     * <code>float iou_threshold = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIouThreshold() {
      bitField0_ = (bitField0_ & ~0x00000001);
      iouThreshold_ = 0F;
      onChanged();
      return this;
    }

    private float meanAveragePrecision_;
    /**
     *
     *
     * <pre>
     * Output only. The mean average precision, most often close to au_prc.
     * </pre>
     *
     * <code>float mean_average_precision = 2;</code>
     *
     * @return The meanAveragePrecision.
     */
    @java.lang.Override
    public float getMeanAveragePrecision() {
      return meanAveragePrecision_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The mean average precision, most often close to au_prc.
     * </pre>
     *
     * <code>float mean_average_precision = 2;</code>
     *
     * @param value The meanAveragePrecision to set.
     * @return This builder for chaining.
     */
    public Builder setMeanAveragePrecision(float value) {

      meanAveragePrecision_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The mean average precision, most often close to au_prc.
     * </pre>
     *
     * <code>float mean_average_precision = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeanAveragePrecision() {
      bitField0_ = (bitField0_ & ~0x00000002);
      meanAveragePrecision_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry>
        confidenceMetricsEntries_ = java.util.Collections.emptyList();

    private void ensureConfidenceMetricsEntriesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        confidenceMetricsEntries_ =
            new java.util.ArrayList<
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry>(
                confidenceMetricsEntries_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry,
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder,
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntryOrBuilder>
        confidenceMetricsEntriesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry>
        getConfidenceMetricsEntriesList() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
      } else {
        return confidenceMetricsEntriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public int getConfidenceMetricsEntriesCount() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return confidenceMetricsEntries_.size();
      } else {
        return confidenceMetricsEntriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
        getConfidenceMetricsEntries(int index) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return confidenceMetricsEntries_.get(index);
      } else {
        return confidenceMetricsEntriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder setConfidenceMetricsEntries(
        int index,
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry value) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.set(index, value);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder setConfidenceMetricsEntries(
        int index,
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
            builderForValue) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.set(index, builderForValue.build());
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry value) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(value);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        int index,
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry value) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(index, value);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
            builderForValue) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(builderForValue.build());
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        int index,
        com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
            builderForValue) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(index, builderForValue.build());
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addAllConfidenceMetricsEntries(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry>
            values) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, confidenceMetricsEntries_);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder clearConfidenceMetricsEntries() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        confidenceMetricsEntries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder removeConfidenceMetricsEntries(int index) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.remove(index);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
        getConfidenceMetricsEntriesBuilder(int index) {
      return getConfidenceMetricsEntriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntryOrBuilder
        getConfidenceMetricsEntriesOrBuilder(int index) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return confidenceMetricsEntries_.get(index);
      } else {
        return confidenceMetricsEntriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry
                    .ConfidenceMetricsEntryOrBuilder>
        getConfidenceMetricsEntriesOrBuilderList() {
      if (confidenceMetricsEntriesBuilder_ != null) {
        return confidenceMetricsEntriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
        addConfidenceMetricsEntriesBuilder() {
      return getConfidenceMetricsEntriesFieldBuilder()
          .addBuilder(
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder
        addConfidenceMetricsEntriesBuilder(int index) {
      return getConfidenceMetricsEntriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics for each label-match confidence_threshold from
     * 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is
     * derived from them.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder>
        getConfidenceMetricsEntriesBuilderList() {
      return getConfidenceMetricsEntriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry,
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry.Builder,
            com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntryOrBuilder>
        getConfidenceMetricsEntriesFieldBuilder() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        confidenceMetricsEntriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry,
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry.ConfidenceMetricsEntry
                    .Builder,
                com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry
                    .ConfidenceMetricsEntryOrBuilder>(
                confidenceMetricsEntries_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        confidenceMetricsEntries_ = null;
      }
      return confidenceMetricsEntriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.BoundingBoxMetricsEntry)
  private static final com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry();
  }

  public static com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BoundingBoxMetricsEntry> PARSER =
      new com.google.protobuf.AbstractParser<BoundingBoxMetricsEntry>() {
        @java.lang.Override
        public BoundingBoxMetricsEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BoundingBoxMetricsEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BoundingBoxMetricsEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.BoundingBoxMetricsEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
