/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_stats.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * The data statistics of a series of FLOAT64 values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.Float64Stats}
 */
public final class Float64Stats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Float64Stats)
    Float64StatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Float64Stats.newBuilder() to construct.
  private Float64Stats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Float64Stats() {
    quantiles_ = emptyDoubleList();
    histogramBuckets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Float64Stats();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataStatsOuterClass
        .internal_static_google_cloud_automl_v1beta1_Float64Stats_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataStatsOuterClass
        .internal_static_google_cloud_automl_v1beta1_Float64Stats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.Float64Stats.class,
            com.google.cloud.automl.v1beta1.Float64Stats.Builder.class);
  }

  public interface HistogramBucketOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.automl.v1beta1.Float64Stats.HistogramBucket)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The minimum value of the bucket, inclusive.
     * </pre>
     *
     * <code>double min = 1;</code>
     *
     * @return The min.
     */
    double getMin();

    /**
     *
     *
     * <pre>
     * The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
     * which case it's inclusive.
     * </pre>
     *
     * <code>double max = 2;</code>
     *
     * @return The max.
     */
    double getMax();

    /**
     *
     *
     * <pre>
     * The number of data values that are in the bucket, i.e. are between
     * min and max values.
     * </pre>
     *
     * <code>int64 count = 3;</code>
     *
     * @return The count.
     */
    long getCount();
  }
  /**
   *
   *
   * <pre>
   * A bucket of a histogram.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Float64Stats.HistogramBucket}
   */
  public static final class HistogramBucket extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Float64Stats.HistogramBucket)
      HistogramBucketOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HistogramBucket.newBuilder() to construct.
    private HistogramBucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HistogramBucket() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HistogramBucket();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_Float64Stats_HistogramBucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_Float64Stats_HistogramBucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.class,
              com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder.class);
    }

    public static final int MIN_FIELD_NUMBER = 1;
    private double min_ = 0D;
    /**
     *
     *
     * <pre>
     * The minimum value of the bucket, inclusive.
     * </pre>
     *
     * <code>double min = 1;</code>
     *
     * @return The min.
     */
    @java.lang.Override
    public double getMin() {
      return min_;
    }

    public static final int MAX_FIELD_NUMBER = 2;
    private double max_ = 0D;
    /**
     *
     *
     * <pre>
     * The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
     * which case it's inclusive.
     * </pre>
     *
     * <code>double max = 2;</code>
     *
     * @return The max.
     */
    @java.lang.Override
    public double getMax() {
      return max_;
    }

    public static final int COUNT_FIELD_NUMBER = 3;
    private long count_ = 0L;
    /**
     *
     *
     * <pre>
     * The number of data values that are in the bucket, i.e. are between
     * min and max values.
     * </pre>
     *
     * <code>int64 count = 3;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(min_) != 0) {
        output.writeDouble(1, min_);
      }
      if (java.lang.Double.doubleToRawLongBits(max_) != 0) {
        output.writeDouble(2, max_);
      }
      if (count_ != 0L) {
        output.writeInt64(3, count_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(min_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, min_);
      }
      if (java.lang.Double.doubleToRawLongBits(max_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, max_);
      }
      if (count_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, count_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket)) {
        return super.equals(obj);
      }
      com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket other =
          (com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket) obj;

      if (java.lang.Double.doubleToLongBits(getMin())
          != java.lang.Double.doubleToLongBits(other.getMin())) return false;
      if (java.lang.Double.doubleToLongBits(getMax())
          != java.lang.Double.doubleToLongBits(other.getMax())) return false;
      if (getCount() != other.getCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMin()));
      hash = (37 * hash) + MAX_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMax()));
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A bucket of a histogram.
     * </pre>
     *
     * Protobuf type {@code google.cloud.automl.v1beta1.Float64Stats.HistogramBucket}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Float64Stats.HistogramBucket)
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_Float64Stats_HistogramBucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_Float64Stats_HistogramBucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.class,
                com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder.class);
      }

      // Construct using com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        min_ = 0D;
        max_ = 0D;
        count_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.automl.v1beta1.DataStatsOuterClass
            .internal_static_google_cloud_automl_v1beta1_Float64Stats_HistogramBucket_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket
          getDefaultInstanceForType() {
        return com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket build() {
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket buildPartial() {
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket result =
            new com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.min_ = min_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.max_ = max_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.count_ = count_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket) {
          return mergeFrom((com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket other) {
        if (other
            == com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.getDefaultInstance())
          return this;
        if (other.getMin() != 0D) {
          setMin(other.getMin());
        }
        if (other.getMax() != 0D) {
          setMax(other.getMax());
        }
        if (other.getCount() != 0L) {
          setCount(other.getCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  min_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              case 17:
                {
                  max_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 24:
                {
                  count_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double min_;
      /**
       *
       *
       * <pre>
       * The minimum value of the bucket, inclusive.
       * </pre>
       *
       * <code>double min = 1;</code>
       *
       * @return The min.
       */
      @java.lang.Override
      public double getMin() {
        return min_;
      }
      /**
       *
       *
       * <pre>
       * The minimum value of the bucket, inclusive.
       * </pre>
       *
       * <code>double min = 1;</code>
       *
       * @param value The min to set.
       * @return This builder for chaining.
       */
      public Builder setMin(double value) {

        min_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum value of the bucket, inclusive.
       * </pre>
       *
       * <code>double min = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMin() {
        bitField0_ = (bitField0_ & ~0x00000001);
        min_ = 0D;
        onChanged();
        return this;
      }

      private double max_;
      /**
       *
       *
       * <pre>
       * The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
       * which case it's inclusive.
       * </pre>
       *
       * <code>double max = 2;</code>
       *
       * @return The max.
       */
      @java.lang.Override
      public double getMax() {
        return max_;
      }
      /**
       *
       *
       * <pre>
       * The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
       * which case it's inclusive.
       * </pre>
       *
       * <code>double max = 2;</code>
       *
       * @param value The max to set.
       * @return This builder for chaining.
       */
      public Builder setMax(double value) {

        max_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
       * which case it's inclusive.
       * </pre>
       *
       * <code>double max = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMax() {
        bitField0_ = (bitField0_ & ~0x00000002);
        max_ = 0D;
        onChanged();
        return this;
      }

      private long count_;
      /**
       *
       *
       * <pre>
       * The number of data values that are in the bucket, i.e. are between
       * min and max values.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }
      /**
       *
       *
       * <pre>
       * The number of data values that are in the bucket, i.e. are between
       * min and max values.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(long value) {

        count_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of data values that are in the bucket, i.e. are between
       * min and max values.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        count_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Float64Stats.HistogramBucket)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Float64Stats.HistogramBucket)
    private static final com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket();
    }

    public static com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HistogramBucket> PARSER =
        new com.google.protobuf.AbstractParser<HistogramBucket>() {
          @java.lang.Override
          public HistogramBucket parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HistogramBucket> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HistogramBucket> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int MEAN_FIELD_NUMBER = 1;
  private double mean_ = 0D;
  /**
   *
   *
   * <pre>
   * The mean of the series.
   * </pre>
   *
   * <code>double mean = 1;</code>
   *
   * @return The mean.
   */
  @java.lang.Override
  public double getMean() {
    return mean_;
  }

  public static final int STANDARD_DEVIATION_FIELD_NUMBER = 2;
  private double standardDeviation_ = 0D;
  /**
   *
   *
   * <pre>
   * The standard deviation of the series.
   * </pre>
   *
   * <code>double standard_deviation = 2;</code>
   *
   * @return The standardDeviation.
   */
  @java.lang.Override
  public double getStandardDeviation() {
    return standardDeviation_;
  }

  public static final int QUANTILES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList quantiles_;
  /**
   *
   *
   * <pre>
   * Ordered from 0 to k k-quantile values of the data series of n values.
   * The value at index i is, approximately, the i*n/k-th smallest value in the
   * series; for i = 0 and i = k these are, respectively, the min and max
   * values.
   * </pre>
   *
   * <code>repeated double quantiles = 3;</code>
   *
   * @return A list containing the quantiles.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double> getQuantilesList() {
    return quantiles_;
  }
  /**
   *
   *
   * <pre>
   * Ordered from 0 to k k-quantile values of the data series of n values.
   * The value at index i is, approximately, the i*n/k-th smallest value in the
   * series; for i = 0 and i = k these are, respectively, the min and max
   * values.
   * </pre>
   *
   * <code>repeated double quantiles = 3;</code>
   *
   * @return The count of quantiles.
   */
  public int getQuantilesCount() {
    return quantiles_.size();
  }
  /**
   *
   *
   * <pre>
   * Ordered from 0 to k k-quantile values of the data series of n values.
   * The value at index i is, approximately, the i*n/k-th smallest value in the
   * series; for i = 0 and i = k these are, respectively, the min and max
   * values.
   * </pre>
   *
   * <code>repeated double quantiles = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The quantiles at the given index.
   */
  public double getQuantiles(int index) {
    return quantiles_.getDouble(index);
  }

  private int quantilesMemoizedSerializedSize = -1;

  public static final int HISTOGRAM_BUCKETS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket>
      histogramBuckets_;
  /**
   *
   *
   * <pre>
   * Histogram buckets of the data series. Sorted by the min value of the
   * bucket, ascendingly, and the number of the buckets is dynamically
   * generated. The buckets are non-overlapping and completely cover whole
   * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
   * the last one being `"Infinity"`.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket>
      getHistogramBucketsList() {
    return histogramBuckets_;
  }
  /**
   *
   *
   * <pre>
   * Histogram buckets of the data series. Sorted by the min value of the
   * bucket, ascendingly, and the number of the buckets is dynamically
   * generated. The buckets are non-overlapping and completely cover whole
   * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
   * the last one being `"Infinity"`.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder>
      getHistogramBucketsOrBuilderList() {
    return histogramBuckets_;
  }
  /**
   *
   *
   * <pre>
   * Histogram buckets of the data series. Sorted by the min value of the
   * bucket, ascendingly, and the number of the buckets is dynamically
   * generated. The buckets are non-overlapping and completely cover whole
   * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
   * the last one being `"Infinity"`.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
   * </code>
   */
  @java.lang.Override
  public int getHistogramBucketsCount() {
    return histogramBuckets_.size();
  }
  /**
   *
   *
   * <pre>
   * Histogram buckets of the data series. Sorted by the min value of the
   * bucket, ascendingly, and the number of the buckets is dynamically
   * generated. The buckets are non-overlapping and completely cover whole
   * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
   * the last one being `"Infinity"`.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket getHistogramBuckets(
      int index) {
    return histogramBuckets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Histogram buckets of the data series. Sorted by the min value of the
   * bucket, ascendingly, and the number of the buckets is dynamically
   * generated. The buckets are non-overlapping and completely cover whole
   * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
   * the last one being `"Infinity"`.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder
      getHistogramBucketsOrBuilder(int index) {
    return histogramBuckets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (java.lang.Double.doubleToRawLongBits(mean_) != 0) {
      output.writeDouble(1, mean_);
    }
    if (java.lang.Double.doubleToRawLongBits(standardDeviation_) != 0) {
      output.writeDouble(2, standardDeviation_);
    }
    if (getQuantilesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(quantilesMemoizedSerializedSize);
    }
    for (int i = 0; i < quantiles_.size(); i++) {
      output.writeDoubleNoTag(quantiles_.getDouble(i));
    }
    for (int i = 0; i < histogramBuckets_.size(); i++) {
      output.writeMessage(4, histogramBuckets_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(mean_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, mean_);
    }
    if (java.lang.Double.doubleToRawLongBits(standardDeviation_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, standardDeviation_);
    }
    {
      int dataSize = 0;
      dataSize = 8 * getQuantilesList().size();
      size += dataSize;
      if (!getQuantilesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      quantilesMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < histogramBuckets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, histogramBuckets_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.Float64Stats)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.Float64Stats other =
        (com.google.cloud.automl.v1beta1.Float64Stats) obj;

    if (java.lang.Double.doubleToLongBits(getMean())
        != java.lang.Double.doubleToLongBits(other.getMean())) return false;
    if (java.lang.Double.doubleToLongBits(getStandardDeviation())
        != java.lang.Double.doubleToLongBits(other.getStandardDeviation())) return false;
    if (!getQuantilesList().equals(other.getQuantilesList())) return false;
    if (!getHistogramBucketsList().equals(other.getHistogramBucketsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MEAN_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMean()));
    hash = (37 * hash) + STANDARD_DEVIATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getStandardDeviation()));
    if (getQuantilesCount() > 0) {
      hash = (37 * hash) + QUANTILES_FIELD_NUMBER;
      hash = (53 * hash) + getQuantilesList().hashCode();
    }
    if (getHistogramBucketsCount() > 0) {
      hash = (37 * hash) + HISTOGRAM_BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getHistogramBucketsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.Float64Stats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The data statistics of a series of FLOAT64 values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Float64Stats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Float64Stats)
      com.google.cloud.automl.v1beta1.Float64StatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_Float64Stats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_Float64Stats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Float64Stats.class,
              com.google.cloud.automl.v1beta1.Float64Stats.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.Float64Stats.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mean_ = 0D;
      standardDeviation_ = 0D;
      quantiles_ = emptyDoubleList();
      if (histogramBucketsBuilder_ == null) {
        histogramBuckets_ = java.util.Collections.emptyList();
      } else {
        histogramBuckets_ = null;
        histogramBucketsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataStatsOuterClass
          .internal_static_google_cloud_automl_v1beta1_Float64Stats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Float64Stats getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.Float64Stats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Float64Stats build() {
      com.google.cloud.automl.v1beta1.Float64Stats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Float64Stats buildPartial() {
      com.google.cloud.automl.v1beta1.Float64Stats result =
          new com.google.cloud.automl.v1beta1.Float64Stats(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.automl.v1beta1.Float64Stats result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        quantiles_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.quantiles_ = quantiles_;
      if (histogramBucketsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          histogramBuckets_ = java.util.Collections.unmodifiableList(histogramBuckets_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.histogramBuckets_ = histogramBuckets_;
      } else {
        result.histogramBuckets_ = histogramBucketsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.Float64Stats result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mean_ = mean_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.standardDeviation_ = standardDeviation_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.Float64Stats) {
        return mergeFrom((com.google.cloud.automl.v1beta1.Float64Stats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.Float64Stats other) {
      if (other == com.google.cloud.automl.v1beta1.Float64Stats.getDefaultInstance()) return this;
      if (other.getMean() != 0D) {
        setMean(other.getMean());
      }
      if (other.getStandardDeviation() != 0D) {
        setStandardDeviation(other.getStandardDeviation());
      }
      if (!other.quantiles_.isEmpty()) {
        if (quantiles_.isEmpty()) {
          quantiles_ = other.quantiles_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureQuantilesIsMutable();
          quantiles_.addAll(other.quantiles_);
        }
        onChanged();
      }
      if (histogramBucketsBuilder_ == null) {
        if (!other.histogramBuckets_.isEmpty()) {
          if (histogramBuckets_.isEmpty()) {
            histogramBuckets_ = other.histogramBuckets_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureHistogramBucketsIsMutable();
            histogramBuckets_.addAll(other.histogramBuckets_);
          }
          onChanged();
        }
      } else {
        if (!other.histogramBuckets_.isEmpty()) {
          if (histogramBucketsBuilder_.isEmpty()) {
            histogramBucketsBuilder_.dispose();
            histogramBucketsBuilder_ = null;
            histogramBuckets_ = other.histogramBuckets_;
            bitField0_ = (bitField0_ & ~0x00000008);
            histogramBucketsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHistogramBucketsFieldBuilder()
                    : null;
          } else {
            histogramBucketsBuilder_.addAllMessages(other.histogramBuckets_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                mean_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 17:
              {
                standardDeviation_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
            case 25:
              {
                double v = input.readDouble();
                ensureQuantilesIsMutable();
                quantiles_.addDouble(v);
                break;
              } // case 25
            case 26:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureQuantilesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  quantiles_.addDouble(input.readDouble());
                }
                input.popLimit(limit);
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket m =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.parser(),
                        extensionRegistry);
                if (histogramBucketsBuilder_ == null) {
                  ensureHistogramBucketsIsMutable();
                  histogramBuckets_.add(m);
                } else {
                  histogramBucketsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double mean_;
    /**
     *
     *
     * <pre>
     * The mean of the series.
     * </pre>
     *
     * <code>double mean = 1;</code>
     *
     * @return The mean.
     */
    @java.lang.Override
    public double getMean() {
      return mean_;
    }
    /**
     *
     *
     * <pre>
     * The mean of the series.
     * </pre>
     *
     * <code>double mean = 1;</code>
     *
     * @param value The mean to set.
     * @return This builder for chaining.
     */
    public Builder setMean(double value) {

      mean_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mean of the series.
     * </pre>
     *
     * <code>double mean = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMean() {
      bitField0_ = (bitField0_ & ~0x00000001);
      mean_ = 0D;
      onChanged();
      return this;
    }

    private double standardDeviation_;
    /**
     *
     *
     * <pre>
     * The standard deviation of the series.
     * </pre>
     *
     * <code>double standard_deviation = 2;</code>
     *
     * @return The standardDeviation.
     */
    @java.lang.Override
    public double getStandardDeviation() {
      return standardDeviation_;
    }
    /**
     *
     *
     * <pre>
     * The standard deviation of the series.
     * </pre>
     *
     * <code>double standard_deviation = 2;</code>
     *
     * @param value The standardDeviation to set.
     * @return This builder for chaining.
     */
    public Builder setStandardDeviation(double value) {

      standardDeviation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard deviation of the series.
     * </pre>
     *
     * <code>double standard_deviation = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStandardDeviation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      standardDeviation_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList quantiles_ = emptyDoubleList();

    private void ensureQuantilesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        quantiles_ = mutableCopy(quantiles_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @return A list containing the quantiles.
     */
    public java.util.List<java.lang.Double> getQuantilesList() {
      return ((bitField0_ & 0x00000004) != 0)
          ? java.util.Collections.unmodifiableList(quantiles_)
          : quantiles_;
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @return The count of quantiles.
     */
    public int getQuantilesCount() {
      return quantiles_.size();
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The quantiles at the given index.
     */
    public double getQuantiles(int index) {
      return quantiles_.getDouble(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The quantiles to set.
     * @return This builder for chaining.
     */
    public Builder setQuantiles(int index, double value) {

      ensureQuantilesIsMutable();
      quantiles_.setDouble(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @param value The quantiles to add.
     * @return This builder for chaining.
     */
    public Builder addQuantiles(double value) {

      ensureQuantilesIsMutable();
      quantiles_.addDouble(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @param values The quantiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllQuantiles(java.lang.Iterable<? extends java.lang.Double> values) {
      ensureQuantilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, quantiles_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered from 0 to k k-quantile values of the data series of n values.
     * The value at index i is, approximately, the i*n/k-th smallest value in the
     * series; for i = 0 and i = k these are, respectively, the min and max
     * values.
     * </pre>
     *
     * <code>repeated double quantiles = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuantiles() {
      quantiles_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket>
        histogramBuckets_ = java.util.Collections.emptyList();

    private void ensureHistogramBucketsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        histogramBuckets_ =
            new java.util.ArrayList<com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket>(
                histogramBuckets_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket,
            com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder,
            com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder>
        histogramBucketsBuilder_;

    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket>
        getHistogramBucketsList() {
      if (histogramBucketsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(histogramBuckets_);
      } else {
        return histogramBucketsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public int getHistogramBucketsCount() {
      if (histogramBucketsBuilder_ == null) {
        return histogramBuckets_.size();
      } else {
        return histogramBucketsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket getHistogramBuckets(
        int index) {
      if (histogramBucketsBuilder_ == null) {
        return histogramBuckets_.get(index);
      } else {
        return histogramBucketsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder setHistogramBuckets(
        int index, com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket value) {
      if (histogramBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.set(index, value);
        onChanged();
      } else {
        histogramBucketsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder setHistogramBuckets(
        int index,
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder builderForValue) {
      if (histogramBucketsBuilder_ == null) {
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.set(index, builderForValue.build());
        onChanged();
      } else {
        histogramBucketsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder addHistogramBuckets(
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket value) {
      if (histogramBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.add(value);
        onChanged();
      } else {
        histogramBucketsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder addHistogramBuckets(
        int index, com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket value) {
      if (histogramBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.add(index, value);
        onChanged();
      } else {
        histogramBucketsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder addHistogramBuckets(
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder builderForValue) {
      if (histogramBucketsBuilder_ == null) {
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.add(builderForValue.build());
        onChanged();
      } else {
        histogramBucketsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder addHistogramBuckets(
        int index,
        com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder builderForValue) {
      if (histogramBucketsBuilder_ == null) {
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.add(index, builderForValue.build());
        onChanged();
      } else {
        histogramBucketsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder addAllHistogramBuckets(
        java.lang.Iterable<? extends com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket>
            values) {
      if (histogramBucketsBuilder_ == null) {
        ensureHistogramBucketsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, histogramBuckets_);
        onChanged();
      } else {
        histogramBucketsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder clearHistogramBuckets() {
      if (histogramBucketsBuilder_ == null) {
        histogramBuckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        histogramBucketsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public Builder removeHistogramBuckets(int index) {
      if (histogramBucketsBuilder_ == null) {
        ensureHistogramBucketsIsMutable();
        histogramBuckets_.remove(index);
        onChanged();
      } else {
        histogramBucketsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder
        getHistogramBucketsBuilder(int index) {
      return getHistogramBucketsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder
        getHistogramBucketsOrBuilder(int index) {
      if (histogramBucketsBuilder_ == null) {
        return histogramBuckets_.get(index);
      } else {
        return histogramBucketsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder>
        getHistogramBucketsOrBuilderList() {
      if (histogramBucketsBuilder_ != null) {
        return histogramBucketsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(histogramBuckets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder
        addHistogramBucketsBuilder() {
      return getHistogramBucketsFieldBuilder()
          .addBuilder(
              com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder
        addHistogramBucketsBuilder(int index) {
      return getHistogramBucketsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Histogram buckets of the data series. Sorted by the min value of the
     * bucket, ascendingly, and the number of the buckets is dynamically
     * generated. The buckets are non-overlapping and completely cover whole
     * FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
     * the last one being `"Infinity"`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.automl.v1beta1.Float64Stats.HistogramBucket histogram_buckets = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder>
        getHistogramBucketsBuilderList() {
      return getHistogramBucketsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket,
            com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder,
            com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder>
        getHistogramBucketsFieldBuilder() {
      if (histogramBucketsBuilder_ == null) {
        histogramBucketsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket,
                com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucket.Builder,
                com.google.cloud.automl.v1beta1.Float64Stats.HistogramBucketOrBuilder>(
                histogramBuckets_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        histogramBuckets_ = null;
      }
      return histogramBucketsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Float64Stats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Float64Stats)
  private static final com.google.cloud.automl.v1beta1.Float64Stats DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Float64Stats();
  }

  public static com.google.cloud.automl.v1beta1.Float64Stats getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Float64Stats> PARSER =
      new com.google.protobuf.AbstractParser<Float64Stats>() {
        @java.lang.Override
        public Float64Stats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Float64Stats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Float64Stats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Float64Stats getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
