/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/model_evaluation.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Evaluation results of a model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.ModelEvaluation}
 */
public final class ModelEvaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.ModelEvaluation)
    ModelEvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelEvaluation.newBuilder() to construct.
  private ModelEvaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelEvaluation() {
    name_ = "";
    annotationSpecId_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelEvaluation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.ModelEvaluationOuterClass
        .internal_static_google_cloud_automl_v1beta1_ModelEvaluation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.ModelEvaluationOuterClass
        .internal_static_google_cloud_automl_v1beta1_ModelEvaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.ModelEvaluation.class,
            com.google.cloud.automl.v1beta1.ModelEvaluation.Builder.class);
  }

  private int metricsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metrics_;

  public enum MetricsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLASSIFICATION_EVALUATION_METRICS(8),
    REGRESSION_EVALUATION_METRICS(24),
    TRANSLATION_EVALUATION_METRICS(9),
    IMAGE_OBJECT_DETECTION_EVALUATION_METRICS(12),
    VIDEO_OBJECT_TRACKING_EVALUATION_METRICS(14),
    TEXT_SENTIMENT_EVALUATION_METRICS(11),
    TEXT_EXTRACTION_EVALUATION_METRICS(13),
    METRICS_NOT_SET(0);
    private final int value;

    private MetricsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetricsCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetricsCase forNumber(int value) {
      switch (value) {
        case 8:
          return CLASSIFICATION_EVALUATION_METRICS;
        case 24:
          return REGRESSION_EVALUATION_METRICS;
        case 9:
          return TRANSLATION_EVALUATION_METRICS;
        case 12:
          return IMAGE_OBJECT_DETECTION_EVALUATION_METRICS;
        case 14:
          return VIDEO_OBJECT_TRACKING_EVALUATION_METRICS;
        case 11:
          return TEXT_SENTIMENT_EVALUATION_METRICS;
        case 13:
          return TEXT_EXTRACTION_EVALUATION_METRICS;
        case 0:
          return METRICS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetricsCase getMetricsCase() {
    return MetricsCase.forNumber(metricsCase_);
  }

  public static final int CLASSIFICATION_EVALUATION_METRICS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image, text, video and tables
   * classification.
   * Tables problem is considered a classification when the target column
   * is CATEGORY DataType.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
   * </code>
   *
   * @return Whether the classificationEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasClassificationEvaluationMetrics() {
    return metricsCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image, text, video and tables
   * classification.
   * Tables problem is considered a classification when the target column
   * is CATEGORY DataType.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
   * </code>
   *
   * @return The classificationEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
      getClassificationEvaluationMetrics() {
    if (metricsCase_ == 8) {
      return (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)
          metrics_;
    }
    return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image, text, video and tables
   * classification.
   * Tables problem is considered a classification when the target column
   * is CATEGORY DataType.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ClassificationProto
          .ClassificationEvaluationMetricsOrBuilder
      getClassificationEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 8) {
      return (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)
          metrics_;
    }
    return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
        .getDefaultInstance();
  }

  public static final int REGRESSION_EVALUATION_METRICS_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for Tables regression.
   * Tables problem is considered a regression when the target column
   * has FLOAT64 DataType.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
   * </code>
   *
   * @return Whether the regressionEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasRegressionEvaluationMetrics() {
    return metricsCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for Tables regression.
   * Tables problem is considered a regression when the target column
   * has FLOAT64 DataType.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
   * </code>
   *
   * @return The regressionEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
      getRegressionEvaluationMetrics() {
    if (metricsCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for Tables regression.
   * Tables problem is considered a regression when the target column
   * has FLOAT64 DataType.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetricsOrBuilder
      getRegressionEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
        .getDefaultInstance();
  }

  public static final int TRANSLATION_EVALUATION_METRICS_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for translation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
   * </code>
   *
   * @return Whether the translationEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasTranslationEvaluationMetrics() {
    return metricsCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for translation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
   * </code>
   *
   * @return The translationEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics
      getTranslationEvaluationMetrics() {
    if (metricsCase_ == 9) {
      return (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for translation.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TranslationEvaluationMetricsOrBuilder
      getTranslationEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 9) {
      return (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.getDefaultInstance();
  }

  public static final int IMAGE_OBJECT_DETECTION_EVALUATION_METRICS_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image object detection.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
   * </code>
   *
   * @return Whether the imageObjectDetectionEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasImageObjectDetectionEvaluationMetrics() {
    return metricsCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image object detection.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
   * </code>
   *
   * @return The imageObjectDetectionEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
      getImageObjectDetectionEvaluationMetrics() {
    if (metricsCase_ == 12) {
      return (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for image object detection.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetricsOrBuilder
      getImageObjectDetectionEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 12) {
      return (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
        .getDefaultInstance();
  }

  public static final int VIDEO_OBJECT_TRACKING_EVALUATION_METRICS_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for video object tracking.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
   * </code>
   *
   * @return Whether the videoObjectTrackingEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasVideoObjectTrackingEvaluationMetrics() {
    return metricsCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for video object tracking.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
   * </code>
   *
   * @return The videoObjectTrackingEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
      getVideoObjectTrackingEvaluationMetrics() {
    if (metricsCase_ == 14) {
      return (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Model evaluation metrics for video object tracking.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetricsOrBuilder
      getVideoObjectTrackingEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 14) {
      return (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
        .getDefaultInstance();
  }

  public static final int TEXT_SENTIMENT_EVALUATION_METRICS_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Evaluation metrics for text sentiment models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
   * </code>
   *
   * @return Whether the textSentimentEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasTextSentimentEvaluationMetrics() {
    return metricsCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics for text sentiment models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
   * </code>
   *
   * @return The textSentimentEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
      getTextSentimentEvaluationMetrics() {
    if (metricsCase_ == 11) {
      return (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
          metrics_;
    }
    return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics for text sentiment models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetricsOrBuilder
      getTextSentimentEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 11) {
      return (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
          metrics_;
    }
    return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        .getDefaultInstance();
  }

  public static final int TEXT_EXTRACTION_EVALUATION_METRICS_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Evaluation metrics for text extraction models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
   * </code>
   *
   * @return Whether the textExtractionEvaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasTextExtractionEvaluationMetrics() {
    return metricsCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics for text extraction models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
   * </code>
   *
   * @return The textExtractionEvaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics
      getTextExtractionEvaluationMetrics() {
    if (metricsCase_ == 13) {
      return (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics for text extraction models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetricsOrBuilder
      getTextExtractionEvaluationMetricsOrBuilder() {
    if (metricsCase_ == 13) {
      return (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_;
    }
    return com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the model evaluation.
   * Format:
   *
   * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the model evaluation.
   * Format:
   *
   * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SPEC_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object annotationSpecId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the annotation spec that the model evaluation applies to. The
   * The ID is empty for the overall model evaluation.
   * For Tables annotation specs in the dataset do not exist and this ID is
   * always not set, but for CLASSIFICATION
   *
   * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
   * the
   * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
   * field is used.
   * </pre>
   *
   * <code>string annotation_spec_id = 2;</code>
   *
   * @return The annotationSpecId.
   */
  @java.lang.Override
  public java.lang.String getAnnotationSpecId() {
    java.lang.Object ref = annotationSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the annotation spec that the model evaluation applies to. The
   * The ID is empty for the overall model evaluation.
   * For Tables annotation specs in the dataset do not exist and this ID is
   * always not set, but for CLASSIFICATION
   *
   * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
   * the
   * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
   * field is used.
   * </pre>
   *
   * <code>string annotation_spec_id = 2;</code>
   *
   * @return The bytes for annotationSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationSpecIdBytes() {
    java.lang.Object ref = annotationSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The value of
   * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
   * the moment when the model was trained. Because this field returns a value
   * at model training time, for different models trained from the same dataset,
   * the values may differ, since display names could had been changed between
   * the two model's trainings.
   * For Tables CLASSIFICATION
   *
   * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
   * distinct values of the target column at the moment of the model evaluation
   * are populated here.
   * The display_name is empty for the overall model evaluation.
   * </pre>
   *
   * <code>string display_name = 15;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The value of
   * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
   * the moment when the model was trained. Because this field returns a value
   * at model training time, for different models trained from the same dataset,
   * the values may differ, since display names could had been changed between
   * the two model's trainings.
   * For Tables CLASSIFICATION
   *
   * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
   * distinct values of the target column at the moment of the model evaluation
   * are populated here.
   * The display_name is empty for the overall model evaluation.
   * </pre>
   *
   * <code>string display_name = 15;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this model evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this model evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this model evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int EVALUATED_EXAMPLE_COUNT_FIELD_NUMBER = 6;
  private int evaluatedExampleCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of examples used for model evaluation, i.e. for
   * which ground truth from time of model creation is compared against the
   * predicted annotations created by the model.
   * For overall ModelEvaluation (i.e. with annotation_spec_id not set) this is
   * the total number of all examples used for evaluation.
   * Otherwise, this is the count of examples that according to the ground
   * truth were annotated by the
   *
   * [annotation_spec_id][google.cloud.automl.v1beta1.ModelEvaluation.annotation_spec_id].
   * </pre>
   *
   * <code>int32 evaluated_example_count = 6;</code>
   *
   * @return The evaluatedExampleCount.
   */
  @java.lang.Override
  public int getEvaluatedExampleCount() {
    return evaluatedExampleCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, annotationSpecId_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (evaluatedExampleCount_ != 0) {
      output.writeInt32(6, evaluatedExampleCount_);
    }
    if (metricsCase_ == 8) {
      output.writeMessage(
          8,
          (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)
              metrics_);
    }
    if (metricsCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_);
    }
    if (metricsCase_ == 11) {
      output.writeMessage(
          11,
          (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
              metrics_);
    }
    if (metricsCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_);
    }
    if (metricsCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_);
    }
    if (metricsCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, displayName_);
    }
    if (metricsCase_ == 24) {
      output.writeMessage(
          24,
          (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics) metrics_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, annotationSpecId_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (evaluatedExampleCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, evaluatedExampleCount_);
    }
    if (metricsCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8,
              (com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics)
                  metrics_);
    }
    if (metricsCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_);
    }
    if (metricsCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11,
              (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
                  metrics_);
    }
    if (metricsCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_);
    }
    if (metricsCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_);
    }
    if (metricsCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, displayName_);
    }
    if (metricsCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24,
              (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics)
                  metrics_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.ModelEvaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.ModelEvaluation other =
        (com.google.cloud.automl.v1beta1.ModelEvaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAnnotationSpecId().equals(other.getAnnotationSpecId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getEvaluatedExampleCount() != other.getEvaluatedExampleCount()) return false;
    if (!getMetricsCase().equals(other.getMetricsCase())) return false;
    switch (metricsCase_) {
      case 8:
        if (!getClassificationEvaluationMetrics()
            .equals(other.getClassificationEvaluationMetrics())) return false;
        break;
      case 24:
        if (!getRegressionEvaluationMetrics().equals(other.getRegressionEvaluationMetrics()))
          return false;
        break;
      case 9:
        if (!getTranslationEvaluationMetrics().equals(other.getTranslationEvaluationMetrics()))
          return false;
        break;
      case 12:
        if (!getImageObjectDetectionEvaluationMetrics()
            .equals(other.getImageObjectDetectionEvaluationMetrics())) return false;
        break;
      case 14:
        if (!getVideoObjectTrackingEvaluationMetrics()
            .equals(other.getVideoObjectTrackingEvaluationMetrics())) return false;
        break;
      case 11:
        if (!getTextSentimentEvaluationMetrics().equals(other.getTextSentimentEvaluationMetrics()))
          return false;
        break;
      case 13:
        if (!getTextExtractionEvaluationMetrics()
            .equals(other.getTextExtractionEvaluationMetrics())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ANNOTATION_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationSpecId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + EVALUATED_EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getEvaluatedExampleCount();
    switch (metricsCase_) {
      case 8:
        hash = (37 * hash) + CLASSIFICATION_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getClassificationEvaluationMetrics().hashCode();
        break;
      case 24:
        hash = (37 * hash) + REGRESSION_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getRegressionEvaluationMetrics().hashCode();
        break;
      case 9:
        hash = (37 * hash) + TRANSLATION_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getTranslationEvaluationMetrics().hashCode();
        break;
      case 12:
        hash = (37 * hash) + IMAGE_OBJECT_DETECTION_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getImageObjectDetectionEvaluationMetrics().hashCode();
        break;
      case 14:
        hash = (37 * hash) + VIDEO_OBJECT_TRACKING_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getVideoObjectTrackingEvaluationMetrics().hashCode();
        break;
      case 11:
        hash = (37 * hash) + TEXT_SENTIMENT_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getTextSentimentEvaluationMetrics().hashCode();
        break;
      case 13:
        hash = (37 * hash) + TEXT_EXTRACTION_EVALUATION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getTextExtractionEvaluationMetrics().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.ModelEvaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Evaluation results of a model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.ModelEvaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.ModelEvaluation)
      com.google.cloud.automl.v1beta1.ModelEvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ModelEvaluationOuterClass
          .internal_static_google_cloud_automl_v1beta1_ModelEvaluation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ModelEvaluationOuterClass
          .internal_static_google_cloud_automl_v1beta1_ModelEvaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.ModelEvaluation.class,
              com.google.cloud.automl.v1beta1.ModelEvaluation.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.ModelEvaluation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (classificationEvaluationMetricsBuilder_ != null) {
        classificationEvaluationMetricsBuilder_.clear();
      }
      if (regressionEvaluationMetricsBuilder_ != null) {
        regressionEvaluationMetricsBuilder_.clear();
      }
      if (translationEvaluationMetricsBuilder_ != null) {
        translationEvaluationMetricsBuilder_.clear();
      }
      if (imageObjectDetectionEvaluationMetricsBuilder_ != null) {
        imageObjectDetectionEvaluationMetricsBuilder_.clear();
      }
      if (videoObjectTrackingEvaluationMetricsBuilder_ != null) {
        videoObjectTrackingEvaluationMetricsBuilder_.clear();
      }
      if (textSentimentEvaluationMetricsBuilder_ != null) {
        textSentimentEvaluationMetricsBuilder_.clear();
      }
      if (textExtractionEvaluationMetricsBuilder_ != null) {
        textExtractionEvaluationMetricsBuilder_.clear();
      }
      name_ = "";
      annotationSpecId_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      evaluatedExampleCount_ = 0;
      metricsCase_ = 0;
      metrics_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.ModelEvaluationOuterClass
          .internal_static_google_cloud_automl_v1beta1_ModelEvaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ModelEvaluation getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.ModelEvaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ModelEvaluation build() {
      com.google.cloud.automl.v1beta1.ModelEvaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ModelEvaluation buildPartial() {
      com.google.cloud.automl.v1beta1.ModelEvaluation result =
          new com.google.cloud.automl.v1beta1.ModelEvaluation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.ModelEvaluation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.annotationSpecId_ = annotationSpecId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.evaluatedExampleCount_ = evaluatedExampleCount_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.automl.v1beta1.ModelEvaluation result) {
      result.metricsCase_ = metricsCase_;
      result.metrics_ = this.metrics_;
      if (metricsCase_ == 8 && classificationEvaluationMetricsBuilder_ != null) {
        result.metrics_ = classificationEvaluationMetricsBuilder_.build();
      }
      if (metricsCase_ == 24 && regressionEvaluationMetricsBuilder_ != null) {
        result.metrics_ = regressionEvaluationMetricsBuilder_.build();
      }
      if (metricsCase_ == 9 && translationEvaluationMetricsBuilder_ != null) {
        result.metrics_ = translationEvaluationMetricsBuilder_.build();
      }
      if (metricsCase_ == 12 && imageObjectDetectionEvaluationMetricsBuilder_ != null) {
        result.metrics_ = imageObjectDetectionEvaluationMetricsBuilder_.build();
      }
      if (metricsCase_ == 14 && videoObjectTrackingEvaluationMetricsBuilder_ != null) {
        result.metrics_ = videoObjectTrackingEvaluationMetricsBuilder_.build();
      }
      if (metricsCase_ == 11 && textSentimentEvaluationMetricsBuilder_ != null) {
        result.metrics_ = textSentimentEvaluationMetricsBuilder_.build();
      }
      if (metricsCase_ == 13 && textExtractionEvaluationMetricsBuilder_ != null) {
        result.metrics_ = textExtractionEvaluationMetricsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.ModelEvaluation) {
        return mergeFrom((com.google.cloud.automl.v1beta1.ModelEvaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.ModelEvaluation other) {
      if (other == com.google.cloud.automl.v1beta1.ModelEvaluation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getAnnotationSpecId().isEmpty()) {
        annotationSpecId_ = other.annotationSpecId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getEvaluatedExampleCount() != 0) {
        setEvaluatedExampleCount(other.getEvaluatedExampleCount());
      }
      switch (other.getMetricsCase()) {
        case CLASSIFICATION_EVALUATION_METRICS:
          {
            mergeClassificationEvaluationMetrics(other.getClassificationEvaluationMetrics());
            break;
          }
        case REGRESSION_EVALUATION_METRICS:
          {
            mergeRegressionEvaluationMetrics(other.getRegressionEvaluationMetrics());
            break;
          }
        case TRANSLATION_EVALUATION_METRICS:
          {
            mergeTranslationEvaluationMetrics(other.getTranslationEvaluationMetrics());
            break;
          }
        case IMAGE_OBJECT_DETECTION_EVALUATION_METRICS:
          {
            mergeImageObjectDetectionEvaluationMetrics(
                other.getImageObjectDetectionEvaluationMetrics());
            break;
          }
        case VIDEO_OBJECT_TRACKING_EVALUATION_METRICS:
          {
            mergeVideoObjectTrackingEvaluationMetrics(
                other.getVideoObjectTrackingEvaluationMetrics());
            break;
          }
        case TEXT_SENTIMENT_EVALUATION_METRICS:
          {
            mergeTextSentimentEvaluationMetrics(other.getTextSentimentEvaluationMetrics());
            break;
          }
        case TEXT_EXTRACTION_EVALUATION_METRICS:
          {
            mergeTextExtractionEvaluationMetrics(other.getTextExtractionEvaluationMetrics());
            break;
          }
        case METRICS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 10
            case 18:
              {
                annotationSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 18
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 42
            case 48:
              {
                evaluatedExampleCount_ = input.readInt32();
                bitField0_ |= 0x00000800;
                break;
              } // case 48
            case 66:
              {
                input.readMessage(
                    getClassificationEvaluationMetricsFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricsCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getTranslationEvaluationMetricsFieldBuilder().getBuilder(), extensionRegistry);
                metricsCase_ = 9;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(
                    getTextSentimentEvaluationMetricsFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricsCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getImageObjectDetectionEvaluationMetricsFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricsCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getTextExtractionEvaluationMetricsFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricsCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getVideoObjectTrackingEvaluationMetricsFieldBuilder().getBuilder(),
                    extensionRegistry);
                metricsCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 122
            case 194:
              {
                input.readMessage(
                    getRegressionEvaluationMetricsFieldBuilder().getBuilder(), extensionRegistry);
                metricsCase_ = 24;
                break;
              } // case 194
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metricsCase_ = 0;
    private java.lang.Object metrics_;

    public MetricsCase getMetricsCase() {
      return MetricsCase.forNumber(metricsCase_);
    }

    public Builder clearMetrics() {
      metricsCase_ = 0;
      metrics_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics,
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .Builder,
            com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetricsOrBuilder>
        classificationEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     *
     * @return Whether the classificationEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasClassificationEvaluationMetrics() {
      return metricsCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     *
     * @return The classificationEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
        getClassificationEvaluationMetrics() {
      if (classificationEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 8) {
          return (com.google.cloud.automl.v1beta1.ClassificationProto
                  .ClassificationEvaluationMetrics)
              metrics_;
        }
        return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .getDefaultInstance();
      } else {
        if (metricsCase_ == 8) {
          return classificationEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    public Builder setClassificationEvaluationMetrics(
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics value) {
      if (classificationEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        classificationEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    public Builder setClassificationEvaluationMetrics(
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics.Builder
            builderForValue) {
      if (classificationEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        classificationEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    public Builder mergeClassificationEvaluationMetrics(
        com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics value) {
      if (classificationEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 8
            && metrics_
                != com.google.cloud.automl.v1beta1.ClassificationProto
                    .ClassificationEvaluationMetrics.getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .newBuilder(
                      (com.google.cloud.automl.v1beta1.ClassificationProto
                              .ClassificationEvaluationMetrics)
                          metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 8) {
          classificationEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          classificationEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    public Builder clearClassificationEvaluationMetrics() {
      if (classificationEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 8) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 8) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        classificationEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .Builder
        getClassificationEvaluationMetricsBuilder() {
      return getClassificationEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ClassificationProto
            .ClassificationEvaluationMetricsOrBuilder
        getClassificationEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 8) && (classificationEvaluationMetricsBuilder_ != null)) {
        return classificationEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 8) {
          return (com.google.cloud.automl.v1beta1.ClassificationProto
                  .ClassificationEvaluationMetrics)
              metrics_;
        }
        return com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image, text, video and tables
     * classification.
     * Tables problem is considered a classification when the target column
     * is CATEGORY DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ClassificationEvaluationMetrics classification_evaluation_metrics = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics,
            com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                .Builder,
            com.google.cloud.automl.v1beta1.ClassificationProto
                .ClassificationEvaluationMetricsOrBuilder>
        getClassificationEvaluationMetricsFieldBuilder() {
      if (classificationEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 8)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                  .getDefaultInstance();
        }
        classificationEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics,
                com.google.cloud.automl.v1beta1.ClassificationProto.ClassificationEvaluationMetrics
                    .Builder,
                com.google.cloud.automl.v1beta1.ClassificationProto
                    .ClassificationEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.ClassificationProto
                        .ClassificationEvaluationMetrics)
                    metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 8;
      onChanged();
      return classificationEvaluationMetricsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics,
            com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetricsOrBuilder>
        regressionEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     *
     * @return Whether the regressionEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasRegressionEvaluationMetrics() {
      return metricsCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     *
     * @return The regressionEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
        getRegressionEvaluationMetrics() {
      if (regressionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics)
              metrics_;
        }
        return com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
            .getDefaultInstance();
      } else {
        if (metricsCase_ == 24) {
          return regressionEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    public Builder setRegressionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics value) {
      if (regressionEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        regressionEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    public Builder setRegressionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics.Builder
            builderForValue) {
      if (regressionEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        regressionEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    public Builder mergeRegressionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics value) {
      if (regressionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 24
            && metrics_
                != com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
                    .getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
                  .newBuilder(
                      (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics)
                          metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 24) {
          regressionEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          regressionEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    public Builder clearRegressionEvaluationMetrics() {
      if (regressionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 24) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 24) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        regressionEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics.Builder
        getRegressionEvaluationMetricsBuilder() {
      return getRegressionEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetricsOrBuilder
        getRegressionEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 24) && (regressionEvaluationMetricsBuilder_ != null)) {
        return regressionEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics)
              metrics_;
        }
        return com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for Tables regression.
     * Tables problem is considered a regression when the target column
     * has FLOAT64 DataType.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.RegressionEvaluationMetrics regression_evaluation_metrics = 24;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics,
            com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetricsOrBuilder>
        getRegressionEvaluationMetricsFieldBuilder() {
      if (regressionEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 24)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics
                  .getDefaultInstance();
        }
        regressionEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics,
                com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics.Builder,
                com.google.cloud.automl.v1beta1.RegressionProto
                    .RegressionEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.RegressionProto.RegressionEvaluationMetrics)
                    metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 24;
      onChanged();
      return regressionEvaluationMetricsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics,
            com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.TranslationEvaluationMetricsOrBuilder>
        translationEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     *
     * @return Whether the translationEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasTranslationEvaluationMetrics() {
      return metricsCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     *
     * @return The translationEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics
        getTranslationEvaluationMetrics() {
      if (translationEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 9) {
          return (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.getDefaultInstance();
      } else {
        if (metricsCase_ == 9) {
          return translationEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    public Builder setTranslationEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics value) {
      if (translationEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        translationEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    public Builder setTranslationEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.Builder builderForValue) {
      if (translationEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        translationEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    public Builder mergeTranslationEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics value) {
      if (translationEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 9
            && metrics_
                != com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics
                    .getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.newBuilder(
                      (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 9) {
          translationEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          translationEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    public Builder clearTranslationEvaluationMetrics() {
      if (translationEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 9) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 9) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        translationEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.Builder
        getTranslationEvaluationMetricsBuilder() {
      return getTranslationEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TranslationEvaluationMetricsOrBuilder
        getTranslationEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 9) && (translationEvaluationMetricsBuilder_ != null)) {
        return translationEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 9) {
          return (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for translation.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TranslationEvaluationMetrics translation_evaluation_metrics = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics,
            com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.TranslationEvaluationMetricsOrBuilder>
        getTranslationEvaluationMetricsFieldBuilder() {
      if (translationEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 9)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.getDefaultInstance();
        }
        translationEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics,
                com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics.Builder,
                com.google.cloud.automl.v1beta1.TranslationEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.TranslationEvaluationMetrics) metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 9;
      onChanged();
      return translationEvaluationMetricsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetricsOrBuilder>
        imageObjectDetectionEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     *
     * @return Whether the imageObjectDetectionEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasImageObjectDetectionEvaluationMetrics() {
      return metricsCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     *
     * @return The imageObjectDetectionEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
        getImageObjectDetectionEvaluationMetrics() {
      if (imageObjectDetectionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 12) {
          return (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
            .getDefaultInstance();
      } else {
        if (metricsCase_ == 12) {
          return imageObjectDetectionEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    public Builder setImageObjectDetectionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics value) {
      if (imageObjectDetectionEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        imageObjectDetectionEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    public Builder setImageObjectDetectionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics.Builder
            builderForValue) {
      if (imageObjectDetectionEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        imageObjectDetectionEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    public Builder mergeImageObjectDetectionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics value) {
      if (imageObjectDetectionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 12
            && metrics_
                != com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
                    .getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics.newBuilder(
                      (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics)
                          metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 12) {
          imageObjectDetectionEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          imageObjectDetectionEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    public Builder clearImageObjectDetectionEvaluationMetrics() {
      if (imageObjectDetectionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 12) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 12) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        imageObjectDetectionEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics.Builder
        getImageObjectDetectionEvaluationMetricsBuilder() {
      return getImageObjectDetectionEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetricsOrBuilder
        getImageObjectDetectionEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 12) && (imageObjectDetectionEvaluationMetricsBuilder_ != null)) {
        return imageObjectDetectionEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 12) {
          return (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for image object detection.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics image_object_detection_evaluation_metrics = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetricsOrBuilder>
        getImageObjectDetectionEvaluationMetricsFieldBuilder() {
      if (imageObjectDetectionEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 12)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics
                  .getDefaultInstance();
        }
        imageObjectDetectionEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics,
                com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics.Builder,
                com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.ImageObjectDetectionEvaluationMetrics) metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 12;
      onChanged();
      return imageObjectDetectionEvaluationMetricsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetricsOrBuilder>
        videoObjectTrackingEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     *
     * @return Whether the videoObjectTrackingEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasVideoObjectTrackingEvaluationMetrics() {
      return metricsCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     *
     * @return The videoObjectTrackingEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
        getVideoObjectTrackingEvaluationMetrics() {
      if (videoObjectTrackingEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 14) {
          return (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
            .getDefaultInstance();
      } else {
        if (metricsCase_ == 14) {
          return videoObjectTrackingEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    public Builder setVideoObjectTrackingEvaluationMetrics(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics value) {
      if (videoObjectTrackingEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        videoObjectTrackingEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    public Builder setVideoObjectTrackingEvaluationMetrics(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics.Builder
            builderForValue) {
      if (videoObjectTrackingEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        videoObjectTrackingEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    public Builder mergeVideoObjectTrackingEvaluationMetrics(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics value) {
      if (videoObjectTrackingEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 14
            && metrics_
                != com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
                    .getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics.newBuilder(
                      (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics)
                          metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 14) {
          videoObjectTrackingEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          videoObjectTrackingEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    public Builder clearVideoObjectTrackingEvaluationMetrics() {
      if (videoObjectTrackingEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 14) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 14) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        videoObjectTrackingEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics.Builder
        getVideoObjectTrackingEvaluationMetricsBuilder() {
      return getVideoObjectTrackingEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetricsOrBuilder
        getVideoObjectTrackingEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 14) && (videoObjectTrackingEvaluationMetricsBuilder_ != null)) {
        return videoObjectTrackingEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 14) {
          return (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Model evaluation metrics for video object tracking.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics video_object_tracking_evaluation_metrics = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetricsOrBuilder>
        getVideoObjectTrackingEvaluationMetricsFieldBuilder() {
      if (videoObjectTrackingEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 14)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics
                  .getDefaultInstance();
        }
        videoObjectTrackingEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics,
                com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics.Builder,
                com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.VideoObjectTrackingEvaluationMetrics) metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 14;
      onChanged();
      return videoObjectTrackingEvaluationMetricsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics,
            com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                .Builder,
            com.google.cloud.automl.v1beta1.TextSentimentProto
                .TextSentimentEvaluationMetricsOrBuilder>
        textSentimentEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     *
     * @return Whether the textSentimentEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasTextSentimentEvaluationMetrics() {
      return metricsCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     *
     * @return The textSentimentEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
        getTextSentimentEvaluationMetrics() {
      if (textSentimentEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 11) {
          return (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
              metrics_;
        }
        return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
            .getDefaultInstance();
      } else {
        if (metricsCase_ == 11) {
          return textSentimentEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    public Builder setTextSentimentEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics value) {
      if (textSentimentEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        textSentimentEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    public Builder setTextSentimentEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics.Builder
            builderForValue) {
      if (textSentimentEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        textSentimentEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    public Builder mergeTextSentimentEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics value) {
      if (textSentimentEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 11
            && metrics_
                != com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                    .getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                  .newBuilder(
                      (com.google.cloud.automl.v1beta1.TextSentimentProto
                              .TextSentimentEvaluationMetrics)
                          metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 11) {
          textSentimentEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          textSentimentEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    public Builder clearTextSentimentEvaluationMetrics() {
      if (textSentimentEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 11) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 11) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        textSentimentEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics.Builder
        getTextSentimentEvaluationMetricsBuilder() {
      return getTextSentimentEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentProto
            .TextSentimentEvaluationMetricsOrBuilder
        getTextSentimentEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 11) && (textSentimentEvaluationMetricsBuilder_ != null)) {
        return textSentimentEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 11) {
          return (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
              metrics_;
        }
        return com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentEvaluationMetrics text_sentiment_evaluation_metrics = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics,
            com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                .Builder,
            com.google.cloud.automl.v1beta1.TextSentimentProto
                .TextSentimentEvaluationMetricsOrBuilder>
        getTextSentimentEvaluationMetricsFieldBuilder() {
      if (textSentimentEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 11)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                  .getDefaultInstance();
        }
        textSentimentEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics,
                com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics
                    .Builder,
                com.google.cloud.automl.v1beta1.TextSentimentProto
                    .TextSentimentEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextSentimentProto.TextSentimentEvaluationMetrics)
                    metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 11;
      onChanged();
      return textSentimentEvaluationMetricsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics,
            com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetricsOrBuilder>
        textExtractionEvaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     *
     * @return Whether the textExtractionEvaluationMetrics field is set.
     */
    @java.lang.Override
    public boolean hasTextExtractionEvaluationMetrics() {
      return metricsCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     *
     * @return The textExtractionEvaluationMetrics.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics
        getTextExtractionEvaluationMetrics() {
      if (textExtractionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 13) {
          return (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.getDefaultInstance();
      } else {
        if (metricsCase_ == 13) {
          return textExtractionEvaluationMetricsBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    public Builder setTextExtractionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics value) {
      if (textExtractionEvaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        textExtractionEvaluationMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    public Builder setTextExtractionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.Builder builderForValue) {
      if (textExtractionEvaluationMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        textExtractionEvaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    public Builder mergeTextExtractionEvaluationMetrics(
        com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics value) {
      if (textExtractionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 13
            && metrics_
                != com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics
                    .getDefaultInstance()) {
          metrics_ =
              com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 13) {
          textExtractionEvaluationMetricsBuilder_.mergeFrom(value);
        } else {
          textExtractionEvaluationMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    public Builder clearTextExtractionEvaluationMetrics() {
      if (textExtractionEvaluationMetricsBuilder_ == null) {
        if (metricsCase_ == 13) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 13) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        textExtractionEvaluationMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.Builder
        getTextExtractionEvaluationMetricsBuilder() {
      return getTextExtractionEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetricsOrBuilder
        getTextExtractionEvaluationMetricsOrBuilder() {
      if ((metricsCase_ == 13) && (textExtractionEvaluationMetricsBuilder_ != null)) {
        return textExtractionEvaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 13) {
          return (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_;
        }
        return com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics text_extraction_evaluation_metrics = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics,
            com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.Builder,
            com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetricsOrBuilder>
        getTextExtractionEvaluationMetricsFieldBuilder() {
      if (textExtractionEvaluationMetricsBuilder_ == null) {
        if (!(metricsCase_ == 13)) {
          metrics_ =
              com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.getDefaultInstance();
        }
        textExtractionEvaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics,
                com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics.Builder,
                com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetricsOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextExtractionEvaluationMetrics) metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 13;
      onChanged();
      return textExtractionEvaluationMetricsBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model evaluation.
     * Format:
     *
     * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model evaluation.
     * Format:
     *
     * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model evaluation.
     * Format:
     *
     * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model evaluation.
     * Format:
     *
     * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model evaluation.
     * Format:
     *
     * `projects/{project_id}/locations/{location_id}/models/{model_id}/modelEvaluations/{model_evaluation_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object annotationSpecId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the annotation spec that the model evaluation applies to. The
     * The ID is empty for the overall model evaluation.
     * For Tables annotation specs in the dataset do not exist and this ID is
     * always not set, but for CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * the
     * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
     * field is used.
     * </pre>
     *
     * <code>string annotation_spec_id = 2;</code>
     *
     * @return The annotationSpecId.
     */
    public java.lang.String getAnnotationSpecId() {
      java.lang.Object ref = annotationSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the annotation spec that the model evaluation applies to. The
     * The ID is empty for the overall model evaluation.
     * For Tables annotation specs in the dataset do not exist and this ID is
     * always not set, but for CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * the
     * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
     * field is used.
     * </pre>
     *
     * <code>string annotation_spec_id = 2;</code>
     *
     * @return The bytes for annotationSpecId.
     */
    public com.google.protobuf.ByteString getAnnotationSpecIdBytes() {
      java.lang.Object ref = annotationSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the annotation spec that the model evaluation applies to. The
     * The ID is empty for the overall model evaluation.
     * For Tables annotation specs in the dataset do not exist and this ID is
     * always not set, but for CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * the
     * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
     * field is used.
     * </pre>
     *
     * <code>string annotation_spec_id = 2;</code>
     *
     * @param value The annotationSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      annotationSpecId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the annotation spec that the model evaluation applies to. The
     * The ID is empty for the overall model evaluation.
     * For Tables annotation specs in the dataset do not exist and this ID is
     * always not set, but for CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * the
     * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
     * field is used.
     * </pre>
     *
     * <code>string annotation_spec_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSpecId() {
      annotationSpecId_ = getDefaultInstance().getAnnotationSpecId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the annotation spec that the model evaluation applies to. The
     * The ID is empty for the overall model evaluation.
     * For Tables annotation specs in the dataset do not exist and this ID is
     * always not set, but for CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * the
     * [display_name][google.cloud.automl.v1beta1.ModelEvaluation.display_name]
     * field is used.
     * </pre>
     *
     * <code>string annotation_spec_id = 2;</code>
     *
     * @param value The bytes for annotationSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      annotationSpecId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
     * the moment when the model was trained. Because this field returns a value
     * at model training time, for different models trained from the same dataset,
     * the values may differ, since display names could had been changed between
     * the two model's trainings.
     * For Tables CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * distinct values of the target column at the moment of the model evaluation
     * are populated here.
     * The display_name is empty for the overall model evaluation.
     * </pre>
     *
     * <code>string display_name = 15;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
     * the moment when the model was trained. Because this field returns a value
     * at model training time, for different models trained from the same dataset,
     * the values may differ, since display names could had been changed between
     * the two model's trainings.
     * For Tables CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * distinct values of the target column at the moment of the model evaluation
     * are populated here.
     * The display_name is empty for the overall model evaluation.
     * </pre>
     *
     * <code>string display_name = 15;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
     * the moment when the model was trained. Because this field returns a value
     * at model training time, for different models trained from the same dataset,
     * the values may differ, since display names could had been changed between
     * the two model's trainings.
     * For Tables CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * distinct values of the target column at the moment of the model evaluation
     * are populated here.
     * The display_name is empty for the overall model evaluation.
     * </pre>
     *
     * <code>string display_name = 15;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
     * the moment when the model was trained. Because this field returns a value
     * at model training time, for different models trained from the same dataset,
     * the values may differ, since display names could had been changed between
     * the two model's trainings.
     * For Tables CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * distinct values of the target column at the moment of the model evaluation
     * are populated here.
     * The display_name is empty for the overall model evaluation.
     * </pre>
     *
     * <code>string display_name = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of
     * [display_name][google.cloud.automl.v1beta1.AnnotationSpec.display_name] at
     * the moment when the model was trained. Because this field returns a value
     * at model training time, for different models trained from the same dataset,
     * the values may differ, since display names could had been changed between
     * the two model's trainings.
     * For Tables CLASSIFICATION
     *
     * [prediction_type-s][google.cloud.automl.v1beta1.TablesModelMetadata.prediction_type]
     * distinct values of the target column at the moment of the model evaluation
     * are populated here.
     * The display_name is empty for the overall model evaluation.
     * </pre>
     *
     * <code>string display_name = 15;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int evaluatedExampleCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of examples used for model evaluation, i.e. for
     * which ground truth from time of model creation is compared against the
     * predicted annotations created by the model.
     * For overall ModelEvaluation (i.e. with annotation_spec_id not set) this is
     * the total number of all examples used for evaluation.
     * Otherwise, this is the count of examples that according to the ground
     * truth were annotated by the
     *
     * [annotation_spec_id][google.cloud.automl.v1beta1.ModelEvaluation.annotation_spec_id].
     * </pre>
     *
     * <code>int32 evaluated_example_count = 6;</code>
     *
     * @return The evaluatedExampleCount.
     */
    @java.lang.Override
    public int getEvaluatedExampleCount() {
      return evaluatedExampleCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of examples used for model evaluation, i.e. for
     * which ground truth from time of model creation is compared against the
     * predicted annotations created by the model.
     * For overall ModelEvaluation (i.e. with annotation_spec_id not set) this is
     * the total number of all examples used for evaluation.
     * Otherwise, this is the count of examples that according to the ground
     * truth were annotated by the
     *
     * [annotation_spec_id][google.cloud.automl.v1beta1.ModelEvaluation.annotation_spec_id].
     * </pre>
     *
     * <code>int32 evaluated_example_count = 6;</code>
     *
     * @param value The evaluatedExampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluatedExampleCount(int value) {

      evaluatedExampleCount_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of examples used for model evaluation, i.e. for
     * which ground truth from time of model creation is compared against the
     * predicted annotations created by the model.
     * For overall ModelEvaluation (i.e. with annotation_spec_id not set) this is
     * the total number of all examples used for evaluation.
     * Otherwise, this is the count of examples that according to the ground
     * truth were annotated by the
     *
     * [annotation_spec_id][google.cloud.automl.v1beta1.ModelEvaluation.annotation_spec_id].
     * </pre>
     *
     * <code>int32 evaluated_example_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvaluatedExampleCount() {
      bitField0_ = (bitField0_ & ~0x00000800);
      evaluatedExampleCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.ModelEvaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.ModelEvaluation)
  private static final com.google.cloud.automl.v1beta1.ModelEvaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.ModelEvaluation();
  }

  public static com.google.cloud.automl.v1beta1.ModelEvaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelEvaluation> PARSER =
      new com.google.protobuf.AbstractParser<ModelEvaluation>() {
        @java.lang.Override
        public ModelEvaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelEvaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelEvaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ModelEvaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
