/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/model.proto

package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * API proto representing a trained machine learning model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.Model}
 */
public final class Model extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.Model)
    ModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Model.newBuilder() to construct.
  private Model(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Model() {
    name_ = "";
    displayName_ = "";
    datasetId_ = "";
    deploymentState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Model();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.ModelOuterClass
        .internal_static_google_cloud_automl_v1beta1_Model_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.ModelOuterClass
        .internal_static_google_cloud_automl_v1beta1_Model_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.Model.class,
            com.google.cloud.automl.v1beta1.Model.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Deployment state of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.automl.v1beta1.Model.DeploymentState}
   */
  public enum DeploymentState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should not be used, an un-set enum has this value by default.
     * </pre>
     *
     * <code>DEPLOYMENT_STATE_UNSPECIFIED = 0;</code>
     */
    DEPLOYMENT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Model is deployed.
     * </pre>
     *
     * <code>DEPLOYED = 1;</code>
     */
    DEPLOYED(1),
    /**
     *
     *
     * <pre>
     * Model is not deployed.
     * </pre>
     *
     * <code>UNDEPLOYED = 2;</code>
     */
    UNDEPLOYED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should not be used, an un-set enum has this value by default.
     * </pre>
     *
     * <code>DEPLOYMENT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int DEPLOYMENT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Model is deployed.
     * </pre>
     *
     * <code>DEPLOYED = 1;</code>
     */
    public static final int DEPLOYED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Model is not deployed.
     * </pre>
     *
     * <code>UNDEPLOYED = 2;</code>
     */
    public static final int UNDEPLOYED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeploymentState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeploymentState forNumber(int value) {
      switch (value) {
        case 0:
          return DEPLOYMENT_STATE_UNSPECIFIED;
        case 1:
          return DEPLOYED;
        case 2:
          return UNDEPLOYED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeploymentState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeploymentState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DeploymentState>() {
              public DeploymentState findValueByNumber(int number) {
                return DeploymentState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.Model.getDescriptor().getEnumTypes().get(0);
    }

    private static final DeploymentState[] VALUES = values();

    public static DeploymentState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeploymentState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.automl.v1beta1.Model.DeploymentState)
  }

  private int modelMetadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object modelMetadata_;

  public enum ModelMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSLATION_MODEL_METADATA(15),
    IMAGE_CLASSIFICATION_MODEL_METADATA(13),
    TEXT_CLASSIFICATION_MODEL_METADATA(14),
    IMAGE_OBJECT_DETECTION_MODEL_METADATA(20),
    VIDEO_CLASSIFICATION_MODEL_METADATA(23),
    VIDEO_OBJECT_TRACKING_MODEL_METADATA(21),
    TEXT_EXTRACTION_MODEL_METADATA(19),
    TABLES_MODEL_METADATA(24),
    TEXT_SENTIMENT_MODEL_METADATA(22),
    MODELMETADATA_NOT_SET(0);
    private final int value;

    private ModelMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModelMetadataCase forNumber(int value) {
      switch (value) {
        case 15:
          return TRANSLATION_MODEL_METADATA;
        case 13:
          return IMAGE_CLASSIFICATION_MODEL_METADATA;
        case 14:
          return TEXT_CLASSIFICATION_MODEL_METADATA;
        case 20:
          return IMAGE_OBJECT_DETECTION_MODEL_METADATA;
        case 23:
          return VIDEO_CLASSIFICATION_MODEL_METADATA;
        case 21:
          return VIDEO_OBJECT_TRACKING_MODEL_METADATA;
        case 19:
          return TEXT_EXTRACTION_MODEL_METADATA;
        case 24:
          return TABLES_MODEL_METADATA;
        case 22:
          return TEXT_SENTIMENT_MODEL_METADATA;
        case 0:
          return MODELMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModelMetadataCase getModelMetadataCase() {
    return ModelMetadataCase.forNumber(modelMetadataCase_);
  }

  public static final int TRANSLATION_MODEL_METADATA_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Metadata for translation models.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
   * </code>
   *
   * @return Whether the translationModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTranslationModelMetadata() {
    return modelMetadataCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Metadata for translation models.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
   * </code>
   *
   * @return The translationModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TranslationModelMetadata getTranslationModelMetadata() {
    if (modelMetadataCase_ == 15) {
      return (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for translation models.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TranslationModelMetadataOrBuilder
      getTranslationModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 15) {
      return (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance();
  }

  public static final int IMAGE_CLASSIFICATION_MODEL_METADATA_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Metadata for image classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
   * </code>
   *
   * @return Whether the imageClassificationModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasImageClassificationModelMetadata() {
    return modelMetadataCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Metadata for image classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
   * </code>
   *
   * @return The imageClassificationModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata
      getImageClassificationModelMetadata() {
    if (modelMetadataCase_ == 13) {
      return (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for image classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageClassificationModelMetadataOrBuilder
      getImageClassificationModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 13) {
      return (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_MODEL_METADATA_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Metadata for text classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
   * </code>
   *
   * @return Whether the textClassificationModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextClassificationModelMetadata() {
    return modelMetadataCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Metadata for text classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
   * </code>
   *
   * @return The textClassificationModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextClassificationModelMetadata
      getTextClassificationModelMetadata() {
    if (modelMetadataCase_ == 14) {
      return (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for text classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextClassificationModelMetadataOrBuilder
      getTextClassificationModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 14) {
      return (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.getDefaultInstance();
  }

  public static final int IMAGE_OBJECT_DETECTION_MODEL_METADATA_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Metadata for image object detection models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
   * </code>
   *
   * @return Whether the imageObjectDetectionModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasImageObjectDetectionModelMetadata() {
    return modelMetadataCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Metadata for image object detection models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
   * </code>
   *
   * @return The imageObjectDetectionModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
      getImageObjectDetectionModelMetadata() {
    if (modelMetadataCase_ == 20) {
      return (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for image object detection models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadataOrBuilder
      getImageObjectDetectionModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 20) {
      return (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.getDefaultInstance();
  }

  public static final int VIDEO_CLASSIFICATION_MODEL_METADATA_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Metadata for video classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
   * </code>
   *
   * @return Whether the videoClassificationModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasVideoClassificationModelMetadata() {
    return modelMetadataCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Metadata for video classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
   * </code>
   *
   * @return The videoClassificationModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata
      getVideoClassificationModelMetadata() {
    if (modelMetadataCase_ == 23) {
      return (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for video classification models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoClassificationModelMetadataOrBuilder
      getVideoClassificationModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 23) {
      return (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.getDefaultInstance();
  }

  public static final int VIDEO_OBJECT_TRACKING_MODEL_METADATA_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Metadata for video object tracking models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
   * </code>
   *
   * @return Whether the videoObjectTrackingModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasVideoObjectTrackingModelMetadata() {
    return modelMetadataCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Metadata for video object tracking models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
   * </code>
   *
   * @return The videoObjectTrackingModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata
      getVideoObjectTrackingModelMetadata() {
    if (modelMetadataCase_ == 21) {
      return (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for video object tracking models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadataOrBuilder
      getVideoObjectTrackingModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 21) {
      return (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.getDefaultInstance();
  }

  public static final int TEXT_EXTRACTION_MODEL_METADATA_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Metadata for text extraction models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
   * </code>
   *
   * @return Whether the textExtractionModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextExtractionModelMetadata() {
    return modelMetadataCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Metadata for text extraction models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
   * </code>
   *
   * @return The textExtractionModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextExtractionModelMetadata
      getTextExtractionModelMetadata() {
    if (modelMetadataCase_ == 19) {
      return (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for text extraction models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextExtractionModelMetadataOrBuilder
      getTextExtractionModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 19) {
      return (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.getDefaultInstance();
  }

  public static final int TABLES_MODEL_METADATA_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Metadata for Tables models.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
   *
   * @return Whether the tablesModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTablesModelMetadata() {
    return modelMetadataCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Metadata for Tables models.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
   *
   * @return The tablesModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TablesModelMetadata getTablesModelMetadata() {
    if (modelMetadataCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for Tables models.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TablesModelMetadataOrBuilder
      getTablesModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 24) {
      return (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance();
  }

  public static final int TEXT_SENTIMENT_MODEL_METADATA_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Metadata for text sentiment models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
   * </code>
   *
   * @return Whether the textSentimentModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextSentimentModelMetadata() {
    return modelMetadataCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Metadata for text sentiment models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
   * </code>
   *
   * @return The textSentimentModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSentimentModelMetadata
      getTextSentimentModelMetadata() {
    if (modelMetadataCase_ == 22) {
      return (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for text sentiment models.
   * </pre>
   *
   * <code>
   * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TextSentimentModelMetadataOrBuilder
      getTextSentimentModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 22) {
      return (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_;
    }
    return com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the model.
   * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the model.
   * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the model to show in the interface. The name can be
   * up to 32 characters long and can consist only of ASCII Latin letters A-Z
   * and a-z, underscores
   * (_), and ASCII digits 0-9. It must start with a letter.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the model to show in the interface. The name can be
   * up to 32 characters long and can consist only of ASCII Latin letters A-Z
   * and a-z, underscores
   * (_), and ASCII digits 0-9. It must start with a letter.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource ID of the dataset used to create the model. The dataset must
   * come from the same ancestor project and location.
   * </pre>
   *
   * <code>string dataset_id = 3;</code>
   *
   * @return The datasetId.
   */
  @java.lang.Override
  public java.lang.String getDatasetId() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource ID of the dataset used to create the model. The dataset must
   * come from the same ancestor project and location.
   * </pre>
   *
   * <code>string dataset_id = 3;</code>
   *
   * @return The bytes for datasetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetIdBytes() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the model training finished  and can be used for prediction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the model training finished  and can be used for prediction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the model training finished  and can be used for prediction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this model was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this model was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this model was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DEPLOYMENT_STATE_FIELD_NUMBER = 8;
  private int deploymentState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Deployment state of the model. A model can only serve
   * prediction requests after it gets deployed.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
   *
   * @return The enum numeric value on the wire for deploymentState.
   */
  @java.lang.Override
  public int getDeploymentStateValue() {
    return deploymentState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Deployment state of the model. A model can only serve
   * prediction requests after it gets deployed.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
   *
   * @return The deploymentState.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Model.DeploymentState getDeploymentState() {
    com.google.cloud.automl.v1beta1.Model.DeploymentState result =
        com.google.cloud.automl.v1beta1.Model.DeploymentState.forNumber(deploymentState_);
    return result == null
        ? com.google.cloud.automl.v1beta1.Model.DeploymentState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, datasetId_);
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (deploymentState_
        != com.google.cloud.automl.v1beta1.Model.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, deploymentState_);
    }
    if (updateTime_ != null) {
      output.writeMessage(11, getUpdateTime());
    }
    if (modelMetadataCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 15) {
      output.writeMessage(
          15, (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 19) {
      output.writeMessage(
          19, (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 21) {
      output.writeMessage(
          21, (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 22) {
      output.writeMessage(
          22, (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 23) {
      output.writeMessage(
          23, (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 24) {
      output.writeMessage(24, (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, datasetId_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (deploymentState_
        != com.google.cloud.automl.v1beta1.Model.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, deploymentState_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    if (modelMetadataCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13,
              (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20,
              (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21,
              (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23,
              (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.Model)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.Model other = (com.google.cloud.automl.v1beta1.Model) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDatasetId().equals(other.getDatasetId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (deploymentState_ != other.deploymentState_) return false;
    if (!getModelMetadataCase().equals(other.getModelMetadataCase())) return false;
    switch (modelMetadataCase_) {
      case 15:
        if (!getTranslationModelMetadata().equals(other.getTranslationModelMetadata()))
          return false;
        break;
      case 13:
        if (!getImageClassificationModelMetadata()
            .equals(other.getImageClassificationModelMetadata())) return false;
        break;
      case 14:
        if (!getTextClassificationModelMetadata()
            .equals(other.getTextClassificationModelMetadata())) return false;
        break;
      case 20:
        if (!getImageObjectDetectionModelMetadata()
            .equals(other.getImageObjectDetectionModelMetadata())) return false;
        break;
      case 23:
        if (!getVideoClassificationModelMetadata()
            .equals(other.getVideoClassificationModelMetadata())) return false;
        break;
      case 21:
        if (!getVideoObjectTrackingModelMetadata()
            .equals(other.getVideoObjectTrackingModelMetadata())) return false;
        break;
      case 19:
        if (!getTextExtractionModelMetadata().equals(other.getTextExtractionModelMetadata()))
          return false;
        break;
      case 24:
        if (!getTablesModelMetadata().equals(other.getTablesModelMetadata())) return false;
        break;
      case 22:
        if (!getTextSentimentModelMetadata().equals(other.getTextSentimentModelMetadata()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DEPLOYMENT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + deploymentState_;
    switch (modelMetadataCase_) {
      case 15:
        hash = (37 * hash) + TRANSLATION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTranslationModelMetadata().hashCode();
        break;
      case 13:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationModelMetadata().hashCode();
        break;
      case 14:
        hash = (37 * hash) + TEXT_CLASSIFICATION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationModelMetadata().hashCode();
        break;
      case 20:
        hash = (37 * hash) + IMAGE_OBJECT_DETECTION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getImageObjectDetectionModelMetadata().hashCode();
        break;
      case 23:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationModelMetadata().hashCode();
        break;
      case 21:
        hash = (37 * hash) + VIDEO_OBJECT_TRACKING_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getVideoObjectTrackingModelMetadata().hashCode();
        break;
      case 19:
        hash = (37 * hash) + TEXT_EXTRACTION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextExtractionModelMetadata().hashCode();
        break;
      case 24:
        hash = (37 * hash) + TABLES_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTablesModelMetadata().hashCode();
        break;
      case 22:
        hash = (37 * hash) + TEXT_SENTIMENT_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextSentimentModelMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Model parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Model parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.Model parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.Model prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * API proto representing a trained machine learning model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.Model}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.Model)
      com.google.cloud.automl.v1beta1.ModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.ModelOuterClass
          .internal_static_google_cloud_automl_v1beta1_Model_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.ModelOuterClass
          .internal_static_google_cloud_automl_v1beta1_Model_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.Model.class,
              com.google.cloud.automl.v1beta1.Model.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.Model.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (translationModelMetadataBuilder_ != null) {
        translationModelMetadataBuilder_.clear();
      }
      if (imageClassificationModelMetadataBuilder_ != null) {
        imageClassificationModelMetadataBuilder_.clear();
      }
      if (textClassificationModelMetadataBuilder_ != null) {
        textClassificationModelMetadataBuilder_.clear();
      }
      if (imageObjectDetectionModelMetadataBuilder_ != null) {
        imageObjectDetectionModelMetadataBuilder_.clear();
      }
      if (videoClassificationModelMetadataBuilder_ != null) {
        videoClassificationModelMetadataBuilder_.clear();
      }
      if (videoObjectTrackingModelMetadataBuilder_ != null) {
        videoObjectTrackingModelMetadataBuilder_.clear();
      }
      if (textExtractionModelMetadataBuilder_ != null) {
        textExtractionModelMetadataBuilder_.clear();
      }
      if (tablesModelMetadataBuilder_ != null) {
        tablesModelMetadataBuilder_.clear();
      }
      if (textSentimentModelMetadataBuilder_ != null) {
        textSentimentModelMetadataBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      datasetId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deploymentState_ = 0;
      modelMetadataCase_ = 0;
      modelMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.ModelOuterClass
          .internal_static_google_cloud_automl_v1beta1_Model_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Model getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.Model.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Model build() {
      com.google.cloud.automl.v1beta1.Model result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Model buildPartial() {
      com.google.cloud.automl.v1beta1.Model result =
          new com.google.cloud.automl.v1beta1.Model(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.Model result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.datasetId_ = datasetId_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.deploymentState_ = deploymentState_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.automl.v1beta1.Model result) {
      result.modelMetadataCase_ = modelMetadataCase_;
      result.modelMetadata_ = this.modelMetadata_;
      if (modelMetadataCase_ == 15 && translationModelMetadataBuilder_ != null) {
        result.modelMetadata_ = translationModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 13 && imageClassificationModelMetadataBuilder_ != null) {
        result.modelMetadata_ = imageClassificationModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 14 && textClassificationModelMetadataBuilder_ != null) {
        result.modelMetadata_ = textClassificationModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 20 && imageObjectDetectionModelMetadataBuilder_ != null) {
        result.modelMetadata_ = imageObjectDetectionModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 23 && videoClassificationModelMetadataBuilder_ != null) {
        result.modelMetadata_ = videoClassificationModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 21 && videoObjectTrackingModelMetadataBuilder_ != null) {
        result.modelMetadata_ = videoObjectTrackingModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 19 && textExtractionModelMetadataBuilder_ != null) {
        result.modelMetadata_ = textExtractionModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 24 && tablesModelMetadataBuilder_ != null) {
        result.modelMetadata_ = tablesModelMetadataBuilder_.build();
      }
      if (modelMetadataCase_ == 22 && textSentimentModelMetadataBuilder_ != null) {
        result.modelMetadata_ = textSentimentModelMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.Model) {
        return mergeFrom((com.google.cloud.automl.v1beta1.Model) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.Model other) {
      if (other == com.google.cloud.automl.v1beta1.Model.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getDatasetId().isEmpty()) {
        datasetId_ = other.datasetId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.deploymentState_ != 0) {
        setDeploymentStateValue(other.getDeploymentStateValue());
      }
      switch (other.getModelMetadataCase()) {
        case TRANSLATION_MODEL_METADATA:
          {
            mergeTranslationModelMetadata(other.getTranslationModelMetadata());
            break;
          }
        case IMAGE_CLASSIFICATION_MODEL_METADATA:
          {
            mergeImageClassificationModelMetadata(other.getImageClassificationModelMetadata());
            break;
          }
        case TEXT_CLASSIFICATION_MODEL_METADATA:
          {
            mergeTextClassificationModelMetadata(other.getTextClassificationModelMetadata());
            break;
          }
        case IMAGE_OBJECT_DETECTION_MODEL_METADATA:
          {
            mergeImageObjectDetectionModelMetadata(other.getImageObjectDetectionModelMetadata());
            break;
          }
        case VIDEO_CLASSIFICATION_MODEL_METADATA:
          {
            mergeVideoClassificationModelMetadata(other.getVideoClassificationModelMetadata());
            break;
          }
        case VIDEO_OBJECT_TRACKING_MODEL_METADATA:
          {
            mergeVideoObjectTrackingModelMetadata(other.getVideoObjectTrackingModelMetadata());
            break;
          }
        case TEXT_EXTRACTION_MODEL_METADATA:
          {
            mergeTextExtractionModelMetadata(other.getTextExtractionModelMetadata());
            break;
          }
        case TABLES_MODEL_METADATA:
          {
            mergeTablesModelMetadata(other.getTablesModelMetadata());
            break;
          }
        case TEXT_SENTIMENT_MODEL_METADATA:
          {
            mergeTextSentimentModelMetadata(other.getTextSentimentModelMetadata());
            break;
          }
        case MODELMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 18
            case 26:
              {
                datasetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 58
            case 64:
              {
                deploymentState_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 64
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(
                    getImageClassificationModelMetadataFieldBuilder().getBuilder(),
                    extensionRegistry);
                modelMetadataCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getTextClassificationModelMetadataFieldBuilder().getBuilder(),
                    extensionRegistry);
                modelMetadataCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getTranslationModelMetadataFieldBuilder().getBuilder(), extensionRegistry);
                modelMetadataCase_ = 15;
                break;
              } // case 122
            case 154:
              {
                input.readMessage(
                    getTextExtractionModelMetadataFieldBuilder().getBuilder(), extensionRegistry);
                modelMetadataCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getImageObjectDetectionModelMetadataFieldBuilder().getBuilder(),
                    extensionRegistry);
                modelMetadataCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getVideoObjectTrackingModelMetadataFieldBuilder().getBuilder(),
                    extensionRegistry);
                modelMetadataCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getTextSentimentModelMetadataFieldBuilder().getBuilder(), extensionRegistry);
                modelMetadataCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getVideoClassificationModelMetadataFieldBuilder().getBuilder(),
                    extensionRegistry);
                modelMetadataCase_ = 23;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getTablesModelMetadataFieldBuilder().getBuilder(), extensionRegistry);
                modelMetadataCase_ = 24;
                break;
              } // case 194
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modelMetadataCase_ = 0;
    private java.lang.Object modelMetadata_;

    public ModelMetadataCase getModelMetadataCase() {
      return ModelMetadataCase.forNumber(modelMetadataCase_);
    }

    public Builder clearModelMetadata() {
      modelMetadataCase_ = 0;
      modelMetadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TranslationModelMetadata,
            com.google.cloud.automl.v1beta1.TranslationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TranslationModelMetadataOrBuilder>
        translationModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     *
     * @return Whether the translationModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTranslationModelMetadata() {
      return modelMetadataCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     *
     * @return The translationModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TranslationModelMetadata getTranslationModelMetadata() {
      if (translationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 15) {
          return (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 15) {
          return translationModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    public Builder setTranslationModelMetadata(
        com.google.cloud.automl.v1beta1.TranslationModelMetadata value) {
      if (translationModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        translationModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    public Builder setTranslationModelMetadata(
        com.google.cloud.automl.v1beta1.TranslationModelMetadata.Builder builderForValue) {
      if (translationModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        translationModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    public Builder mergeTranslationModelMetadata(
        com.google.cloud.automl.v1beta1.TranslationModelMetadata value) {
      if (translationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 15
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TranslationModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 15) {
          translationModelMetadataBuilder_.mergeFrom(value);
        } else {
          translationModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    public Builder clearTranslationModelMetadata() {
      if (translationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 15) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 15) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        translationModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TranslationModelMetadata.Builder
        getTranslationModelMetadataBuilder() {
      return getTranslationModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TranslationModelMetadataOrBuilder
        getTranslationModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 15) && (translationModelMetadataBuilder_ != null)) {
        return translationModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 15) {
          return (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for translation models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TranslationModelMetadata translation_model_metadata = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TranslationModelMetadata,
            com.google.cloud.automl.v1beta1.TranslationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TranslationModelMetadataOrBuilder>
        getTranslationModelMetadataFieldBuilder() {
      if (translationModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 15)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TranslationModelMetadata.getDefaultInstance();
        }
        translationModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TranslationModelMetadata,
                com.google.cloud.automl.v1beta1.TranslationModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.TranslationModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TranslationModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 15;
      onChanged();
      return translationModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata,
            com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageClassificationModelMetadataOrBuilder>
        imageClassificationModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     *
     * @return Whether the imageClassificationModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasImageClassificationModelMetadata() {
      return modelMetadataCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     *
     * @return The imageClassificationModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata
        getImageClassificationModelMetadata() {
      if (imageClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 13) {
          return (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata
            .getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 13) {
          return imageClassificationModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    public Builder setImageClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata value) {
      if (imageClassificationModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        imageClassificationModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    public Builder setImageClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.Builder builderForValue) {
      if (imageClassificationModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    public Builder mergeImageClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata value) {
      if (imageClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 13
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata)
                          modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 13) {
          imageClassificationModelMetadataBuilder_.mergeFrom(value);
        } else {
          imageClassificationModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    public Builder clearImageClassificationModelMetadata() {
      if (imageClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 13) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 13) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        imageClassificationModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.Builder
        getImageClassificationModelMetadataBuilder() {
      return getImageClassificationModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageClassificationModelMetadataOrBuilder
        getImageClassificationModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 13) && (imageClassificationModelMetadataBuilder_ != null)) {
        return imageClassificationModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 13) {
          return (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for image classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageClassificationModelMetadata image_classification_model_metadata = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata,
            com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageClassificationModelMetadataOrBuilder>
        getImageClassificationModelMetadataFieldBuilder() {
      if (imageClassificationModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 13)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.getDefaultInstance();
        }
        imageClassificationModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata,
                com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.ImageClassificationModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ImageClassificationModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 13;
      onChanged();
      return imageClassificationModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextClassificationModelMetadata,
            com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextClassificationModelMetadataOrBuilder>
        textClassificationModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     *
     * @return Whether the textClassificationModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextClassificationModelMetadata() {
      return modelMetadataCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     *
     * @return The textClassificationModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextClassificationModelMetadata
        getTextClassificationModelMetadata() {
      if (textClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 14) {
          return (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 14) {
          return textClassificationModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    public Builder setTextClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.TextClassificationModelMetadata value) {
      if (textClassificationModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        textClassificationModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    public Builder setTextClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.Builder builderForValue) {
      if (textClassificationModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    public Builder mergeTextClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.TextClassificationModelMetadata value) {
      if (textClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 14
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.TextClassificationModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata)
                          modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 14) {
          textClassificationModelMetadataBuilder_.mergeFrom(value);
        } else {
          textClassificationModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    public Builder clearTextClassificationModelMetadata() {
      if (textClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 14) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 14) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        textClassificationModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.Builder
        getTextClassificationModelMetadataBuilder() {
      return getTextClassificationModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextClassificationModelMetadataOrBuilder
        getTextClassificationModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 14) && (textClassificationModelMetadataBuilder_ != null)) {
        return textClassificationModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 14) {
          return (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for text classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextClassificationModelMetadata text_classification_model_metadata = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextClassificationModelMetadata,
            com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextClassificationModelMetadataOrBuilder>
        getTextClassificationModelMetadataFieldBuilder() {
      if (textClassificationModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 14)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.getDefaultInstance();
        }
        textClassificationModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextClassificationModelMetadata,
                com.google.cloud.automl.v1beta1.TextClassificationModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.TextClassificationModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextClassificationModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 14;
      onChanged();
      return textClassificationModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadataOrBuilder>
        imageObjectDetectionModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     *
     * @return Whether the imageObjectDetectionModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasImageObjectDetectionModelMetadata() {
      return modelMetadataCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     *
     * @return The imageObjectDetectionModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
        getImageObjectDetectionModelMetadata() {
      if (imageObjectDetectionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 20) {
          return (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
            .getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 20) {
          return imageObjectDetectionModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    public Builder setImageObjectDetectionModelMetadata(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata value) {
      if (imageObjectDetectionModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        imageObjectDetectionModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    public Builder setImageObjectDetectionModelMetadata(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.Builder builderForValue) {
      if (imageObjectDetectionModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        imageObjectDetectionModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    public Builder mergeImageObjectDetectionModelMetadata(
        com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata value) {
      if (imageObjectDetectionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 20
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata)
                          modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 20) {
          imageObjectDetectionModelMetadataBuilder_.mergeFrom(value);
        } else {
          imageObjectDetectionModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    public Builder clearImageObjectDetectionModelMetadata() {
      if (imageObjectDetectionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 20) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 20) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        imageObjectDetectionModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.Builder
        getImageObjectDetectionModelMetadataBuilder() {
      return getImageObjectDetectionModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadataOrBuilder
        getImageObjectDetectionModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 20) && (imageObjectDetectionModelMetadataBuilder_ != null)) {
        return imageObjectDetectionModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 20) {
          return (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for image object detection models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata image_object_detection_model_metadata = 20;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadataOrBuilder>
        getImageObjectDetectionModelMetadataFieldBuilder() {
      if (imageObjectDetectionModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 20)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata
                  .getDefaultInstance();
        }
        imageObjectDetectionModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata,
                com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.ImageObjectDetectionModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 20;
      onChanged();
      return imageObjectDetectionModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata,
            com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoClassificationModelMetadataOrBuilder>
        videoClassificationModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     *
     * @return Whether the videoClassificationModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasVideoClassificationModelMetadata() {
      return modelMetadataCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     *
     * @return The videoClassificationModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata
        getVideoClassificationModelMetadata() {
      if (videoClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 23) {
          return (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata
            .getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 23) {
          return videoClassificationModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    public Builder setVideoClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata value) {
      if (videoClassificationModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        videoClassificationModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    public Builder setVideoClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.Builder builderForValue) {
      if (videoClassificationModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    public Builder mergeVideoClassificationModelMetadata(
        com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata value) {
      if (videoClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 23
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata)
                          modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 23) {
          videoClassificationModelMetadataBuilder_.mergeFrom(value);
        } else {
          videoClassificationModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    public Builder clearVideoClassificationModelMetadata() {
      if (videoClassificationModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 23) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 23) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        videoClassificationModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.Builder
        getVideoClassificationModelMetadataBuilder() {
      return getVideoClassificationModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoClassificationModelMetadataOrBuilder
        getVideoClassificationModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 23) && (videoClassificationModelMetadataBuilder_ != null)) {
        return videoClassificationModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 23) {
          return (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for video classification models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoClassificationModelMetadata video_classification_model_metadata = 23;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata,
            com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoClassificationModelMetadataOrBuilder>
        getVideoClassificationModelMetadataFieldBuilder() {
      if (videoClassificationModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 23)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.getDefaultInstance();
        }
        videoClassificationModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata,
                com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.VideoClassificationModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.VideoClassificationModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 23;
      onChanged();
      return videoClassificationModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadataOrBuilder>
        videoObjectTrackingModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     *
     * @return Whether the videoObjectTrackingModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasVideoObjectTrackingModelMetadata() {
      return modelMetadataCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     *
     * @return The videoObjectTrackingModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata
        getVideoObjectTrackingModelMetadata() {
      if (videoObjectTrackingModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 21) {
          return (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata
            .getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 21) {
          return videoObjectTrackingModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    public Builder setVideoObjectTrackingModelMetadata(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata value) {
      if (videoObjectTrackingModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        videoObjectTrackingModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    public Builder setVideoObjectTrackingModelMetadata(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.Builder builderForValue) {
      if (videoObjectTrackingModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        videoObjectTrackingModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    public Builder mergeVideoObjectTrackingModelMetadata(
        com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata value) {
      if (videoObjectTrackingModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 21
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata)
                          modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 21) {
          videoObjectTrackingModelMetadataBuilder_.mergeFrom(value);
        } else {
          videoObjectTrackingModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    public Builder clearVideoObjectTrackingModelMetadata() {
      if (videoObjectTrackingModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 21) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 21) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        videoObjectTrackingModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.Builder
        getVideoObjectTrackingModelMetadataBuilder() {
      return getVideoObjectTrackingModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadataOrBuilder
        getVideoObjectTrackingModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 21) && (videoObjectTrackingModelMetadataBuilder_ != null)) {
        return videoObjectTrackingModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 21) {
          return (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for video object tracking models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata video_object_tracking_model_metadata = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadataOrBuilder>
        getVideoObjectTrackingModelMetadataFieldBuilder() {
      if (videoObjectTrackingModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 21)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.getDefaultInstance();
        }
        videoObjectTrackingModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata,
                com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.VideoObjectTrackingModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 21;
      onChanged();
      return videoObjectTrackingModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextExtractionModelMetadata,
            com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextExtractionModelMetadataOrBuilder>
        textExtractionModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     *
     * @return Whether the textExtractionModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextExtractionModelMetadata() {
      return modelMetadataCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     *
     * @return The textExtractionModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextExtractionModelMetadata
        getTextExtractionModelMetadata() {
      if (textExtractionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 19) {
          return (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 19) {
          return textExtractionModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    public Builder setTextExtractionModelMetadata(
        com.google.cloud.automl.v1beta1.TextExtractionModelMetadata value) {
      if (textExtractionModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        textExtractionModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    public Builder setTextExtractionModelMetadata(
        com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.Builder builderForValue) {
      if (textExtractionModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textExtractionModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    public Builder mergeTextExtractionModelMetadata(
        com.google.cloud.automl.v1beta1.TextExtractionModelMetadata value) {
      if (textExtractionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 19
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.TextExtractionModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 19) {
          textExtractionModelMetadataBuilder_.mergeFrom(value);
        } else {
          textExtractionModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    public Builder clearTextExtractionModelMetadata() {
      if (textExtractionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 19) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 19) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        textExtractionModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.Builder
        getTextExtractionModelMetadataBuilder() {
      return getTextExtractionModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextExtractionModelMetadataOrBuilder
        getTextExtractionModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 19) && (textExtractionModelMetadataBuilder_ != null)) {
        return textExtractionModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 19) {
          return (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for text extraction models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextExtractionModelMetadata text_extraction_model_metadata = 19;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextExtractionModelMetadata,
            com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextExtractionModelMetadataOrBuilder>
        getTextExtractionModelMetadataFieldBuilder() {
      if (textExtractionModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 19)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.getDefaultInstance();
        }
        textExtractionModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextExtractionModelMetadata,
                com.google.cloud.automl.v1beta1.TextExtractionModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.TextExtractionModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextExtractionModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 19;
      onChanged();
      return textExtractionModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TablesModelMetadata,
            com.google.cloud.automl.v1beta1.TablesModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TablesModelMetadataOrBuilder>
        tablesModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     *
     * @return Whether the tablesModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTablesModelMetadata() {
      return modelMetadataCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     *
     * @return The tablesModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesModelMetadata getTablesModelMetadata() {
      if (tablesModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 24) {
          return tablesModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    public Builder setTablesModelMetadata(
        com.google.cloud.automl.v1beta1.TablesModelMetadata value) {
      if (tablesModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        tablesModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    public Builder setTablesModelMetadata(
        com.google.cloud.automl.v1beta1.TablesModelMetadata.Builder builderForValue) {
      if (tablesModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        tablesModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    public Builder mergeTablesModelMetadata(
        com.google.cloud.automl.v1beta1.TablesModelMetadata value) {
      if (tablesModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 24
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TablesModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 24) {
          tablesModelMetadataBuilder_.mergeFrom(value);
        } else {
          tablesModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    public Builder clearTablesModelMetadata() {
      if (tablesModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 24) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 24) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        tablesModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    public com.google.cloud.automl.v1beta1.TablesModelMetadata.Builder
        getTablesModelMetadataBuilder() {
      return getTablesModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TablesModelMetadataOrBuilder
        getTablesModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 24) && (tablesModelMetadataBuilder_ != null)) {
        return tablesModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 24) {
          return (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for Tables models.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TablesModelMetadata tables_model_metadata = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TablesModelMetadata,
            com.google.cloud.automl.v1beta1.TablesModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TablesModelMetadataOrBuilder>
        getTablesModelMetadataFieldBuilder() {
      if (tablesModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 24)) {
          modelMetadata_ = com.google.cloud.automl.v1beta1.TablesModelMetadata.getDefaultInstance();
        }
        tablesModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TablesModelMetadata,
                com.google.cloud.automl.v1beta1.TablesModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.TablesModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TablesModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 24;
      onChanged();
      return tablesModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSentimentModelMetadata,
            com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextSentimentModelMetadataOrBuilder>
        textSentimentModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     *
     * @return Whether the textSentimentModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextSentimentModelMetadata() {
      return modelMetadataCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     *
     * @return The textSentimentModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentModelMetadata
        getTextSentimentModelMetadata() {
      if (textSentimentModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 22) {
          return (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 22) {
          return textSentimentModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    public Builder setTextSentimentModelMetadata(
        com.google.cloud.automl.v1beta1.TextSentimentModelMetadata value) {
      if (textSentimentModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        textSentimentModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    public Builder setTextSentimentModelMetadata(
        com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.Builder builderForValue) {
      if (textSentimentModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textSentimentModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    public Builder mergeTextSentimentModelMetadata(
        com.google.cloud.automl.v1beta1.TextSentimentModelMetadata value) {
      if (textSentimentModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 22
            && modelMetadata_
                != com.google.cloud.automl.v1beta1.TextSentimentModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.newBuilder(
                      (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 22) {
          textSentimentModelMetadataBuilder_.mergeFrom(value);
        } else {
          textSentimentModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    public Builder clearTextSentimentModelMetadata() {
      if (textSentimentModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 22) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 22) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        textSentimentModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    public com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.Builder
        getTextSentimentModelMetadataBuilder() {
      return getTextSentimentModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TextSentimentModelMetadataOrBuilder
        getTextSentimentModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 22) && (textSentimentModelMetadataBuilder_ != null)) {
        return textSentimentModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 22) {
          return (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_;
        }
        return com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for text sentiment models.
     * </pre>
     *
     * <code>
     * .google.cloud.automl.v1beta1.TextSentimentModelMetadata text_sentiment_model_metadata = 22;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.TextSentimentModelMetadata,
            com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.Builder,
            com.google.cloud.automl.v1beta1.TextSentimentModelMetadataOrBuilder>
        getTextSentimentModelMetadataFieldBuilder() {
      if (textSentimentModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 22)) {
          modelMetadata_ =
              com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.getDefaultInstance();
        }
        textSentimentModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.TextSentimentModelMetadata,
                com.google.cloud.automl.v1beta1.TextSentimentModelMetadata.Builder,
                com.google.cloud.automl.v1beta1.TextSentimentModelMetadataOrBuilder>(
                (com.google.cloud.automl.v1beta1.TextSentimentModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 22;
      onChanged();
      return textSentimentModelMetadataBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model.
     * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model.
     * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model.
     * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model.
     * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the model.
     * Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the model to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9. It must start with a letter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9. It must start with a letter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9. It must start with a letter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9. It must start with a letter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model to show in the interface. The name can be
     * up to 32 characters long and can consist only of ASCII Latin letters A-Z
     * and a-z, underscores
     * (_), and ASCII digits 0-9. It must start with a letter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource ID of the dataset used to create the model. The dataset must
     * come from the same ancestor project and location.
     * </pre>
     *
     * <code>string dataset_id = 3;</code>
     *
     * @return The datasetId.
     */
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource ID of the dataset used to create the model. The dataset must
     * come from the same ancestor project and location.
     * </pre>
     *
     * <code>string dataset_id = 3;</code>
     *
     * @return The bytes for datasetId.
     */
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource ID of the dataset used to create the model. The dataset must
     * come from the same ancestor project and location.
     * </pre>
     *
     * <code>string dataset_id = 3;</code>
     *
     * @param value The datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource ID of the dataset used to create the model. The dataset must
     * come from the same ancestor project and location.
     * </pre>
     *
     * <code>string dataset_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetId() {
      datasetId_ = getDefaultInstance().getDatasetId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource ID of the dataset used to create the model. The dataset must
     * come from the same ancestor project and location.
     * </pre>
     *
     * <code>string dataset_id = 3;</code>
     *
     * @param value The bytes for datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the model training finished  and can be used for prediction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this model was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int deploymentState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Deployment state of the model. A model can only serve
     * prediction requests after it gets deployed.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
     *
     * @return The enum numeric value on the wire for deploymentState.
     */
    @java.lang.Override
    public int getDeploymentStateValue() {
      return deploymentState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment state of the model. A model can only serve
     * prediction requests after it gets deployed.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
     *
     * @param value The enum numeric value on the wire for deploymentState to set.
     * @return This builder for chaining.
     */
    public Builder setDeploymentStateValue(int value) {
      deploymentState_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment state of the model. A model can only serve
     * prediction requests after it gets deployed.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
     *
     * @return The deploymentState.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.Model.DeploymentState getDeploymentState() {
      com.google.cloud.automl.v1beta1.Model.DeploymentState result =
          com.google.cloud.automl.v1beta1.Model.DeploymentState.forNumber(deploymentState_);
      return result == null
          ? com.google.cloud.automl.v1beta1.Model.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment state of the model. A model can only serve
     * prediction requests after it gets deployed.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
     *
     * @param value The deploymentState to set.
     * @return This builder for chaining.
     */
    public Builder setDeploymentState(com.google.cloud.automl.v1beta1.Model.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      deploymentState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment state of the model. A model can only serve
     * prediction requests after it gets deployed.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.Model.DeploymentState deployment_state = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeploymentState() {
      bitField0_ = (bitField0_ & ~0x00004000);
      deploymentState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.Model)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.Model)
  private static final com.google.cloud.automl.v1beta1.Model DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.Model();
  }

  public static com.google.cloud.automl.v1beta1.Model getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Model> PARSER =
      new com.google.protobuf.AbstractParser<Model>() {
        @java.lang.Override
        public Model parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Model> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Model> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.Model getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
