/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/table_spec.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * A specification of a relational table.
 * The table's schema is represented via its child column specs. It is
 * pre-populated as part of ImportData by schema inference algorithm, the
 * version of which is a required parameter of ImportData InputConfig.
 * Note: While working with a table, at times the schema may be
 * inconsistent with the data in the table (e.g. string in a FLOAT64 column).
 * The consistency validation is done upon creation of a model.
 * Used by:
 *   *   Tables
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.TableSpec}
 */
public final class TableSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.TableSpec)
    TableSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TableSpec.newBuilder() to construct.
  private TableSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TableSpec() {
    name_ = "";
    timeColumnSpecId_ = "";
    inputConfigs_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TableSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.TableSpecOuterClass
        .internal_static_google_cloud_automl_v1beta1_TableSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.TableSpecOuterClass
        .internal_static_google_cloud_automl_v1beta1_TableSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.TableSpec.class,
            com.google.cloud.automl.v1beta1.TableSpec.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the table spec.
   * Form:
   *
   * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the table spec.
   * Form:
   *
   * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_COLUMN_SPEC_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeColumnSpecId_ = "";
  /**
   *
   *
   * <pre>
   * column_spec_id of the time column. Only used if the parent dataset's
   * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
   * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
   * those in between to VALIDATE.
   * Required type: TIMESTAMP.
   * If both this column and ml_use_column are not set, then ML use of all rows
   * will be assigned by AutoML. NOTE: Updates of this field will instantly
   * affect any other users concurrently working with the dataset.
   * </pre>
   *
   * <code>string time_column_spec_id = 2;</code>
   *
   * @return The timeColumnSpecId.
   */
  @java.lang.Override
  public java.lang.String getTimeColumnSpecId() {
    java.lang.Object ref = timeColumnSpecId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeColumnSpecId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * column_spec_id of the time column. Only used if the parent dataset's
   * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
   * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
   * those in between to VALIDATE.
   * Required type: TIMESTAMP.
   * If both this column and ml_use_column are not set, then ML use of all rows
   * will be assigned by AutoML. NOTE: Updates of this field will instantly
   * affect any other users concurrently working with the dataset.
   * </pre>
   *
   * <code>string time_column_spec_id = 2;</code>
   *
   * @return The bytes for timeColumnSpecId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeColumnSpecIdBytes() {
    java.lang.Object ref = timeColumnSpecId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeColumnSpecId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 3;
  private long rowCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of rows (i.e. examples) in the table.
   * </pre>
   *
   * <code>int64 row_count = 3;</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public long getRowCount() {
    return rowCount_;
  }

  public static final int VALID_ROW_COUNT_FIELD_NUMBER = 4;
  private long validRowCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of valid rows (i.e. without values that don't match
   * DataType-s of their columns).
   * </pre>
   *
   * <code>int64 valid_row_count = 4;</code>
   *
   * @return The validRowCount.
   */
  @java.lang.Override
  public long getValidRowCount() {
    return validRowCount_;
  }

  public static final int COLUMN_COUNT_FIELD_NUMBER = 7;
  private long columnCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of columns of the table. That is, the number of
   * child ColumnSpec-s.
   * </pre>
   *
   * <code>int64 column_count = 7;</code>
   *
   * @return The columnCount.
   */
  @java.lang.Override
  public long getColumnCount() {
    return columnCount_;
  }

  public static final int INPUT_CONFIGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.automl.v1beta1.InputConfig> inputConfigs_;
  /**
   *
   *
   * <pre>
   * Output only. Input configs via which data currently residing in the table
   * had been imported.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.automl.v1beta1.InputConfig> getInputConfigsList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Input configs via which data currently residing in the table
   * had been imported.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.automl.v1beta1.InputConfigOrBuilder>
      getInputConfigsOrBuilderList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Input configs via which data currently residing in the table
   * had been imported.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public int getInputConfigsCount() {
    return inputConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Input configs via which data currently residing in the table
   * had been imported.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.InputConfig getInputConfigs(int index) {
    return inputConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Input configs via which data currently residing in the table
   * had been imported.
   * </pre>
   *
   * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.InputConfigOrBuilder getInputConfigsOrBuilder(int index) {
    return inputConfigs_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeColumnSpecId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, timeColumnSpecId_);
    }
    if (rowCount_ != 0L) {
      output.writeInt64(3, rowCount_);
    }
    if (validRowCount_ != 0L) {
      output.writeInt64(4, validRowCount_);
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      output.writeMessage(5, inputConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    if (columnCount_ != 0L) {
      output.writeInt64(7, columnCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeColumnSpecId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, timeColumnSpecId_);
    }
    if (rowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, rowCount_);
    }
    if (validRowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, validRowCount_);
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, inputConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    if (columnCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, columnCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.TableSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.TableSpec other =
        (com.google.cloud.automl.v1beta1.TableSpec) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTimeColumnSpecId().equals(other.getTimeColumnSpecId())) return false;
    if (getRowCount() != other.getRowCount()) return false;
    if (getValidRowCount() != other.getValidRowCount()) return false;
    if (getColumnCount() != other.getColumnCount()) return false;
    if (!getInputConfigsList().equals(other.getInputConfigsList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TIME_COLUMN_SPEC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTimeColumnSpecId().hashCode();
    hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowCount());
    hash = (37 * hash) + VALID_ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValidRowCount());
    hash = (37 * hash) + COLUMN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getColumnCount());
    if (getInputConfigsCount() > 0) {
      hash = (37 * hash) + INPUT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfigsList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.TableSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.TableSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A specification of a relational table.
   * The table's schema is represented via its child column specs. It is
   * pre-populated as part of ImportData by schema inference algorithm, the
   * version of which is a required parameter of ImportData InputConfig.
   * Note: While working with a table, at times the schema may be
   * inconsistent with the data in the table (e.g. string in a FLOAT64 column).
   * The consistency validation is done upon creation of a model.
   * Used by:
   *   *   Tables
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.TableSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.TableSpec)
      com.google.cloud.automl.v1beta1.TableSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.TableSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_TableSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.TableSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_TableSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.TableSpec.class,
              com.google.cloud.automl.v1beta1.TableSpec.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.TableSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      timeColumnSpecId_ = "";
      rowCount_ = 0L;
      validRowCount_ = 0L;
      columnCount_ = 0L;
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
      } else {
        inputConfigs_ = null;
        inputConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.TableSpecOuterClass
          .internal_static_google_cloud_automl_v1beta1_TableSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TableSpec getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.TableSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TableSpec build() {
      com.google.cloud.automl.v1beta1.TableSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TableSpec buildPartial() {
      com.google.cloud.automl.v1beta1.TableSpec result =
          new com.google.cloud.automl.v1beta1.TableSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.automl.v1beta1.TableSpec result) {
      if (inputConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.inputConfigs_ = inputConfigs_;
      } else {
        result.inputConfigs_ = inputConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.TableSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.timeColumnSpecId_ = timeColumnSpecId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rowCount_ = rowCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validRowCount_ = validRowCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.columnCount_ = columnCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.TableSpec) {
        return mergeFrom((com.google.cloud.automl.v1beta1.TableSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.TableSpec other) {
      if (other == com.google.cloud.automl.v1beta1.TableSpec.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTimeColumnSpecId().isEmpty()) {
        timeColumnSpecId_ = other.timeColumnSpecId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getRowCount() != 0L) {
        setRowCount(other.getRowCount());
      }
      if (other.getValidRowCount() != 0L) {
        setValidRowCount(other.getValidRowCount());
      }
      if (other.getColumnCount() != 0L) {
        setColumnCount(other.getColumnCount());
      }
      if (inputConfigsBuilder_ == null) {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigs_.isEmpty()) {
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureInputConfigsIsMutable();
            inputConfigs_.addAll(other.inputConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigsBuilder_.isEmpty()) {
            inputConfigsBuilder_.dispose();
            inputConfigsBuilder_ = null;
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000020);
            inputConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputConfigsFieldBuilder()
                    : null;
          } else {
            inputConfigsBuilder_.addAllMessages(other.inputConfigs_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                timeColumnSpecId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                rowCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                validRowCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.automl.v1beta1.InputConfig m =
                    input.readMessage(
                        com.google.cloud.automl.v1beta1.InputConfig.parser(), extensionRegistry);
                if (inputConfigsBuilder_ == null) {
                  ensureInputConfigsIsMutable();
                  inputConfigs_.add(m);
                } else {
                  inputConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                columnCount_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the table spec.
     * Form:
     *
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the table spec.
     * Form:
     *
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the table spec.
     * Form:
     *
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the table spec.
     * Form:
     *
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the table spec.
     * Form:
     *
     * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object timeColumnSpecId_ = "";
    /**
     *
     *
     * <pre>
     * column_spec_id of the time column. Only used if the parent dataset's
     * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
     * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
     * those in between to VALIDATE.
     * Required type: TIMESTAMP.
     * If both this column and ml_use_column are not set, then ML use of all rows
     * will be assigned by AutoML. NOTE: Updates of this field will instantly
     * affect any other users concurrently working with the dataset.
     * </pre>
     *
     * <code>string time_column_spec_id = 2;</code>
     *
     * @return The timeColumnSpecId.
     */
    public java.lang.String getTimeColumnSpecId() {
      java.lang.Object ref = timeColumnSpecId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeColumnSpecId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the time column. Only used if the parent dataset's
     * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
     * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
     * those in between to VALIDATE.
     * Required type: TIMESTAMP.
     * If both this column and ml_use_column are not set, then ML use of all rows
     * will be assigned by AutoML. NOTE: Updates of this field will instantly
     * affect any other users concurrently working with the dataset.
     * </pre>
     *
     * <code>string time_column_spec_id = 2;</code>
     *
     * @return The bytes for timeColumnSpecId.
     */
    public com.google.protobuf.ByteString getTimeColumnSpecIdBytes() {
      java.lang.Object ref = timeColumnSpecId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeColumnSpecId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the time column. Only used if the parent dataset's
     * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
     * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
     * those in between to VALIDATE.
     * Required type: TIMESTAMP.
     * If both this column and ml_use_column are not set, then ML use of all rows
     * will be assigned by AutoML. NOTE: Updates of this field will instantly
     * affect any other users concurrently working with the dataset.
     * </pre>
     *
     * <code>string time_column_spec_id = 2;</code>
     *
     * @param value The timeColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setTimeColumnSpecId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeColumnSpecId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the time column. Only used if the parent dataset's
     * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
     * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
     * those in between to VALIDATE.
     * Required type: TIMESTAMP.
     * If both this column and ml_use_column are not set, then ML use of all rows
     * will be assigned by AutoML. NOTE: Updates of this field will instantly
     * affect any other users concurrently working with the dataset.
     * </pre>
     *
     * <code>string time_column_spec_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeColumnSpecId() {
      timeColumnSpecId_ = getDefaultInstance().getTimeColumnSpecId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column_spec_id of the time column. Only used if the parent dataset's
     * ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
     * and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
     * those in between to VALIDATE.
     * Required type: TIMESTAMP.
     * If both this column and ml_use_column are not set, then ML use of all rows
     * will be assigned by AutoML. NOTE: Updates of this field will instantly
     * affect any other users concurrently working with the dataset.
     * </pre>
     *
     * <code>string time_column_spec_id = 2;</code>
     *
     * @param value The bytes for timeColumnSpecId to set.
     * @return This builder for chaining.
     */
    public Builder setTimeColumnSpecIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeColumnSpecId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long rowCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of rows (i.e. examples) in the table.
     * </pre>
     *
     * <code>int64 row_count = 3;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public long getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of rows (i.e. examples) in the table.
     * </pre>
     *
     * <code>int64 row_count = 3;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(long value) {

      rowCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of rows (i.e. examples) in the table.
     * </pre>
     *
     * <code>int64 row_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rowCount_ = 0L;
      onChanged();
      return this;
    }

    private long validRowCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of valid rows (i.e. without values that don't match
     * DataType-s of their columns).
     * </pre>
     *
     * <code>int64 valid_row_count = 4;</code>
     *
     * @return The validRowCount.
     */
    @java.lang.Override
    public long getValidRowCount() {
      return validRowCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of valid rows (i.e. without values that don't match
     * DataType-s of their columns).
     * </pre>
     *
     * <code>int64 valid_row_count = 4;</code>
     *
     * @param value The validRowCount to set.
     * @return This builder for chaining.
     */
    public Builder setValidRowCount(long value) {

      validRowCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of valid rows (i.e. without values that don't match
     * DataType-s of their columns).
     * </pre>
     *
     * <code>int64 valid_row_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidRowCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      validRowCount_ = 0L;
      onChanged();
      return this;
    }

    private long columnCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of columns of the table. That is, the number of
     * child ColumnSpec-s.
     * </pre>
     *
     * <code>int64 column_count = 7;</code>
     *
     * @return The columnCount.
     */
    @java.lang.Override
    public long getColumnCount() {
      return columnCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of columns of the table. That is, the number of
     * child ColumnSpec-s.
     * </pre>
     *
     * <code>int64 column_count = 7;</code>
     *
     * @param value The columnCount to set.
     * @return This builder for chaining.
     */
    public Builder setColumnCount(long value) {

      columnCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of columns of the table. That is, the number of
     * child ColumnSpec-s.
     * </pre>
     *
     * <code>int64 column_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      columnCount_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.automl.v1beta1.InputConfig> inputConfigs_ =
        java.util.Collections.emptyList();

    private void ensureInputConfigsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        inputConfigs_ =
            new java.util.ArrayList<com.google.cloud.automl.v1beta1.InputConfig>(inputConfigs_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.InputConfig,
            com.google.cloud.automl.v1beta1.InputConfig.Builder,
            com.google.cloud.automl.v1beta1.InputConfigOrBuilder>
        inputConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.InputConfig> getInputConfigsList() {
      if (inputConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      } else {
        return inputConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public int getInputConfigsCount() {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.size();
      } else {
        return inputConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.automl.v1beta1.InputConfig getInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder setInputConfigs(int index, com.google.cloud.automl.v1beta1.InputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder setInputConfigs(
        int index, com.google.cloud.automl.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(com.google.cloud.automl.v1beta1.InputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(int index, com.google.cloud.automl.v1beta1.InputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(
        com.google.cloud.automl.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(
        int index, com.google.cloud.automl.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addAllInputConfigs(
        java.lang.Iterable<? extends com.google.cloud.automl.v1beta1.InputConfig> values) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputConfigs_);
        onChanged();
      } else {
        inputConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder clearInputConfigs() {
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        inputConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder removeInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.remove(index);
        onChanged();
      } else {
        inputConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.automl.v1beta1.InputConfig.Builder getInputConfigsBuilder(int index) {
      return getInputConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.automl.v1beta1.InputConfigOrBuilder getInputConfigsOrBuilder(
        int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.automl.v1beta1.InputConfigOrBuilder>
        getInputConfigsOrBuilderList() {
      if (inputConfigsBuilder_ != null) {
        return inputConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.automl.v1beta1.InputConfig.Builder addInputConfigsBuilder() {
      return getInputConfigsFieldBuilder()
          .addBuilder(com.google.cloud.automl.v1beta1.InputConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.automl.v1beta1.InputConfig.Builder addInputConfigsBuilder(int index) {
      return getInputConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.automl.v1beta1.InputConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Input configs via which data currently residing in the table
     * had been imported.
     * </pre>
     *
     * <code>repeated .google.cloud.automl.v1beta1.InputConfig input_configs = 5;</code>
     */
    public java.util.List<com.google.cloud.automl.v1beta1.InputConfig.Builder>
        getInputConfigsBuilderList() {
      return getInputConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.automl.v1beta1.InputConfig,
            com.google.cloud.automl.v1beta1.InputConfig.Builder,
            com.google.cloud.automl.v1beta1.InputConfigOrBuilder>
        getInputConfigsFieldBuilder() {
      if (inputConfigsBuilder_ == null) {
        inputConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.automl.v1beta1.InputConfig,
                com.google.cloud.automl.v1beta1.InputConfig.Builder,
                com.google.cloud.automl.v1beta1.InputConfigOrBuilder>(
                inputConfigs_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        inputConfigs_ = null;
      }
      return inputConfigsBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.TableSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.TableSpec)
  private static final com.google.cloud.automl.v1beta1.TableSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.TableSpec();
  }

  public static com.google.cloud.automl.v1beta1.TableSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TableSpec> PARSER =
      new com.google.protobuf.AbstractParser<TableSpec>() {
        @java.lang.Override
        public TableSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TableSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TableSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TableSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
