/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/automl/v1beta1/data_types.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.automl.v1beta1;

/**
 *
 *
 * <pre>
 * Indicated the type of data that can be stored in a structured data entity
 * (e.g. a table).
 * </pre>
 *
 * Protobuf type {@code google.cloud.automl.v1beta1.DataType}
 */
public final class DataType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.automl.v1beta1.DataType)
    DataTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataType.newBuilder() to construct.
  private DataType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataType() {
    typeCode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataType();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.automl.v1beta1.DataTypes
        .internal_static_google_cloud_automl_v1beta1_DataType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.automl.v1beta1.DataTypes
        .internal_static_google_cloud_automl_v1beta1_DataType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.automl.v1beta1.DataType.class,
            com.google.cloud.automl.v1beta1.DataType.Builder.class);
  }

  private int detailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LIST_ELEMENT_TYPE(2),
    STRUCT_TYPE(3),
    TIME_FORMAT(5),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 2:
          return LIST_ELEMENT_TYPE;
        case 3:
          return STRUCT_TYPE;
        case 5:
          return TIME_FORMAT;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int LIST_ELEMENT_TYPE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
   * then `list_element_type` is the type of the elements.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
   *
   * @return Whether the listElementType field is set.
   */
  @java.lang.Override
  public boolean hasListElementType() {
    return detailsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
   * then `list_element_type` is the type of the elements.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
   *
   * @return The listElementType.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DataType getListElementType() {
    if (detailsCase_ == 2) {
      return (com.google.cloud.automl.v1beta1.DataType) details_;
    }
    return com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
   * then `list_element_type` is the type of the elements.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DataTypeOrBuilder getListElementTypeOrBuilder() {
    if (detailsCase_ == 2) {
      return (com.google.cloud.automl.v1beta1.DataType) details_;
    }
    return com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
  }

  public static final int STRUCT_TYPE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
   * provides type information for the struct's fields.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
   *
   * @return Whether the structType field is set.
   */
  @java.lang.Override
  public boolean hasStructType() {
    return detailsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
   * provides type information for the struct's fields.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
   *
   * @return The structType.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.StructType getStructType() {
    if (detailsCase_ == 3) {
      return (com.google.cloud.automl.v1beta1.StructType) details_;
    }
    return com.google.cloud.automl.v1beta1.StructType.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
   * provides type information for the struct's fields.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.StructTypeOrBuilder getStructTypeOrBuilder() {
    if (detailsCase_ == 3) {
      return (com.google.cloud.automl.v1beta1.StructType) details_;
    }
    return com.google.cloud.automl.v1beta1.StructType.getDefaultInstance();
  }

  public static final int TIME_FORMAT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
   * then `time_format` provides the format in which that time field is
   * expressed. The time_format must either be one of:
   * * `UNIX_SECONDS`
   * * `UNIX_MILLISECONDS`
   * * `UNIX_MICROSECONDS`
   * * `UNIX_NANOSECONDS`
   * (for respectively number of seconds, milliseconds, microseconds and
   * nanoseconds since start of the Unix epoch);
   * or be written in `strftime` syntax. If time_format is not set, then the
   * default format as described on the type_code is used.
   * </pre>
   *
   * <code>string time_format = 5;</code>
   *
   * @return Whether the timeFormat field is set.
   */
  public boolean hasTimeFormat() {
    return detailsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
   * then `time_format` provides the format in which that time field is
   * expressed. The time_format must either be one of:
   * * `UNIX_SECONDS`
   * * `UNIX_MILLISECONDS`
   * * `UNIX_MICROSECONDS`
   * * `UNIX_NANOSECONDS`
   * (for respectively number of seconds, milliseconds, microseconds and
   * nanoseconds since start of the Unix epoch);
   * or be written in `strftime` syntax. If time_format is not set, then the
   * default format as described on the type_code is used.
   * </pre>
   *
   * <code>string time_format = 5;</code>
   *
   * @return The timeFormat.
   */
  public java.lang.String getTimeFormat() {
    java.lang.Object ref = "";
    if (detailsCase_ == 5) {
      ref = details_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (detailsCase_ == 5) {
        details_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
   * then `time_format` provides the format in which that time field is
   * expressed. The time_format must either be one of:
   * * `UNIX_SECONDS`
   * * `UNIX_MILLISECONDS`
   * * `UNIX_MICROSECONDS`
   * * `UNIX_NANOSECONDS`
   * (for respectively number of seconds, milliseconds, microseconds and
   * nanoseconds since start of the Unix epoch);
   * or be written in `strftime` syntax. If time_format is not set, then the
   * default format as described on the type_code is used.
   * </pre>
   *
   * <code>string time_format = 5;</code>
   *
   * @return The bytes for timeFormat.
   */
  public com.google.protobuf.ByteString getTimeFormatBytes() {
    java.lang.Object ref = "";
    if (detailsCase_ == 5) {
      ref = details_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (detailsCase_ == 5) {
        details_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_CODE_FIELD_NUMBER = 1;
  private int typeCode_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
   *
   * @return The enum numeric value on the wire for typeCode.
   */
  @java.lang.Override
  public int getTypeCodeValue() {
    return typeCode_;
  }
  /**
   *
   *
   * <pre>
   * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
   * </pre>
   *
   * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
   *
   * @return The typeCode.
   */
  @java.lang.Override
  public com.google.cloud.automl.v1beta1.TypeCode getTypeCode() {
    com.google.cloud.automl.v1beta1.TypeCode result =
        com.google.cloud.automl.v1beta1.TypeCode.forNumber(typeCode_);
    return result == null ? com.google.cloud.automl.v1beta1.TypeCode.UNRECOGNIZED : result;
  }

  public static final int NULLABLE_FIELD_NUMBER = 4;
  private boolean nullable_ = false;
  /**
   *
   *
   * <pre>
   * If true, this DataType can also be `NULL`. In .CSV files `NULL` value is
   * expressed as an empty string.
   * </pre>
   *
   * <code>bool nullable = 4;</code>
   *
   * @return The nullable.
   */
  @java.lang.Override
  public boolean getNullable() {
    return nullable_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCode_ != com.google.cloud.automl.v1beta1.TypeCode.TYPE_CODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, typeCode_);
    }
    if (detailsCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.automl.v1beta1.DataType) details_);
    }
    if (detailsCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.automl.v1beta1.StructType) details_);
    }
    if (nullable_ != false) {
      output.writeBool(4, nullable_);
    }
    if (detailsCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, details_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCode_ != com.google.cloud.automl.v1beta1.TypeCode.TYPE_CODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, typeCode_);
    }
    if (detailsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.automl.v1beta1.DataType) details_);
    }
    if (detailsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.automl.v1beta1.StructType) details_);
    }
    if (nullable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, nullable_);
    }
    if (detailsCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, details_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.automl.v1beta1.DataType)) {
      return super.equals(obj);
    }
    com.google.cloud.automl.v1beta1.DataType other = (com.google.cloud.automl.v1beta1.DataType) obj;

    if (typeCode_ != other.typeCode_) return false;
    if (getNullable() != other.getNullable()) return false;
    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 2:
        if (!getListElementType().equals(other.getListElementType())) return false;
        break;
      case 3:
        if (!getStructType().equals(other.getStructType())) return false;
        break;
      case 5:
        if (!getTimeFormat().equals(other.getTimeFormat())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + typeCode_;
    hash = (37 * hash) + NULLABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNullable());
    switch (detailsCase_) {
      case 2:
        hash = (37 * hash) + LIST_ELEMENT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getListElementType().hashCode();
        break;
      case 3:
        hash = (37 * hash) + STRUCT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getStructType().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TIME_FORMAT_FIELD_NUMBER;
        hash = (53 * hash) + getTimeFormat().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.automl.v1beta1.DataType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.automl.v1beta1.DataType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Indicated the type of data that can be stored in a structured data entity
   * (e.g. a table).
   * </pre>
   *
   * Protobuf type {@code google.cloud.automl.v1beta1.DataType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.automl.v1beta1.DataType)
      com.google.cloud.automl.v1beta1.DataTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.automl.v1beta1.DataTypes
          .internal_static_google_cloud_automl_v1beta1_DataType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.automl.v1beta1.DataTypes
          .internal_static_google_cloud_automl_v1beta1_DataType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.automl.v1beta1.DataType.class,
              com.google.cloud.automl.v1beta1.DataType.Builder.class);
    }

    // Construct using com.google.cloud.automl.v1beta1.DataType.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (listElementTypeBuilder_ != null) {
        listElementTypeBuilder_.clear();
      }
      if (structTypeBuilder_ != null) {
        structTypeBuilder_.clear();
      }
      typeCode_ = 0;
      nullable_ = false;
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.automl.v1beta1.DataTypes
          .internal_static_google_cloud_automl_v1beta1_DataType_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DataType getDefaultInstanceForType() {
      return com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DataType build() {
      com.google.cloud.automl.v1beta1.DataType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DataType buildPartial() {
      com.google.cloud.automl.v1beta1.DataType result =
          new com.google.cloud.automl.v1beta1.DataType(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.automl.v1beta1.DataType result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.typeCode_ = typeCode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nullable_ = nullable_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.automl.v1beta1.DataType result) {
      result.detailsCase_ = detailsCase_;
      result.details_ = this.details_;
      if (detailsCase_ == 2 && listElementTypeBuilder_ != null) {
        result.details_ = listElementTypeBuilder_.build();
      }
      if (detailsCase_ == 3 && structTypeBuilder_ != null) {
        result.details_ = structTypeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.automl.v1beta1.DataType) {
        return mergeFrom((com.google.cloud.automl.v1beta1.DataType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.automl.v1beta1.DataType other) {
      if (other == com.google.cloud.automl.v1beta1.DataType.getDefaultInstance()) return this;
      if (other.typeCode_ != 0) {
        setTypeCodeValue(other.getTypeCodeValue());
      }
      if (other.getNullable() != false) {
        setNullable(other.getNullable());
      }
      switch (other.getDetailsCase()) {
        case LIST_ELEMENT_TYPE:
          {
            mergeListElementType(other.getListElementType());
            break;
          }
        case STRUCT_TYPE:
          {
            mergeStructType(other.getStructType());
            break;
          }
        case TIME_FORMAT:
          {
            detailsCase_ = 5;
            details_ = other.details_;
            onChanged();
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                typeCode_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getListElementTypeFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStructTypeFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                nullable_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                detailsCase_ = 5;
                details_ = s;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DataType,
            com.google.cloud.automl.v1beta1.DataType.Builder,
            com.google.cloud.automl.v1beta1.DataTypeOrBuilder>
        listElementTypeBuilder_;
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     *
     * @return Whether the listElementType field is set.
     */
    @java.lang.Override
    public boolean hasListElementType() {
      return detailsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     *
     * @return The listElementType.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DataType getListElementType() {
      if (listElementTypeBuilder_ == null) {
        if (detailsCase_ == 2) {
          return (com.google.cloud.automl.v1beta1.DataType) details_;
        }
        return com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
      } else {
        if (detailsCase_ == 2) {
          return listElementTypeBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    public Builder setListElementType(com.google.cloud.automl.v1beta1.DataType value) {
      if (listElementTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        listElementTypeBuilder_.setMessage(value);
      }
      detailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    public Builder setListElementType(
        com.google.cloud.automl.v1beta1.DataType.Builder builderForValue) {
      if (listElementTypeBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        listElementTypeBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    public Builder mergeListElementType(com.google.cloud.automl.v1beta1.DataType value) {
      if (listElementTypeBuilder_ == null) {
        if (detailsCase_ == 2
            && details_ != com.google.cloud.automl.v1beta1.DataType.getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.DataType.newBuilder(
                      (com.google.cloud.automl.v1beta1.DataType) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 2) {
          listElementTypeBuilder_.mergeFrom(value);
        } else {
          listElementTypeBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    public Builder clearListElementType() {
      if (listElementTypeBuilder_ == null) {
        if (detailsCase_ == 2) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 2) {
          detailsCase_ = 0;
          details_ = null;
        }
        listElementTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    public com.google.cloud.automl.v1beta1.DataType.Builder getListElementTypeBuilder() {
      return getListElementTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.DataTypeOrBuilder getListElementTypeOrBuilder() {
      if ((detailsCase_ == 2) && (listElementTypeBuilder_ != null)) {
        return listElementTypeBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 2) {
          return (com.google.cloud.automl.v1beta1.DataType) details_;
        }
        return com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [ARRAY][google.cloud.automl.v1beta1.TypeCode.ARRAY],
     * then `list_element_type` is the type of the elements.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.DataType list_element_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.DataType,
            com.google.cloud.automl.v1beta1.DataType.Builder,
            com.google.cloud.automl.v1beta1.DataTypeOrBuilder>
        getListElementTypeFieldBuilder() {
      if (listElementTypeBuilder_ == null) {
        if (!(detailsCase_ == 2)) {
          details_ = com.google.cloud.automl.v1beta1.DataType.getDefaultInstance();
        }
        listElementTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.DataType,
                com.google.cloud.automl.v1beta1.DataType.Builder,
                com.google.cloud.automl.v1beta1.DataTypeOrBuilder>(
                (com.google.cloud.automl.v1beta1.DataType) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 2;
      onChanged();
      return listElementTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.StructType,
            com.google.cloud.automl.v1beta1.StructType.Builder,
            com.google.cloud.automl.v1beta1.StructTypeOrBuilder>
        structTypeBuilder_;
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     *
     * @return Whether the structType field is set.
     */
    @java.lang.Override
    public boolean hasStructType() {
      return detailsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     *
     * @return The structType.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.StructType getStructType() {
      if (structTypeBuilder_ == null) {
        if (detailsCase_ == 3) {
          return (com.google.cloud.automl.v1beta1.StructType) details_;
        }
        return com.google.cloud.automl.v1beta1.StructType.getDefaultInstance();
      } else {
        if (detailsCase_ == 3) {
          return structTypeBuilder_.getMessage();
        }
        return com.google.cloud.automl.v1beta1.StructType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    public Builder setStructType(com.google.cloud.automl.v1beta1.StructType value) {
      if (structTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        structTypeBuilder_.setMessage(value);
      }
      detailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    public Builder setStructType(
        com.google.cloud.automl.v1beta1.StructType.Builder builderForValue) {
      if (structTypeBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        structTypeBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    public Builder mergeStructType(com.google.cloud.automl.v1beta1.StructType value) {
      if (structTypeBuilder_ == null) {
        if (detailsCase_ == 3
            && details_ != com.google.cloud.automl.v1beta1.StructType.getDefaultInstance()) {
          details_ =
              com.google.cloud.automl.v1beta1.StructType.newBuilder(
                      (com.google.cloud.automl.v1beta1.StructType) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 3) {
          structTypeBuilder_.mergeFrom(value);
        } else {
          structTypeBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    public Builder clearStructType() {
      if (structTypeBuilder_ == null) {
        if (detailsCase_ == 3) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 3) {
          detailsCase_ = 0;
          details_ = null;
        }
        structTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    public com.google.cloud.automl.v1beta1.StructType.Builder getStructTypeBuilder() {
      return getStructTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.StructTypeOrBuilder getStructTypeOrBuilder() {
      if ((detailsCase_ == 3) && (structTypeBuilder_ != null)) {
        return structTypeBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 3) {
          return (com.google.cloud.automl.v1beta1.StructType) details_;
        }
        return com.google.cloud.automl.v1beta1.StructType.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [STRUCT][google.cloud.automl.v1beta1.TypeCode.STRUCT], then `struct_type`
     * provides type information for the struct's fields.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.StructType struct_type = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.automl.v1beta1.StructType,
            com.google.cloud.automl.v1beta1.StructType.Builder,
            com.google.cloud.automl.v1beta1.StructTypeOrBuilder>
        getStructTypeFieldBuilder() {
      if (structTypeBuilder_ == null) {
        if (!(detailsCase_ == 3)) {
          details_ = com.google.cloud.automl.v1beta1.StructType.getDefaultInstance();
        }
        structTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.automl.v1beta1.StructType,
                com.google.cloud.automl.v1beta1.StructType.Builder,
                com.google.cloud.automl.v1beta1.StructTypeOrBuilder>(
                (com.google.cloud.automl.v1beta1.StructType) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 3;
      onChanged();
      return structTypeBuilder_;
    }

    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
     * then `time_format` provides the format in which that time field is
     * expressed. The time_format must either be one of:
     * * `UNIX_SECONDS`
     * * `UNIX_MILLISECONDS`
     * * `UNIX_MICROSECONDS`
     * * `UNIX_NANOSECONDS`
     * (for respectively number of seconds, milliseconds, microseconds and
     * nanoseconds since start of the Unix epoch);
     * or be written in `strftime` syntax. If time_format is not set, then the
     * default format as described on the type_code is used.
     * </pre>
     *
     * <code>string time_format = 5;</code>
     *
     * @return Whether the timeFormat field is set.
     */
    @java.lang.Override
    public boolean hasTimeFormat() {
      return detailsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
     * then `time_format` provides the format in which that time field is
     * expressed. The time_format must either be one of:
     * * `UNIX_SECONDS`
     * * `UNIX_MILLISECONDS`
     * * `UNIX_MICROSECONDS`
     * * `UNIX_NANOSECONDS`
     * (for respectively number of seconds, milliseconds, microseconds and
     * nanoseconds since start of the Unix epoch);
     * or be written in `strftime` syntax. If time_format is not set, then the
     * default format as described on the type_code is used.
     * </pre>
     *
     * <code>string time_format = 5;</code>
     *
     * @return The timeFormat.
     */
    @java.lang.Override
    public java.lang.String getTimeFormat() {
      java.lang.Object ref = "";
      if (detailsCase_ == 5) {
        ref = details_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (detailsCase_ == 5) {
          details_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
     * then `time_format` provides the format in which that time field is
     * expressed. The time_format must either be one of:
     * * `UNIX_SECONDS`
     * * `UNIX_MILLISECONDS`
     * * `UNIX_MICROSECONDS`
     * * `UNIX_NANOSECONDS`
     * (for respectively number of seconds, milliseconds, microseconds and
     * nanoseconds since start of the Unix epoch);
     * or be written in `strftime` syntax. If time_format is not set, then the
     * default format as described on the type_code is used.
     * </pre>
     *
     * <code>string time_format = 5;</code>
     *
     * @return The bytes for timeFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTimeFormatBytes() {
      java.lang.Object ref = "";
      if (detailsCase_ == 5) {
        ref = details_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (detailsCase_ == 5) {
          details_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
     * then `time_format` provides the format in which that time field is
     * expressed. The time_format must either be one of:
     * * `UNIX_SECONDS`
     * * `UNIX_MILLISECONDS`
     * * `UNIX_MICROSECONDS`
     * * `UNIX_NANOSECONDS`
     * (for respectively number of seconds, milliseconds, microseconds and
     * nanoseconds since start of the Unix epoch);
     * or be written in `strftime` syntax. If time_format is not set, then the
     * default format as described on the type_code is used.
     * </pre>
     *
     * <code>string time_format = 5;</code>
     *
     * @param value The timeFormat to set.
     * @return This builder for chaining.
     */
    public Builder setTimeFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      detailsCase_ = 5;
      details_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
     * then `time_format` provides the format in which that time field is
     * expressed. The time_format must either be one of:
     * * `UNIX_SECONDS`
     * * `UNIX_MILLISECONDS`
     * * `UNIX_MICROSECONDS`
     * * `UNIX_NANOSECONDS`
     * (for respectively number of seconds, milliseconds, microseconds and
     * nanoseconds since start of the Unix epoch);
     * or be written in `strftime` syntax. If time_format is not set, then the
     * default format as described on the type_code is used.
     * </pre>
     *
     * <code>string time_format = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeFormat() {
      if (detailsCase_ == 5) {
        detailsCase_ = 0;
        details_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [type_code][google.cloud.automl.v1beta1.DataType.type_code] == [TIMESTAMP][google.cloud.automl.v1beta1.TypeCode.TIMESTAMP]
     * then `time_format` provides the format in which that time field is
     * expressed. The time_format must either be one of:
     * * `UNIX_SECONDS`
     * * `UNIX_MILLISECONDS`
     * * `UNIX_MICROSECONDS`
     * * `UNIX_NANOSECONDS`
     * (for respectively number of seconds, milliseconds, microseconds and
     * nanoseconds since start of the Unix epoch);
     * or be written in `strftime` syntax. If time_format is not set, then the
     * default format as described on the type_code is used.
     * </pre>
     *
     * <code>string time_format = 5;</code>
     *
     * @param value The bytes for timeFormat to set.
     * @return This builder for chaining.
     */
    public Builder setTimeFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      detailsCase_ = 5;
      details_ = value;
      onChanged();
      return this;
    }

    private int typeCode_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
     *
     * @return The enum numeric value on the wire for typeCode.
     */
    @java.lang.Override
    public int getTypeCodeValue() {
      return typeCode_;
    }
    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
     *
     * @param value The enum numeric value on the wire for typeCode to set.
     * @return This builder for chaining.
     */
    public Builder setTypeCodeValue(int value) {
      typeCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
     *
     * @return The typeCode.
     */
    @java.lang.Override
    public com.google.cloud.automl.v1beta1.TypeCode getTypeCode() {
      com.google.cloud.automl.v1beta1.TypeCode result =
          com.google.cloud.automl.v1beta1.TypeCode.forNumber(typeCode_);
      return result == null ? com.google.cloud.automl.v1beta1.TypeCode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
     *
     * @param value The typeCode to set.
     * @return This builder for chaining.
     */
    public Builder setTypeCode(com.google.cloud.automl.v1beta1.TypeCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      typeCode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.cloud.automl.v1beta1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.cloud.automl.v1beta1.TypeCode type_code = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypeCode() {
      bitField0_ = (bitField0_ & ~0x00000008);
      typeCode_ = 0;
      onChanged();
      return this;
    }

    private boolean nullable_;
    /**
     *
     *
     * <pre>
     * If true, this DataType can also be `NULL`. In .CSV files `NULL` value is
     * expressed as an empty string.
     * </pre>
     *
     * <code>bool nullable = 4;</code>
     *
     * @return The nullable.
     */
    @java.lang.Override
    public boolean getNullable() {
      return nullable_;
    }
    /**
     *
     *
     * <pre>
     * If true, this DataType can also be `NULL`. In .CSV files `NULL` value is
     * expressed as an empty string.
     * </pre>
     *
     * <code>bool nullable = 4;</code>
     *
     * @param value The nullable to set.
     * @return This builder for chaining.
     */
    public Builder setNullable(boolean value) {

      nullable_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, this DataType can also be `NULL`. In .CSV files `NULL` value is
     * expressed as an empty string.
     * </pre>
     *
     * <code>bool nullable = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullable() {
      bitField0_ = (bitField0_ & ~0x00000010);
      nullable_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.automl.v1beta1.DataType)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.automl.v1beta1.DataType)
  private static final com.google.cloud.automl.v1beta1.DataType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.automl.v1beta1.DataType();
  }

  public static com.google.cloud.automl.v1beta1.DataType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataType> PARSER =
      new com.google.protobuf.AbstractParser<DataType>() {
        @java.lang.Override
        public DataType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.automl.v1beta1.DataType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
